/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D.Screens;

import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Audio.Source;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.ScreenAdapters.MovieScreen;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Tile;
import ru.m210projects.Duke3D.Globals;
import ru.m210projects.Duke3D.Sounds;
import ru.m210projects.Duke3D.Types.AnimFile;

public class AnmScreen
extends MovieScreen {
    private int lastanimhack;
    private int bonuscnt = 0;
    private String name;
    private Source scenevoice;
    private int[] scenevoices = new int[]{289, 290, 291, 292, 293};

    public AnmScreen(BuildGame game) {
        super(game, Globals.TILE_ANIM);
        this.nFlags |= 4;
    }

    public boolean init(String fn, int t) {
        if (this.isInited()) {
            return false;
        }
        if (!this.open(fn)) {
            return false;
        }
        this.lastanimhack = t;
        this.name = fn;
        return true;
    }

    @Override
    protected boolean play() {
        if (this.mvfil != null) {
            if (this.LastMS == -1L) {
                this.LastMS = this.engine.getticks();
            }
            Tile pic = this.engine.getTile(this.TILE_MOVIE);
            long ms = this.engine.getticks();
            long dt = ms - this.LastMS;
            this.mvtime += dt;
            float tick = this.mvfil.getRate();
            if ((float)this.mvtime >= tick) {
                if (this.frame < this.mvfil.getFrames()) {
                    pic.data = this.DoDrawFrame(this.frame);
                    this.engine.invalidatetile(this.TILE_MOVIE, 0, -1);
                    ++this.frame;
                } else if (!this.name.equals("radlogo.anm")) {
                    return false;
                }
                this.mvtime = (long)((float)this.mvtime - tick);
            }
            this.LastMS = ms;
            if (pic.getWidth() <= 0) {
                return false;
            }
            if (pic.data != null) {
                this.engine.rotatesprite(this.nPosX << 16, this.nPosY << 16, this.nScale, 512, this.TILE_MOVIE, 0, 0, this.nFlags, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            }
            return true;
        }
        return false;
    }

    @Override
    protected MovieScreen.MovieFile GetFile(String file) {
        byte[] animbuf = BuildGdx.cache.getBytes(file, 0);
        if (animbuf == null) {
            return null;
        }
        return new AnimFile(animbuf);
    }

    @Override
    protected void StopAllSounds() {
        Sounds.StopAllSounds();
        Sounds.sndStopMusic();
    }

    @Override
    protected byte[] DoDrawFrame(int frame) {
        if (this.lastanimhack == 8) {
            this.endanimvol41(frame);
        } else if (this.lastanimhack == 10) {
            this.endanimvol42(frame);
        } else if (this.lastanimhack == 11) {
            this.endanimvol43(frame);
        } else if (this.lastanimhack == 9) {
            this.intro42animsounds(frame);
        } else if (this.lastanimhack == 7) {
            this.intro4animsounds(frame);
        } else if (this.lastanimhack == 6) {
            this.first4animsounds(frame);
        } else if (this.lastanimhack == 5) {
            this.logoanimsounds(frame);
        } else if (this.lastanimhack < 4) {
            this.endanimsounds(frame);
        }
        return this.mvfil.getFrame(frame);
    }

    @Override
    protected BuildFont GetFont() {
        return this.game.getFont(0);
    }

    @Override
    protected void callback() {
        if (!this.checkAnm()) {
            super.callback();
        }
    }

    @Override
    protected void DrawEscText(BuildFont font, int pal) {
        int shade = 16 + Pragmas.mulscale(16L, Engine.sintable[20 * Engine.totalclock & 0x7FF], 16);
        font.drawText(160, 5, "Press ESC to skip", shade, pal, BuildFont.TextAlign.Center, 2, true);
    }

    private boolean checkAnm() {
        if (this.name.equals("vol41a.anm")) {
            this.close();
            this.init("vol42a.anm", 7);
            return true;
        }
        if (this.name.equals("vol42a.anm")) {
            this.close();
            this.init("vol43a.anm", 9);
            return true;
        }
        if (this.name.equals("vol4e1.anm")) {
            this.close();
            this.init("vol4e2.anm", 10);
            return true;
        }
        if (this.name.equals("vol4e2.anm")) {
            this.close();
            this.init("vol4e3.anm", 11);
            return true;
        }
        if (this.name.equals("radlogo.anm")) {
            if (!(this.bonuscnt < 0 || this.bonuscnt >= this.scenevoices.length || this.scenevoice != null && this.scenevoice.isActive())) {
                this.scenevoice = Sounds.sound(this.scenevoices[this.bonuscnt]);
                ++this.bonuscnt;
            }
            return true;
        }
        return this.name.equals("duketeam.anm");
    }

    private void endanimsounds(int fr) {
        block0 : switch (Globals.ud.volume_number) {
            case 0: {
                break;
            }
            case 1: {
                switch (fr) {
                    case 1: {
                        Sounds.sound(91);
                        break;
                    }
                    case 26: {
                        Sounds.sound(295);
                        break;
                    }
                    case 36: {
                        Sounds.sound(296);
                        break;
                    }
                    case 54: {
                        Sounds.sound(158);
                        break;
                    }
                    case 62: {
                        Sounds.sound(297);
                        break;
                    }
                    case 75: {
                        Sounds.sound(298);
                        break;
                    }
                    case 81: {
                        Sounds.sound(299);
                        break;
                    }
                    case 115: {
                        Sounds.sound(300);
                        break;
                    }
                    case 124: {
                        Sounds.sound(301);
                    }
                }
                break;
            }
            case 2: {
                switch (fr) {
                    case 1: {
                        Sounds.sound(308);
                        break block0;
                    }
                    case 98: {
                        Sounds.sound(38);
                        break block0;
                    }
                    case 102: {
                        Sounds.sound(158);
                        Sounds.sound(69);
                        break block0;
                    }
                    case 124: {
                        Sounds.sound(30);
                        break block0;
                    }
                    case 134: {
                        Sounds.sound(29);
                        break block0;
                    }
                    case 158: {
                        Sounds.sound(14);
                    }
                }
            }
        }
    }

    private void logoanimsounds(int fr) {
        switch (fr) {
            case 1: {
                Sounds.sound(244);
                break;
            }
            case 19: {
                Sounds.sound(14);
            }
        }
    }

    private void intro4animsounds(int fr) {
        switch (fr) {
            case 1: {
                Sounds.sound(392);
                break;
            }
            case 12: 
            case 34: {
                Sounds.sound(21);
                break;
            }
            case 18: {
                Sounds.sound(367);
            }
        }
    }

    private void first4animsounds(int fr) {
        switch (fr) {
            case 1: {
                Sounds.sound(363);
                break;
            }
            case 12: {
                Sounds.sound(364);
                break;
            }
            case 7: {
                Sounds.sound(365);
                break;
            }
            case 26: {
                Sounds.sound(366);
            }
        }
    }

    private void intro42animsounds(int fr) {
        switch (fr) {
            case 10: {
                Sounds.sound(368);
            }
        }
    }

    private void endanimvol41(int fr) {
        switch (fr) {
            case 3: {
                Sounds.sound(48);
                break;
            }
            case 35: {
                Sounds.sound(384);
            }
        }
    }

    private void endanimvol42(int fr) {
        switch (fr) {
            case 11: {
                Sounds.sound(48);
                break;
            }
            case 20: {
                Sounds.sound(384);
                break;
            }
            case 39: {
                Sounds.sound(385);
                break;
            }
            case 50: {
                BuildGdx.audio.getSound().stopAllSounds();
            }
        }
    }

    private void endanimvol43(int fr) {
        switch (fr) {
            case 1: {
                Sounds.sound(370);
                break;
            }
            case 40: {
                Sounds.sound(384);
                Sounds.sound(48);
                break;
            }
            case 50: {
                Sounds.sound(393);
            }
        }
    }
}

