/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP.Factory;

import com.badlogic.gdx.math.Vector2;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Input.BuildControllers;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildControls;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Settings.BuildConfig;
import ru.m210projects.LSP.Config;
import ru.m210projects.LSP.Globals;
import ru.m210projects.LSP.Main;
import ru.m210projects.LSP.Types.Input;

public class LSPInput
extends BuildControls {
    private int vel;
    private int svel;
    private float horiz;
    private float angvel;
    private boolean crouch;
    private int lPlayerXVel;
    private int lPlayerYVel;

    public LSPInput(BuildConfig cfg, BuildControllers gpmanager) {
        super(cfg, gpmanager);
    }

    public void reset() {
        this.lPlayerYVel = 0;
        this.lPlayerXVel = 0;
    }

    @Override
    public float getScaleX() {
        return 1.0f;
    }

    @Override
    public void ctrlGetInput(BuildNet.NetInput input) {
        double yvel;
        float k;
        boolean running;
        Input gInput = (Input)input;
        if (Main.game.menu.gShowMenu || Console.IsShown()) {
            return;
        }
        gInput.Reset();
        this.vel = 0;
        this.svel = 0;
        this.angvel = 0.0f;
        this.horiz = 0.0f;
        gInput.bits = gInput.bits | (this.ctrlGetInputKey(BuildConfig.GameKeys.Jump, true) ? 1 : 0);
        gInput.bits = gInput.bits | (this.ctrlGetInputKey(BuildConfig.GameKeys.Crouch, false) ? 2 : 0);
        gInput.bits = gInput.bits | (this.ctrlGetInputKey(BuildConfig.GameKeys.Look_Up, false) ? 4 : 0);
        gInput.bits = gInput.bits | (this.ctrlGetInputKey(BuildConfig.GameKeys.Look_Down, false) ? 8 : 0);
        gInput.bits = gInput.bits | (this.ctrlGetInputKey(BuildConfig.GameKeys.Run, false) ? 256 : 0);
        gInput.bits = gInput.bits | (this.ctrlGetInputKey(BuildConfig.GameKeys.Open, true) ? 1024 : 0);
        gInput.bits = gInput.bits | (this.ctrlGetInputKey(BuildConfig.GameKeys.Weapon_Fire, false) ? 2048 : 0);
        gInput.bits = gInput.bits | (this.ctrlGetInputKey(Config.LSPKeys.Weapon_1, true) ? 16384 : 0);
        gInput.bits = gInput.bits | (this.ctrlGetInputKey(Config.LSPKeys.Weapon_2, true) ? 32768 : 0);
        gInput.bits = gInput.bits | (this.ctrlGetInputKey(Config.LSPKeys.Weapon_3, true) ? 49152 : 0);
        if (this.ctrlGetInputKey(BuildConfig.GameKeys.Previous_Weapon, true)) {
            gInput.bits |= 0x10000;
        }
        if (this.ctrlGetInputKey(BuildConfig.GameKeys.Next_Weapon, true)) {
            gInput.bits |= 0x14000;
        }
        if (this.ctrlGetInputKey(Config.LSPKeys.Last_Used_Weapon, true)) {
            gInput.bits |= 0x18000;
        }
        gInput.bits = gInput.bits | (this.ctrlKeyStatusOnce(237) ? 131072 : 0);
        if (this.ctrlGetInputKey(Config.LSPKeys.Crouch_toggle, true)) {
            boolean bl = this.crouch = !this.crouch;
        }
        if (this.crouch) {
            gInput.bits |= 2;
        }
        int keymove = 80;
        int keyturn = 128;
        boolean bl = running = !Main.cfg.gAutoRun && (gInput.bits & 0x100) != 0 || (gInput.bits & 0x100) == 0 && Main.cfg.gAutoRun;
        if (running) {
            keymove = 128;
            keyturn = 192;
        }
        if (this.ctrlGetInputKey(BuildConfig.GameKeys.Strafe, false)) {
            if (this.ctrlGetInputKey(BuildConfig.GameKeys.Turn_Left, false)) {
                this.svel -= -keymove;
            }
            if (this.ctrlGetInputKey(BuildConfig.GameKeys.Turn_Right, false)) {
                this.svel -= keymove;
            }
            this.svel = (short)Gameutils.BClipRange((float)this.svel - 20.0f * this.ctrlGetMouseStrafe(), (float)(-keymove), (float)keymove);
        } else {
            if (this.ctrlGetInputKey(BuildConfig.GameKeys.Turn_Left, false)) {
                this.angvel -= (float)keyturn;
            } else if (this.ctrlGetInputKey(BuildConfig.GameKeys.Turn_Right, false)) {
                this.angvel += (float)keyturn;
            }
            this.angvel = Gameutils.BClipRange(this.angvel + this.ctrlGetMouseTurn(), -1024.0f, 1024.0f);
        }
        if (this.ctrlGetInputKey(BuildConfig.GameKeys.Strafe_Left, false)) {
            this.svel += keymove;
        }
        if (this.ctrlGetInputKey(BuildConfig.GameKeys.Strafe_Right, false)) {
            this.svel += -keymove;
        }
        if (this.ctrlGetInputKey(BuildConfig.GameKeys.Move_Forward, false)) {
            this.vel += keymove;
        }
        if (this.ctrlGetInputKey(BuildConfig.GameKeys.Move_Backward, false)) {
            this.vel += -keymove;
        }
        if (Main.cfg.gMouseAim) {
            this.horiz = Gameutils.BClipRange(this.ctrlGetMouseLook(!Main.cfg.gInvertmouse), (float)(-(Engine.ydim >> 1)), (float)(100 + (Engine.ydim >> 1)));
        } else {
            this.vel = (short)Gameutils.BClipRange((float)this.vel - this.ctrlGetMouseMove(), (float)(-4 * keymove), (float)(4 * keymove));
        }
        Vector2 stick1 = this.ctrlGetStick(BuildControls.JoyStick.Turning);
        Vector2 stick2 = this.ctrlGetStick(BuildControls.JoyStick.Moving);
        float lookx = stick1.x;
        float looky = -stick1.y;
        if (Main.cfg.gJoyInvert) {
            looky *= -1.0f;
        }
        if (looky != 0.0f) {
            k = 4.0f;
            this.horiz = Gameutils.BClipRange(this.horiz + k * looky * (float)Main.cfg.gJoyLookSpeed / 65536.0f, (float)(-(Engine.ydim >> 1)), (float)(100 + (Engine.ydim >> 1)));
        }
        if (lookx != 0.0f) {
            k = 80.0f;
            this.angvel = (short)Gameutils.BClipRange(this.angvel + k * lookx * (float)Main.cfg.gJoyTurnSpeed / 65536.0f, -1024.0f, 1024.0f);
        }
        if (stick2.y != 0.0f) {
            k = 320.0f;
            this.vel = (short)Gameutils.BClipRange((float)this.vel - k * stick2.y, -128.0f, 127.0f);
        }
        if (stick2.x != 0.0f) {
            k = 320.0f;
            this.svel = (short)Gameutils.BClipRange((float)this.svel - k * stick2.x, -128.0f, 127.0f);
        }
        if (this.svel < 0) {
            this.svel = Math.min(this.svel + 8, 0);
        }
        if (this.svel > 0) {
            this.svel = Math.max(this.svel - 8, 0);
        }
        if (this.vel < 0) {
            this.vel = Math.min(this.vel + 8, 0);
        }
        if (this.vel > 0) {
            this.vel = Math.max(this.vel - 8, 0);
        }
        if (Globals.followmode && Globals.gPlayer[Mmulti.myconnectindex].gViewMode != 3) {
            Globals.followvel = this.vel;
            Globals.followsvel = this.svel;
            Globals.followang = this.angvel;
            return;
        }
        k = 0.17f;
        float angle = Gameutils.BClampAngle(Globals.gPlayer[Mmulti.myconnectindex].ang);
        double xvel = (double)this.vel * Gameutils.BCosAngle(angle) + (double)this.svel * Gameutils.BSinAngle(angle);
        double len = Math.sqrt(xvel * xvel + (yvel = (double)this.vel * Gameutils.BSinAngle(angle) - (double)this.svel * Gameutils.BCosAngle(angle)) * yvel);
        if (len > (double)(keymove << 14)) {
            xvel = xvel / len * (double)(keymove << 14);
            yvel = yvel / len * (double)(keymove << 14);
        }
        this.lPlayerXVel = (int)((double)this.lPlayerXVel + xvel * (double)k);
        this.lPlayerYVel = (int)((double)this.lPlayerYVel + yvel * (double)k);
        this.lPlayerXVel = Pragmas.mulscale(this.lPlayerXVel, 53248L, 16);
        this.lPlayerYVel = Pragmas.mulscale(this.lPlayerYVel, 53248L, 16);
        if (Pragmas.klabs(this.lPlayerXVel) < 2048 && Pragmas.klabs(this.lPlayerYVel) < 2048) {
            this.lPlayerYVel = 0;
            this.lPlayerXVel = 0;
        }
        gInput.xvel = this.lPlayerXVel;
        gInput.yvel = this.lPlayerYVel;
        gInput.angvel = this.angvel;
        gInput.horiz = this.horiz;
    }
}

