/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.Components;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.miginfocom.swing.MigLayout;
import ru.m210projects.Build.Settings.BuildConfig;
import ru.m210projects.Launcher.desktop.BoundsPopupMenuListener;
import ru.m210projects.Launcher.desktop.CheckFiles;
import ru.m210projects.Launcher.desktop.ComboItem;
import ru.m210projects.Launcher.desktop.Components.Buttons.OpenButton;
import ru.m210projects.Launcher.desktop.Components.Buttons.SettingsButton;
import ru.m210projects.Launcher.desktop.Components.DirectoryBrowser;
import ru.m210projects.Launcher.desktop.Components.GamePanel;
import ru.m210projects.Launcher.desktop.GameEntries.DukeEntry;
import ru.m210projects.Launcher.desktop.GameEntries.GameEntry;
import ru.m210projects.Launcher.desktop.GetSteamLibraries;
import ru.m210projects.Launcher.desktop.JLauncher;
import ru.m210projects.Launcher.desktop.Main;
import ru.m210projects.Launcher.desktop.WinReg;

public class DukePanel
extends GamePanel {
    private static final long serialVersionUID = 1L;
    private JTextField pathField;
    private JButton launchButton;
    private OpenButton openButton;
    private JLauncher main;
    private JComboBox<ComboItem> gameFoldersList;
    private JLabel messageField = new JLabel();
    private boolean isPortable;
    private boolean Init = false;
    private boolean initialized = false;

    public DukePanel(JLauncher main, DukeEntry entry, boolean isPortable) {
        super(entry);
        this.main = main;
        this.isPortable = isPortable;
    }

    @Override
    public void init() {
        this.setLayout(new MigLayout("", "[grow][]", "[][grow][]"));
        if (Main.isWindows & !this.isPortable) {
            this.gameFoldersList = new JComboBox();
            final BuildConfig cfg = this.entry.getConfig();
            final ComboItem cfgPath = new ComboItem(cfg.path, cfg.path);
            if (cfg.path != null) {
                this.gameFoldersList.addItem(cfgPath);
            }
            PopupMenuListener popupMenuListener = new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    if (!DukePanel.this.Init) {
                        int i = 0;
                        while (i < GetSteamLibraries.steamLibraries.size()) {
                            ComboItem[] paths = new ComboItem[]{new ComboItem(String.valueOf(GetSteamLibraries.steamLibraries.get(i)) + "common\\Duke Nukem 3D Twentieth Anniversary World Tour\\", "[WT Steam] " + GetSteamLibraries.steamLibraries.get(i) + "common\\Duke Nukem 3D Twentieth Anniversary World Tour\\"), new ComboItem(String.valueOf(GetSteamLibraries.steamLibraries.get(i)) + "common\\Duke Nukem 3D\\gameroot\\", "[Megaton Steam] " + GetSteamLibraries.steamLibraries.get(i) + "common\\Duke Nukem 3D\\gameroot\\"), new ComboItem(String.valueOf(GetSteamLibraries.steamLibraries.get(i)) + "common\\Duke Nukem 3D\\Duke Nukem 3D\\", "[3DRA Steam] " + GetSteamLibraries.steamLibraries.get(i) + "common\\Duke Nukem 3D\\Duke Nukem 3D\\")};
                            int j = 0;
                            while (j < paths.length) {
                                if (new File(paths[j].getValue()).exists()) {
                                    if (Objects.equals(paths[j].getValue(), cfg.path)) {
                                        DukePanel.this.gameFoldersList.insertItemAt(paths[j], 0);
                                        DukePanel.this.gameFoldersList.removeItem(cfgPath);
                                    } else {
                                        DukePanel.this.gameFoldersList.addItem(paths[j]);
                                    }
                                }
                                ++j;
                            }
                            ++i;
                        }
                        int count = 1;
                        while (count < 9) {
                            String regPath = null;
                            String regKey = null;
                            String pathToGame = null;
                            String label = null;
                            switch (count) {
                                case 1: {
                                    regPath = "HKLM\\Software\\WOW6432Node\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\{701DE32E-4F6E-4524-9966-837165B91EB9}_is1";
                                    regKey = "InstallLocation";
                                    label = "[Zoom] ";
                                    break;
                                }
                                case 2: {
                                    regPath = "HKLM\\Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\{701DE32E-4F6E-4524-9966-837165B91EB9}_is1";
                                    regKey = "InstallLocation";
                                    label = "[Zoom] ";
                                    break;
                                }
                                case 3: {
                                    regPath = "HKLM\\Software\\WOW6432Node\\GOG.com\\GOGDUKE3D";
                                    regKey = "PATH";
                                    label = "[GOG] ";
                                    break;
                                }
                                case 4: {
                                    regPath = "HKLM\\Software\\GOG.com\\GOGDUKE3D";
                                    regKey = "PATH";
                                    label = "[GOG] ";
                                    break;
                                }
                                case 5: {
                                    regPath = "HKLM\\SOFTWARE\\WOW6432Node\\3DRealms\\Anthology";
                                    regKey = "";
                                    label = "[Anthology] ";
                                    break;
                                }
                                case 6: {
                                    regPath = "HKLM\\SOFTWARE\\3DRealms\\Anthology";
                                    regKey = "";
                                    label = "[Anthology] ";
                                    break;
                                }
                                case 7: {
                                    regPath = "HKLM\\SOFTWARE\\WOW6432Node\\3DRealms\\Duke Nukem 3D";
                                    regKey = "";
                                    label = "[Anthology] ";
                                    break;
                                }
                                case 8: {
                                    regPath = "HKLM\\SOFTWARE\\3DRealms\\Duke Nukem 3D";
                                    regKey = "";
                                    label = "[Anthology] ";
                                }
                            }
                            pathToGame = WinReg.getRegKey(regPath, regKey);
                            if (pathToGame != null && new File(pathToGame).exists()) {
                                switch (count) {
                                    case 5: {
                                        pathToGame = String.valueOf(pathToGame) + "\\Duke Nukem 3D\\";
                                        break;
                                    }
                                    case 6: {
                                        pathToGame = String.valueOf(pathToGame) + "\\Duke Nukem 3D\\";
                                    }
                                }
                                if (!pathToGame.endsWith("\\")) {
                                    pathToGame = String.valueOf(pathToGame) + "\\";
                                }
                                if (Objects.equals(pathToGame, cfg.path)) {
                                    DukePanel.this.gameFoldersList.insertItemAt(new ComboItem(pathToGame, String.valueOf(label) + pathToGame), 0);
                                    DukePanel.this.gameFoldersList.removeItem(cfgPath);
                                } else {
                                    DukePanel.this.gameFoldersList.addItem(new ComboItem(pathToGame, String.valueOf(label) + pathToGame));
                                }
                            }
                            ++count;
                            DukePanel.this.Init = true;
                        }
                    }
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            };
            this.gameFoldersList.addPopupMenuListener(popupMenuListener);
            this.gameFoldersList.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DukePanel.this.path = ((ComboItem)DukePanel.this.gameFoldersList.getSelectedItem()).getValue();
                    CheckFiles result = DukePanel.this.entry.checkResources(DukePanel.this.path, true);
                    boolean access = result.getValue();
                    DukePanel.this.messageField.setText(result.getLabel());
                    DukePanel.this.entry.getConfig().path = DukePanel.this.path;
                    DukePanel.this.startButtonStatus(access);
                }
            });
            BoundsPopupMenuListener listener = new BoundsPopupMenuListener(true, false);
            this.gameFoldersList.addPopupMenuListener(listener);
            this.gameFoldersList.setPrototypeDisplayValue(new ComboItem("", ""));
            this.add(this.gameFoldersList, "cell 0 0,grow");
        } else {
            this.pathField = new JTextField();
            this.pathField.setToolTipText("Path to " + this.entry.getResourceName() + " files");
            this.pathField.setEditable(false);
            this.add((Component)this.pathField, "cell 0 0,grow");
            this.pathField.setColumns(10);
        }
        JButton browseTW = new JButton("...");
        browseTW.setToolTipText("Choose folder");
        browseTW.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = DirectoryBrowser.showDirectoryChooser(Main.fr.getFrame(), DukePanel.this.path, DukePanel.this.entry.getResourceName(), DukePanel.this.entry.getIcon16());
                if (f != null) {
                    DukePanel.this.path = String.valueOf(f.getAbsolutePath()) + File.separator;
                }
                if (Main.isWindows) {
                    ComboItem addedPath = new ComboItem(DukePanel.this.path, DukePanel.this.path);
                    DukePanel.this.gameFoldersList.addItem(addedPath);
                    DukePanel.this.gameFoldersList.setSelectedItem(addedPath);
                }
                if (!Main.isWindows) {
                    DukePanel.this.pathField.setText(DukePanel.this.path);
                }
                CheckFiles result = DukePanel.this.entry.checkResources(DukePanel.this.path, true);
                boolean access = result.getValue();
                DukePanel.this.messageField.setText(result.getLabel());
                DukePanel.this.entry.getConfig().path = DukePanel.this.path;
                DukePanel.this.startButtonStatus(access);
            }
        });
        if (!this.isPortable) {
            this.add((Component)browseTW, "cell 2 0,grow");
        }
        this.openButton = new OpenButton();
        this.add((Component)this.openButton, "cell 3 0,grow");
        this.add((Component)this.messageField, "cell 0 1 4, grow");
        this.messageField.setVerticalAlignment(1);
        this.launchButton = new JButton();
        this.launchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DukePanel.this.launchButton.setText("Loading...");
                DukePanel.this.launchButton.setEnabled(false);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        (this).DukePanel.this.entry.startGame((this).DukePanel.this.path);
                    }
                });
            }
        });
        this.add((Component)this.launchButton, "cell 0 3 3 1,grow");
        this.add((Component)new SettingsButton(this.main, this.entry, null, "Settings"), "cell 3 3,alignx right,growy");
    }

    @Override
    public void update() {
        BuildConfig cfg = this.entry.getConfig();
        this.path = cfg.path != null ? cfg.path : GameEntry.getDirPath();
        this.openButton.update(this.path);
        if (!this.initialized) {
            CheckFiles result = this.entry.checkResources(this.path, true);
            boolean access = result.getValue();
            this.messageField.setText(result.getLabel());
            this.startButtonStatus(access);
            if (!Main.isWindows || this.isPortable) {
                this.pathField.setText(this.path);
            }
            this.initialized = true;
        }
    }

    public void startButtonStatus(boolean access) {
        this.launchButton.setEnabled(access);
        if (access) {
            this.launchButton.setText("Play " + this.entry.getResourceName());
        } else {
            this.launchButton.setText(String.valueOf(this.entry.getResourceName()) + " resources not found!");
        }
    }
}

