/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.Components;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import ru.m210projects.Build.Settings.BuildConfig;
import ru.m210projects.Launcher.desktop.CheckFiles;
import ru.m210projects.Launcher.desktop.Components.Buttons.OpenButton;
import ru.m210projects.Launcher.desktop.Components.Buttons.SettingsButton;
import ru.m210projects.Launcher.desktop.Components.DirectoryBrowser;
import ru.m210projects.Launcher.desktop.Components.GamePanel;
import ru.m210projects.Launcher.desktop.GameEntries.GameEntry;
import ru.m210projects.Launcher.desktop.GameEntries.WH2Entry;
import ru.m210projects.Launcher.desktop.JLauncher;
import ru.m210projects.Launcher.desktop.Main;

public class WH2Panel
extends GamePanel {
    private static final long serialVersionUID = 1L;
    private JTextField pathField;
    private JButton launchButton;
    private OpenButton openButton;
    private JLauncher main;
    private JLabel messageField = new JLabel();
    private boolean isPortable;
    private boolean initialized = false;

    public WH2Panel(JLauncher main, WH2Entry entry, boolean isPortable) {
        super(entry);
        this.main = main;
        this.isPortable = isPortable;
    }

    @Override
    public void init() {
        this.setLayout(new MigLayout("", "[grow][]", "[][grow][]"));
        this.pathField = new JTextField();
        this.pathField.setToolTipText("Path to " + this.entry.getResourceName() + " files");
        this.pathField.setEditable(false);
        this.add((Component)this.pathField, "cell 0 0,grow");
        this.pathField.setColumns(10);
        JButton browseTW = new JButton("...");
        browseTW.setToolTipText("Choose folder");
        browseTW.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = DirectoryBrowser.showDirectoryChooser(Main.fr.getFrame(), WH2Panel.this.path, WH2Panel.this.entry.getResourceName(), WH2Panel.this.entry.getIcon16());
                if (f != null) {
                    WH2Panel.this.path = String.valueOf(f.getAbsolutePath()) + File.separator;
                }
                WH2Panel.this.pathField.setText(WH2Panel.this.path);
                CheckFiles result = WH2Panel.this.entry.checkResources(WH2Panel.this.path, true);
                boolean access = result.getValue();
                WH2Panel.this.messageField.setText(result.getLabel());
                WH2Panel.this.entry.getConfig().path = WH2Panel.this.path;
                WH2Panel.this.startButtonStatus(access);
            }
        });
        if (!this.isPortable) {
            this.add((Component)browseTW, "cell 1 0,grow");
        }
        this.openButton = new OpenButton();
        this.add((Component)this.openButton, "cell 2 0,grow");
        this.add((Component)this.messageField, "cell 0 1 4, grow");
        this.messageField.setVerticalAlignment(1);
        this.launchButton = new JButton();
        this.launchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                WH2Panel.this.launchButton.setText("Loading...");
                WH2Panel.this.launchButton.setEnabled(false);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        (this).WH2Panel.this.entry.startGame((this).WH2Panel.this.path);
                    }
                });
            }
        });
        this.add((Component)this.launchButton, "cell 0 3 2 1,grow");
        this.add((Component)new SettingsButton(this.main, this.entry, null, "Settings"), "cell 2 3,alignx right,growy");
    }

    @Override
    public void update() {
        BuildConfig cfg = this.entry.getConfig();
        this.path = cfg.path != null ? cfg.path : GameEntry.getDirPath();
        this.openButton.update(this.path);
        if (!this.initialized) {
            CheckFiles result = this.entry.checkResources(this.path, true);
            boolean access = result.getValue();
            this.messageField.setText(result.getLabel());
            this.pathField.setText(this.path);
            this.startButtonStatus(access);
            this.initialized = true;
        }
    }

    public void startButtonStatus(boolean access) {
        this.launchButton.setEnabled(access);
        if (access) {
            this.launchButton.setText("Play " + this.entry.getResourceName());
            this.launchButton.requestFocus();
        } else {
            this.launchButton.setText(String.valueOf(this.entry.getResourceName()) + " resources not found!");
        }
    }
}

