/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop;

import java.io.File;
import javax.swing.UIManager;
import ru.m210projects.Build.Settings.BuildConfig;
import ru.m210projects.Launcher.desktop.GameEntries.GameEntry;
import ru.m210projects.Launcher.desktop.JLauncher;
import ru.m210projects.Launcher.desktop.Main;

public class Frame {
    protected String portableEmulatorPath = null;
    public boolean forcePortable = false;
    private int currentEntry;
    private JLauncher frame;

    public Frame(GameEntry ... entry) {
        if (this.checkPortable(entry)) {
            return;
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.frame = new JLauncher("BuildGDX " + Main.appversion, this.currentEntry, entry);
        this.frame.start();
        if (this.currentEntry != -1) {
            this.frame.showEntry(entry[this.currentEntry]);
        }
    }

    public void dispose() {
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    public JLauncher getFrame() {
        return this.frame;
    }

    private boolean checkPortable(GameEntry ... entry) {
        String currentPath = this.portableEmulatorPath != null ? this.portableEmulatorPath : GameEntry.getDirPath();
        this.currentEntry = -1;
        if (this.checkPortablePath(currentPath)) {
            int i = 0;
            while (i < entry.length) {
                if (entry[i].checkResources(currentPath, false).getValue()) {
                    this.currentEntry = i;
                    break;
                }
                ++i;
            }
        }
        if (this.currentEntry != -1) {
            BuildConfig currentConfig = entry[this.currentEntry].buildConfig(currentPath);
            currentConfig.path = currentPath;
            if (!currentConfig.startup) {
                entry[this.currentEntry].startGame(currentPath);
                return true;
            }
        }
        return false;
    }

    private boolean checkPortablePath(String path) {
        File f;
        File directory = new File(path);
        File[] fList = directory.listFiles();
        if (fList != null) {
            File[] fileArray = fList;
            if (fList.length != 0) {
                File file = fileArray[0];
                if (file.getName().toLowerCase().equals("portable")) {
                    this.forcePortable = true;
                }
                return true;
            }
        }
        if ((f = new File(String.valueOf(path) + "tmp_check.write")).exists()) {
            return f.delete();
        }
        try {
            if (f.createNewFile()) {
                return f.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

