/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import net.miginfocom.swing.MigLayout;
import ru.m210projects.Launcher.desktop.Components.About;
import ru.m210projects.Launcher.desktop.Components.BloodPanel;
import ru.m210projects.Launcher.desktop.Components.Buttons.AboutButton;
import ru.m210projects.Launcher.desktop.Components.Buttons.FrameButton;
import ru.m210projects.Launcher.desktop.Components.Buttons.GameButton;
import ru.m210projects.Launcher.desktop.Components.Buttons.SettingsButton;
import ru.m210projects.Launcher.desktop.Components.DukePanel;
import ru.m210projects.Launcher.desktop.Components.FramePanel;
import ru.m210projects.Launcher.desktop.Components.GamePanel;
import ru.m210projects.Launcher.desktop.Components.ImagePanel;
import ru.m210projects.Launcher.desktop.Components.LSPPanel;
import ru.m210projects.Launcher.desktop.Components.NamPanel;
import ru.m210projects.Launcher.desktop.Components.PSPanel;
import ru.m210projects.Launcher.desktop.Components.RRPanel;
import ru.m210projects.Launcher.desktop.Components.RRRAPanel;
import ru.m210projects.Launcher.desktop.Components.SWPanel;
import ru.m210projects.Launcher.desktop.Components.Settings;
import ru.m210projects.Launcher.desktop.Components.TekwarPanel;
import ru.m210projects.Launcher.desktop.Components.WH2Panel;
import ru.m210projects.Launcher.desktop.Components.WHPanel;
import ru.m210projects.Launcher.desktop.GameEntries.BloodEntry;
import ru.m210projects.Launcher.desktop.GameEntries.DisabledEntry;
import ru.m210projects.Launcher.desktop.GameEntries.DukeEntry;
import ru.m210projects.Launcher.desktop.GameEntries.GameEntry;
import ru.m210projects.Launcher.desktop.GameEntries.LSPEntry;
import ru.m210projects.Launcher.desktop.GameEntries.NamEntry;
import ru.m210projects.Launcher.desktop.GameEntries.PSlaveEntry;
import ru.m210projects.Launcher.desktop.GameEntries.RREntry;
import ru.m210projects.Launcher.desktop.GameEntries.RRRAEntry;
import ru.m210projects.Launcher.desktop.GameEntries.SWEntry;
import ru.m210projects.Launcher.desktop.GameEntries.TekwarEntry;
import ru.m210projects.Launcher.desktop.GameEntries.WH2Entry;
import ru.m210projects.Launcher.desktop.GameEntries.WHEntry;

public class JLauncher
extends JFrame {
    private static final long serialVersionUID = 1L;
    private CardLayout cl_HeaderLogo;
    private CardLayout cl_RightPanel;
    private JPanel RightPanel;
    private JPanel HeaderLogo;
    public Settings settingsPanel;
    public AboutButton about;
    public GameEntry[] entries;
    public HashMap<GameEntry, GameButton> buttonLinker;

    public JLauncher(String title, int portableEntry, GameEntry ... entry) {
        this.setTitle(title);
        this.setResizable(false);
        this.setLayout(new MigLayout("", "[][grow 1]", "[::100px,fill][grow,top][bottom]"));
        this.setDefaultCloseOperation(3);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/Games/build32.png")));
        this.entries = entry;
        this.buttonLinker = new HashMap(entry.length);
        this.cl_HeaderLogo = new CardLayout();
        this.HeaderLogo = new JPanel();
        this.HeaderLogo.setBorder(null);
        this.add((Component)this.HeaderLogo, "cell 1 0 2 1,grow");
        this.HeaderLogo.setLayout(this.cl_HeaderLogo);
        this.HeaderLogo.add((Component)new ImagePanel(this.getClass().getResource("/Headers/headerbuild.png")), "logoBuild");
        int i = 0;
        while (i < entry.length) {
            this.HeaderLogo.add((Component)new ImagePanel(entry[i].getLogo()), "logo " + i);
            ++i;
        }
        this.HeaderLogo.setPreferredSize(new Dimension(380, 100));
        this.cl_RightPanel = new CardLayout();
        this.RightPanel = new JPanel();
        this.RightPanel.setBorder(new EtchedBorder(1, null, null));
        this.RightPanel.setLayout(this.cl_RightPanel);
        JPanel buttons = new JPanel();
        buttons.setLayout(new MigLayout("", "[fill]", ""));
        int i2 = 0;
        while (i2 < entry.length) {
            GameButton b = new GameButton(this, i2);
            this.buttonLinker.put(this.entries[i2], b);
            this.RightPanel.add((Component)this.buildPanel(entry[i2], portableEntry != -1), "panel " + i2);
            if (portableEntry == -1) {
                buttons.add((Component)b, "cell 0 " + i2);
                b.setHorizontalAlignment(2);
            }
            ++i2;
        }
        this.settingsPanel = new Settings(this, portableEntry != -1 ? this.entries[portableEntry] : null);
        this.RightPanel.add((Component)this.settingsPanel, "Settings");
        this.RightPanel.add((Component)new About(), "About");
        this.about = new AboutButton(this, "logoBuild", "About");
        this.add((Component)this.about, "cell 1 2,alignx right,growy");
        this.add((Component)this.RightPanel, "cell 1 1,grow");
        if (portableEntry == -1) {
            this.add((Component)buttons, "cell 0 0,grow");
        }
    }

    private FramePanel buildPanel(GameEntry entry, boolean isPortable) {
        if (entry instanceof TekwarEntry) {
            return new TekwarPanel(this, (TekwarEntry)entry, isPortable);
        }
        if (entry instanceof WHEntry) {
            return new WHPanel(this, (WHEntry)entry, isPortable);
        }
        if (entry instanceof WH2Entry) {
            return new WH2Panel(this, (WH2Entry)entry, isPortable);
        }
        if (entry instanceof BloodEntry) {
            return new BloodPanel(this, (BloodEntry)entry, isPortable);
        }
        if (entry instanceof DukeEntry) {
            return new DukePanel(this, (DukeEntry)entry, isPortable);
        }
        if (entry instanceof RREntry) {
            return new RRPanel(this, (RREntry)entry, isPortable);
        }
        if (entry instanceof RRRAEntry) {
            return new RRRAPanel(this, (RRRAEntry)entry, isPortable);
        }
        if (entry instanceof PSlaveEntry) {
            return new PSPanel(this, (PSlaveEntry)entry, isPortable);
        }
        if (entry instanceof LSPEntry) {
            return new LSPPanel(this, (LSPEntry)entry, isPortable);
        }
        if (entry instanceof SWEntry) {
            return new SWPanel(this, (SWEntry)entry, isPortable);
        }
        if (entry instanceof NamEntry) {
            return new NamPanel(this, (NamEntry)entry, isPortable);
        }
        if (entry instanceof DisabledEntry) {
            GameButton button = this.buttonLinker.get(entry);
            button.setEnabled(false);
            return new GamePanel(entry){
                private static final long serialVersionUID = 1L;

                @Override
                public void init() {
                }

                @Override
                public void update() {
                }
            };
        }
        System.err.println("GamePanel not found for " + entry.appname);
        return null;
    }

    public void showPanel(FrameButton button) {
        button.requestFocus();
        if (button.panelName != null) {
            this.cl_RightPanel.show(this.RightPanel, button.panelName);
        }
        if (button.logoName != null) {
            this.cl_HeaderLogo.show(this.HeaderLogo, button.logoName);
        }
        if (button == this.about || button instanceof SettingsButton) {
            this.about.setAction(true);
        } else {
            this.about.setAction(false);
        }
    }

    public void showEntry(GameEntry entry) {
        if (entry == null) {
            return;
        }
        this.settingsPanel.setEntry(entry);
        GameButton button = this.buttonLinker.get(entry);
        button.requestFocus();
        this.cl_RightPanel.show(this.RightPanel, button.panelName);
        this.cl_HeaderLogo.show(this.HeaderLogo, button.logoName);
        this.about.setEntry(entry);
        this.about.setAction(false);
    }

    public void start() {
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.showPanel(this.about);
    }
}

