/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.FileResource;
import ru.m210projects.Build.FileHandle.FileUtils;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.Tools.SaveManager;
import ru.m210projects.Build.Types.LittleEndian;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.Tile;
import ru.m210projects.Build.Types.WALL;
import ru.m210projects.Powerslave.Anim;
import ru.m210projects.Powerslave.Bullet;
import ru.m210projects.Powerslave.Enemies.Anubis;
import ru.m210projects.Powerslave.Enemies.Fish;
import ru.m210projects.Powerslave.Enemies.LavaDude;
import ru.m210projects.Powerslave.Enemies.Lion;
import ru.m210projects.Powerslave.Enemies.Mummy;
import ru.m210projects.Powerslave.Enemies.Queen;
import ru.m210projects.Powerslave.Enemies.Ra;
import ru.m210projects.Powerslave.Enemies.Rat;
import ru.m210projects.Powerslave.Enemies.Rex;
import ru.m210projects.Powerslave.Enemies.Roach;
import ru.m210projects.Powerslave.Enemies.Scorp;
import ru.m210projects.Powerslave.Enemies.Set;
import ru.m210projects.Powerslave.Enemies.Spider;
import ru.m210projects.Powerslave.Enemies.Wasp;
import ru.m210projects.Powerslave.Energy;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Grenade;
import ru.m210projects.Powerslave.Light;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Map;
import ru.m210projects.Powerslave.Menus.MenuCorruptGame;
import ru.m210projects.Powerslave.Menus.PSMenuUserContent;
import ru.m210projects.Powerslave.Object;
import ru.m210projects.Powerslave.Palette;
import ru.m210projects.Powerslave.Player;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Sector;
import ru.m210projects.Powerslave.Slide;
import ru.m210projects.Powerslave.Snake;
import ru.m210projects.Powerslave.SpiritHead;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Switch;
import ru.m210projects.Powerslave.Type.EpisodeInfo;
import ru.m210projects.Powerslave.Type.LSInfo;
import ru.m210projects.Powerslave.Type.PlayerStruct;
import ru.m210projects.Powerslave.Type.SafeLoader;
import ru.m210projects.Powerslave.View;
import ru.m210projects.Powerslave.Weapons;

public class LoadSave {
    public static String nSaveFile;
    public static String nSaveName;
    public static boolean gClassicMode;
    public static boolean gQuickSaving;
    public static boolean gAutosaveRequest;
    public static SafeLoader loader;
    public static LSInfo lsInf;
    public static int quickslot;
    public static String lastload;
    public static final String savsign = "LOBO";
    public static final String origsave = "savgamea.sav";
    public static final int gdxSave = 100;
    public static final int currentGdxSave = 100;
    public static final int SAVEVERSION;
    public static final int SAVETIME = 8;
    public static final int SAVENAME = 32;
    public static final int SAVELEVELINFO = 5;
    public static final int SAVEHEADER;
    public static final int SAVESCREENSHOTSIZE = 16000;
    public static final int SAVEGDXDATA = 16273;
    public static final char[] filenum;

    static {
        gClassicMode = false;
        loader = new SafeLoader();
        lsInf = new LSInfo();
        quickslot = 0;
        SAVEVERSION = savsign.length() + 2;
        SAVEHEADER = SAVEVERSION + 8 + 32 + 5;
        filenum = new char[4];
    }

    public static void FindSaves() {
        Resource origSave = BuildGdx.cache.open(origsave, 0);
        if (origSave != null) {
            int i = 0;
            while (i < 5) {
                FileResource fil;
                String filename = "savgame" + i + ".sav";
                if (BuildGdx.compat.checkFile(filename, Compat.Path.User) == null && loader.loadOrig(origSave, i) && (fil = BuildGdx.compat.open("savgame" + i + ".sav", Compat.Path.User, FileResource.Mode.Write)) != null) {
                    long time = Main.game.date.getCurrentDate();
                    LoadSave.SaveHeader(fil, LoadSave.loader.savename, time, LoadSave.loader.level, LoadSave.loader.best, true);
                    LoadSave.SaveGDXBlock(fil);
                    fil.writeShort(LoadSave.loader.nPlayerWeapons[Globals.nLocalPlayer]);
                    fil.writeShort(LoadSave.loader.PlayerList[Globals.nLocalPlayer].currentWeapon);
                    fil.writeShort(LoadSave.loader.nPlayerClip[Globals.nLocalPlayer]);
                    fil.writeShort(LoadSave.loader.nPlayerItem[Globals.nLocalPlayer]);
                    fil.writeBytes(LoadSave.loader.PlayerList[Globals.nLocalPlayer].getBytes(false), PlayerStruct.size(false));
                    fil.writeShort(LoadSave.loader.nPlayerLives[Globals.nLocalPlayer]);
                    fil.close();
                    Main.game.pSavemgr.add(LoadSave.loader.savename, time, filename);
                }
                ++i;
            }
            origSave.close();
        }
        FileResource fil = null;
        for (FileEntry file : BuildGdx.compat.getDirectory(Compat.Path.User).getFiles().values()) {
            short nVersion;
            if (!file.getExtension().equals("sav") || (fil = BuildGdx.compat.open(file)) == null) continue;
            String signature = fil.readString(4);
            if (signature == null || signature.isEmpty()) {
                fil.close();
                continue;
            }
            if (signature.equals(savsign) && (nVersion = fil.readShort().shortValue()) >= 100) {
                long time = fil.readLong();
                String savname = fil.readString(32).trim();
                Main.game.pSavemgr.add(savname, time, file.getName());
            }
            fil.close();
        }
        Main.game.pSavemgr.sort();
    }

    public static int lsReadLoadData(String filename) {
        FileResource file = BuildGdx.compat.open(filename, Compat.Path.User, FileResource.Mode.Read);
        if (file != null) {
            Tile pic = Main.engine.getTile(SaveManager.Screenshot);
            if (!pic.isLoaded()) {
                Main.engine.allocatepermanenttile(SaveManager.Screenshot, 160, 100);
            }
            int nVersion = LoadSave.checkSave(file) & 0xFFFF;
            lsInf.clear();
            if (nVersion == 100) {
                String fullname;
                String addon;
                file.seek(SAVEVERSION, Resource.Whence.Set);
                LoadSave.lsInf.date = Main.game.date.getDate(file.readLong());
                file.seek(SAVEVERSION + 8 + 32, Resource.Whence.Set);
                lsInf.read(file);
                if (file.remaining() <= 16000) {
                    file.close();
                    return -1;
                }
                boolean hasCapt = file.readBoolean();
                if (hasCapt) {
                    file.read(pic.data, 0, 16000);
                    Main.engine.invalidatetile(SaveManager.Screenshot, 0, -1);
                }
                LoadSave.lsInf.addonfile = null;
                if (file.readByte() == 2 && !(addon = FileUtils.getFullName(fullname = file.readString(144).trim())).isEmpty()) {
                    LoadSave.lsInf.addonfile = "Addon: " + addon;
                }
                file.close();
                return hasCapt ? 1 : -1;
            }
            LoadSave.lsInf.info = "Incompatible ver. " + nVersion + " != " + 100;
            if (!file.isClosed()) {
                file.close();
            }
        } else {
            lsInf.clear();
        }
        return -1;
    }

    public static int checkSave(Resource bb) {
        String signature = bb.readString(4);
        if (!signature.equals(savsign)) {
            return 0;
        }
        return bb.readShort().shortValue();
    }

    public static boolean checkfile(Resource bb) {
        int nVersion = LoadSave.checkSave(bb);
        if (nVersion != 100) {
            return false;
        }
        return loader.load(bb);
    }

    public static boolean loadgame(String filename) {
        FileResource fil = BuildGdx.compat.open(filename, Compat.Path.User, FileResource.Mode.Read);
        if (fil != null) {
            boolean status = LoadSave.checkfile(fil);
            fil.close();
            if (status) {
                LoadSave.load();
                if (lastload == null || lastload.isEmpty()) {
                    lastload = filename;
                }
                if (gClassicMode) {
                    nSaveFile = filename;
                    nSaveName = LoadSave.loader.savename;
                } else {
                    nSaveName = null;
                    nSaveFile = null;
                }
            }
            return status;
        }
        return false;
    }

    private static void load() {
        LoadSave.LoadGDXBlock();
        gClassicMode = LoadSave.loader.gClassicMode;
        Globals.nBestLevel = LoadSave.loader.best;
        if (gClassicMode) {
            View.zoom = 768;
            Globals.nPlayerWeapons[Globals.nLocalPlayer] = LoadSave.loader.nPlayerWeapons[Globals.nLocalPlayer];
            Globals.PlayerList[Globals.nLocalPlayer].currentWeapon = LoadSave.loader.PlayerList[Globals.nLocalPlayer].currentWeapon;
            Globals.nPlayerClip[Globals.nLocalPlayer] = LoadSave.loader.nPlayerClip[Globals.nLocalPlayer];
            int nAmmo = Globals.PlayerList[Globals.nLocalPlayer].AmmosAmount[1];
            if (nAmmo >= 6) {
                nAmmo = 6;
            }
            Globals.nPistolClip[Globals.nLocalPlayer] = nAmmo;
            Globals.nPlayerItem[Globals.nLocalPlayer] = LoadSave.loader.nPlayerItem[Globals.nLocalPlayer];
            Globals.PlayerList[Globals.nLocalPlayer].copy(LoadSave.loader.PlayerList[Globals.nLocalPlayer]);
            Globals.nPlayerLives[Globals.nLocalPlayer] = LoadSave.loader.nPlayerLives[Globals.nLocalPlayer];
            Player.SetPlayerItem(Globals.nLocalPlayer, Globals.nPlayerItem[Globals.nLocalPlayer]);
            Weapons.CheckClip(Globals.nLocalPlayer);
            Main.game.nNetMode = BuildGame.NetMode.Single;
            Main.gGameScreen.changemap(LoadSave.loader.level, null);
            View.StatusMessage(500, "Game loaded", Globals.nLocalPlayer);
            System.gc();
        } else {
            Object.InitElev();
            LoadSave.loadFM();
            Main.gPrecacheScreen.init(false, new Runnable(){

                @Override
                public void run() {
                    Main.game.nNetMode = BuildGame.NetMode.Single;
                    Main.gGameScreen.gNameShowTime = 500;
                    Main.game.changeScreen(Main.gGameScreen);
                    Main.game.pInput.resetMousePos();
                    Main.game.gPaused = false;
                    Light.LoadTorch(Light.bTorch);
                    Player.SetPlayerItem(Globals.nLocalPlayer, Globals.nPlayerItem[Globals.nLocalPlayer]);
                    View.SetAirFrame();
                    View.RefreshStatus();
                    if (loader.getMessage() != null) {
                        View.StatusMessage(2000, loader.getMessage(), Mmulti.myconnectindex);
                    } else {
                        View.StatusMessage(500, "Game loaded", Globals.nLocalPlayer);
                    }
                    System.gc();
                    Main.game.pNet.ResetTimers();
                    Main.game.pNet.ready2send = true;
                }
            });
            Main.game.changeScreen(Main.gPrecacheScreen);
        }
    }

    public static void LoadGDXBlock() {
        if (LoadSave.loader.warp_on == 0) {
            Globals.mUserFlag = Main.UserFlag.None;
            PSMenuUserContent.resetEpisodeResources(Globals.gOriginalEpisode);
        } else if (LoadSave.loader.warp_on == 1) {
            Globals.mUserFlag = Main.UserFlag.UserMap;
            Globals.boardfilename = LoadSave.loader.boardfilename;
            PSMenuUserContent.resetEpisodeResources(null);
        } else if (LoadSave.loader.warp_on == 2) {
            Globals.mUserFlag = Main.UserFlag.Addon;
            PSMenuUserContent.checkEpisodeResources(LoadSave.loader.addon);
        }
    }

    public static void loadMap() {
        Engine.numsectors = LoadSave.loader.numsectors;
        int s = 0;
        while (s < Engine.numsectors) {
            if (Engine.sector[s] == null) {
                Engine.sector[s] = new SECTOR();
            }
            Engine.sector[s].set(LoadSave.loader.sector[s]);
            ++s;
        }
        Engine.numwalls = LoadSave.loader.numwalls;
        int w = 0;
        while (w < Engine.numwalls) {
            if (Engine.wall[w] == null) {
                Engine.wall[w] = new WALL();
            }
            Engine.wall[w].set(LoadSave.loader.wall[w]);
            ++w;
        }
        int i = 0;
        while (i < Engine.MAXSPRITES) {
            if (Engine.sprite[i] == null) {
                Engine.sprite[i] = new SPRITE();
            }
            Engine.sprite[i].set(LoadSave.loader.sprite[i]);
            ++i;
        }
        System.arraycopy(LoadSave.loader.headspritesect, 0, Engine.headspritesect, 0, Engine.MAXSECTORS + 1);
        System.arraycopy(LoadSave.loader.headspritestat, 0, Engine.headspritestat, 0, 1025);
        System.arraycopy(LoadSave.loader.prevspritesect, 0, Engine.prevspritesect, 0, Engine.MAXSPRITES);
        System.arraycopy(LoadSave.loader.prevspritestat, 0, Engine.prevspritestat, 0, Engine.MAXSPRITES);
        System.arraycopy(LoadSave.loader.nextspritesect, 0, Engine.nextspritesect, 0, Engine.MAXSPRITES);
        System.arraycopy(LoadSave.loader.nextspritestat, 0, Engine.nextspritestat, 0, Engine.MAXSPRITES);
    }

    private static void loadPlayer() {
        Globals.PlayerCount = 1;
        Globals.PlayerList[Globals.nLocalPlayer].copy(LoadSave.loader.PlayerList[Globals.nLocalPlayer]);
        Mmulti.connecthead = LoadSave.loader.connecthead;
        System.arraycopy(LoadSave.loader.connectpoint2, 0, Mmulti.connectpoint2, 0, 8);
        Light.bTorch = LoadSave.loader.bTorch;
        Globals.nFreeze = LoadSave.loader.nFreeze;
        Globals.nXDamage[Globals.nLocalPlayer] = LoadSave.loader.nXDamage;
        Globals.nYDamage[Globals.nLocalPlayer] = LoadSave.loader.nYDamage;
        Globals.nDoppleSprite[Globals.nLocalPlayer] = LoadSave.loader.nDoppleSprite;
        Globals.nPlayerClip[Globals.nLocalPlayer] = LoadSave.loader.nPlayerClip[Globals.nLocalPlayer];
        Globals.nPistolClip[Globals.nLocalPlayer] = LoadSave.loader.nPistolClip[Globals.nLocalPlayer];
        Globals.nPlayerTorch[Globals.nLocalPlayer] = LoadSave.loader.nPlayerTorch;
        Globals.nPlayerWeapons[Globals.nLocalPlayer] = LoadSave.loader.nPlayerWeapons[Globals.nLocalPlayer];
        Globals.nPlayerLives[Globals.nLocalPlayer] = LoadSave.loader.nPlayerLives[Globals.nLocalPlayer];
        Globals.nPlayerItem[Globals.nLocalPlayer] = LoadSave.loader.nPlayerItem[Globals.nLocalPlayer];
        Globals.nPlayerInvisible[Globals.nLocalPlayer] = LoadSave.loader.nPlayerInvisible;
        Globals.nPlayerDouble[Globals.nLocalPlayer] = LoadSave.loader.nPlayerDouble;
        Globals.nPlayerViewSect[Globals.nLocalPlayer] = LoadSave.loader.nPlayerViewSect;
        Globals.nPlayerFloorSprite[Globals.nLocalPlayer] = LoadSave.loader.nPlayerFloorSprite;
        Globals.nPlayerScore[Globals.nLocalPlayer] = LoadSave.loader.nPlayerScore;
        Globals.nPlayerGrenade[Globals.nLocalPlayer] = LoadSave.loader.nPlayerGrenade;
        Globals.nPlayerSnake[Globals.nLocalPlayer] = LoadSave.loader.nPlayerSnake;
        Globals.nDestVertPan[Globals.nLocalPlayer] = LoadSave.loader.nDestVertPan;
        Globals.dVertPan[Globals.nLocalPlayer] = LoadSave.loader.dVertPan;
        Globals.nDeathType[Globals.nLocalPlayer] = LoadSave.loader.nDeathType;
        Globals.nQuake[Globals.nLocalPlayer] = LoadSave.loader.nQuake;
        Globals.bTouchFloor[Globals.nLocalPlayer] = LoadSave.loader.bTouchFloor;
        Globals.initx = LoadSave.loader.initx;
        Globals.inity = LoadSave.loader.inity;
        Globals.initz = LoadSave.loader.initz;
        Globals.inita = LoadSave.loader.inita;
        Globals.initsect = LoadSave.loader.initsect;
        System.arraycopy(LoadSave.loader.show2dsector, 0, Engine.show2dsector, 0, Engine.MAXSECTORS + 7 >> 3);
        System.arraycopy(LoadSave.loader.show2dwall, 0, Engine.show2dwall, 0, 1024);
        System.arraycopy(LoadSave.loader.show2dsprite, 0, Engine.show2dsprite, 0, Engine.MAXSPRITES + 7 >> 3);
        Globals.nPlayerPushSound[Globals.nLocalPlayer] = -1;
        Globals.nTauntTimer[Globals.nLocalPlayer] = (short)(Random.RandomSize(3) + 3);
        Globals.nPlayerPushSect[Globals.nLocalPlayer] = -1;
        Globals.nPlayerSwear[Globals.nLocalPlayer] = 4;
        Globals.nTemperature[Globals.nLocalPlayer] = 0;
        Weapons.SetWeaponStatus(Globals.nLocalPlayer);
    }

    private static void loadSprites() {
        LoadSave.loadEnemies();
        Bullet.loadBullets(loader, null);
        Grenade.loadGrenades(loader, null);
        Sprites.loadBubbles(loader, null);
        Snake.loadSnakes(loader, null);
        Object.loadObjects(loader, null);
        Object.loadTraps(loader, null);
        Object.loadDrips(loader, null);
        Globals.nCreaturesLeft = LoadSave.loader.nCreaturesLeft;
        Globals.nCreaturesMax = LoadSave.loader.nCreaturesMax;
        SpiritHead.nSpiritSprite = LoadSave.loader.nSpiritSprite;
        Globals.nMagicCount = LoadSave.loader.nMagicCount;
        Map.nRegenerates = LoadSave.loader.nRegenerates;
        Map.nFirstRegenerate = LoadSave.loader.nFirstRegenerate;
        Globals.nNetStartSprites = LoadSave.loader.nNetStartSprites;
        Globals.nCurStartSprite = LoadSave.loader.nCurStartSprite;
        Globals.nNetPlayerCount = LoadSave.loader.nNetPlayerCount;
        System.arraycopy(LoadSave.loader.nNetStartSprite, 0, Globals.nNetStartSprite, 0, 8);
        System.arraycopy(LoadSave.loader.nChunkSprite, 0, Sprites.nChunkSprite, 0, Sprites.nChunkSprite.length);
        System.arraycopy(LoadSave.loader.nBodyGunSprite, 0, Sprites.nBodyGunSprite, 0, Sprites.nBodyGunSprite.length);
        System.arraycopy(LoadSave.loader.nBodySprite, 0, Sprites.nBodySprite, 0, Sprites.nBodySprite.length);
        Sprites.nCurChunkNum = LoadSave.loader.nCurChunkNum;
        Sprites.nCurBodyNum = LoadSave.loader.nCurBodyNum;
        Sprites.nCurBodyGunNum = LoadSave.loader.nCurBodyGunNum;
        Sprites.nBodyTotal = LoadSave.loader.nBodyTotal;
        Sprites.nChunkTotal = LoadSave.loader.nChunkTotal;
        Globals.nRadialSpr = LoadSave.loader.nRadialSpr;
        Globals.nRadialDamage = LoadSave.loader.nRadialDamage;
        Globals.nDamageRadius = LoadSave.loader.nDamageRadius;
        Globals.nRadialOwner = LoadSave.loader.nRadialOwner;
        Globals.nRadialBullet = LoadSave.loader.nRadialBullet;
        Globals.nDronePitch = LoadSave.loader.nDronePitch;
        Globals.nFinaleSpr = LoadSave.loader.nFinaleSpr;
        Globals.nFinaleStage = LoadSave.loader.nFinaleStage;
        Globals.lFinaleStart = LoadSave.loader.lFinaleStart;
        Globals.nSmokeSparks = LoadSave.loader.nSmokeSparks;
    }

    private static void loadEnemies() {
        Anubis.loadAnubis(loader, null);
        Fish.loadFish(loader, null);
        LavaDude.loadLava(loader, null);
        Lion.loadLion(loader, null);
        Mummy.loadMummy(loader, null);
        Queen.loadQueen(loader, null);
        Ra.loadRa(loader, null);
        Rat.loadRat(loader, null);
        Rex.loadRex(loader, null);
        Roach.loadRoach(loader, null);
        Scorp.loadScorp(loader, null);
        Set.loadSet(loader, null);
        Spider.loadSpider(loader, null);
        Wasp.loadWasp(loader, null);
    }

    private static void loadSectors() {
        Light.loadLights(loader, null);
        Object.loadElevs(loader, null);
        Object.loadBobs(loader, null);
        Sector.loadMoves(loader, null);
        Object.loadTrails(loader, null);
        Sector.loadPushBlocks(loader, null);
        Slide.loadSlide(loader, null);
        Switch.loadSwitches(loader, null);
        Sector.loadLinks(loader, null);
        Sector.loadSecExtra(loader, null);
        Globals.nEnergyChan = LoadSave.loader.nEnergyChan;
        Globals.nEnergyBlocks = LoadSave.loader.nEnergyBlocks;
        Globals.nEnergyTowers = LoadSave.loader.nEnergyTowers;
        Map.nSwitchSound = LoadSave.loader.nSwitchSound;
        Map.nStoneSound = LoadSave.loader.nStoneSound;
        Map.nElevSound = LoadSave.loader.nElevSound;
        Map.nStopSound = LoadSave.loader.nStopSound;
        Globals.lCountDown = LoadSave.loader.lCountDown;
        Globals.nAlarmTicks = LoadSave.loader.nAlarmTicks;
        Globals.nRedTicks = LoadSave.loader.nRedTicks;
        Globals.nClockVal = LoadSave.loader.nClockVal;
        Globals.nButtonColor = LoadSave.loader.nButtonColor;
        Engine.pskyoff[0] = 0;
        Engine.pskyoff[1] = 0;
        Engine.pskyoff[2] = 0;
        Engine.pskyoff[3] = 0;
        Engine.parallaxtype = 0;
        Engine.visibility = 1024;
        Engine.parallaxyoffs = 256;
        Engine.pskybits = (short)2;
    }

    private static void loadFM() {
        Globals.levelnum = LoadSave.loader.level;
        Globals.lastlevel = LoadSave.loader.lastlevel;
        LoadSave.loadMap();
        Anim.loadAnm(loader, null);
        LoadSave.loadSprites();
        LoadSave.loadSectors();
        Object.loadWallFaces(loader, null);
        RunList.loadRunList(loader, null);
        LoadSave.loadPlayer();
        Random.loadRandom(loader, null);
        Palette.GrabPalette();
        if (Globals.levelnum == 20) {
            Energy.InitEnergyTile();
            Arrays.fill(Main.engine.loadtile(3603), (byte)-1);
        }
        Globals.totalmoves = LoadSave.loader.totalmoves;
        Globals.moveframes = LoadSave.loader.moveframes;
    }

    public static void quicksave() {
        if (Mmulti.numplayers > 1 || gClassicMode) {
            return;
        }
        if (Globals.PlayerList[Globals.nLocalPlayer].HealthAmount != 0) {
            gQuickSaving = true;
        }
    }

    public static boolean canLoad(final String filename) {
        FileResource fil = BuildGdx.compat.open(filename, Compat.Path.User, FileResource.Mode.Read);
        if (fil != null) {
            int nVersion = LoadSave.checkSave(fil) & 0xFFFF;
            if (nVersion != 100) {
                if (nVersion >= 100) {
                    final EpisodeInfo addon = loader.LoadGDXHeader(fil);
                    if (LoadSave.loader.level <= 20 && LoadSave.loader.warp_on != 1) {
                        MenuCorruptGame menu = (MenuCorruptGame)Main.game.menu.mMenus[12];
                        menu.setRunnable(new Runnable(){

                            @Override
                            public void run() {
                                EpisodeInfo game = addon != null ? addon : Globals.gOriginalEpisode;
                                Globals.levelnew = LoadSave.loader.level;
                                if (LoadSave.loader.gClassicMode) {
                                    nSaveFile = filename;
                                    nSaveName = LoadSave.loader.savename;
                                } else {
                                    nSaveName = null;
                                    nSaveFile = null;
                                }
                                Main.gGameScreen.newgame(game, Globals.levelnew, LoadSave.loader.gClassicMode);
                                Globals.nBestLevel = LoadSave.loader.best;
                            }
                        });
                        Main.game.menu.mOpen(menu, -1);
                    }
                }
                fil.close();
                return false;
            }
            fil.close();
            return true;
        }
        return false;
    }

    public static void quickload() {
        if (Mmulti.numplayers > 1 || gClassicMode) {
            return;
        }
        final String loadname = Main.game.pSavemgr.getLast();
        if (loadname != null && LoadSave.canLoad(loadname)) {
            Main.game.changeScreen(Main.gLoadingScreen);
            Main.gLoadingScreen.init(new Runnable(){

                @Override
                public void run() {
                    if (!LoadSave.loadgame(loadname)) {
                        Main.game.setPrevScreen();
                        if (Main.game.isCurrentScreen(Main.gGameScreen)) {
                            Main.game.pNet.ready2send = true;
                            View.StatusMessage(500, "Incompatible version of saved game found!", Globals.nLocalPlayer);
                        }
                    }
                }
            });
        }
    }

    public static String makeNum(int num) {
        LoadSave.filenum[3] = (char)(num % 10 + 48);
        LoadSave.filenum[2] = (char)(num / 10 % 10 + 48);
        LoadSave.filenum[1] = (char)(num / 100 % 10 + 48);
        LoadSave.filenum[0] = (char)(num / 1000 % 10 + 48);
        return new String(filenum);
    }

    public static void SaveVersion(FileResource fil, int nVersion) {
        fil.writeBytes(savsign.toCharArray(), 4);
        fil.writeShort(nVersion);
    }

    public static void SaveHeader(FileResource fil, String savename, long time, int level, int best, boolean gClassicMode) {
        LoadSave.SaveVersion(fil, 100);
        byte[] buf = new byte[8];
        LittleEndian.putLong(buf, 0, time);
        fil.writeBytes(buf, 8);
        fil.writeBytes(savename.toCharArray(), 32);
        fil.writeByte(gClassicMode ? 1 : 0);
        fil.writeShort(level);
        fil.writeShort(best);
    }

    public static void SaveGDXBlock(FileResource fil) {
        ByteBuffer bb = ByteBuffer.allocate(16273);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        boolean hasCapt = Main.gGameScreen != null && Main.gGameScreen.captBuffer != null;
        bb.put(hasCapt ? (byte)1 : 0);
        if (hasCapt) {
            bb.put(Main.gGameScreen.captBuffer);
            Main.gGameScreen.captBuffer = null;
        }
        byte warp_on = 0;
        if (Globals.mUserFlag == Main.UserFlag.UserMap) {
            warp_on = 1;
        }
        if (Globals.mUserFlag == Main.UserFlag.Addon) {
            warp_on = 2;
        }
        bb.put(warp_on);
        byte[] name = new byte[144];
        if (warp_on == 2) {
            if (Globals.gCurrentEpisode != null) {
                bb.put(Globals.gCurrentEpisode.packed ? (byte)1 : 0);
                if (Globals.gCurrentEpisode.path != null) {
                    String path = Globals.gCurrentEpisode.path;
                    System.arraycopy(path.getBytes(), 0, name, 0, Math.min(path.length(), 144));
                }
            }
        } else if (Globals.boardfilename != null) {
            System.arraycopy(Globals.boardfilename.getBytes(), 0, name, 0, Math.min(Globals.boardfilename.length(), 144));
        }
        bb.put(name);
        fil.writeBytes(bb.array(), 16273);
    }

    public static int savegame(String savename, String filename) {
        FileResource fil;
        File file = BuildGdx.compat.checkFile(filename, Compat.Path.User);
        if (file != null) {
            file.delete();
        }
        if ((fil = BuildGdx.compat.open(filename, Compat.Path.User, FileResource.Mode.Write)) != null) {
            long time = Main.game.date.getCurrentDate();
            LoadSave.save(fil, savename, time, Globals.levelnum, Globals.nBestLevel, gClassicMode);
            Main.game.pSavemgr.add(savename, time, filename);
            lastload = filename;
            return 0;
        }
        View.StatusMessage(500, "Game not saved. Access denied!", Globals.nLocalPlayer);
        return -1;
    }

    private static void save(FileResource fil, String savename, long time, int level, int best, boolean classic) {
        LoadSave.SaveHeader(fil, savename, time, level, best, classic);
        LoadSave.SaveGDXBlock(fil);
        if (classic) {
            fil.writeShort(Globals.nPlayerWeapons[Globals.nLocalPlayer]);
            fil.writeShort(Globals.PlayerList[Globals.nLocalPlayer].currentWeapon);
            fil.writeShort(Globals.nPlayerClip[Globals.nLocalPlayer]);
            fil.writeShort(Globals.nPlayerItem[Globals.nLocalPlayer]);
            fil.writeBytes(Globals.PlayerList[Globals.nLocalPlayer].getBytes(false), PlayerStruct.size(false));
            fil.writeShort(Globals.nPlayerLives[Globals.nLocalPlayer]);
        } else {
            LoadSave.saveFM(fil);
        }
        fil.close();
        System.gc();
        View.StatusMessage(500, "Game saved", Globals.nLocalPlayer);
    }

    private static void saveFM(FileResource fil) {
        fil.writeInt(Globals.lastlevel);
        LoadSave.saveMap(fil);
        fil.writeBytes(Anim.saveAnm());
        LoadSave.saveSprites(fil);
        LoadSave.saveSectors(fil);
        fil.writeBytes(Object.saveWallFaces());
        fil.writeBytes(RunList.saveRunList());
        LoadSave.savePlayer(fil);
        fil.writeBytes(Random.saveRandom());
        fil.writeInt(Globals.totalmoves);
        fil.writeInt(Globals.moveframes);
    }

    private static void saveMap(FileResource fil) {
        int bufsize = 2 + Engine.numsectors * 40 + 2 + Engine.numwalls * 32 + Engine.MAXSPRITES * 44 + (Engine.MAXSECTORS + 1) * 2 + 2050 + Engine.MAXSPRITES * 8;
        ByteBuffer bb = ByteBuffer.allocate(bufsize);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort(Engine.numwalls);
        int w = 0;
        while (w < Engine.numwalls) {
            bb.put(Engine.wall[w].getBytes());
            ++w;
        }
        bb.putShort(Engine.numsectors);
        int s = 0;
        while (s < Engine.numsectors) {
            bb.put(Engine.sector[s].getBytes());
            ++s;
        }
        int i = 0;
        while (i < Engine.MAXSPRITES) {
            bb.put(Engine.sprite[i].getBytes());
            ++i;
        }
        i = 0;
        while (i <= Engine.MAXSECTORS) {
            bb.putShort(Engine.headspritesect[i]);
            ++i;
        }
        i = 0;
        while (i <= 1024) {
            bb.putShort(Engine.headspritestat[i]);
            ++i;
        }
        i = 0;
        while (i < Engine.MAXSPRITES) {
            bb.putShort(Engine.prevspritesect[i]);
            bb.putShort(Engine.prevspritestat[i]);
            bb.putShort(Engine.nextspritesect[i]);
            bb.putShort(Engine.nextspritestat[i]);
            ++i;
        }
        fil.writeBytes(bb);
    }

    private static void savePlayer(FileResource fil) {
        fil.writeBytes(Globals.PlayerList[Globals.nLocalPlayer].getBytes(true), PlayerStruct.size(true));
        fil.writeShort(Mmulti.connecthead);
        fil.writeBytes(Mmulti.connectpoint2, 8);
        fil.writeByte(Light.bTorch);
        fil.writeInt(Globals.nFreeze);
        fil.writeInt(Globals.nXDamage[Globals.nLocalPlayer]);
        fil.writeInt(Globals.nYDamage[Globals.nLocalPlayer]);
        fil.writeShort(Globals.nDoppleSprite[Globals.nLocalPlayer]);
        fil.writeShort(Globals.nPlayerClip[Globals.nLocalPlayer]);
        fil.writeShort(Globals.nPistolClip[Globals.nLocalPlayer]);
        fil.writeShort(Globals.nPlayerTorch[Globals.nLocalPlayer]);
        fil.writeShort(Globals.nPlayerWeapons[Globals.nLocalPlayer]);
        fil.writeShort(Globals.nPlayerLives[Globals.nLocalPlayer]);
        fil.writeShort(Globals.nPlayerItem[Globals.nLocalPlayer]);
        fil.writeShort(Globals.nPlayerInvisible[Globals.nLocalPlayer]);
        fil.writeShort(Globals.nPlayerDouble[Globals.nLocalPlayer]);
        fil.writeShort(Globals.nPlayerViewSect[Globals.nLocalPlayer]);
        fil.writeShort(Globals.nPlayerFloorSprite[Globals.nLocalPlayer]);
        fil.writeShort(Globals.nPlayerScore[Globals.nLocalPlayer]);
        fil.writeShort(Globals.nPlayerGrenade[Globals.nLocalPlayer]);
        fil.writeShort(Globals.nPlayerSnake[Globals.nLocalPlayer]);
        fil.writeShort((short)Globals.nDestVertPan[Globals.nLocalPlayer]);
        fil.writeShort(Globals.dVertPan[Globals.nLocalPlayer]);
        fil.writeShort(Globals.nDeathType[Globals.nLocalPlayer]);
        fil.writeShort(Globals.nQuake[Globals.nLocalPlayer]);
        fil.writeByte(Globals.bTouchFloor[Globals.nLocalPlayer] ? 1 : 0);
        fil.writeInt(Globals.initx);
        fil.writeInt(Globals.inity);
        fil.writeInt(Globals.initz);
        fil.writeShort(Globals.inita);
        fil.writeShort(Globals.initsect);
        fil.writeBytes(Engine.show2dsector);
        fil.writeBytes(Engine.show2dwall);
        fil.writeBytes(Engine.show2dsprite);
    }

    private static void saveEnemies(FileResource fil) {
        fil.writeBytes(Anubis.saveAnubis());
        fil.writeBytes(Fish.saveFish());
        fil.writeBytes(LavaDude.saveLava());
        fil.writeBytes(Lion.saveLion());
        fil.writeBytes(Mummy.saveMummy());
        fil.writeBytes(Queen.saveQueen());
        fil.writeBytes(Ra.saveRa());
        fil.writeBytes(Rat.saveRat());
        fil.writeBytes(Rex.saveRex());
        fil.writeBytes(Roach.saveRoach());
        fil.writeBytes(Scorp.saveScorp());
        fil.writeBytes(Set.saveSet());
        fil.writeBytes(Spider.saveSpider());
        fil.writeBytes(Wasp.saveWasp());
    }

    private static void saveSprites(FileResource fil) {
        LoadSave.saveEnemies(fil);
        fil.writeBytes(Bullet.saveBullets());
        fil.writeBytes(Grenade.saveGrenades());
        fil.writeBytes(Sprites.saveBubbles());
        fil.writeBytes(Snake.saveSnakes());
        fil.writeBytes(Object.saveObjects());
        fil.writeBytes(Object.saveTraps());
        fil.writeBytes(Object.saveDrips());
        fil.writeShort(Globals.nCreaturesLeft);
        fil.writeShort(Globals.nCreaturesMax);
        fil.writeShort(SpiritHead.nSpiritSprite);
        fil.writeShort(Globals.nMagicCount);
        fil.writeShort(Map.nRegenerates);
        fil.writeShort(Map.nFirstRegenerate);
        fil.writeShort(Globals.nNetStartSprites);
        fil.writeShort(Globals.nCurStartSprite);
        fil.writeShort(Globals.nNetPlayerCount);
        fil.writeBytes(Globals.nNetStartSprite, 8);
        fil.writeBytes(Sprites.nChunkSprite, Sprites.nChunkSprite.length);
        fil.writeBytes(Sprites.nBodyGunSprite, Sprites.nBodyGunSprite.length);
        fil.writeBytes(Sprites.nBodySprite, Sprites.nBodySprite.length);
        fil.writeShort(Sprites.nCurChunkNum);
        fil.writeShort(Sprites.nCurBodyNum);
        fil.writeShort(Sprites.nCurBodyGunNum);
        fil.writeShort(Sprites.nBodyTotal);
        fil.writeShort(Sprites.nChunkTotal);
        fil.writeShort(Globals.nRadialSpr);
        fil.writeShort(Globals.nRadialDamage);
        fil.writeShort(Globals.nDamageRadius);
        fil.writeShort(Globals.nRadialOwner);
        fil.writeShort(Globals.nRadialBullet);
        fil.writeShort(Globals.nDronePitch);
        fil.writeShort(Globals.nFinaleSpr);
        fil.writeShort(Globals.nFinaleStage);
        fil.writeShort(Globals.lFinaleStart);
        fil.writeShort(Globals.nSmokeSparks);
    }

    private static void saveSectors(FileResource fil) {
        fil.writeBytes(Light.saveLights());
        fil.writeBytes(Object.saveElevs());
        fil.writeBytes(Object.saveBobs());
        fil.writeBytes(Sector.saveMoves());
        fil.writeBytes(Object.saveTrails());
        fil.writeBytes(Sector.savePushBlocks());
        fil.writeBytes(Slide.saveSlide());
        fil.writeBytes(Switch.saveSwitches());
        fil.writeBytes(Sector.saveLinks());
        fil.writeBytes(Sector.saveSecExtra());
        fil.writeShort(Globals.nEnergyChan);
        fil.writeShort(Globals.nEnergyBlocks);
        fil.writeShort(Globals.nEnergyTowers);
        fil.writeShort(Map.nSwitchSound);
        fil.writeShort(Map.nStoneSound);
        fil.writeShort(Map.nElevSound);
        fil.writeShort(Map.nStopSound);
        fil.writeInt(Globals.lCountDown);
        fil.writeShort(Globals.nAlarmTicks);
        fil.writeShort(Globals.nRedTicks);
        fil.writeShort(Globals.nClockVal);
        fil.writeShort(Globals.nButtonColor);
    }
}

