/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Audio.BuildAudio;
import ru.m210projects.Build.Audio.MusicSource;
import ru.m210projects.Build.Audio.Sound;
import ru.m210projects.Build.Audio.Source;
import ru.m210projects.Build.Audio.SourceCallback;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Script.CueScript;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.WALL;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Map;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Snake;
import ru.m210projects.Powerslave.SoundResource;

public class Sound {
    private static SourceCallback<Integer> callback = new SourceCallback<Integer>(){

        @Override
        public void run(Integer ch) {
            if (Sound.sActiveSound[ch.intValue()].pHandle != null) {
                Sound.sActiveSound[ch.intValue()].pHandle.dispose();
            }
            Sound.sActiveSound[ch.intValue()].pHandle = null;
            Sound.sActiveSound[ch.intValue()].rate = 0;
        }
    };
    public static String[] SoundFiles = new String[]{"spl_big", "spl_smal", "bubble_l", "grn_drop", "p_click", "grn_roll", "cosprite", "m_chant0", "anu_icu", "item_reg", "item_spe", "item_key", "torch_on", "jon_bnst", "jon_gasp", "jon_land", "jon_gags", "jon_fall", "jon_drwn", "jon_air1", "jon_glp1", "jon_bbwl", "jon_pois", "amb_ston", "cat_icu", "bubble_h", "set_land", "jon_hlnd", "jon_laf2", "spi_jump", "jon_scub", "item_use", "tr_arrow", "swi_foot", "swi_ston", "swi_wtr1", "tr_fire", "m_skull5", "spi_atak", "anu_hit", "fishdies", "scrp_icu", "jon_wade", "amb_watr", "tele_1", "wasp_stg", "res", "drum4", "rex_icu", "m_hits_u", "q_tail", "vatr_mov", "jon_hit3", "jon_t_2", "jon_t_1", "jon_t_5", "jon_t_6", "jon_t_8", "jon_t_4", "rasprit1", "jon_fdie", "wijaf1", "ship_1", "saw_on", "ra_on", "amb_ston", "vatr_stp", "mana1", "mana2", "ammo", "pot_pc1", "pot_pc2", "weapon", "alarm", "tick1", "scrp_zap", "jon_t_3", "jon_laf1", "blasted", "jon_air2"};
    public static int nWaspSound = -1;
    public static int[] StaticSound = new int[80];
    public static SoundResource[] SoundBufs = new SoundResource[200];
    public static String[] szSoundName = new String[200];
    public static int nSoundCount;
    public static int soundx;
    public static int soundy;
    public static int soundz;
    public static int soundsect;
    public static int nLocalSectFlags;
    public static int nAmbientChannel;
    public static int nLocalChan;
    public static ActiveSound[] sActiveSound;
    public static int nNextFreq;
    public static int nSwirlyFrames;
    public static String[] cdtracks;
    public static int currTrack;
    public static MusicSource currMusic;
    private static int pSoundVolume;
    private static int pSoundPitch;

    static {
        nAmbientChannel = -1;
        currTrack = -1;
        currMusic = null;
    }

    public static void sndInit() {
        if (Main.cfg.maxvoices < 8) {
            Main.cfg.maxvoices = 8;
        }
        if (BuildGdx.audio.getSound().init(Sound.SystemType.Stereo, Main.cfg.maxvoices, Main.cfg.resampler_num)) {
            BuildGdx.audio.setVolume(BuildAudio.Driver.Sound, Main.cfg.soundVolume);
        } else {
            Console.Println(String.valueOf(BuildGdx.audio.getName(BuildAudio.Driver.Sound)) + " initialization failed", Console.OSDTEXT_RED);
        }
        if (!BuildGdx.audio.getMusic().init()) {
            Console.Println(String.valueOf(BuildGdx.audio.getName(BuildAudio.Driver.Music)) + " initialization failed", Console.OSDTEXT_RED);
        }
        if (!Main.cfg.muteMusic) {
            BuildGdx.audio.setVolume(BuildAudio.Driver.Music, Main.cfg.musicVolume);
        } else {
            BuildGdx.audio.setVolume(BuildAudio.Driver.Music, 0.0f);
        }
        Globals.nCreepyTimer = 180;
        Sound.InitSoundInfo(Main.cfg.maxvoices);
    }

    private static void InitSoundInfo(int voices) {
        sActiveSound = new ActiveSound[voices];
        int i = 0;
        while (i < sActiveSound.length) {
            Sound.sActiveSound[i] = new ActiveSound();
            Sound.sActiveSound[i].ambchannel = i;
            ++i;
        }
    }

    public static void GetSpriteSoundPitch(int nSector, int pVolume, int pPitch) {
        if (!Gameutils.isValidSector(nSector)) {
            return;
        }
        pSoundVolume = pVolume;
        pSoundPitch = pPitch;
        if (((nLocalSectFlags ^ Globals.SectFlag[nSector]) & 0x2000) != 0) {
            pSoundVolume >>= 1;
            pSoundPitch -= 1200;
        }
    }

    public static boolean midRestart() {
        Sound.StopMusic();
        if (!BuildGdx.audio.getMusic().init()) {
            Console.Println(String.valueOf(BuildGdx.audio.getName(BuildAudio.Driver.Music)) + " initialization failed", Console.OSDTEXT_RED);
            return false;
        }
        return true;
    }

    public static boolean sndRestart(int nvoices, int resampler) {
        BuildGdx.audio.getSound().stopAllSounds();
        BuildGdx.audio.getSound().uninit();
        Main.cfg.maxvoices = nvoices;
        Console.Println("Sound restarting...");
        if (!BuildGdx.audio.getSound().init(Sound.SystemType.Stereo, nvoices, resampler)) {
            Console.Println(String.valueOf(BuildGdx.audio.getName(BuildAudio.Driver.Sound)) + " initialization failed", Console.OSDTEXT_RED);
            return false;
        }
        BuildGdx.audio.setVolume(BuildAudio.Driver.Sound, Main.cfg.soundVolume);
        Sound.InitSoundInfo(Main.cfg.maxvoices);
        return true;
    }

    public static int GetFrameSound(int a1, int a2) {
        if (a1 == -1 || a2 + Seq.SeqBase[a1] == -1) {
            return -1;
        }
        return Seq.FrameSound[a2 + Seq.SeqBase[a1]];
    }

    public static void LoadFX() {
        int i = 0;
        while (i < 80) {
            Sound.StaticSound[i] = Sound.LoadSound(SoundFiles[i]);
            ++i;
        }
    }

    public static void StartElevSound(short a1, int a2) {
        if ((a2 & 2) != 0) {
            Sound.D3PlayFX(StaticSound[Map.nElevSound], a1);
        } else {
            Sound.D3PlayFX(StaticSound[Map.nStoneSound], a1);
        }
    }

    public static int LoadSound(String name) {
        int i = 0;
        while (i < nSoundCount) {
            if (szSoundName[i].equalsIgnoreCase(name)) {
                return i;
            }
            ++i;
        }
        if (nSoundCount >= 200) {
            Main.game.ThrowError("Too many sounds being loaded... increase array size");
            return -1;
        }
        byte[] data = BuildGdx.cache.getBytes(String.valueOf(name) + ".voc", 1);
        if (data == null) {
            Console.Println("Sound " + name + " not found.", Console.OSDTEXT_RED);
            return -1;
        }
        if (name.equals("WASP_WNG")) {
            nWaspSound = nSoundCount;
        }
        Sound.szSoundName[Sound.nSoundCount] = name;
        Sound.SoundBufs[Sound.nSoundCount] = new SoundResource(data, nSoundCount);
        return nSoundCount++;
    }

    public static void sndHandlePause(boolean gPaused) {
        if (gPaused) {
            if (currMusic != null) {
                currMusic.pause();
            }
            BuildGdx.audio.getSound().stopAllSounds();
        } else if (!Main.cfg.muteMusic && currMusic != null) {
            currMusic.resume();
        }
    }

    public static void searchCDtracks() {
        for (FileEntry file : BuildGdx.compat.getDirectory(Compat.Path.Game).getFiles().values()) {
            if (!file.getExtension().equals("cue")) continue;
            CueScript cdTracks = new CueScript(file);
            cdtracks = cdTracks.getTracks();
            int numtracks = cdtracks.length;
            int i = 0;
            while (i < cdtracks.length) {
                if (!BuildGdx.cache.contains(cdtracks[i], 0)) {
                    Sound.cdtracks[i] = null;
                    --numtracks;
                }
                ++i;
            }
            Console.Println(String.valueOf(numtracks) + " cd tracks found...");
            return;
        }
        Console.Println("Cd tracks not found.");
    }

    public static boolean MusicPlaying() {
        return currMusic != null && currMusic.isPlaying();
    }

    public static boolean playCDtrack(int nTrack, boolean loop) {
        if (nTrack < 0) {
            return false;
        }
        if (Sound.MusicPlaying() && currTrack == nTrack) {
            return true;
        }
        MusicSource mus = null;
        if (cdtracks != null && nTrack > 0 && nTrack <= cdtracks.length && cdtracks[nTrack - 1] != null && (mus = BuildGdx.audio.newMusic(BuildAudio.MusicType.Digital, cdtracks[nTrack - 1])) != null) {
            Sound.StopMusic();
            currMusic = mus;
            currTrack = nTrack;
            currMusic.play(loop);
            return true;
        }
        return false;
    }

    public static void sndPlayMusic() {
        if (!Main.cfg.muteMusic) {
            BuildGdx.audio.setVolume(BuildAudio.Driver.Music, Main.cfg.musicVolume);
        } else {
            BuildGdx.audio.setVolume(BuildAudio.Driver.Music, 0.0f);
        }
        if (Globals.mUserFlag != Main.UserFlag.UserMap) {
            int num = Globals.levelnum;
            if (Globals.levelnum != 0) {
                num = Globals.levelnum - 1;
            }
            Sound.playCDtrack(num % 8 + 11, true);
        } else if (!Sound.MusicPlaying()) {
            int num = (int)(Math.random() * 8.0 + 11.0);
            Sound.playCDtrack(num, true);
        }
    }

    public static void StopMusic() {
        if (currMusic != null) {
            currMusic.stop();
        }
        currTrack = -1;
        currMusic = null;
    }

    public static void StopAllSounds() {
        BuildGdx.audio.getSound().stopAllSounds();
        int i = 0;
        while (i < sActiveSound.length) {
            if (Sound.sActiveSound[i].pHandle != null) {
                Sound.sActiveSound[i].pHandle.dispose();
            }
            Sound.sActiveSound[i].pHandle = null;
            Sound.sActiveSound[i].rate = 0;
            ++i;
        }
        nAmbientChannel = -1;
    }

    public static Source PlayLocalSound(int soundid, int rateoffs) {
        Source hVoice;
        if (Main.cfg.noSound || !BuildGdx.audio.IsInited(BuildAudio.Driver.Sound) || soundid < 0 || soundid >= SoundBufs.length) {
            return null;
        }
        if (nAmbientChannel == nLocalChan) {
            nAmbientChannel = -1;
        }
        ActiveSound pSound = sActiveSound[nLocalChan];
        SoundResource res = SoundBufs[soundid];
        if (res == null) {
            return null;
        }
        int rate = res.rate;
        if (rateoffs != 0) {
            rate += rateoffs;
        }
        if ((hVoice = BuildGdx.audio.newSound(res.ptr, rate, res.bits, 255)) != null) {
            if (Sound.LocalSoundPlaying()) {
                Sound.StopLocalSound();
            }
            if (res.loop) {
                hVoice.setLooping(true, 0, -1);
            }
            hVoice.setGlobal(1);
            hVoice.play(255.0f);
            pSound.pHandle = hVoice;
            pSound.rate = rate;
            pSound.soundnum = soundid;
            Sound.SetLocalChan(0);
            return hVoice;
        }
        return null;
    }

    public static void CheckAmbience(int sect) {
        if (Gameutils.isValidSector(sect) && Globals.SectSound[sect] != -1) {
            short nSourceSect = Globals.SectSoundSect[sect];
            WALL pWall = Engine.wall[Engine.sector[nSourceSect].wallptr];
            if (nAmbientChannel < 0) {
                Sound.PlayFXAtXYZ(Globals.SectSound[sect] | 0x4000, pWall.x, pWall.y, Engine.sector[nSourceSect].floorz, sect);
                return;
            }
            ActiveSound pSound = sActiveSound[nAmbientChannel];
            if (sect == nSourceSect) {
                SPRITE pPlayer = Engine.sprite[Globals.PlayerList[Globals.nLocalPlayer].spriteId];
                pSound.x = pPlayer.x;
                pSound.y = pPlayer.y;
                pSound.z = pPlayer.z;
            } else {
                pSound.x = pWall.x;
                pSound.y = pWall.y;
                pSound.z = Engine.sector[nSourceSect].floorz;
            }
            return;
        }
        if (nAmbientChannel != -1) {
            if (Sound.sActiveSound[Sound.nAmbientChannel].pHandle != null) {
                Sound.sActiveSound[Sound.nAmbientChannel].pHandle.dispose();
            }
            Sound.sActiveSound[Sound.nAmbientChannel].pHandle = null;
            Sound.sActiveSound[Sound.nAmbientChannel].rate = 0;
            nAmbientChannel = -1;
        }
    }

    public static void StopLocalSound() {
        if (nLocalChan == nAmbientChannel) {
            nAmbientChannel = -1;
        }
        if (Sound.LocalSoundPlaying()) {
            Sound.sActiveSound[Sound.nLocalChan].pHandle.dispose();
        }
        Sound.sActiveSound[Sound.nLocalChan].pHandle = null;
        Sound.sActiveSound[Sound.nLocalChan].rate = 0;
    }

    public static void StopSpriteSound(int nSprite) {
        if (Main.cfg.noSound || !BuildGdx.audio.IsInited(BuildAudio.Driver.Sound)) {
            return;
        }
        int i = 0;
        while (i < sActiveSound.length) {
            if (Sound.SoundPlaying(i) && nSprite == Sound.sActiveSound[i].spr) {
                Sound.sActiveSound[i].pHandle.dispose();
                Sound.sActiveSound[i].pHandle = null;
                Sound.sActiveSound[i].rate = 0;
                break;
            }
            ++i;
        }
    }

    public static void BendAmbientSound() {
        if (Main.cfg.noSound || !BuildGdx.audio.IsInited(BuildAudio.Driver.Sound)) {
            return;
        }
        if (nAmbientChannel >= 0) {
            ActiveSound pSound = sActiveSound[nAmbientChannel];
            if (pSound.pHandle != null) {
                pSound.pHandle.setPitch((float)(Globals.nDronePitch + 11000) / (float)pSound.rate);
            }
        }
    }

    public static int PlayFXAtXYZ(int soundid, int x, int y, int z, int sect) {
        if (Main.cfg.noSound || !BuildGdx.audio.IsInited(BuildAudio.Driver.Sound)) {
            return -1;
        }
        soundx = x;
        soundy = y;
        soundz = z;
        soundsect = sect & Engine.MAXSECTORS - 1;
        int num = Sound.PlayFX2(soundid, -1);
        if (num != -1 && (sect & 0x4000) != 0) {
            Sound.sActiveSound[num].asound_C = 2000;
        }
        return num;
    }

    public static void D3PlayFX(int soundid, int nSprite) {
        Sound.PlayFX2(soundid, nSprite);
    }

    public static int PlayFX2(int soundid, int nSprite) {
        int vol;
        if (Main.cfg.noSound || !BuildGdx.audio.IsInited(BuildAudio.Driver.Sound)) {
            return -1;
        }
        nLocalSectFlags = Globals.SectFlag[Globals.nPlayerViewSect[Globals.nLocalPlayer]];
        boolean v33 = false;
        boolean v11 = false;
        if (nSprite >= 0) {
            v33 = (nSprite & 0x2000) != 0;
            v11 = (nSprite & 0x4000) != 0;
            soundx = Engine.sprite[nSprite &= 0xFFF].x;
            soundy = Engine.sprite[nSprite].y;
            soundz = Engine.sprite[nSprite].z;
            soundsect = Engine.sprite[nSprite].sectnum;
        }
        int dx = Globals.initx - soundx >> 8;
        int dy = Globals.inity - soundy >> 8;
        int dist = Sound.GetDistFromDXDY(dx, dy);
        int n = vol = v33 ? 255 : Gameutils.BClipRange(265 - (Engine.sintable[2 * dist & 0x7FF] >> 6), 0, 255);
        if (dist >= 255 || vol == 0) {
            if (nSprite >= 0) {
                Sound.StopSpriteSound(nSprite);
            }
            return -1;
        }
        int v37 = soundid & 0xFE00;
        boolean v39 = (soundid & 0x2000) != 0;
        boolean v38 = (soundid & 0x1000) != 0;
        boolean v35 = (soundid & 0x4000) != 0;
        int v29 = Integer.MAX_VALUE;
        int v36 = (soundid & 0xE00) >> 9;
        soundid &= 0x1FF;
        int v32 = 0;
        if (v38 || v35) {
            v32 = 1000;
        } else if (nSprite != -1 && v11) {
            v32 = 2000;
        }
        int nFree = 0;
        int v30 = 0;
        int v26 = 0;
        if (soundid < 0 || soundid >= SoundBufs.length) {
            return -1;
        }
        int i = 1;
        while (i < sActiveSound.length) {
            if (Sound.SoundPlaying(i)) {
                ActiveSound pSound = sActiveSound[i];
                if (v32 >= pSound.asound_C) {
                    if (v29 > pSound.clock && pSound.asound_C == v32) {
                        v30 = i;
                        v29 = pSound.clock;
                    }
                    if (!v38) {
                        if (soundid == pSound.soundnum) {
                            if (!v39 && nSprite == pSound.spr) {
                                return -1;
                            }
                            v26 = i;
                        } else if (nSprite == pSound.spr && (v39 || soundid != pSound.soundnum)) {
                            nFree = i;
                            break;
                        }
                    }
                }
            } else {
                nFree = i;
            }
            ++i;
        }
        while (true) {
            if (nFree != 0) {
                SoundResource res;
                ActiveSound pFree = sActiveSound[nFree];
                if (pFree.pHandle != null && pFree.pHandle.isActive()) {
                    pFree.pHandle.dispose();
                    if (pFree.ambchannel == nAmbientChannel) {
                        nAmbientChannel = -1;
                    }
                    pFree.pHandle = null;
                    pFree.rate = 0;
                }
                if ((res = SoundBufs[soundid]) == null) {
                    return -1;
                }
                if (!Main.cfg.bWaspSound && soundid == nWaspSound) {
                    return -1;
                }
                int rate = res.rate;
                int pitch = 0;
                if (v36 != 0) {
                    pitch = -16 * (Globals.totalmoves & (1 << v36) - 1);
                }
                if (pitch != 0) {
                    rate += pitch;
                }
                pFree.oldpitch = pitch += rate;
                pFree.oldvolume = vol;
                if (nSprite < 0) {
                    pFree.x = soundx;
                    pFree.y = soundy;
                    pFree.z = soundz;
                    pFree.sectnum = soundsect;
                }
                Sound.GetSpriteSoundPitch(soundsect, vol, pitch);
                pFree.pitch = pSoundPitch;
                pFree.volume = pSoundVolume;
                pFree.spr = nSprite;
                pFree.soundnum = soundid;
                pFree.clock = Engine.totalclock;
                pFree.asound_C = v32;
                pFree.ambient = v37;
                Source hVoice = BuildGdx.audio.newSound(res.ptr, rate, res.bits, 255);
                if (hVoice != null) {
                    boolean isPlayer;
                    boolean bl = isPlayer = nSprite == Globals.PlayerList[Globals.nLocalPlayer].spriteId;
                    if (res.loop) {
                        hVoice.setLooping(true, 0, -1);
                    }
                    if (isPlayer) {
                        hVoice.setGlobal(1);
                    } else {
                        hVoice.setPosition(soundx, soundz >> 4, soundy);
                    }
                    hVoice.setCallback(callback, nFree);
                    hVoice.play((float)vol / 255.0f);
                    if (v35) {
                        nAmbientChannel = pFree.ambchannel;
                    }
                    if (!isPlayer && Gameutils.isValidSprite(nSprite) && (Engine.sprite[nSprite].cstat & 0x101) != 0) {
                        Globals.nCreepyTimer = 180;
                    }
                    pFree.pHandle = hVoice;
                    pFree.rate = rate;
                    return pFree.ambchannel;
                }
                return -1;
            }
            if (v26 != 0) {
                nFree = v26;
                continue;
            }
            if (v30 == 0) break;
            nFree = v30;
        }
        return -1;
    }

    public static int GetDistFromDXDY(int dx, int dy) {
        return (dx * dx + dy * dy >> 3) - (dx * dx + dy * dy >> 5);
    }

    public static void StartSwirlies() {
        if (Main.cfg.noSound || !BuildGdx.audio.IsInited(BuildAudio.Driver.Sound)) {
            return;
        }
        Sound.StopAllSounds();
        nNextFreq = 19000;
        nSwirlyFrames = 0;
        int i = 1;
        while (i <= 4) {
            Sound.StartSwirly(i);
            ++i;
        }
    }

    private static void StartSwirly(int nSwirly) {
        ActiveSound pSound = sActiveSound[nSwirly];
        pSound.panning &= 0x7FF;
        pSound.oldpitch = nNextFreq - Random.RandomSize(9);
        nNextFreq = Math.min(25000 - 6 * Random.RandomSize(10), 32000);
        SoundResource res = SoundBufs[StaticSound[67]];
        if (res == null) {
            return;
        }
        pSound.pHandle = BuildGdx.audio.newSound(res.ptr, pSound.oldpitch, res.bits, 255);
        Source pHandle = pSound.pHandle;
        if (pHandle != null) {
            pHandle.setGlobal(1);
            pHandle.setPosition(pSound.panning, 0.0f, 0.0f);
            pHandle.setCallback(callback, nSwirly);
            pHandle.play((float)Math.min(nSwirlyFrames + 1, 220) / 220.0f);
            pHandle.rate = pSound.oldpitch;
        }
    }

    public static void UpdateSwirlies() {
        if (Main.cfg.noSound || !BuildGdx.audio.IsInited(BuildAudio.Driver.Sound)) {
            return;
        }
        ++nSwirlyFrames;
        int nSound = 1;
        int nShift = 5;
        int i = 1;
        while (i <= 4) {
            ActiveSound pSound = sActiveSound[nSound++];
            if (pSound.pHandle == null || !pSound.pHandle.isActive()) {
                Sound.StartSwirly(i);
            }
            if (pSound.pHandle != null) {
                pSound.panning = Engine.sintable[Engine.totalclock << nShift & 0x7FF] >> 8;
                pSound.pHandle.setPosition(pSound.panning, 0.0f, 0.0f);
            }
            ++nShift;
            ++i;
        }
    }

    public static void SoundBigEntrance() {
        if (Main.cfg.noSound || !BuildGdx.audio.IsInited(BuildAudio.Driver.Sound)) {
            return;
        }
        Sound.StopAllSounds();
        int rate = -1200;
        int i = 0;
        while (i < 4) {
            SoundResource res = SoundBufs[12];
            if (res == null) {
                return;
            }
            ActiveSound pSound = sActiveSound[i];
            pSound.pHandle = BuildGdx.audio.newSound(res.ptr, rate + 11000, res.bits, 255);
            Source pHandle = pSound.pHandle;
            if (pHandle == null) {
                return;
            }
            pSound.oldpitch = rate;
            pHandle.setGlobal(1);
            pHandle.setPosition(63 - 127 * (i & 1), 0.0f, 0.0f);
            pHandle.setCallback(callback, i);
            pHandle.play(200.0f);
            pHandle.rate = rate + 11000;
            rate += 512;
            ++i;
        }
    }

    private static boolean SoundPlaying(int num) {
        return num >= 0 && num < sActiveSound.length && Sound.sActiveSound[num].pHandle != null && Sound.sActiveSound[num].pHandle.isActive();
    }

    public static boolean LocalSoundPlaying() {
        return Sound.SoundPlaying(nLocalChan);
    }

    public static int GetLocalSound() {
        if (!Sound.LocalSoundPlaying()) {
            return -1;
        }
        return Sound.sActiveSound[Sound.nLocalChan].soundnum & 0x1FF;
    }

    public static void SetLocalChan(int channel) {
        if (channel >= 0 && channel < sActiveSound.length) {
            nLocalChan = channel;
        }
    }

    public static void PlayLogoSound() {
        Sound.PlayLocalSound(StaticSound[28], 7000);
    }

    public static void PlayGameOverSound() {
        Sound.PlayLocalSound(StaticSound[28], 0);
    }

    public static void UpdateSounds() {
        int earang;
        int earz;
        int eary;
        int earx;
        if (Main.cfg.noSound || !BuildGdx.audio.IsInited(BuildAudio.Driver.Sound) || Globals.nFreeze != 0) {
            return;
        }
        nLocalSectFlags = Globals.SectFlag[Globals.nPlayerViewSect[Globals.nLocalPlayer]];
        if (Globals.nSnakeCam >= 0) {
            SPRITE pSnake = Engine.sprite[Snake.SnakeList[Globals.nSnakeCam].nSprite[0]];
            earx = pSnake.x;
            eary = pSnake.y;
            earz = pSnake.z;
            earang = pSnake.ang;
        } else {
            earx = Globals.initx;
            eary = Globals.inity;
            earz = Globals.initz;
            earang = Globals.inita;
        }
        BuildGdx.audio.getSound().setListener(earx, earz >> 4, eary, earang);
        int i = 1;
        while (i < sActiveSound.length) {
            if (Sound.SoundPlaying(i)) {
                int dy;
                int dx;
                SPRITE spr;
                ActiveSound pSound = sActiveSound[i];
                Source pHandle = pSound.pHandle;
                SPRITE sPRITE = spr = pSound.spr >= 0 ? Engine.sprite[pSound.spr] : null;
                if (spr != null) {
                    dx = earx - spr.x;
                    dy = eary - spr.y;
                    if (spr != Engine.sprite[Globals.PlayerList[Globals.nLocalPlayer].spriteId]) {
                        pHandle.setPosition(spr.x, spr.z >> 4, spr.y);
                    } else {
                        pHandle.setPosition(0.0f, 0.0f, 0.0f);
                    }
                } else {
                    dx = earx - pSound.x;
                    dy = eary - pSound.y;
                    pHandle.setPosition(pSound.x, pSound.z >> 4, pSound.y);
                }
                int dist = Sound.GetDistFromDXDY(dx >> 8, dy >> 8);
                if (dist >= 255) {
                    pHandle.dispose();
                    if ((pSound.ambient & 0x4000) != 0) {
                        nAmbientChannel = -1;
                    }
                    return;
                }
                int vol = Gameutils.BClipRange(265 - (Engine.sintable[2 * dist & 0x7FF] >> 6), 0, 255);
                int pitch = pSound.oldpitch;
                int sectnum = pSound.sectnum;
                if (spr != null) {
                    sectnum = spr == Engine.sprite[Globals.PlayerList[Globals.nLocalPlayer].spriteId] ? Globals.nPlayerViewSect[Globals.nLocalPlayer] : (int)spr.sectnum;
                }
                Sound.GetSpriteSoundPitch(sectnum, vol, pitch);
                vol = pSoundVolume;
                pitch = pSoundPitch;
                if (pSound.pitch != pitch) {
                    pSound.pitch = pitch;
                }
                if (vol != pSound.volume) {
                    if (pitch < 0) {
                        pitch = 7000;
                    }
                    pHandle.setPitch((float)pitch / (float)pHandle.rate);
                    pHandle.setVolume((float)vol / 255.0f);
                    pSound.volume = vol;
                }
            }
            ++i;
        }
        if (Globals.nFreeze != 0 || Globals.levelnum == 20 || --Globals.nCreepyTimer > 0) {
            return;
        }
        if (Globals.nCreaturesLeft > 0 && (Globals.SectFlag[Globals.nPlayerViewSect[Globals.nLocalPlayer]] & 0x2000) == 0) {
            SPRITE pPlayer = Engine.sprite[Globals.PlayerList[Globals.nLocalPlayer].spriteId];
            int soundId = Sound.GetFrameSound(Seq.SeqOffsets[65], Globals.totalmoves % Seq.SeqSize[Seq.SeqOffsets[65]]);
            int sx = Globals.totalmoves + 32 & 0x1F;
            if ((Globals.totalmoves & 1) != 0) {
                sx = -sx;
            }
            int sy = Globals.totalmoves + 32 & 0x3F;
            if ((Globals.totalmoves & 2) != 0) {
                sy = -sy;
            }
            Sound.PlayFXAtXYZ(soundId, pPlayer.x + sx, sy + pPlayer.y, pPlayer.z, pPlayer.sectnum);
        }
        Globals.nCreepyTimer = 180;
    }

    public static class ActiveSound {
        public Source pHandle;
        public int rate;
        public int spr;
        public int x;
        public int y;
        public int z;
        public int oldvolume;
        public int volume;
        public int panning;
        public int oldpitch;
        public int pitch;
        public int soundnum;
        public int asound_C;
        public int clock;
        public int ambient;
        public int ambchannel;
        public int sectnum;
    }
}

