/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Redneck.Types;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Types.LittleEndian;

public class MVEFile {
    private byte[] signature = "Interplay MVE File\u001a\u0000".getBytes();
    private byte[] magic;
    private final int CHUNK_INIT_AUDIO = 0;
    private final int CHUNK_AUDIO_ONLY = 1;
    private final int CHUNK_INIT_VIDEO = 2;
    private final int CHUNK_VIDEO = 3;
    private final int CHUNK_SHUTDOWN = 4;
    private final int CHUNK_END = 5;
    private final int CHUNK_DONE = 65532;
    private final int CHUNK_EOF = 65534;
    private final int CHUNK_BAD = 65535;
    private final int OPCODE_END_OF_STREAM = 0;
    private final int OPCODE_END_OF_CHUNK = 1;
    private final int OPCODE_CREATE_TIMER = 2;
    private final int OPCODE_INIT_AUDIO_BUFFERS = 3;
    private final int OPCODE_START_STOP_AUDIO = 4;
    private final int OPCODE_INIT_VIDEO_BUFFERS = 5;
    private final int OPCODE_VIDEO_DATA_06 = 6;
    private final int OPCODE_SEND_BUFFER = 7;
    private final int OPCODE_AUDIO_FRAME = 8;
    private final int OPCODE_SILENCE_FRAME = 9;
    private final int OPCODE_INIT_VIDEO_MODE = 10;
    private final int OPCODE_CREATE_GRADIENT = 11;
    private final int OPCODE_SET_PALETTE = 12;
    private final int OPCODE_SET_PALETTE_COMPRESSED = 13;
    private final int OPCODE_SET_SKIP_MAP = 14;
    private final int OPCODE_SET_DECODING_MAP = 15;
    private final int OPCODE_VIDEO_DATA_10 = 16;
    private final int OPCODE_VIDEO_DATA_11 = 17;
    private final int OPCODE_UNKNOWN_12 = 18;
    private final int OPCODE_UNKNOWN_13 = 19;
    private final int OPCODE_UNKNOWN_14 = 20;
    private final int OPCODE_UNKNOWN_15 = 21;
    private final int AV_CODEC_ID_NONE = -1;
    private final int AV_CODEC_ID_INTERPLAY_DPCM = 1;
    private final int AV_CODEC_ID_PCM_S16LE = 2;
    private final int AV_CODEC_ID_PCM_U8 = 3;
    private final int VIDEO_DELTA_FRAME = 1;
    private int[] interplay_dpcm_delta_table;
    private int audio_type;
    private int audio_sample_rate;
    private int audio_flags;
    private int audio_channels;
    private int audio_bits;
    private int audio_frame_count;
    private int width;
    private int height;
    private int frame_pts_inc;
    private int video_bpp;
    private byte frame_format;
    private byte[] palette;
    private boolean hasPalette;
    private boolean send_buffer;
    private int audio_chunk_offset;
    private int audio_chunk_size;
    private int skip_map_chunk_offset;
    private short skip_map_chunk_size;
    private int decode_map_chunk_offset;
    private short decode_map_chunk_size;
    private int video_chunk_offset;
    private short video_chunk_size;
    private int next_chunk_offset;
    private FramePacket pkt;
    private int video_pts;
    private int back_buf1;
    private int back_buf2;
    private byte[] buffer;
    private byte[] frame;
    private int max_block_offset;
    private Resource file;

    public MVEFile(Resource bb) {
        byte[] byArray = new byte[6];
        byArray[0] = 26;
        byArray[3] = 1;
        byArray[4] = 51;
        byArray[5] = 17;
        this.magic = byArray;
        this.CHUNK_INIT_AUDIO = 0;
        this.CHUNK_AUDIO_ONLY = 1;
        this.CHUNK_INIT_VIDEO = 2;
        this.CHUNK_VIDEO = 3;
        this.CHUNK_SHUTDOWN = 4;
        this.CHUNK_END = 5;
        this.CHUNK_DONE = 65532;
        this.CHUNK_EOF = 65534;
        this.CHUNK_BAD = 65535;
        this.OPCODE_END_OF_STREAM = 0;
        this.OPCODE_END_OF_CHUNK = 1;
        this.OPCODE_CREATE_TIMER = 2;
        this.OPCODE_INIT_AUDIO_BUFFERS = 3;
        this.OPCODE_START_STOP_AUDIO = 4;
        this.OPCODE_INIT_VIDEO_BUFFERS = 5;
        this.OPCODE_VIDEO_DATA_06 = 6;
        this.OPCODE_SEND_BUFFER = 7;
        this.OPCODE_AUDIO_FRAME = 8;
        this.OPCODE_SILENCE_FRAME = 9;
        this.OPCODE_INIT_VIDEO_MODE = 10;
        this.OPCODE_CREATE_GRADIENT = 11;
        this.OPCODE_SET_PALETTE = 12;
        this.OPCODE_SET_PALETTE_COMPRESSED = 13;
        this.OPCODE_SET_SKIP_MAP = 14;
        this.OPCODE_SET_DECODING_MAP = 15;
        this.OPCODE_VIDEO_DATA_10 = 16;
        this.OPCODE_VIDEO_DATA_11 = 17;
        this.OPCODE_UNKNOWN_12 = 18;
        this.OPCODE_UNKNOWN_13 = 19;
        this.OPCODE_UNKNOWN_14 = 20;
        this.OPCODE_UNKNOWN_15 = 21;
        this.AV_CODEC_ID_NONE = -1;
        this.AV_CODEC_ID_INTERPLAY_DPCM = 1;
        this.AV_CODEC_ID_PCM_S16LE = 2;
        this.AV_CODEC_ID_PCM_U8 = 3;
        this.VIDEO_DELTA_FRAME = 1;
        int[] nArray = new int[256];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 10;
        nArray[11] = 11;
        nArray[12] = 12;
        nArray[13] = 13;
        nArray[14] = 14;
        nArray[15] = 15;
        nArray[16] = 16;
        nArray[17] = 17;
        nArray[18] = 18;
        nArray[19] = 19;
        nArray[20] = 20;
        nArray[21] = 21;
        nArray[22] = 22;
        nArray[23] = 23;
        nArray[24] = 24;
        nArray[25] = 25;
        nArray[26] = 26;
        nArray[27] = 27;
        nArray[28] = 28;
        nArray[29] = 29;
        nArray[30] = 30;
        nArray[31] = 31;
        nArray[32] = 32;
        nArray[33] = 33;
        nArray[34] = 34;
        nArray[35] = 35;
        nArray[36] = 36;
        nArray[37] = 37;
        nArray[38] = 38;
        nArray[39] = 39;
        nArray[40] = 40;
        nArray[41] = 41;
        nArray[42] = 42;
        nArray[43] = 43;
        nArray[44] = 47;
        nArray[45] = 51;
        nArray[46] = 56;
        nArray[47] = 61;
        nArray[48] = 66;
        nArray[49] = 72;
        nArray[50] = 79;
        nArray[51] = 86;
        nArray[52] = 94;
        nArray[53] = 102;
        nArray[54] = 112;
        nArray[55] = 122;
        nArray[56] = 133;
        nArray[57] = 145;
        nArray[58] = 158;
        nArray[59] = 173;
        nArray[60] = 189;
        nArray[61] = 206;
        nArray[62] = 225;
        nArray[63] = 245;
        nArray[64] = 267;
        nArray[65] = 292;
        nArray[66] = 318;
        nArray[67] = 348;
        nArray[68] = 379;
        nArray[69] = 414;
        nArray[70] = 452;
        nArray[71] = 493;
        nArray[72] = 538;
        nArray[73] = 587;
        nArray[74] = 640;
        nArray[75] = 699;
        nArray[76] = 763;
        nArray[77] = 832;
        nArray[78] = 908;
        nArray[79] = 991;
        nArray[80] = 1081;
        nArray[81] = 1180;
        nArray[82] = 1288;
        nArray[83] = 1405;
        nArray[84] = 1534;
        nArray[85] = 1673;
        nArray[86] = 1826;
        nArray[87] = 1993;
        nArray[88] = 2175;
        nArray[89] = 2373;
        nArray[90] = 2590;
        nArray[91] = 2826;
        nArray[92] = 3084;
        nArray[93] = 3365;
        nArray[94] = 3672;
        nArray[95] = 4008;
        nArray[96] = 4373;
        nArray[97] = 4772;
        nArray[98] = 5208;
        nArray[99] = 5683;
        nArray[100] = 6202;
        nArray[101] = 6767;
        nArray[102] = 7385;
        nArray[103] = 8059;
        nArray[104] = 8794;
        nArray[105] = 9597;
        nArray[106] = 10472;
        nArray[107] = 11428;
        nArray[108] = 12471;
        nArray[109] = 13609;
        nArray[110] = 14851;
        nArray[111] = 16206;
        nArray[112] = 17685;
        nArray[113] = 19298;
        nArray[114] = 21060;
        nArray[115] = 22981;
        nArray[116] = 25078;
        nArray[117] = 27367;
        nArray[118] = 29864;
        nArray[119] = 32589;
        nArray[120] = -29973;
        nArray[121] = -26728;
        nArray[122] = -23186;
        nArray[123] = -19322;
        nArray[124] = -15105;
        nArray[125] = -10503;
        nArray[126] = -5481;
        nArray[127] = -1;
        nArray[128] = 1;
        nArray[129] = 1;
        nArray[130] = 5481;
        nArray[131] = 10503;
        nArray[132] = 15105;
        nArray[133] = 19322;
        nArray[134] = 23186;
        nArray[135] = 26728;
        nArray[136] = 29973;
        nArray[137] = -32589;
        nArray[138] = -29864;
        nArray[139] = -27367;
        nArray[140] = -25078;
        nArray[141] = -22981;
        nArray[142] = -21060;
        nArray[143] = -19298;
        nArray[144] = -17685;
        nArray[145] = -16206;
        nArray[146] = -14851;
        nArray[147] = -13609;
        nArray[148] = -12471;
        nArray[149] = -11428;
        nArray[150] = -10472;
        nArray[151] = -9597;
        nArray[152] = -8794;
        nArray[153] = -8059;
        nArray[154] = -7385;
        nArray[155] = -6767;
        nArray[156] = -6202;
        nArray[157] = -5683;
        nArray[158] = -5208;
        nArray[159] = -4772;
        nArray[160] = -4373;
        nArray[161] = -4008;
        nArray[162] = -3672;
        nArray[163] = -3365;
        nArray[164] = -3084;
        nArray[165] = -2826;
        nArray[166] = -2590;
        nArray[167] = -2373;
        nArray[168] = -2175;
        nArray[169] = -1993;
        nArray[170] = -1826;
        nArray[171] = -1673;
        nArray[172] = -1534;
        nArray[173] = -1405;
        nArray[174] = -1288;
        nArray[175] = -1180;
        nArray[176] = -1081;
        nArray[177] = -991;
        nArray[178] = -908;
        nArray[179] = -832;
        nArray[180] = -763;
        nArray[181] = -699;
        nArray[182] = -640;
        nArray[183] = -587;
        nArray[184] = -538;
        nArray[185] = -493;
        nArray[186] = -452;
        nArray[187] = -414;
        nArray[188] = -379;
        nArray[189] = -348;
        nArray[190] = -318;
        nArray[191] = -292;
        nArray[192] = -267;
        nArray[193] = -245;
        nArray[194] = -225;
        nArray[195] = -206;
        nArray[196] = -189;
        nArray[197] = -173;
        nArray[198] = -158;
        nArray[199] = -145;
        nArray[200] = -133;
        nArray[201] = -122;
        nArray[202] = -112;
        nArray[203] = -102;
        nArray[204] = -94;
        nArray[205] = -86;
        nArray[206] = -79;
        nArray[207] = -72;
        nArray[208] = -66;
        nArray[209] = -61;
        nArray[210] = -56;
        nArray[211] = -51;
        nArray[212] = -47;
        nArray[213] = -43;
        nArray[214] = -42;
        nArray[215] = -41;
        nArray[216] = -40;
        nArray[217] = -39;
        nArray[218] = -38;
        nArray[219] = -37;
        nArray[220] = -36;
        nArray[221] = -35;
        nArray[222] = -34;
        nArray[223] = -33;
        nArray[224] = -32;
        nArray[225] = -31;
        nArray[226] = -30;
        nArray[227] = -29;
        nArray[228] = -28;
        nArray[229] = -27;
        nArray[230] = -26;
        nArray[231] = -25;
        nArray[232] = -24;
        nArray[233] = -23;
        nArray[234] = -22;
        nArray[235] = -21;
        nArray[236] = -20;
        nArray[237] = -19;
        nArray[238] = -18;
        nArray[239] = -17;
        nArray[240] = -16;
        nArray[241] = -15;
        nArray[242] = -14;
        nArray[243] = -13;
        nArray[244] = -12;
        nArray[245] = -11;
        nArray[246] = -10;
        nArray[247] = -9;
        nArray[248] = -8;
        nArray[249] = -7;
        nArray[250] = -6;
        nArray[251] = -5;
        nArray[252] = -4;
        nArray[253] = -3;
        nArray[254] = -2;
        nArray[255] = -1;
        this.interplay_dpcm_delta_table = nArray;
        this.palette = new byte[768];
        this.pkt = new FramePacket();
        this.file = bb;
        byte[] data = new byte[20];
        bb.read(data);
        int i = 0;
        while (i < 20) {
            if (data[i] != this.signature[i]) {
                return;
            }
            ++i;
        }
        bb.read(data, 0, 6);
        i = 0;
        while (i < 6) {
            if (data[i] != this.magic[i]) {
                return;
            }
            ++i;
        }
        this.next_chunk_offset = bb.position();
        if (this.process_chunk(bb) != 2) {
            return;
        }
        bb.seek(2L, Resource.Whence.Current);
        short chunk_type = bb.readShort();
        if (chunk_type == 3) {
            this.audio_type = 0;
        } else if (this.process_chunk(bb) != 0) {
            return;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean process() {
        return this.process_chunk(this.file) == 65532;
    }

    public byte[] getPalette() {
        if (this.hasPalette) {
            return this.palette;
        }
        return null;
    }

    public byte[] getFrame() {
        if (this.frame != null) {
            Arrays.fill(this.frame, (byte)0);
        }
        if (this.pkt.video_chunk_data == null) {
            return this.frame;
        }
        if (!this.decode()) {
            return this.frame;
        }
        System.arraycopy(this.buffer, this.back_buf1, this.frame, 0, this.frame.length);
        return this.frame;
    }

    public int getRate() {
        if (this.frame_pts_inc == 0) {
            return 1000;
        }
        return this.frame_pts_inc;
    }

    public void close() {
        this.file.close();
    }

    private int process_chunk(Resource bb) {
        int chunk_type = this.load_ipmovie_packet(bb);
        if (chunk_type != 65532) {
            return chunk_type;
        }
        int chunk_size = bb.readShort().shortValue();
        chunk_type = bb.readShort().shortValue();
        switch (chunk_type) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                chunk_type = 65535;
                break;
            }
        }
        while (chunk_size > 0 && chunk_type != 65535) {
            short opcode_size = bb.readShort();
            int opcode_type = bb.readByte() & 0xFF;
            int opcode_version = bb.readByte() & 0xFF;
            chunk_size -= 4;
            chunk_size -= opcode_size;
            switch (opcode_type) {
                case 0: {
                    bb.seek(opcode_size, Resource.Whence.Current);
                    break;
                }
                case 1: {
                    bb.seek(opcode_size, Resource.Whence.Current);
                    break;
                }
                case 2: {
                    if (opcode_version > 0 || opcode_size != 6) {
                        System.err.println("bad create_timer opcode");
                        chunk_type = 65535;
                        break;
                    }
                    this.frame_pts_inc = bb.readInt();
                    this.frame_pts_inc *= bb.readShort().shortValue();
                    break;
                }
                case 3: {
                    if (opcode_version > 1 || opcode_size > 10 || opcode_size < 6) {
                        System.err.println("bad init_audio_buffers opcode\n");
                        chunk_type = 65535;
                        break;
                    }
                    byte[] scratch = new byte[opcode_size];
                    bb.read(scratch);
                    this.audio_sample_rate = LittleEndian.getUShort(scratch, 4);
                    this.audio_flags = LittleEndian.getUShort(scratch, 2);
                    this.audio_channels = (this.audio_flags & 1) + 1;
                    this.audio_bits = ((this.audio_flags >> 1 & 1) + 1) * 8;
                    if (opcode_version == 1 && (this.audio_flags & 4) != 0) {
                        this.audio_type = 1;
                        break;
                    }
                    if (this.audio_bits == 16) {
                        this.audio_type = 2;
                        break;
                    }
                    this.audio_type = 3;
                    break;
                }
                case 4: {
                    bb.seek(opcode_size, Resource.Whence.Current);
                    break;
                }
                case 5: {
                    if (opcode_version > 2 || opcode_size > 8 || opcode_size < 4 || opcode_version == 2 && opcode_size < 8) {
                        System.err.println("bad init_video_buffers opcode");
                        chunk_type = 65535;
                        break;
                    }
                    this.width = bb.readShort() * 8;
                    this.height = bb.readShort() * 8;
                    if (opcode_version == 2) {
                        bb.readShort();
                    }
                    this.video_bpp = opcode_version < 2 || bb.readShort() == 0 ? 8 : 16;
                    int size = this.width * this.height * (this.video_bpp == 8 ? 1 : 2);
                    this.buffer = new byte[2 * size];
                    this.back_buf1 = 0;
                    this.back_buf2 = size;
                    this.max_block_offset = (this.height - 7) * this.width - 8;
                    this.frame = new byte[size];
                    break;
                }
                case 10: {
                    bb.seek(opcode_size, Resource.Whence.Current);
                    break;
                }
                case 7: {
                    bb.seek(opcode_size, Resource.Whence.Current);
                    this.send_buffer = true;
                    break;
                }
                case 8: {
                    this.audio_chunk_offset = bb.position();
                    this.audio_chunk_size = opcode_size;
                    bb.seek(opcode_size, Resource.Whence.Current);
                    break;
                }
                case 9: {
                    bb.seek(opcode_size, Resource.Whence.Current);
                    break;
                }
                case 11: {
                    bb.seek(opcode_size, Resource.Whence.Current);
                    break;
                }
                case 13: {
                    bb.seek(opcode_size, Resource.Whence.Current);
                    break;
                }
                case 14: {
                    this.skip_map_chunk_offset = bb.position();
                    this.skip_map_chunk_size = opcode_size;
                    bb.seek(opcode_size, Resource.Whence.Current);
                    break;
                }
                case 15: {
                    this.decode_map_chunk_offset = bb.position();
                    this.decode_map_chunk_size = opcode_size;
                    bb.seek(opcode_size, Resource.Whence.Current);
                    break;
                }
                case 6: {
                    this.frame_format = (byte)6;
                    this.video_chunk_offset = bb.position();
                    this.video_chunk_size = opcode_size;
                    bb.seek(opcode_size, Resource.Whence.Current);
                    break;
                }
                case 16: {
                    this.frame_format = (byte)16;
                    this.video_chunk_offset = bb.position();
                    this.video_chunk_size = opcode_size;
                    bb.seek(opcode_size, Resource.Whence.Current);
                    break;
                }
                case 17: {
                    this.frame_format = (byte)17;
                    this.video_chunk_offset = bb.position();
                    this.video_chunk_size = opcode_size;
                    bb.seek(opcode_size, Resource.Whence.Current);
                    break;
                }
                case 12: {
                    if (opcode_size > 772 || opcode_size < 4) {
                        System.err.println("demux_ipmovie: set_palette opcode with invalid size");
                        chunk_type = 65535;
                        break;
                    }
                    int first_color = bb.readShort() & 0xFF;
                    int last_color = first_color + (bb.readShort() & 0xFF) - 1;
                    if (first_color > 255 || last_color > 255 || (last_color - first_color + 1) * 3 + 4 > opcode_size) {
                        System.err.println("demux_ipmovie: set_palette indexes out of range (" + first_color + " . " + last_color + ")");
                        chunk_type = 65535;
                        break;
                    }
                    int i = first_color;
                    while (i <= last_color) {
                        this.palette[3 * i + 0] = (byte)(bb.readByte() * 4);
                        this.palette[3 * i + 1] = (byte)(bb.readByte() * 4);
                        this.palette[3 * i + 2] = (byte)(bb.readByte() * 4);
                        ++i;
                    }
                    this.hasPalette = true;
                    break;
                }
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    bb.seek(opcode_size, Resource.Whence.Current);
                    break;
                }
                default: {
                    chunk_type = 65535;
                }
            }
        }
        this.next_chunk_offset = bb.position();
        if (chunk_type == 3 || chunk_type == 1) {
            chunk_type = this.load_ipmovie_packet(bb);
        }
        return chunk_type;
    }

    private int load_ipmovie_packet(Resource bb) {
        int chunk_type;
        if (this.audio_chunk_offset != 0 && this.audio_channels != 0 && this.audio_bits != 0) {
            if (this.audio_type == -1) {
                System.err.println("Can not read audio packet before audio codec is known");
                return 65535;
            }
            if (this.audio_type != 1) {
                this.audio_chunk_offset += 6;
                this.audio_chunk_size -= 6;
            }
            bb.seek(this.audio_chunk_offset, Resource.Whence.Set);
            this.audio_chunk_offset = 0;
            this.pkt.audio_chunk_data = new byte[this.audio_chunk_size];
            if (bb.position() + this.audio_chunk_size >= bb.size()) {
                return 65534;
            }
            bb.read(this.pkt.audio_chunk_data);
            this.pkt.pts = this.audio_frame_count;
            this.audio_frame_count = this.audio_type != 1 ? (this.audio_frame_count += this.audio_chunk_size / this.audio_channels / (this.audio_bits / 8)) : (this.audio_frame_count += (this.audio_chunk_size - 6 - this.audio_channels) / this.audio_channels);
            chunk_type = 3;
        } else if (this.frame_format != 0) {
            this.pkt.video_chunk_data = new byte[this.video_chunk_size];
            this.pkt.decode_map_chunk_data = new byte[this.decode_map_chunk_size];
            this.pkt.skip_map_chunk_data = new byte[this.skip_map_chunk_size];
            if (this.hasPalette) {
                this.pkt.palette = new byte[768];
                System.arraycopy(this.palette, 0, this.pkt.palette, 0, 768);
                this.hasPalette = false;
            }
            this.pkt.frame_format = this.frame_format;
            this.pkt.send_buffer = this.send_buffer;
            this.pkt.video_chunk_size = this.video_chunk_size;
            this.pkt.decode_map_chunk_size = this.decode_map_chunk_size;
            this.pkt.skip_map_chunk_size = this.skip_map_chunk_size;
            this.frame_format = 0;
            this.send_buffer = false;
            this.pkt.pos = this.video_chunk_offset;
            bb.seek(this.video_chunk_offset, Resource.Whence.Set);
            this.video_chunk_offset = 0;
            if (bb.position() + this.video_chunk_size >= bb.size()) {
                return 65534;
            }
            bb.read(this.pkt.video_chunk_data);
            if (this.decode_map_chunk_size != 0) {
                this.pkt.pos = this.decode_map_chunk_offset;
                bb.seek(this.decode_map_chunk_offset, Resource.Whence.Set);
                this.decode_map_chunk_offset = 0;
                if (bb.position() + this.decode_map_chunk_size >= bb.size()) {
                    return 65534;
                }
                bb.read(this.pkt.decode_map_chunk_data);
            }
            if (this.skip_map_chunk_size != 0) {
                this.pkt.pos = this.skip_map_chunk_offset;
                bb.seek(this.skip_map_chunk_offset, Resource.Whence.Set);
                this.skip_map_chunk_offset = 0;
                if (bb.position() + this.skip_map_chunk_size >= bb.size()) {
                    return 65534;
                }
                bb.read(this.pkt.skip_map_chunk_data);
            }
            this.video_chunk_size = 0;
            this.decode_map_chunk_size = 0;
            this.skip_map_chunk_size = 0;
            this.pkt.pts = this.video_pts;
            this.video_pts += this.frame_pts_inc;
            chunk_type = 3;
        } else {
            bb.seek(this.next_chunk_offset, Resource.Whence.Set);
            chunk_type = 65532;
        }
        return chunk_type;
    }

    private boolean decode() {
        ByteBuffer bb = ByteBuffer.wrap(this.pkt.video_chunk_data).order(ByteOrder.LITTLE_ENDIAN);
        bb.getShort();
        bb.getShort();
        bb.getShort();
        bb.getShort();
        bb.getShort();
        bb.getShort();
        int flags = bb.getShort() & 0xFFFF;
        if ((flags & 1) != 0) {
            int temp = this.back_buf1;
            this.back_buf1 = this.back_buf2;
            this.back_buf2 = temp;
        }
        boolean dec = false;
        if (this.video_bpp != 16) {
            if (this.palette == null) {
                System.err.println("No palette available");
                return false;
            }
            dec = this.decode_frame8(bb, this.pkt.video_chunk_size);
        }
        return dec;
    }

    private boolean decode_frame8(ByteBuffer data, int len) {
        boolean rc = true;
        int index = 0;
        int xx = this.width >> 3;
        int yy = this.height >> 3;
        int frameptr = this.back_buf1;
        int y = 0;
        while (y < yy) {
            int x = 0;
            while (x < xx) {
                int opcode = index & true ? (this.pkt.decode_map_chunk_data[index >> 1] & 0xFF) >> 4 : this.pkt.decode_map_chunk_data[index >> 1] & 0xF;
                ++index;
                switch (opcode) {
                    case 0: {
                        rc = this.copy_block(frameptr, frameptr + (this.back_buf2 - this.back_buf1), 0);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        rc = this.decode_0x2(frameptr, data);
                        break;
                    }
                    case 3: {
                        rc = this.decode_0x3(frameptr, data);
                        break;
                    }
                    case 4: {
                        rc = this.decode_0x4(frameptr, data);
                        break;
                    }
                    case 5: {
                        rc = this.decode_0x5(frameptr, data);
                        break;
                    }
                    case 6: {
                        rc = false;
                        break;
                    }
                    case 7: {
                        rc = this.decode_0x7(frameptr, data);
                        break;
                    }
                    case 8: {
                        rc = this.decode_0x8(frameptr, data);
                        break;
                    }
                    case 9: {
                        rc = this.decode_0x9(frameptr, data);
                        break;
                    }
                    case 10: {
                        rc = this.decode_0xa(frameptr, data);
                        break;
                    }
                    case 11: {
                        rc = this.decode_0xb(frameptr, data);
                        break;
                    }
                    case 12: {
                        rc = this.decode_0xc(frameptr, data);
                        break;
                    }
                    case 13: {
                        rc = this.decode_0xd(frameptr, data);
                        break;
                    }
                    case 14: {
                        rc = this.decode_0xe(frameptr, data);
                        break;
                    }
                    case 15: {
                        rc = this.decode_0xf(frameptr, data);
                    }
                }
                if (!rc) {
                    return false;
                }
                frameptr += 8;
                ++x;
            }
            frameptr += 7 * this.width;
            ++y;
        }
        return true;
    }

    private boolean copy_block(int frameptr, int src_offset, int offset) {
        long frame_offset = frameptr - this.back_buf1 + offset;
        if (frame_offset < 0L) {
            System.err.println("frame offset < 0 (" + frame_offset + ")");
            return false;
        }
        if (frame_offset > (long)this.max_block_offset) {
            System.err.println("frame offset above limit (" + frame_offset + " > " + this.max_block_offset + ")");
            return false;
        }
        int i = 0;
        while (i < 8) {
            System.arraycopy(this.buffer, src_offset, this.buffer, frameptr, 8);
            frameptr += this.width;
            src_offset += this.width;
            ++i;
        }
        return true;
    }

    private boolean decode_0x2(int frame, ByteBuffer data) {
        int y;
        int x;
        if (!data.hasRemaining()) {
            return false;
        }
        int B = data.get() & 0xFF;
        if (B < 56) {
            x = 8 + B % 7;
            y = B / 7;
        } else {
            x = -14 + (B - 56) % 29;
            y = 8 + (B - 56) / 29;
        }
        int offset = y * this.width + x;
        return this.copy_block(frame, frame + offset, offset);
    }

    private boolean decode_0x3(int frame, ByteBuffer data) {
        int y;
        int x;
        if (!data.hasRemaining()) {
            return false;
        }
        int B = data.get() & 0xFF;
        if (B < 56) {
            x = -(8 + B % 7);
            y = -(B / 7);
        } else {
            x = -(-14 + (B - 56) % 29);
            y = -(8 + (B - 56) / 29);
        }
        int offset = y * this.width + x;
        return this.copy_block(frame, frame + offset, offset);
    }

    private boolean decode_0x4(int frame, ByteBuffer data) {
        if (!data.hasRemaining()) {
            return false;
        }
        int B = data.get() & 0xFF;
        int x = -8 + (B & 0xF);
        int y = -8 + (B >> 4 & 0xF);
        int offset = y * this.width + x;
        return this.copy_block(frame, frame + (this.back_buf2 - this.back_buf1) + offset, offset);
    }

    private boolean decode_0x5(int frame, ByteBuffer data) {
        if (data.remaining() < 2) {
            return false;
        }
        byte x = data.get();
        byte y = data.get();
        int offset = y * this.width + x;
        return this.copy_block(frame, frame + (this.back_buf2 - this.back_buf1) + offset, offset);
    }

    private boolean decode_0x7(int frame, ByteBuffer data) {
        if (data.remaining() < 4) {
            return false;
        }
        byte[] P = new byte[2];
        data.get(P);
        if ((P[0] & 0xFF) <= (P[1] & 0xFF)) {
            int y = 0;
            while (y < 8) {
                int flags = data.get() & 0xFF | 0x100;
                while (flags != 1) {
                    this.buffer[frame++] = P[flags & 1];
                    flags >>= 1;
                }
                frame += this.width - 8;
                ++y;
            }
        } else {
            int flags = data.getShort();
            int y = 0;
            while (y < 8) {
                int x = 0;
                while (x < 8) {
                    byte by = P[flags & 1];
                    this.buffer[frame + x + 1 + this.width] = by;
                    this.buffer[frame + x + this.width] = by;
                    this.buffer[frame + x + 1] = by;
                    this.buffer[frame + x] = by;
                    x += 2;
                    flags >>= 1;
                }
                frame += this.width * 2;
                y += 2;
            }
        }
        return true;
    }

    private boolean decode_0x8(int frame, ByteBuffer data) {
        byte[] P = new byte[8];
        int flags = 0;
        if (data.remaining() < 12) {
            return false;
        }
        data.get(P, 0, 2);
        if ((P[0] & 0xFF) <= (P[1] & 0xFF)) {
            int y = 0;
            while (y < 16) {
                if ((y & 3) == 0) {
                    if (y != 0) {
                        data.get(P, 0, 2);
                    }
                    flags = data.getShort();
                }
                int x = 0;
                while (x < 4) {
                    this.buffer[frame++] = P[flags & 1];
                    ++x;
                    flags >>= 1;
                }
                frame += this.width - 4;
                if (y == 7) {
                    frame -= 8 * this.width - 4;
                }
                ++y;
            }
        } else {
            flags = data.getInt();
            data.get(P, 2, 2);
            if ((P[2] & 0xFF) <= (P[3] & 0xFF)) {
                int y = 0;
                while (y < 16) {
                    int x = 0;
                    while (x < 4) {
                        this.buffer[frame++] = P[flags & 1];
                        ++x;
                        flags >>= 1;
                    }
                    frame += this.width - 4;
                    if (y == 7) {
                        frame -= 8 * this.width - 4;
                        P[0] = P[2];
                        P[1] = P[3];
                        flags = data.getInt();
                    }
                    ++y;
                }
            } else {
                int y = 0;
                while (y < 8) {
                    if (y == 4) {
                        P[0] = P[2];
                        P[1] = P[3];
                        flags = data.getInt();
                    }
                    int x = 0;
                    while (x < 8) {
                        this.buffer[frame++] = P[flags & 1];
                        ++x;
                        flags >>= 1;
                    }
                    frame += this.width - 8;
                    ++y;
                }
            }
        }
        return true;
    }

    private boolean decode_0x9(int frame, ByteBuffer data) {
        if (data.remaining() < 8) {
            return false;
        }
        byte[] P = new byte[4];
        data.get(P);
        if ((P[0] & 0xFF) <= (P[1] & 0xFF)) {
            if ((P[2] & 0xFF) <= (P[3] & 0xFF)) {
                int y = 0;
                while (y < 8) {
                    int flags = data.getShort();
                    int x = 0;
                    while (x < 8) {
                        this.buffer[frame++] = P[flags & 3];
                        ++x;
                        flags >>= 2;
                    }
                    frame += this.width - 8;
                    ++y;
                }
            } else {
                int flags = data.getInt();
                int y = 0;
                while (y < 8) {
                    int x = 0;
                    while (x < 8) {
                        byte by = P[flags & 3];
                        this.buffer[frame + x + 1 + this.width] = by;
                        this.buffer[frame + x + this.width] = by;
                        this.buffer[frame + x + 1] = by;
                        this.buffer[frame + x] = by;
                        x += 2;
                        flags >>= 2;
                    }
                    frame += this.width * 2;
                    y += 2;
                }
            }
        } else {
            long flags = data.getLong();
            if ((P[2] & 0xFF) <= (P[3] & 0xFF)) {
                int y = 0;
                while (y < 8) {
                    int x = 0;
                    while (x < 8) {
                        byte by = P[(int)(flags & 3L)];
                        this.buffer[frame + x + 1] = by;
                        this.buffer[frame + x] = by;
                        x += 2;
                        flags >>= 2;
                    }
                    frame += this.width;
                    ++y;
                }
            } else {
                int y = 0;
                while (y < 8) {
                    int x = 0;
                    while (x < 8) {
                        byte by = P[(int)(flags & 3L)];
                        this.buffer[frame + x + this.width] = by;
                        this.buffer[frame + x] = by;
                        ++x;
                        flags >>= 2;
                    }
                    frame += this.width * 2;
                    y += 2;
                }
            }
        }
        return true;
    }

    private boolean decode_0xa(int frame, ByteBuffer data) {
        byte[] P = new byte[8];
        if (data.remaining() < 16) {
            return false;
        }
        data.get(P, 0, 4);
        if ((P[0] & 0xFF) <= (P[1] & 0xFF)) {
            int flags = 0;
            int y = 0;
            while (y < 16) {
                if ((y & 3) == 0) {
                    if (y != 0) {
                        data.get(P, 0, 4);
                    }
                    flags = data.getInt();
                }
                int x = 0;
                while (x < 4) {
                    this.buffer[frame++] = P[flags & 3];
                    ++x;
                    flags >>= 2;
                }
                frame += this.width - 4;
                if (y == 7) {
                    frame -= 8 * this.width - 4;
                }
                ++y;
            }
        } else {
            long flags = data.getLong();
            data.get(P, 4, 4);
            boolean vert = (P[4] & 0xFF) <= (P[5] & 0xFF);
            int y = 0;
            while (y < 16) {
                int x = 0;
                while (x < 4) {
                    this.buffer[frame++] = P[(int)(flags & 3L)];
                    ++x;
                    flags >>= 2;
                }
                if (vert) {
                    frame += this.width - 4;
                    if (y == 7) {
                        frame -= 8 * this.width - 4;
                    }
                } else if ((y & 1) != 0) {
                    frame += this.width - 8;
                }
                if (y == 7) {
                    System.arraycopy(P, 4, P, 0, 4);
                    flags = data.getLong();
                }
                ++y;
            }
        }
        return true;
    }

    private boolean decode_0xb(int frame, ByteBuffer data) {
        if (data.remaining() < 64) {
            return false;
        }
        int y = 0;
        while (y < 8) {
            data.get(this.buffer, frame, 8);
            frame += this.width;
            ++y;
        }
        return true;
    }

    private boolean decode_0xc(int frame, ByteBuffer data) {
        if (data.remaining() < 16) {
            return false;
        }
        int y = 0;
        while (y < 8) {
            int x = 0;
            while (x < 8) {
                byte by = data.get();
                this.buffer[frame + this.width + x + 1] = by;
                this.buffer[frame + this.width + x] = by;
                this.buffer[frame + x + 1] = by;
                this.buffer[frame + x] = by;
                x += 2;
            }
            frame += this.width * 2;
            y += 2;
        }
        return true;
    }

    private boolean decode_0xd(int frame, ByteBuffer data) {
        if (data.remaining() < 4) {
            return false;
        }
        byte[] P = new byte[2];
        int y = 0;
        while (y < 8) {
            if ((y & 3) == 0) {
                data.get(P);
            }
            Arrays.fill(this.buffer, frame, frame + 4, P[0]);
            Arrays.fill(this.buffer, frame + 4, frame + 8, P[1]);
            frame += this.width;
            ++y;
        }
        return true;
    }

    private boolean decode_0xe(int frame, ByteBuffer data) {
        if (data.remaining() < 1) {
            return false;
        }
        byte pix = data.get();
        int y = 0;
        while (y < 8) {
            Arrays.fill(this.buffer, frame, frame + 8, pix);
            frame += this.width;
            ++y;
        }
        return true;
    }

    private boolean decode_0xf(int frame, ByteBuffer data) {
        if (data.remaining() < 2) {
            return false;
        }
        byte[] P = new byte[2];
        data.get(P);
        int y = 0;
        while (y < 8) {
            int x = 0;
            while (x < 4) {
                this.buffer[frame++] = P[y & 1];
                this.buffer[frame++] = P[y & 1 ^ 1];
                ++x;
            }
            frame += this.width - 8;
            ++y;
        }
        return true;
    }

    public class FramePacket {
        public int pts;
        public byte frame_format;
        public boolean send_buffer;
        public short video_chunk_size;
        public byte[] video_chunk_data;
        public short decode_map_chunk_size;
        public byte[] decode_map_chunk_data;
        public short skip_map_chunk_size;
        public byte[] skip_map_chunk_data;
        public byte[] audio_chunk_data;
        public byte[] palette;
        public int pos;
    }
}

