/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Tekwar.Factory;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Input.BuildControllers;
import ru.m210projects.Build.OnSceenDisplay.OSDFunc;
import ru.m210projects.Build.Pattern.BuildControls;
import ru.m210projects.Build.Pattern.BuildEngine;
import ru.m210projects.Build.Pattern.BuildFactory;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pattern.FontHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.SliderDrawable;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Tekwar.Factory.TekControl;
import ru.m210projects.Tekwar.Factory.TekEngine;
import ru.m210projects.Tekwar.Factory.TekMenuHandler;
import ru.m210projects.Tekwar.Factory.TekNetwork;
import ru.m210projects.Tekwar.Factory.TekPolymost;
import ru.m210projects.Tekwar.Factory.TekSoftware;
import ru.m210projects.Tekwar.Factory.TekwarOSDFunc;
import ru.m210projects.Tekwar.Fonts.MenuFont;
import ru.m210projects.Tekwar.Fonts.StandartFont;
import ru.m210projects.Tekwar.Fonts.TekFontA;
import ru.m210projects.Tekwar.Fonts.TekFontB;
import ru.m210projects.Tekwar.Main;
import ru.m210projects.Tekwar.Menus.TekSliderDrawable;

public class TekFactory
extends BuildFactory {
    private Main app;

    public TekFactory(Main app) {
        super("tekwar.dat");
        this.app = app;
    }

    @Override
    public void drawInitScreen() {
        this.app.pEngine.rotatesprite(0xA00000, 0x640000, 65536, 0, 321, 0, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
    }

    @Override
    public BuildEngine engine() throws Exception {
        Main.engine = new TekEngine(this.app);
        return Main.engine;
    }

    @Override
    public Renderer renderer(Renderer.RenderType type) {
        if (type == Renderer.RenderType.Software) {
            return new TekSoftware(this.app.pEngine);
        }
        return new TekPolymost(this.app.pEngine);
    }

    @Override
    public DefScript getBaseDef(BuildEngine engine) {
        return new DefScript(engine, false);
    }

    @Override
    public BuildControls input(BuildControllers gpmanager) {
        return new TekControl(this.app.pCfg, gpmanager);
    }

    @Override
    public OSDFunc console() {
        return new TekwarOSDFunc(this.app);
    }

    @Override
    public MenuHandler menus() {
        this.app.menu = new TekMenuHandler(this.app, 32);
        return this.app.menu;
    }

    @Override
    public FontHandler fonts() {
        return new FontHandler(4){

            @Override
            protected BuildFont init(int i) {
                if (i == 0) {
                    return new MenuFont(((TekFactory)TekFactory.this).app.pEngine);
                }
                if (i == 1) {
                    return new TekFontA(((TekFactory)TekFactory.this).app.pEngine);
                }
                if (i == 2) {
                    return new TekFontB(((TekFactory)TekFactory.this).app.pEngine);
                }
                return new StandartFont(((TekFactory)TekFactory.this).app.pEngine);
            }
        };
    }

    @Override
    public BuildNet net() {
        return new TekNetwork(this.app);
    }

    @Override
    public SliderDrawable slider() {
        return new TekSliderDrawable(this.app);
    }
}

