/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Enemies;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Enemies.Coolie;
import ru.m210projects.Wang.Enemies.Decision;
import ru.m210projects.Wang.Enemies.Personality;
import ru.m210projects.Wang.Enemies.Ripper;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.JWeapon;
import ru.m210projects.Wang.Player;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.ATTRIBUTE;
import ru.m210projects.Wang.Type.Actor_Action_Set;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Weapon;

public class Coolg {
    private static final Animator InitCoolgCircle = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return Coolg.InitCoolgCircle(SpriteNum) != 0;
        }
    };
    private static final Decision[] CoolgBattle = new Decision[]{new Decision(50, InitCoolgCircle), new Decision(450, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] CoolgOffense = new Decision[]{new Decision(449, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] CoolgBroadcast = new Decision[]{new Decision(1, Ai.InitActorAmbientNoise), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] CoolgSurprised = new Decision[]{new Decision(100, InitCoolgCircle), new Decision(701, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] CoolgEvasive = new Decision[]{new Decision(20, InitCoolgCircle), new Decision(1024, Ai.InitActorRunAway)};
    private static final Decision[] CoolgLostTarget = new Decision[]{new Decision(900, Ai.InitActorFindPlayer), new Decision(1024, Ai.InitActorWanderAround)};
    private static final Decision[] CoolgCloseRange = new Decision[]{new Decision(800, Ai.InitActorAttack), new Decision(1024, Ai.InitActorReposition)};
    private static final Decision[] CoolgTouchTarget = new Decision[]{new Decision(1024, Ai.InitActorAttack)};
    private static final Personality CoolgPersonality = new Personality(CoolgBattle, CoolgOffense, CoolgBroadcast, CoolgSurprised, CoolgEvasive, CoolgLostTarget, CoolgCloseRange, CoolgTouchTarget);
    private static final ATTRIBUTE CoolgAttrib;
    public static final int COOLG_RUN_RATE = 40;
    private static final Animator DoCoolgMove;
    private static final State[][] s_CoolgRun;
    private static final State[][] s_CoolgStand;
    public static final int COOLG_RATE = 16;
    private static final Animator NullCoolg;
    public static final int COOLG_FIRE_RATE = 12;
    private static final State[][] s_CoolgAttack;
    public static final int COOLG_PAIN_RATE = 15;
    private static final Animator DoCoolgPain;
    private static final State[][] s_CoolgPain;
    public static final int COOLG_DIE_RATE = 20;
    public static final int COOLG_DIE = 4307;
    public static final int COOLG_DEAD = 4312;
    private static final Animator DoCoolgDeath;
    private static final State[] s_CoolgDie;
    private static final State[] s_CoolgDead;
    public static final int COOLG_BIRTH_RATE = 20;
    public static final int COOLG_BIRTH = 4268;
    private static final Animator DoCoolgBirth;
    private static final State[] s_CoolgBirth;
    private static final Actor_Action_Set CoolgActionSet;
    private static final int COOLG_BOB_AMT;
    private static final Animator DoCoolgCircle;

    static {
        short[] sArray = new short[4];
        sArray[0] = 3;
        sArray[2] = -2;
        sArray[3] = -3;
        int[] nArray = new int[10];
        nArray[0] = 83;
        nArray[1] = 81;
        nArray[3] = 84;
        nArray[4] = 87;
        nArray[5] = 80;
        nArray[6] = 82;
        nArray[7] = 85;
        nArray[8] = 86;
        CoolgAttrib = new ATTRIBUTE(new short[]{60, 80, 150, 190}, sArray, 3, nArray);
        DoCoolgMove = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Coolg.DoCoolgMove(SpriteNum) != 0;
            }
        };
        s_CoolgRun = new State[][]{{new State(4277, 40, DoCoolgMove), new State(4278, 40, DoCoolgMove), new State(4279, 40, DoCoolgMove), new State(4280, 40, DoCoolgMove)}, {new State(4281, 40, DoCoolgMove), new State(4282, 40, DoCoolgMove), new State(4283, 40, DoCoolgMove), new State(4284, 40, DoCoolgMove)}, {new State(4285, 40, DoCoolgMove), new State(4286, 40, DoCoolgMove), new State(4287, 40, DoCoolgMove), new State(4288, 40, DoCoolgMove)}, {new State(4289, 40, DoCoolgMove), new State(4290, 40, DoCoolgMove), new State(4291, 40, DoCoolgMove), new State(4292, 40, DoCoolgMove)}, {new State(4293, 40, DoCoolgMove), new State(4294, 40, DoCoolgMove), new State(4295, 40, DoCoolgMove), new State(4296, 40, DoCoolgMove)}};
        s_CoolgStand = new State[][]{{new State(4277, 40, DoCoolgMove).setNext()}, {new State(4281, 40, DoCoolgMove).setNext()}, {new State(4285, 40, DoCoolgMove).setNext()}, {new State(4289, 40, DoCoolgMove).setNext()}, {new State(4293, 40, DoCoolgMove).setNext()}};
        NullCoolg = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Coolg.NullCoolg(SpriteNum) != 0;
            }
        };
        s_CoolgAttack = new State[][]{{new State(4297, 24, NullCoolg), new State(4298, 24, NullCoolg), new State(4299, 24, NullCoolg), new State(4299, Gameutils.SF_QUICK_CALL, Ripper.InitCoolgFire), new State(4299, 12, NullCoolg), new State(4299, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4279, 12, DoCoolgMove).setNext()}, {new State(4300, 24, NullCoolg), new State(4301, 24, NullCoolg), new State(4302, 24, NullCoolg), new State(4302, Gameutils.SF_QUICK_CALL, Ripper.InitCoolgFire), new State(4302, 12, NullCoolg), new State(4302, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4279, 12, DoCoolgMove).setNext()}, {new State(4303, 24, NullCoolg), new State(4304, 24, NullCoolg), new State(4305, 24, NullCoolg), new State(4305, Gameutils.SF_QUICK_CALL, Ripper.InitCoolgFire), new State(4305, 12, NullCoolg), new State(4305, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4279, 12, DoCoolgMove).setNext()}, {new State(4289, 24, NullCoolg), new State(4290, 24, NullCoolg), new State(4291, 24, NullCoolg), new State(4291, Gameutils.SF_QUICK_CALL, Ripper.InitCoolgFire), new State(4291, 12, NullCoolg), new State(4291, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4279, 12, DoCoolgMove).setNext()}, {new State(4293, 24, NullCoolg), new State(4294, 24, NullCoolg), new State(4295, 24, NullCoolg), new State(4295, Gameutils.SF_QUICK_CALL, Ripper.InitCoolgFire), new State(4295, 12, NullCoolg), new State(4295, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4279, 12, DoCoolgMove).setNext()}};
        DoCoolgPain = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Coolg.DoCoolgPain(SpriteNum) != 0;
            }
        };
        s_CoolgPain = new State[][]{{new State(4306, 15, DoCoolgPain), new State(4306, 15, DoCoolgPain).setNext()}, {new State(4281, 15, DoCoolgPain), new State(4281, 15, DoCoolgPain).setNext()}, {new State(4285, 15, DoCoolgPain), new State(4285, 15, DoCoolgPain).setNext()}, {new State(4289, 15, DoCoolgPain), new State(4289, 15, DoCoolgPain).setNext()}, {new State(4293, 15, DoCoolgPain), new State(4293, 15, DoCoolgPain).setNext()}};
        DoCoolgDeath = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Coolg.DoCoolgDeath(SpriteNum) != 0;
            }
        };
        s_CoolgDie = new State[]{new State(4307, 20, DoCoolgDeath), new State(4308, 20, DoCoolgDeath), new State(4309, 20, DoCoolgDeath), new State(4310, 20, DoCoolgDeath), new State(4311, 20, DoCoolgDeath), new State(4312, 20, DoCoolgDeath).setNext()};
        s_CoolgDead = new State[]{new State(4312, Gameutils.SF_QUICK_CALL, Player.QueueFloorBlood), new State(4312, 20, Actor.DoActorDebris).setNext()};
        DoCoolgBirth = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Coolg.DoCoolgBirth(SpriteNum) != 0;
            }
        };
        s_CoolgBirth = new State[]{new State(4268, 20, null), new State(4269, 20, null), new State(4270, 20, null), new State(4271, 20, null), new State(4272, 20, null), new State(4273, 20, null), new State(4274, 20, null), new State(4275, 20, null), new State(4276, 20, null), new State(4276, 20, null), new State(4276, Gameutils.SF_QUICK_CALL, DoCoolgBirth).setNext()};
        CoolgActionSet = new Actor_Action_Set(CoolgStateGroup.sg_CoolgStand, CoolgStateGroup.sg_CoolgRun, null, null, null, null, null, null, null, null, null, CoolgStateGroup.sg_CoolgPain, CoolgStateGroup.sg_CoolgDie, null, CoolgStateGroup.sg_CoolgDead, null, null, new Sprites.StateGroup[]{CoolgStateGroup.sg_CoolgAttack}, new short[]{1024}, new Sprites.StateGroup[]{CoolgStateGroup.sg_CoolgAttack}, new short[]{1024}, null, null, null);
        COOLG_BOB_AMT = Gameutils.Z(8);
        DoCoolgCircle = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Coolg.DoCoolgCircle(SpriteNum) != 0;
            }
        };
    }

    public static void InitCoolgStates() {
        CoolgStateGroup[] coolgStateGroupArray = CoolgStateGroup.values();
        int n = coolgStateGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            CoolgStateGroup sg = coolgStateGroupArray[n2];
            int rot = 0;
            while (rot < sg.group.length) {
                State.InitState(sg.group[rot]);
                ++rot;
            }
            ++n2;
        }
        State.InitState(s_CoolgBirth);
    }

    private static void CoolgCommon(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        sp.clipdist = 50;
        u.floor_dist = (short)Gameutils.Z(16);
        u.ceiling_dist = (short)Gameutils.Z(20);
        u.sz = sp.z;
        sp.xrepeat = (short)42;
        sp.yrepeat = (short)42;
        sp.extra = (short)(sp.extra | Gameutils.SPRX_PLAYER_OR_ENEMY);
    }

    public static int SetupCoolg(int SpriteNum) {
        USER u;
        SPRITE sp = Engine.sprite[SpriteNum];
        if (MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_RESTORE)) {
            u = Gameutils.pUser[SpriteNum];
        } else {
            Gameutils.pUser[SpriteNum] = u = Sprites.SpawnUser(SpriteNum, 4277, s_CoolgRun[0][0]);
            u.Health = (short)65;
        }
        Sprites.ChangeState(SpriteNum, s_CoolgRun[0][0]);
        u.Attrib = CoolgAttrib;
        Ai.DoActorSetSpeed(SpriteNum, 1);
        u.StateEnd = s_CoolgDie[0];
        u.Rot = CoolgStateGroup.sg_CoolgRun;
        Coolie.EnemyDefaults(SpriteNum, CoolgActionSet, CoolgPersonality);
        u.Flags |= Gameutils.SPR_NO_SCAREDZ | Gameutils.SPR_XFLIP_TOGGLE;
        Coolg.CoolgCommon(SpriteNum);
        return 0;
    }

    public static int NewCoolg(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = Gameutils.pUser[SpriteNum].getSprite();
        int newsp = Sprites.SpawnSprite(2, 4277, s_CoolgBirth[0], sp.sectnum, sp.x, sp.y, sp.z, sp.ang, 50);
        USER nu = Gameutils.pUser[newsp];
        SPRITE np = Engine.sprite[newsp];
        Sprites.ChangeState(newsp, s_CoolgBirth[0]);
        nu.StateEnd = s_CoolgDie[0];
        nu.Rot = CoolgStateGroup.sg_CoolgRun;
        nu.spal = u.spal;
        np.pal = nu.spal;
        nu.ActorActionSet = CoolgActionSet;
        np.shade = sp.shade;
        nu.Personality = CoolgPersonality;
        nu.Attrib = CoolgAttrib;
        ++Game.TotalKillable;
        Coolg.CoolgCommon(newsp);
        return 0;
    }

    private static int DoCoolgBirth(int newsp) {
        USER u = Gameutils.pUser[newsp];
        u.Health = (short)65;
        u.Attrib = CoolgAttrib;
        Ai.DoActorSetSpeed(newsp, 1);
        Sprites.ChangeState(newsp, s_CoolgRun[0][0]);
        u.StateEnd = s_CoolgDie[0];
        u.Rot = CoolgStateGroup.sg_CoolgRun;
        Coolie.EnemyDefaults(newsp, CoolgActionSet, CoolgPersonality);
        --Game.TotalKillable;
        u.Flags |= Gameutils.SPR_NO_SCAREDZ | Gameutils.SPR_XFLIP_TOGGLE;
        Coolg.CoolgCommon(newsp);
        return 0;
    }

    private static int NullCoolg(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        u.ShellNum -= 6;
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        Coolg.DoCoolgMatchPlayerZ(SpriteNum);
        Actor.DoActorSectorDamage(SpriteNum);
        return 0;
    }

    private static int DoCoolgMatchPlayerZ(int SpriteNum) {
        int bound;
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE tsp = Engine.sprite[Gameutils.pUser[SpriteNum].tgt_sp];
        if (!MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_BLOCK) || !MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN)) {
            JWeapon.InitBloodSpray(SpriteNum, true, 105);
            JWeapon.InitBloodSpray(SpriteNum, true, 105);
            Weapon.UpdateSinglePlayKills(SpriteNum, null);
            Weapon.SetSuicide(SpriteNum);
        }
        int zdiff = Gameutils.SPRITEp_MID(tsp) - u.sz;
        int zdist = Gameutils.Z(20 + Gameutils.RANDOM_RANGE(100));
        if (Pragmas.klabs(zdiff) > zdist) {
            u.sz = zdiff > 0 ? (u.sz += 1020) : (u.sz -= 1020);
        }
        int loz = u.loz;
        int hiz = u.hiz;
        if (u.lo_sectp != -1 && Sector.SectUser[u.lo_sectp] != null && Sector.SectUser[u.lo_sectp].depth != 0) {
            loz -= Gameutils.Z(Sector.SectUser[u.lo_sectp].depth) - Gameutils.Z(8);
        }
        if (u.sz > (bound = u.lo_sp != -1 ? loz - u.floor_dist : loz - u.floor_dist - COOLG_BOB_AMT)) {
            u.sz = bound;
        }
        if (u.sz < (bound = u.hi_sp != -1 ? hiz + u.ceiling_dist : hiz + u.ceiling_dist + COOLG_BOB_AMT)) {
            u.sz = bound;
        }
        u.sz = Math.min(u.sz, loz - u.floor_dist);
        u.sz = Math.max(u.sz, hiz + u.ceiling_dist);
        u.Counter = (short)(u.Counter + 48 & 0x7FF);
        sp.z = u.sz + (COOLG_BOB_AMT * Engine.sintable[u.Counter] >> 14);
        bound = u.hiz + u.ceiling_dist + COOLG_BOB_AMT;
        if (sp.z < bound) {
            sp.z = u.sz = bound + COOLG_BOB_AMT;
        }
        return 0;
    }

    private static int InitCoolgCircle(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        u.ActorActionFunc = DoCoolgCircle;
        Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Run);
        Ai.DoActorSetSpeed(SpriteNum, 3);
        sp.xvel = (short)400;
        u.Counter2 = (short)(sp.xvel / 3);
        if (Gameutils.RANDOM_P2(1024) < 512) {
            u.Counter2 = -u.Counter2;
        }
        u.jump_speed = (short)(400 + Gameutils.RANDOM_P2(256));
        if (Pragmas.klabs(u.sz - u.hiz) < Pragmas.klabs(u.sz - u.loz)) {
            u.jump_speed = -u.jump_speed;
        }
        u.WaitTics = (short)((Gameutils.RANDOM_RANGE(3) + 1) * 120);
        u.ActorActionFunc.invoke(SpriteNum);
        return 0;
    }

    private static int DoCoolgCircle(int SpriteNum) {
        int ny;
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        sp.ang = Gameutils.NORM_ANGLE(sp.ang + u.Counter2);
        int nx = sp.xvel * Engine.sintable[Gameutils.NORM_ANGLE(sp.ang + 512)] >> 14;
        if (!Sprites.move_actor(SpriteNum, nx, ny = sp.xvel * Engine.sintable[sp.ang] >> 14, 0)) {
            Ai.InitActorReposition.invoke(SpriteNum);
            return 0;
        }
        u.sz -= u.jump_speed * 6;
        int bound = u.hiz + u.ceiling_dist + COOLG_BOB_AMT;
        if (u.sz < bound) {
            u.sz = bound;
            Ai.InitActorReposition.invoke(SpriteNum);
            return 0;
        }
        u.WaitTics = (short)(u.WaitTics - 6);
        if (u.WaitTics < 0) {
            Ai.InitActorReposition.invoke(SpriteNum);
            u.WaitTics = 0;
            return 0;
        }
        return 0;
    }

    private static int DoCoolgDeath(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        sp.cstat = (short)(sp.cstat & ~Gameutils.CSTAT_SPRITE_TRANSLUCENT);
        sp.cstat = (short)(sp.cstat & ~Gameutils.CSTAT_SPRITE_INVISIBLE);
        sp.xrepeat = (short)42;
        sp.shade = (byte)-10;
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_FALLING)) {
            Actor.DoFall(SpriteNum);
        } else {
            Weapon.DoFindGroundPoint(SpriteNum);
            u.floor_dist = 0;
            Actor.DoBeginFall(SpriteNum);
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        int nx = sp.xvel * Engine.sintable[Gameutils.NORM_ANGLE(sp.ang + 512)] >> 14;
        int ny = sp.xvel * Engine.sintable[sp.ang] >> 14;
        u.ret = Sprites.move_sprite(SpriteNum, nx, ny, 0, u.ceiling_dist, u.floor_dist, Gameutils.CLIPMASK_MISSILE, 6);
        Weapon.DoFindGroundPoint(SpriteNum);
        if (sp.z >= u.loz) {
            u.Flags &= ~(Gameutils.SPR_FALLING | Gameutils.SPR_SLIDING);
            sp.cstat = (short)(sp.cstat & ~Gameutils.CSTAT_SPRITE_YFLIP);
            Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Dead);
            return 0;
        }
        return 0;
    }

    private static int DoCoolgMove(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        if ((u.ShellNum -= 6) <= 0) {
            switch (u.FlagOwner) {
                case 0: {
                    sp.cstat = (short)(sp.cstat | Gameutils.CSTAT_SPRITE_TRANSLUCENT);
                    u.ShellNum = Gameutils.SEC(2);
                    break;
                }
                case 1: {
                    Sound.PlaySound(213, sp, 1);
                    sp.cstat = (short)(sp.cstat & ~Gameutils.CSTAT_SPRITE_TRANSLUCENT);
                    sp.cstat = (short)(sp.cstat | Gameutils.CSTAT_SPRITE_INVISIBLE);
                    u.ShellNum = Gameutils.SEC(1) + Gameutils.SEC(Gameutils.RANDOM_RANGE(2));
                    break;
                }
                case 2: {
                    sp.cstat = (short)(sp.cstat | Gameutils.CSTAT_SPRITE_TRANSLUCENT);
                    sp.cstat = (short)(sp.cstat & ~Gameutils.CSTAT_SPRITE_INVISIBLE);
                    u.ShellNum = Gameutils.SEC(2);
                    break;
                }
                case 3: {
                    Sound.PlaySound(213, sp, 1);
                    sp.cstat = (short)(sp.cstat & ~Gameutils.CSTAT_SPRITE_TRANSLUCENT);
                    sp.cstat = (short)(sp.cstat & ~Gameutils.CSTAT_SPRITE_INVISIBLE);
                    u.ShellNum = Gameutils.SEC(2) + Gameutils.SEC(Gameutils.RANDOM_RANGE(3));
                    break;
                }
                default: {
                    u.FlagOwner = 0;
                }
            }
            u.FlagOwner = (short)(u.FlagOwner + 1);
            if (u.FlagOwner > 3) {
                u.FlagOwner = 0;
            }
        }
        if (u.FlagOwner - 1 == 0) {
            sp.xrepeat = (short)(sp.xrepeat - 1);
            sp.shade = (byte)(sp.shade + 1);
            if (sp.xrepeat < 4) {
                sp.xrepeat = (short)4;
            }
            if (sp.shade > 126) {
                sp.shade = (byte)127;
                sp.hitag = (short)9998;
            }
        } else if (u.FlagOwner - 1 == 2) {
            sp.hitag = 0;
            sp.xrepeat = (short)(sp.xrepeat + 1);
            sp.shade = (byte)(sp.shade - 1);
            if (sp.xrepeat > 42) {
                sp.xrepeat = (short)42;
            }
            if (sp.shade < -10) {
                sp.shade = (byte)-10;
            }
        } else if (u.FlagOwner == 0) {
            sp.xrepeat = (short)42;
            sp.shade = (byte)-10;
            sp.hitag = 0;
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (u.track >= 0) {
            Track.ActorFollowTrack(SpriteNum, 6);
        } else {
            u.ActorActionFunc.invoke(SpriteNum);
        }
        if (Gameutils.RANDOM_P2(1024) < 32 && !MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_INVISIBLE)) {
            Weapon.InitCoolgDrip(SpriteNum);
        }
        Coolg.DoCoolgMatchPlayerZ(SpriteNum);
        Actor.DoActorSectorDamage(SpriteNum);
        return 0;
    }

    private static int DoCoolgPain(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        Coolg.NullCoolg(SpriteNum);
        u.WaitTics = (short)(u.WaitTics - 6);
        if (u.WaitTics <= 0) {
            Ai.InitActorDecide(SpriteNum);
        }
        return 0;
    }

    public static void CoolgSaveable() {
        Saveable.SaveData(DoCoolgBirth);
        Saveable.SaveData(NullCoolg);
        Saveable.SaveData(InitCoolgCircle);
        Saveable.SaveData(DoCoolgCircle);
        Saveable.SaveData(DoCoolgDeath);
        Saveable.SaveData(DoCoolgMove);
        Saveable.SaveData(DoCoolgPain);
        Saveable.SaveData(CoolgPersonality);
        Saveable.SaveData(CoolgAttrib);
        Saveable.SaveData(s_CoolgRun);
        Saveable.SaveGroup(CoolgStateGroup.sg_CoolgRun);
        Saveable.SaveData(s_CoolgStand);
        Saveable.SaveGroup(CoolgStateGroup.sg_CoolgStand);
        Saveable.SaveData(s_CoolgAttack);
        Saveable.SaveGroup(CoolgStateGroup.sg_CoolgAttack);
        Saveable.SaveData(s_CoolgPain);
        Saveable.SaveGroup(CoolgStateGroup.sg_CoolgPain);
        Saveable.SaveData(s_CoolgDie);
        Saveable.SaveGroup(CoolgStateGroup.sg_CoolgDie);
        Saveable.SaveData(s_CoolgDead);
        Saveable.SaveGroup(CoolgStateGroup.sg_CoolgDead);
        Saveable.SaveData(s_CoolgBirth);
        Saveable.SaveData(CoolgActionSet);
    }

    static /* synthetic */ State[][] access$7() {
        return s_CoolgStand;
    }

    static /* synthetic */ State[][] access$8() {
        return s_CoolgRun;
    }

    static /* synthetic */ State[][] access$9() {
        return s_CoolgPain;
    }

    static /* synthetic */ State[] access$10() {
        return s_CoolgDie;
    }

    static /* synthetic */ State[] access$11() {
        return s_CoolgDead;
    }

    static /* synthetic */ State[][] access$12() {
        return s_CoolgAttack;
    }

    public static enum CoolgStateGroup implements Sprites.StateGroup
    {
        sg_CoolgStand(Coolg.access$7()[0], Coolg.access$7()[1], Coolg.access$7()[2], Coolg.access$7()[3], Coolg.access$7()[4]),
        sg_CoolgRun(Coolg.access$8()[0], Coolg.access$8()[1], Coolg.access$8()[2], Coolg.access$8()[3], Coolg.access$8()[4]),
        sg_CoolgPain(Coolg.access$9()[0], Coolg.access$9()[1], Coolg.access$9()[2], Coolg.access$9()[3], Coolg.access$9()[4]),
        sg_CoolgDie(new State[][]{Coolg.access$10()}),
        sg_CoolgDead(new State[][]{Coolg.access$11()}),
        sg_CoolgAttack(Coolg.access$12()[0], Coolg.access$12()[1], Coolg.access$12()[2], Coolg.access$12()[3], Coolg.access$12()[4]);

        private final State[][] group;
        private int index = -1;

        private CoolgStateGroup(State[] ... states) {
            this.group = states;
        }

        @Override
        public State getState(int rotation, int offset) {
            return this.group[rotation][offset];
        }

        @Override
        public State getState(int rotation) {
            return this.group[rotation][0];
        }

        @Override
        public int getLength(int rotation) {
            return this.group[rotation].length;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public void setIndex(int index) {
            this.index = index;
        }
    }
}

