/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Enemies;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Enemies.Coolie;
import ru.m210projects.Wang.Enemies.Decision;
import ru.m210projects.Wang.Enemies.Personality;
import ru.m210projects.Wang.Enemies.Ripper2;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Player;
import ru.m210projects.Wang.Rooms;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.ATTRIBUTE;
import ru.m210projects.Wang.Type.Actor_Action_Set;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Weapon;

public class Ripper {
    private static final Decision[] RipperBattle = new Decision[]{new Decision(748, Ai.InitActorMoveCloser), new Decision(750, Ai.InitActorAlertNoise), new Decision(755, Ai.InitActorAttackNoise), new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] RipperOffense = new Decision[]{new Decision(700, Ai.InitActorMoveCloser), new Decision(710, Ai.InitActorAlertNoise), new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] RipperBroadcast = new Decision[]{new Decision(3, Ai.InitActorAlertNoise), new Decision(6, Ai.InitActorAmbientNoise), new Decision(1024, Ai.InitActorDecide)};
    private static final Animator InitRipperHang = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return Ripper.InitRipperHang(SpriteNum) != 0;
        }
    };
    private static final Decision[] RipperSurprised = new Decision[]{new Decision(30, InitRipperHang), new Decision(701, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] RipperEvasive = new Decision[]{new Decision(6, InitRipperHang), new Decision(1024, null)};
    private static final Decision[] RipperLostTarget = new Decision[]{new Decision(980, Ai.InitActorFindPlayer), new Decision(1024, Ai.InitActorWanderAround)};
    private static final Decision[] RipperCloseRange = new Decision[]{new Decision(900, Ai.InitActorAttack), new Decision(1024, Ai.InitActorReposition)};
    private static final Personality RipperPersonality = new Personality(RipperBattle, RipperOffense, RipperBroadcast, RipperSurprised, RipperEvasive, RipperLostTarget, RipperCloseRange, RipperCloseRange);
    private static final ATTRIBUTE RipperAttrib;
    public static final int RIPPER_RUN_RATE = 16;
    private static final Animator DoRipperMove;
    private static final State[][] s_RipperRun;
    public static final int RIPPER_STAND_RATE = 12;
    private static final State[][] s_RipperStand;
    public static final int RIPPER_SWIPE_RATE = 8;
    private static final Animator NullRipper;
    private static final State[][] s_RipperSwipe;
    public static final int RIPPER_SPEW_RATE = 8;
    public static final Animator InitCoolgFire;
    private static final State[][] s_RipperSpew;
    public static final int RIPPER_HEART_RATE = 14;
    private static final Animator DoRipperStandHeart;
    private static final State[][] s_RipperHeart;
    public static final int RIPPER_HANG_RATE = 14;
    private static final Animator DoRipperHang;
    private static final State[][] s_RipperHang;
    public static final int RIPPER_PAIN_RATE = 38;
    private static final Animator DoRipperPain;
    private static final State[][] s_RipperPain;
    public static final int RIPPER_JUMP_RATE = 25;
    private static final Animator DoRipperMoveJump;
    private static final State[][] s_RipperJump;
    public static final int RIPPER_FALL_RATE = 25;
    private static final State[][] s_RipperFall;
    public static final int RIPPER_JUMP_ATTACK_RATE = 35;
    private static final Animator DoRipperBeginJumpAttack;
    private static final State[][] s_RipperJumpAttack;
    public static final int RIPPER_HANG_JUMP_RATE = 20;
    private static final Animator DoRipperHangJF;
    private static final State[][] s_RipperHangJump;
    private static final State[][] s_RipperHangFall;
    public static final int RIPPER_DIE_RATE = 16;
    private static final State[] s_RipperDie;
    public static final int RIPPER_DEAD_RATE = 8;
    private static final State[] s_RipperDead;
    private static final Animator DoActorDeathMove;
    private static final State[] s_RipperDeathJump;
    private static final State[] s_RipperDeathFall;
    private static final Actor_Action_Set RipperActionSet;
    private static final Actor_Action_Set RipperBrownActionSet;

    static {
        short[] sArray = new short[4];
        sArray[0] = 5;
        sArray[2] = -2;
        sArray[3] = -4;
        int[] nArray = new int[10];
        nArray[0] = 95;
        nArray[1] = 96;
        nArray[2] = 97;
        nArray[3] = 98;
        nArray[4] = 99;
        nArray[5] = 100;
        RipperAttrib = new ATTRIBUTE(new short[]{200, 220, 240, 280}, sArray, 3, nArray);
        DoRipperMove = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Ripper.DoRipperMove(SpriteNum) != 0;
            }
        };
        s_RipperRun = new State[][]{{new State(1580, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove), new State(1581, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove), new State(1582, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove), new State(1583, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove)}, {new State(1584, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove), new State(1585, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove), new State(1586, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove), new State(1587, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove)}, {new State(1588, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove), new State(1589, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove), new State(1590, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove), new State(1591, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove)}, {new State(1592, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove), new State(1593, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove), new State(1594, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove), new State(1595, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove)}, {new State(1596, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove), new State(1597, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove), new State(1598, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove), new State(1599, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipperMove)}};
        s_RipperStand = new State[][]{{new State(1620, 12, DoRipperMove).setNext()}, {new State(1622, 12, DoRipperMove).setNext()}, {new State(1624, 12, DoRipperMove).setNext()}, {new State(1626, 12, DoRipperMove).setNext()}, {new State(1628, 12, DoRipperMove).setNext()}};
        NullRipper = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Ripper.NullRipper(SpriteNum) != 0;
            }
        };
        s_RipperSwipe = new State[][]{{new State(1600, 8, NullRipper), new State(1601, 8, NullRipper), new State(1601, Gameutils.SF_QUICK_CALL, Ripper2.InitRipperSlash), new State(1602, 8, NullRipper), new State(1603, 8, NullRipper), new State(1603, Gameutils.SF_QUICK_CALL, Ripper2.InitRipperSlash), new State(1603, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1603, 8, DoRipperMove).setNext()}, {new State(1604, 8, NullRipper), new State(1605, 8, NullRipper), new State(1605, Gameutils.SF_QUICK_CALL, Ripper2.InitRipperSlash), new State(1606, 8, NullRipper), new State(1607, 8, NullRipper), new State(1607, Gameutils.SF_QUICK_CALL, Ripper2.InitRipperSlash), new State(1607, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1607, 8, DoRipperMove).setNext()}, {new State(1608, 8, NullRipper), new State(1609, 8, NullRipper), new State(1609, Gameutils.SF_QUICK_CALL, Ripper2.InitRipperSlash), new State(1610, 8, NullRipper), new State(1611, 8, NullRipper), new State(1611, Gameutils.SF_QUICK_CALL, Ripper2.InitRipperSlash), new State(1611, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1611, 8, DoRipperMove).setNext()}, {new State(1612, 8, NullRipper), new State(1613, 8, NullRipper), new State(1613, Gameutils.SF_QUICK_CALL, Ripper2.InitRipperSlash), new State(1614, 8, NullRipper), new State(1615, 8, NullRipper), new State(1615, Gameutils.SF_QUICK_CALL, Ripper2.InitRipperSlash), new State(1615, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1615, 8, DoRipperMove).setNext()}, {new State(1616, 8, NullRipper), new State(1617, 8, NullRipper), new State(1617, Gameutils.SF_QUICK_CALL, Ripper2.InitRipperSlash), new State(1618, 8, NullRipper), new State(1619, 8, NullRipper), new State(1619, Gameutils.SF_QUICK_CALL, Ripper2.InitRipperSlash), new State(1619, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1619, 8, DoRipperMove).setNext()}};
        InitCoolgFire = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Weapon.InitCoolgFire(SpriteNum) != 0;
            }
        };
        s_RipperSpew = new State[][]{{new State(1600, 8, NullRipper), new State(1601, 8, NullRipper), new State(1601, Gameutils.SF_QUICK_CALL, InitCoolgFire), new State(1602, 8, NullRipper), new State(1603, 8, NullRipper), new State(1603, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1603, 8, DoRipperMove).setNext()}, {new State(1604, 8, NullRipper), new State(1605, 8, NullRipper), new State(1605, Gameutils.SF_QUICK_CALL, InitCoolgFire), new State(1606, 8, NullRipper), new State(1607, 8, NullRipper), new State(1607, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1607, 8, DoRipperMove).setNext()}, {new State(1608, 8, NullRipper), new State(1609, 8, NullRipper), new State(1609, Gameutils.SF_QUICK_CALL, InitCoolgFire), new State(1610, 8, NullRipper), new State(1611, 8, NullRipper), new State(1611, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1611, 8, DoRipperMove).setNext()}, {new State(1612, 8, NullRipper), new State(1613, 8, NullRipper), new State(1613, Gameutils.SF_QUICK_CALL, InitCoolgFire), new State(1614, 8, NullRipper), new State(1615, 8, NullRipper), new State(1615, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1615, 8, DoRipperMove).setNext()}, {new State(1616, 8, NullRipper), new State(1617, 8, NullRipper), new State(1617, Gameutils.SF_QUICK_CALL, InitCoolgFire), new State(1618, 8, NullRipper), new State(1619, 8, NullRipper), new State(1619, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1619, 8, DoRipperMove).setNext()}};
        DoRipperStandHeart = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Ripper.DoRipperStandHeart(SpriteNum) != 0;
            }
        };
        s_RipperHeart = new State[][]{{new State(1635, 14, DoRipperStandHeart).setNext()}, {new State(1635, 14, DoRipperStandHeart).setNext()}, {new State(1635, 14, DoRipperStandHeart).setNext()}, {new State(1635, 14, DoRipperStandHeart).setNext()}, {new State(1635, 14, DoRipperStandHeart).setNext()}};
        DoRipperHang = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Ripper.DoRipperHang(SpriteNum) != 0;
            }
        };
        s_RipperHang = new State[][]{{new State(1645, 14, DoRipperHang).setNext()}, {new State(1645, 14, DoRipperHang).setNext()}, {new State(1639, 14, DoRipperHang).setNext()}, {new State(1637, 14, DoRipperHang).setNext()}, {new State(1635, 14, DoRipperHang).setNext()}};
        DoRipperPain = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Ripper.DoRipperPain(SpriteNum) != 0;
            }
        };
        s_RipperPain = new State[][]{{new State(1620, 38, DoRipperPain).setNext()}, {new State(1620, 38, DoRipperPain).setNext()}, {new State(1620, 38, DoRipperPain).setNext()}, {new State(1620, 38, DoRipperPain).setNext()}, {new State(1620, 38, DoRipperPain).setNext()}};
        DoRipperMoveJump = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Ripper.DoRipperMoveJump(SpriteNum) != 0;
            }
        };
        s_RipperJump = new State[][]{{new State(1620, 25, NullRipper), new State(1621, 25, DoRipperMoveJump).setNext()}, {new State(1622, 25, NullRipper), new State(1623, 25, DoRipperMoveJump).setNext()}, {new State(1624, 25, NullRipper), new State(1625, 25, DoRipperMoveJump).setNext()}, {new State(1626, 25, NullRipper), new State(1627, 25, DoRipperMoveJump).setNext()}, {new State(1628, 25, NullRipper), new State(1629, 25, DoRipperMoveJump).setNext()}};
        s_RipperFall = new State[][]{{new State(1621, 25, DoRipperMoveJump).setNext()}, {new State(1623, 25, DoRipperMoveJump).setNext()}, {new State(1625, 25, DoRipperMoveJump).setNext()}, {new State(1627, 25, DoRipperMoveJump).setNext()}, {new State(1629, 25, DoRipperMoveJump).setNext()}};
        DoRipperBeginJumpAttack = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Ripper.DoRipperBeginJumpAttack(SpriteNum) != 0;
            }
        };
        s_RipperJumpAttack = new State[][]{{new State(1620, 35, NullRipper), new State(1620, Gameutils.SF_QUICK_CALL, DoRipperBeginJumpAttack), new State(1621, 35, DoRipperMoveJump).setNext()}, {new State(1622, 35, NullRipper), new State(1622, Gameutils.SF_QUICK_CALL, DoRipperBeginJumpAttack), new State(1623, 35, DoRipperMoveJump).setNext()}, {new State(1624, 35, NullRipper), new State(1624, Gameutils.SF_QUICK_CALL, DoRipperBeginJumpAttack), new State(1625, 35, DoRipperMoveJump).setNext()}, {new State(1626, 35, NullRipper), new State(1626, Gameutils.SF_QUICK_CALL, DoRipperBeginJumpAttack), new State(1627, 35, DoRipperMoveJump).setNext()}, {new State(1628, 35, NullRipper), new State(1628, Gameutils.SF_QUICK_CALL, DoRipperBeginJumpAttack), new State(1629, 35, DoRipperMoveJump).setNext()}};
        DoRipperHangJF = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Ripper.DoRipperHangJF(SpriteNum) != 0;
            }
        };
        s_RipperHangJump = new State[][]{{new State(1620, 20, NullRipper), new State(1621, 20, DoRipperHangJF).setNext()}, {new State(1622, 20, NullRipper), new State(1623, 20, DoRipperHangJF).setNext()}, {new State(1624, 20, NullRipper), new State(1625, 20, DoRipperHangJF).setNext()}, {new State(1626, 20, NullRipper), new State(1627, 20, DoRipperHangJF).setNext()}, {new State(1628, 20, NullRipper), new State(1629, 20, DoRipperHangJF).setNext()}};
        s_RipperHangFall = new State[][]{{new State(1621, 25, DoRipperHangJF).setNext()}, {new State(1623, 25, DoRipperHangJF).setNext()}, {new State(1625, 25, DoRipperHangJF).setNext()}, {new State(1627, 25, DoRipperHangJF).setNext()}, {new State(1629, 25, DoRipperHangJF).setNext()}};
        s_RipperDie = new State[]{new State(1640, 16, NullRipper), new State(1641, 16, NullRipper), new State(1642, 16, NullRipper), new State(1643, 16, NullRipper), new State(1643, 16, Actor.DoActorDebris).setNext()};
        s_RipperDead = new State[]{new State(1642, 8, null), new State(1643, 8, null), new State(1643, Gameutils.SF_QUICK_CALL, Player.QueueFloorBlood), new State(1643, 8, Actor.DoActorDebris).setNext()};
        DoActorDeathMove = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Actor.DoActorDeathMove(SpriteNum) != 0;
            }
        };
        s_RipperDeathJump = new State[]{new State(1640, 16, DoActorDeathMove).setNext()};
        s_RipperDeathFall = new State[]{new State(1641, 16, DoActorDeathMove).setNext()};
        RipperActionSet = new Actor_Action_Set(RipperStateGroup.sg_RipperStand, RipperStateGroup.sg_RipperRun, RipperStateGroup.sg_RipperJump, RipperStateGroup.sg_RipperFall, null, null, null, null, null, null, null, RipperStateGroup.sg_RipperPain, RipperStateGroup.sg_RipperDie, null, RipperStateGroup.sg_RipperDead, RipperStateGroup.sg_RipperDeathJump, RipperStateGroup.sg_RipperDeathFall, new Sprites.StateGroup[]{RipperStateGroup.sg_RipperSwipe, RipperStateGroup.sg_RipperSpew}, new short[]{800, 1024}, new Sprites.StateGroup[]{RipperStateGroup.sg_RipperJumpAttack, RipperStateGroup.sg_RipperSpew}, new short[]{400, 1024}, new Sprites.StateGroup[]{RipperStateGroup.sg_RipperHeart, RipperStateGroup.sg_RipperHang}, null, null);
        RipperBrownActionSet = new Actor_Action_Set(RipperStateGroup.sg_RipperStand, RipperStateGroup.sg_RipperRun, RipperStateGroup.sg_RipperJump, RipperStateGroup.sg_RipperFall, null, null, null, null, null, null, null, RipperStateGroup.sg_RipperPain, RipperStateGroup.sg_RipperDie, null, RipperStateGroup.sg_RipperDead, RipperStateGroup.sg_RipperDeathJump, RipperStateGroup.sg_RipperDeathFall, new Sprites.StateGroup[]{RipperStateGroup.sg_RipperSwipe}, new short[]{1024}, new Sprites.StateGroup[]{RipperStateGroup.sg_RipperJumpAttack, RipperStateGroup.sg_RipperSwipe}, new short[]{800, 1024}, new Sprites.StateGroup[]{RipperStateGroup.sg_RipperHeart, RipperStateGroup.sg_RipperHang}, null, null);
    }

    public static void InitRipperStates() {
        RipperStateGroup[] ripperStateGroupArray = RipperStateGroup.values();
        int n = ripperStateGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            RipperStateGroup sg = ripperStateGroupArray[n2];
            int rot = 0;
            while (rot < sg.group.length) {
                State.InitState(sg.group[rot]);
                ++rot;
            }
            ++n2;
        }
    }

    public static int SetupRipper(int SpriteNum) {
        USER u;
        SPRITE sp = Engine.sprite[SpriteNum];
        if (MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_RESTORE)) {
            u = Gameutils.pUser[SpriteNum];
        } else {
            Gameutils.pUser[SpriteNum] = u = Sprites.SpawnUser(SpriteNum, 1580, s_RipperRun[0][0]);
            u.Health = (short)35;
        }
        Sprites.ChangeState(SpriteNum, s_RipperRun[0][0]);
        u.Attrib = RipperAttrib;
        Ai.DoActorSetSpeed(SpriteNum, 3);
        u.StateEnd = s_RipperDie[0];
        u.Rot = RipperStateGroup.sg_RipperRun;
        sp.xrepeat = (short)64;
        sp.yrepeat = (short)64;
        if (sp.pal == 7) {
            Coolie.EnemyDefaults(SpriteNum, RipperBrownActionSet, RipperPersonality);
            sp.xrepeat = (short)106;
            sp.yrepeat = (short)90;
            if (!MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_RESTORE)) {
                u.Health = (short)500;
            }
            sp.clipdist += 32;
        } else {
            Coolie.EnemyDefaults(SpriteNum, RipperActionSet, RipperPersonality);
        }
        u.Flags |= Gameutils.SPR_XFLIP_TOGGLE;
        return 0;
    }

    private static int GetJumpHeight(short jump_speed, short jump_grav) {
        jump_speed = (short)Pragmas.klabs(jump_speed);
        int jump_iterations = jump_speed / (jump_grav * 6);
        int height = jump_speed * jump_iterations * 6;
        height = MyTypes.DIV256(height);
        return MyTypes.DIV2(height);
    }

    public static int PickJumpSpeed(int SpriteNum, int pix_height) {
        USER u = Gameutils.pUser[SpriteNum];
        u.jump_speed = (short)-600;
        u.jump_grav = (short)8;
        while (Ripper.GetJumpHeight(u.jump_speed, u.jump_grav) <= pix_height + 20) {
            u.jump_speed = (short)(u.jump_speed - 100);
        }
        return u.jump_speed;
    }

    public static int PickJumpMaxSpeed(int SpriteNum, int max_speed) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        u.jump_speed = (short)max_speed;
        u.jump_grav = (short)8;
        int zh = Gameutils.SPRITEp_TOS(sp);
        while (zh - Gameutils.Z(Ripper.GetJumpHeight(u.jump_speed, u.jump_grav)) - Gameutils.Z(16) <= u.hiz) {
            u.jump_speed = (short)(u.jump_speed + 100);
            if (u.jump_speed <= -200) continue;
        }
        return u.jump_speed;
    }

    private static int InitRipperHang(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        int hitsect = -2;
        boolean Found = false;
        int dang = 0;
        while (dang < 2048) {
            short tang = Gameutils.NORM_ANGLE(sp.ang + dang);
            Rooms.FAFhitscan(sp.x, sp.y, sp.z - Gameutils.SPRITEp_SIZE_Z(sp), sp.sectnum, Engine.sintable[Gameutils.NORM_ANGLE(tang + 512)], Engine.sintable[tang], 0, Engine.pHitInfo, Gameutils.CLIPMASK_MISSILE);
            hitsect = Engine.pHitInfo.hitsect;
            short hitwall = Engine.pHitInfo.hitwall;
            int hitx = Engine.pHitInfo.hitx;
            int hity = Engine.pHitInfo.hity;
            if (hitsect >= 0) {
                int dist = Game.Distance(sp.x, sp.y, hitx, hity);
                if (hitwall >= 0 && dist >= 2000 && dist <= 7000) {
                    Found = true;
                    sp.ang = tang;
                    break;
                }
            }
            dang = (short)(dang + 128);
        }
        if (!Found) {
            Ai.InitActorDecide(SpriteNum);
            return 0;
        }
        Sprites.NewStateGroup(SpriteNum, RipperStateGroup.sg_RipperHangJump);
        u.StateFallOverride = RipperStateGroup.sg_RipperHangFall;
        Ai.DoActorSetSpeed(SpriteNum, 3);
        Ripper.PickJumpMaxSpeed(SpriteNum, -800);
        u.Flags |= Gameutils.SPR_JUMPING;
        u.Flags &= ~Gameutils.SPR_FALLING;
        u.jump_grav = (short)8;
        Actor.DoJump(SpriteNum);
        return 0;
    }

    private static int DoRipperHang(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        u.WaitTics = (short)(u.WaitTics - 6);
        if (u.WaitTics > 0) {
            return 0;
        }
        Sprites.NewStateGroup(SpriteNum, RipperStateGroup.sg_RipperJumpAttack);
        u.Tics += u.State.Tics;
        return 0;
    }

    private static int DoRipperMoveHang(int SpriteNum) {
        int ny;
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        int nx = sp.xvel * Engine.sintable[Gameutils.NORM_ANGLE(sp.ang + 512)] >> 14;
        if (!Sprites.move_actor(SpriteNum, nx, ny = sp.xvel * Engine.sintable[sp.ang] >> 14, 0)) {
            switch (MyTypes.DTEST(u.ret, 57344)) {
                case 32768: {
                    short hitwall = Gameutils.NORM_WALL(u.ret);
                    Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Special[1]);
                    u.WaitTics = (short)(2 + (Gameutils.RANDOM_P2(1024) >> 8) * 120);
                    short w = hitwall;
                    short nw = Engine.wall[w].point2;
                    sp.ang = Gameutils.NORM_ANGLE(Main.engine.getangle(Engine.wall[nw].x - Engine.wall[w].x, Engine.wall[nw].y - Engine.wall[w].y) - 512);
                    return 0;
                }
            }
        }
        return 0;
    }

    private static int DoRipperHangJF(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING)) {
                Actor.DoJump(SpriteNum);
            } else {
                Actor.DoFall(SpriteNum);
            }
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (Ripper.DoRipperQuickJump(SpriteNum) != 0) {
                return 0;
            }
            Ai.InitActorDecide(SpriteNum);
        }
        Ripper.DoRipperMoveHang(SpriteNum);
        return 0;
    }

    private static final int RANDOM_NEG(int x) {
        return Gameutils.RANDOM_P2(x << 1) - x;
    }

    private static int DoRipperBeginJumpAttack(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE psp = Engine.sprite[Gameutils.pUser[SpriteNum].tgt_sp];
        short tang = Main.engine.getangle(psp.x - sp.x, psp.y - sp.y);
        sp.ang = Sprites.move_sprite(SpriteNum, Engine.sintable[Gameutils.NORM_ANGLE(tang + 512)] >> 7, Engine.sintable[tang] >> 7, 0, u.ceiling_dist, u.floor_dist, Gameutils.CLIPMASK_ACTOR, 6) != 0 ? Gameutils.NORM_ANGLE(sp.ang + 1024 + (Ripper.RANDOM_NEG(16384) >> 6)) : Gameutils.NORM_ANGLE(tang + (Ripper.RANDOM_NEG(16384) >> 6));
        Ai.DoActorSetSpeed(SpriteNum, 3);
        Ripper.PickJumpMaxSpeed(SpriteNum, -400);
        u.Flags |= Gameutils.SPR_JUMPING;
        u.Flags &= ~Gameutils.SPR_FALLING;
        u.jump_grav = (short)17;
        Sprites.DoActorZrange(SpriteNum);
        Actor.DoJump(SpriteNum);
        return 0;
    }

    private static int DoRipperMoveJump(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING)) {
                Actor.DoJump(SpriteNum);
            } else {
                Actor.DoFall(SpriteNum);
            }
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (Ripper.DoRipperQuickJump(SpriteNum) != 0) {
                return 0;
            }
            Ai.InitActorDecide(SpriteNum);
        }
        Ripper.DoRipperMoveHang(SpriteNum);
        return 0;
    }

    private static int DoRipperQuickJump(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        if (u.lo_sp != -1) {
            SPRITE tsp = Engine.sprite[u.lo_sp];
            if (MyTypes.TEST(tsp.extra, Gameutils.SPRX_PLAYER_OR_ENEMY)) {
                Sprites.NewStateGroup(SpriteNum, RipperStateGroup.sg_RipperJumpAttack);
                u.Tics = 30;
                return 1;
            }
        }
        return 0;
    }

    private static int NullRipper(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        Actor.DoActorSectorDamage(SpriteNum);
        return 0;
    }

    private static int DoRipperPain(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        Ripper.NullRipper(SpriteNum);
        u.WaitTics = (short)(u.WaitTics - 6);
        if (u.WaitTics <= 0) {
            Ai.InitActorDecide(SpriteNum);
        }
        return 0;
    }

    public static int DoRipperRipHeart(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE tsp = Engine.sprite[u.tgt_sp];
        Sprites.NewStateGroup(SpriteNum, RipperStateGroup.sg_RipperHeart);
        u.WaitTics = (short)720;
        tsp.ang = Main.engine.getangle(sp.x - tsp.x, sp.y - tsp.y);
        return 0;
    }

    private static int DoRipperStandHeart(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        Ripper.NullRipper(SpriteNum);
        u.WaitTics = (short)(u.WaitTics - 6);
        if (u.WaitTics <= 0) {
            Sprites.NewStateGroup(SpriteNum, RipperStateGroup.sg_RipperRun);
        }
        return 0;
    }

    void RipperHatch(int Weapon2) {
        SPRITE wp = Engine.sprite[Weapon2];
        short rip_ang = (short)Gameutils.RANDOM_P2(2048);
        short newsp = Rooms.COVERinsertsprite(wp.sectnum, 0);
        SPRITE np = Engine.sprite[newsp];
        np.reset();
        np.sectnum = wp.sectnum;
        np.statnum = 0;
        np.x = wp.x;
        np.y = wp.y;
        np.z = wp.z;
        np.owner = (short)-1;
        np.yrepeat = (short)64;
        np.xrepeat = (short)64;
        np.ang = rip_ang;
        np.pal = 0;
        Ripper.SetupRipper(newsp);
        USER nu = Gameutils.pUser[newsp];
        nu.Flags |= Gameutils.SPR_ACTIVE;
        Sprites.NewStateGroup(newsp, nu.ActorActionSet.Jump);
        nu.ActorActionFunc = Ai.DoActorMoveJump;
        Ai.DoActorSetSpeed(newsp, 3);
        Ripper.PickJumpMaxSpeed(newsp, -600);
        nu.Flags |= Gameutils.SPR_JUMPING;
        nu.Flags &= ~Gameutils.SPR_FALLING;
        nu.jump_grav = (short)8;
        Sprites.DoActorZrange(newsp);
        Actor.DoJump(newsp);
    }

    private static int DoRipperMove(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        if (u.scale_speed != 0) {
            Actor.DoScaleSprite(SpriteNum);
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING)) {
                Actor.DoJump(SpriteNum);
            } else {
                Actor.DoFall(SpriteNum);
            }
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (Ripper.DoRipperQuickJump(SpriteNum) != 0) {
                return 0;
            }
            Actor.KeepActorOnFloor(SpriteNum);
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (u.track >= 0) {
            Track.ActorFollowTrack(SpriteNum, 6);
        } else {
            u.ActorActionFunc.invoke(SpriteNum);
        }
        Actor.DoActorSectorDamage(SpriteNum);
        return 0;
    }

    public static void RipperSaveable() {
        Saveable.SaveData(InitCoolgFire);
        Saveable.SaveData(DoActorDeathMove);
        Saveable.SaveData(InitRipperHang);
        Saveable.SaveData(DoRipperHang);
        Saveable.SaveData(DoRipperHangJF);
        Saveable.SaveData(DoRipperBeginJumpAttack);
        Saveable.SaveData(DoRipperMoveJump);
        Saveable.SaveData(NullRipper);
        Saveable.SaveData(DoRipperPain);
        Saveable.SaveData(DoRipperStandHeart);
        Saveable.SaveData(DoRipperMove);
        Saveable.SaveData(RipperPersonality);
        Saveable.SaveData(RipperAttrib);
        Saveable.SaveData(s_RipperRun);
        Saveable.SaveGroup(RipperStateGroup.sg_RipperRun);
        Saveable.SaveData(s_RipperStand);
        Saveable.SaveGroup(RipperStateGroup.sg_RipperStand);
        Saveable.SaveData(s_RipperSwipe);
        Saveable.SaveGroup(RipperStateGroup.sg_RipperSwipe);
        Saveable.SaveData(s_RipperSpew);
        Saveable.SaveGroup(RipperStateGroup.sg_RipperSpew);
        Saveable.SaveData(s_RipperHeart);
        Saveable.SaveGroup(RipperStateGroup.sg_RipperHeart);
        Saveable.SaveData(s_RipperHang);
        Saveable.SaveGroup(RipperStateGroup.sg_RipperHang);
        Saveable.SaveData(s_RipperPain);
        Saveable.SaveGroup(RipperStateGroup.sg_RipperPain);
        Saveable.SaveData(s_RipperJump);
        Saveable.SaveGroup(RipperStateGroup.sg_RipperJump);
        Saveable.SaveData(s_RipperFall);
        Saveable.SaveGroup(RipperStateGroup.sg_RipperFall);
        Saveable.SaveData(s_RipperJumpAttack);
        Saveable.SaveGroup(RipperStateGroup.sg_RipperJumpAttack);
        Saveable.SaveData(s_RipperHangJump);
        Saveable.SaveGroup(RipperStateGroup.sg_RipperHangJump);
        Saveable.SaveData(s_RipperHangFall);
        Saveable.SaveGroup(RipperStateGroup.sg_RipperHangFall);
        Saveable.SaveData(s_RipperDie);
        Saveable.SaveData(s_RipperDead);
        Saveable.SaveGroup(RipperStateGroup.sg_RipperDie);
        Saveable.SaveGroup(RipperStateGroup.sg_RipperDead);
        Saveable.SaveData(s_RipperDeathJump);
        Saveable.SaveData(s_RipperDeathFall);
        Saveable.SaveGroup(RipperStateGroup.sg_RipperDeathJump);
        Saveable.SaveGroup(RipperStateGroup.sg_RipperDeathFall);
        Saveable.SaveData(RipperActionSet);
        Saveable.SaveData(RipperBrownActionSet);
    }

    static /* synthetic */ State[][] access$9() {
        return s_RipperStand;
    }

    static /* synthetic */ State[][] access$10() {
        return s_RipperRun;
    }

    static /* synthetic */ State[][] access$11() {
        return s_RipperJump;
    }

    static /* synthetic */ State[][] access$12() {
        return s_RipperFall;
    }

    static /* synthetic */ State[][] access$13() {
        return s_RipperPain;
    }

    static /* synthetic */ State[] access$14() {
        return s_RipperDie;
    }

    static /* synthetic */ State[] access$15() {
        return s_RipperDead;
    }

    static /* synthetic */ State[] access$16() {
        return s_RipperDeathJump;
    }

    static /* synthetic */ State[] access$17() {
        return s_RipperDeathFall;
    }

    static /* synthetic */ State[][] access$18() {
        return s_RipperSpew;
    }

    static /* synthetic */ State[][] access$19() {
        return s_RipperJumpAttack;
    }

    static /* synthetic */ State[][] access$20() {
        return s_RipperHeart;
    }

    static /* synthetic */ State[][] access$21() {
        return s_RipperHang;
    }

    static /* synthetic */ State[][] access$22() {
        return s_RipperSwipe;
    }

    static /* synthetic */ State[][] access$23() {
        return s_RipperHangJump;
    }

    static /* synthetic */ State[][] access$24() {
        return s_RipperHangFall;
    }

    public static enum RipperStateGroup implements Sprites.StateGroup
    {
        sg_RipperStand(Ripper.access$9()[0], Ripper.access$9()[1], Ripper.access$9()[2], Ripper.access$9()[3], Ripper.access$9()[4]),
        sg_RipperRun(Ripper.access$10()[0], Ripper.access$10()[1], Ripper.access$10()[2], Ripper.access$10()[3], Ripper.access$10()[4]),
        sg_RipperJump(Ripper.access$11()[0], Ripper.access$11()[1], Ripper.access$11()[2], Ripper.access$11()[3], Ripper.access$11()[4]),
        sg_RipperFall(Ripper.access$12()[0], Ripper.access$12()[1], Ripper.access$12()[2], Ripper.access$12()[3], Ripper.access$12()[4]),
        sg_RipperPain(Ripper.access$13()[0], Ripper.access$13()[1], Ripper.access$13()[2], Ripper.access$13()[3], Ripper.access$13()[4]),
        sg_RipperDie(new State[][]{Ripper.access$14()}),
        sg_RipperDead(new State[][]{Ripper.access$15()}),
        sg_RipperDeathJump(new State[][]{Ripper.access$16()}),
        sg_RipperDeathFall(new State[][]{Ripper.access$17()}),
        sg_RipperSpew(Ripper.access$18()[0], Ripper.access$18()[1], Ripper.access$18()[2], Ripper.access$18()[3], Ripper.access$18()[4]),
        sg_RipperJumpAttack(Ripper.access$19()[0], Ripper.access$19()[1], Ripper.access$19()[2], Ripper.access$19()[3], Ripper.access$19()[4]),
        sg_RipperHeart(Ripper.access$20()[0], Ripper.access$20()[1], Ripper.access$20()[2], Ripper.access$20()[3], Ripper.access$20()[4]),
        sg_RipperHang(Ripper.access$21()[0], Ripper.access$21()[1], Ripper.access$21()[2], Ripper.access$21()[3], Ripper.access$21()[4]),
        sg_RipperSwipe(Ripper.access$22()[0], Ripper.access$22()[1], Ripper.access$22()[2], Ripper.access$22()[3], Ripper.access$22()[4]),
        sg_RipperHangJump(Ripper.access$23()[0], Ripper.access$23()[1], Ripper.access$23()[2], Ripper.access$23()[3], Ripper.access$23()[4]),
        sg_RipperHangFall(Ripper.access$24()[0], Ripper.access$24()[1], Ripper.access$24()[2], Ripper.access$24()[3], Ripper.access$24()[4]);

        private final State[][] group;
        private int index = -1;

        private RipperStateGroup(State[] ... states) {
            this.group = states;
        }

        @Override
        public State getState(int rotation, int offset) {
            return this.group[rotation][offset];
        }

        @Override
        public State getState(int rotation) {
            return this.group[rotation][0];
        }

        @Override
        public int getLength(int rotation) {
            return this.group[rotation].length;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public void setIndex(int index) {
            this.index = index;
        }
    }
}

