/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Factory;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Input.BuildControllers;
import ru.m210projects.Build.OnSceenDisplay.OSDFunc;
import ru.m210projects.Build.Pattern.BuildControls;
import ru.m210projects.Build.Pattern.BuildEngine;
import ru.m210projects.Build.Pattern.BuildFactory;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pattern.FontHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.SliderDrawable;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Wang.Factory.WangEngine;
import ru.m210projects.Wang.Factory.WangInput;
import ru.m210projects.Wang.Factory.WangMenuHandler;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Factory.WangOSDFunc;
import ru.m210projects.Wang.Factory.WangPolymost;
import ru.m210projects.Wang.Factory.WangSliderDrawable;
import ru.m210projects.Wang.Factory.WangSoftware;
import ru.m210projects.Wang.Fonts.GameFont;
import ru.m210projects.Wang.Fonts.MenuFont;
import ru.m210projects.Wang.Fonts.MiniFont;
import ru.m210projects.Wang.Fonts.StandartFont;
import ru.m210projects.Wang.Main;

public class WangFactory
extends BuildFactory {
    private Main app;

    public WangFactory(Main app) {
        super("sw.grp");
        this.app = app;
    }

    @Override
    public BuildEngine engine() throws Exception {
        Main.engine = new WangEngine(this.app);
        return Main.engine;
    }

    @Override
    public Renderer renderer(Renderer.RenderType type) {
        if (type == Renderer.RenderType.Software) {
            return new WangSoftware(this.app.pEngine);
        }
        return new WangPolymost(this.app.pEngine);
    }

    @Override
    public DefScript getBaseDef(BuildEngine engine) {
        return new DefScript(engine, false);
    }

    @Override
    public BuildControls input(BuildControllers gpmanager) {
        return new WangInput(this.app.pCfg, gpmanager);
    }

    @Override
    public OSDFunc console() {
        return new WangOSDFunc(this.app);
    }

    @Override
    public MenuHandler menus() {
        return new WangMenuHandler(this.app);
    }

    @Override
    public FontHandler fonts() {
        return new FontHandler(3){

            @Override
            protected BuildFont init(int i) {
                if (i == 0) {
                    return new MiniFont(((WangFactory)WangFactory.this).app.pEngine);
                }
                if (i == 1) {
                    return new GameFont(((WangFactory)WangFactory.this).app.pEngine);
                }
                if (i == 2) {
                    return new MenuFont(((WangFactory)WangFactory.this).app.pEngine);
                }
                return new StandartFont(((WangFactory)WangFactory.this).app.pEngine);
            }
        };
    }

    @Override
    public BuildNet net() {
        Main.gNet = this.app.net = new WangNetwork(this.app);
        return this.app.net;
    }

    @Override
    public SliderDrawable slider() {
        return new WangSliderDrawable();
    }

    @Override
    public void drawInitScreen() {
        Main.engine.clearview(117);
        Main.engine.rotatesprite(Engine.xdim << 15, Engine.ydim << 15, Pragmas.divscale(Engine.ydim, 240L, 16), 0, 2324, 0, 0, 8, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
    }
}

