/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Menus;

import java.util.Arrays;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuButton;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuText;
import ru.m210projects.Build.Pattern.MenuItems.MenuVariants;
import ru.m210projects.Build.Settings.BuildConfig;
import ru.m210projects.Wang.Config;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Menus.MenuJoystick;
import ru.m210projects.Wang.Menus.MenuMenuKeyboard;
import ru.m210projects.Wang.Menus.MenuMouse;
import ru.m210projects.Wang.Menus.WangTitle;

public class MenuControls
extends BuildMenu {
    public MenuControls(Main app) {
        this.addItem(new WangTitle("Controls Setup"), false);
        int pos = 39;
        MenuButton mMouseSet = new MenuButton("Mouse setup", app.getFont(1), 35, pos += 10, 320, 0, 0, new MenuMouse(app), -1, null, 0);
        MenuButton mJoySet = new MenuButton("Joystick setup", app.getFont(1), 35, pos += 10, 320, 0, 0, new MenuJoystick(app), -1, null, 0);
        MenuButton mKeySet = new MenuButton("Keyboard Setup", app.getFont(1), 35, pos += 10, 320, 0, 0, new MenuMenuKeyboard(app), -1, null, 0);
        MenuButton mKeyReset = new MenuButton("Reset to default", app.getFont(1), 35, pos += 15, 320, 0, 0, this.getResetDefaultMenu(app, app.getFont(1), 90, 16), -1, null, 0);
        MenuButton mKeyClassic = new MenuButton("Reset to classic", app.getFont(1), 35, pos += 10, 320, 0, 0, this.getResetClassicMenu(app, app.getFont(1), 90, 16), -1, null, 0);
        this.addItem(mMouseSet, true);
        this.addItem(mJoySet, false);
        this.addItem(mKeySet, false);
        this.addItem(mKeyReset, false);
        this.addItem(mKeyClassic, false);
    }

    private void mResetDefault(BuildConfig cfg, MenuHandler menu) {
        int i = 0;
        while (i < cfg.keymap.length) {
            cfg.primarykeys[i] = Config.defkeys[i];
            ++i;
        }
        Arrays.fill(cfg.secondkeys, 0);
        Arrays.fill(cfg.mousekeys, 0);
        cfg.mousekeys[BuildConfig.GameKeys.Weapon_Fire.getNum()] = 226;
        cfg.mousekeys[Config.SwKeys.Special_Fire.getNum()] = 227;
        cfg.mousekeys[BuildConfig.GameKeys.Open.getNum()] = 228;
        cfg.mousekeys[BuildConfig.GameKeys.Next_Weapon.getNum()] = 224;
        cfg.mousekeys[BuildConfig.GameKeys.Previous_Weapon.getNum()] = 225;
        Console.setCaptureKey(cfg.primarykeys[BuildConfig.GameKeys.Show_Console.getNum()], 0);
        Console.setCaptureKey(cfg.secondkeys[BuildConfig.GameKeys.Show_Console.getNum()], 1);
        Console.setCaptureKey(cfg.mousekeys[BuildConfig.GameKeys.Show_Console.getNum()], 2);
        menu.mMenuBack();
    }

    private void mResetClassic(BuildConfig cfg, MenuHandler menu) {
        int i = 0;
        while (i < cfg.keymap.length) {
            cfg.primarykeys[i] = Config.defclassickeys[i];
            ++i;
        }
        Arrays.fill(cfg.secondkeys, 0);
        Arrays.fill(cfg.mousekeys, 0);
        cfg.mousekeys[BuildConfig.GameKeys.Weapon_Fire.getNum()] = 226;
        cfg.mousekeys[Config.SwKeys.Special_Fire.getNum()] = 227;
        cfg.mousekeys[BuildConfig.GameKeys.Open.getNum()] = 228;
        cfg.mousekeys[BuildConfig.GameKeys.Next_Weapon.getNum()] = 224;
        cfg.mousekeys[BuildConfig.GameKeys.Previous_Weapon.getNum()] = 225;
        Console.setCaptureKey(cfg.primarykeys[BuildConfig.GameKeys.Show_Console.getNum()], 0);
        Console.setCaptureKey(cfg.secondkeys[BuildConfig.GameKeys.Show_Console.getNum()], 1);
        Console.setCaptureKey(cfg.mousekeys[BuildConfig.GameKeys.Show_Console.getNum()], 2);
        menu.mMenuBack();
    }

    protected BuildMenu getResetDefaultMenu(final BuildGame app, BuildFont style, int posy, int pal) {
        BuildMenu menu = new BuildMenu();
        MenuText QuitQuestion = new MenuText("Do you really want to reset keys?", style, 160, posy, 1);
        QuitQuestion.pal = pal;
        MenuVariants QuitVariants = new MenuVariants(app.pEngine, "[Y/N]", style, 160, posy += 2 * style.getHeight()){

            @Override
            public void positive(MenuHandler menu) {
                MenuControls.this.mResetDefault(app.pCfg, menu);
            }
        };
        QuitVariants.pal = pal;
        menu.addItem(QuitQuestion, false);
        menu.addItem(QuitVariants, true);
        return menu;
    }

    protected BuildMenu getResetClassicMenu(final BuildGame app, BuildFont style, int posy, int pal) {
        BuildMenu menu = new BuildMenu();
        MenuText QuitQuestion = new MenuText("Do you really want reset to classic keys?", style, 160, posy, 1);
        QuitQuestion.pal = pal;
        MenuVariants QuitVariants = new MenuVariants(app.pEngine, "[Y/N]", style, 160, posy += 2 * style.getHeight()){

            @Override
            public void positive(MenuHandler menu) {
                MenuControls.this.mResetClassic(app.pCfg, menu);
            }
        };
        QuitVariants.pal = pal;
        menu.addItem(QuitQuestion, false);
        menu.addItem(QuitVariants, true);
        return menu;
    }
}

