/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import java.util.Arrays;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.WALL;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Break;
import ru.m210projects.Wang.Draw;
import ru.m210projects.Wang.Enemies.Ninja;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Inv;
import ru.m210projects.Wang.JPlayer;
import ru.m210projects.Wang.JSector;
import ru.m210projects.Wang.JWeapon;
import ru.m210projects.Wang.LoadSave;
import ru.m210projects.Wang.MClip;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Palette;
import ru.m210projects.Wang.Panel;
import ru.m210projects.Wang.Quake;
import ru.m210projects.Wang.Rooms;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Shrap;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Text;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.Input;
import ru.m210projects.Wang.Type.LONGp;
import ru.m210projects.Wang.Type.List;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Panel_Sprite;
import ru.m210projects.Wang.Type.Panel_Sprite_Func;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.RTS;
import ru.m210projects.Wang.Type.Remote_Control;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.Sect_User;
import ru.m210projects.Wang.Type.Sector_Object;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.Target_Sort;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Type.VOC3D;
import ru.m210projects.Wang.Vis;
import ru.m210projects.Wang.Warp;
import ru.m210projects.Wang.Weapon;
import ru.m210projects.Wang.Weapons.Chops;
import ru.m210projects.Wang.Weapons.Fist;
import ru.m210projects.Wang.Weapons.Grenade;
import ru.m210projects.Wang.Weapons.Heart;
import ru.m210projects.Wang.Weapons.HotHead;
import ru.m210projects.Wang.Weapons.Micro;
import ru.m210projects.Wang.Weapons.Mine;
import ru.m210projects.Wang.Weapons.Rail;
import ru.m210projects.Wang.Weapons.Shotgun;
import ru.m210projects.Wang.Weapons.Star;
import ru.m210projects.Wang.Weapons.Sword;
import ru.m210projects.Wang.Weapons.Uzi;

public class Player {
    public static final int SO_DRIVE_SOUND = 2;
    public static final int SO_IDLE_SOUND = 1;
    public static short NormalVisibility;
    public static final int PLAYER_HORIZ_MAX = 299;
    public static final int PLAYER_HORIZ_MIN = -99;
    public static final int MIN_SWIM_DEPTH = 15;
    public static final int PLAYER_HEIGHT;
    public static final int PLAYER_CRAWL_HEIGHT;
    public static final int PLAYER_SWIM_HEIGHT;
    public static final int PLAYER_DIVE_HEIGHT;
    public static final int PLAYER_DIE_DOWN_HEIGHT;
    public static final int PLAYER_DIE_UP_HEIGHT;
    public static final int PLAYER_STEP_HEIGHT;
    public static final int PLAYER_CRAWL_STEP_HEIGHT;
    public static final int PLAYER_SWIM_STEP_HEIGHT;
    public static final int PLAYER_DIVE_STEP_HEIGHT;
    public static final int PLAYER_JUMP_STEP_HEIGHT;
    public static final int PLAYER_FALL_STEP_HEIGHT;
    public static final int PLAYER_RUN_FLOOR_DIST;
    public static final int PLAYER_CRAWL_FLOOR_DIST;
    public static final int PLAYER_WADE_FLOOR_DIST;
    public static final int PLAYER_JUMP_FLOOR_DIST;
    public static final int PLAYER_FALL_FLOOR_DIST;
    public static final int PLAYER_SWIM_FLOOR_DIST;
    public static final int PLAYER_DIVE_FLOOR_DIST;
    public static final int PLAYER_RUN_CEILING_DIST;
    public static final int PLAYER_SWIM_CEILING_DIST;
    public static final int PLAYER_DIVE_CEILING_DIST;
    public static final int PLAYER_CRAWL_CEILING_DIST;
    public static final int PLAYER_JUMP_CEILING_DIST;
    public static final int PLAYER_FALL_CEILING_DIST;
    public static final int PLAYER_WADE_CEILING_DIST;
    public static final int PLAYER_DIVE_MAX_SPEED = 1700;
    public static final int PLAYER_DIVE_INC = 600;
    public static final int PLAYER_DIVE_BOB_AMT;
    public static final int PLAYER_DIVE_TIME = 1440;
    public static final int PLAYER_DIVE_DAMAGE_AMOUNT = -1;
    public static final int PLAYER_DIVE_DAMAGE_TIME = 50;
    public static final int PLAYER_FLY_MAX_SPEED = 2560;
    public static final int PLAYER_FLY_INC = 1000;
    public static final int PLAYER_FLY_BOB_AMT;
    public static final int PLAYER_FALL_HEIGHT;
    public static final int PLAYER_FALL_DAMAGE_AMOUNT = 10;
    public static final int PLAYER_DEATH_HEIGHT;
    public static final int PLAYER_DEAD_HEAD_FLOORZ_OFFSET;
    public static final int PLAYER_NINJA_XREPEAT = 47;
    public static final int PLAYER_NINJA_YREPEAT = 33;
    public static final int PLAYER_MIN_HEIGHT;
    public static final int PLAYER_CRAWL_WADE_DEPTH = 30;
    boolean NightVision = false;
    public static final int PLAYER_TURN_SCALE = 12;
    public static final int PLAYER_RUN_FRICTION = 50000;
    public static final int PLAYER_JUMP_FRICTION = 50000;
    public static final int PLAYER_FALL_FRICTION = 50000;
    public static final int PLAYER_WADE_FRICTION = 50000;
    public static final int PLAYER_FLY_FRICTION = 55808;
    public static final int PLAYER_CRAWL_FRICTION = 45056;
    public static final int PLAYER_SWIM_FRICTION = 49152;
    public static final int PLAYER_DIVE_FRICTION = 49152;
    public static final int PLAYER_CLIMB_FRICTION = 45056;
    public static final int BOAT_FRICTION = 51968;
    public static final int TANK_FRICTION = 53248;
    public static final int PLAYER_SLIDE_FRICTION = 53248;
    public static final int JUMP_STUFF = 4;
    public static final int PLAYER_JUMP_GRAV = 24;
    public static final int PLAYER_JUMP_AMT = -650;
    public static final int PLAYER_CLIMB_JUMP_AMT = -1100;
    public static final int MAX_JUMP_DURATION = 12;
    public static final int PlayerGravity = 24;
    public static final int PLAYER_STANDING_ROOM;
    private static final Animator DoPlayerSpriteReset;
    private static final Animator DoFootPrints;
    public static final Animator QueueFloorBlood;
    public static final int PLAYER_NINJA_RATE = 14;
    private static State[][] s_PlayerNinjaRun;
    public static final int PLAYER_NINJA_STAND_RATE = 10;
    private static State[][] s_PlayerNinjaStand;
    public static final int NINJA_STAR_RATE = 12;
    public static final int PLAYER_NINJA_JUMP_RATE = 24;
    private static State[][] s_PlayerNinjaJump;
    public static final int PLAYER_NINJA_FALL_RATE = 16;
    private static State[][] s_PlayerNinjaFall;
    public static final int PLAYER_NINJA_CLIMB_RATE = 20;
    private static State[][] s_PlayerNinjaClimb;
    public static final int PLAYER_NINJA_CRAWL_RATE = 14;
    private static State[][] s_PlayerNinjaCrawl;
    public static final int PLAYER_NINJA_SWIM_RATE = 22;
    private static State[][] s_PlayerNinjaSwim;
    public static final int NINJA_HeadHurl_RATE = 16;
    public static final int NINJA_Head_RATE = 16;
    public static final int NINJA_HeadFly = 1134;
    public static final int NINJA_HeadFly_RATE = 16;
    private static State[][] s_PlayerHeadFly;
    private static State[][] s_PlayerHead;
    public static final int NINJA_HeadHurl_FRAMES = 1;
    public static final int NINJA_HeadHurl_R0 = 1147;
    public static final int NINJA_HeadHurl_R1 = 1148;
    public static final int NINJA_HeadHurl_R2 = 1149;
    public static final int NINJA_HeadHurl_R3 = 1150;
    public static final int NINJA_HeadHurl_R4 = 1151;
    private static State[][] s_PlayerHeadHurl;
    public static final int NINJA_DIE_RATE = 22;
    private static State[][] s_PlayerDeath;
    private static final int PLAYER_NINJA_SWORD_RATE = 12;
    private static State[][] s_PlayerNinjaSword;
    private static final int PLAYER_NINJA_PUNCH_RATE = 15;
    private static State[][] s_PlayerNinjaPunch;
    public static final int PLAYER_NINJA_FLY_RATE = 15;
    public static final int PLAYER_NINJA_FLY_R0 = 1200;
    public static final int PLAYER_NINJA_FLY_R1 = 1200;
    public static final int PLAYER_NINJA_FLY_R2 = 1200;
    public static final int PLAYER_NINJA_FLY_R3 = 1200;
    public static final int PLAYER_NINJA_FLY_R4 = 1200;
    private static State[][] s_PlayerNinjaFly;
    public static final Panel_Sprite_Func pSetVisNorm;
    public static Target_Sort[] TargetSort;
    public static short TargetSortCount;
    public static final int PICK_DIST = 40000;
    private static final int TURN_SHIFT = 2;
    public static final int HORIZ_SPEED = 16;
    private static int count;
    private static int vel;
    private static int[] x;
    private static int[] y;
    private static int[] ox;
    private static int[] oy;
    private static VOC3D handle;
    private static final int ADJ_AMT = 8;
    private static short[] angs;
    private static final short[] angles;
    private static short[] sf;
    private static short[] UnderStatList;
    private static final int PLAYER_DEATH_GRAV = 8;
    public static final int MAX_SUICIDE = 11;
    private static final String[] SuicideNote;
    public static final int MAX_KILL_NOTES = 16;
    public static final int PLAYER_DEATH_TILT_VALUE = 32;
    public static final int PLAYER_DEATH_HORIZ_UP_VALUE = 165;
    public static final int PLAYER_DEATH_HORIZ_JUMP_VALUE = 150;
    public static final int PLAYER_DEATH_HORIZ_FALL_VALUE = 50;
    private static final Player_Action_Func[] PlayerDeathFunc;
    private static final int ChopTimer = 3600;
    public static final String MSG_GAME_PAUSED = "Game Paused";
    private static boolean[] SpawnPositionUsed;
    private static short[] MultiStatList;

    static {
        PLAYER_HEIGHT = Gameutils.Z(58);
        PLAYER_CRAWL_HEIGHT = Gameutils.Z(36);
        PLAYER_SWIM_HEIGHT = Gameutils.Z(26);
        PLAYER_DIVE_HEIGHT = Gameutils.Z(26);
        PLAYER_DIE_DOWN_HEIGHT = Gameutils.Z(4);
        PLAYER_DIE_UP_HEIGHT = Gameutils.Z(8);
        PLAYER_STEP_HEIGHT = Gameutils.Z(30);
        PLAYER_CRAWL_STEP_HEIGHT = Gameutils.Z(8);
        PLAYER_SWIM_STEP_HEIGHT = Gameutils.Z(8);
        PLAYER_DIVE_STEP_HEIGHT = Gameutils.Z(8);
        PLAYER_JUMP_STEP_HEIGHT = Gameutils.Z(48);
        PLAYER_FALL_STEP_HEIGHT = Gameutils.Z(24);
        PLAYER_RUN_FLOOR_DIST = PLAYER_HEIGHT - PLAYER_STEP_HEIGHT;
        PLAYER_CRAWL_FLOOR_DIST = PLAYER_CRAWL_HEIGHT - PLAYER_CRAWL_STEP_HEIGHT;
        PLAYER_WADE_FLOOR_DIST = PLAYER_HEIGHT - PLAYER_STEP_HEIGHT;
        PLAYER_JUMP_FLOOR_DIST = PLAYER_HEIGHT - PLAYER_JUMP_STEP_HEIGHT;
        PLAYER_FALL_FLOOR_DIST = PLAYER_HEIGHT - PLAYER_FALL_STEP_HEIGHT;
        PLAYER_SWIM_FLOOR_DIST = PLAYER_SWIM_HEIGHT - PLAYER_SWIM_STEP_HEIGHT;
        PLAYER_DIVE_FLOOR_DIST = PLAYER_DIVE_HEIGHT - PLAYER_DIVE_STEP_HEIGHT;
        PLAYER_RUN_CEILING_DIST = Gameutils.Z(10);
        PLAYER_SWIM_CEILING_DIST = Gameutils.Z(12);
        PLAYER_DIVE_CEILING_DIST = Gameutils.Z(22);
        PLAYER_CRAWL_CEILING_DIST = Gameutils.Z(12);
        PLAYER_JUMP_CEILING_DIST = Gameutils.Z(4);
        PLAYER_FALL_CEILING_DIST = Gameutils.Z(4);
        PLAYER_WADE_CEILING_DIST = Gameutils.Z(4);
        PLAYER_DIVE_BOB_AMT = Gameutils.Z(8);
        PLAYER_FLY_BOB_AMT = Gameutils.Z(12);
        PLAYER_FALL_HEIGHT = Gameutils.Z(28);
        PLAYER_DEATH_HEIGHT = Gameutils.Z(16);
        PLAYER_DEAD_HEAD_FLOORZ_OFFSET = Gameutils.Z(7);
        PLAYER_MIN_HEIGHT = Gameutils.Z(20);
        PLAYER_STANDING_ROOM = Gameutils.Z(68);
        DoPlayerSpriteReset = new Animator(){

            @Override
            public boolean invoke(int spr) {
                Player.DoPlayerSpriteReset(spr);
                return false;
            }
        };
        DoFootPrints = new Animator(){

            @Override
            public boolean invoke(int spr) {
                return Player.DoFootPrints(spr) != 0;
            }
        };
        QueueFloorBlood = new Animator(){

            @Override
            public boolean invoke(int spr) {
                return Weapon.QueueFloorBlood(spr) != 0;
            }
        };
        s_PlayerNinjaRun = new State[][]{{new State(1094, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1095, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1095, Gameutils.SF_QUICK_CALL, DoFootPrints), new State(1096, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1097, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1097, Gameutils.SF_QUICK_CALL, DoFootPrints)}, {new State(1098, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1099, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1099, Gameutils.SF_QUICK_CALL, DoFootPrints), new State(1100, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1101, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1101, Gameutils.SF_QUICK_CALL, DoFootPrints)}, {new State(1102, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1103, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1103, Gameutils.SF_QUICK_CALL, DoFootPrints), new State(1104, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1105, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1105, Gameutils.SF_QUICK_CALL, DoFootPrints)}, {new State(1106, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1107, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1107, Gameutils.SF_QUICK_CALL, DoFootPrints), new State(1108, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1109, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1109, Gameutils.SF_QUICK_CALL, DoFootPrints)}, {new State(1110, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1111, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1111, Gameutils.SF_QUICK_CALL, DoFootPrints), new State(1112, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1113, 0xE | Gameutils.SF_TIC_ADJUST, null), new State(1113, Gameutils.SF_QUICK_CALL, DoFootPrints)}};
        s_PlayerNinjaStand = new State[][]{{new State(1094, 10, null).setNext()}, {new State(1098, 10, null).setNext()}, {new State(1102, 10, null).setNext()}, {new State(1106, 10, null).setNext()}, {new State(1110, 10, null).setNext()}};
        s_PlayerNinjaJump = new State[][]{{new State(1074, 24, null), new State(1075, 24, null), new State(1076, 24, null), new State(1077, 24, null).setNext()}, {new State(1078, 24, null), new State(1079, 24, null), new State(1080, 24, null), new State(1081, 24, null).setNext()}, {new State(1082, 24, null), new State(1083, 24, null), new State(1084, 24, null), new State(1085, 24, null).setNext()}, {new State(1086, 24, null), new State(1087, 24, null), new State(1088, 24, null), new State(1089, 24, null).setNext()}, {new State(1090, 24, null), new State(1091, 24, null), new State(1092, 24, null), new State(1093, 24, null).setNext()}};
        s_PlayerNinjaFall = new State[][]{{new State(1075, 16, null), new State(1076, 16, null).setNext()}, {new State(1079, 16, null), new State(1080, 16, null).setNext()}, {new State(1083, 16, null), new State(1084, 16, null).setNext()}, {new State(1087, 16, null), new State(1088, 16, null).setNext()}, {new State(1091, 16, null), new State(1092, 16, null).setNext()}};
        s_PlayerNinjaClimb = new State[][]{{new State(1024, 20, null), new State(1025, 20, null), new State(1026, 20, null), new State(1027, 20, null)}, {new State(1028, 20, null), new State(1029, 20, null), new State(1030, 20, null), new State(1031, 20, null)}, {new State(1032, 20, null), new State(1033, 20, null), new State(1034, 20, null), new State(1035, 20, null)}, {new State(1036, 20, null), new State(1037, 20, null), new State(1038, 20, null), new State(1039, 20, null)}, {new State(1040, 20, null), new State(1041, 20, null), new State(1042, 20, null), new State(1043, 20, null)}};
        s_PlayerNinjaCrawl = new State[][]{{new State(1044, 14, null), new State(1045, 14, null), new State(1045, Gameutils.SF_QUICK_CALL, DoFootPrints), new State(1046, 14, null), new State(1045, 14, null), new State(1045, Gameutils.SF_QUICK_CALL, DoFootPrints)}, {new State(1048, 14, null), new State(1049, 14, null), new State(1049, Gameutils.SF_QUICK_CALL, DoFootPrints), new State(1050, 14, null), new State(1049, 14, null), new State(1049, Gameutils.SF_QUICK_CALL, DoFootPrints)}, {new State(1052, 14, null), new State(1053, 14, null), new State(1053, Gameutils.SF_QUICK_CALL, DoFootPrints), new State(1054, 14, null), new State(1053, 14, null), new State(1053, Gameutils.SF_QUICK_CALL, DoFootPrints)}, {new State(1056, 14, null), new State(1057, 14, null), new State(1057, Gameutils.SF_QUICK_CALL, DoFootPrints), new State(1058, 14, null), new State(1057, 14, null), new State(1057, Gameutils.SF_QUICK_CALL, DoFootPrints)}, {new State(1060, 14, null), new State(1061, 14, null), new State(1061, Gameutils.SF_QUICK_CALL, DoFootPrints), new State(1062, 14, null), new State(1061, 14, null), new State(1061, Gameutils.SF_QUICK_CALL, DoFootPrints)}};
        s_PlayerNinjaSwim = new State[][]{{new State(1114, 22, null), new State(1115, 22, null), new State(1116, 22, null), new State(1117, 22, null)}, {new State(1118, 22, null), new State(1119, 22, null), new State(1120, 22, null), new State(1121, 22, null)}, {new State(1122, 22, null), new State(1123, 22, null), new State(1124, 22, null), new State(1125, 22, null)}, {new State(1126, 22, null), new State(1127, 22, null), new State(1128, 22, null), new State(1129, 22, null)}, {new State(1130, 22, null), new State(1131, 22, null), new State(1132, 22, null), new State(1133, 22, null)}};
        s_PlayerHeadFly = new State[][]{{new State(1134, 16, null), new State(1135, 16, null), new State(1136, 16, null), new State(1137, 16, null), new State(1138, 16, null), new State(1139, 16, null), new State(1140, 16, null), new State(1141, 16, null)}, {new State(1134, 16, null), new State(1135, 16, null), new State(1136, 16, null), new State(1137, 16, null), new State(1138, 16, null), new State(1139, 16, null), new State(1140, 16, null), new State(1141, 16, null)}, {new State(1134, 16, null), new State(1135, 16, null), new State(1136, 16, null), new State(1137, 16, null), new State(1138, 16, null), new State(1139, 16, null), new State(1140, 16, null), new State(1141, 16, null)}, {new State(1134, 16, null), new State(1135, 16, null), new State(1136, 16, null), new State(1137, 16, null), new State(1138, 16, null), new State(1139, 16, null), new State(1140, 16, null), new State(1141, 16, null)}, {new State(1134, 16, null), new State(1135, 16, null), new State(1136, 16, null), new State(1137, 16, null), new State(1138, 16, null), new State(1139, 16, null), new State(1140, 16, null), new State(1141, 16, null)}};
        s_PlayerHead = new State[][]{{new State(1142, 16, null).setNext()}, {new State(1143, 16, null).setNext()}, {new State(1144, 16, null).setNext()}, {new State(1145, 16, null).setNext()}, {new State(1146, 16, null).setNext()}};
        s_PlayerHeadHurl = new State[][]{{new State(1147, 16, null).setNext()}, {new State(1148, 16, null).setNext()}, {new State(1149, 16, null).setNext()}, {new State(1150, 16, null).setNext()}, {new State(1151, 16, null).setNext()}};
        s_PlayerDeath = new State[][]{{new State(1152, 22, null), new State(1153, 22, null), new State(1154, 22, null), new State(1155, 22, null), new State(1156, 22, null), new State(1157, 22, null), new State(1158, 22, null), new State(1159, 22, null), new State(1160, Gameutils.SF_QUICK_CALL, QueueFloorBlood), new State(1160, 22, null).setNext()}, {new State(1152, 22, null), new State(1153, 22, null), new State(1154, 22, null), new State(1155, 22, null), new State(1156, 22, null), new State(1157, 22, null), new State(1158, 22, null), new State(1159, 22, null), new State(1160, Gameutils.SF_QUICK_CALL, QueueFloorBlood), new State(1160, 22, null).setNext()}, {new State(1152, 22, null), new State(1153, 22, null), new State(1154, 22, null), new State(1155, 22, null), new State(1156, 22, null), new State(1157, 22, null), new State(1158, 22, null), new State(1159, 22, null), new State(1160, Gameutils.SF_QUICK_CALL, QueueFloorBlood), new State(1160, 22, null).setNext()}, {new State(1152, 22, null), new State(1153, 22, null), new State(1154, 22, null), new State(1155, 22, null), new State(1156, 22, null), new State(1157, 22, null), new State(1158, 22, null), new State(1159, 22, null), new State(1160, Gameutils.SF_QUICK_CALL, QueueFloorBlood), new State(1160, 22, null).setNext()}, {new State(1152, 22, null), new State(1153, 22, null), new State(1154, 22, null), new State(1155, 22, null), new State(1156, 22, null), new State(1157, 22, null), new State(1158, 22, null), new State(1159, 22, null), new State(1160, Gameutils.SF_QUICK_CALL, QueueFloorBlood), new State(1160, 22, null).setNext()}};
        s_PlayerNinjaSword = new State[][]{{new State(1161, 12, null), new State(1162, 12, null), new State(1163, 12, null), new State(1163, 0xC | Gameutils.SF_PLAYER_FUNC, DoPlayerSpriteReset)}, {new State(1164, 12, null), new State(1165, 12, null), new State(1166, 12, null), new State(1166, 0xC | Gameutils.SF_PLAYER_FUNC, DoPlayerSpriteReset)}, {new State(1167, 12, null), new State(1168, 12, null), new State(1169, 12, null), new State(1169, 0xC | Gameutils.SF_PLAYER_FUNC, DoPlayerSpriteReset)}, {new State(1170, 12, null), new State(1171, 12, null), new State(1172, 12, null), new State(1172, 0xC | Gameutils.SF_PLAYER_FUNC, DoPlayerSpriteReset)}, {new State(1173, 12, null), new State(1174, 12, null), new State(1175, 12, null), new State(1175, 0xC | Gameutils.SF_PLAYER_FUNC, DoPlayerSpriteReset)}};
        s_PlayerNinjaPunch = new State[][]{{new State(1176, 15, null), new State(1177, 15, null), new State(1177, 0xF | Gameutils.SF_PLAYER_FUNC, DoPlayerSpriteReset).setNext()}, {new State(1178, 15, null), new State(1179, 15, null), new State(1179, 0xF | Gameutils.SF_PLAYER_FUNC, DoPlayerSpriteReset).setNext()}, {new State(1180, 15, null), new State(1181, 15, null), new State(1181, 0xF | Gameutils.SF_PLAYER_FUNC, DoPlayerSpriteReset).setNext()}, {new State(1182, 15, null), new State(1183, 15, null), new State(1183, 0xF | Gameutils.SF_PLAYER_FUNC, DoPlayerSpriteReset).setNext()}, {new State(1184, 15, null), new State(1185, 15, null), new State(1185, 0xF | Gameutils.SF_PLAYER_FUNC, DoPlayerSpriteReset).setNext()}};
        s_PlayerNinjaFly = new State[][]{{new State(1200, 15, null).setNext()}, {new State(1200, 15, null).setNext()}, {new State(1200, 15, null).setNext()}, {new State(1200, 15, null).setNext()}, {new State(1200, 15, null).setNext()}};
        pSetVisNorm = new Panel_Sprite_Func(){

            @Override
            public void invoke(Panel_Sprite psp) {
                Player.SetVisNorm();
            }
        };
        TargetSort = new Target_Sort[16];
        count = 0;
        x = new int[4];
        y = new int[4];
        ox = new int[4];
        oy = new int[4];
        handle = null;
        angs = new short[3];
        angles = new short[]{30, -30};
        sf = new short[2];
        UnderStatList = new short[]{50, 51};
        SuicideNote = new String[]{"decided to do the graveyard tour.", "had enough and checked out.", "didn't fear the Reaper.", "dialed the 1-800-CYANIDE line.", "wasted himself.", "kicked his own ass.", "went out in blaze of his own glory.", "killed himself before anyone else could.", "needs shooting lessons.", "blew his head off.", "did everyone a favor and offed himself."};
        PlayerDeathFunc = new Player_Action_Func[]{Player_Action_Func.DoPlayerDeathFlip, Player_Action_Func.DoPlayerDeathCrumble, Player_Action_Func.DoPlayerDeathExplode, Player_Action_Func.DoPlayerDeathFlip, Player_Action_Func.DoPlayerDeathExplode, Player_Action_Func.DoPlayerDeathDrown};
        SpawnPositionUsed = new boolean[9];
        MultiStatList = new short[]{600, 610};
    }

    public static final boolean TEST_UNDERWATER(PlayerStr pp) {
        return MyTypes.TEST(Engine.sector[pp.cursectnum].extra, Gameutils.SECTFX_UNDERWATER);
    }

    public static void InitPlayerStates() {
        PlayerStateGroup[] playerStateGroupArray = PlayerStateGroup.values();
        int n = playerStateGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            PlayerStateGroup sg = playerStateGroupArray[n2];
            int rot = 0;
            while (rot < 5) {
                State.InitState(sg.group[rot]);
                ++rot;
            }
            ++n2;
        }
    }

    public static void DoPlayerSpriteThrow(PlayerStr pp) {
        if (!MyTypes.TEST(pp.Flags, Gameutils.PF_DIVING | Gameutils.PF_FLYING | Gameutils.PF_CRAWLING)) {
            if (pp.CurWpn == pp.Wpn[13] && Gameutils.pUser[pp.PlayerSprite].Rot != PlayerStateGroup.sg_PlayerNinjaSword) {
                Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerNinjaSword);
            } else {
                Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerNinjaPunch);
            }
        }
    }

    public static void DoPlayerSpriteReset(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        if (u.PlayerP == -1) {
            return;
        }
        PlayerStr pp = Game.Player[u.PlayerP];
        if (pp.DoPlayerAction == Player_Action_Func.DoPlayerCrawl) {
            Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Crawl);
        } else if (MyTypes.TEST(pp.Flags, Gameutils.PF_PLAYER_MOVED)) {
            Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Run);
        } else {
            Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Stand);
        }
    }

    public static void SetVisHigh() {
    }

    public static void SetVisNorm() {
    }

    public static short GetDeltaAngle(int ang1, int ang2) {
        if (Pragmas.klabs(ang1 - ang2) > 1024) {
            if (ang1 <= 1024) {
                ang1 += 2048;
            }
            if (ang2 <= 1024) {
                ang2 += 2048;
            }
        }
        return (short)(ang1 - ang2);
    }

    public static int DoPickTarget(int spnum, int max_delta_ang, int skip_targets) {
        SPRITE sp = Engine.sprite[spnum];
        USER u = Gameutils.pUser[spnum];
        if (max_delta_ang == 0) {
            max_delta_ang = 1;
        }
        TargetSortCount = 0;
        if (TargetSort[0] == null) {
            Player.TargetSort[0] = new Target_Sort();
        }
        Player.TargetSort[0].sprite_num = -1;
        int shp = 0;
        while (shp < Weapon.StatDamageList.length) {
            int i = Engine.headspritestat[Weapon.StatDamageList[shp]];
            while (i != -1) {
                int nexti;
                block8: {
                    short ndx;
                    short delta_ang;
                    int dist;
                    block10: {
                        block9: {
                            short angle2;
                            nexti = Engine.nextspritestat[i];
                            SPRITE ep = Engine.sprite[i];
                            USER eu = Gameutils.pUser[i];
                            if (i == spnum || skip_targets != 2 && (skip_targets != 0 && MyTypes.TEST(eu.Flags, Gameutils.SPR_TARGETED) || eu.PlayerP != -1 && MyTypes.TEST(Game.Player[eu.PlayerP].Flags, Gameutils.PF_DEAD)) || (dist = Gameutils.FindDistance3D(sp.x - ep.x, sp.y - ep.y, sp.z - ep.z >> 4)) > 40000 || skip_targets != 2 && !MyTypes.TEST(ep.extra, Gameutils.SPRX_PLAYER_OR_ENEMY) || (delta_ang = (short)Pragmas.klabs(Player.GetDeltaAngle(sp.ang, angle2 = Gameutils.NORM_ANGLE(Main.engine.getangle(ep.x - sp.x, ep.y - sp.y))))) > max_delta_ang) break block8;
                            int zh = u != null && u.PlayerP != -1 ? Game.Player[u.PlayerP].posz : Gameutils.SPRITEp_TOS(sp) + MyTypes.DIV4(Gameutils.SPRITEp_SIZE_Z(sp));
                            int ezh = Gameutils.SPRITEp_TOS(ep) + MyTypes.DIV4(Gameutils.SPRITEp_SIZE_Z(ep));
                            int ezhm = Gameutils.SPRITEp_TOS(ep) + MyTypes.DIV2(Gameutils.SPRITEp_SIZE_Z(ep));
                            int ezhl = Gameutils.SPRITEp_BOS(ep) - MyTypes.DIV4(Gameutils.SPRITEp_SIZE_Z(ep));
                            if (!Rooms.FAFcansee(sp.x, sp.y, zh, sp.sectnum, ep.x, ep.y, ezh, ep.sectnum) && !Rooms.FAFcansee(sp.x, sp.y, zh, sp.sectnum, ep.x, ep.y, ezhm, ep.sectnum) && !Rooms.FAFcansee(sp.x, sp.y, zh, sp.sectnum, ep.x, ep.y, ezhl, ep.sectnum)) break block8;
                            if (TargetSortCount <= TargetSort.length - 1) break block9;
                            ndx = 0;
                            while (ndx < TargetSort.length) {
                                if (dist < Player.TargetSort[ndx].dist) break;
                                ndx = (short)(ndx + 1);
                            }
                            if (ndx != TargetSort.length) break block10;
                            break block8;
                        }
                        ndx = TargetSortCount;
                    }
                    if (TargetSort[ndx] == null) {
                        Player.TargetSort[ndx] = new Target_Sort();
                    }
                    Target_Sort ts = TargetSort[ndx];
                    ts.sprite_num = i;
                    ts.dang = delta_ang;
                    ts.dist = dist;
                    int ang_weight = (max_delta_ang - ts.dang << 16) / max_delta_ang;
                    int dist_weight = (MyTypes.DIV2(40000) - MyTypes.DIV2(ts.dist) << 16) / MyTypes.DIV2(40000);
                    ts.weight = (ang_weight + dist_weight * 4) / 5;
                    if ((TargetSortCount = (short)(TargetSortCount + 1)) >= TargetSort.length) {
                        TargetSortCount = (short)TargetSort.length;
                    }
                }
                i = nexti;
            }
            ++shp;
        }
        if (TargetSortCount > 1) {
            Arrays.sort(TargetSort, 0, (int)TargetSortCount);
        }
        return Player.TargetSort[0].sprite_num;
    }

    public static void DoPlayerResetMovement(PlayerStr pp) {
        pp.oxvect = 0;
        pp.xvect = 0;
        pp.oxvect = 0;
        pp.yvect = 0;
        pp.slide_xvect = 0;
        pp.slide_yvect = 0;
        pp.drive_angvel = 0.0f;
        pp.drive_oangvel = 0.0f;
        pp.Flags &= ~Gameutils.PF_PLAYER_MOVED;
    }

    public static void DoPlayerTeleportPause(PlayerStr pp) {
        USER u = Gameutils.pUser[pp.PlayerSprite];
        pp.lastcursectnum = pp.cursectnum;
        u.WaitTics = (short)(u.WaitTics - 3);
        if (u.WaitTics <= 0) {
            pp.Flags2 &= ~Gameutils.PF2_TELEPORTED;
            Player.DoPlayerResetMovement(pp);
            Player.DoPlayerBeginRun(pp);
            return;
        }
    }

    public static void DoPlayerTeleportToSprite(PlayerStr pp, SPRITE sp) {
        pp.pang = pp.oang = (float)sp.ang;
        pp.oposx = pp.oldposx = sp.x;
        pp.posx = pp.oldposx;
        pp.oposy = pp.oldposy = sp.y;
        pp.posy = pp.oldposy;
        pp.posz = pp.oposz = sp.z - PLAYER_HEIGHT;
        pp.cursectnum = Rooms.COVERupdatesector(pp.posx, pp.posy, pp.cursectnum);
        pp.Flags2 |= Gameutils.PF2_TELEPORTED;
    }

    public static void DoPlayerTeleportToOffset(PlayerStr pp) {
        pp.oposx = pp.oldposx = pp.posx;
        pp.oposy = pp.oldposy = pp.posy;
        pp.cursectnum = Rooms.COVERupdatesector(pp.posx, pp.posy, pp.cursectnum);
        pp.Flags2 |= Gameutils.PF2_TELEPORTED;
    }

    public static void DoSpawnTeleporterEffect(SPRITE sp) {
        int nx = Gameutils.MOVEx(512, sp.ang);
        int ny = Gameutils.MOVEy(512, sp.ang);
        int effect = Sprites.SpawnSprite(4, 0, Weapon.s_TeleportEffect[0], sp.sectnum, nx += sp.x, ny += sp.y, Gameutils.SPRITEp_TOS(sp) + Gameutils.Z(16), sp.ang, 0);
        SPRITE ep = Engine.sprite[effect];
        Main.engine.setspritez(effect, ep.x, ep.y, ep.z);
        ep.shade = (byte)-40;
        ep.yrepeat = (short)42;
        ep.xrepeat = (short)42;
        ep.cstat = (short)(ep.cstat | Gameutils.CSTAT_SPRITE_YCENTER);
        ep.cstat = (short)(ep.cstat & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        ep.cstat = (short)(ep.cstat | Gameutils.CSTAT_SPRITE_WALL);
    }

    public static void DoSpawnTeleporterEffectPlace(SPRITE sp) {
        int effect = Sprites.SpawnSprite(4, 0, Weapon.s_TeleportEffect[0], sp.sectnum, sp.x, sp.y, Gameutils.SPRITEp_TOS(sp) + Gameutils.Z(16), sp.ang, 0);
        SPRITE ep = Engine.sprite[effect];
        Main.engine.setspritez(effect, ep.x, ep.y, ep.z);
        ep.shade = (byte)-40;
        ep.yrepeat = (short)42;
        ep.xrepeat = (short)42;
        ep.cstat = (short)(ep.cstat | Gameutils.CSTAT_SPRITE_YCENTER);
        ep.cstat = (short)(ep.cstat & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        ep.cstat = (short)(ep.cstat | Gameutils.CSTAT_SPRITE_WALL);
    }

    public static void DoPlayerWarpTeleporter(PlayerStr pp) {
        USER u = Gameutils.pUser[pp.PlayerSprite];
        SPRITE sp = pp.getSprite();
        SPRITE sp_warp = Warp.WarpM(pp.posx, pp.posy, pp.posz, pp.cursectnum);
        if (sp_warp == null) {
            return;
        }
        pp.posx = Warp.warp.x;
        pp.posy = Warp.warp.y;
        pp.posz = Warp.warp.z;
        pp.cursectnum = Warp.warp.sectnum;
        switch (Gameutils.SP_TAG3(sp_warp)) {
            case 1: {
                Player.DoPlayerTeleportToOffset(pp);
                Player.UpdatePlayerSprite(pp);
                break;
            }
            default: {
                Player.DoPlayerTeleportToSprite(pp, sp_warp);
                Sound.PlaySound(207, pp, 0);
                Player.DoPlayerResetMovement(pp);
                u.WaitTics = (short)30;
                Player.DoPlayerBeginRun(pp);
                pp.DoPlayerAction = Player_Action_Func.DoPlayerTeleportPause;
                Sprites.NewStateGroup(pp.PlayerSprite, Gameutils.pUser[pp.PlayerSprite].ActorActionSet.Stand);
                Player.UpdatePlayerSprite(pp);
                Player.DoSpawnTeleporterEffect(sp);
                short pnum = Mmulti.connecthead;
                while (pnum != -1) {
                    if (Game.Player[pnum] != pp) {
                        PlayerStr npp = Game.Player[pnum];
                        if (npp.cursectnum == pp.cursectnum) {
                            Panel.PlayerUpdateHealth(npp, -Gameutils.pUser[npp.PlayerSprite].Health);
                            Weapon.PlayerCheckDeath(npp, pp.PlayerSprite);
                        }
                    }
                    pnum = Mmulti.connectpoint2[pnum];
                }
                break block0;
            }
        }
        u.ox = sp.x;
        u.oy = sp.y;
        u.oz = sp.z;
    }

    public static void DoPlayerSetWadeDepth(PlayerStr pp) {
        pp.WadeDepth = 0;
        if (pp.lo_sectp == -1) {
            return;
        }
        SECTOR sectp = Engine.sector[pp.lo_sectp];
        if (MyTypes.TEST(sectp.extra, Gameutils.SECTFX_SINK) && pp.posz + PLAYER_HEIGHT > sectp.floorz - Gameutils.Z(Sector.SectUser[pp.lo_sectp].depth)) {
            pp.WadeDepth = Sector.SectUser[pp.lo_sectp].depth;
        }
    }

    public static void DoPlayerHeight(PlayerStr pp) {
        int diff = pp.posz - (pp.loz - PLAYER_HEIGHT);
        pp.posz -= MyTypes.DIV4(diff) + MyTypes.DIV8(diff);
    }

    public static void DoPlayerJumpHeight(PlayerStr pp) {
        if (pp.lo_sectp != -1 && MyTypes.TEST(Engine.sector[pp.lo_sectp].extra, Gameutils.SECTFX_DYNAMIC_AREA) && pp.posz + PLAYER_HEIGHT > pp.loz) {
            pp.posz = pp.loz - PLAYER_HEIGHT;
            Player.DoPlayerBeginRun(pp);
        }
    }

    public static void DoPlayerCrawlHeight(PlayerStr pp) {
        int diff = pp.posz - (pp.loz - PLAYER_CRAWL_HEIGHT);
        pp.posz -= MyTypes.DIV4(diff) + MyTypes.DIV8(diff);
    }

    public static void DoPlayerTurn(PlayerStr pp) {
        float angvel;
        short delta_ang;
        if (!MyTypes.TEST(pp.Flags, Gameutils.PF_TURN_180)) {
            if (Gameutils.TEST_SYNC_KEY(pp, 25)) {
                if (Gameutils.FLAG_KEY_PRESSED(pp, 25)) {
                    Gameutils.FLAG_KEY_RELEASE(pp, 25);
                    pp.turn180_target = Gameutils.NORM_ANGLE(pp.getAnglei() + 1024);
                    delta_ang = Player.GetDeltaAngle(pp.turn180_target, pp.getAnglei());
                    pp.pang = Gameutils.NORM_ANGLE(pp.getAnglei() + (Pragmas.klabs(delta_ang) >> 2));
                    pp.Flags |= Gameutils.PF_TURN_180;
                }
            } else {
                Gameutils.FLAG_KEY_RESET(pp, 25);
            }
        }
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_TURN_180)) {
            delta_ang = Player.GetDeltaAngle(pp.turn180_target, pp.getAnglei());
            if (!Game.isOriginal()) {
                pp.pang += (float)(delta_ang >> 2);
                pp.pang = ru.m210projects.Build.Gameutils.BClampAngle(pp.pang);
            } else {
                pp.pang = Gameutils.NORM_ANGLE(pp.getAnglei() + (delta_ang >> 2));
            }
            Engine.sprite[pp.PlayerSprite].ang = pp.getAnglei();
            if (!WangNetwork.Prediction && pp.PlayerUnderSprite >= 0) {
                Engine.sprite[pp.PlayerUnderSprite].ang = pp.getAnglei();
            }
            if (Pragmas.klabs(delta_ang = Player.GetDeltaAngle(pp.turn180_target, pp.getAnglei())) < 12) {
                pp.pang = pp.turn180_target;
                pp.Flags &= ~Gameutils.PF_TURN_180;
            } else {
                return;
            }
        }
        if ((angvel = pp.input.angvel * 12.0f) != 0.0f) {
            if (!Game.isOriginal()) {
                angvel += angvel / 4.0f;
                pp.pang += angvel * 3.0f / 32.0f;
                pp.pang = ru.m210projects.Build.Gameutils.BClampAngle(pp.pang);
            } else {
                angvel += (float)MyTypes.DIV4((int)angvel);
                pp.pang += (float)MyTypes.DIV32((int)angvel * 3);
                pp.pang = Gameutils.NORM_ANGLE(pp.getAnglei());
            }
            Engine.sprite[pp.PlayerSprite].ang = pp.getAnglei();
            if (!WangNetwork.Prediction && pp.PlayerUnderSprite >= 0) {
                Engine.sprite[pp.PlayerUnderSprite].ang = pp.getAnglei();
            }
        }
    }

    public static void DoPlayerTurnBoat(PlayerStr pp) {
        float angvel;
        Sector_Object sop = Sprites.SectorObject[pp.sop];
        if (sop.drive_angspeed != 0) {
            pp.drive_oangvel = pp.drive_angvel;
            pp.drive_angvel = Pragmas.mulscale((int)pp.input.angvel, sop.drive_angspeed, 16);
            int angslide = sop.drive_angslide;
            angvel = pp.drive_angvel = (float)((int)((pp.drive_angvel + pp.drive_oangvel * (float)(angslide - 1)) / (float)angslide));
        } else {
            angvel = pp.input.angvel * 12.0f;
            if (!Game.isOriginal()) {
                angvel += angvel - angvel / 4.0f;
                angvel = angvel * 3.0f / 32.0f;
            } else {
                angvel += angvel - (float)MyTypes.DIV4((int)angvel);
                angvel = MyTypes.DIV32((int)angvel * 3);
            }
        }
        if (angvel != 0.0f) {
            if (!Game.isOriginal()) {
                pp.pang += angvel;
                pp.pang = ru.m210projects.Build.Gameutils.BClampAngle(pp.pang);
            } else {
                pp.pang = Gameutils.NORM_ANGLE((int)((float)pp.getAnglei() + angvel));
            }
            Engine.sprite[pp.PlayerSprite].ang = pp.getAnglei();
        }
    }

    public static void DoPlayerTurnTank(PlayerStr pp, int z, int floor_dist) {
        float angvel;
        Sector_Object sop = Sprites.SectorObject[pp.sop];
        if (sop.drive_angspeed != 0) {
            pp.drive_oangvel = pp.drive_angvel;
            pp.drive_angvel = Pragmas.mulscale((int)pp.input.angvel, sop.drive_angspeed, 16);
            long angslide = sop.drive_angslide;
            angvel = pp.drive_angvel = (float)((int)((pp.drive_angvel + pp.drive_oangvel * (float)(angslide - 1L)) / (float)angslide));
        } else {
            angvel = pp.input.angvel * 3.0f / 8.0f;
        }
        if (angvel != 0.0f && MClip.MultiClipTurn(pp, Gameutils.NORM_ANGLE((int)(pp.getAnglef() + angvel)), z, floor_dist)) {
            if (!Game.isOriginal()) {
                pp.pang += angvel;
                pp.pang = ru.m210projects.Build.Gameutils.BClampAngle(pp.pang);
            } else {
                pp.pang = Gameutils.NORM_ANGLE((int)((float)pp.getAnglei() + angvel));
            }
            Engine.sprite[pp.PlayerSprite].ang = pp.getAnglei();
        }
    }

    public static void DoPlayerTurnTankRect(PlayerStr pp, int[] x, int[] y, int[] ox, int[] oy) {
        float angvel;
        Sector_Object sop = Sprites.SectorObject[pp.sop];
        if (sop.drive_angspeed != 0) {
            pp.drive_oangvel = pp.drive_angvel;
            pp.drive_angvel = Pragmas.mulscale((int)pp.input.angvel, sop.drive_angspeed, 16);
            int angslide = sop.drive_angslide;
            angvel = pp.drive_angvel = (pp.drive_angvel + pp.drive_oangvel * (float)(angslide - 1)) / (float)angslide;
        } else {
            angvel = pp.input.angvel * 3.0f / 8.0f;
        }
        if (angvel != 0.0f && MClip.RectClipTurn(pp, Gameutils.NORM_ANGLE((int)(pp.getAnglef() + angvel)), x, y, ox, oy)) {
            if (!Game.isOriginal()) {
                pp.pang += angvel;
                pp.pang = ru.m210projects.Build.Gameutils.BClampAngle(pp.pang);
            } else {
                pp.pang = Gameutils.NORM_ANGLE((int)((float)pp.getAnglei() + angvel));
            }
            Engine.sprite[pp.PlayerSprite].ang = pp.getAnglei();
        }
    }

    public static void DoPlayerTurnTurret(PlayerStr pp) {
        float angvel;
        Sector_Object sop = Sprites.SectorObject[pp.sop];
        if (!WangNetwork.Prediction) {
            int fifo_ndx = Main.game.pNet.gNetFifoTail - 2 & 0xFF;
            Input last_input = (Input)Main.game.pNet.gFifoInput[fifo_ndx][pp.pnum];
            if (pp.input.angvel != 0.0f && last_input.angvel == 0.0f) {
                Player.PlaySOsound(sop.mid_sector, 2);
            } else if (pp.input.angvel == 0.0f && last_input.angvel != 0.0f) {
                Player.PlaySOsound(sop.mid_sector, 1);
            }
        }
        if (sop.drive_angspeed != 0) {
            pp.drive_oangvel = pp.drive_angvel;
            pp.drive_angvel = pp.input.angvel * (float)sop.drive_angspeed / 65536.0f;
            int angslide = sop.drive_angslide;
            angvel = pp.drive_angvel = (pp.drive_angvel + pp.drive_oangvel * (float)(angslide - 1)) / (float)angslide;
        } else {
            angvel = pp.input.angvel * 3.0f / 4.0f;
        }
        if (angvel != 0.0f) {
            short diff;
            float new_ang = pp.getAnglef() + angvel;
            new_ang = Game.isOriginal() ? (float)Gameutils.NORM_ANGLE((int)((float)pp.getAnglei() + angvel)) : ru.m210projects.Build.Gameutils.BClampAngle(new_ang);
            if (sop.limit_ang_center >= 0 && Pragmas.klabs(diff = Player.GetDeltaAngle((int)new_ang, sop.limit_ang_center)) >= sop.limit_ang_delta) {
                new_ang = diff < 0 ? (float)((short)(sop.limit_ang_center - sop.limit_ang_delta)) : (float)((short)(sop.limit_ang_center + sop.limit_ang_delta));
            }
            pp.pang = new_ang;
            Engine.sprite[pp.PlayerSprite].ang = pp.getAnglei();
        }
    }

    public static void SlipSlope(PlayerStr pp) {
        if (!ru.m210projects.Build.Gameutils.isValidSector(pp.cursectnum)) {
            return;
        }
        short wallptr = Engine.sector[pp.cursectnum].wallptr;
        Sect_User sectu = Sector.SectUser[pp.cursectnum];
        if (sectu == null || !MyTypes.TEST(sectu.flags, Gameutils.SECTFU_SLIDE_SECTOR) || !MyTypes.TEST(Engine.sector[pp.cursectnum].floorstat, Gameutils.FLOOR_STAT_SLOPE)) {
            return;
        }
        short ang = Main.engine.getangle(Engine.wall[Engine.wall[wallptr].point2].x - Engine.wall[wallptr].x, Engine.wall[Engine.wall[wallptr].point2].y - Engine.wall[wallptr].y);
        ang = Gameutils.NORM_ANGLE(ang + 512);
        pp.xvect += Pragmas.mulscale(Engine.sintable[Gameutils.NORM_ANGLE(ang + 512)], Engine.sector[pp.cursectnum].floorheinum, sectu.speed);
        pp.yvect += Pragmas.mulscale(Engine.sintable[ang], Engine.sector[pp.cursectnum].floorheinum, sectu.speed);
    }

    private static void PlayerAutoLook(PlayerStr pp) {
        if (!ru.m210projects.Build.Gameutils.isValidSector(pp.cursectnum)) {
            return;
        }
        if (!MyTypes.TEST(pp.Flags, Gameutils.PF_FLYING | Gameutils.PF_SWIMMING | Gameutils.PF_DIVING | Gameutils.PF_CLIMBING | Gameutils.PF_JUMPING | Gameutils.PF_FALLING) && MyTypes.TEST(Engine.sector[pp.cursectnum].floorstat, Gameutils.FLOOR_STAT_SLOPE)) {
            int y;
            int x;
            if (Game.isOriginal()) {
                x = pp.posx + (Engine.sintable[pp.getAnglei() + 512 & 0x7FF] >> 5);
                y = pp.posy + (Engine.sintable[pp.getAnglei() & 0x7FF] >> 5);
            } else {
                x = (int)((double)pp.posx + ru.m210projects.Build.Gameutils.BCosAngle(pp.getAnglef()) / 32.0);
                y = (int)((double)pp.posy + ru.m210projects.Build.Gameutils.BSinAngle(pp.getAnglef()) / 32.0);
            }
            short tempsect = Rooms.COVERupdatesector(x, y, pp.cursectnum);
            if (tempsect >= 0) {
                int j = Main.engine.getflorzofslope(pp.cursectnum, pp.posx, pp.posy);
                int k = Main.engine.getflorzofslope(pp.cursectnum, x, y);
                if (pp.cursectnum == tempsect || Pragmas.klabs(Main.engine.getflorzofslope(tempsect, x, y) - k) <= 1024) {
                    pp.horizoff += (float)((j - k) * 160 >> 16);
                }
            }
        }
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_CLIMBING)) {
            if (pp.horizoff < 100.0f) {
                pp.horizoff = Game.isOriginal() ? (pp.horizoff += (float)((100 - (int)pp.horizoff >> 3) + 1)) : (pp.horizoff += (100.0f - pp.horizoff) / 8.0f + 1.0f);
            }
        } else {
            if (pp.horizoff > 0.0f) {
                pp.horizoff = Game.isOriginal() ? (pp.horizoff -= (float)(((int)pp.horizoff >> 3) + 1)) : (pp.horizoff -= pp.horizoff / 8.0f + 1.0f);
            }
            if (pp.horizoff < 0.0f) {
                pp.horizoff = Game.isOriginal() ? (pp.horizoff += (float)(((int)(-pp.horizoff) >> 3) + 1)) : (pp.horizoff += -pp.horizoff / 8.0f + 1.0f);
            }
        }
    }

    public static void DoPlayerHorizon(PlayerStr pp) {
        if (Main.gNet.MultiGameType == WangNetwork.MultiGameTypes.MULTI_GAME_NONE && (Main.gs.SlopeTilting || !Main.gs.gMouseAim)) {
            Player.PlayerAutoLook(pp);
        }
        if (pp.input.aimvel != 0.0f) {
            pp.horizbase += pp.input.aimvel;
            pp.Flags |= Gameutils.PF_LOCK_HORIZ | Gameutils.PF_LOOKING;
        }
        if (Gameutils.TEST_SYNC_KEY(pp, 8)) {
            pp.horizbase = 100.0f;
            pp.horiz = 100.0f;
            pp.horizoff = 0.0f;
        }
        if (Gameutils.TEST_SYNC_KEY(pp, 21) || Gameutils.TEST_SYNC_KEY(pp, 22)) {
            pp.Flags |= Gameutils.PF_LOCK_HORIZ | Gameutils.PF_LOOKING;
            if (Gameutils.TEST_SYNC_KEY(pp, 22)) {
                pp.horizbase -= 8.0f;
            }
            if (Gameutils.TEST_SYNC_KEY(pp, 21)) {
                pp.horizbase += 8.0f;
            }
        }
        if (Gameutils.TEST_SYNC_KEY(pp, 12) || Gameutils.TEST_SYNC_KEY(pp, 13)) {
            pp.Flags &= ~Gameutils.PF_LOCK_HORIZ;
            pp.Flags |= Gameutils.PF_LOOKING;
            if (Gameutils.TEST_SYNC_KEY(pp, 13)) {
                pp.horizbase -= 16.0f;
            }
            if (Gameutils.TEST_SYNC_KEY(pp, 12)) {
                pp.horizbase += 16.0f;
            }
        }
        if (!(MyTypes.TEST(pp.Flags, Gameutils.PF_LOCK_HORIZ) || Gameutils.TEST_SYNC_KEY(pp, 12) || Gameutils.TEST_SYNC_KEY(pp, 13))) {
            if (pp.horizbase != 100.0f) {
                int i = 1;
                while (i != 0) {
                    pp.horizbase = Game.isOriginal() ? (pp.horizbase += (float)(25 - ((int)pp.horizbase >> 2))) : (pp.horizbase += 25.0f - pp.horizbase / 4.0f);
                    --i;
                }
            } else {
                pp.Flags &= ~Gameutils.PF_LOOKING;
            }
        }
        pp.horizbase = Math.max(pp.horizbase, -99.0f);
        pp.horizbase = Math.min(pp.horizbase, 299.0f);
        if (pp.horizbase + pp.horizoff < -99.0f) {
            pp.horizoff = -99.0f - pp.horizbase;
        } else if (pp.horizbase + pp.horizoff > 299.0f) {
            pp.horizoff = 299.0f - pp.horizbase;
        }
        pp.horiz = pp.horizbase + pp.horizoff;
    }

    public static void DoPlayerBob(PlayerStr pp) {
        int dist = 0;
        dist = Game.Distance(pp.posx, pp.posy, pp.oldposx, pp.oldposy);
        if (dist > 512) {
            dist = 0;
        }
        if (Gameutils.TEST_SYNC_KEY(pp, 16) || MyTypes.TEST(pp.Flags, Gameutils.PF_LOCK_RUN)) {
            int amt = 12;
            amt = Pragmas.mulscale(amt, dist << 8, 16);
            dist = Pragmas.mulscale(dist, 26000L, 16);
            pp.bcnt = (short)(pp.bcnt + dist);
            pp.bcnt = (short)(pp.bcnt & 0x7FF);
            pp.bob_z = Pragmas.mulscale(Gameutils.Z(amt), Engine.sintable[pp.bcnt], 14);
        } else {
            int amt = 5;
            amt = Pragmas.mulscale(amt, dist << 9, 16);
            dist = Pragmas.mulscale(dist, 32000L, 16);
            pp.bcnt = (short)(pp.bcnt + dist);
            pp.bcnt = (short)(pp.bcnt & 0x7FF);
            pp.bob_z = Pragmas.mulscale(Gameutils.Z(amt), Engine.sintable[pp.bcnt], 14);
        }
    }

    public static void DoPlayerBeginRecoil(PlayerStr pp, int pix_amt) {
        pp.Flags |= Gameutils.PF_RECOIL;
        pp.recoil_amt = (short)pix_amt;
        pp.recoil_speed = (short)80;
        pp.recoil_ndx = 0;
        pp.recoil_horizoff = 0;
    }

    public static void DoPlayerRecoil(PlayerStr pp) {
        pp.recoil_ndx = (short)(pp.recoil_ndx + pp.recoil_speed);
        if (Engine.sintable[pp.recoil_ndx] < 0) {
            pp.Flags &= ~Gameutils.PF_RECOIL;
            pp.recoil_horizoff = 0;
            return;
        }
        pp.recoil_horizoff = (short)(pp.recoil_amt * Engine.sintable[pp.recoil_ndx] >> 14);
    }

    public static void DoPlayerSpriteBob(PlayerStr pp, int player_height, int bob_amt, int bob_speed) {
        SPRITE sp = pp.getSprite();
        pp.bob_ndx = (short)(pp.bob_ndx + (3 << bob_speed) & 0x7FF);
        pp.bob_amt = (short)((long)bob_amt * (long)Engine.sintable[pp.bob_ndx] >> 14);
        sp.z = pp.posz + player_height + pp.bob_amt;
    }

    public static void UpdatePlayerUnderSprite(PlayerStr pp) {
        SPRITE over_sp = pp.getSprite();
        USER over_u = Gameutils.pUser[pp.PlayerSprite];
        if (WangNetwork.Prediction) {
            return;
        }
        int water_level_z = Engine.sector[over_sp.sectnum].floorz;
        boolean above_water = Gameutils.SPRITEp_BOS(over_sp) <= water_level_z;
        boolean in_dive_area = Gameutils.SpriteInDiveArea(over_sp);
        if (!in_dive_area || in_dive_area && above_water) {
            if (pp.PlayerUnderSprite >= 0) {
                Sprites.KillSprite(pp.PlayerUnderSprite);
                pp.PlayerUnderSprite = (short)-1;
            }
            return;
        }
        if (pp.PlayerUnderSprite < 0) {
            Ninja.SpawnPlayerUnderSprite(pp.pnum);
        }
        SPRITE sp = Engine.sprite[pp.PlayerUnderSprite];
        USER u = Gameutils.pUser[pp.PlayerUnderSprite];
        short SpriteNum = pp.PlayerUnderSprite;
        sp.x = over_sp.x;
        sp.y = over_sp.y;
        sp.z = over_sp.z;
        Main.engine.changespritesect(SpriteNum, over_sp.sectnum);
        Weapon.SpriteWarpToUnderwater(SpriteNum);
        int zdiff = Gameutils.SPRITEp_BOS(over_sp) - water_level_z;
        sp.z = Engine.sector[sp.sectnum].ceilingz + zdiff;
        u.State = over_u.State;
        u.Rot = over_u.Rot;
        u.StateStart = over_u.StateStart;
        sp.picnum = over_sp.picnum;
    }

    public static void UpdatePlayerSprite(PlayerStr pp) {
        if (!ru.m210projects.Build.Gameutils.isValidSector(pp.cursectnum)) {
            return;
        }
        SPRITE sp = pp.getSprite();
        Main.game.pInt.setsprinterpolate(pp.PlayerSprite, sp);
        sp.x = pp.posx;
        sp.y = pp.posy;
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
            Main.engine.changespritesect(pp.PlayerSprite, pp.cursectnum);
            Engine.sprite[pp.PlayerSprite].ang = pp.getAnglei();
            Player.UpdatePlayerUnderSprite(pp);
            return;
        }
        if (pp.sop_control != -1) {
            sp.z = Engine.sector[pp.cursectnum].floorz;
            Main.engine.changespritesect(pp.PlayerSprite, pp.cursectnum);
        } else if (pp.DoPlayerAction == Player_Action_Func.DoPlayerCrawl) {
            sp.z = pp.posz + PLAYER_CRAWL_HEIGHT;
            Main.engine.changespritesect(pp.PlayerSprite, pp.cursectnum);
        } else if (pp.DoPlayerAction == Player_Action_Func.DoPlayerWade) {
            sp.z = pp.posz + PLAYER_HEIGHT;
            Main.engine.changespritesect(pp.PlayerSprite, pp.cursectnum);
            if (pp.WadeDepth > Gameutils.Z(29)) {
                Player.DoPlayerSpriteBob(pp, PLAYER_HEIGHT, Gameutils.Z(3), 3);
            }
        } else if (pp.DoPlayerAction == Player_Action_Func.DoPlayerDive) {
            sp.z = pp.posz + Gameutils.Z(10);
            Main.engine.changespritesect(pp.PlayerSprite, pp.cursectnum);
        } else if (pp.DoPlayerAction == Player_Action_Func.DoPlayerClimb) {
            sp.z = pp.posz + Gameutils.Z(17);
            Main.engine.changespritesect(pp.PlayerSprite, pp.cursectnum);
        } else if (pp.DoPlayerAction == Player_Action_Func.DoPlayerFly) {
            Player.DoPlayerSpriteBob(pp, PLAYER_HEIGHT, Gameutils.Z(6), 3);
            Main.engine.changespritesect(pp.PlayerSprite, pp.cursectnum);
        } else if (pp.DoPlayerAction == Player_Action_Func.DoPlayerJump || pp.DoPlayerAction == Player_Action_Func.DoPlayerFall || pp.DoPlayerAction == Player_Action_Func.DoPlayerForceJump) {
            sp.z = pp.posz + PLAYER_HEIGHT;
            Main.engine.changespritesect(pp.PlayerSprite, pp.cursectnum);
        } else if (pp.DoPlayerAction == Player_Action_Func.DoPlayerTeleportPause) {
            sp.z = pp.posz + PLAYER_HEIGHT;
            Main.engine.changespritesect(pp.PlayerSprite, pp.cursectnum);
        } else {
            sp.z = pp.loz;
            Main.engine.changespritesect(pp.PlayerSprite, pp.cursectnum);
        }
        Player.UpdatePlayerUnderSprite(pp);
        sp.ang = (short)pp.pang;
    }

    public static void DoPlayerZrange(PlayerStr pp) {
        SPRITE psp = pp.getSprite();
        short bakcstat = psp.cstat;
        psp.cstat = (short)(psp.cstat & ~Gameutils.CSTAT_SPRITE_BLOCK);
        Rooms.FAFgetzrange(pp.posx, pp.posy, pp.posz + Gameutils.Z(8), pp.cursectnum, Game.tmp_ptr[0].set(0), Game.tmp_ptr[1].set(0), Game.tmp_ptr[2].set(0), Game.tmp_ptr[3].set(0), (psp.clipdist << 2) - 8, Gameutils.CLIPMASK_PLAYER);
        psp.cstat = bakcstat;
        pp.hiz = Game.tmp_ptr[0].value;
        int ceilhit = Game.tmp_ptr[1].value;
        pp.loz = Game.tmp_ptr[2].value;
        int florhit = Game.tmp_ptr[3].value;
        pp.hi_sectp = -1;
        pp.lo_sectp = -1;
        pp.hi_sp = -1;
        pp.lo_sp = -1;
        if (MyTypes.DTEST(ceilhit, 49152) == 49152) {
            pp.hi_sp = ceilhit & 0xFFF;
        } else {
            pp.hi_sectp = ceilhit & 0xFFF;
        }
        if (MyTypes.DTEST(florhit, 49152) == 49152) {
            pp.lo_sp = florhit & 0xFFF;
            if (Engine.sprite[pp.lo_sp].statnum == 2 && Gameutils.pUser[pp.lo_sp].ID == 1095) {
                pp.lo_sectp = Engine.sprite[pp.lo_sp].sectnum;
                pp.loz = Engine.sprite[pp.lo_sp].z;
                pp.lo_sp = -1;
            }
        } else {
            pp.lo_sectp = florhit & 0xFFF;
        }
    }

    private static void DoPlayerSlide(PlayerStr pp) {
        USER u = Gameutils.pUser[pp.PlayerSprite];
        if ((pp.slide_xvect | pp.slide_yvect) == 0) {
            return;
        }
        if (pp.sop != -1) {
            return;
        }
        pp.slide_xvect = Pragmas.mulscale(pp.slide_xvect, 53248L, 16);
        pp.slide_yvect = Pragmas.mulscale(pp.slide_yvect, 53248L, 16);
        if (Pragmas.klabs(pp.slide_xvect) < 12800 && Pragmas.klabs(pp.slide_yvect) < 12800) {
            pp.slide_yvect = 0;
            pp.slide_xvect = 0;
        }
        int push_ret = Main.engine.pushmove(pp.posx, pp.posy, pp.posz, pp.cursectnum, pp.getSprite().clipdist << 2, pp.ceiling_dist, pp.floor_dist, Gameutils.CLIPMASK_PLAYER);
        if (Engine.pushmove_sectnum != -1) {
            pp.posx = Engine.pushmove_x;
            pp.posy = Engine.pushmove_y;
            pp.posz = Engine.pushmove_z;
            pp.cursectnum = Engine.pushmove_sectnum;
        }
        if (push_ret < 0) {
            if (!MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
                Panel.PlayerUpdateHealth(pp, -u.Health);
                Weapon.PlayerCheckDeath(pp, -1);
                if (MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
                    return;
                }
            }
            return;
        }
        Main.engine.clipmove(pp.posx, pp.posy, pp.posz, pp.cursectnum, pp.slide_xvect, pp.slide_yvect, pp.getSprite().clipdist << 2, pp.ceiling_dist, pp.floor_dist, Gameutils.CLIPMASK_PLAYER);
        if (Engine.clipmove_sectnum != -1) {
            pp.posx = Engine.clipmove_x;
            pp.posy = Engine.clipmove_y;
            pp.posz = Engine.clipmove_z;
            pp.cursectnum = Engine.clipmove_sectnum;
        }
        Player.PlayerCheckValidMove(pp);
        push_ret = Main.engine.pushmove(pp.posx, pp.posy, pp.posz, pp.cursectnum, pp.getSprite().clipdist << 2, pp.ceiling_dist, pp.floor_dist, Gameutils.CLIPMASK_PLAYER);
        if (Engine.pushmove_sectnum != -1) {
            pp.posx = Engine.pushmove_x;
            pp.posy = Engine.pushmove_y;
            pp.posz = Engine.pushmove_z;
            pp.cursectnum = Engine.pushmove_sectnum;
        }
        if (push_ret < 0) {
            if (!MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
                Panel.PlayerUpdateHealth(pp, -u.Health);
                Weapon.PlayerCheckDeath(pp, -1);
                if (MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
                    return;
                }
            }
            return;
        }
    }

    public static void PlayerCheckValidMove(PlayerStr pp) {
        if (pp.cursectnum == -1) {
            pp.posx = pp.oldposx;
            pp.posy = pp.oldposy;
            pp.posz = pp.oldposz;
            pp.cursectnum = pp.lastcursectnum;
            if (count++ > 400) {
                Main.game.GameCrash("Player stuck");
                count = 0;
                Main.game.show();
            }
        }
    }

    public static void DoPlayerMenuKeys(PlayerStr pp) {
        if (Main.game.nNetMode == BuildGame.NetMode.Single) {
            if (Gameutils.TEST_SYNC_KEY(pp, 7)) {
                if (Gameutils.FLAG_KEY_PRESSED(pp, 7)) {
                    Gameutils.FLAG_KEY_RELEASE(pp, 7);
                    pp.Flags ^= Gameutils.PF_AUTO_AIM;
                }
            } else {
                Gameutils.FLAG_KEY_RESET(pp, 7);
            }
        }
    }

    public static void PlayerSectorBound(PlayerStr pp, int amt) {
        Main.engine.getzsofslope(pp.cursectnum, pp.posx, pp.posy, Rooms.zofslope);
        if (pp.posz > Rooms.zofslope[1] - amt) {
            pp.posz = Rooms.zofslope[1] - amt;
        }
        if (pp.posz < Rooms.zofslope[0] + amt) {
            pp.posz = Rooms.zofslope[0] + amt;
        }
    }

    public static final void PLAYER_RUN_LOCK(PlayerStr pp) {
        if (Gameutils.TEST_SYNC_KEY(pp, 10)) {
            if (Gameutils.FLAG_KEY_PRESSED(pp, 10)) {
                Gameutils.FLAG_KEY_RELEASE(pp, 10);
                pp.Flags ^= Gameutils.PF_LOCK_RUN;
                Main.gs.AutoRun = MyTypes.TEST(pp.Flags, Gameutils.PF_LOCK_RUN);
                Text.PutStringInfo(pp, "Run mode " + (MyTypes.TEST(pp.Flags, Gameutils.PF_LOCK_RUN) ? "ON" : "OFF"));
            }
        } else {
            Gameutils.FLAG_KEY_RESET(pp, 10);
        }
    }

    public static void DoPlayerMove(PlayerStr pp) {
        USER u = Gameutils.pUser[pp.PlayerSprite];
        int push_ret = 0;
        Player.SlipSlope(pp);
        Player.PLAYER_RUN_LOCK(pp);
        Player.DoPlayerTurn(pp);
        pp.oldposx = pp.posx;
        pp.oldposy = pp.posy;
        pp.oldposz = pp.posz;
        pp.lastcursectnum = pp.cursectnum;
        pp.Flags = Gameutils.PLAYER_MOVING(pp) == 0 ? (pp.Flags &= ~Gameutils.PF_PLAYER_MOVED) : (pp.Flags |= Gameutils.PF_PLAYER_MOVED);
        Player.DoPlayerSlide(pp);
        pp.oxvect = pp.xvect;
        pp.oyvect = pp.yvect;
        pp.xvect += pp.input.vel * 3 * 2 << 6;
        pp.yvect += pp.input.svel * 3 * 2 << 6;
        int friction = pp.friction;
        if (!MyTypes.TEST(pp.Flags, Gameutils.PF_SWIMMING) && pp.WadeDepth != 0) {
            friction -= pp.WadeDepth * 100;
        }
        pp.xvect = Pragmas.mulscale(pp.xvect, friction, 16);
        pp.yvect = Pragmas.mulscale(pp.yvect, friction, 16);
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_FLYING)) {
            pp.xvect = (pp.xvect + pp.oxvect * 1) / 2;
            pp.yvect = (pp.yvect + pp.oyvect * 1) / 2;
        } else if (MyTypes.TEST(pp.Flags, Gameutils.PF_DIVING)) {
            pp.xvect = (pp.xvect + pp.oxvect * 2) / 3;
            pp.yvect = (pp.yvect + pp.oyvect * 2) / 3;
        }
        if (Pragmas.klabs(pp.xvect) < 12800 && Pragmas.klabs(pp.yvect) < 12800) {
            pp.yvect = 0;
            pp.xvect = 0;
        }
        SPRITE psp = pp.getSprite();
        psp.xvel = (short)(Gameutils.FindDistance2D(pp.xvect, pp.yvect) >> 14);
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_CLIP_CHEAT)) {
            short sectnum = pp.cursectnum;
            pp.posx += pp.xvect >> 14;
            pp.posy += pp.yvect >> 14;
            if ((sectnum = Rooms.COVERupdatesector(pp.posx, pp.posy, sectnum)) != -1) {
                pp.cursectnum = sectnum;
            }
        } else {
            push_ret = Main.engine.pushmove(pp.posx, pp.posy, pp.posz, pp.cursectnum, psp.clipdist << 2, pp.ceiling_dist, pp.floor_dist - Gameutils.Z(16), Gameutils.CLIPMASK_PLAYER);
            if (Engine.pushmove_sectnum != -1) {
                pp.posx = Engine.pushmove_x;
                pp.posy = Engine.pushmove_y;
                pp.posz = Engine.pushmove_z;
                pp.cursectnum = Engine.pushmove_sectnum;
            }
            if (push_ret < 0 && !MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
                Panel.PlayerUpdateHealth(pp, -u.Health);
                Weapon.PlayerCheckDeath(pp, -1);
                if (MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
                    return;
                }
            }
            short save_cstat = psp.cstat;
            psp.cstat = (short)(psp.cstat & ~Gameutils.CSTAT_SPRITE_BLOCK);
            pp.cursectnum = Rooms.COVERupdatesector(pp.posx, pp.posy, pp.cursectnum);
            Main.engine.clipmove(pp.posx, pp.posy, pp.posz, pp.cursectnum, pp.xvect, pp.yvect, psp.clipdist << 2, pp.ceiling_dist, pp.floor_dist, Gameutils.CLIPMASK_PLAYER);
            if (Engine.clipmove_sectnum != -1) {
                pp.posx = Engine.clipmove_x;
                pp.posy = Engine.clipmove_y;
                pp.posz = Engine.clipmove_z;
                pp.cursectnum = Engine.clipmove_sectnum;
            }
            psp.cstat = save_cstat;
            Player.PlayerCheckValidMove(pp);
            push_ret = Main.engine.pushmove(pp.posx, pp.posy, pp.posz, pp.cursectnum, psp.clipdist << 2, pp.ceiling_dist, pp.floor_dist - Gameutils.Z(16), Gameutils.CLIPMASK_PLAYER);
            if (Engine.pushmove_sectnum != -1) {
                pp.posx = Engine.pushmove_x;
                pp.posy = Engine.pushmove_y;
                pp.posz = Engine.pushmove_z;
                pp.cursectnum = Engine.pushmove_sectnum;
            }
            if (push_ret < 0 && !MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
                Panel.PlayerUpdateHealth(pp, -u.Health);
                Weapon.PlayerCheckDeath(pp, -1);
                if (MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
                    return;
                }
            }
        }
        if (Warp.WarpPlane(pp.posx, pp.posy, pp.posz, pp.cursectnum) != null) {
            pp.posx = Warp.warp.x;
            pp.posy = Warp.warp.y;
            pp.posz = Warp.warp.z;
            pp.cursectnum = Warp.warp.sectnum;
            Player.PlayerWarpUpdatePos(pp);
        }
        Player.DoPlayerZrange(pp);
        Player.DoPlayerSetWadeDepth(pp);
        Player.DoPlayerHorizon(pp);
        if (ru.m210projects.Build.Gameutils.isValidSector(pp.cursectnum) && MyTypes.TEST(Engine.sector[pp.cursectnum].extra, Gameutils.SECTFX_DYNAMIC_AREA)) {
            if (MyTypes.TEST(pp.Flags, Gameutils.PF_FLYING | Gameutils.PF_JUMPING | Gameutils.PF_FALLING)) {
                if (pp.posz > pp.loz) {
                    pp.posz = pp.loz - PLAYER_HEIGHT;
                }
                if (pp.posz < pp.hiz) {
                    pp.posz = pp.hiz + PLAYER_HEIGHT;
                }
            } else if (MyTypes.TEST(pp.Flags, Gameutils.PF_SWIMMING | Gameutils.PF_DIVING)) {
                if (pp.posz > pp.loz) {
                    pp.posz = pp.loz - PLAYER_SWIM_HEIGHT;
                }
                if (pp.posz < pp.hiz) {
                    pp.posz = pp.hiz + PLAYER_SWIM_HEIGHT;
                }
            }
        }
    }

    public static void DoPlayerSectorUpdatePreMove(PlayerStr pp) {
        short sectnum = pp.cursectnum;
        if (!ru.m210projects.Build.Gameutils.isValidSector(pp.cursectnum)) {
            return;
        }
        if (MyTypes.TEST(Engine.sector[pp.cursectnum].extra, Gameutils.SECTFX_DYNAMIC_AREA)) {
            if ((sectnum = Main.engine.updatesectorz(pp.posx, pp.posy, pp.posz, sectnum)) < 0) {
                sectnum = pp.cursectnum;
                sectnum = Rooms.COVERupdatesector(pp.posx, pp.posy, sectnum);
            }
        } else if (Gameutils.FAF_ConnectArea(sectnum) && (sectnum = Main.engine.updatesectorz(pp.posx, pp.posy, pp.posz, sectnum)) < 0) {
            sectnum = pp.cursectnum;
            sectnum = Rooms.COVERupdatesector(pp.posx, pp.posy, sectnum);
        }
        pp.cursectnum = sectnum;
    }

    public static void DoPlayerSectorUpdatePostMove(PlayerStr pp) {
        if (Gameutils.FAF_ConnectArea(pp.cursectnum)) {
            short sectnum = pp.cursectnum;
            pp.cursectnum = Main.engine.updatesectorz(pp.posx, pp.posy, pp.posz, sectnum);
            if (pp.cursectnum < 0) {
                pp.cursectnum = sectnum;
                Main.engine.getzsofslope(pp.cursectnum, pp.posx, pp.posy, Rooms.zofslope);
                if (pp.posz > Rooms.zofslope[1]) {
                    pp.posz = Rooms.zofslope[1];
                }
                if (pp.posz < Rooms.zofslope[0]) {
                    pp.posz = Rooms.zofslope[0];
                }
                pp.cursectnum = Main.engine.updatesectorz(pp.posx, pp.posy, pp.posz, pp.cursectnum);
            }
        } else {
            Player.PlayerSectorBound(pp, Gameutils.Z(1));
        }
    }

    public static void PlaySOsound(short sectnum, int sound_num) {
        short i = Engine.headspritesect[sectnum];
        while (i != -1) {
            short nexti = Engine.nextspritesect[i];
            if (Engine.sprite[i].statnum == 65) {
                Sector.DoSoundSpotStopSound(Engine.sprite[i].lotag);
                Sector.DoSoundSpotMatch(Engine.sprite[i].lotag, sound_num, Sound.SoundType.SOUND_OBJECT_TYPE);
            }
            i = nexti;
        }
    }

    public static void StopSOsound(short sectnum) {
        short i = Engine.headspritesect[sectnum];
        while (i != -1) {
            short nexti = Engine.nextspritesect[i];
            if (Engine.sprite[i].statnum == 65) {
                Sector.DoSoundSpotStopSound(Engine.sprite[i].lotag);
            }
            i = nexti;
        }
    }

    public static void DoPlayerMoveBoat(PlayerStr pp) {
        Sector_Object sop = Sprites.SectorObject[pp.sop];
        if (WangNetwork.Prediction) {
            return;
        }
        if (!WangNetwork.Prediction) {
            int fifo_ndx = Main.game.pNet.gNetFifoTail - 2 & 0xFF;
            Input last_input = (Input)Main.game.pNet.gFifoInput[fifo_ndx][pp.pnum];
            if (Pragmas.klabs(pp.input.vel | pp.input.svel) != 0 && Pragmas.klabs(last_input.vel | last_input.svel) == 0) {
                Player.PlaySOsound(sop.mid_sector, 2);
            } else if (Pragmas.klabs(pp.input.vel | pp.input.svel) == 0 && Pragmas.klabs(last_input.vel | last_input.svel) != 0) {
                Player.PlaySOsound(sop.mid_sector, 1);
            }
        }
        Player.PLAYER_RUN_LOCK(pp);
        Player.DoPlayerTurnBoat(pp);
        pp.Flags = Gameutils.PLAYER_MOVING(pp) == 0 ? (pp.Flags &= ~Gameutils.PF_PLAYER_MOVED) : (pp.Flags |= Gameutils.PF_PLAYER_MOVED);
        pp.oxvect = pp.xvect;
        pp.oyvect = pp.yvect;
        if (sop.drive_speed != 0) {
            pp.xvect = Pragmas.mulscale(pp.input.vel, sop.drive_speed, 6);
            pp.yvect = Pragmas.mulscale(pp.input.svel, sop.drive_speed, 6);
            pp.xvect = (pp.xvect + pp.oxvect * (sop.drive_slide - 1)) / sop.drive_slide;
            pp.yvect = (pp.yvect + pp.oyvect * (sop.drive_slide - 1)) / sop.drive_slide;
        } else {
            pp.xvect += pp.input.vel * 3 * 2 << 6;
            pp.yvect += pp.input.svel * 3 * 2 << 6;
            pp.xvect = Pragmas.mulscale(pp.xvect, 51968L, 16);
            pp.yvect = Pragmas.mulscale(pp.yvect, 51968L, 16);
            pp.xvect = (pp.xvect + pp.oxvect * 5) / 6;
            pp.yvect = (pp.yvect + pp.oyvect * 5) / 6;
        }
        if (Pragmas.klabs(pp.xvect) < 12800 && Pragmas.klabs(pp.yvect) < 12800) {
            pp.yvect = 0;
            pp.xvect = 0;
        }
        pp.lastcursectnum = pp.cursectnum;
        int z = pp.posz + Gameutils.Z(10);
        short save_sectnum = pp.cursectnum;
        Track.OperateSectorObject(pp.sop, pp.getAnglef(), Integer.MAX_VALUE, Integer.MAX_VALUE, 1);
        pp.cursectnum = sop.op_main_sector;
        int floor_dist = Pragmas.klabs(z - sop.floor_loz);
        Main.engine.clipmove(pp.posx, pp.posy, z, pp.cursectnum, pp.xvect, pp.yvect, sop.clipdist, Gameutils.Z(4), floor_dist, Gameutils.CLIPMASK_PLAYER);
        if (Engine.clipmove_sectnum != -1) {
            pp.posx = Engine.clipmove_x;
            pp.posy = Engine.clipmove_y;
            z = Engine.clipmove_z;
            pp.cursectnum = Engine.clipmove_sectnum;
        }
        Track.OperateSectorObject(pp.sop, pp.getAnglef(), pp.posx, pp.posy, 1);
        pp.cursectnum = save_sectnum;
        Player.DoPlayerHorizon(pp);
    }

    public static void DoTankTreads(PlayerStr pp) {
        boolean reverse = false;
        if (WangNetwork.Prediction) {
            return;
        }
        int vel = Gameutils.FindDistance2D(pp.xvect >> 8, pp.yvect >> 8);
        int dot = Game.isOriginal() ? Gameutils.DOT_PRODUCT_2D(pp.xvect, pp.yvect, Engine.sintable[Gameutils.NORM_ANGLE(pp.getAnglei() + 512)], Engine.sintable[pp.getAnglei()]) : Gameutils.DOT_PRODUCT_2D(pp.xvect, pp.yvect, (int)ru.m210projects.Build.Gameutils.BCosAngle(pp.getAnglef()), (int)ru.m210projects.Build.Gameutils.BSinAngle(pp.getAnglef()));
        if (dot < 0) {
            reverse = true;
        }
        Sector_Object sop = Sprites.SectorObject[pp.sop];
        int j = 0;
        while (sop.sector[j] != -1) {
            short i = Engine.headspritesect[sop.sector[j]];
            while (i != -1) {
                short nexti = Engine.nextspritesect[i];
                SPRITE sp = Engine.sprite[i];
                if (Gameutils.TEST_BOOL1(sp)) {
                    if (sp.statnum == 89) {
                        if (reverse) {
                            if (!Gameutils.TEST_BOOL2(sp)) {
                                Gameutils.SET_BOOL2(sp);
                                sp.ang = Gameutils.NORM_ANGLE(sp.ang + 1024);
                            }
                        } else if (Gameutils.TEST_BOOL2(sp)) {
                            Gameutils.RESET_BOOL2(sp);
                            sp.ang = Gameutils.NORM_ANGLE(sp.ang + 1024);
                        }
                        sp.xvel = (short)vel;
                    } else if (sp.statnum == 87) {
                        sp = Engine.sprite[i];
                        if (reverse) {
                            if (!Gameutils.TEST_BOOL2(sp)) {
                                Gameutils.SET_BOOL2(sp);
                                sp.ang = Gameutils.NORM_ANGLE(sp.ang + 1024);
                            }
                        } else if (Gameutils.TEST_BOOL2(sp)) {
                            Gameutils.RESET_BOOL2(sp);
                            sp.ang = Gameutils.NORM_ANGLE(sp.ang + 1024);
                        }
                        sp.xvel = (short)vel;
                    } else if (sp.statnum == 88) {
                        sp = Engine.sprite[i];
                        if (reverse) {
                            if (!Gameutils.TEST_BOOL2(sp)) {
                                Gameutils.SET_BOOL2(sp);
                                sp.ang = Gameutils.NORM_ANGLE(sp.ang + 1024);
                            }
                        } else if (Gameutils.TEST_BOOL2(sp)) {
                            Gameutils.RESET_BOOL2(sp);
                            sp.ang = Gameutils.NORM_ANGLE(sp.ang + 1024);
                        }
                        sp.xvel = (short)vel;
                    }
                }
                i = nexti;
            }
            ++j;
        }
    }

    public static void SetupDriveCrush(PlayerStr pp, int[] x, int[] y) {
        short radius = Sprites.SectorObject[pp.sop_control].clipdist;
        x[0] = pp.posx - radius;
        y[0] = pp.posy - radius;
        x[1] = pp.posx + radius;
        y[1] = pp.posy - radius;
        x[2] = pp.posx + radius;
        y[2] = pp.posy + radius;
        x[3] = pp.posx - radius;
        y[3] = pp.posy + radius;
    }

    public static void DriveCrush(PlayerStr pp, int[] x, int[] y) {
        USER u;
        SPRITE sp;
        short nexti;
        if (Sprites.MoveSkip4 == 0) {
            return;
        }
        if ((pp.xvect | pp.yvect) == 0 && pp.input.angvel == 0.0f) {
            return;
        }
        Sector_Object sop = Sprites.SectorObject[pp.sop_control];
        short i = Engine.headspritesect[sop.op_main_sector];
        while (i != -1) {
            nexti = Engine.nextspritesect[i];
            sp = Engine.sprite[i];
            u = Gameutils.pUser[i];
            if (!(MClip.testpointinquad(sp.x, sp.y, x, y) == 0 || MyTypes.TEST(sp.extra, Gameutils.SPRX_BREAKABLE) && Break.HitBreakSprite(i, 0) || sp.statnum == 4 || sp.picnum == 2307 || MyTypes.TEST(sp.extra, Gameutils.SPRX_PLAYER_OR_ENEMY) && !MyTypes.TEST(u.Flags, Gameutils.SPR_DEAD) && !MyTypes.TEST(sp.extra, Gameutils.SPRX_BREAKABLE) || MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_INVISIBLE) || sp.statnum > 47 || sp.z < sop.crush_z)) {
                Weapon.SpriteQueueDelete(i);
                Sprites.KillSprite(i);
            }
            i = nexti;
        }
        i = Engine.headspritestat[2];
        while (i != -1) {
            block20: {
                block21: {
                    nexti = Engine.nextspritestat[i];
                    sp = Engine.sprite[i];
                    if (MClip.testpointinquad(sp.x, sp.y, x, y) == 0 || sp.z < sop.crush_z) break block20;
                    vel = Gameutils.FindDistance2D(pp.xvect >> 8, pp.yvect >> 8);
                    if (vel >= 9000) break block21;
                    Actor.DoActorBeginSlide(i, Main.engine.getangle(pp.xvect, pp.yvect), vel / 8, 5);
                    if (Actor.DoActorSlide(i)) break block20;
                }
                Weapon.UpdateSinglePlayKills(i, pp);
                if (Shrap.SpawnShrap(i, -99)) {
                    Weapon.SetSuicide(i);
                } else {
                    Sprites.KillSprite(i);
                }
            }
            i = nexti;
        }
        i = Engine.headspritestat[3];
        while (i != -1) {
            nexti = Engine.nextspritestat[i];
            sp = Engine.sprite[i];
            if (MClip.testpointinquad(sp.x, sp.y, x, y) != 0 && sp.z >= sop.crush_z) {
                Weapon.SpriteQueueDelete(i);
                Sprites.KillSprite(i);
            }
            i = nexti;
        }
        int stat = 0;
        while (stat < 8) {
            i = Engine.headspritestat[21 + stat];
            if (i >= 0) {
                sp = Engine.sprite[i];
                u = Gameutils.pUser[i];
                if (u.PlayerP != pp.pnum && MClip.testpointinquad(sp.x, sp.y, x, y) != 0 && sp.z >= sop.crush_z) {
                    int damage = -(u.Health + 100);
                    Weapon.PlayerDamageSlide(Game.Player[u.PlayerP], damage, pp.getAnglei());
                    Panel.PlayerUpdateHealth(Game.Player[u.PlayerP], damage);
                    Weapon.PlayerCheckDeath(Game.Player[u.PlayerP], pp.PlayerSprite);
                }
            }
            stat = (short)(stat + 1);
        }
        int s = 0;
        while (sop.sector[s] != -1) {
            i = Engine.headspritesect[sop.sector[s]];
            while (i != -1) {
                nexti = Engine.nextspritesect[i];
                sp = Engine.sprite[i];
                u = Gameutils.pUser[i];
                if (sp.z >= sop.crush_z + Gameutils.Z(40) && MyTypes.TEST(sp.extra, Gameutils.SPRX_PLAYER_OR_ENEMY) && sp.statnum == 2) {
                    if (Shrap.SpawnShrap(i, -99)) {
                        Weapon.SetSuicide(i);
                    } else {
                        Sprites.KillSprite(i);
                    }
                }
                i = nexti;
            }
            ++s;
        }
    }

    public static void DoPlayerMoveTank(PlayerStr pp) {
        boolean RectClip;
        int count = 0;
        Sector_Object sop = Sprites.SectorObject[pp.sop];
        int spnum = sop.sp_child;
        USER u = Gameutils.pUser[spnum];
        boolean bl = RectClip = MyTypes.TEST(sop.flags, Gameutils.SOBJ_RECT_CLIP);
        if (WangNetwork.Prediction) {
            return;
        }
        if (!WangNetwork.Prediction) {
            int fifo_ndx = Main.game.pNet.gNetFifoTail - 2 & 0xFF;
            Input last_input = (Input)Main.game.pNet.gFifoInput[fifo_ndx][pp.pnum];
            if (Pragmas.klabs(pp.input.vel | pp.input.svel) != 0 && Pragmas.klabs(last_input.vel | last_input.svel) == 0) {
                Player.PlaySOsound(sop.mid_sector, 2);
            } else if (Pragmas.klabs(pp.input.vel | pp.input.svel) == 0 && Pragmas.klabs(last_input.vel | last_input.svel) != 0) {
                Player.PlaySOsound(sop.mid_sector, 1);
            }
        }
        Player.PLAYER_RUN_LOCK(pp);
        pp.Flags = Gameutils.PLAYER_MOVING(pp) == 0 ? (pp.Flags &= ~Gameutils.PF_PLAYER_MOVED) : (pp.Flags |= Gameutils.PF_PLAYER_MOVED);
        pp.oxvect = pp.xvect;
        pp.oyvect = pp.yvect;
        if (sop.drive_speed != 0) {
            pp.xvect = Pragmas.mulscale(pp.input.vel, sop.drive_speed, 6);
            pp.yvect = Pragmas.mulscale(pp.input.svel, sop.drive_speed, 6);
            pp.xvect = (pp.xvect + pp.oxvect * (sop.drive_slide - 1)) / sop.drive_slide;
            pp.yvect = (pp.yvect + pp.oyvect * (sop.drive_slide - 1)) / sop.drive_slide;
        } else {
            pp.xvect += pp.input.vel * 3 * 2 << 6;
            pp.yvect += pp.input.svel * 3 * 2 << 6;
            pp.xvect = Pragmas.mulscale(pp.xvect, 53248L, 16);
            pp.yvect = Pragmas.mulscale(pp.yvect, 53248L, 16);
            pp.xvect = (pp.xvect + pp.oxvect * 1) / 2;
            pp.yvect = (pp.yvect + pp.oyvect * 1) / 2;
        }
        if (Pragmas.klabs(pp.xvect) < 12800 && Pragmas.klabs(pp.yvect) < 12800) {
            pp.yvect = 0;
            pp.xvect = 0;
        }
        pp.lastcursectnum = pp.cursectnum;
        int z = pp.posz + Gameutils.Z(10);
        if (RectClip) {
            int wallcount = 0;
            int s = 0;
            while (sop.sector[s] != -1) {
                SECTOR sectp = Engine.sector[sop.sector[s]];
                int startwall = sectp.wallptr;
                short endwall = (short)(startwall + sectp.wallnum - 1);
                int k = startwall;
                while (k <= endwall) {
                    WALL wp = Engine.wall[k];
                    if (wp.extra != 0 && MyTypes.DTEST(wp.extra, Gameutils.WALLFX_LOOP_OUTER | Gameutils.WALLFX_LOOP_OUTER_SECONDARY) == Gameutils.WALLFX_LOOP_OUTER) {
                        Player.x[count] = wp.x;
                        Player.y[count] = wp.y;
                        Player.ox[count] = sop.xmid - sop.xorig[wallcount];
                        Player.oy[count] = sop.ymid - sop.yorig[wallcount];
                        ++count;
                    }
                    ++wallcount;
                    ++k;
                }
                ++s;
            }
        }
        short save_sectnum = pp.cursectnum;
        Track.OperateSectorObject(pp.sop, pp.getAnglef(), Integer.MAX_VALUE, Integer.MAX_VALUE, 1);
        pp.cursectnum = sop.op_main_sector;
        int floor_dist = Pragmas.klabs(z - sop.floor_loz);
        if (RectClip) {
            SPRITE psp = pp.getSprite();
            short save_cstat = psp.cstat;
            psp.cstat = (short)(psp.cstat & ~Gameutils.CSTAT_SPRITE_BLOCK);
            Player.DoPlayerTurnTankRect(pp, x, y, ox, oy);
            boolean ret = MClip.RectClipMove(pp, x, y);
            Player.DriveCrush(pp, x, y);
            psp.cstat = save_cstat;
            if (!ret) {
                int vel = Gameutils.FindDistance2D(pp.xvect >> 8, pp.yvect >> 8);
                if (vel > 13000) {
                    int nx = MyTypes.DIV2(x[0] + x[1]);
                    int ny = MyTypes.DIV2(y[0] + y[1]);
                    Main.engine.hitscan(nx, ny, Engine.sector[pp.cursectnum].floorz - Gameutils.Z(10), pp.cursectnum, Gameutils.MOVEx(256, pp.getAnglei()), Gameutils.MOVEy(256, pp.getAnglei()), 0, Engine.pHitInfo, Gameutils.CLIPMASK_PLAYER);
                    if (Gameutils.FindDistance2D(Engine.pHitInfo.hitx - nx, Engine.pHitInfo.hity - ny) < 800) {
                        u.ret = Engine.pHitInfo.hitwall >= 0 ? Engine.pHitInfo.hitwall | 0x8000 : (Engine.pHitInfo.hitsprite >= 0 ? Engine.pHitInfo.hitsprite | 0xC000 : 0);
                        Weapon.VehicleMoveHit(spnum);
                    }
                    if (!MyTypes.TEST(sop.flags, Gameutils.SOBJ_NO_QUAKE)) {
                        Quake.SetPlayerQuake(pp);
                    }
                }
                if (vel > 12000) {
                    pp.oyvect = 0;
                    pp.oxvect = 0;
                    pp.yvect = 0;
                    pp.xvect = 0;
                }
            }
        } else {
            Player.DoPlayerTurnTank(pp, z, floor_dist);
            SPRITE psp = pp.getSprite();
            short save_cstat = psp.cstat;
            psp.cstat = (short)(psp.cstat & ~Gameutils.CSTAT_SPRITE_BLOCK);
            if (sop.clipdist != 0) {
                u.ret = Main.engine.clipmove(pp.posx, pp.posy, z, pp.cursectnum, pp.xvect, pp.yvect, sop.clipdist, Gameutils.Z(4), floor_dist, Gameutils.CLIPMASK_PLAYER);
                if (Engine.clipmove_sectnum != -1) {
                    pp.posx = Engine.clipmove_x;
                    pp.posy = Engine.clipmove_y;
                    z = Engine.clipmove_z;
                    pp.cursectnum = Engine.clipmove_sectnum;
                }
            } else {
                u.ret = MClip.MultiClipMove(pp, z, floor_dist);
            }
            psp.cstat = save_cstat;
            if (u.ret != 0) {
                int vel = Gameutils.FindDistance2D(pp.xvect >> 8, pp.yvect >> 8);
                if (vel > 13000) {
                    Weapon.VehicleMoveHit(spnum);
                    pp.slide_xvect = -pp.xvect << 1;
                    pp.slide_yvect = -pp.yvect << 1;
                    if (!MyTypes.TEST(sop.flags, Gameutils.SOBJ_NO_QUAKE)) {
                        Quake.SetPlayerQuake(pp);
                    }
                }
                if (vel > 12000) {
                    pp.oyvect = 0;
                    pp.oxvect = 0;
                    pp.yvect = 0;
                    pp.xvect = 0;
                }
            }
        }
        Track.OperateSectorObject(pp.sop, pp.getAnglef(), pp.posx, pp.posy, 1);
        pp.cursectnum = save_sectnum;
        Player.DoPlayerHorizon(pp);
        Player.DoTankTreads(pp);
    }

    public static void DoPlayerMoveTurret(PlayerStr pp) {
        Player.PLAYER_RUN_LOCK(pp);
        Player.DoPlayerTurnTurret(pp);
        pp.Flags = Gameutils.PLAYER_MOVING(pp) == 0 ? (pp.Flags &= ~Gameutils.PF_PLAYER_MOVED) : (pp.Flags |= Gameutils.PF_PLAYER_MOVED);
        Sector_Object sop = Sprites.SectorObject[pp.sop];
        Track.OperateSectorObject(pp.sop, pp.getAnglef(), sop.xmid, sop.ymid, 1);
        Player.DoPlayerHorizon(pp);
    }

    public static void DoPlayerBeginJump(PlayerStr pp) {
        USER u = Gameutils.pUser[pp.PlayerSprite];
        pp.Flags |= Gameutils.PF_JUMPING;
        pp.Flags &= ~Gameutils.PF_FALLING;
        pp.Flags &= ~Gameutils.PF_CRAWLING;
        pp.Flags &= ~Gameutils.PF_LOCK_CRAWL;
        pp.floor_dist = PLAYER_JUMP_FLOOR_DIST;
        pp.ceiling_dist = PLAYER_JUMP_CEILING_DIST;
        pp.friction = 50000;
        pp.jump_speed = -650 + pp.WadeDepth * 4;
        if (Player.DoPlayerWadeSuperJump(pp)) {
            pp.jump_speed = -650 - pp.WadeDepth * 5;
        }
        pp.JumpDuration = (short)12;
        pp.DoPlayerAction = Player_Action_Func.DoPlayerJump;
        Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Jump);
    }

    public static void DoPlayerBeginForceJump(PlayerStr pp) {
        USER u = Gameutils.pUser[pp.PlayerSprite];
        pp.Flags |= Gameutils.PF_JUMPING;
        pp.Flags &= ~(Gameutils.PF_FALLING | Gameutils.PF_CRAWLING | Gameutils.PF_CLIMBING | Gameutils.PF_LOCK_CRAWL);
        pp.JumpDuration = (short)12;
        pp.DoPlayerAction = Player_Action_Func.DoPlayerForceJump;
        pp.floor_dist = PLAYER_JUMP_FLOOR_DIST;
        pp.ceiling_dist = PLAYER_JUMP_CEILING_DIST;
        pp.friction = 50000;
        Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Jump);
    }

    public static void DoPlayerJump(PlayerStr pp) {
        if (!Gameutils.TEST_SYNC_KEY(pp, 19)) {
            Gameutils.FLAG_KEY_RESET(pp, 19);
        }
        int i = 0;
        while (i < 3) {
            if (Gameutils.TEST_SYNC_KEY(pp, 19) && pp.JumpDuration > 0) {
                pp.jump_speed -= 24;
                pp.JumpDuration = (short)(pp.JumpDuration - 1);
            }
            if ((pp.jump_speed += 24) > 0) {
                Player.DoPlayerBeginFall(pp);
                Player.DoPlayerFall(pp);
                return;
            }
            pp.posz += pp.jump_speed;
            if (Player.PlayerCeilingHit(pp, pp.hiz + Gameutils.Z(4))) {
                pp.posz = pp.hiz + Gameutils.Z(4);
                pp.jump_speed = -pp.jump_speed;
                Player.DoPlayerBeginFall(pp);
                Player.DoPlayerFall(pp);
                return;
            }
            if (Player.PlayerFloorHit(pp, pp.loz - pp.floor_dist)) {
                pp.posz = pp.loz - pp.floor_dist;
                pp.jump_speed = 0;
                Player.PlayerSectorBound(pp, Gameutils.Z(1));
                Player.DoPlayerBeginRun(pp);
                Player.DoPlayerHeight(pp);
                return;
            }
            i = (short)(i + 1);
        }
        if (Player.PlayerFlyKey(pp)) {
            Player.DoPlayerBeginFly(pp);
            return;
        }
        if (Player.PlayerOnLadder(pp)) {
            Player.DoPlayerBeginClimb(pp);
            return;
        }
        Player.DoPlayerMove(pp);
        Player.DoPlayerJumpHeight(pp);
    }

    public static void DoPlayerForceJump(PlayerStr pp) {
        int i = 0;
        while (i < 3) {
            if ((pp.jump_speed += 24) > 0) {
                Player.DoPlayerBeginFall(pp);
                Player.DoPlayerFall(pp);
                return;
            }
            pp.posz += pp.jump_speed;
            if (Player.PlayerCeilingHit(pp, pp.hiz + Gameutils.Z(4))) {
                pp.posz = pp.hiz + Gameutils.Z(4);
                pp.jump_speed = -pp.jump_speed;
                Player.DoPlayerBeginFall(pp);
                Player.DoPlayerFall(pp);
                return;
            }
            i = (short)(i + 1);
        }
        Player.DoPlayerMove(pp);
    }

    public static void DoPlayerBeginFall(PlayerStr pp) {
        USER u = Gameutils.pUser[pp.PlayerSprite];
        pp.Flags |= Gameutils.PF_FALLING;
        pp.Flags &= ~Gameutils.PF_JUMPING;
        pp.Flags &= ~Gameutils.PF_CRAWLING;
        pp.Flags &= ~Gameutils.PF_LOCK_CRAWL;
        pp.floor_dist = PLAYER_FALL_FLOOR_DIST;
        pp.ceiling_dist = PLAYER_FALL_CEILING_DIST;
        pp.DoPlayerAction = Player_Action_Func.DoPlayerFall;
        pp.friction = 50000;
        if (u.Rot == u.ActorActionSet.Jump) {
            Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Fall);
        }
    }

    public static void StackedWaterSplash(PlayerStr pp) {
        if (Gameutils.FAF_ConnectArea(pp.cursectnum)) {
            short sectnum = pp.cursectnum;
            sectnum = Main.engine.updatesectorz(pp.posx, pp.posy, Gameutils.SPRITEp_BOS(pp.getSprite()), sectnum);
            if (Gameutils.SectorIsUnderwaterArea(sectnum)) {
                Sound.PlaySound(196, pp, 8);
            }
        }
    }

    public static void DoPlayerFall(PlayerStr pp) {
        if (!Gameutils.TEST_SYNC_KEY(pp, 19)) {
            Gameutils.FLAG_KEY_RESET(pp, 19);
        }
        if (Gameutils.SectorIsUnderwaterArea(pp.cursectnum)) {
            Player.StackedWaterSplash(pp);
            Player.DoPlayerBeginDiveNoWarp(pp);
            return;
        }
        int i = 0;
        while (i < 3) {
            pp.jump_speed += 24;
            if (pp.jump_speed > 4100) {
                pp.jump_speed = 4100;
            }
            pp.posz += pp.jump_speed;
            if (pp.jump_speed > 2000) {
                Sound.PlayerSound(266, 13, pp);
                handle = pp.TalkVocHandle;
            } else if (pp.jump_speed > 1300 && !Main.gs.gMouseAim && MyTypes.TEST(pp.Flags, Gameutils.PF_LOCK_HORIZ)) {
                pp.Flags &= ~Gameutils.PF_LOCK_HORIZ;
                pp.Flags |= Gameutils.PF_LOOKING;
            }
            int depth = Rooms.GetZadjustment(pp.cursectnum, 98) >> 8;
            if (depth == 0) {
                depth = pp.WadeDepth;
            }
            int recoil_amt = depth > 20 ? 0 : Math.min(pp.jump_speed * 6, Gameutils.Z(35));
            if (Player.PlayerCeilingHit(pp, pp.hiz + pp.ceiling_dist)) {
                pp.posz = pp.hiz + pp.ceiling_dist;
            }
            if (Player.PlayerFloorHit(pp, pp.loz - PLAYER_HEIGHT + recoil_amt)) {
                Sect_User sectu = Sector.SectUser[pp.cursectnum];
                SECTOR sectp = Engine.sector[pp.cursectnum];
                Player.PlayerSectorBound(pp, Gameutils.Z(1));
                if (sectu != null && MyTypes.DTEST(sectp.extra, Gameutils.SECTFX_LIQUID_MASK) != 0) {
                    Sound.PlaySound(196, pp, 8);
                } else if (pp.jump_speed > 1020) {
                    Sound.PlaySound(57, pp, 9);
                }
                if (handle != null && handle.isActive()) {
                    handle.stop();
                    pp.PlayerTalking = false;
                    handle = null;
                }
                if (Player.DoPlayerTestCrawl(pp) || Gameutils.TEST_SYNC_KEY(pp, 20)) {
                    pp.posz = pp.loz - PLAYER_CRAWL_HEIGHT;
                } else {
                    pp.posz += recoil_amt;
                    Player.DoPlayerHeight(pp);
                }
                if (pp.jump_speed > 1700 && depth == 0) {
                    Sound.PlayerSound(257, 9, pp);
                    if (pp.jump_speed > 1700 && pp.jump_speed < 4000) {
                        if (pp.jump_speed > 0) {
                            Panel.PlayerUpdateHealth(pp, -((pp.jump_speed - 1700) / 40));
                        }
                    } else if (pp.jump_speed >= 4000) {
                        USER u = Gameutils.pUser[pp.PlayerSprite];
                        Panel.PlayerUpdateHealth(pp, -u.Health);
                        u.Health = 0;
                    }
                    Weapon.PlayerCheckDeath(pp, -1);
                    if (MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
                        return;
                    }
                }
                if (Gameutils.TEST_SYNC_KEY(pp, 20)) {
                    Player.StackedWaterSplash(pp);
                    Player.DoPlayerBeginCrawl(pp);
                    return;
                }
                if (Player.PlayerCanDiveNoWarp(pp)) {
                    Player.DoPlayerBeginDiveNoWarp(pp);
                    return;
                }
                Player.StackedWaterSplash(pp);
                Player.DoPlayerBeginRun(pp);
                return;
            }
            i = (short)(i + 1);
        }
        if (Player.PlayerFlyKey(pp)) {
            Player.DoPlayerBeginFly(pp);
            return;
        }
        if (Player.PlayerOnLadder(pp)) {
            Player.DoPlayerBeginClimb(pp);
            return;
        }
        Player.DoPlayerMove(pp);
    }

    public static void DoPlayerBeginClimb(PlayerStr pp) {
        SPRITE sp = pp.getSprite();
        pp.Flags &= ~(Gameutils.PF_JUMPING | Gameutils.PF_FALLING);
        pp.Flags &= ~Gameutils.PF_CRAWLING;
        pp.Flags &= ~Gameutils.PF_LOCK_CRAWL;
        pp.DoPlayerAction = Player_Action_Func.DoPlayerClimb;
        pp.Flags |= Gameutils.PF_CLIMBING | Gameutils.PF_WEAPON_DOWN;
        sp.cstat = (short)(sp.cstat | Gameutils.CSTAT_SPRITE_YCENTER);
        Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerNinjaClimb);
    }

    public static void DoPlayerClimb(PlayerStr pp) {
        USER u = Gameutils.pUser[pp.PlayerSprite];
        SPRITE sp = pp.getSprite();
        boolean LadderUpdate = false;
        if (WangNetwork.Prediction) {
            return;
        }
        pp.xvect += pp.input.vel * 3 * 2 << 6;
        pp.yvect += pp.input.svel * 3 * 2 << 6;
        pp.xvect = Pragmas.mulscale(pp.xvect, 45056L, 16);
        pp.yvect = Pragmas.mulscale(pp.yvect, 45056L, 16);
        if (Pragmas.klabs(pp.xvect) < 12800 && Pragmas.klabs(pp.yvect) < 12800) {
            pp.yvect = 0;
            pp.xvect = 0;
        }
        int climbvel = Gameutils.FindDistance2D(pp.xvect, pp.yvect) >> 9;
        int dot = Gameutils.DOT_PRODUCT_2D(pp.xvect, pp.yvect, Engine.sintable[Gameutils.NORM_ANGLE(pp.getAnglei() + 512)], Engine.sintable[pp.getAnglei()]);
        if (dot < 0) {
            climbvel = -climbvel;
        }
        Player.PLAYER_RUN_LOCK(pp);
        if (Gameutils.TEST_SYNC_KEY(pp, 19)) {
            pp.Flags &= ~(Gameutils.PF_CLIMBING | Gameutils.PF_WEAPON_DOWN);
            sp.cstat = (short)(sp.cstat & ~Gameutils.CSTAT_SPRITE_YCENTER);
            Player.DoPlayerBeginJump(pp);
            return;
        }
        if (climbvel != 0) {
            int i = 3;
            while (i != 0) {
                if (pp.posx != pp.lx) {
                    if (pp.posx < pp.lx) {
                        pp.posx += 8;
                    } else if (pp.posx > pp.lx) {
                        pp.posx -= 8;
                    }
                    if (Pragmas.klabs(pp.posx - pp.lx) <= 8) {
                        pp.posx = pp.lx;
                    }
                }
                if (pp.posy != pp.ly) {
                    if (pp.posy < pp.ly) {
                        pp.posy += 8;
                    } else if (pp.posy > pp.ly) {
                        pp.posy -= 8;
                    }
                    if (Pragmas.klabs(pp.posy - pp.ly) <= 8) {
                        pp.posy = pp.ly;
                    }
                }
                if (sp.x != u.sx) {
                    if (sp.x < u.sx) {
                        sp.x += 8;
                    } else if (sp.x > u.sx) {
                        sp.x -= 8;
                    }
                    if (Pragmas.klabs(sp.x - u.sx) <= 8) {
                        sp.x = u.sx;
                    }
                }
                if (sp.y != u.sy) {
                    if (sp.y < u.sy) {
                        sp.y += 8;
                    } else if (sp.y > u.sy) {
                        sp.y -= 8;
                    }
                    if (Pragmas.klabs(sp.y - u.sy) <= 8) {
                        sp.y = u.sy;
                    }
                }
                i = (char)(i - 1);
            }
        }
        Player.DoPlayerZrange(pp);
        if (climbvel > 0) {
            int climb_amt = (climbvel >> 4) * 8;
            pp.climb_ndx &= 0x3FF;
            pp.posz -= climb_amt;
            if (Player.PlayerCeilingHit(pp, pp.hiz)) {
                pp.posz = pp.hiz;
                Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerNinjaClimb);
            }
            if (pp.LadderSector != -1 && Player.PlayerCeilingHit(pp, pp.hiz + Gameutils.Z(4))) {
                pp.posz = Engine.sector[pp.LadderSector].ceilingz + Gameutils.Z(4);
                Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerNinjaClimb);
            }
            if (pp.LadderSector == -1 || pp.posz < Engine.sector[pp.LadderSector].floorz - Gameutils.Z(6)) {
                pp.jump_speed = -1100;
                pp.Flags &= ~(Gameutils.PF_CLIMBING | Gameutils.PF_WEAPON_DOWN);
                sp.cstat = (short)(sp.cstat & ~Gameutils.CSTAT_SPRITE_YCENTER);
                Player.DoPlayerBeginForceJump(pp);
            }
        } else if (climbvel < 0) {
            int climb_amt = -(climbvel >> 4) * 8;
            pp.climb_ndx &= 0x3FF;
            pp.posz += climb_amt;
            if (Player.PlayerFloorHit(pp, pp.loz - Gameutils.Z(4) - PLAYER_HEIGHT)) {
                pp.posz = pp.loz - Gameutils.Z(4) - PLAYER_HEIGHT;
                if (climbvel < 0) {
                    pp.Flags &= ~(Gameutils.PF_CLIMBING | Gameutils.PF_WEAPON_DOWN);
                    sp.cstat = (short)(sp.cstat & ~Gameutils.CSTAT_SPRITE_YCENTER);
                    Player.DoPlayerBeginRun(pp);
                    return;
                }
            }
        } else {
            Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerNinjaClimb);
        }
        sp.z = pp.posz + PLAYER_HEIGHT;
        Main.engine.changespritesect(pp.PlayerSprite, pp.cursectnum);
        Player.DoPlayerHorizon(pp);
        if (Gameutils.FAF_ConnectArea(pp.cursectnum)) {
            pp.cursectnum = Main.engine.updatesectorz(pp.posx, pp.posy, pp.posz, pp.cursectnum);
            LadderUpdate = true;
        }
        if (Warp.WarpPlane(pp.posx, pp.posy, pp.posz, pp.cursectnum) != null) {
            pp.posx = Warp.warp.x;
            pp.posy = Warp.warp.y;
            pp.posz = Warp.warp.z;
            pp.cursectnum = Warp.warp.sectnum;
            Player.PlayerWarpUpdatePos(pp);
            LadderUpdate = true;
        }
        if (LadderUpdate) {
            Main.engine.neartag(pp.posx, pp.posy, pp.posz, pp.cursectnum, pp.getAnglei(), Engine.neartag, 800, 3);
            short wal = Engine.neartag.tagwall;
            if (wal >= 0) {
                SPRITE lsp = Engine.sprite[Player.FindNearSprite(pp.getSprite(), 53)];
                int nx = Gameutils.MOVEx(100, lsp.ang);
                int ny = Gameutils.MOVEy(100, lsp.ang);
                pp.LadderAngle = Gameutils.NORM_ANGLE(lsp.ang + 1024);
                pp.LadderSector = Engine.wall[wal].nextsector;
                pp.lx = lsp.x + nx * 5;
                pp.ly = lsp.y + ny * 5;
                pp.pang = pp.LadderAngle;
            }
        }
    }

    public static boolean DoPlayerWadeSuperJump(PlayerStr pp) {
        int zh = Engine.sector[pp.cursectnum].floorz - Gameutils.Z(pp.WadeDepth) - Gameutils.Z(2);
        if (WangNetwork.Prediction) {
            return false;
        }
        int i = 0;
        while (i < 3) {
            Rooms.FAFhitscan(pp.posx, pp.posy, zh, pp.cursectnum, Engine.sintable[Gameutils.NORM_ANGLE(pp.getAnglei() + angs[i] + 512)], Engine.sintable[Gameutils.NORM_ANGLE(pp.getAnglei() + angs[i])], 0, Engine.pHitInfo, Gameutils.CLIPMASK_MISSILE);
            if (Engine.pHitInfo.hitwall >= 0 && Engine.pHitInfo.hitsect >= 0) {
                Engine.pHitInfo.hitsect = Engine.wall[Engine.pHitInfo.hitwall].nextsector;
                if (Engine.pHitInfo.hitsect != -1 && Pragmas.klabs(Engine.sector[Engine.pHitInfo.hitsect].floorz - pp.posz) < Gameutils.Z(50) && Game.Distance(pp.posx, pp.posy, Engine.pHitInfo.hitx, Engine.pHitInfo.hity) < (pp.getSprite().clipdist << 2) + 256) {
                    return true;
                }
            }
            i = (short)(i + 1);
        }
        return false;
    }

    public static boolean PlayerFlyKey(PlayerStr pp) {
        if (!Game.GodMode) {
            return false;
        }
        if (Game.MessageInputMode) {
            return false;
        }
        boolean key = Gameutils.TEST_SYNC_KEY(pp, 15);
        if (key) {
            Gameutils.RESET_SYNC_KEY(pp, 15);
        }
        return key;
    }

    public static void DoPlayerBeginCrawl(PlayerStr pp) {
        USER u = Gameutils.pUser[pp.PlayerSprite];
        pp.Flags &= ~(Gameutils.PF_FALLING | Gameutils.PF_JUMPING);
        pp.Flags |= Gameutils.PF_CRAWLING;
        pp.friction = 45056;
        pp.floor_dist = PLAYER_CRAWL_FLOOR_DIST;
        pp.ceiling_dist = PLAYER_CRAWL_CEILING_DIST;
        pp.DoPlayerAction = Player_Action_Func.DoPlayerCrawl;
        Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Crawl);
    }

    public static boolean PlayerFallTest(PlayerStr pp, int player_height) {
        if (Pragmas.klabs(pp.posz - pp.loz) > player_height + PLAYER_FALL_HEIGHT) {
            return pp.lo_sectp == -1 || Pragmas.klabs(Engine.sector[pp.lo_sectp].floorheinum) <= 3000 || !MyTypes.TEST(Engine.sector[pp.lo_sectp].floorstat, Gameutils.FLOOR_STAT_SLOPE) || pp.lo_sectp != pp.lastcursectnum;
        }
        return false;
    }

    public static void DoPlayerCrawl(PlayerStr pp) {
        USER u = Gameutils.pUser[pp.PlayerSprite];
        if (Gameutils.SectorIsUnderwaterArea(pp.cursectnum)) {
            if (Gameutils.FAF_ConnectArea(pp.cursectnum)) {
                pp.posz = Engine.sector[pp.cursectnum].ceilingz + Gameutils.Z(12);
            }
            Player.DoPlayerBeginDiveNoWarp(pp);
        }
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_LOCK_CRAWL)) {
            if (Gameutils.TEST_SYNC_KEY(pp, 14)) {
                if (Gameutils.FLAG_KEY_PRESSED(pp, 14) && Pragmas.klabs(pp.loz - pp.hiz) >= PLAYER_STANDING_ROOM) {
                    Gameutils.FLAG_KEY_RELEASE(pp, 14);
                    pp.Flags &= ~Gameutils.PF_CRAWLING;
                    Player.DoPlayerBeginRun(pp);
                    return;
                }
            } else {
                Gameutils.FLAG_KEY_RESET(pp, 14);
            }
            if (Gameutils.TEST_SYNC_KEY(pp, 19) && Pragmas.klabs(pp.loz - pp.hiz) >= PLAYER_STANDING_ROOM) {
                pp.Flags &= ~Gameutils.PF_CRAWLING;
                Player.DoPlayerBeginRun(pp);
                return;
            }
        } else if (!Gameutils.TEST_SYNC_KEY(pp, 20) && Pragmas.klabs(pp.loz - pp.hiz) >= PLAYER_STANDING_ROOM) {
            pp.Flags &= ~Gameutils.PF_CRAWLING;
            Player.DoPlayerBeginRun(pp);
            return;
        }
        if (pp.lo_sectp != -1 && MyTypes.TEST(Engine.sector[pp.lo_sectp].extra, Gameutils.SECTFX_CURRENT)) {
            Player.DoPlayerCurrent(pp);
        }
        Player.DoPlayerMove(pp);
        if (pp.WadeDepth > 30) {
            pp.Flags &= ~Gameutils.PF_CRAWLING;
            Player.DoPlayerBeginRun(pp);
            return;
        }
        if (!MyTypes.TEST(pp.Flags, Gameutils.PF_PLAYER_MOVED)) {
            Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Crawl);
        }
        if (Player.PlayerFallTest(pp, PLAYER_CRAWL_HEIGHT)) {
            pp.jump_speed = Gameutils.Z(1);
            pp.Flags &= ~Gameutils.PF_CRAWLING;
            Player.DoPlayerBeginFall(pp);
            Player.DoPlayerFall(pp);
            return;
        }
        if (ru.m210projects.Build.Gameutils.isValidSector(pp.cursectnum) && MyTypes.TEST(Engine.sector[pp.cursectnum].extra, Gameutils.SECTFX_DYNAMIC_AREA)) {
            pp.posz = pp.loz - PLAYER_CRAWL_HEIGHT;
        }
        Player.DoPlayerBob(pp);
        Player.DoPlayerCrawlHeight(pp);
    }

    public static void DoPlayerBeginFly(PlayerStr pp) {
        pp.Flags &= ~(Gameutils.PF_FALLING | Gameutils.PF_JUMPING | Gameutils.PF_CRAWLING);
        pp.Flags |= Gameutils.PF_FLYING;
        pp.friction = 55808;
        pp.floor_dist = PLAYER_RUN_FLOOR_DIST;
        pp.ceiling_dist = PLAYER_RUN_CEILING_DIST;
        pp.DoPlayerAction = Player_Action_Func.DoPlayerFly;
        pp.z_speed = -Gameutils.Z(10);
        pp.jump_speed = 0;
        pp.bob_amt = 0;
        pp.bob_ndx = (short)1024;
        Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerNinjaFly);
    }

    public static int GetSinNdx(int range, int bob_amt) {
        int amt = Gameutils.Z(512) / range;
        return bob_amt * amt;
    }

    public static void PlayerWarpUpdatePos(PlayerStr pp) {
        if (WangNetwork.Prediction) {
            return;
        }
        pp.oposx = pp.posx;
        pp.oposy = pp.posy;
        pp.oposz = pp.posz;
        Player.DoPlayerZrange(pp);
        Player.UpdatePlayerSprite(pp);
    }

    public static boolean PlayerCeilingHit(PlayerStr pp, int zlimit) {
        return pp.posz < zlimit;
    }

    public static boolean PlayerFloorHit(PlayerStr pp, int zlimit) {
        return pp.posz > zlimit;
    }

    public static void DoPlayerFly(PlayerStr pp) {
        if (Gameutils.SectorIsUnderwaterArea(pp.cursectnum)) {
            Player.DoPlayerBeginDiveNoWarp(pp);
            return;
        }
        if (Gameutils.TEST_SYNC_KEY(pp, 20)) {
            pp.z_speed += 1000;
            if (pp.z_speed > 2560) {
                pp.z_speed = 2560;
            }
        }
        if (Gameutils.TEST_SYNC_KEY(pp, 19)) {
            pp.z_speed -= 1000;
            if (pp.z_speed < -2560) {
                pp.z_speed = -2560;
            }
        }
        pp.z_speed = Pragmas.mulscale(pp.z_speed, 58000L, 16);
        pp.posz += pp.z_speed;
        if (Player.PlayerCeilingHit(pp, pp.hiz + PLAYER_FLY_BOB_AMT + Gameutils.Z(8))) {
            pp.posz = pp.hiz + PLAYER_FLY_BOB_AMT + Gameutils.Z(8);
            pp.z_speed = 0;
        }
        if (Player.PlayerFloorHit(pp, pp.loz - PLAYER_HEIGHT - PLAYER_FLY_BOB_AMT)) {
            pp.posz = pp.loz - PLAYER_HEIGHT - PLAYER_FLY_BOB_AMT;
            pp.z_speed = 0;
        }
        if (Player.PlayerFlyKey(pp)) {
            pp.Flags &= ~Gameutils.PF_FLYING;
            pp.bob_amt = 0;
            pp.bob_ndx = 0;
            Player.DoPlayerBeginFall(pp);
            Player.DoPlayerFall(pp);
            return;
        }
        Player.DoPlayerMove(pp);
    }

    public static int FindNearSprite(SPRITE sp, int stat) {
        int near_dist = 15000;
        int near_fp = -1;
        int fs = Engine.headspritestat[stat];
        while (fs != -1) {
            int next_fs = Engine.nextspritestat[fs];
            SPRITE fp = Engine.sprite[fs];
            int dist = Game.Distance(sp.x, sp.y, fp.x, fp.y);
            if (dist < near_dist) {
                near_dist = dist;
                near_fp = fs;
            }
            fs = next_fs;
        }
        return near_fp;
    }

    public static boolean PlayerOnLadder(PlayerStr pp) {
        int wal = -1;
        if (WangNetwork.Prediction) {
            return false;
        }
        Main.engine.neartag(pp.posx, pp.posy, pp.posz, pp.cursectnum, pp.getAnglei(), Engine.neartag, 1792, 3);
        short neartagwall = Engine.neartag.tagwall;
        int dir = Gameutils.DOT_PRODUCT_2D(pp.xvect, pp.yvect, Engine.sintable[Gameutils.NORM_ANGLE(pp.getAnglei() + 512)], Engine.sintable[pp.getAnglei()]);
        if (dir < 0) {
            return false;
        }
        if (neartagwall < 0 || Engine.wall[neartagwall].lotag != 305) {
            return false;
        }
        int i = 0;
        while (i < angles.length) {
            Main.engine.neartag(pp.posx, pp.posy, pp.posz, pp.cursectnum, Gameutils.NORM_ANGLE(pp.getAnglei() + angles[i]), Engine.neartag, 600, 3);
            wal = Engine.neartag.tagwall;
            int dist = Engine.neartag.taghitdist;
            if (wal < 0 || dist < 100 || Engine.wall[wal].lotag != 305) {
                return false;
            }
            Rooms.FAFhitscan(pp.posx, pp.posy, pp.posz, pp.cursectnum, Engine.sintable[Gameutils.NORM_ANGLE(pp.getAnglei() + angles[i] + 512)], Engine.sintable[Gameutils.NORM_ANGLE(pp.getAnglei() + angles[i])], 0, Engine.pHitInfo, Gameutils.CLIPMASK_MISSILE);
            dist = Gameutils.DIST(pp.posx, pp.posy, Engine.pHitInfo.hitx, Engine.pHitInfo.hity);
            if (Engine.pHitInfo.hitsprite >= 0 ? MyTypes.TEST(Engine.sprite[Engine.pHitInfo.hitsprite].cstat, Gameutils.CSTAT_SPRITE_BLOCK) && !MyTypes.TEST(Engine.sprite[Engine.pHitInfo.hitsprite].cstat, Gameutils.CSTAT_SPRITE_WALL) : Engine.pHitInfo.hitwall >= 0 && Engine.wall[Engine.pHitInfo.hitwall].lotag != 305) {
                return false;
            }
            ++i;
        }
        int lspi = Player.FindNearSprite(pp.getSprite(), 53);
        if (lspi == -1) {
            return false;
        }
        SPRITE lsp = Engine.sprite[lspi];
        int nx = Gameutils.MOVEx(100, lsp.ang);
        int ny = Gameutils.MOVEy(100, lsp.ang);
        pp.LadderAngle = Gameutils.NORM_ANGLE(lsp.ang + 1024);
        pp.LadderSector = Engine.wall[wal].nextsector;
        pp.lx = lsp.x + nx * 5;
        pp.ly = lsp.y + ny * 5;
        pp.pang = pp.LadderAngle;
        return true;
    }

    public static boolean DoPlayerTestCrawl(PlayerStr pp) {
        return Pragmas.klabs(pp.loz - pp.hiz) < PLAYER_STANDING_ROOM;
    }

    public static boolean PlayerInDiveArea(PlayerStr pp) {
        if (pp.lo_sectp == -1) {
            return false;
        }
        SECTOR sectp = Engine.sector[pp.cursectnum];
        if (MyTypes.TEST(sectp.extra, Gameutils.SECTFX_DIVE_AREA)) {
            Player.CheckFootPrints(pp);
            return true;
        }
        return false;
    }

    public static boolean PlayerCanDive(PlayerStr pp) {
        if (WangNetwork.Prediction) {
            return false;
        }
        if ((Gameutils.TEST_SYNC_KEY(pp, 20) || Gameutils.TEST_SYNC_KEY(pp, 14) || pp.jump_speed > 0) && Player.PlayerInDiveArea(pp)) {
            pp.posz += Gameutils.Z(20);
            pp.z_speed = Gameutils.Z(20);
            pp.jump_speed = 0;
            if (pp.posz > pp.loz - Gameutils.Z(pp.WadeDepth) - Gameutils.Z(2)) {
                Player.DoPlayerBeginDive(pp);
            }
            return true;
        }
        return false;
    }

    public static boolean PlayerCanDiveNoWarp(PlayerStr pp) {
        if (WangNetwork.Prediction) {
            return false;
        }
        if (pp.jump_speed > 1400 && Gameutils.FAF_ConnectArea(pp.cursectnum)) {
            short sectnum = pp.cursectnum;
            sectnum = Main.engine.updatesectorz(pp.posx, pp.posy, Gameutils.SPRITEp_BOS(pp.getSprite()), sectnum);
            if (Gameutils.SectorIsUnderwaterArea(sectnum)) {
                pp.cursectnum = sectnum;
                pp.posz = Engine.sector[sectnum].ceilingz;
                pp.posz += Gameutils.Z(20);
                pp.z_speed = Gameutils.Z(20);
                pp.jump_speed = 0;
                Sound.PlaySound(196, pp, 8);
                Player.DoPlayerBeginDiveNoWarp(pp);
                return true;
            }
        }
        return false;
    }

    public static int GetOverlapSector(int x, int y, LONGp over, LONGp under) {
        int found = 0;
        if (Sector.SectUser[under.value] != null && Sector.SectUser[under.value].number >= 30000 || Sector.SectUser[over.value] != null && Sector.SectUser[over.value].number >= 30000) {
            return Player.GetOverlapSector2(x, y, over, under);
        }
        if (Main.engine.inside(x, y, (short)over.value) != 0) {
            Player.sf[found] = (short)over.value;
            ++found;
        }
        if (Main.engine.inside(x, y, (short)under.value) != 0) {
            Player.sf[found] = (short)under.value;
            ++found;
        }
        if (found == 0) {
            int i = 0;
            while (i < Engine.numsectors) {
                if (Main.engine.inside(x, y, (short)i) != 0) {
                    Player.sf[found] = (short)i;
                    ++found;
                }
                ++i;
            }
        }
        if (found == 0) {
            return 0;
        }
        if (found == 2) {
            if (Engine.sector[Player.sf[0]].floorz > Engine.sector[Player.sf[1]].floorz) {
                under.value = sf[0];
                over.value = sf[1];
            } else {
                under.value = sf[1];
                over.value = sf[0];
            }
        } else {
            over.value = sf[0];
            under.value = -1;
        }
        return found;
    }

    private static int GetOverlapSector2(int x, int y, LONGp over, LONGp under) {
        int found = 0;
        if (Main.engine.inside(x, y, (short)over.value) != 0) {
            Player.sf[found] = (short)over.value;
            ++found;
        }
        if (Main.engine.inside(x, y, (short)under.value) != 0) {
            Player.sf[found] = (short)under.value;
            ++found;
        }
        if (found == 0) {
            short nexti;
            short i = Engine.headspritestat[49];
            while (i != -1) {
                nexti = Engine.nextspritestat[i];
                if (Main.engine.inside(x, y, Engine.sprite[i].sectnum) != 0) {
                    Player.sf[found] = Engine.sprite[i].sectnum;
                    ++found;
                }
                i = nexti;
            }
            int stat = 0;
            while (stat < UnderStatList.length) {
                i = Engine.headspritestat[UnderStatList[stat]];
                while (i != -1) {
                    nexti = Engine.nextspritestat[i];
                    if (Engine.sprite[i].lotag != 0 && Main.engine.inside(x, y, Engine.sprite[i].sectnum) != 0) {
                        Player.sf[found] = Engine.sprite[i].sectnum;
                        ++found;
                    }
                    i = nexti;
                }
                stat = (short)(stat + 1);
            }
        }
        if (found == 0) {
            return 0;
        }
        if (found == 2) {
            if (Engine.sector[Player.sf[0]].floorz > Engine.sector[Player.sf[1]].floorz) {
                under.value = sf[0];
                over.value = sf[1];
            } else {
                under.value = sf[1];
                over.value = sf[0];
            }
        } else {
            over.value = sf[0];
            under.value = -1;
        }
        return found;
    }

    public static void DoPlayerWarpToUnderwater(PlayerStr pp) {
        short nexti;
        USER u = Gameutils.pUser[pp.PlayerSprite];
        Sect_User sectu = Sector.SectUser[pp.cursectnum];
        SPRITE under_sp = null;
        SPRITE over_sp = null;
        boolean Found = false;
        if (WangNetwork.Prediction) {
            return;
        }
        short i = Engine.headspritestat[49];
        while (i != -1) {
            nexti = Engine.nextspritestat[i];
            over_sp = Engine.sprite[i];
            if (MyTypes.TEST(Engine.sector[over_sp.sectnum].extra, Gameutils.SECTFX_DIVE_AREA) && Sector.SectUser[over_sp.sectnum] != null && Sector.SectUser[over_sp.sectnum].number == sectu.number) {
                Found = true;
                break;
            }
            i = nexti;
        }
        if (!Found) {
            return;
        }
        Found = false;
        i = Engine.headspritestat[50];
        while (i != -1) {
            nexti = Engine.nextspritestat[i];
            under_sp = Engine.sprite[i];
            if (MyTypes.TEST(Engine.sector[under_sp.sectnum].extra, Gameutils.SECTFX_UNDERWATER) && Sector.SectUser[under_sp.sectnum] != null && Sector.SectUser[under_sp.sectnum].number == sectu.number) {
                Found = true;
                break;
            }
            i = nexti;
        }
        if (!Found) {
            return;
        }
        u.sx = over_sp.x - pp.posx;
        u.sy = over_sp.y - pp.posy;
        pp.posx = under_sp.x - u.sx;
        pp.posy = under_sp.y - u.sy;
        pp.cursectnum = Player.GetOverlapSector(pp.posx, pp.posy, Game.tmp_ptr[0].set(over_sp.sectnum), Game.tmp_ptr[1].set(under_sp.sectnum)) == 2 ? (short)Game.tmp_ptr[1].value : (short)Game.tmp_ptr[0].value;
        pp.posz = Engine.sector[under_sp.sectnum].ceilingz + Gameutils.Z(6);
        pp.oposx = pp.posx;
        pp.oposy = pp.posy;
        pp.oposz = pp.posz;
        Player.DoPlayerZrange(pp);
    }

    public static void DoPlayerWarpToSurface(PlayerStr pp) {
        short nexti;
        USER u = Gameutils.pUser[pp.PlayerSprite];
        Sect_User sectu = Sector.SectUser[pp.cursectnum];
        SPRITE under_sp = null;
        SPRITE over_sp = null;
        boolean Found = false;
        if (WangNetwork.Prediction) {
            return;
        }
        short i = Engine.headspritestat[50];
        while (i != -1) {
            nexti = Engine.nextspritestat[i];
            under_sp = Engine.sprite[i];
            if (MyTypes.TEST(Engine.sector[under_sp.sectnum].extra, Gameutils.SECTFX_UNDERWATER) && Sector.SectUser[under_sp.sectnum] != null && Sector.SectUser[under_sp.sectnum].number == sectu.number) {
                Found = true;
                break;
            }
            i = nexti;
        }
        if (!Found) {
            return;
        }
        Found = false;
        i = Engine.headspritestat[49];
        while (i != -1) {
            nexti = Engine.nextspritestat[i];
            over_sp = Engine.sprite[i];
            if (MyTypes.TEST(Engine.sector[over_sp.sectnum].extra, Gameutils.SECTFX_DIVE_AREA) && Sector.SectUser[over_sp.sectnum] != null && Sector.SectUser[over_sp.sectnum].number == sectu.number) {
                Found = true;
                break;
            }
            i = nexti;
        }
        u.sx = under_sp.x - pp.posx;
        u.sy = under_sp.y - pp.posy;
        pp.posx = over_sp.x - u.sx;
        pp.posy = over_sp.y - u.sy;
        if (Player.GetOverlapSector(pp.posx, pp.posy, Game.tmp_ptr[0].set(over_sp.sectnum), Game.tmp_ptr[1].set(under_sp.sectnum)) != 0) {
            pp.cursectnum = (short)Game.tmp_ptr[0].value;
        }
        pp.posz = Engine.sector[over_sp.sectnum].floorz - Gameutils.Z(2);
        Player.DoPlayerZrange(pp);
        Player.DoPlayerSetWadeDepth(pp);
        pp.posz -= Gameutils.Z(pp.WadeDepth);
        pp.oposx = pp.posx;
        pp.oposy = pp.posy;
        pp.oposz = pp.posz;
    }

    public static void DoPlayerBeginDive(PlayerStr pp) {
        SPRITE sp = Engine.sprite[pp.PlayerSprite];
        USER u = Gameutils.pUser[pp.PlayerSprite];
        if (WangNetwork.Prediction) {
            return;
        }
        if (pp.Bloody) {
            pp.Bloody = false;
        }
        pp.Flags |= Gameutils.PF_DIVING;
        Palette.DoPlayerDivePalette(pp);
        Palette.DoPlayerNightVisionPalette(pp);
        if (pp == Game.Player[Game.screenpeek]) {
            Sound.COVER_SetReverb(140);
            pp.Reverb = (short)140;
        }
        Weapon.SpawnSplash(pp.PlayerSprite);
        Player.DoPlayerWarpToUnderwater(pp);
        Sector.OperateTripTrigger(pp);
        pp.Flags &= ~(Gameutils.PF_JUMPING | Gameutils.PF_FALLING);
        pp.Flags &= ~Gameutils.PF_CRAWLING;
        pp.Flags &= ~Gameutils.PF_LOCK_CRAWL;
        pp.friction = 49152;
        pp.ceiling_dist = PLAYER_DIVE_CEILING_DIST;
        pp.floor_dist = PLAYER_DIVE_FLOOR_DIST;
        sp.cstat = (short)(sp.cstat | Gameutils.CSTAT_SPRITE_YCENTER);
        pp.DoPlayerAction = Player_Action_Func.DoPlayerDive;
        pp.DiveTics = (short)1440;
        pp.DiveDamageTics = 0;
        Player.DoPlayerMove(pp);
        Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Dive);
        Player.DoPlayerDive(pp);
    }

    public static void DoPlayerBeginDiveNoWarp(PlayerStr pp) {
        SPRITE sp = Engine.sprite[pp.PlayerSprite];
        USER u = Gameutils.pUser[pp.PlayerSprite];
        if (WangNetwork.Prediction) {
            return;
        }
        if (!Gameutils.SectorIsUnderwaterArea(pp.cursectnum)) {
            return;
        }
        if (pp.Bloody) {
            pp.Bloody = false;
        }
        if (pp == Game.Player[Game.screenpeek]) {
            Sound.COVER_SetReverb(140);
            pp.Reverb = (short)140;
        }
        Player.CheckFootPrints(pp);
        if (pp.lo_sectp != -1 && MyTypes.DTEST(Engine.sector[pp.lo_sectp].extra, Gameutils.SECTFX_LIQUID_MASK) == Gameutils.SECTFX_LIQUID_LAVA) {
            pp.Flags |= Gameutils.PF_DIVING_IN_LAVA;
            u.DamageTics = 0;
        }
        pp.Flags |= Gameutils.PF_DIVING;
        Palette.DoPlayerDivePalette(pp);
        Palette.DoPlayerNightVisionPalette(pp);
        pp.Flags &= ~(Gameutils.PF_JUMPING | Gameutils.PF_FALLING);
        pp.friction = 49152;
        pp.ceiling_dist = PLAYER_DIVE_CEILING_DIST;
        pp.floor_dist = PLAYER_DIVE_FLOOR_DIST;
        sp.cstat = (short)(sp.cstat | Gameutils.CSTAT_SPRITE_YCENTER);
        pp.DoPlayerAction = Player_Action_Func.DoPlayerDive;
        pp.z_speed = 0;
        pp.DiveTics = (short)1440;
        pp.DiveDamageTics = 0;
        Player.DoPlayerMove(pp);
        Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Dive);
        Player.DoPlayerDive(pp);
    }

    public static void DoPlayerStopDiveNoWarp(PlayerStr pp) {
        if (WangNetwork.Prediction) {
            return;
        }
        if (!Draw.NoMeters) {
            Draw.SetRedrawScreen(pp);
        }
        if (pp.TalkVocHandle != null && pp.TalkVocHandle.isActive()) {
            pp.TalkVocHandle.stop();
            pp.TalkVocHandle = null;
            pp.TalkVocnum = -1;
            pp.PlayerTalking = false;
        }
        Sound.PlayerSound(476, 13, pp);
        pp.bob_amt = 0;
        pp.Flags &= ~(Gameutils.PF_DIVING | Gameutils.PF_DIVING_IN_LAVA);
        Palette.DoPlayerDivePalette(pp);
        Palette.DoPlayerNightVisionPalette(pp);
        pp.getSprite().cstat = (short)(pp.getSprite().cstat & ~Gameutils.CSTAT_SPRITE_YCENTER);
        if (pp == Game.Player[Game.screenpeek]) {
            Sound.COVER_SetReverb(0);
            pp.Reverb = 0;
        }
        Player.DoPlayerZrange(pp);
    }

    public static void DoPlayerStopDive(PlayerStr pp) {
        SPRITE sp = Engine.sprite[pp.PlayerSprite];
        if (WangNetwork.Prediction) {
            return;
        }
        if (!Draw.NoMeters) {
            Draw.SetRedrawScreen(pp);
        }
        if (pp.TalkVocHandle != null && pp.TalkVocHandle.isActive()) {
            pp.TalkVocHandle.stop();
        }
        pp.TalkVocnum = -1;
        pp.TalkVocHandle = null;
        pp.PlayerTalking = false;
        Sound.PlayerSound(476, 13, pp);
        pp.bob_amt = 0;
        Player.DoPlayerWarpToSurface(pp);
        Player.DoPlayerBeginWade(pp);
        pp.Flags &= ~(Gameutils.PF_DIVING | Gameutils.PF_DIVING_IN_LAVA);
        Palette.DoPlayerDivePalette(pp);
        Palette.DoPlayerNightVisionPalette(pp);
        sp.cstat = (short)(sp.cstat & ~Gameutils.CSTAT_SPRITE_YCENTER);
        if (pp == Game.Player[Game.screenpeek]) {
            Sound.COVER_SetReverb(0);
            pp.Reverb = 0;
        }
    }

    public static void DoPlayerDiveMeter(PlayerStr pp) {
        int color = 0;
        if (Draw.NoMeters) {
            return;
        }
        if (pp != Game.Player[Mmulti.myconnectindex]) {
            return;
        }
        if (!MyTypes.TEST(pp.Flags, Gameutils.PF_DIVING | Gameutils.PF_DIVING_IN_LAVA)) {
            return;
        }
        int meterunit = 48;
        if (meterunit <= 0) {
            return;
        }
        short metertics = (short)(pp.DiveTics / meterunit);
        if (metertics <= 0 && !MyTypes.TEST(pp.Flags, Gameutils.PF_DIVING | Gameutils.PF_DIVING_IN_LAVA)) {
            Draw.SetRedrawScreen(pp);
            return;
        }
        if (metertics <= 0) {
            return;
        }
        int y = Mmulti.numplayers < 2 ? 10 : (Mmulti.numplayers >= 2 && Mmulti.numplayers <= 4 ? 20 : 30);
        color = metertics <= 12 && metertics > 6 ? 20 : (metertics <= 6 ? 25 : 22);
        Main.engine.rotatesprite(0xD00000, y << 16, 65536, 0, 5408, 1, 1, Gameutils.ROTATE_SPRITE_SCREEN_CLIP, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
        Main.engine.rotatesprite(0x1090000, y << 16, 65536, 0, 5406 - metertics, 1, color, Gameutils.ROTATE_SPRITE_SCREEN_CLIP, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
    }

    public static void DoPlayerDive(PlayerStr pp) {
        if (!ru.m210projects.Build.Gameutils.isValidSector(pp.cursectnum)) {
            return;
        }
        USER u = Gameutils.pUser[pp.PlayerSprite];
        Sect_User sectu = Sector.SectUser[pp.cursectnum];
        if (!Gameutils.SectorIsUnderwaterArea(pp.cursectnum)) {
            Player.DoPlayerStopDiveNoWarp(pp);
            Player.DoPlayerBeginRun(pp);
            return;
        }
        pp.DiveTics = (short)(pp.DiveTics - 3);
        if (pp.DiveTics < 0 && (pp.DiveDamageTics = (short)(pp.DiveDamageTics - 3)) < 0) {
            pp.DiveDamageTics = (short)50;
            Sound.PlayerSound(502, 9, pp);
            Panel.PlayerUpdateHealth(pp, -3 - (Gameutils.RANDOM_RANGE(1792) >> 8));
            Weapon.PlayerCheckDeath(pp, -1);
            if (MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
                return;
            }
        }
        if (pp.lo_sectp != -1 && MyTypes.TEST(Engine.sector[pp.lo_sectp].extra, Gameutils.SECTFX_CURRENT)) {
            Player.DoPlayerCurrent(pp);
        }
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_DIVING_IN_LAVA) && (u.DamageTics = (short)(u.DamageTics - 3)) < 0) {
            u.DamageTics = (short)30;
            Panel.PlayerUpdateHealth(pp, -40);
        }
        if (Gameutils.TEST_SYNC_KEY(pp, 20) || Gameutils.TEST_SYNC_KEY(pp, 14)) {
            pp.z_speed += 600;
            if (pp.z_speed > 1700) {
                pp.z_speed = 1700;
            }
        }
        if (Gameutils.TEST_SYNC_KEY(pp, 19)) {
            pp.z_speed -= 600;
            if (pp.z_speed < -1700) {
                pp.z_speed = -1700;
            }
        }
        pp.z_speed = Pragmas.mulscale(pp.z_speed, 58000L, 16);
        if (Pragmas.klabs(pp.z_speed) < 16) {
            pp.z_speed = 0;
        }
        pp.posz += pp.z_speed;
        if (pp.z_speed < 0 && Gameutils.FAF_ConnectArea(pp.cursectnum) && pp.posz < Engine.sector[pp.cursectnum].ceilingz + Gameutils.Z(10)) {
            short sectnum = pp.cursectnum;
            sectnum = Main.engine.updatesectorz(pp.posx, pp.posy, Engine.sector[pp.cursectnum].ceilingz - Gameutils.Z(8), sectnum);
            if (sectnum >= 0 && !Gameutils.SectorIsUnderwaterArea(sectnum)) {
                pp.posz = Engine.sector[pp.cursectnum].ceilingz - Gameutils.Z(8);
                pp.cursectnum = sectnum;
                Player.DoPlayerStopDiveNoWarp(pp);
                Player.DoPlayerBeginRun(pp);
                return;
            }
        }
        if (sectu != null && (sectu.number == 0 || MyTypes.TEST(sectu.flags, Gameutils.SECTFU_CANT_SURFACE))) {
            if (pp.posz < pp.hiz + pp.ceiling_dist) {
                pp.posz = pp.hiz + pp.ceiling_dist;
            }
        } else if (pp.posz < pp.hiz + Gameutils.Z(4) && pp.hi_sp == -1) {
            Player.DoPlayerStopDive(pp);
            return;
        }
        if (pp.posz >= pp.loz - PLAYER_DIVE_HEIGHT) {
            pp.posz = pp.loz - PLAYER_DIVE_HEIGHT;
        }
        if (Gameutils.PLAYER_MOVING(pp) == 0 && pp.z_speed == 0 && pp.up_speed == 0) {
            Player.DoPlayerSpriteBob(pp, PLAYER_DIVE_HEIGHT, PLAYER_DIVE_BOB_AMT, 3);
        } else if (Pragmas.klabs(pp.bob_amt) < Gameutils.Z(1)) {
            pp.bob_amt = 0;
            pp.bob_ndx = 0;
        } else {
            Player.DoPlayerSpriteBob(pp, PLAYER_DIVE_HEIGHT, PLAYER_DIVE_BOB_AMT, 3);
        }
        if (pp.posz + pp.bob_amt >= pp.loz - PLAYER_DIVE_HEIGHT) {
            pp.bob_ndx = Gameutils.NORM_ANGLE(pp.bob_ndx + (1536 - pp.bob_ndx) * 2);
            Player.DoPlayerSpriteBob(pp, PLAYER_DIVE_HEIGHT, PLAYER_DIVE_BOB_AMT, 3);
        }
        if (pp.posz + pp.bob_amt < pp.hiz + pp.ceiling_dist) {
            pp.bob_ndx = Gameutils.NORM_ANGLE(pp.bob_ndx + (512 - pp.bob_ndx) * 2);
            Player.DoPlayerSpriteBob(pp, PLAYER_DIVE_HEIGHT, PLAYER_DIVE_BOB_AMT, 3);
        }
        Player.DoPlayerMove(pp);
        if (!WangNetwork.Prediction && pp.z_speed != 0 && Gameutils.RANDOM_P2(32768) >> 5 < 64 || Gameutils.PLAYER_MOVING(pp) != 0 && Gameutils.RANDOM_P2(32768) >> 5 < 64) {
            Sound.PlaySound(158, pp, 0);
            short bubble = (short)Weapon.SpawnBubble(pp.PlayerSprite);
            if (bubble >= 0) {
                SPRITE bp = Engine.sprite[bubble];
                int nx = Gameutils.MOVEx(192, Gameutils.NORM_ANGLE(bp.ang + 1024));
                int ny = Gameutils.MOVEy(192, Gameutils.NORM_ANGLE(bp.ang + 1024));
                Sprites.move_sprite(bubble, nx, ny, 0, u.ceiling_dist, u.floor_dist, 0, 3);
            }
        }
    }

    public static boolean DoPlayerTestPlaxDeath(PlayerStr pp) {
        USER u = Gameutils.pUser[pp.PlayerSprite];
        if (pp.lo_sectp != -1 && MyTypes.TEST(Engine.sector[pp.lo_sectp].floorstat, Gameutils.FLOOR_STAT_PLAX)) {
            Panel.PlayerUpdateHealth(pp, -u.Health);
            Weapon.PlayerCheckDeath(pp, -1);
            return true;
        }
        return false;
    }

    private static void DoPlayerCurrent(PlayerStr pp) {
        if (!ru.m210projects.Build.Gameutils.isValidSector(pp.cursectnum)) {
            return;
        }
        Sect_User sectu = Sector.SectUser[pp.cursectnum];
        if (sectu == null) {
            return;
        }
        SPRITE psp = pp.getSprite();
        int xvect = sectu.speed * 3 * Engine.sintable[Gameutils.NORM_ANGLE(sectu.ang + 512)] >> 4;
        int yvect = sectu.speed * 3 * Engine.sintable[sectu.ang] >> 4;
        int push_ret = Main.engine.pushmove(pp.posx, pp.posy, pp.posz, pp.cursectnum, psp.clipdist << 2, pp.ceiling_dist, pp.floor_dist, Gameutils.CLIPMASK_PLAYER);
        if (Engine.pushmove_sectnum != -1) {
            pp.posx = Engine.pushmove_x;
            pp.posy = Engine.pushmove_y;
            pp.posz = Engine.pushmove_z;
            pp.cursectnum = Engine.pushmove_sectnum;
        }
        if (push_ret < 0) {
            if (!MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
                USER u = Gameutils.pUser[pp.PlayerSprite];
                Panel.PlayerUpdateHealth(pp, -u.Health);
                Weapon.PlayerCheckDeath(pp, -1);
                if (MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
                    return;
                }
            }
            return;
        }
        Main.engine.clipmove(pp.posx, pp.posy, pp.posz, pp.cursectnum, xvect, yvect, psp.clipdist << 2, pp.ceiling_dist, pp.floor_dist, Gameutils.CLIPMASK_PLAYER);
        if (Engine.clipmove_sectnum != -1) {
            pp.posx = Engine.clipmove_x;
            pp.posy = Engine.clipmove_y;
            pp.posz = Engine.clipmove_z;
            pp.cursectnum = Engine.clipmove_sectnum;
        }
        Player.PlayerCheckValidMove(pp);
        Main.engine.pushmove(pp.posx, pp.posy, pp.posz, pp.cursectnum, psp.clipdist << 2, pp.ceiling_dist, pp.floor_dist, Gameutils.CLIPMASK_PLAYER);
        if (Engine.pushmove_sectnum != -1) {
            pp.posx = Engine.pushmove_x;
            pp.posy = Engine.pushmove_y;
            pp.posz = Engine.pushmove_z;
            pp.cursectnum = Engine.pushmove_sectnum;
        }
        if (push_ret < 0) {
            if (!MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
                USER u = Gameutils.pUser[pp.PlayerSprite];
                Panel.PlayerUpdateHealth(pp, -u.Health);
                Weapon.PlayerCheckDeath(pp, -1);
                if (MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
                    return;
                }
            }
            return;
        }
    }

    public static void DoPlayerFireOutWater(PlayerStr pp) {
        USER u = Gameutils.pUser[pp.PlayerSprite];
        if (WangNetwork.Prediction) {
            return;
        }
        if (pp.WadeDepth > 20) {
            if (u.flame >= 0) {
                Weapon.SetSuicide(u.flame);
            }
            u.flame = (short)-2;
        }
    }

    public static void DoPlayerFireOutDeath(PlayerStr pp) {
        USER u = Gameutils.pUser[pp.PlayerSprite];
        if (WangNetwork.Prediction) {
            return;
        }
        if (u.flame >= 0) {
            Weapon.SetSuicide(u.flame);
        }
        u.flame = (short)-2;
    }

    public static void DoPlayerBeginWade(PlayerStr pp) {
        USER u = Gameutils.pUser[pp.PlayerSprite];
        if (Player.DoPlayerTestPlaxDeath(pp)) {
            return;
        }
        pp.Flags &= ~(Gameutils.PF_JUMPING | Gameutils.PF_FALLING);
        pp.Flags &= ~Gameutils.PF_CRAWLING;
        pp.friction = 50000;
        pp.floor_dist = PLAYER_WADE_FLOOR_DIST;
        pp.ceiling_dist = PLAYER_WADE_CEILING_DIST;
        pp.DoPlayerAction = Player_Action_Func.DoPlayerWade;
        Player.DoPlayerFireOutWater(pp);
        if (pp.jump_speed > 100) {
            Weapon.SpawnSplash(pp.PlayerSprite);
        }
        if (pp.jump_speed > 0 && pp.jump_speed < 1300) {
            pp.jump_speed = 0;
        }
        Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Run);
    }

    public static void DoPlayerWade(PlayerStr pp) {
        USER u = Gameutils.pUser[pp.PlayerSprite];
        Player.DoPlayerFireOutWater(pp);
        if (Gameutils.TEST_SYNC_KEY(pp, 18)) {
            if (Gameutils.FLAG_KEY_PRESSED(pp, 18) && ru.m210projects.Build.Gameutils.isValidSector(pp.cursectnum) && MyTypes.TEST(Engine.sector[pp.cursectnum].extra, Gameutils.SECTFX_OPERATIONAL)) {
                Gameutils.FLAG_KEY_RELEASE(pp, 18);
                Player.DoPlayerBeginOperate(pp);
                pp.bob_amt = 0;
                pp.bob_ndx = 0;
                return;
            }
        } else {
            Gameutils.FLAG_KEY_RESET(pp, 18);
        }
        if (Player.DoPlayerTestCrawl(pp) && pp.WadeDepth <= 30) {
            Player.DoPlayerBeginCrawl(pp);
            return;
        }
        if (Gameutils.TEST_SYNC_KEY(pp, 20) && pp.WadeDepth <= 30) {
            Player.DoPlayerBeginCrawl(pp);
            return;
        }
        if (Gameutils.TEST_SYNC_KEY(pp, 19)) {
            if (Gameutils.FLAG_KEY_PRESSED(pp, 19)) {
                Gameutils.FLAG_KEY_RELEASE(pp, 19);
                Player.DoPlayerBeginJump(pp);
                pp.bob_amt = 0;
                pp.bob_ndx = 0;
                return;
            }
        } else {
            Gameutils.FLAG_KEY_RESET(pp, 19);
        }
        if (Player.PlayerFlyKey(pp)) {
            Player.DoPlayerBeginFly(pp);
            pp.bob_amt = 0;
            pp.bob_ndx = 0;
            return;
        }
        if (Player.PlayerOnLadder(pp)) {
            Player.DoPlayerBeginClimb(pp);
            return;
        }
        if (pp.lo_sectp != -1 && MyTypes.TEST(Engine.sector[pp.lo_sectp].extra, Gameutils.SECTFX_CURRENT)) {
            Player.DoPlayerCurrent(pp);
        }
        Player.DoPlayerMove(pp);
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_PLAYER_MOVED)) {
            if (u.Rot != u.ActorActionSet.Run) {
                Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Run);
            }
        } else if (u.Rot != u.ActorActionSet.Stand) {
            Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Stand);
        }
        if (Pragmas.klabs(pp.posz - pp.loz) > PLAYER_HEIGHT + PLAYER_FALL_HEIGHT) {
            pp.jump_speed = Gameutils.Z(1);
            Player.DoPlayerBeginFall(pp);
            Player.DoPlayerFall(pp);
            return;
        }
        if (Player.PlayerCanDive(pp)) {
            pp.bob_amt = 0;
            pp.bob_ndx = 0;
            return;
        }
        if (Pragmas.klabs(pp.posz - pp.loz) > PLAYER_HEIGHT + PLAYER_FALL_HEIGHT) {
            pp.jump_speed = Gameutils.Z(1);
            Player.DoPlayerBeginFall(pp);
            Player.DoPlayerFall(pp);
            pp.bob_amt = 0;
            pp.bob_ndx = 0;
            return;
        }
        Player.DoPlayerBob(pp);
        Player.DoPlayerHeight(pp);
        if (pp.WadeDepth == 0) {
            Player.DoPlayerBeginRun(pp);
            return;
        }
    }

    public static void DoPlayerBeginOperateBoat(PlayerStr pp) {
        USER u = Gameutils.pUser[pp.PlayerSprite];
        pp.floor_dist = PLAYER_RUN_FLOOR_DIST;
        pp.ceiling_dist = PLAYER_RUN_CEILING_DIST;
        pp.DoPlayerAction = Player_Action_Func.DoPlayerOperateBoat;
        if (MyTypes.TEST(Sprites.SectorObject[pp.sop].flags, Gameutils.SOBJ_HAS_WEAPON)) {
            pp.Flags |= Gameutils.PF_WEAPON_DOWN;
        }
        Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Run);
    }

    public static void DoPlayerBeginOperateTank(PlayerStr pp) {
        USER u = Gameutils.pUser[pp.PlayerSprite];
        pp.floor_dist = PLAYER_RUN_FLOOR_DIST;
        pp.ceiling_dist = PLAYER_RUN_CEILING_DIST;
        pp.DoPlayerAction = Player_Action_Func.DoPlayerOperateTank;
        if (MyTypes.TEST(Sprites.SectorObject[pp.sop].flags, Gameutils.SOBJ_HAS_WEAPON)) {
            pp.Flags |= Gameutils.PF_WEAPON_DOWN;
        }
        Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Stand);
    }

    public static void DoPlayerBeginOperateTurret(PlayerStr pp) {
        USER u = Gameutils.pUser[pp.PlayerSprite];
        pp.floor_dist = PLAYER_RUN_FLOOR_DIST;
        pp.ceiling_dist = PLAYER_RUN_CEILING_DIST;
        pp.DoPlayerAction = Player_Action_Func.DoPlayerOperateTurret;
        if (MyTypes.TEST(Sprites.SectorObject[pp.sop].flags, Gameutils.SOBJ_HAS_WEAPON)) {
            pp.Flags |= Gameutils.PF_WEAPON_DOWN;
        }
        Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Stand);
    }

    public static void FindMainSector(int sopi) {
        Sector_Object sop = Sprites.SectorObject[sopi];
        if (sop.op_main_sector < 0) {
            int sx = sop.xmid;
            int sy = sop.ymid;
            Track.PlaceSectorObject(sopi, sop.ang, Integer.MAX_VALUE, Integer.MAX_VALUE);
            sop.op_main_sector = 0;
            sop.op_main_sector = Main.engine.updatesectorz(sx, sy, sop.zmid, sop.op_main_sector);
            Track.PlaceSectorObject(sopi, sop.ang, sx, sy);
        }
    }

    public static void DoPlayerOperateMatch(PlayerStr pp, boolean starting) {
        if (pp.sop == -1) {
            return;
        }
        Sector_Object sop = Sprites.SectorObject[pp.sop];
        short i = Engine.headspritesect[sop.mid_sector];
        while (i != -1) {
            short nexti = Engine.nextspritesect[i];
            SPRITE sp = Engine.sprite[i];
            if (sp.statnum == 500 && sp.hitag == 147) {
                if (starting) {
                    if (Gameutils.SP_TAG5(sp) == 0) break;
                    Sector.DoMatchEverything(pp, Gameutils.SP_TAG5(sp), -1);
                    break;
                }
                if (!Gameutils.TEST_BOOL2(sp) || Gameutils.SP_TAG5(sp) == 0) break;
                Sector.DoMatchEverything(pp, Gameutils.SP_TAG5(sp) + 1, -1);
                break;
            }
            i = nexti;
        }
    }

    public static void DoPlayerBeginOperate(PlayerStr pp) {
        int sopi = Track.PlayerOnObject(pp.cursectnum);
        if (sopi == -1) {
            Player.DoPlayerBeginRun(pp);
            return;
        }
        Sector_Object sop = Sprites.SectorObject[sopi];
        if (sop.controller != -1) {
            return;
        }
        if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_REMOTE_ONLY)) {
            return;
        }
        if (sop.max_damage != -9999 && sop.max_damage <= 0) {
            if (pp.InventoryAmount[1] != 0) {
                Inv.UseInventoryRepairKit(pp);
                sop.max_damage = Gameutils.pUser[sop.sp_child].MaxHealth;
                Track.VehicleSetSmoke(sop, null);
                sop.flags &= ~Gameutils.SOBJ_BROKEN;
            } else {
                Sound.PlayerSound(494, 9, pp);
                return;
            }
        }
        pp.sop = pp.sop_control = sopi;
        sop.controller = pp.PlayerSprite;
        pp.pang = sop.ang;
        pp.posx = sop.xmid;
        pp.posy = sop.ymid;
        pp.cursectnum = Rooms.COVERupdatesector(pp.posx, pp.posy, pp.cursectnum);
        Main.engine.getzsofslope(pp.cursectnum, pp.posx, pp.posy, Rooms.zofslope);
        int fz = Rooms.zofslope[1];
        pp.posz = fz - PLAYER_HEIGHT;
        pp.Flags &= ~(Gameutils.PF_CRAWLING | Gameutils.PF_JUMPING | Gameutils.PF_FALLING | Gameutils.PF_LOCK_CRAWL);
        Player.DoPlayerOperateMatch(pp, true);
        int i = 0;
        while (sop.sp_num[i] != -1) {
            if (Engine.sprite[sop.sp_num[i]].statnum == 55) {
                sop.flags |= Gameutils.SOBJ_HAS_WEAPON;
                break;
            }
            ++i;
        }
        Player.DoPlayerResetMovement(pp);
        switch (sop.track) {
            case 98: {
                if ((pp.input.vel | pp.input.svel) != 0) {
                    Player.PlaySOsound(sop.mid_sector, 2);
                } else {
                    Player.PlaySOsound(sop.mid_sector, 1);
                }
                pp.posz = fz - PLAYER_HEIGHT;
                Player.DoPlayerBeginOperateTank(pp);
                break;
            }
            case 96: 
            case 97: {
                if (pp.input.angvel != 0.0f) {
                    Player.PlaySOsound(sop.mid_sector, 2);
                } else {
                    Player.PlaySOsound(sop.mid_sector, 1);
                }
                pp.posz = fz - PLAYER_HEIGHT;
                Player.DoPlayerBeginOperateTurret(pp);
                break;
            }
            case 99: {
                if ((pp.input.vel | pp.input.svel) != 0) {
                    Player.PlaySOsound(sop.mid_sector, 2);
                } else {
                    Player.PlaySOsound(sop.mid_sector, 1);
                }
                pp.posz = fz - PLAYER_HEIGHT;
                Player.DoPlayerBeginOperateBoat(pp);
                break;
            }
            default: {
                return;
            }
        }
    }

    public static void DoPlayerBeginRemoteOperate(PlayerStr pp, int sopi) {
        Sector_Object sop = Sprites.SectorObject[sopi];
        pp.sop_remote = pp.sop_control = sopi;
        pp.sop = pp.sop_control;
        sop.controller = pp.PlayerSprite;
        if (sop.max_damage != -9999 && sop.max_damage <= 0) {
            if (pp.InventoryAmount[1] != 0) {
                Inv.UseInventoryRepairKit(pp);
                sop.max_damage = Gameutils.pUser[sop.sp_child].MaxHealth;
                Track.VehicleSetSmoke(sop, null);
                sop.flags &= ~Gameutils.SOBJ_BROKEN;
            } else {
                Sound.PlayerSound(494, 9, pp);
                return;
            }
        }
        short save_sectnum = pp.cursectnum;
        pp.pang = sop.ang;
        pp.posx = sop.xmid;
        pp.posy = sop.ymid;
        pp.cursectnum = Rooms.COVERupdatesector(pp.posx, pp.posy, pp.cursectnum);
        Main.engine.getzsofslope(pp.cursectnum, pp.posx, pp.posy, Rooms.zofslope);
        int fz = Rooms.zofslope[1];
        pp.posz = fz - PLAYER_HEIGHT;
        pp.Flags &= ~(Gameutils.PF_CRAWLING | Gameutils.PF_JUMPING | Gameutils.PF_FALLING | Gameutils.PF_LOCK_CRAWL);
        Player.DoPlayerOperateMatch(pp, true);
        int i = 0;
        while (sop.sp_num[i] != -1) {
            if (Engine.sprite[sop.sp_num[i]].statnum == 55) {
                sop.flags |= Gameutils.SOBJ_HAS_WEAPON;
                break;
            }
            ++i;
        }
        Player.DoPlayerResetMovement(pp);
        Player.PlayerToRemote(pp);
        Player.PlayerRemoteInit(pp);
        switch (sop.track) {
            case 98: {
                if ((pp.input.vel | pp.input.svel) != 0) {
                    Player.PlaySOsound(sop.mid_sector, 2);
                } else {
                    Player.PlaySOsound(sop.mid_sector, 1);
                }
                pp.posz = fz - PLAYER_HEIGHT;
                Player.DoPlayerBeginOperateTank(pp);
                break;
            }
            case 96: 
            case 97: {
                if (pp.input.angvel != 0.0f) {
                    Player.PlaySOsound(sop.mid_sector, 2);
                } else {
                    Player.PlaySOsound(sop.mid_sector, 1);
                }
                pp.posz = fz - PLAYER_HEIGHT;
                Player.DoPlayerBeginOperateTurret(pp);
                break;
            }
            case 99: {
                if ((pp.input.vel | pp.input.svel) != 0) {
                    Player.PlaySOsound(sop.mid_sector, 2);
                } else {
                    Player.PlaySOsound(sop.mid_sector, 1);
                }
                pp.posz = fz - PLAYER_HEIGHT;
                Player.DoPlayerBeginOperateBoat(pp);
                break;
            }
            default: {
                return;
            }
        }
        Player.PlayerRemoteReset(pp, save_sectnum);
    }

    public static void PlayerRemoteReset(PlayerStr pp, short sectnum) {
        if (!ru.m210projects.Build.Gameutils.isValidSector(sectnum)) {
            return;
        }
        pp.cursectnum = pp.lastcursectnum = sectnum;
        pp.posx = Engine.sprite[pp.remote_sprite].x;
        pp.posy = Engine.sprite[pp.remote_sprite].y;
        pp.posz = Engine.sector[sectnum].floorz - PLAYER_HEIGHT;
        pp.slide_yvect = 0;
        pp.slide_xvect = 0;
        pp.oyvect = 0;
        pp.oxvect = 0;
        pp.yvect = 0;
        pp.xvect = 0;
        Player.UpdatePlayerSprite(pp);
    }

    public static void PlayerRemoteInit(PlayerStr pp) {
        pp.remote.xvect = 0;
        pp.remote.yvect = 0;
        pp.remote.oxvect = 0;
        pp.remote.oyvect = 0;
        pp.remote.slide_xvect = 0;
        pp.remote.slide_yvect = 0;
    }

    public static void RemoteToPlayer(PlayerStr pp) {
        pp.cursectnum = pp.remote.cursectnum;
        pp.lastcursectnum = pp.remote.lastcursectnum;
        pp.posx = pp.remote.posx;
        pp.posy = pp.remote.posy;
        pp.posz = pp.remote.posz;
        pp.xvect = pp.remote.xvect;
        pp.yvect = pp.remote.yvect;
        pp.oxvect = pp.remote.oxvect;
        pp.oyvect = pp.remote.oyvect;
        pp.slide_xvect = pp.remote.slide_xvect;
        pp.slide_yvect = pp.remote.slide_yvect;
    }

    public static void PlayerToRemote(PlayerStr pp) {
        if (pp.remote == null) {
            pp.remote = new Remote_Control();
        }
        pp.remote.cursectnum = pp.cursectnum;
        pp.remote.lastcursectnum = pp.lastcursectnum;
        pp.remote.oposx = pp.remote.posx;
        pp.remote.oposy = pp.remote.posy;
        pp.remote.oposz = pp.remote.posz;
        pp.remote.posx = pp.posx;
        pp.remote.posy = pp.posy;
        pp.remote.posz = pp.posz;
        pp.remote.xvect = pp.xvect;
        pp.remote.yvect = pp.yvect;
        pp.remote.oxvect = pp.oxvect;
        pp.remote.oyvect = pp.oyvect;
        pp.remote.slide_xvect = pp.slide_xvect;
        pp.remote.slide_yvect = pp.slide_yvect;
    }

    public static void DoPlayerStopOperate(PlayerStr pp) {
        pp.Flags &= ~Gameutils.PF_WEAPON_DOWN;
        Player.DoPlayerResetMovement(pp);
        Player.DoTankTreads(pp);
        Player.DoPlayerOperateMatch(pp, false);
        Player.StopSOsound(Sprites.SectorObject[pp.sop].mid_sector);
        if (pp.sop_remote != -1) {
            pp.pang = Gameutils.TEST_BOOL1(Engine.sprite[pp.remote_sprite]) ? (pp.oang = (float)Engine.sprite[pp.remote_sprite].ang) : (pp.oang = (float)Main.engine.getangle(Sprites.SectorObject[pp.sop_remote].xmid - pp.posx, Sprites.SectorObject[pp.sop_remote].ymid - pp.posy));
        }
        if (pp.sop_control != -1) {
            Sprites.SectorObject[pp.sop_control].controller = -1;
        }
        pp.sop_control = -1;
        pp.sop_riding = -1;
        pp.sop_remote = -1;
        pp.sop = -1;
        Player.DoPlayerBeginRun(pp);
    }

    public static void DoPlayerOperateTurret(PlayerStr pp) {
        if (Gameutils.TEST_SYNC_KEY(pp, 18)) {
            if (Gameutils.FLAG_KEY_PRESSED(pp, 18)) {
                Gameutils.FLAG_KEY_RELEASE(pp, 18);
                Player.DoPlayerStopOperate(pp);
                return;
            }
        } else {
            Gameutils.FLAG_KEY_RESET(pp, 18);
        }
        Sector_Object sop = Sprites.SectorObject[pp.sop];
        if (sop.max_damage != -9999 && sop.max_damage <= 0) {
            Player.DoPlayerStopOperate(pp);
            return;
        }
        short save_sectnum = pp.cursectnum;
        if (pp.sop_remote != -1) {
            Player.RemoteToPlayer(pp);
        }
        Player.DoPlayerMoveTurret(pp);
        if (pp.sop_remote != -1) {
            Player.PlayerToRemote(pp);
            Player.PlayerRemoteReset(pp, save_sectnum);
        }
    }

    public static void DoPlayerOperateBoat(PlayerStr pp) {
        if (Gameutils.TEST_SYNC_KEY(pp, 18)) {
            if (Gameutils.FLAG_KEY_PRESSED(pp, 18)) {
                Gameutils.FLAG_KEY_RELEASE(pp, 18);
                Player.DoPlayerStopOperate(pp);
                return;
            }
        } else {
            Gameutils.FLAG_KEY_RESET(pp, 18);
        }
        Sector_Object sop = Sprites.SectorObject[pp.sop];
        if (sop.max_damage != -9999 && sop.max_damage <= 0) {
            Player.DoPlayerStopOperate(pp);
            return;
        }
        short save_sectnum = pp.cursectnum;
        if (pp.sop_remote != -1) {
            Player.RemoteToPlayer(pp);
        }
        Player.DoPlayerMoveBoat(pp);
        if (pp.sop_remote != -1) {
            Player.PlayerToRemote(pp);
            Player.PlayerRemoteReset(pp, save_sectnum);
        }
    }

    public static void DoPlayerOperateTank(PlayerStr pp) {
        if (Gameutils.TEST_SYNC_KEY(pp, 18)) {
            if (Gameutils.FLAG_KEY_PRESSED(pp, 18)) {
                Gameutils.FLAG_KEY_RELEASE(pp, 18);
                Player.DoPlayerStopOperate(pp);
                return;
            }
        } else {
            Gameutils.FLAG_KEY_RESET(pp, 18);
        }
        Sector_Object sop = Sprites.SectorObject[pp.sop];
        if (sop.max_damage != -9999 && sop.max_damage <= 0) {
            Player.DoPlayerStopOperate(pp);
            return;
        }
        short save_sectnum = pp.cursectnum;
        if (pp.sop_remote != -1) {
            Player.RemoteToPlayer(pp);
        }
        Player.DoPlayerMoveTank(pp);
        if (pp.sop_remote != -1) {
            Player.PlayerToRemote(pp);
            Player.PlayerRemoteReset(pp, save_sectnum);
        }
    }

    public static void DoPlayerDeathJump(PlayerStr pp) {
        int i = 0;
        while (i < 3) {
            if ((pp.jump_speed += 8) > 0) {
                pp.Flags &= ~Gameutils.PF_JUMPING;
                pp.Flags |= Gameutils.PF_FALLING;
                Player.DoPlayerDeathFall(pp);
                return;
            }
            pp.posz += pp.jump_speed;
            if (Player.PlayerCeilingHit(pp, pp.hiz + Gameutils.Z(4))) {
                pp.posz = pp.hiz + Gameutils.Z(4);
                pp.jump_speed = -pp.jump_speed;
                pp.Flags &= ~Gameutils.PF_JUMPING;
                pp.Flags |= Gameutils.PF_FALLING;
                Player.DoPlayerDeathFall(pp);
                return;
            }
            i = (short)(i + 1);
        }
    }

    public static void DoPlayerDeathFall(PlayerStr pp) {
        int i = 0;
        while (i < 3) {
            pp.jump_speed += 8;
            pp.posz += pp.jump_speed;
            int loz = pp.lo_sectp != -1 && MyTypes.TEST(Engine.sector[pp.lo_sectp].extra, Gameutils.SECTFX_SINK) ? Engine.sector[pp.lo_sectp].floorz : pp.loz;
            if (Player.PlayerFloorHit(pp, loz - PLAYER_DEATH_HEIGHT)) {
                if (loz != pp.loz) {
                    Weapon.SpawnSplash(pp.PlayerSprite);
                }
                if (Gameutils.RANDOM_RANGE(1000) > 500) {
                    Sound.PlaySound(56, pp, 8);
                } else {
                    Sound.PlaySound(410, pp, 8);
                }
                pp.posz = loz - PLAYER_DEATH_HEIGHT;
                pp.Flags &= ~Gameutils.PF_FALLING;
            }
            i = (short)(i + 1);
        }
    }

    public static final String KilledPlayerMessage(PlayerStr pp, PlayerStr killer) {
        int rnd = Gameutils.STD_RANDOM_RANGE(16);
        String p1 = pp.getName();
        String p2 = killer.getName();
        if (pp.HitBy == killer.PlayerSprite) {
            return String.valueOf(p1) + " was killed by " + p2 + ".";
        }
        switch (rnd) {
            case 0: {
                return String.valueOf(p1) + " was wasted by " + p2 + "'s " + Weapon.DeathString(pp.HitBy) + ".";
            }
            case 1: {
                return String.valueOf(p1) + " got his ass kicked by " + p2 + "'s " + Weapon.DeathString(pp.HitBy) + ".";
            }
            case 2: {
                return String.valueOf(p1) + " bows down before the mighty power of " + p2 + ".";
            }
            case 3: {
                return String.valueOf(p1) + " was killed by " + p2 + "'s " + Weapon.DeathString(pp.HitBy) + ".";
            }
            case 4: {
                return String.valueOf(p1) + " got slapped down hard by " + p2 + "'s " + Weapon.DeathString(pp.HitBy) + ".";
            }
            case 5: {
                return String.valueOf(p1) + " got on his knees before " + p2 + ".";
            }
            case 6: {
                return String.valueOf(p1) + " was totally out classed by " + p2 + "'s " + Weapon.DeathString(pp.HitBy) + ".";
            }
            case 7: {
                return String.valueOf(p1) + " got chewed apart by " + p2 + "'s " + Weapon.DeathString(pp.HitBy) + ".";
            }
            case 8: {
                return String.valueOf(p1) + " was retired by " + p2 + "'s " + Weapon.DeathString(pp.HitBy) + ".";
            }
            case 9: {
                return String.valueOf(p1) + " was greased by " + p2 + "'s " + Weapon.DeathString(pp.HitBy) + ".";
            }
            case 10: {
                return String.valueOf(p1) + " was humbled lower than dirt by " + p2 + ".";
            }
            case 11: {
                return String.valueOf(p2) + " beats " + p1 + " like a red headed step child.";
            }
            case 12: {
                return String.valueOf(p1) + " begs for mercy as " + p2 + " terminates him with extreme prejudice.";
            }
            case 13: {
                return String.valueOf(p1) + " falls before the superior skills of " + p2 + ".";
            }
            case 14: {
                return String.valueOf(p2) + " gives " + p1 + " a beating he'll never forget.";
            }
            case 15: {
                return String.valueOf(p2) + " puts the Smack Dab on " + p1 + " with his " + Weapon.DeathString(pp.HitBy);
            }
        }
        return null;
    }

    public static void DoPlayerDeathMessage(int pp, int nkiller) {
        boolean SEND_OK = false;
        String ds = null;
        PlayerStr killer = Game.Player[nkiller];
        int n = pp;
        killer.KilledPlayer[n] = (short)(killer.KilledPlayer[n] + 1);
        if (Game.Player[pp] == killer && pp == Mmulti.myconnectindex) {
            ds = String.valueOf(Game.Player[pp].getName()) + " " + SuicideNote[Gameutils.STD_RANDOM_RANGE(11)];
            SEND_OK = true;
        } else if (killer == Game.Player[Mmulti.myconnectindex]) {
            ds = Player.KilledPlayerMessage(Game.Player[pp], killer);
            SEND_OK = true;
        }
        if (SEND_OK) {
            Main.gNet.SendMessage(-1, ds);
            JPlayer.adduserquote(ds);
        }
    }

    public static void DoPlayerBeginDie(int ppnum) {
        int choosesnd = 0;
        PlayerStr pp = Game.Player[ppnum];
        USER u = Gameutils.pUser[pp.PlayerSprite];
        if (WangNetwork.Prediction) {
            return;
        }
        if (Game.GodMode) {
            return;
        }
        if (pp.PlayerTalking) {
            if (pp.TalkVocHandle.isActive()) {
                pp.TalkVocHandle.stop();
            }
            pp.PlayerTalking = false;
            pp.TalkVocnum = -1;
            pp.TalkVocHandle = null;
        }
        choosesnd = Gameutils.RANDOM_RANGE(5);
        Sound.PlayerSound(Sound.PlayerLowHealthPainVocs[choosesnd], 13, pp);
        if (Main.game.nNetMode == BuildGame.NetMode.Single && Mmulti.numplayers <= 1 && LoadSave.lastload != null && !LoadSave.lastload.isEmpty() && BuildGdx.compat.checkFile(LoadSave.lastload, Compat.Path.User) != null) {
            Main.game.menu.mOpen(Main.game.menu.mMenus[16], -1);
        } else {
            short bak = Text.GlobInfoStringTime;
            Text.GlobInfoStringTime = (short)999;
            Text.PutStringInfo(pp, "Press \"USE\" or SPACE to restart");
            Text.GlobInfoStringTime = bak;
        }
        if (pp.sop_control != -1) {
            Player.DoPlayerStopOperate(pp);
        }
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_DIVING)) {
            pp.DeathType = (short)5;
        }
        pp.Flags &= ~(Gameutils.PF_JUMPING | Gameutils.PF_FALLING | Gameutils.PF_DIVING | Gameutils.PF_FLYING | Gameutils.PF_CLIMBING | Gameutils.PF_CRAWLING | Gameutils.PF_LOCK_CRAWL);
        pp.tilt_dest = 0;
        Sprites.ActorCoughItem(pp.PlayerSprite);
        if (Mmulti.numplayers > 1 || Main.gNet.FakeMultiplayer) {
            if (pp.Killer >= 0) {
                USER ku = Gameutils.pUser[pp.Killer];
                if (ku != null && ku.PlayerP != -1) {
                    if (pp.pnum == ku.PlayerP) {
                        Panel.PlayerUpdateKills(ppnum, -1);
                        Player.DoPlayerDeathMessage(ppnum, ppnum);
                    } else if (Main.gNet.TeamPlay) {
                        if (Gameutils.pUser[pp.PlayerSprite].spal == ku.spal) {
                            Panel.PlayerUpdateKills(ppnum, -1);
                            Player.DoPlayerDeathMessage(ppnum, ku.PlayerP);
                        } else {
                            Panel.PlayerUpdateKills(ku.PlayerP, 1);
                            Player.DoPlayerDeathMessage(ppnum, ku.PlayerP);
                        }
                    } else {
                        Panel.PlayerUpdateKills(ku.PlayerP, 1);
                        Player.DoPlayerDeathMessage(ppnum, ku.PlayerP);
                    }
                }
            } else {
                Panel.PlayerUpdateKills(ppnum, -1);
                Player.DoPlayerDeathMessage(ppnum, ppnum);
            }
        }
        Inv.KillInventoryBar(pp);
        pp.Flags |= Gameutils.PF_LOCK_HORIZ;
        pp.friction = 50000;
        pp.slide_yvect = 0;
        pp.slide_xvect = 0;
        pp.floor_dist = PLAYER_WADE_FLOOR_DIST;
        pp.ceiling_dist = PLAYER_WADE_CEILING_DIST;
        pp.DoPlayerAction = PlayerDeathFunc[pp.DeathType];
        pp.sop_control = -1;
        pp.sop_remote = -1;
        pp.sop_riding = -1;
        pp.sop = -1;
        pp.Flags &= ~Gameutils.PF_TWO_UZI;
        Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Run);
        Panel.pWeaponForceRest(pp);
        if (pp.Chops != null) {
            Chops.ChopsSetRetract(pp);
        }
        SPRITE psp = pp.getSprite();
        switch (pp.DeathType) {
            case 5: {
                pp.Flags |= Gameutils.PF_JUMPING;
                u.ID = (short)4227;
                pp.jump_speed = -200;
                Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerDeath);
                Weapon.DoFindGround(pp.PlayerSprite);
                Actor.DoBeginJump(pp.PlayerSprite);
                u.jump_speed = (short)-300;
                break;
            }
            case 0: 
            case 3: {
                pp.Flags |= Gameutils.PF_JUMPING;
                u.ID = (short)4227;
                pp.jump_speed = -300;
                Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerDeath);
                psp.cstat = (short)(psp.cstat & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
                u.ceiling_dist = (short)Gameutils.Z(10);
                u.floor_dist = (short)Gameutils.Z(0);
                Weapon.DoFindGround(pp.PlayerSprite);
                Actor.DoBeginJump(pp.PlayerSprite);
                u.jump_speed = (short)-400;
                break;
            }
            case 1: {
                Sound.PlaySound(58, pp, 8);
                pp.Flags |= Gameutils.PF_DEAD_HEAD | Gameutils.PF_JUMPING;
                pp.jump_speed = -300;
                u.slide_vel = 0;
                Shrap.SpawnShrap(pp.PlayerSprite, -1);
                psp.cstat = (short)(psp.cstat | Gameutils.CSTAT_SPRITE_YCENTER);
                Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerHeadFly);
                u.ID = (short)1142;
                psp.xrepeat = (short)48;
                psp.yrepeat = (short)48;
                JWeapon.InitBloodSpray(pp.PlayerSprite, true, 105);
                break;
            }
            case 2: {
                Sound.PlaySound(58, pp, 8);
                pp.Flags |= Gameutils.PF_DEAD_HEAD | Gameutils.PF_JUMPING;
                pp.jump_speed = -650;
                Shrap.SpawnShrap(pp.PlayerSprite, -1);
                psp.cstat = (short)(psp.cstat | Gameutils.CSTAT_SPRITE_YCENTER);
                Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerHeadFly);
                u.ID = (short)1142;
                psp.xrepeat = (short)48;
                psp.yrepeat = (short)48;
                JWeapon.InitBloodSpray(pp.PlayerSprite, true, -1);
                JWeapon.InitBloodSpray(pp.PlayerSprite, true, -1);
                JWeapon.InitBloodSpray(pp.PlayerSprite, true, -1);
                break;
            }
            case 4: {
                Sound.PlaySound(61, pp, 8);
                pp.Flags |= Gameutils.PF_DEAD_HEAD | Gameutils.PF_JUMPING;
                pp.jump_speed = 200;
                u.slide_vel = 800;
                Shrap.SpawnShrap(pp.PlayerSprite, -1);
                psp.cstat = (short)(psp.cstat | Gameutils.CSTAT_SPRITE_YCENTER);
                Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerHeadFly);
                u.ID = (short)1142;
                psp.xrepeat = (short)48;
                psp.yrepeat = (short)48;
                JWeapon.InitBloodSpray(pp.PlayerSprite, true, 105);
                break;
            }
        }
        pp.Flags |= Gameutils.PF_DEAD;
        u.Flags &= ~Gameutils.SPR_BOUNCE;
        pp.Flags &= ~Gameutils.PF_HEAD_CONTROL;
    }

    public static boolean DoPlayerDeathHoriz(PlayerStr pp, int target, int speed) {
        if (pp.horiz > (float)target) {
            pp.horiz -= (float)speed;
            if (pp.horiz <= (float)target) {
                pp.horiz = target;
            }
        }
        if (pp.horiz < (float)target) {
            pp.horiz += (float)speed;
            if (pp.horiz >= (float)target) {
                pp.horiz = target;
            }
        }
        return pp.horiz == (float)target;
    }

    public static boolean DoPlayerDeathTilt(PlayerStr pp, int target, int speed) {
        if (pp.tilt > target) {
            pp.tilt -= speed;
            if (pp.tilt <= target) {
                pp.tilt = target;
            }
        }
        if (pp.tilt < target) {
            pp.tilt += speed;
            if (pp.tilt >= target) {
                pp.tilt = target;
            }
        }
        return pp.tilt == target;
    }

    public static void DoPlayerDeathZrange(PlayerStr pp) {
        USER u = Gameutils.pUser[pp.PlayerSprite];
        Weapon.DoFindGround(pp.PlayerSprite);
        pp.loz = u.loz;
        pp.lo_sp = u.lo_sp;
        pp.lo_sectp = u.lo_sectp;
    }

    public static void DoPlayerDeathHurl(PlayerStr pp) {
        if ((Mmulti.numplayers > 1 || Main.gNet.FakeMultiplayer) && Gameutils.TEST_SYNC_KEY(pp, 17) && Gameutils.FLAG_KEY_PRESSED(pp, 17)) {
            pp.Flags |= Gameutils.PF_HEAD_CONTROL;
            Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerHeadHurl);
            if (Sprites.MoveSkip4 == 0) {
                Shrap.SpawnShrap(pp.PlayerSprite, -1);
                if (Gameutils.RANDOM_RANGE(1000) > 400) {
                    Sound.PlayerSound(48, 9, pp);
                }
            }
            return;
        }
        if (!MyTypes.TEST(pp.Flags, Gameutils.PF_JUMPING | Gameutils.PF_FALLING)) {
            Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerHead);
        }
    }

    public static void DoPlayerDeathFollowKiller(PlayerStr pp) {
        SPRITE kp;
        Player.DoPlayerDeathHoriz(pp, 165, 4);
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD_HEAD) && pp.input.angvel != 0.0f || MyTypes.TEST(pp.Flags, Gameutils.PF_HEAD_CONTROL)) {
            Player.PLAYER_RUN_LOCK(pp);
            Player.DoPlayerTurn(pp);
            return;
        }
        if (pp.Killer > -1 && Rooms.FAFcansee(kp.x, kp.y, Gameutils.SPRITEp_TOS(kp = Engine.sprite[pp.Killer]), kp.sectnum, pp.posx, pp.posy, pp.posz, pp.cursectnum)) {
            short ang2 = Main.engine.getangle(kp.x - pp.posx, kp.y - pp.posy);
            short delta_ang = Player.GetDeltaAngle(ang2, pp.getAnglei());
            pp.pang += (float)(delta_ang >> 4);
            pp.pang = ru.m210projects.Build.Gameutils.BClampAngle(pp.pang);
        }
    }

    public static void DoPlayerDeathRestart(PlayerStr pp) {
        SPRITE sp = pp.getSprite();
        USER u = Gameutils.pUser[pp.PlayerSprite];
        if (Player.PlayerFloorHit(pp, pp.loz - PLAYER_HEIGHT)) {
            if (pp.DeathType == 0 || pp.DeathType == 3) {
                Weapon.QueueLoWangs(pp.PlayerSprite);
            }
        } else {
            JWeapon.InitBloodSpray(pp.PlayerSprite, true, -1);
            JWeapon.InitBloodSpray(pp.PlayerSprite, true, -1);
            JWeapon.InitBloodSpray(pp.PlayerSprite, true, -1);
        }
        Text.pClearTextLine(pp, Text.TEXT_INFO_LINE(0));
        Player.PlayerSpawnPosition(pp.pnum);
        Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Stand);
        sp.picnum = u.State.Pic;
        sp.yrepeat = (short)47;
        sp.xrepeat = (short)47;
        sp.cstat = (short)(sp.cstat & ~Gameutils.CSTAT_SPRITE_YCENTER);
        sp.x = pp.posx;
        sp.y = pp.posy;
        sp.z = pp.posz + PLAYER_HEIGHT;
        sp.ang = pp.getAnglei();
        Player.DoSpawnTeleporterEffect(sp);
        Sound.PlaySound(207, pp, 0);
        Player.DoPlayerZrange(pp);
        pp.sop_control = -1;
        pp.sop_remote = -1;
        pp.sop_riding = -1;
        pp.sop = -1;
        pp.Flags &= ~(Gameutils.PF_WEAPON_DOWN | Gameutils.PF_WEAPON_RETRACT);
        pp.Flags &= ~Gameutils.PF_DEAD;
        pp.Flags &= ~Gameutils.PF_LOCK_HORIZ;
        sp.cstat = (short)(sp.cstat & ~Gameutils.CSTAT_SPRITE_YCENTER);
        sp.cstat = (short)(sp.cstat | (Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        sp.xrepeat = (short)47;
        sp.yrepeat = (short)33;
        pp.horizbase = 100.0f;
        pp.horiz = 100.0f;
        Player.DoPlayerResetMovement(pp);
        u.ID = (short)4096;
        Ninja.PlayerDeathReset(pp);
        if (pp == Game.Player[Game.screenpeek]) {
            Palette.ResetPalette(pp, 256);
        }
        pp.NightVision = false;
        pp.FadeAmt = 0;
        Palette.DoPlayerDivePalette(pp);
        Palette.DoPlayerNightVisionPalette(pp);
        if (Mmulti.numplayers > 1 || Main.gNet.FakeMultiplayer) {
            Player.DoPlayerBeginRun(pp);
        } else if (Game.DemoPlaying) {
            if (Game.rec != null) {
                Game.rec.close();
            }
        } else {
            Game.ExitLevel = true;
        }
        Player.DoPlayerFireOutDeath(pp);
    }

    private static void DoPlayerDeathCheckKeys(PlayerStr pp) {
        if (Gameutils.TEST_SYNC_KEY(pp, 31)) {
            Player.DoPlayerDeathRestart(pp);
        }
    }

    public static void DoPlayerHeadDebris(PlayerStr pp) {
        if (!ru.m210projects.Build.Gameutils.isValidSector(pp.cursectnum)) {
            return;
        }
        SECTOR sectp = Engine.sector[pp.cursectnum];
        if (MyTypes.TEST(sectp.extra, Gameutils.SECTFX_SINK)) {
            Player.DoPlayerSpriteBob(pp, Gameutils.Z(8), Gameutils.Z(4), 3);
        } else {
            pp.bob_amt = 0;
        }
    }

    public static SPRITE DoPlayerDeathCheckKick(PlayerStr pp) {
        SPRITE sp = pp.getSprite();
        USER u = Gameutils.pUser[pp.PlayerSprite];
        int stat = 0;
        while (stat < Weapon.StatDamageList.length) {
            short i = Engine.headspritestat[Weapon.StatDamageList[stat]];
            while (i != -1) {
                short nexti = Engine.nextspritestat[i];
                SPRITE hp = Engine.sprite[i];
                USER hu = Gameutils.pUser[i];
                if (i == pp.PlayerSprite) break;
                if (MyTypes.TEST(hp.extra, Gameutils.SPRX_PLAYER_OR_ENEMY) && Gameutils.DISTANCE(hp.x, hp.y, sp.x, sp.y) < hu.Radius + 100) {
                    pp.Killer = i;
                    u.slide_ang = Main.engine.getangle(sp.x - hp.x, sp.y - hp.y);
                    u.slide_ang = Gameutils.NORM_ANGLE(u.slide_ang + (Gameutils.RANDOM_P2(4096) >> 5) - 64);
                    u.slide_vel = hp.xvel << 1;
                    u.Flags &= ~Gameutils.SPR_BOUNCE;
                    pp.jump_speed = -500;
                    Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerHeadFly);
                    pp.Flags |= Gameutils.PF_JUMPING;
                    Shrap.SpawnShrap(pp.PlayerSprite, -1);
                    return hp;
                }
                i = nexti;
            }
            stat = (short)(stat + 1);
        }
        Player.DoPlayerZrange(pp);
        if (Pragmas.klabs(pp.loz - pp.hiz) < Gameutils.SPRITEp_SIZE_Z(sp) - Gameutils.Z(8)) {
            u.slide_ang = (short)Gameutils.RANDOM_P2(2048);
            u.slide_vel = 1000;
            u.Flags &= ~Gameutils.SPR_BOUNCE;
            pp.jump_speed = -100;
            Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerHeadFly);
            pp.Flags |= Gameutils.PF_JUMPING;
            Shrap.SpawnShrap(pp.PlayerSprite, -1);
            return null;
        }
        return null;
    }

    public static void DoPlayerDeathMoveHead(PlayerStr pp) {
        int day;
        SPRITE sp = pp.getSprite();
        USER u = Gameutils.pUser[pp.PlayerSprite];
        int dax = Gameutils.MOVEx(u.slide_vel, u.slide_ang);
        u.ret = Sprites.move_sprite(pp.PlayerSprite, dax, day = Gameutils.MOVEy(u.slide_vel, u.slide_ang), 0, Gameutils.Z(16), Gameutils.Z(16), 1, 3);
        if (u.ret != 0) {
            switch (MyTypes.DTEST(u.ret, 57344)) {
                case 49152: {
                    int hitsprite = -2;
                    hitsprite = Gameutils.NORM_SPRITE(u.ret);
                    SPRITE hsp = Engine.sprite[hitsprite];
                    if (!MyTypes.TEST(hsp.cstat, Gameutils.CSTAT_SPRITE_WALL)) break;
                    short wall_ang = Gameutils.NORM_ANGLE(hsp.ang);
                    short dang = Player.GetDeltaAngle(u.slide_ang, wall_ang);
                    u.slide_ang = Gameutils.NORM_ANGLE(wall_ang + 1024 - dang);
                    Shrap.SpawnShrap(pp.PlayerSprite, -1);
                    break;
                }
                case 32768: {
                    short hitwall;
                    short w = hitwall = Gameutils.NORM_WALL(u.ret);
                    short nw = Engine.wall[w].point2;
                    short wall_ang = Gameutils.NORM_ANGLE(Main.engine.getangle(Engine.wall[nw].x - Engine.wall[w].x, Engine.wall[nw].y - Engine.wall[w].y) - 512);
                    short dang = Player.GetDeltaAngle(u.slide_ang, wall_ang);
                    u.slide_ang = Gameutils.NORM_ANGLE(wall_ang + 1024 - dang);
                    Shrap.SpawnShrap(pp.PlayerSprite, -1);
                }
            }
        }
        pp.posx = sp.x;
        pp.posy = sp.y;
        short sectnum = pp.cursectnum = sp.sectnum;
        if ((sectnum = Rooms.COVERupdatesector(pp.posx, pp.posy, sectnum)) < 0) {
            pp.cursectnum = pp.lv_sectnum;
            Main.engine.changespritesect(pp.PlayerSprite, pp.lv_sectnum);
            pp.posx = sp.x = pp.lv_x;
            pp.posy = sp.y = pp.lv_y;
        } else {
            pp.lv_sectnum = sectnum;
            pp.lv_x = pp.posx;
            pp.lv_y = pp.posy;
        }
    }

    public static void DoPlayerDeathFlip(PlayerStr pp) {
        if (WangNetwork.Prediction) {
            return;
        }
        Player.DoPlayerDeathZrange(pp);
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_JUMPING | Gameutils.PF_FALLING)) {
            if (MyTypes.TEST(pp.Flags, Gameutils.PF_JUMPING)) {
                Player.DoPlayerDeathJump(pp);
                Player.DoPlayerDeathHoriz(pp, 165, 2);
                if (!Sprites.MoveSkip2) {
                    Actor.DoJump(pp.PlayerSprite);
                }
            }
            if (MyTypes.TEST(pp.Flags, Gameutils.PF_FALLING)) {
                Player.DoPlayerDeathFall(pp);
                Player.DoPlayerDeathHoriz(pp, 165, 4);
                if (!Sprites.MoveSkip2) {
                    Actor.DoFall(pp.PlayerSprite);
                }
            }
        } else {
            Player.DoPlayerDeathFollowKiller(pp);
        }
        Player.DoPlayerDeathCheckKeys(pp);
    }

    public static void DoPlayerDeathDrown(PlayerStr pp) {
        SPRITE sp = pp.getSprite();
        if (WangNetwork.Prediction) {
            return;
        }
        Player.DoPlayerDeathZrange(pp);
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_JUMPING | Gameutils.PF_FALLING)) {
            if (MyTypes.TEST(pp.Flags, Gameutils.PF_JUMPING)) {
                Player.DoPlayerDeathJump(pp);
                Player.DoPlayerDeathHoriz(pp, 165, 2);
                if (!Sprites.MoveSkip2) {
                    Actor.DoJump(pp.PlayerSprite);
                }
            }
            if (MyTypes.TEST(pp.Flags, Gameutils.PF_FALLING)) {
                pp.posz += Gameutils.Z(2);
                if (!Sprites.MoveSkip2) {
                    sp.z += Gameutils.Z(4);
                }
                if (pp.posz > pp.loz - PLAYER_DEATH_HEIGHT) {
                    pp.posz = pp.loz - PLAYER_DEATH_HEIGHT;
                    pp.Flags &= ~Gameutils.PF_FALLING;
                }
            }
        }
        Player.DoPlayerDeathFollowKiller(pp);
        Player.DoPlayerDeathCheckKeys(pp);
    }

    public static void DoPlayerDeathBounce(PlayerStr pp) {
        SPRITE sp = pp.getSprite();
        USER u = Gameutils.pUser[pp.PlayerSprite];
        if (WangNetwork.Prediction) {
            return;
        }
        if (pp.lo_sectp != -1 && MyTypes.TEST(Engine.sector[pp.lo_sectp].extra, Gameutils.SECTFX_SINK)) {
            sp.cstat = (short)(sp.cstat & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
            Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerHead);
            u.slide_vel = 0;
            u.Flags |= Gameutils.SPR_BOUNCE;
            return;
        }
        u.Flags |= Gameutils.SPR_BOUNCE;
        pp.jump_speed = -300;
        u.slide_vel >>= 2;
        u.slide_ang = Gameutils.NORM_ANGLE((Gameutils.RANDOM_P2(16384) >> 8) - 32);
        pp.Flags |= Gameutils.PF_JUMPING;
        Shrap.SpawnShrap(pp.PlayerSprite, -1);
    }

    public static void DoPlayerDeathCrumble(PlayerStr pp) {
        SPRITE sp = pp.getSprite();
        USER u = Gameutils.pUser[pp.PlayerSprite];
        if (WangNetwork.Prediction) {
            return;
        }
        Player.DoPlayerDeathZrange(pp);
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_JUMPING | Gameutils.PF_FALLING)) {
            if (MyTypes.TEST(pp.Flags, Gameutils.PF_JUMPING)) {
                Player.DoPlayerDeathJump(pp);
                Player.DoPlayerDeathHoriz(pp, 150, 4);
            }
            if (MyTypes.TEST(pp.Flags, Gameutils.PF_FALLING)) {
                Player.DoPlayerDeathFall(pp);
                Player.DoPlayerDeathHoriz(pp, 50, 3);
            }
            if (!MyTypes.TEST(pp.Flags, Gameutils.PF_JUMPING | Gameutils.PF_FALLING)) {
                if (!MyTypes.TEST(u.Flags, Gameutils.SPR_BOUNCE)) {
                    Player.DoPlayerDeathBounce(pp);
                    return;
                }
                sp.cstat = (short)(sp.cstat & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
                Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerHead);
            } else {
                Player.DoPlayerDeathMoveHead(pp);
            }
        } else {
            Player.DoPlayerDeathCheckKick(pp);
            Player.DoPlayerDeathHurl(pp);
            Player.DoPlayerDeathFollowKiller(pp);
        }
        Player.DoPlayerDeathCheckKeys(pp);
        sp.z = pp.posz + PLAYER_DEAD_HEAD_FLOORZ_OFFSET;
        Player.DoPlayerHeadDebris(pp);
    }

    public static void DoPlayerDeathExplode(PlayerStr pp) {
        SPRITE sp = pp.getSprite();
        USER u = Gameutils.pUser[pp.PlayerSprite];
        if (WangNetwork.Prediction) {
            return;
        }
        Player.DoPlayerDeathZrange(pp);
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_JUMPING | Gameutils.PF_FALLING)) {
            if (MyTypes.TEST(pp.Flags, Gameutils.PF_JUMPING)) {
                Player.DoPlayerDeathJump(pp);
                Player.DoPlayerDeathHoriz(pp, 150, 4);
            }
            if (MyTypes.TEST(pp.Flags, Gameutils.PF_FALLING)) {
                Player.DoPlayerDeathFall(pp);
                Player.DoPlayerDeathHoriz(pp, 150, 3);
            }
            if (!MyTypes.TEST(pp.Flags, Gameutils.PF_JUMPING | Gameutils.PF_FALLING)) {
                if (!MyTypes.TEST(u.Flags, Gameutils.SPR_BOUNCE)) {
                    Player.DoPlayerDeathBounce(pp);
                    return;
                }
                sp.cstat = (short)(sp.cstat & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
                Sprites.NewStateGroup(pp.PlayerSprite, PlayerStateGroup.sg_PlayerHead);
            } else {
                Player.DoPlayerDeathMoveHead(pp);
            }
        } else {
            Player.DoPlayerDeathCheckKick(pp);
            Player.DoPlayerDeathHurl(pp);
            Player.DoPlayerDeathFollowKiller(pp);
        }
        Player.DoPlayerDeathCheckKeys(pp);
        sp.z = pp.posz + PLAYER_DEAD_HEAD_FLOORZ_OFFSET;
        Player.DoPlayerHeadDebris(pp);
    }

    public static void DoPlayerBeginRun(PlayerStr pp) {
        USER u = Gameutils.pUser[pp.PlayerSprite];
        if (Player.DoPlayerTestCrawl(pp)) {
            Player.DoPlayerBeginCrawl(pp);
            return;
        }
        pp.Flags &= ~(Gameutils.PF_CRAWLING | Gameutils.PF_JUMPING | Gameutils.PF_FALLING | Gameutils.PF_LOCK_CRAWL | Gameutils.PF_CLIMBING);
        if (pp.WadeDepth != 0) {
            Player.DoPlayerBeginWade(pp);
            return;
        }
        pp.friction = 50000;
        pp.floor_dist = PLAYER_RUN_FLOOR_DIST;
        pp.ceiling_dist = PLAYER_RUN_CEILING_DIST;
        pp.DoPlayerAction = Player_Action_Func.DoPlayerRun;
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_PLAYER_MOVED)) {
            Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Run);
        } else {
            Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Stand);
        }
    }

    public static void DoPlayerRun(PlayerStr pp) {
        USER u = Gameutils.pUser[pp.PlayerSprite];
        if (Gameutils.SectorIsUnderwaterArea(pp.cursectnum)) {
            Player.DoPlayerBeginDiveNoWarp(pp);
            return;
        }
        if (Player.DoPlayerTestCrawl(pp)) {
            Player.DoPlayerBeginCrawl(pp);
            return;
        }
        if (Gameutils.TEST_SYNC_KEY(pp, 20)) {
            Player.DoPlayerBeginCrawl(pp);
            return;
        }
        if (Gameutils.TEST_SYNC_KEY(pp, 19)) {
            if (Gameutils.FLAG_KEY_PRESSED(pp, 19)) {
                Gameutils.FLAG_KEY_RELEASE(pp, 19);
                pp.posz = pp.loz - PLAYER_HEIGHT;
                Player.DoPlayerBeginJump(pp);
                return;
            }
        } else {
            Gameutils.FLAG_KEY_RESET(pp, 19);
        }
        if (Gameutils.TEST_SYNC_KEY(pp, 14)) {
            if (Gameutils.FLAG_KEY_PRESSED(pp, 14)) {
                Gameutils.FLAG_KEY_RELEASE(pp, 14);
                pp.Flags |= Gameutils.PF_LOCK_CRAWL;
                Player.DoPlayerBeginCrawl(pp);
                return;
            }
        } else {
            Gameutils.FLAG_KEY_RESET(pp, 14);
        }
        if (Player.PlayerFlyKey(pp)) {
            Player.DoPlayerBeginFly(pp);
            return;
        }
        if (!MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD) && !WangNetwork.Prediction) {
            if (Gameutils.TEST_SYNC_KEY(pp, 18)) {
                if (Gameutils.FLAG_KEY_PRESSED(pp, 18)) {
                    int sp;
                    if (MyTypes.TEST(Engine.sector[pp.cursectnum].extra, Gameutils.SECTFX_OPERATIONAL)) {
                        Gameutils.FLAG_KEY_RELEASE(pp, 18);
                        Player.DoPlayerBeginOperate(pp);
                        return;
                    }
                    if (MyTypes.TEST(Engine.sector[pp.cursectnum].extra, Gameutils.SECTFX_TRIGGER) && (sp = Player.FindNearSprite(pp.getSprite(), 58)) != -1 && Gameutils.SP_TAG5(Engine.sprite[sp]) == 0) {
                        pp.remote_sprite = sp;
                        Gameutils.FLAG_KEY_RELEASE(pp, 18);
                        Player.DoPlayerBeginRemoteOperate(pp, Gameutils.SP_TAG7(Engine.sprite[pp.remote_sprite]));
                        return;
                    }
                }
            } else {
                Gameutils.FLAG_KEY_RESET(pp, 18);
            }
        }
        Player.DoPlayerBob(pp);
        if (pp.WadeDepth != 0) {
            Player.DoPlayerBeginWade(pp);
            return;
        }
        if (Player.PlayerOnLadder(pp)) {
            Player.DoPlayerBeginClimb(pp);
            return;
        }
        Player.DoPlayerMove(pp);
        if (u.Rot != PlayerStateGroup.sg_PlayerNinjaSword && u.Rot != PlayerStateGroup.sg_PlayerNinjaPunch) {
            if (MyTypes.TEST(pp.Flags, Gameutils.PF_PLAYER_MOVED)) {
                if (u.Rot != u.ActorActionSet.Run) {
                    Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Run);
                }
            } else if (u.Rot != u.ActorActionSet.Stand) {
                Sprites.NewStateGroup(pp.PlayerSprite, u.ActorActionSet.Stand);
            }
        }
        if (Player.PlayerFallTest(pp, PLAYER_HEIGHT)) {
            pp.jump_speed = Gameutils.Z(1);
            Player.DoPlayerBeginFall(pp);
            Player.DoPlayerFall(pp);
            return;
        }
        if (ru.m210projects.Build.Gameutils.isValidSector(pp.cursectnum) && MyTypes.TEST(Engine.sector[pp.cursectnum].extra, Gameutils.SECTFX_DYNAMIC_AREA)) {
            pp.posz = pp.loz - PLAYER_HEIGHT;
        }
        Player.DoPlayerHeight(pp);
    }

    public static void PlayerStateControl(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        u.Tics += 3;
        while (u.Tics >= MyTypes.DTEST(u.State.Tics, 65535)) {
            u.Tics -= MyTypes.DTEST(u.State.Tics, 65535);
            u.State = u.State.getNext();
            while (MyTypes.TEST(u.State.Tics, Gameutils.SF_QUICK_CALL)) {
                u.State.Animator.invoke(SpriteNum);
                if (!MyTypes.TEST(u.State.Tics, Gameutils.SF_QUICK_CALL)) continue;
                u.State = u.State.getNext();
            }
            if (u.State.Pic != 0) continue;
            Sprites.NewStateGroup(SpriteNum, u.State.getNextGroup());
        }
        Engine.sprite[SpriteNum].picnum = u.RotNum > 1 ? u.Rot.getState((int)0).Pic : u.State.Pic;
        if (MyTypes.TEST(u.State.Tics, Gameutils.SF_PLAYER_FUNC) && u.State.Animator != null) {
            u.State.Animator.invoke(SpriteNum);
        }
    }

    public static void MoveSkipSavePos() {
        USER u;
        SPRITE sp;
        short nexti;
        short i;
        int stat;
        Sprites.MoveSkip8 = Sprites.MoveSkip8 + 1 & 7;
        Sprites.MoveSkip4 = Sprites.MoveSkip4 + 1 & 3;
        Sprites.MoveSkip2 = !Sprites.MoveSkip2;
        short pnum = Mmulti.connecthead;
        while (pnum != -1) {
            PlayerStr pp = Game.Player[pnum];
            pp.oposx = pp.posx;
            pp.oposy = pp.posy;
            pp.oposz = pp.posz;
            pp.oang = pp.pang;
            pp.ohoriz = pp.horiz;
            pp.obob_z = pp.bob_z;
            pp.obob_amt = pp.bob_amt;
            pnum = Mmulti.connectpoint2[pnum];
        }
        if (Sprites.MoveSkip4 == 0) {
            stat = 6;
            while (stat <= 9) {
                i = Engine.headspritestat[stat];
                while (i != -1) {
                    nexti = Engine.nextspritestat[i];
                    sp = Engine.sprite[i];
                    u = Gameutils.pUser[i];
                    if (u != null) {
                        u.ox = sp.x;
                        u.oy = sp.y;
                        u.oz = sp.z;
                    }
                    i = nexti;
                }
                stat = (short)(stat + 1);
            }
        }
        if (!Sprites.MoveSkip2) {
            stat = 2;
            while (stat <= 5) {
                i = Engine.headspritestat[stat];
                while (i != -1) {
                    nexti = Engine.nextspritestat[i];
                    sp = Engine.sprite[i];
                    u = Gameutils.pUser[i];
                    if (u != null) {
                        u.ox = sp.x;
                        u.oy = sp.y;
                        u.oz = sp.z;
                    }
                    i = nexti;
                }
                stat = (short)(stat + 1);
            }
        }
    }

    public static void PlayerTimers(PlayerStr pp) {
        Inv.InventoryTimer(pp);
    }

    public static void ChopsCheck(PlayerStr pp) {
        if (!(Main.game.pMenu.gShowMenu || Draw.HelpInputMode || MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD) || pp.sop_riding != -1 || Mmulti.numplayers > 1)) {
            if ((pp.input.bits | pp.input.vel | pp.input.svel) != 0 || pp.input.angvel != 0.0f || pp.input.aimvel != 0.0f || MyTypes.TEST(pp.Flags, Gameutils.PF_CLIMBING | Gameutils.PF_FALLING | Gameutils.PF_DIVING)) {
                if (pp.Chops != null) {
                    if (pp.sop_control == -1) {
                        pp.Flags &= ~Gameutils.PF_WEAPON_DOWN;
                    }
                    Chops.ChopsSetRetract(pp);
                }
                Game.ChopTics = 0;
            } else {
                Game.ChopTics += 3;
                if (pp.Chops == null) {
                    if (Game.ChopTics > 3600) {
                        Game.ChopTics = 0;
                        pp.Flags |= Gameutils.PF_WEAPON_DOWN;
                        Chops.InitChops(pp);
                    }
                } else if (Game.ChopTics > 3600) {
                    Game.ChopTics = 0;
                    pp.Flags &= ~Gameutils.PF_WEAPON_DOWN;
                    Chops.ChopsSetRetract(pp);
                }
            }
        }
    }

    public static void PlayerGlobal(PlayerStr pp) {
        Player.PlayerTimers(pp);
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_RECOIL)) {
            Player.DoPlayerRecoil(pp);
        }
        if (!MyTypes.TEST(pp.Flags, Gameutils.PF_CLIP_CHEAT) && pp.hi_sectp != -1 && pp.lo_sectp != -1) {
            int min_height = PLAYER_MIN_HEIGHT;
            if (Pragmas.klabs(pp.loz - pp.hiz) < min_height && !MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
                Panel.PlayerUpdateHealth(pp, -Gameutils.pUser[pp.PlayerSprite].Health);
                Weapon.PlayerCheckDeath(pp, -1);
                if (MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
                    return;
                }
            }
        }
        if (pp.FadeAmt > 0 && Sprites.MoveSkip4 == 0) {
            Palette.DoPaletteFlash(pp);
        }
        if (pp.circle_camera_dist > 12000) {
            pp.circle_camera_ang = Gameutils.NORM_ANGLE(pp.circle_camera_ang + 14);
        }
        if (pp.camera_check_time_delay > 0) {
            pp.camera_check_time_delay = (short)(pp.camera_check_time_delay - 3);
            if (pp.camera_check_time_delay <= 0) {
                pp.camera_check_time_delay = 0;
            }
        }
    }

    public static void UpdateScrollingMessages() {
        int i = 0;
        while (i < 6) {
            if (JPlayer.user_quote_time[i] != 0) {
                int n = i;
                JPlayer.user_quote_time[n] = JPlayer.user_quote_time[n] - 1;
                if (JPlayer.user_quote_time[i] <= 0) {
                    Draw.SetRedrawScreen(Game.Player[Mmulti.myconnectindex]);
                    JPlayer.user_quote_time[i] = 0;
                }
            }
            i = (short)(i + 1);
        }
        JPlayer.quotebot = Main.gs.BorderNum > 4 ? JPlayer.quotebotgoal : (Pragmas.klabs(JPlayer.quotebotgoal - JPlayer.quotebot) <= 16 ? (JPlayer.quotebot += Pragmas.ksgn(JPlayer.quotebotgoal - JPlayer.quotebot)) : JPlayer.quotebotgoal);
    }

    public static void MultiPlayLimits() {
        boolean Done = false;
        if (Game.ExitLevel) {
            return;
        }
        if (Main.gNet.MultiGameType != WangNetwork.MultiGameTypes.MULTI_GAME_COMMBAT) {
            return;
        }
        if (Main.gNet.KillLimit != 0) {
            short pnum = Mmulti.connecthead;
            while (pnum != -1) {
                PlayerStr pp = Game.Player[pnum];
                if (pp.Kills >= Main.gNet.KillLimit) {
                    Done = true;
                }
                pnum = Mmulti.connectpoint2[pnum];
            }
        }
        if (Main.gNet.TimeLimit != 0) {
            Main.gNet.TimeLimitClock -= 3;
            if (Main.gNet.TimeLimitClock <= 0) {
                Done = true;
            }
        }
        if (Done) {
            Main.gNet.TimeLimitClock = Main.gNet.TimeLimit;
            if (Game.Level <= 22) {
                ++Game.Level;
            }
            Game.ExitLevel = true;
            Game.FinishedLevel = true;
        }
    }

    public static void domovethings(BuildNet net) {
        PlayerStr pp;
        short i = Mmulti.connecthead;
        while (i != -1) {
            pp = Game.Player[i];
            pp.input.Copy(net.gFifoInput[net.gNetFifoTail & 0xFF][i]);
            i = Mmulti.connectpoint2[i];
        }
        ++net.gNetFifoTail;
        Arrays.fill(Draw.bCopySpriteOffs, false);
        if (Main.gNet.MyCommPlayerQuit()) {
            return;
        }
        if (Main.game.nNetMode == BuildGame.NetMode.Multiplayer) {
            Main.gNet.PauseMultiPlay();
        }
        net.CalcChecksum();
        if ((Main.game.gPaused || !Game.DemoPlaying && WangNetwork.CommPlayers < 2 && !Main.game.isCurrentScreen(Main.gDemoScreen) && (Main.game.menu.gShowMenu || Console.IsShown())) && !Main.game.menu.isOpened(Main.game.menu.mMenus[16])) {
            return;
        }
        Player.UpdateScrollingMessages();
        ++Main.gNet.MoveThingsCount;
        if (Game.DemoRecording && Game.rec != null) {
            Game.rec.record();
        }
        Game.totalsynctics += 3;
        Player.MoveSkipSavePos();
        short pnum = Mmulti.connecthead;
        while (pnum != -1) {
            pp = Game.Player[pnum];
            Player.DoPlayerMenuKeys(pp);
            pnum = Mmulti.connectpoint2[pnum];
        }
        if (Main.game.gPaused) {
            return;
        }
        Game.PlayClock += 3;
        if (RTS.rtsplaying > '\u0000') {
            RTS.rtsplaying = (char)(RTS.rtsplaying - '\u0001');
        }
        if (!Game.DebugAnim && !Game.DebugActorFreeze) {
            Sector.DoAnim(3);
        }
        if (!Game.DebugSector) {
            Sector.DoSector();
        }
        Vis.ProcessVisOn();
        if (Sprites.MoveSkip4 == 0) {
            Quake.ProcessQuakeOn();
            Quake.ProcessQuakeSpot();
            JSector.JS_ProcessEchoSpot();
        }
        Sprites.SpriteControl();
        pnum = Mmulti.connecthead;
        while (pnum != -1) {
            Sector.GlobPlayerStr = pp = Game.Player[pnum];
            if (Mmulti.numplayers <= 1 && Game.PlayerTrackingMode && pnum == Game.screenpeek && Game.screenpeek != Mmulti.myconnectindex) {
                Game.Player[Game.screenpeek].pang = Main.engine.getangle(Game.Player[Mmulti.myconnectindex].posx - Game.Player[Game.screenpeek].posx, Game.Player[Mmulti.myconnectindex].posy - Game.Player[Game.screenpeek].posy);
            }
            if (!MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
                Player.LookupOperate(pp);
                Panel.WeaponOperate(pp);
                Sector.PlayerOperateEnv(pp);
            }
            Player.DoPlayerSectorUpdatePreMove(pp);
            Player.ChopsCheck(pp);
            pp.DoPlayerAction.invoke(pp);
            Player.UpdatePlayerSprite(pp);
            Panel.pSpriteControl(pp);
            Player.PlayerStateControl(pp.PlayerSprite);
            Player.DoPlayerSectorUpdatePostMove(pp);
            Player.PlayerGlobal(pp);
            pnum = Mmulti.connectpoint2[pnum];
        }
        Player.MultiPlayLimits();
        if (Sprites.MoveSkip8 == 0) {
            Sprites.MoveSkip8 = Sprites.MoveSkip8 + 1 & 0xF;
        }
        Sound.DoUpdateSounds3D();
        net.CorrectPrediction();
        if (Weapon.FinishTimer != 0 && (Weapon.FinishTimer -= 3) <= 0) {
            Weapon.FinishTimer = 0;
            Game.ExitLevel = true;
            Game.FinishedLevel = true;
        }
        if (Game.ExitLevel) {
            if (Game.rec != null) {
                Game.rec.close();
            }
            System.err.println("LeaveMap");
            if (Mmulti.numplayers > 1 && Main.game.pNet.bufferJitter >= 0 && Mmulti.myconnectindex == Mmulti.connecthead) {
                i = 0;
                while (i <= Main.game.pNet.bufferJitter) {
                    Main.game.pNet.GetNetworkInput();
                    i = (short)(i + 1);
                }
            }
            if (!Main.game.pNet.WaitForAllPlayers(5000)) {
                Main.game.pNet.NetDisconnect(Mmulti.myconnectindex);
                return;
            }
            Main.game.pNet.ready2send = false;
            if (Main.game.isCurrentScreen(Main.gDemoScreen)) {
                return;
            }
            Game.ExitLevel = false;
            if (Game.FinishedLevel) {
                if (Game.FinishAnim != 0 && Main.gAnmScreen.init(Game.FinishAnim)) {
                    Main.game.changeScreen(Main.gAnmScreen.setCallback(new Runnable(){

                        @Override
                        public void run() {
                            if (Game.Level != 4 && Game.Level != 20) {
                                ++Game.Level;
                            }
                            Main.game.changeScreen(Main.gStatisticScreen);
                        }
                    }).escSkipping(true));
                    return;
                }
                Main.game.changeScreen(Main.gStatisticScreen);
            } else if (!Main.gGameScreen.enterlevel(Main.gGameScreen.getTitle())) {
                Main.game.show();
            }
        }
    }

    private static void LookupOperate(PlayerStr pp) {
        pp.lookang -= pp.lookang >> 2;
        if (pp.lookang != 0 && pp.lookang >> 2 == 0) {
            pp.lookang -= Pragmas.ksgn(pp.lookang);
        }
        if (Gameutils.TEST_SYNC_KEY(pp, 23)) {
            pp.lookang -= 152;
        }
        if (Gameutils.TEST_SYNC_KEY(pp, 24)) {
            pp.lookang += 152;
        }
    }

    public static void InitAllPlayers(boolean NewGame2) {
        PlayerStr pfirst = Game.Player[Mmulti.connecthead];
        pfirst.horizbase = 100.0f;
        pfirst.horiz = 100.0f;
        int ppi = 0;
        while (ppi < 8) {
            PlayerStr pp = Game.Player[ppi];
            pp.posx = pp.oposx = pfirst.posx;
            pp.posy = pp.oposy = pfirst.posy;
            pp.posz = pp.oposz = pfirst.posz;
            pp.pang = pp.oang = pfirst.pang;
            pp.horiz = pp.ohoriz = pfirst.horiz;
            pp.cursectnum = pfirst.cursectnum;
            pp.lastcursectnum = (short)(pfirst.cursectnum + 1);
            pp.horizbase = pfirst.horizbase;
            pp.oldposx = 0;
            pp.oldposy = 0;
            pp.climb_ndx = 10;
            pp.Killer = (short)-1;
            pp.Kills = 0;
            pp.bcnt = 0;
            pp.UziShellLeftAlt = false;
            pp.UziShellRightAlt = false;
            pp.ceiling_dist = PLAYER_RUN_CEILING_DIST;
            pp.floor_dist = PLAYER_RUN_FLOOR_DIST;
            pp.WpnGotOnceFlags = 0;
            pp.DoPlayerAction = Player_Action_Func.DoPlayerBeginRun;
            pp.KeyPressFlags = -1;
            Arrays.fill(pp.KilledPlayer, (short)0);
            if (NewGame2) {
                int i = 0;
                while (i < 7) {
                    pp.InventoryAmount[i] = 0;
                    pp.InventoryPercent[i] = 0;
                    ++i;
                }
            }
            pp.FadeAmt = 0;
            pp.FadeTics = 0;
            pp.StartColor = 0;
            pp.horizoff = 0.0f;
            System.arraycopy(Engine.palette, 0, pp.temp_pal, 0, 768);
            List.Init(pp.PanelSpriteList);
            ++ppi;
        }
    }

    public static int SearchSpawnPosition(PlayerStr pp) {
        int pos_num;
        boolean blocked;
        block0: do {
            short spawn_sprite;
            if ((spawn_sprite = Engine.headspritestat[600 + (pos_num = Gameutils.RANDOM_RANGE(8))]) <= -1) {
                return 0;
            }
            SPRITE sp = Engine.sprite[spawn_sprite];
            blocked = false;
            short pnum = Mmulti.connecthead;
            while (pnum != -1) {
                PlayerStr opp = Game.Player[pnum];
                if (opp != pp && Gameutils.FindDistance3D(sp.x - opp.posx, sp.y - opp.posy, sp.z - opp.posz >> 4) < 1000) {
                    blocked = true;
                    continue block0;
                }
                pnum = Mmulti.connectpoint2[pnum];
            }
        } while (blocked);
        return pos_num;
    }

    public static void PlayerSpawnPosition(int pnum) {
        PlayerStr pp = Game.Player[pnum];
        int spawn_sprite = -1;
        int pos_num = pnum;
        int i = 0;
        while (i < 8) {
            if (!SpawnPositionUsed[i]) {
                pos_num = i;
                break;
            }
            ++i;
        }
        switch (Main.gNet.MultiGameType) {
            default: {
                break;
            }
            case MULTI_GAME_NONE: {
                spawn_sprite = Engine.headspritestat[600];
                break;
            }
            case MULTI_GAME_COMMBAT: 
            case MULTI_GAME_AI_BOTS: {
                if (MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
                    pos_num = Player.SearchSpawnPosition(pp);
                }
                spawn_sprite = Engine.headspritestat[600 + pos_num];
                break;
            }
            case MULTI_GAME_COOPERATIVE: {
                spawn_sprite = Engine.headspritestat[610 + pos_num];
            }
        }
        Player.SpawnPositionUsed[pos_num] = true;
        if (spawn_sprite < 0) {
            spawn_sprite = Engine.headspritestat[600];
        }
        SPRITE sp = Engine.sprite[spawn_sprite];
        pp.posx = pp.oposx = sp.x;
        pp.posy = pp.oposy = sp.y;
        pp.posz = pp.oposz = sp.z;
        pp.pang = pp.oang = (float)sp.ang;
        pp.cursectnum = sp.sectnum;
        Main.engine.getzsofslope(pp.cursectnum, pp.posx, pp.posy, Rooms.zofslope);
        if (pp.posz > Rooms.zofslope[1] - PLAYER_HEIGHT) {
            pp.posz = pp.oposz = Rooms.zofslope[1] - PLAYER_HEIGHT;
        }
    }

    public static void InitMultiPlayerInfo() {
        PlayerStr pp = Game.Player[0];
        short SpriteNum = Engine.headspritestat[0];
        while (SpriteNum != -1) {
            short NextSprite = Engine.nextspritestat[SpriteNum];
            SPRITE sp = Engine.sprite[SpriteNum];
            short tag = sp.hitag;
            if (sp.picnum == 2307) {
                switch (tag) {
                    case 42: {
                        Sprites.change_sprite_stat(SpriteNum, 600 + sp.lotag);
                        break;
                    }
                    case 48: {
                        Sprites.change_sprite_stat(SpriteNum, 610 + sp.lotag);
                    }
                }
            }
            SpriteNum = NextSprite;
        }
        int stat = 0;
        while (stat < MultiStatList.length) {
            if (Main.gNet.MultiGameType == WangNetwork.MultiGameTypes.MULTI_GAME_NONE || Engine.headspritestat[MultiStatList[stat] + 0] < 0) {
                int start0 = Sprites.SpawnSprite(MultiStatList[stat], 2307, null, pp.cursectnum, pp.posx, pp.posy, pp.posz, pp.getAnglei(), 0);
                Gameutils.pUser[start0] = null;
                Engine.sprite[start0].picnum = (short)2307;
            }
            ++stat;
        }
        Arrays.fill(SpawnPositionUsed, false);
        short pnum = Mmulti.connecthead;
        while (pnum != -1) {
            pp = Game.Player[pnum];
            switch (Main.gNet.MultiGameType) {
                default: {
                    break;
                }
                case MULTI_GAME_NONE: {
                    Player.PlayerSpawnPosition(pnum);
                    break;
                }
                case MULTI_GAME_COMMBAT: 
                case MULTI_GAME_AI_BOTS: {
                    Arrays.fill(Game.Player[0].HasKey, (byte)-1);
                    Arrays.fill(pp.HasKey, (byte)-1);
                    Player.PlayerSpawnPosition(pnum);
                    break;
                }
                case MULTI_GAME_COOPERATIVE: {
                    Player.PlayerSpawnPosition(pnum);
                }
            }
            pnum = Mmulti.connectpoint2[pnum];
        }
    }

    public static int DoFootPrints(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        if (u.PlayerP != -1) {
            if (Gameutils.FAF_ConnectArea(Game.Player[u.PlayerP].cursectnum)) {
                return 0;
            }
            if (Game.Player[u.PlayerP].NumFootPrints > 0) {
                Weapon.QueueFootPrint(SpriteNum);
            }
        }
        return 0;
    }

    public static void CheckFootPrints(PlayerStr pp) {
        if (pp.NumFootPrints <= 0 || Weapon.FootMode != Gameutils.FootType.WATER_FOOT) {
            pp.NumFootPrints = (short)(Gameutils.RANDOM_RANGE(10) + 3);
            Weapon.FootMode = Gameutils.FootType.WATER_FOOT;
        }
    }

    public static void PlayerSaveable() {
        Saveable.SaveData(DoPlayerSpriteReset);
        Saveable.SaveData(DoFootPrints);
        Saveable.SaveData(QueueFloorBlood);
        Saveable.SaveData(pSetVisNorm);
        Saveable.SaveData(s_PlayerNinjaRun);
        Saveable.SaveGroup(PlayerStateGroup.sg_PlayerNinjaRun);
        Saveable.SaveData(s_PlayerNinjaStand);
        Saveable.SaveGroup(PlayerStateGroup.sg_PlayerNinjaStand);
        Saveable.SaveData(s_PlayerNinjaJump);
        Saveable.SaveGroup(PlayerStateGroup.sg_PlayerNinjaJump);
        Saveable.SaveData(s_PlayerNinjaFall);
        Saveable.SaveGroup(PlayerStateGroup.sg_PlayerNinjaFall);
        Saveable.SaveData(s_PlayerNinjaClimb);
        Saveable.SaveGroup(PlayerStateGroup.sg_PlayerNinjaClimb);
        Saveable.SaveData(s_PlayerNinjaCrawl);
        Saveable.SaveGroup(PlayerStateGroup.sg_PlayerNinjaCrawl);
        Saveable.SaveData(s_PlayerNinjaSwim);
        Saveable.SaveGroup(PlayerStateGroup.sg_PlayerNinjaSwim);
        Saveable.SaveData(s_PlayerHeadFly);
        Saveable.SaveGroup(PlayerStateGroup.sg_PlayerHeadFly);
        Saveable.SaveData(s_PlayerHead);
        Saveable.SaveGroup(PlayerStateGroup.sg_PlayerHead);
        Saveable.SaveData(s_PlayerHeadHurl);
        Saveable.SaveGroup(PlayerStateGroup.sg_PlayerHeadHurl);
        Saveable.SaveData(s_PlayerDeath);
        Saveable.SaveGroup(PlayerStateGroup.sg_PlayerDeath);
        Saveable.SaveData(s_PlayerNinjaSword);
        Saveable.SaveGroup(PlayerStateGroup.sg_PlayerNinjaSword);
        Saveable.SaveData(s_PlayerNinjaPunch);
        Saveable.SaveGroup(PlayerStateGroup.sg_PlayerNinjaPunch);
        Saveable.SaveData(s_PlayerNinjaFly);
        Saveable.SaveGroup(PlayerStateGroup.sg_PlayerNinjaFly);
    }

    static /* synthetic */ State[][] access$0() {
        return s_PlayerNinjaRun;
    }

    static /* synthetic */ State[][] access$1() {
        return s_PlayerNinjaStand;
    }

    static /* synthetic */ State[][] access$2() {
        return s_PlayerNinjaJump;
    }

    static /* synthetic */ State[][] access$3() {
        return s_PlayerNinjaFall;
    }

    static /* synthetic */ State[][] access$4() {
        return s_PlayerNinjaClimb;
    }

    static /* synthetic */ State[][] access$5() {
        return s_PlayerNinjaCrawl;
    }

    static /* synthetic */ State[][] access$6() {
        return s_PlayerNinjaSwim;
    }

    static /* synthetic */ State[][] access$7() {
        return s_PlayerHeadFly;
    }

    static /* synthetic */ State[][] access$8() {
        return s_PlayerHead;
    }

    static /* synthetic */ State[][] access$9() {
        return s_PlayerHeadHurl;
    }

    static /* synthetic */ State[][] access$10() {
        return s_PlayerDeath;
    }

    static /* synthetic */ State[][] access$11() {
        return s_PlayerNinjaSword;
    }

    static /* synthetic */ State[][] access$12() {
        return s_PlayerNinjaPunch;
    }

    static /* synthetic */ State[][] access$13() {
        return s_PlayerNinjaFly;
    }

    public static enum PlayerStateGroup implements Sprites.StateGroup
    {
        sg_PlayerNinjaRun(Player.access$0()[0], Player.access$0()[1], Player.access$0()[2], Player.access$0()[3], Player.access$0()[4]),
        sg_PlayerNinjaStand(Player.access$1()[0], Player.access$1()[1], Player.access$1()[2], Player.access$1()[3], Player.access$1()[4]),
        sg_PlayerNinjaJump(Player.access$2()[0], Player.access$2()[1], Player.access$2()[2], Player.access$2()[3], Player.access$2()[4]),
        sg_PlayerNinjaFall(Player.access$3()[0], Player.access$3()[1], Player.access$3()[2], Player.access$3()[3], Player.access$3()[4]),
        sg_PlayerNinjaClimb(Player.access$4()[0], Player.access$4()[1], Player.access$4()[2], Player.access$4()[3], Player.access$4()[4]),
        sg_PlayerNinjaCrawl(Player.access$5()[0], Player.access$5()[1], Player.access$5()[2], Player.access$5()[3], Player.access$5()[4]),
        sg_PlayerNinjaSwim(Player.access$6()[0], Player.access$6()[1], Player.access$6()[2], Player.access$6()[3], Player.access$6()[4]),
        sg_PlayerHeadFly(Player.access$7()[0], Player.access$7()[1], Player.access$7()[2], Player.access$7()[3], Player.access$7()[4]),
        sg_PlayerHead(Player.access$8()[0], Player.access$8()[1], Player.access$8()[2], Player.access$8()[3], Player.access$8()[4]),
        sg_PlayerHeadHurl(Player.access$9()[0], Player.access$9()[1], Player.access$9()[2], Player.access$9()[3], Player.access$9()[4]),
        sg_PlayerDeath(Player.access$10()[0], Player.access$10()[1], Player.access$10()[2], Player.access$10()[3], Player.access$10()[4]),
        sg_PlayerNinjaSword(Player.access$11()[0], Player.access$11()[1], Player.access$11()[2], Player.access$11()[3], Player.access$11()[4]),
        sg_PlayerNinjaPunch(Player.access$12()[0], Player.access$12()[1], Player.access$12()[2], Player.access$12()[3], Player.access$12()[4]),
        sg_PlayerNinjaFly(Player.access$13()[0], Player.access$13()[1], Player.access$13()[2], Player.access$13()[3], Player.access$13()[4]);

        private final State[][] group;
        private int index = -1;

        private PlayerStateGroup(State[] ... states) {
            this.group = states;
        }

        @Override
        public State getState(int rotation, int offset) {
            return this.group[rotation][offset];
        }

        @Override
        public State getState(int rotation) {
            return this.group[rotation][0];
        }

        @Override
        public int getLength(int rotation) {
            return this.group[rotation].length;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public void setIndex(int index) {
            this.index = index;
        }
    }

    public static enum Player_Action_Func {
        DoPlayerCrawl{

            @Override
            public void invoke(PlayerStr pp) {
                Player.DoPlayerCrawl(pp);
            }
        }
        ,
        DoPlayerTeleportPause{

            @Override
            public void invoke(PlayerStr pp) {
                Player.DoPlayerTeleportPause(pp);
            }
        }
        ,
        DoPlayerJump{

            @Override
            public void invoke(PlayerStr pp) {
                Player.DoPlayerJump(pp);
            }
        }
        ,
        DoPlayerFall{

            @Override
            public void invoke(PlayerStr pp) {
                Player.DoPlayerFall(pp);
            }
        }
        ,
        DoPlayerForceJump{

            @Override
            public void invoke(PlayerStr pp) {
                Player.DoPlayerForceJump(pp);
            }
        }
        ,
        DoPlayerClimb{

            @Override
            public void invoke(PlayerStr pp) {
                Player.DoPlayerClimb(pp);
            }
        }
        ,
        DoPlayerFly{

            @Override
            public void invoke(PlayerStr pp) {
                Player.DoPlayerFly(pp);
            }
        }
        ,
        DoPlayerDive{

            @Override
            public void invoke(PlayerStr pp) {
                Player.DoPlayerDive(pp);
            }
        }
        ,
        DoPlayerWade{

            @Override
            public void invoke(PlayerStr pp) {
                Player.DoPlayerWade(pp);
            }
        }
        ,
        DoPlayerOperateTurret{

            @Override
            public void invoke(PlayerStr pp) {
                Player.DoPlayerOperateTurret(pp);
            }
        }
        ,
        DoPlayerOperateBoat{

            @Override
            public void invoke(PlayerStr pp) {
                Player.DoPlayerOperateBoat(pp);
            }
        }
        ,
        DoPlayerOperateTank{

            @Override
            public void invoke(PlayerStr pp) {
                Player.DoPlayerOperateTank(pp);
            }
        }
        ,
        DoPlayerRun{

            @Override
            public void invoke(PlayerStr pp) {
                Player.DoPlayerRun(pp);
            }
        }
        ,
        DoPlayerDeathFlip{

            @Override
            public void invoke(PlayerStr pp) {
                Player.DoPlayerDeathFlip(pp);
            }
        }
        ,
        DoPlayerDeathDrown{

            @Override
            public void invoke(PlayerStr pp) {
                Player.DoPlayerDeathDrown(pp);
            }
        }
        ,
        DoPlayerDeathCrumble{

            @Override
            public void invoke(PlayerStr pp) {
                Player.DoPlayerDeathCrumble(pp);
            }
        }
        ,
        DoPlayerDeathExplode{

            @Override
            public void invoke(PlayerStr pp) {
                Player.DoPlayerDeathExplode(pp);
            }
        }
        ,
        DoPlayerBeginRun{

            @Override
            public void invoke(PlayerStr pp) {
                Player.DoPlayerBeginRun(pp);
            }
        }
        ,
        InitWeaponSword{

            @Override
            public void invoke(PlayerStr pp) {
                Sword.InitWeaponSword(pp);
            }
        }
        ,
        InitWeaponFist{

            @Override
            public void invoke(PlayerStr pp) {
                Fist.InitWeaponFist(pp);
            }
        }
        ,
        InitWeaponStar{

            @Override
            public void invoke(PlayerStr pp) {
                Star.InitWeaponStar(pp);
            }
        }
        ,
        InitWeaponShotgun{

            @Override
            public void invoke(PlayerStr pp) {
                Shotgun.InitWeaponShotgun(pp);
            }
        }
        ,
        InitWeaponUzi{

            @Override
            public void invoke(PlayerStr pp) {
                Uzi.InitWeaponUzi(pp);
            }
        }
        ,
        InitWeaponMicro{

            @Override
            public void invoke(PlayerStr pp) {
                Micro.InitWeaponMicro(pp);
            }
        }
        ,
        InitWeaponGrenade{

            @Override
            public void invoke(PlayerStr pp) {
                Grenade.InitWeaponGrenade(pp);
            }
        }
        ,
        InitWeaponMine{

            @Override
            public void invoke(PlayerStr pp) {
                Mine.InitWeaponMine(pp);
            }
        }
        ,
        InitWeaponRail{

            @Override
            public void invoke(PlayerStr pp) {
                Rail.InitWeaponRail(pp);
            }
        }
        ,
        InitWeaponHothead{

            @Override
            public void invoke(PlayerStr pp) {
                HotHead.InitWeaponHothead(pp);
            }
        }
        ,
        InitWeaponHeart{

            @Override
            public void invoke(PlayerStr pp) {
                Heart.InitWeaponHeart(pp);
            }
        }
        ,
        UseInventoryMedkit{

            @Override
            public void invoke(PlayerStr pp) {
                Inv.UseInventoryMedkit(pp);
            }
        }
        ,
        UseInventoryCloak{

            @Override
            public void invoke(PlayerStr pp) {
                Inv.UseInventoryCloak(pp);
            }
        }
        ,
        UseInventoryNightVision{

            @Override
            public void invoke(PlayerStr pp) {
                Inv.UseInventoryNightVision(pp);
            }
        }
        ,
        UseInventoryChemBomb{

            @Override
            public void invoke(PlayerStr pp) {
                Inv.UseInventoryChemBomb(pp);
            }
        }
        ,
        UseInventoryFlashBomb{

            @Override
            public void invoke(PlayerStr pp) {
                Inv.UseInventoryFlashBomb(pp);
            }
        }
        ,
        UseInventoryCaltrops{

            @Override
            public void invoke(PlayerStr pp) {
                Inv.UseInventoryCaltrops(pp);
            }
        };


        public abstract void invoke(PlayerStr var1);
    }
}

