/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Screens;

import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.CRC32;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildControls;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pattern.ScreenAdapters.GameAdapter;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Settings.BuildConfig;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Wang.Border;
import ru.m210projects.Wang.Cheats;
import ru.m210projects.Wang.Config;
import ru.m210projects.Wang.Draw;
import ru.m210projects.Wang.Factory.WangMenuHandler;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.JPlayer;
import ru.m210projects.Wang.LoadSave;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Palette;
import ru.m210projects.Wang.Player;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Text;
import ru.m210projects.Wang.Type.DemoFile;
import ru.m210projects.Wang.Type.GameInfo;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.ResourceHandler;
import ru.m210projects.Wang.Type.VOC3D;

public class GameScreen
extends GameAdapter {
    private Main game;
    private int nonsharedtimer;
    private boolean NewGame = false;

    public GameScreen(Main game) {
        super(game, Main.gLoadingScreen);
        this.game = game;
    }

    @Override
    public void hide() {
        if (!this.game.isCurrentScreen(Main.gPrecacheScreen)) {
            BuildGdx.app.postRunnable(new Runnable(){

                @Override
                public void run() {
                    Game.TerminateLevel();
                }
            });
        }
    }

    @Override
    public void ProcessFrame(BuildNet net) {
        Player.domovethings(net);
    }

    @Override
    public void DrawWorld(float smooth) {
        this.game.pIntSkip2.dointerpolations(smooth);
        this.game.pIntSkip4.dointerpolations(smooth);
        Draw.drawscreen(Game.Player[Game.screenpeek], (int)smooth);
    }

    @Override
    public void DrawHud(float smooth) {
        Draw.drawhud(Game.Player[Game.screenpeek]);
        if (this.game.net.bOutOfSync) {
            this.game.getFont(1).drawText(160, 20, Strhandler.toCharArray("Out of sync!"), 0, 12, BuildFont.TextAlign.Center, 2, false);
            switch (this.game.net.bOutOfSyncByte / 4) {
                case 0: {
                    this.game.getFont(1).drawText(160, 30, Strhandler.toCharArray("seed checksum error"), 0, 12, BuildFont.TextAlign.Center, 2, false);
                    break;
                }
                case 1: {
                    this.game.getFont(1).drawText(160, 30, Strhandler.toCharArray("player struct checksum error"), 0, 12, BuildFont.TextAlign.Center, 2, false);
                    break;
                }
                case 2: {
                    this.game.getFont(1).drawText(160, 30, Strhandler.toCharArray("player sprite checksum error"), 0, 12, BuildFont.TextAlign.Center, 2, false);
                    break;
                }
                case 3: {
                    this.game.getFont(1).drawText(160, 30, Strhandler.toCharArray("missile sprites checksum error"), 0, 12, BuildFont.TextAlign.Center, 2, false);
                }
            }
        }
        this.game.pIntSkip2.restoreinterpolations();
        this.game.pIntSkip4.restoreinterpolations();
        if (Game.Player[Game.screenpeek].FadeAmt != 0 && Main.engine.glrender() != null) {
            Main.engine.showfade();
        }
    }

    @Override
    public void PostFrame(BuildNet net) {
        if (LoadSave.gQuickSaving) {
            if (this.captBuffer != null) {
                LoadSave.savegame("[quicksave_" + LoadSave.quickslot + "]", "quicksav" + LoadSave.quickslot + ".sav");
                LoadSave.quickslot ^= 1;
                LoadSave.gQuickSaving = false;
            } else {
                Main.gGameScreen.capture(160, 100);
            }
        }
        if (LoadSave.gAutosaveRequest) {
            if (this.captBuffer != null) {
                LoadSave.savegame("[autosave]", "autosave.sav");
                LoadSave.gAutosaveRequest = false;
            } else {
                Main.gGameScreen.capture(160, 100);
            }
        }
    }

    @Override
    public void KeyHandler() {
        PlayerStr pp = Game.Player[Mmulti.myconnectindex];
        WangMenuHandler menu = this.game.menu;
        if (menu.gShowMenu) {
            Main.engine.handleevents();
            menu.mKeyHandler(this.game.pInput, BuildGdx.graphics.getDeltaTime());
            return;
        }
        if (Console.IsShown() || Game.MessageInputMode) {
            return;
        }
        BuildControls input = this.game.pInput;
        if (input.ctrlGetInputKey(BuildConfig.GameKeys.Menu_Toggle, true)) {
            menu.mOpen(menu.mMenus[1], -1);
        }
        if (input.ctrlGetInputKey(Config.SwKeys.Show_Help, true)) {
            menu.mOpen(menu.mMenus[6], -1);
        }
        if (input.ctrlGetInputKey(Config.SwKeys.Show_Savemenu, true)) {
            if (Mmulti.numplayers > 1 || this.game.net.FakeMultiplayer) {
                return;
            }
            if (!MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
                Main.gGameScreen.capture(160, 100);
                menu.mOpen(menu.mMenus[8], -1);
            }
        }
        if (input.ctrlGetInputKey(Config.SwKeys.Show_Loadmenu, true)) {
            if (Mmulti.numplayers > 1 || this.game.net.FakeMultiplayer) {
                return;
            }
            menu.mOpen(menu.mMenus[7], -1);
        }
        if (input.ctrlGetInputKey(Config.SwKeys.See_Chase_View, true)) {
            if (input.ctrlKeyStatus(59) || input.ctrlKeyStatus(60)) {
                if (MyTypes.TEST(pp.Flags, Gameutils.PF_VIEW_FROM_OUTSIDE)) {
                    pp.view_outside_dang = Gameutils.NORM_ANGLE(pp.view_outside_dang + 256);
                }
            } else if (MyTypes.TEST(pp.Flags, Gameutils.PF_VIEW_FROM_OUTSIDE)) {
                pp.Flags &= ~Gameutils.PF_VIEW_FROM_OUTSIDE;
            } else {
                pp.Flags |= Gameutils.PF_VIEW_FROM_OUTSIDE;
                pp.camera_dist = 0;
            }
        }
        if (Draw.dimensionmode == 5 || Draw.dimensionmode == 6) {
            int j = Engine.totalclock - this.nonsharedtimer;
            this.nonsharedtimer += j;
            if (input.ctrlGetInputKey(BuildConfig.GameKeys.Enlarge_Screen, false)) {
                Draw.zoom += Pragmas.mulscale(j, Math.max(Draw.zoom, 256), 6);
            }
            if (input.ctrlGetInputKey(BuildConfig.GameKeys.Shrink_Screen, false)) {
                Draw.zoom -= Pragmas.mulscale(j, Math.max(Draw.zoom, 256), 6);
            }
            if (Draw.zoom > 2048) {
                Draw.zoom = 2048;
            }
            if (Draw.zoom < 48) {
                Draw.zoom = 48;
            }
            if (input.ctrlGetInputKey(Config.SwKeys.Map_Follow_Mode, true)) {
                boolean bl = Draw.ScrollMode2D = !Draw.ScrollMode2D;
                if (Draw.ScrollMode2D) {
                    Draw.Follow_posx = pp.oposx;
                    Draw.Follow_posy = pp.oposy;
                }
                Text.PutStringInfoLine(pp, "ScrollMode " + (Draw.ScrollMode2D ? "ON" : "OFF"));
            }
        } else {
            if (input.ctrlGetInputKey(BuildConfig.GameKeys.Enlarge_Screen, true)) {
                Border.SetBorder(pp, Main.gs.BorderNum + 1);
            }
            if (input.ctrlGetInputKey(BuildConfig.GameKeys.Shrink_Screen, true)) {
                Border.SetBorder(pp, Main.gs.BorderNum - 1);
            }
        }
        if (input.ctrlGetInputKey(Config.SwKeys.Toggle_Crosshair, true)) {
            Main.gs.Crosshair = !Main.gs.Crosshair;
            Text.PutStringInfoLine(pp, "Crosshair " + (Main.gs.Crosshair ? "ON" : "OFF"));
        }
        if (input.ctrlGetInputKey(Config.SwKeys.Show_Sounds, true)) {
            menu.mOpen(menu.mMenus[3], -1);
        }
        if (input.ctrlGetInputKey(Config.SwKeys.Show_Options, true)) {
            menu.mOpen(menu.mMenus[5], -1);
        }
        if (input.ctrlGetInputKey(Config.SwKeys.Gamma, true)) {
            this.openGamma(menu);
        }
        if (input.ctrlGetInputKey(Config.SwKeys.Quicksave, true)) {
            LoadSave.quicksave();
        }
        if (input.ctrlGetInputKey(Config.SwKeys.Messages, true)) {
            Main.gs.Messages = !Main.gs.Messages;
            Text.PutStringInfoLine(pp, "Messages " + (Main.gs.Messages ? "ON" : "OFF"));
        }
        if (input.ctrlGetInputKey(BuildConfig.GameKeys.Send_Message, false)) {
            Game.MessageInputMode = true;
            Engine.getInput().initMessageInput(null);
        }
        if (input.ctrlGetInputKey(Config.SwKeys.Quickload, true)) {
            LoadSave.quickload();
        }
        if (input.ctrlGetInputKey(Config.SwKeys.See_Coop_View, true) && (Main.gNet.MultiGameType == WangNetwork.MultiGameTypes.MULTI_GAME_COOPERATIVE || Main.gNet.FakeMultiplayer)) {
            if ((Game.screenpeek = Mmulti.connectpoint2[Game.screenpeek]) < 0) {
                Game.screenpeek = Mmulti.connecthead;
            }
            Palette.ResetPalette(Game.Player[Game.screenpeek], 256);
            Palette.DoPlayerDivePalette(Game.Player[Game.screenpeek]);
            Palette.DoPlayerNightVisionPalette(Game.Player[Game.screenpeek]);
        }
        if (input.ctrlGetInputKey(Config.SwKeys.Quit, true)) {
            menu.mOpen(menu.mMenus[9], -1);
        }
        if (input.ctrlGetInputKey(Config.SwKeys.Screenshot, true)) {
            this.makeScreenshot();
        }
    }

    @Override
    public void sndHandlePause(boolean pause) {
        Sound.sndHandlePause(pause);
    }

    @Override
    protected boolean prepareboard(String map) {
        Draw.gNameShowTime = 500;
        Game.FinishAnim = 0;
        if (!Game.InitLevel(map, this.NewGame)) {
            return false;
        }
        if (this != Main.gDemoScreen) {
            Game.InitPlayerGameSettings();
        } else {
            Game.Player[Mmulti.myconnectindex].Flags = Main.gDemoScreen.demfile.Flags[Mmulti.myconnectindex];
        }
        Main.gNet.InitNetPlayerOptions();
        Main.gNet.ResetTimers();
        Main.gNet.InitPrediction(Game.Player[Mmulti.myconnectindex]);
        Main.gNet.WaitForAllPlayers(0);
        Main.engine.sampletimer();
        Game.InitTimingVars();
        Draw.SetRedrawScreen(Game.Player[Mmulti.myconnectindex]);
        Sound.StartAmbientSound();
        Sound.StartMusic();
        if (Game.DemoRecording) {
            Game.rec = new DemoFile(2);
        }
        if (!this.NewGame && this.game.nNetMode == BuildGame.NetMode.Single && this != Main.gDemoScreen) {
            LoadSave.gAutosaveRequest = true;
        }
        this.NewGame = false;
        System.err.println(map);
        return true;
    }

    public void newgame(final boolean isMultiplayer, final Object item, final int nEpisode, final int nLevel, final int nDifficulty) {
        if (Game.rec != null) {
            Game.rec.close();
        }
        if (Mmulti.numplayers > 1 && this.game.pNet.bufferJitter >= 0 && Mmulti.myconnectindex == Mmulti.connecthead) {
            int i = 0;
            while (i <= this.game.pNet.bufferJitter) {
                this.game.pNet.GetNetworkInput();
                ++i;
            }
        }
        this.pNet.ready2send = false;
        this.game.changeScreen(this.load);
        this.load.init(new Runnable(){

            @Override
            public void run() {
                Cheats.InfinityAmmo = false;
                boolean bl = Game.DemoPlaying = GameScreen.this == Main.gDemoScreen;
                if (!isMultiplayer) {
                    if (Mmulti.numplayers > 1) {
                        GameScreen.this.pNet.NetDisconnect(Mmulti.myconnectindex);
                    }
                    Mmulti.connecthead = 0;
                    Mmulti.connectpoint2[0] = -1;
                    WangNetwork.CommPlayers = 1;
                    ((GameScreen)GameScreen.this).game.nNetMode = BuildGame.NetMode.Single;
                    Main.gNet.FakeMultiplayer = false;
                    if (!Game.DemoPlaying) {
                        Main.gNet.KillLimit = 0;
                        Main.gNet.TimeLimit = 0;
                        Main.gNet.TimeLimitClock = 0;
                        Main.gNet.MultiGameType = WangNetwork.MultiGameTypes.MULTI_GAME_NONE;
                        Main.gNet.TeamPlay = false;
                        Main.gNet.HurtTeammate = false;
                        Main.gNet.SpawnMarkers = false;
                        Main.gNet.NoRespawn = false;
                        Main.gNet.Nuke = true;
                    }
                } else {
                    if (Main.gNet.FakeMultiplayer) {
                        Mmulti.connecthead = 0;
                        WangNetwork.CommPlayers = Main.gNet.FakeMultiNumPlayers;
                        int i = 0;
                        while (i < 16) {
                            Mmulti.connectpoint2[i] = (short)(i + 1);
                            i = (short)(i + 1);
                        }
                        Mmulti.connectpoint2[Main.gNet.FakeMultiNumPlayers - 1] = -1;
                    } else {
                        WangNetwork.CommPlayers = Mmulti.numplayers;
                    }
                    if (GameScreen.this != Main.gDemoScreen) {
                        Main.gNet.HurtTeammate = Game.pNetInfo.nFriendlyFire == 1;
                        Main.gNet.SpawnMarkers = Game.pNetInfo.SpawnMarkers;
                        Main.gNet.TeamPlay = Game.pNetInfo.TeamPlay;
                        Main.gNet.Nuke = Game.pNetInfo.NetNuke;
                        Main.gNet.KillLimit = Game.pNetInfo.KillLimit * 10;
                        Main.gNet.TimeLimitClock = Main.gNet.TimeLimit = WangNetwork.TimeLimitTable[Game.pNetInfo.TimeLimit] * 60 * 120;
                        Main.gNet.MultiGameType = WangNetwork.MultiGameTypes.values()[Game.pNetInfo.nGameType + 1];
                        if (Main.gNet.MultiGameType == WangNetwork.MultiGameTypes.MULTI_GAME_COMMBAT_NO_RESPAWN) {
                            Main.gNet.MultiGameType = WangNetwork.MultiGameTypes.MULTI_GAME_COMMBAT;
                            Main.gNet.NoRespawn = true;
                        } else {
                            Main.gNet.NoRespawn = false;
                        }
                    }
                    Game.GodMode = false;
                    ((GameScreen)GameScreen.this).game.nNetMode = BuildGame.NetMode.Multiplayer;
                }
                Game.boardfilename = null;
                Main.UserFlag flag = Main.UserFlag.None;
                if (item instanceof GameInfo && !item.equals(Game.defGame)) {
                    flag = Main.UserFlag.Addon;
                    GameInfo game = (GameInfo)item;
                    ResourceHandler.checkEpisodeResources(game);
                    Console.Println("Start user episode: " + game.Title);
                } else {
                    ResourceHandler.resetEpisodeResources();
                }
                if (item != null && item instanceof FileEntry) {
                    flag = Main.UserFlag.UserMap;
                    Game.boardfilename = ((FileEntry)item).getPath();
                    Game.Level = 0;
                    Console.Println("Start user map: " + ((FileEntry)item).getName());
                }
                Main.mUserFlag = flag;
                if (GameScreen.this != Main.gDemoScreen && !isMultiplayer) {
                    VOC3D skillvoice = null;
                    switch (nDifficulty) {
                        case 0: {
                            skillvoice = Sound.PlaySound(248, null, 0);
                            break;
                        }
                        case 1: {
                            skillvoice = Sound.PlaySound(368, null, 0);
                            break;
                        }
                        case 2: {
                            skillvoice = Sound.PlaySound(349, null, 0);
                            break;
                        }
                        case 3: {
                            skillvoice = Sound.PlaySound(369, null, 0);
                        }
                    }
                    while (skillvoice != null && skillvoice.isActive()) {
                    }
                }
                if (nEpisode == 0) {
                    Game.Level = nLevel + 1;
                } else if (nEpisode == 1) {
                    Game.Level = 5 + nLevel;
                } else if (nEpisode == 2) {
                    Game.Level = 23 + nLevel;
                }
                Game.Skill = nDifficulty;
                Game.FinishAnim = 0;
                if (flag == Main.UserFlag.Addon && ((GameScreen)GameScreen.this).game.nNetMode == BuildGame.NetMode.Single && GameScreen.this != Main.gDemoScreen && nLevel == 0) {
                    byte[] currentAnm = BuildGdx.cache.getBytes("sw.anm", 0);
                    byte[] defAnm = BuildGdx.cache.getBytes("sw.anm", 1);
                    if (currentAnm != null && defAnm != null && CRC32.getChecksum(currentAnm) != CRC32.getChecksum(defAnm) && Main.gAnmScreen.init(0)) {
                        GameScreen.this.game.changeScreen(Main.gAnmScreen.setCallback(new Runnable(){

                            @Override
                            public void run() {
                                GameScreen.this.NewGame = true;
                                if (!GameScreen.this.enterlevel(GameScreen.this.getTitle())) {
                                    GameScreen.this.game.show();
                                }
                            }
                        }).escSkipping(true));
                        return;
                    }
                }
                GameScreen.this.NewGame = true;
                if (!GameScreen.this.enterlevel(GameScreen.this.getTitle())) {
                    GameScreen.this.game.show();
                }
            }
        });
    }

    public boolean enterlevel(String title) {
        if (title == null) {
            return false;
        }
        String map = Main.mUserFlag == Main.UserFlag.UserMap ? Game.boardfilename : Game.currentGame.getMapPath(Game.Level);
        if (this != Main.gDemoScreen) {
            Game.DemoRecording = Game.isDemoRecording;
        }
        this.loadboard(map, null).setTitle(title);
        return true;
    }

    @Override
    protected void startboard(Runnable startboard) {
        Main.gPrecacheScreen.init(false, startboard);
        this.game.changeScreen(Main.gPrecacheScreen);
    }

    public String getTitle() {
        String title = null;
        if (Main.mUserFlag != Main.UserFlag.UserMap) {
            return Game.currentGame.getMapTitle(Game.Level);
        }
        FileEntry file = BuildGdx.compat.checkFile(Game.boardfilename);
        if (file == null) {
            this.game.GameCrash("Map " + Game.boardfilename + " not found!");
            return null;
        }
        title = file.getName();
        return title;
    }

    protected void openGamma(WangMenuHandler menu) {
        menu.mOpen(menu.mMenus[13], -1);
    }

    protected void makeScreenshot() {
        String filename;
        FileEntry map;
        String name = "scrxxxx.png";
        if (Main.mUserFlag == Main.UserFlag.UserMap && (map = BuildGdx.compat.checkFile(Game.boardfilename)) != null) {
            name = "scr-" + map.getName() + "-xxxx.png";
        }
        if ((filename = this.pEngine.screencapture(name = "scr-" + this.getTitle() + "-xxxx.png")) != null) {
            JPlayer.adduserquote(String.valueOf(filename) + " saved");
        } else {
            JPlayer.adduserquote("Screenshot not saved. Access denied!");
        }
    }
}

