/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Type;

import java.io.File;
import java.util.List;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.FileHandle.Cache1D;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.DirectoryEntry;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.Group;
import ru.m210projects.Build.FileHandle.GroupResource;
import ru.m210projects.Build.FileHandle.PackedZipGroup;
import ru.m210projects.Build.FileHandle.UserGroup;
import ru.m210projects.Build.FileHandle.ZipGroup;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.Types.Tile;
import ru.m210projects.Wang.Digi;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Menus.MenuUserContent;
import ru.m210projects.Wang.Type.GameInfo;
import ru.m210projects.Wang.Type.VoxelScript;

public class ResourceHandler {
    private static UserGroup usergroup;
    public static boolean usecustomarts;

    public static void resetEpisodeResources() {
        BuildGdx.cache.clearDynamicResources();
        usergroup = null;
        Game.currentGame = Game.defGame;
        int i = 0;
        while (i < Digi.voc.length) {
            Digi.voc[i].data = null;
            ++i;
        }
        if (!usecustomarts) {
            Main.game.setDefs(Main.game.baseDef);
            return;
        }
        System.err.println("Reset to default resources");
        i = 0;
        while (i < Game.kMaxTiles) {
            Main.engine.getTile(i).clear();
            ++i;
        }
        if (Main.engine.loadpics() == 0) {
            Main.game.dassert("ART files not found " + new File(String.valueOf(Compat.Path.Game.getPath()) + "TILES###.ART").getAbsolutePath());
        }
        Main.game.setDefs(Main.game.baseDef);
        ResourceHandler.InitSpecialTextures();
        usecustomarts = false;
    }

    public static void InitSpecialTextures() {
        Tile pic = Main.engine.getTile(340);
        pic.setWidth(0).setHeight(0);
        int i = 0;
        while (i < 8) {
            Main.engine.getTile(i + 6000).clear();
            ++i;
        }
    }

    public static void InitGroupResources(DefScript addonScript, List<GroupResource> list) {
        for (GroupResource res : list) {
            if (!res.getFullName().equals("swgdx.def") && res.getExtension().equals("def")) {
                addonScript.loadScript(String.valueOf(res.getFullName()) + " script", res.getBytes());
                Console.Println("Found def-script. Loading " + res.getFullName());
                continue;
            }
            if (res.getExtension().equals("art")) {
                Main.engine.loadpic(res.getFullName());
                usecustomarts = true;
                continue;
            }
            if (!res.getFullName().equals("swvoxfil.txt")) continue;
            VoxelScript vox = new VoxelScript(res);
            vox.apply(addonScript);
            Console.Println("Found swvoxfil.txt. Loading... ");
        }
    }

    public static GameInfo GetEpisode(String path, boolean isPackage) {
        DirectoryEntry resDir = null;
        if (!isPackage) {
            resDir = BuildGdx.compat.checkDirectory(path);
        }
        return ((MenuUserContent)Main.game.menu.mMenus[15]).getAddon(isPackage ? path : null, resDir);
    }

    public static void prepareusergroup(Group group, boolean removable) throws Exception {
        if (group.type == Cache1D.PackageType.Zip) {
            ((ZipGroup)group).removeFolders();
        } else if (group.type == Cache1D.PackageType.PackedZip) {
            ((PackedZipGroup)group).removeFolders();
        }
        List<GroupResource> list = group.getList();
        for (GroupResource res : list) {
            if (!res.getExtension().equals("grp") && !res.getExtension().equals("zip")) continue;
            BuildGdx.cache.add(res, removable);
        }
    }

    private static void searchEpisodeResources(DirectoryEntry cache) {
        if (cache.getDirectories().size() > 0) {
            for (DirectoryEntry dir : cache.getDirectories().values()) {
                dir.InitDirectory(dir.getAbsolutePath());
                if (dir.getName().equals("<userdir>")) continue;
                ResourceHandler.searchEpisodeResources(dir);
            }
        }
        if (usergroup == null) {
            usergroup = BuildGdx.cache.add("User", true);
        }
        for (FileEntry file : cache.getFiles().values()) {
            if (file.getExtension().equals("zip") || file.getExtension().equals("grp")) continue;
            usergroup.add(file, -1);
        }
    }

    public static void checkEpisodeResources(GameInfo addon) {
        ResourceHandler.resetEpisodeResources();
        DefScript addonScript = new DefScript(Main.game.baseDef, addon.getFile());
        if (addon.isPackage()) {
            FileEntry fil = addon.getFile();
            try {
                Group gr = BuildGdx.cache.add(fil.getPath());
                gr.setFlags(true, true);
                GroupResource res = gr.open("swgdx.def");
                if (res != null) {
                    addonScript.loadScript(String.valueOf(gr.name) + " script", res.getBytes());
                    res.close();
                }
                ResourceHandler.prepareusergroup(gr, true);
            }
            catch (Exception e) {
                Main.game.GameCrash("Error found in " + fil.getPath() + "\r\n" + e.getMessage());
                return;
            }
        } else if (addon.getDirectory() != BuildGdx.compat.getDirectory(Compat.Path.Game)) {
            FileEntry def;
            ResourceHandler.searchEpisodeResources(addon.getDirectory());
            if (addon.getDirectory() != null && (def = addon.getDirectory().checkFile("swgdx.def")) != null) {
                addonScript.loadScript(def);
            }
        }
        ResourceHandler.InitGroupResources(addonScript, BuildGdx.cache.getDynamicResources());
        Game.currentGame = addon;
        Main.game.setDefs(addonScript);
    }
}

