/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Type;

import java.util.Arrays;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.WALL;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.LoadSave;
import ru.m210projects.Wang.Type.Anim;
import ru.m210projects.Wang.Type.GameInfo;
import ru.m210projects.Wang.Type.List;
import ru.m210projects.Wang.Type.MirrorType;
import ru.m210projects.Wang.Type.Panel_Sprite;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.ResourceHandler;
import ru.m210projects.Wang.Type.SINE_WALL;
import ru.m210projects.Wang.Type.SINE_WAVE_FLOOR;
import ru.m210projects.Wang.Type.Sect_User;
import ru.m210projects.Wang.Type.Sector_Object;
import ru.m210projects.Wang.Type.Spring_Board;
import ru.m210projects.Wang.Type.TRACK;
import ru.m210projects.Wang.Type.TRACK_POINT;
import ru.m210projects.Wang.Type.USER;

public class SafeLoader {
    private String message;
    public GameInfo addon;
    private String addonFileName;
    public byte warp_on;
    private boolean isPackage;
    public int Level;
    public int Skill;
    public String boardfilename;
    public short numsectors;
    public short numwalls;
    public short[] headspritesect;
    public short[] headspritestat;
    public short[] prevspritesect;
    public short[] prevspritestat;
    public short[] nextspritesect;
    public short[] nextspritestat;
    public SECTOR[] sector = new SECTOR[Engine.MAXSECTORS];
    public WALL[] wall = new WALL[Engine.MAXWALLS];
    public SPRITE[] sprite = new SPRITE[Engine.MAXSPRITES];
    public int playTrack;
    public int FinishTimer;
    public boolean FinishedLevel;
    public int FinishAnim;
    public PlayerStr[] Player = new PlayerStr[8];
    public short connecthead;
    public short[] connectpoint2 = new short[16];
    public short numplayers;
    public int CommPlayers;
    public short myconnectindex;
    public Sect_User[] SectUser = new Sect_User[Engine.MAXSECTORS];
    public USER[] pUser = new USER[Engine.MAXSPRITES];
    public Sector_Object[] SectorObject = new Sector_Object[25];
    public SINE_WAVE_FLOOR[][] SineWaveFloor = new SINE_WAVE_FLOOR[6][21];
    public SINE_WALL[][] SineWall = new SINE_WALL[10][64];
    public Spring_Board[] SpringBoard = new Spring_Board[20];
    public int x_min_bound;
    public int y_min_bound;
    public int x_max_bound;
    public int y_max_bound;
    public TRACK[] Track = new TRACK[100];
    public int screenpeek;
    public int totalsynctics;
    public Anim[] pAnim = new Anim[256];
    public int AnimCnt;
    public short[] pskyoff = new short[256];
    public short pskybits;
    public int parallaxyscale;
    public int randomseed;
    public int totalclock;
    public int visibility;
    public short NormalVisibility;
    public int parallaxyoffs;
    public byte parallaxtype;
    public boolean MoveSkip2;
    public int MoveSkip4;
    public int MoveSkip8;
    public MirrorType[] mirror = new MirrorType[8];
    public boolean mirrorinview;
    public int mirrorcnt;
    public short StarQueueHead = 0;
    public short[] StarQueue = new short[32];
    public short HoleQueueHead = 0;
    public short[] HoleQueue = new short[64];
    public short WallBloodQueueHead = 0;
    public short[] WallBloodQueue = new short[32];
    public short FloorBloodQueueHead = 0;
    public short[] FloorBloodQueue = new short[32];
    public short GenericQueueHead = 0;
    public short[] GenericQueue = new short[32];
    public short LoWangsQueueHead = 0;
    public short[] LoWangsQueue = new short[16];
    public int PlayClock;
    public int Kills;
    public int TotalKillable;
    public short LevelSecrets;
    public int[] picanm = new int[Engine.MAXTILES];
    public byte[] show2dsector = new byte[Engine.MAXSECTORS + 7 >> 3];
    public byte[] show2dwall = new byte[Engine.MAXWALLS + 7 >> 3];
    public byte[] show2dsprite = new byte[Engine.MAXSPRITES + 7 >> 3];
    public int Bunny_Count;
    public boolean GodMode;
    public boolean serpwasseen;
    public boolean sumowasseen;
    public boolean zillawasseen;
    public short[] BossSpriteNum = new short[3];
    public int KillLimit;
    public int TimeLimit;
    public int TimeLimitClock;
    public WangNetwork.MultiGameTypes MultiGameType = WangNetwork.MultiGameTypes.MULTI_GAME_NONE;
    public boolean TeamPlay;
    public boolean HurtTeammate;
    public boolean SpawnMarkers;
    public boolean NoRespawn;
    public boolean Nuke = true;

    public SafeLoader() {
        int j;
        this.headspritesect = new short[Engine.MAXSECTORS + 1];
        this.headspritestat = new short[1025];
        this.prevspritesect = new short[Engine.MAXSPRITES];
        this.prevspritestat = new short[Engine.MAXSPRITES];
        this.nextspritesect = new short[Engine.MAXSPRITES];
        this.nextspritestat = new short[Engine.MAXSPRITES];
        int i = 0;
        while (i < 256) {
            this.pAnim[i] = new Anim();
            ++i;
        }
        i = 0;
        while (i < Engine.MAXSPRITES) {
            this.sprite[i] = new SPRITE();
            ++i;
        }
        i = 0;
        while (i < Engine.MAXSECTORS) {
            this.sector[i] = new SECTOR();
            ++i;
        }
        i = 0;
        while (i < Engine.MAXWALLS) {
            this.wall[i] = new WALL();
            ++i;
        }
        i = 0;
        while (i < 8) {
            this.Player[i] = new PlayerStr();
            ++i;
        }
        i = 0;
        while (i < Engine.MAXSECTORS) {
            this.SectUser[i] = new Sect_User();
            ++i;
        }
        i = 0;
        while (i < Engine.MAXSPRITES) {
            this.pUser[i] = new USER();
            ++i;
        }
        i = 0;
        while (i < 25) {
            this.SectorObject[i] = new Sector_Object();
            ++i;
        }
        i = 0;
        while (i < 20) {
            this.SpringBoard[i] = new Spring_Board();
            ++i;
        }
        i = 0;
        while (i < 10) {
            j = 0;
            while (j < 64) {
                this.SineWall[i][j] = new SINE_WALL();
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 6) {
            j = 0;
            while (j < 21) {
                this.SineWaveFloor[i][j] = new SINE_WAVE_FLOOR();
                ++j;
            }
            ++i;
        }
    }

    public boolean load(Resource bb) {
        this.message = null;
        this.warp_on = 0;
        this.isPackage = false;
        this.addon = null;
        this.addonFileName = null;
        try {
            bb.seek(LoadSave.SAVEHEADER - 8, Resource.Whence.Set);
            this.Level = bb.readInt();
            this.Skill = bb.readInt();
            bb.seek(LoadSave.SAVEHEADER + 16000, Resource.Whence.Set);
            int s = 0;
            while (s < Engine.MAXSECTORS) {
                if (this.SectUser[s] != null) {
                    this.SectUser[s].reset();
                }
                ++s;
            }
            Arrays.fill(this.pUser, null);
            this.LoadGDXBlock(bb);
            this.LoadMap(bb);
            this.LoadPanelSprites(bb);
            this.LoadPlayers(bb);
            this.LoadSectorUserInfos(bb);
            this.LoadUserInfos(bb);
            this.LoadSectorObjects(bb);
            this.LoadSineSect(bb);
            this.x_min_bound = bb.readInt();
            this.y_min_bound = bb.readInt();
            this.x_max_bound = bb.readInt();
            this.y_max_bound = bb.readInt();
            this.LoadTracks(bb);
            this.screenpeek = bb.readInt();
            this.totalsynctics = bb.readInt();
            this.LoadAnims(bb);
            this.totalclock = bb.readInt();
            this.randomseed = bb.readInt();
            this.NormalVisibility = bb.readShort();
            this.visibility = bb.readInt();
            this.parallaxtype = bb.readByte();
            this.parallaxyoffs = bb.readInt();
            int i = 0;
            while (i < 256) {
                this.pskyoff[i] = bb.readShort();
                ++i;
            }
            this.pskybits = bb.readShort();
            this.MoveSkip2 = bb.readBoolean();
            this.MoveSkip4 = bb.readInt();
            this.MoveSkip8 = bb.readInt();
            this.LoadMirrors(bb);
            this.LoadQueues(bb);
            this.LoadStuff(bb);
            if (this.warp_on == 1) {
                this.addon = ResourceHandler.GetEpisode(this.addonFileName, this.isPackage);
                if (this.addon == null) {
                    this.message = "Can't find user episode file: " + this.addonFileName;
                    this.warp_on = (byte)2;
                    this.Level = 0;
                }
            }
            if (bb.position() == bb.size()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public String getMessage() {
        return this.message;
    }

    public GameInfo LoadGDXHeader(Resource fil) {
        this.Level = -1;
        this.Skill = -1;
        this.warp_on = 0;
        this.isPackage = false;
        this.addon = null;
        this.addonFileName = null;
        try {
            fil.seek(LoadSave.SAVEHEADER - 8, Resource.Whence.Set);
            this.Level = fil.readInt();
            this.Skill = fil.readInt();
            fil.seek(LoadSave.SAVEHEADER + 16000, Resource.Whence.Set);
            this.LoadGDXBlock(fil);
            if (this.warp_on == 1) {
                this.addon = ResourceHandler.GetEpisode(this.addonFileName, this.isPackage);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.addon;
    }

    private void LoadGDXBlock(Resource bb) {
        int pos = bb.position();
        this.warp_on = bb.readByte();
        if (this.warp_on == 1) {
            this.isPackage = bb.readBoolean();
            this.addonFileName = Strhandler.toLowerCase(bb.readString(144).trim());
        }
        bb.seek(pos + 16128, Resource.Whence.Set);
    }

    private void LoadPlayers(Resource fil) {
        this.numplayers = fil.readShort();
        this.CommPlayers = fil.readShort().shortValue();
        this.myconnectindex = fil.readShort();
        this.connecthead = fil.readShort();
        int i = 0;
        while (i < 16) {
            this.connectpoint2[i] = fil.readShort();
            ++i;
        }
        i = 0;
        while (i < this.numplayers) {
            this.Player[i].load(fil);
            ++i;
        }
    }

    private void LoadPanelSprites(Resource bb) {
        int i = 0;
        while (i < 1) {
            int ndx;
            PlayerStr pp = this.Player[i];
            List.Init(pp.PanelSpriteList);
            while ((ndx = bb.readInt().intValue()) != -1) {
                Panel_Sprite psp = new Panel_Sprite();
                psp.siblingNdx = bb.readInt();
                psp.load(bb);
                List.InsertTrail(pp.PanelSpriteList, psp);
            }
            Panel_Sprite psp = pp.PanelSpriteList.Next;
            while (psp != pp.PanelSpriteList) {
                Panel_Sprite next = psp.Next;
                psp.sibling = List.PanelNdxToSprite(pp.PanelSpriteList, psp.siblingNdx);
                psp = next;
            }
            ++i;
        }
    }

    private void LoadMap(Resource bb) {
        String name = bb.readString(144).trim();
        if (!name.isEmpty()) {
            this.boardfilename = name;
        }
        this.numwalls = bb.readShort();
        int w = 0;
        while (w < this.numwalls) {
            if (this.wall[w] == null) {
                this.wall[w] = new WALL();
            }
            this.wall[w].buildWall(bb);
            ++w;
        }
        this.numsectors = bb.readShort();
        int s = 0;
        while (s < this.numsectors) {
            if (this.sector[s] == null) {
                this.sector[s] = new SECTOR();
            }
            this.sector[s].buildSector(bb);
            ++s;
        }
        int i = 0;
        while (i < Engine.MAXSPRITES) {
            if (this.sprite[i] == null) {
                this.sprite[i] = new SPRITE();
            }
            this.sprite[i].buildSprite(bb);
            ++i;
        }
        i = 0;
        while (i <= Engine.MAXSECTORS) {
            this.headspritesect[i] = bb.readShort();
            ++i;
        }
        i = 0;
        while (i <= 1024) {
            this.headspritestat[i] = bb.readShort();
            ++i;
        }
        i = 0;
        while (i < Engine.MAXSPRITES) {
            this.prevspritesect[i] = bb.readShort();
            ++i;
        }
        i = 0;
        while (i < Engine.MAXSPRITES) {
            this.prevspritestat[i] = bb.readShort();
            ++i;
        }
        i = 0;
        while (i < Engine.MAXSPRITES) {
            this.nextspritesect[i] = bb.readShort();
            ++i;
        }
        i = 0;
        while (i < Engine.MAXSPRITES) {
            this.nextspritestat[i] = bb.readShort();
            ++i;
        }
        this.FinishTimer = bb.readInt();
        this.FinishedLevel = bb.readBoolean();
        this.FinishAnim = bb.readInt();
        this.playTrack = bb.readInt();
    }

    private void LoadSectorUserInfos(Resource fil) {
        int i = 0;
        while (i < this.numsectors) {
            int sectnum = fil.readInt();
            if (sectnum != -1) {
                if (this.SectUser[sectnum] != null) {
                    this.SectUser[sectnum] = new Sect_User();
                }
                this.SectUser[sectnum].load(fil);
            }
            ++i;
        }
    }

    private void LoadUserInfos(Resource fil) {
        int i = 0;
        while (i < Engine.MAXSPRITES) {
            int snum = fil.readInt();
            if (snum != -1) {
                this.pUser[snum] = new USER();
                this.pUser[snum].load(fil);
            }
            ++i;
        }
    }

    private void LoadSectorObjects(Resource fil) {
        int i = 0;
        while (i < 25) {
            this.SectorObject[i].load(fil);
            ++i;
        }
    }

    private void LoadSineSect(Resource fil) {
        int j;
        int i = 0;
        while (i < 6) {
            j = 0;
            while (j < 21) {
                this.SineWaveFloor[i][j].load(fil);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 10) {
            j = 0;
            while (j < 64) {
                this.SineWall[i][j].load(fil);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 20) {
            this.SpringBoard[i].load(fil);
            ++i;
        }
    }

    private void LoadTracks(Resource fil) {
        int i = 0;
        while (i < 100) {
            if (this.Track[i] == null) {
                this.Track[i] = new TRACK();
            } else {
                this.Track[i].reset();
            }
            TRACK tr = this.Track[i];
            tr.ttflags = fil.readInt();
            tr.flags = fil.readShort();
            tr.NumPoints = fil.readShort();
            if (tr.NumPoints == 0) {
                tr.TrackPoint = new TRACK_POINT[1];
            } else {
                tr.TrackPoint = new TRACK_POINT[tr.NumPoints];
                int j = 0;
                while (j < tr.NumPoints) {
                    TRACK_POINT tp = tr.TrackPoint[j] = new TRACK_POINT();
                    tp.x = fil.readInt();
                    tp.y = fil.readInt();
                    tp.z = fil.readInt();
                    tp.ang = fil.readShort();
                    tp.tag_low = fil.readShort();
                    tp.tag_high = fil.readShort();
                    ++j;
                }
            }
            ++i;
        }
    }

    private void LoadAnims(Resource fil) {
        this.AnimCnt = fil.readInt();
        int i = 0;
        while (i < 256) {
            this.pAnim[i].load(fil);
            ++i;
        }
    }

    private void LoadMirrors(Resource fil) {
        this.mirrorcnt = fil.readInt();
        this.mirrorinview = fil.readBoolean();
        int i = 0;
        while (i < 8) {
            if (this.mirror[i] == null) {
                this.mirror[i] = new MirrorType();
            }
            this.mirror[i].load(fil);
            ++i;
        }
    }

    private void LoadQueues(Resource res) {
        this.StarQueueHead = res.readShort();
        int i = 0;
        while (i < 32) {
            this.StarQueue[i] = res.readShort();
            ++i;
        }
        this.HoleQueueHead = res.readShort();
        i = 0;
        while (i < 64) {
            this.HoleQueue[i] = res.readShort();
            ++i;
        }
        this.WallBloodQueueHead = res.readShort();
        i = 0;
        while (i < 32) {
            this.WallBloodQueue[i] = res.readShort();
            ++i;
        }
        this.FloorBloodQueueHead = res.readShort();
        i = 0;
        while (i < 32) {
            this.FloorBloodQueue[i] = res.readShort();
            ++i;
        }
        this.GenericQueueHead = res.readShort();
        i = 0;
        while (i < 32) {
            this.GenericQueue[i] = res.readShort();
            ++i;
        }
        this.LoWangsQueueHead = res.readShort();
        i = 0;
        while (i < 16) {
            this.LoWangsQueue[i] = res.readShort();
            ++i;
        }
    }

    private void LoadStuff(Resource fil) {
        this.PlayClock = fil.readInt();
        this.Kills = fil.readInt();
        this.TotalKillable = fil.readInt();
        this.KillLimit = fil.readInt();
        this.TimeLimit = fil.readInt();
        this.TimeLimitClock = fil.readInt();
        int i = fil.readByte().byteValue();
        this.MultiGameType = i != -1 ? WangNetwork.MultiGameTypes.values()[i] : null;
        this.TeamPlay = fil.readBoolean();
        this.HurtTeammate = fil.readBoolean();
        this.SpawnMarkers = fil.readBoolean();
        this.NoRespawn = fil.readBoolean();
        this.Nuke = fil.readBoolean();
        i = 0;
        while (i < Engine.MAXTILES) {
            this.picanm[i] = fil.readInt();
            ++i;
        }
        this.LevelSecrets = fil.readShort();
        fil.read(this.show2dwall);
        fil.read(this.show2dsprite);
        fil.read(this.show2dsector);
        this.Bunny_Count = fil.readInt();
        this.GodMode = fil.readBoolean();
        this.serpwasseen = fil.readBoolean();
        this.sumowasseen = fil.readBoolean();
        this.zillawasseen = fil.readBoolean();
        i = 0;
        while (i < 3) {
            this.BossSpriteNum[i] = fil.readShort();
            ++i;
        }
    }
}

