/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Weapons;

import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Panel;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Panel_Sprite;
import ru.m210projects.Wang.Type.Panel_Sprite_Func;
import ru.m210projects.Wang.Type.Panel_State;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Weapon;

public class Heart {
    private static final int HEART_REST = 2050;
    private static final int HEART_ATTACK = 2052;
    private static final int ID_HeartPresent0 = 2050;
    private static final int ID_HeartPresent1 = 2051;
    private static final int ID_HeartAttack0 = 2052;
    private static final int ID_HeartAttack1 = 2053;
    private static final int HEART_BLOOD = 2420;
    private static final int ID_HeartBlood0 = 2420;
    private static final int ID_HeartBlood1 = 2421;
    private static final int ID_HeartBlood2 = 2422;
    private static final int ID_HeartBlood3 = 2423;
    private static final int ID_HeartBlood4 = 2424;
    private static final int ID_HeartBlood5 = 2425;
    private static final int HEART_YOFF = 212;
    private static final int Heart_BEAT_RATE = 60;
    private static final int Heart_ACTION_RATE = 10;
    private static final Panel_Sprite_Func pHeartPresent = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            if (MyTypes.TEST(psp.PlayerP().Flags, Gameutils.PF_WEAPON_RETRACT)) {
                return;
            }
            psp.y -= 9;
            if (psp.y < 212) {
                psp.yorig = psp.y = 212;
                Panel.pSetState(psp, psp.RestState);
            }
        }
    };
    private static final Panel_State ps_PresentHeart_0 = new Panel_State(2050, 60, pHeartPresent);
    private static final Panel_State ps_PresentHeart_1 = new Panel_State(2051, 60, pHeartPresent);
    private static final Panel_State[] ps_PresentHeart = new Panel_State[]{ps_PresentHeart_0.setNext(ps_PresentHeart_1), ps_PresentHeart_1.setNext(ps_PresentHeart_0)};
    private static final Panel_Sprite_Func pHeartHide = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            short picnum = psp.picndx;
            psp.y += 9;
            if (psp.y >= 212 + Main.engine.getTile(picnum).getHeight()) {
                psp.y = 212 + Main.engine.getTile(picnum).getHeight();
                Panel.pWeaponUnHideKeys(psp, psp.PresentState);
            }
        }
    };
    private static final Panel_State ps_HeartHide_0 = new Panel_State(2050, 60, pHeartHide);
    private static final Panel_State ps_HeartHide_1 = new Panel_State(2051, 60, pHeartHide);
    private static final Panel_State[] ps_HeartHide = new Panel_State[]{ps_HeartHide_0.setNext(ps_HeartHide_1), ps_HeartHide_1.setNext(ps_HeartHide_0)};
    private static final Panel_Sprite_Func pHeartRetract = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            short picnum = psp.picndx;
            psp.y += 9;
            if (psp.y >= 212 + Main.engine.getTile(picnum).getHeight()) {
                psp.PlayerP().Flags &= ~Gameutils.PF_WEAPON_RETRACT;
                psp.PlayerP().Wpn[9] = null;
                Panel.pKillSprite(psp);
            }
        }
    };
    private static final Panel_State ps_RetractHeart_0 = new Panel_State(2050, 60, pHeartRetract);
    private static final Panel_State ps_RetractHeart_1 = new Panel_State(2051, 60, pHeartRetract);
    private static final Panel_State[] ps_RetractHeart = new Panel_State[]{ps_RetractHeart_0.setNext(ps_RetractHeart_1), ps_RetractHeart_1.setNext(ps_RetractHeart_0)};
    private static final Panel_Sprite_Func pHeartRest = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            boolean force;
            boolean bl = force = MyTypes.TEST(psp.flags, Panel.PANF_UNHIDE_SHOOT);
            if (Panel.pWeaponHideKeys(psp, ps_HeartHide[0])) {
                return;
            }
            psp.yorig += 3;
            if (psp.yorig > 212) {
                psp.yorig = 212;
            }
            psp.y = psp.yorig;
            Heart.pHeartBobSetup(psp);
            Panel.pWeaponBob(psp, Gameutils.PLAYER_MOVING(psp.PlayerP()) != 0);
            if (Gameutils.TEST_SYNC_KEY(psp.PlayerP(), 17) || force) {
                if (Gameutils.FLAG_KEY_PRESSED(psp.PlayerP(), 17) || force) {
                    Gameutils.FLAG_KEY_RELEASE(psp.PlayerP(), 17);
                    psp.flags &= ~Panel.PANF_UNHIDE_SHOOT;
                    if (!Panel.WeaponOK(psp.PlayerP())) {
                        return;
                    }
                    Panel.DoPlayerChooseYell(psp.PlayerP());
                    Panel.pSetState(psp, psp.ActionState);
                }
            } else {
                Gameutils.FLAG_KEY_RESET(psp.PlayerP(), 17);
                Panel.WeaponOK(psp.PlayerP());
            }
        }
    };
    private static final int HEART_BLOOD_SMALL_RATE = 7;
    private static final Panel_Sprite_Func pHeartBlood = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            int x = Panel.castLongX(psp);
            int y = Panel.castLongY(psp);
            if (MyTypes.TEST(psp.flags, Panel.PANF_JUMPING)) {
                Heart.DoPanelJump(psp);
            } else if (MyTypes.TEST(psp.flags, Panel.PANF_FALLING)) {
                Heart.DoPanelFall(psp);
            }
            Panel.setLong(psp, x += psp.xspeed, y);
            if (psp.x > 320 || psp.x < 0 || psp.y > 200) {
                Panel.pKillSprite(psp);
                return;
            }
        }
    };
    private static final Panel_State ps_HeartBloodSmall_0 = new Panel_State(2420, 7, pHeartBlood);
    private static final Panel_State ps_HeartBloodSmall_1 = new Panel_State(2421, 7, pHeartBlood);
    private static final Panel_State ps_HeartBloodSmall_2 = new Panel_State(2422, 7, pHeartBlood);
    private static final Panel_State ps_HeartBloodSmall_3 = new Panel_State(2423, 7, pHeartBlood);
    private static final Panel_State ps_HeartBloodSmall_4 = new Panel_State(2424, 7, pHeartBlood);
    private static final Panel_State ps_HeartBloodSmall_5 = new Panel_State(2425, 7, pHeartBlood);
    private static final Panel_State ps_HeartBloodSmall_6 = new Panel_State(2425, 7, Panel.pSuicide);
    private static final Panel_State[] ps_HeartBloodSmall = new Panel_State[]{ps_HeartBloodSmall_0.setNext(ps_HeartBloodSmall_1), ps_HeartBloodSmall_1.setNext(ps_HeartBloodSmall_2), ps_HeartBloodSmall_2.setNext(ps_HeartBloodSmall_3), ps_HeartBloodSmall_3.setNext(ps_HeartBloodSmall_4), ps_HeartBloodSmall_4.setNext(ps_HeartBloodSmall_5), ps_HeartBloodSmall_5.setNext(ps_HeartBloodSmall_6), ps_HeartBloodSmall_6.setNext()};
    private static final int HEART_BLOOD_RATE = 10;
    private static final Panel_State ps_HeartBlood_0 = new Panel_State(2420, 10, pHeartBlood);
    private static final Panel_State ps_HeartBlood_1 = new Panel_State(2421, 10, pHeartBlood);
    private static final Panel_State ps_HeartBlood_2 = new Panel_State(2422, 10, pHeartBlood);
    private static final Panel_State ps_HeartBlood_3 = new Panel_State(2423, 10, pHeartBlood);
    private static final Panel_State ps_HeartBlood_4 = new Panel_State(2424, 10, pHeartBlood);
    private static final Panel_State ps_HeartBlood_5 = new Panel_State(2425, 10, pHeartBlood);
    private static final Panel_State ps_HeartBlood_6 = new Panel_State(2425, 10, Panel.pSuicide);
    private static final Panel_State[] ps_HeartBlood = new Panel_State[]{ps_HeartBlood_0.setNext(ps_HeartBlood_1), ps_HeartBlood_1.setNext(ps_HeartBlood_2), ps_HeartBlood_2.setNext(ps_HeartBlood_3), ps_HeartBlood_3.setNext(ps_HeartBlood_4), ps_HeartBlood_4.setNext(ps_HeartBlood_5), ps_HeartBlood_5.setNext(ps_HeartBlood_6), ps_HeartBlood_6.setNext()};
    private static final Panel_Shrap[] HeartShrap = new Panel_Shrap[]{new Panel_Shrap(-10, -80, 0, -Heart.FIXED(1, 0), -Heart.FIXED(2, 0), -Heart.FIXED(1, 0), -Heart.FIXED(3, 0), new Panel_State[][]{ps_HeartBloodSmall, ps_HeartBloodSmall}), new Panel_Shrap(0, -85, 0, -Heart.FIXED(1, 0), -Heart.FIXED(5, 0), -Heart.FIXED(1, 0), -Heart.FIXED(1, 0), new Panel_State[][]{ps_HeartBloodSmall, ps_HeartBloodSmall}), new Panel_Shrap(10, -85, 0, -Heart.FIXED(1, 0), -Heart.FIXED(2, 0), Heart.FIXED(1, 0), Heart.FIXED(2, 0), new Panel_State[][]{ps_HeartBloodSmall, ps_HeartBloodSmall}), new Panel_Shrap(25, -80, 0, -Heart.FIXED(1, 0), -Heart.FIXED(2, 0), Heart.FIXED(3, 0), Heart.FIXED(4, 0), new Panel_State[][]{ps_HeartBloodSmall, ps_HeartBloodSmall})};
    private static final Panel_Sprite_Func SpawnSmallHeartBlood = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            PlayerStr pp = psp.PlayerP();
            Sound.PlaySound(27, pp, 13);
            Panel_Shrap hsp = HeartShrap[0];
            int p = 0;
            while (p < HeartShrap.length && hsp.lo_jump_speed != 0) {
                hsp = HeartShrap[p];
                Panel_Sprite blood = Panel.pSpawnSprite(pp, hsp.state[Gameutils.RANDOM_P2(512) >> 8][0], 64, 0, 0);
                blood.x = psp.x + hsp.xoff;
                blood.y = psp.y + hsp.yoff;
                blood.xspeed = hsp.lo_xspeed + (Gameutils.RANDOM_RANGE(hsp.hi_xspeed - hsp.lo_xspeed >> 4) << 4);
                blood.flags |= Panel.PANF_WEAPON_SPRITE;
                blood.scale = 10000 + Gameutils.RANDOM_RANGE(20000);
                blood.jump_speed = hsp.lo_jump_speed + (Gameutils.RANDOM_RANGE(hsp.hi_jump_speed + hsp.lo_jump_speed >> 4) << 4);
                Heart.DoBeginPanelJump(blood);
                ++p;
            }
        }
    };
    private static final Panel_State ps_HeartRest_0 = new Panel_State(2050, 60, pHeartRest);
    private static final Panel_State ps_HeartRest_1 = new Panel_State(2051, 60, pHeartRest);
    private static final Panel_State ps_HeartRest_2 = new Panel_State(2051, 60, SpawnSmallHeartBlood);
    private static final Panel_State ps_HeartRest_3 = new Panel_State(2051, 0, pHeartRest);
    private static final Panel_State[] ps_HeartRest = new Panel_State[]{ps_HeartRest_0.setNext(ps_HeartRest_1), ps_HeartRest_1.setNext(ps_HeartRest_2), ps_HeartRest_2.setNext(ps_HeartRest_3).setFlags(Panel.psf_QuickCall), ps_HeartRest_3.setNext(ps_HeartRest_0)};
    private static final Panel_Sprite_Func pHeartActionBlood = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            psp.yorig -= 3;
            if (psp.yorig < 200) {
                psp.yorig = 200;
            }
            psp.y = psp.yorig;
            Heart.pHeartBobSetup(psp);
            Panel.pWeaponBob(psp, Gameutils.PLAYER_MOVING(psp.PlayerP()) != 0);
            Heart.SpawnHeartBlood(psp);
        }
    };
    private static final Panel_Sprite_Func pHeartAction = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            psp.yorig -= 3;
            if (psp.yorig < 200) {
                psp.yorig = 200;
            }
            psp.y = psp.yorig;
            Heart.pHeartBobSetup(psp);
            Panel.pWeaponBob(psp, Gameutils.PLAYER_MOVING(psp.PlayerP()) != 0);
        }
    };
    private static final Panel_Sprite_Func pHeartAttack = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            PlayerStr pp = psp.PlayerP();
            Sound.PlaySound(28, pp, 9);
            if (Gameutils.RANDOM_RANGE(1000) > 800) {
                Sound.PlayerSound(583, 9, pp);
            }
            Weapon.InitHeartAttack(psp.PlayerP());
        }
    };
    private static final Panel_State ps_HeartAttack_0 = new Panel_State(2052, 10, pHeartActionBlood);
    private static final Panel_State ps_HeartAttack_1 = new Panel_State(2053, 10, pHeartActionBlood);
    private static final Panel_State ps_HeartAttack_2 = new Panel_State(2053, 10, pHeartActionBlood);
    private static final Panel_State ps_HeartAttack_3 = new Panel_State(2053, 10, pHeartAttack);
    private static final Panel_State ps_HeartAttack_4 = new Panel_State(2053, 10, pHeartAction);
    private static final Panel_State ps_HeartAttack_5 = new Panel_State(2053, 10, pHeartAction);
    private static final Panel_State ps_HeartAttack_6 = new Panel_State(2052, 10, pHeartAction);
    private static final Panel_State ps_HeartAttack_7 = new Panel_State(2052, 10, pHeartAction);
    private static final Panel_State[] ps_HeartAttack = new Panel_State[]{ps_HeartAttack_0.setNext(ps_HeartAttack_1).setFlags(Panel.psf_ShadeHalf), ps_HeartAttack_1.setNext(ps_HeartAttack_2).setFlags(Panel.psf_ShadeNone), ps_HeartAttack_2.setNext(ps_HeartAttack_3).setFlags(Panel.psf_ShadeNone), ps_HeartAttack_3.setNext(ps_HeartAttack_4).setFlags(Panel.psf_QuickCall), ps_HeartAttack_4.setNext(ps_HeartAttack_5).setFlags(Panel.psf_ShadeNone), ps_HeartAttack_5.setNext(ps_HeartAttack_6).setFlags(Panel.psf_ShadeNone), ps_HeartAttack_6.setNext(ps_HeartAttack_7).setFlags(Panel.psf_ShadeHalf), ps_HeartAttack_7.setNext(ps_HeartRest[0]).setFlags(Panel.psf_ShadeHalf)};
    private static final int PANEL_JUMP_GRAVITY = 8000;
    private static Panel_Shrap[] HeartShrap2 = new Panel_Shrap[]{new Panel_Shrap(-10, -80, 2, -Heart.FIXED(1, 32000), -Heart.FIXED(2, 32000), -Heart.FIXED(5, 32000), -Heart.FIXED(3, 32000), new Panel_State[][]{ps_HeartBlood, ps_HeartBlood}), new Panel_Shrap(0, -85, 0, -Heart.FIXED(3, 32000), -Heart.FIXED(8, 32000), -Heart.FIXED(3, 32000), -Heart.FIXED(1, 32000), new Panel_State[][]{ps_HeartBlood, ps_HeartBlood}), new Panel_Shrap(10, -85, 2, -Heart.FIXED(1, 32000), -Heart.FIXED(2, 32000), Heart.FIXED(2, 32000), Heart.FIXED(3, 32000), new Panel_State[][]{ps_HeartBlood, ps_HeartBlood}), new Panel_Shrap(25, -80, 2, -Heart.FIXED(1, 32000), -Heart.FIXED(2, 32000), Heart.FIXED(5, 32000), Heart.FIXED(6, 32000), new Panel_State[][]{ps_HeartBlood, ps_HeartBlood})};

    public static void InitWeaponHeart(PlayerStr pp) {
        Panel_Sprite psp;
        if (WangNetwork.Prediction) {
            return;
        }
        if (!MyTypes.TEST(pp.WpnFlags, MyTypes.BIT(9)) || MyTypes.TEST(pp.Flags, Gameutils.PF_WEAPON_RETRACT)) {
            return;
        }
        if (pp.Wpn[9] == null) {
            psp = pp.Wpn[9] = Panel.pSpawnSprite(pp, ps_PresentHeart[0], 128, 170, 212);
            psp.y += Main.engine.getTile(psp.picndx).getHeight();
        }
        if (pp.CurWpn == pp.Wpn[9]) {
            return;
        }
        Panel.PlayerUpdateWeapon(pp, 9);
        pp.WpnUziType = (byte)2;
        Panel.RetractCurWpn(pp);
        Sound.PlaySound(27, pp, 13);
        psp = pp.CurWpn = pp.Wpn[9];
        psp.flags |= Panel.PANF_WEAPON_SPRITE;
        psp.ActionState = ps_HeartAttack[0];
        psp.RetractState = ps_RetractHeart[0];
        psp.PresentState = ps_PresentHeart[0];
        psp.RestState = ps_HeartRest[0];
        Panel.pSetState(psp, psp.PresentState);
        Gameutils.FLAG_KEY_RELEASE(psp.PlayerP(), 17);
        Gameutils.FLAG_KEY_RESET(psp.PlayerP(), 17);
    }

    private static void pHeartBobSetup(Panel_Sprite psp) {
        if (MyTypes.TEST(psp.flags, Panel.PANF_BOB)) {
            return;
        }
        psp.xorig = psp.x;
        psp.yorig = psp.y;
        psp.sin_amt = (short)12;
        psp.sin_ndx = 0;
        psp.bob_height_shift = (short)3;
    }

    private static void DoBeginPanelJump(Panel_Sprite psp) {
        psp.flags |= Panel.PANF_JUMPING;
        psp.flags &= ~Panel.PANF_FALLING;
        psp.jump_grav = 8000;
        Heart.DoPanelJump(psp);
    }

    private static void DoPanelJump(Panel_Sprite psp) {
        int x = Panel.castLongX(psp);
        int y = Panel.castLongY(psp);
        int jump_adj = psp.jump_grav;
        if ((psp.jump_speed += jump_adj) > 0) {
            Heart.DoBeginPanelFall(psp);
            return;
        }
        Panel.setLong(psp, x, y += psp.jump_speed * 3);
    }

    private static void DoBeginPanelFall(Panel_Sprite psp) {
        psp.flags |= Panel.PANF_FALLING;
        psp.flags &= ~Panel.PANF_JUMPING;
        psp.jump_grav = 8000;
        Heart.DoPanelFall(psp);
    }

    private static void DoPanelFall(Panel_Sprite psp) {
        int x = Panel.castLongX(psp);
        int y = Panel.castLongY(psp);
        psp.jump_speed += psp.jump_grav;
        Panel.setLong(psp, x, y += psp.jump_speed * 3);
    }

    private static int FIXED(int msw, int lsw) {
        return msw << 16 | lsw;
    }

    private static void SpawnHeartBlood(Panel_Sprite psp) {
        PlayerStr pp = psp.PlayerP();
        Panel_Shrap hsp = HeartShrap2[0];
        int p = 0;
        while (p < HeartShrap2.length && hsp.lo_jump_speed != 0) {
            hsp = HeartShrap2[p];
            if (hsp.skip != 2 || !Sprites.MoveSkip2) {
                Panel_Sprite blood = Panel.pSpawnSprite(pp, hsp.state[Gameutils.RANDOM_P2(512) >> 8][0], 64, 0, 0);
                blood.x = psp.x + hsp.xoff;
                blood.y = psp.y + hsp.yoff;
                blood.xspeed = hsp.lo_xspeed + (Gameutils.RANDOM_RANGE(hsp.hi_xspeed - hsp.lo_xspeed >> 4) << 4);
                blood.flags |= Panel.PANF_WEAPON_SPRITE;
                blood.scale = 20000 + Gameutils.RANDOM_RANGE(30000);
                blood.jump_speed = hsp.lo_jump_speed + (Gameutils.RANDOM_RANGE(hsp.hi_jump_speed + hsp.lo_jump_speed >> 4) << 4);
                Heart.DoBeginPanelJump(blood);
            }
            ++p;
        }
    }

    public static void HeartSaveable() {
        Saveable.SaveData(ps_PresentHeart);
        Saveable.SaveData(ps_HeartRest);
        Saveable.SaveData(ps_HeartHide);
        Saveable.SaveData(ps_HeartAttack);
        Saveable.SaveData(ps_RetractHeart);
        Saveable.SaveData(ps_HeartBlood);
        Saveable.SaveData(ps_HeartBloodSmall);
        Saveable.SaveData(ps_HeartBlood);
        Saveable.SaveData(pHeartPresent);
        Saveable.SaveData(pHeartHide);
        Saveable.SaveData(pHeartRetract);
        Saveable.SaveData(pHeartRest);
        Saveable.SaveData(pHeartBlood);
        Saveable.SaveData(SpawnSmallHeartBlood);
        Saveable.SaveData(pHeartActionBlood);
        Saveable.SaveData(pHeartAction);
        Saveable.SaveData(pHeartAttack);
    }

    private static class Panel_Shrap {
        public int xoff;
        public int yoff;
        public int skip;
        public int lo_jump_speed;
        public int hi_jump_speed;
        public int lo_xspeed;
        public int hi_xspeed;
        public Panel_State[][] state;

        public Panel_Shrap(int xoff, int yoff, int skip, int lo_jump_speed, int hi_jump_speed, int lo_xspeed, int hi_xspeed, Panel_State[][] state) {
            this.xoff = xoff;
            this.yoff = yoff;
            this.skip = skip;
            this.lo_jump_speed = lo_jump_speed;
            this.hi_jump_speed = hi_jump_speed;
            this.lo_xspeed = lo_xspeed;
            this.hi_xspeed = hi_xspeed;
            this.state = state;
        }
    }
}

