/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.AI;

import ru.m210projects.Blood.AI.AISTATE;
import ru.m210projects.Blood.AI.AISTATEFUNC;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.EVENT;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Tile;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Trigger;
import ru.m210projects.Blood.Types.CALLPROC;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.EXPLODE;
import ru.m210projects.Blood.Types.GENDUDESND;
import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.Types.Seq.SeqInst;
import ru.m210projects.Blood.Types.THINGINFO;
import ru.m210projects.Blood.Types.VECTORDATA;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;

public class AIUNICULT {
    public static final int kSlopeThrow = -8192;
    public static final int kMaxGenDudeSndMode = 11;
    public static AISTATE[] GDXGenDudeIdle = new AISTATE[3];
    public static AISTATE[] GDXGenDudeSearch = new AISTATE[3];
    public static AISTATE[] GDXGenDudeGoto = new AISTATE[3];
    public static AISTATE[] GDXGenDudeDodge = new AISTATE[3];
    public static AISTATE[] GDXGenDudeDodgeDmg = new AISTATE[3];
    public static AISTATE[] GDXGenDudeChase = new AISTATE[3];
    public static AISTATE[] GDXGenDudeFire = new AISTATE[3];
    public static AISTATE[] GDXGenDudeRecoil = new AISTATE[3];
    public static AISTATE GDGenDudeThrow;
    public static AISTATE GDGenDudeThrow2;
    public static AISTATE GDXGenDudePunch;
    public static AISTATE GDXGenDudeRTesla;
    public static final GENDUDESND[] gCustomDudeSnd;

    public static void Init() {
        AIUNICULT.GDXGenDudeIdle[0] = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, false, false, true, null){

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiThinkTarget(sprite, xsprite);
            }
        };
        AIUNICULT.GDXGenDudeIdle[1] = new AISTATE(AISTATEFUNC.Type.idle, 13, null, 0, false, false, true, null){

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiThinkTarget(sprite, xsprite);
            }
        };
        AIUNICULT.GDXGenDudeSearch[0] = new AISTATE(AISTATEFUNC.Type.search, 9, null, 600, false, true, true, GDXGenDudeIdle[0]){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AIUNICULT.aiGenDudeMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIUNICULT.thinkSearch(sprite, xsprite);
            }
        };
        AIUNICULT.GDXGenDudeSearch[1] = new AISTATE(AISTATEFUNC.Type.search, 13, null, 600, false, true, true, GDXGenDudeIdle[1]){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AIUNICULT.aiGenDudeMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIUNICULT.thinkSearch(sprite, xsprite);
            }
        };
        AIUNICULT.GDXGenDudeGoto[0] = new AISTATE(AISTATEFUNC.Type.other, 9, null, 600, false, true, true, GDXGenDudeIdle[0]){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AIUNICULT.aiGenDudeMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIUNICULT.thinkGoto(sprite, xsprite);
            }
        };
        AIUNICULT.GDXGenDudeGoto[1] = new AISTATE(AISTATEFUNC.Type.tgoto, 13, null, 600, false, true, true, GDXGenDudeIdle[1]){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AIUNICULT.aiGenDudeMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIUNICULT.thinkGoto(sprite, xsprite);
            }
        };
        AIUNICULT.GDXGenDudeChase[0] = new AISTATE(AISTATEFUNC.Type.other, 9, null, 0, false, true, true, null){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AIUNICULT.aiGenDudeMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIUNICULT.thinkChase(sprite, xsprite);
            }
        };
        AIUNICULT.GDXGenDudeChase[2] = new AISTATE(AISTATEFUNC.Type.other, 14, null, 0, false, true, true, null){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AIUNICULT.aiGenDudeMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIUNICULT.thinkChase(sprite, xsprite);
            }
        };
        AIUNICULT.GDXGenDudeChase[1] = new AISTATE(AISTATEFUNC.Type.other, 13, null, 0, false, true, true, null){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AIUNICULT.aiGenDudeMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIUNICULT.thinkChase(sprite, xsprite);
            }
        };
        AIUNICULT.GDXGenDudeDodge[0] = new AISTATE(AISTATEFUNC.Type.other, 9, null, 90, false, true, false, GDXGenDudeChase[0]){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveDodge(sprite, xsprite);
            }
        };
        AIUNICULT.GDXGenDudeDodge[2] = new AISTATE(AISTATEFUNC.Type.other, 14, null, 90, false, true, false, GDXGenDudeChase[2]){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveDodge(sprite, xsprite);
            }
        };
        AIUNICULT.GDXGenDudeDodge[1] = new AISTATE(AISTATEFUNC.Type.other, 13, null, 90, false, true, false, GDXGenDudeChase[1]){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveDodge(sprite, xsprite);
            }
        };
        AIUNICULT.GDXGenDudeDodgeDmg[0] = new AISTATE(AISTATEFUNC.Type.other, 9, null, 60, false, true, false, GDXGenDudeChase[0]){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveDodge(sprite, xsprite);
            }
        };
        AIUNICULT.GDXGenDudeDodgeDmg[2] = new AISTATE(AISTATEFUNC.Type.other, 14, null, 60, false, true, false, GDXGenDudeChase[2]){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveDodge(sprite, xsprite);
            }
        };
        AIUNICULT.GDXGenDudeDodgeDmg[1] = new AISTATE(AISTATEFUNC.Type.other, 13, null, 60, false, true, false, GDXGenDudeChase[1]){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveDodge(sprite, xsprite);
            }
        };
        CALLPROC attack = new CALLPROC(){

            @Override
            public void run(int nXSprite) {
                AIUNICULT.GDXCultistAttack1(nXSprite);
            }
        };
        AIUNICULT.GDXGenDudeFire[0] = new AISTATE(AISTATEFUNC.Type.other, 6, attack, 0, false, true, true, GDXGenDudeFire[0]){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveTurn(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIUNICULT.thinkChase(sprite, xsprite);
            }
        };
        AIUNICULT.GDXGenDudeFire[1] = new AISTATE(AISTATEFUNC.Type.other, 8, attack, 0, false, true, true, GDXGenDudeFire[1]){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveTurn(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIUNICULT.thinkChase(sprite, xsprite);
            }
        };
        AIUNICULT.GDXGenDudeFire[2] = new AISTATE(AISTATEFUNC.Type.other, 8, attack, 0, false, true, true, GDXGenDudeFire[2]){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveTurn(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIUNICULT.thinkChase(sprite, xsprite);
            }
        };
        GDGenDudeThrow = new AISTATE(AISTATEFUNC.Type.other, 7, new CALLPROC(){

            @Override
            public void run(int nXSprite) {
                AIUNICULT.ThrowCallback(nXSprite, true);
            }
        }, 0, false, false, false, GDXGenDudeChase[0]);
        GDGenDudeThrow2 = new AISTATE(AISTATEFUNC.Type.other, 7, new CALLPROC(){

            @Override
            public void run(int nXSprite) {
                AIUNICULT.ThrowCallback(nXSprite, false);
            }
        }, 0, false, false, false, GDXGenDudeChase[0]);
        GDXGenDudeRTesla = new AISTATE(AISTATEFUNC.Type.other, 4, null, 0, false, false, false, GDXGenDudeDodge[0]);
        AIUNICULT.GDXGenDudeRecoil[0] = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, false, false, false, GDXGenDudeChase[0]);
        AIUNICULT.GDXGenDudeRecoil[1] = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, false, false, false, GDXGenDudeChase[1]);
        AIUNICULT.GDXGenDudeRecoil[2] = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, false, false, false, GDXGenDudeChase[2]);
        GDXGenDudePunch = new AISTATE(AISTATEFUNC.Type.other, 10, new CALLPROC(){

            @Override
            public void run(int nXSprite) {
                AIUNICULT.punchCallback(nXSprite);
            }
        }, 0, false, false, true, GDXGenDudeChase[0]){
            final boolean punch = false;

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                if (SeqHandling.seqFrame(3, sprite.extra) == -1) {
                    short nXSprite = sprite.extra;
                    AIUNICULT.punchCallback(nXSprite);
                }
            }
        };
    }

    private static void punchCallback(int nXIndex) {
        XSPRITE pXSprite = DB.xsprite[nXIndex];
        int nSprite = pXSprite.reference;
        SPRITE pSprite = Engine.sprite[nSprite];
        short nAngle = Main.engine.getangle(pXSprite.targetX - pSprite.x, pXSprite.targetY - pSprite.y);
        int nZOffset1 = DudeInfo.dudeInfo[pSprite.lotag - 200].eyeHeight;
        int nZOffset2 = 0;
        if (pXSprite.target != -1) {
            SPRITE pTarget = Engine.sprite[pXSprite.target];
            if (Actor.IsDudeSprite(pTarget)) {
                nZOffset2 = DudeInfo.dudeInfo[pTarget.lotag - 200].eyeHeight;
            }
            int dx = Trig.Cos(nAngle) >> 16;
            int dy = Trig.Sin(nAngle) >> 16;
            int dz = nZOffset1 - nZOffset2;
            if (!AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 9)) {
                SOUND.sfxStart3DSound(pSprite, 530, 1, 0);
            }
            Actor.actFireVector(pSprite, 0, 0, dx, dy, dz, 22);
        }
    }

    private static void GDXCultistAttack1(int nXIndex) {
        XSPRITE pXSprite = DB.xsprite[nXIndex];
        int nSprite = pXSprite.reference;
        SPRITE pSprite = Engine.sprite[nSprite];
        short weapon = pXSprite.data1;
        if (weapon >= 0 && weapon < 23) {
            short vector = weapon;
            int dx = Trig.Cos(pSprite.ang) >> 16;
            int dy = Trig.Sin(pSprite.ang) >> 16;
            int dz = Ai.gDudeSlope[nXIndex];
            VECTORDATA pVectorData = Actor.gVectorData[vector];
            int vdist = pVectorData.maxDist;
            if (vdist <= 0 || vdist > 1280) {
                dx += Gameutils.BiRandom2(3000 - 1000 * Globals.pGameInfo.nDifficulty);
                dy += Gameutils.BiRandom2(3000 - 1000 * Globals.pGameInfo.nDifficulty);
                dz += Gameutils.BiRandom2(1000 - 500 * Globals.pGameInfo.nDifficulty);
            }
            Actor.actFireVector(pSprite, 0, 0, dx, dy, dz, vector);
            if (!AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 7)) {
                Actor.sfxPlayVectorSound(pSprite, vector);
            }
        } else if (weapon >= 200 && weapon < 256) {
            SPRITE pSpawned = null;
            int dist = pSprite.clipdist * 6;
            pSpawned = Actor.actSpawnDude(pSprite, weapon, dist);
            if (pSpawned == null) {
                return;
            }
            int n = nSprite;
            Ai.aiThinkTime[n] = Ai.aiThinkTime[n] + 1;
            pSpawned.owner = (short)nSprite;
            pSpawned.x += dist + Gameutils.BiRandom(dist);
            if (pSpawned.extra > -1) {
                DB.xsprite[pSpawned.extra].target = pXSprite.target;
                if (pXSprite.target > -1) {
                    Ai.aiActivateDude(pSpawned, DB.xsprite[pSpawned.extra]);
                }
            }
            ++LEVELS.totalKills;
            if (!AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 7)) {
                SOUND.sfxStart3DSoundCP(pSprite, 379, 1, 0, 65536 - Gameutils.BiRandom(12288), 0);
            }
            if (Gameutils.Chance(13568)) {
                int state = AIUNICULT.checkAttackState(pSprite, pXSprite);
                switch (state) {
                    case 1: {
                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeDodge[1]);
                        break;
                    }
                    case 2: {
                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeDodge[2]);
                        break;
                    }
                    default: {
                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeDodge[0]);
                    }
                }
            }
        } else if (weapon >= 300 && weapon < 318) {
            int dx = Trig.Cos(pSprite.ang) >> 16;
            int dy = Trig.Sin(pSprite.ang) >> 16;
            int dz = Ai.gDudeSlope[nXIndex];
            Actor.actFireMissile(pSprite, 0, 0, dx += Gameutils.BiRandom2(3000 - 1000 * Globals.pGameInfo.nDifficulty), dy += Gameutils.BiRandom2(3000 - 1000 * Globals.pGameInfo.nDifficulty), dz += Gameutils.BiRandom2(1000 - 500 * Globals.pGameInfo.nDifficulty), weapon);
            if (!AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 7)) {
                Actor.sfxPlayMissileSound(pSprite, weapon);
            }
        }
    }

    private static void ThrowCallback(int nXIndex, boolean impact) {
        XSPRITE pXSprite = DB.xsprite[nXIndex];
        int nSprite = pXSprite.reference;
        SPRITE pSprite = Engine.sprite[nSprite];
        if (pXSprite.target < 0 || pXSprite.target >= Globals.kMaxSprites) {
            return;
        }
        SPRITE pTarget = Engine.sprite[pXSprite.target];
        if (pSprite.lotag < 200 || pSprite.lotag >= 256) {
            return;
        }
        short thingType = pXSprite.data1;
        if (thingType >= 400 && thingType < 436) {
            THINGINFO pThinkInfo = Actor.thingInfo[thingType - 400];
            if (pThinkInfo.allowThrow == 1) {
                if (!AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 8)) {
                    SOUND.sfxStart3DSound(pSprite, 455, -1, 0);
                }
                int dx = pTarget.x - pSprite.x;
                int dy = pTarget.y - pSprite.y;
                int dz = pTarget.z - pSprite.z;
                int dist = (int)Main.engine.qdist(dx, dy);
                int zThrow = 14500;
                SPRITE pThing = null;
                SPRITE pLeech = null;
                XSPRITE pXLeech = null;
                if (thingType == 435) {
                    pLeech = AIUNICULT.leechIsDropped(pSprite);
                    if (pLeech != null) {
                        pXLeech = DB.xsprite[pLeech.extra];
                        AIUNICULT.removeLeech(pLeech);
                    }
                    zThrow = 5000;
                }
                if ((pThing = Actor.actFireThing(nSprite, 0, 0, dz / 128 - zThrow, thingType, Pragmas.divscale(dist / 540, 120L, 23))) == null) {
                    return;
                }
                if (pThing.lotag != 434) {
                    if (pThinkInfo.picnum < 0) {
                        pThing.picnum = 0;
                    } else {
                        Tile.tileLoadVoxel(pThinkInfo.picnum);
                    }
                }
                pThing.owner = pSprite.xvel;
                switch (thingType) {
                    case 428: {
                        impact = true;
                        pThing.xrepeat = (short)24;
                        pThing.yrepeat = (short)24;
                        DB.xsprite[pThing.extra].data4 = 3 + Globals.pGameInfo.nDifficulty;
                        break;
                    }
                    case 434: {
                        int[] sPics = new int[]{2406, 2280, 2185, 2155, 2620, 3135};
                        pThing.picnum = (short)sPics[Gameutils.Random(5)];
                        pThing.pal = (short)5;
                        pThing.cstat = (short)(pThing.cstat | 1);
                        pThing.xrepeat = (short)(24 + Gameutils.Random(42));
                        pThing.yrepeat = (short)(24 + Gameutils.Random(42));
                        if (Gameutils.Chance(12288)) {
                            pThing.cstat = (short)(pThing.cstat | 4);
                        }
                        if (Gameutils.Chance(12288)) {
                            pThing.cstat = (short)(pThing.cstat | 8);
                        }
                        DB.xsprite[pThing.extra].data1 = pThing.xrepeat > 60 ? (short)43 : (pThing.xrepeat > 40 ? (short)33 : (pThing.xrepeat > 30 ? (short)23 : (short)12));
                        impact = false;
                        return;
                    }
                    case 400: 
                    case 401: 
                    case 420: {
                        impact = false;
                        break;
                    }
                    case 433: {
                        DB.xsprite[pThing.extra].state = 0;
                        DB.xsprite[pThing.extra].Proximity = true;
                        return;
                    }
                    case 431: 
                    case 435: {
                        XSPRITE pXThing = DB.xsprite[pThing.extra];
                        pXThing.health = pLeech != null ? pXLeech.health : 300 * Globals.pGameInfo.nDifficulty;
                        SOUND.sfxStart3DSound(pSprite, 490, -1, 0);
                        pXThing.data3 = Globals.pGameInfo.nDifficulty <= 2 ? (short)32700 : (short)Gameutils.Random(10);
                        pThing.pal = (short)6;
                        pXThing.target = pTarget.xvel;
                        pXThing.Proximity = true;
                        pXThing.stateTimer = 1;
                        EVENT.evPostCallback(pThing.xvel, 3, 80L, 20);
                        return;
                    }
                }
                if (impact && dist <= 7680) {
                    DB.xsprite[pThing.extra].Impact = true;
                } else {
                    DB.xsprite[pThing.extra].Impact = false;
                    EVENT.evPost(pThing.xvel, 3, 120 * Gameutils.Random(2) + 120, 1);
                }
                return;
            }
        }
    }

    private static void thinkSearch(SPRITE pSprite, XSPRITE pXSprite) {
        Ai.aiChooseDirection(pSprite, pXSprite, pXSprite.goalAng);
        Ai.aiThinkTarget2(pSprite, pXSprite);
    }

    private static void thinkGoto(SPRITE pSprite, XSPRITE pXSprite) {
        if (pSprite.lotag < 200 || pSprite.lotag >= 256) {
            Main.game.dassert("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int dx = pXSprite.targetX - pSprite.x;
        int dy = pXSprite.targetY - pSprite.y;
        short nAngle = Main.engine.getangle(dx, dy);
        int dist = (int)Main.engine.qdist(dx, dy);
        Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
        if (dist < Gameutils.M2X(10.0) && Pragmas.klabs(pSprite.ang - nAngle) < pDudeInfo.periphery) {
            if (AIUNICULT.spriteIsUnderwater(pSprite, false)) {
                Ai.aiNewState(pSprite, pXSprite, GDXGenDudeSearch[1]);
            } else {
                Ai.aiNewState(pSprite, pXSprite, GDXGenDudeSearch[0]);
            }
        }
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void thinkChase(SPRITE pSprite, XSPRITE pXSprite) {
        int vdist;
        int losAngle;
        int dist;
        block82: {
            block83: {
                int state;
                block86: {
                    block87: {
                        VECTORDATA meleeVector;
                        SPRITE pTarget;
                        block85: {
                            SPRITE pLeech;
                            block84: {
                                int defDist;
                                PLAYER pPlayer;
                                if (pSprite.lotag < 200 || pSprite.lotag >= 256) {
                                    Main.game.dassert("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
                                } else {
                                    if (pXSprite.target <= -1) {
                                        if (AIUNICULT.spriteIsUnderwater(pSprite, false)) {
                                            Ai.aiNewState(pSprite, pXSprite, GDXGenDudeGoto[1]);
                                            return;
                                        }
                                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeGoto[0]);
                                        return;
                                    }
                                    if (pXSprite.target >= Globals.kMaxSprites) {
                                        Main.game.dassert("pXSprite.target >= 0 && pXSprite.target < kMaxSprites");
                                    }
                                }
                                DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
                                pTarget = Engine.sprite[pXSprite.target];
                                XSPRITE pXTarget = !Actor.IsDudeSprite(pTarget) || pTarget.extra < 0 ? null : DB.xsprite[pTarget.extra];
                                int dx = pTarget.x - pSprite.x;
                                int dy = pTarget.y - pSprite.y;
                                Ai.aiChooseDirection(pSprite, pXSprite, Main.engine.getangle(dx, dy));
                                if (pXTarget == null || pXTarget.health == 0) {
                                    if (AIUNICULT.spriteIsUnderwater(pSprite, false)) {
                                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeSearch[1]);
                                        return;
                                    }
                                    Ai.aiNewState(pSprite, pXSprite, GDXGenDudeSearch[0]);
                                    AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 5);
                                    return;
                                }
                                if (Gameutils.IsPlayerSprite(pTarget) && PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.lotag - 231], 13) > 0) {
                                    if (AIUNICULT.spriteIsUnderwater(pSprite, false)) {
                                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeSearch[1]);
                                        return;
                                    }
                                    Ai.aiNewState(pSprite, pXSprite, GDXGenDudeSearch[0]);
                                    return;
                                }
                                dist = (int)Main.engine.qdist(dx, dy);
                                if (dist == 0) {
                                    dist = 1;
                                }
                                int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.yrepeat << 2;
                                if (dist > pDudeInfo.seeDist || !Main.engine.cansee(pTarget.x, pTarget.y, pTarget.z, pTarget.sectnum, pSprite.x, pSprite.y, pSprite.z - eyeAboveZ, pSprite.sectnum)) {
                                    if (AIUNICULT.spriteIsUnderwater(pSprite, false)) {
                                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeGoto[1]);
                                    } else {
                                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeGoto[0]);
                                    }
                                    pXSprite.target = -1;
                                    return;
                                }
                                short nAngle = Main.engine.getangle(dx, dy);
                                losAngle = (1024 + nAngle - pSprite.ang & 0x7FF) - 1024;
                                if (dist >= pDudeInfo.seeDist) return;
                                if (Pragmas.klabs(losAngle) > pDudeInfo.periphery) return;
                                if (pXSprite.target < 0) {
                                    Ai.aiSetTarget(pXSprite, pXSprite.target);
                                }
                                if ((Globals.gFrameClock & 0x40) == 0 && Gameutils.Chance(4096) && !AIUNICULT.spriteIsUnderwater(pSprite, false)) {
                                    AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 6);
                                }
                                Ai.gDudeSlope[Engine.sprite[pXSprite.reference].extra] = Pragmas.divscale(pTarget.z - pSprite.z, dist, 10);
                                pLeech = null;
                                meleeVector = Actor.gVectorData[22];
                                if (pXSprite.data1 >= 400 && pXSprite.data1 < 436) {
                                    if (pXSprite.data1 == 431) {
                                        pXSprite.data1 = (short)435;
                                    }
                                    if ((pLeech = AIUNICULT.leechIsDropped(pSprite)) != null && DB.xsprite[pLeech.extra].target != pXSprite.target) {
                                        DB.xsprite[pLeech.extra].target = pXSprite.target;
                                    }
                                    if (Pragmas.klabs(losAngle) >= 85) return;
                                    if (dist < 12264 && dist > 7680 && !AIUNICULT.spriteIsUnderwater(pSprite, false) && pXSprite.data1 != 435) {
                                        int pHit = Gameutils.HitScan(pSprite, pSprite.z, dx, dy, 0, Engine.pHitInfo, 0x1000040, 0);
                                        switch (pHit) {
                                            case 0: 
                                            case 4: {
                                                return;
                                            }
                                        }
                                        Ai.aiNewState(pSprite, pXSprite, GDGenDudeThrow);
                                        return;
                                    }
                                    if (dist > 4072 && dist <= 9072 && !AIUNICULT.spriteIsUnderwater(pSprite, false) && pSprite.owner != 32666) {
                                        switch (pXSprite.data1) {
                                            case 435: {
                                                if (pLeech == null) {
                                                    Ai.aiNewState(pSprite, pXSprite, GDGenDudeThrow2);
                                                    AIUNICULT.GDGenDudeThrow2.next = GDXGenDudeDodge[0];
                                                    return;
                                                }
                                                XSPRITE pXLeech = DB.xsprite[pLeech.extra];
                                                int ldist = Trigger.getTargetDist(pTarget, pDudeInfo, pLeech);
                                                if (ldist > 3 || !Main.engine.cansee(pTarget.x, pTarget.y, pTarget.z, pTarget.sectnum, pLeech.x, pLeech.y, pLeech.z, pLeech.sectnum) || pXLeech.target == -1) {
                                                    Ai.aiNewState(pSprite, pXSprite, GDGenDudeThrow2);
                                                    AIUNICULT.GDGenDudeThrow2.next = GDXGenDudeDodge[0];
                                                    return;
                                                }
                                                AIUNICULT.GDGenDudeThrow2.next = GDXGenDudeChase[0];
                                                if (pXLeech.target != pXSprite.target) {
                                                    pXLeech.target = pXSprite.target;
                                                }
                                                if (dist > 5072 && Gameutils.Chance(12288)) {
                                                    if (AIUNICULT.canDuck(pSprite) && !Gameutils.Chance(8192)) {
                                                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeDodge[2]);
                                                        return;
                                                    }
                                                    Ai.aiNewState(pSprite, pXSprite, GDXGenDudeDodge[0]);
                                                    return;
                                                }
                                                Ai.aiNewState(pSprite, pXSprite, GDXGenDudeChase[0]);
                                                return;
                                            }
                                            case 434: {
                                                if (Gameutils.Chance(8192)) {
                                                    Ai.aiNewState(pSprite, pXSprite, GDGenDudeThrow2);
                                                    return;
                                                }
                                                AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 0);
                                                return;
                                            }
                                        }
                                        Ai.aiNewState(pSprite, pXSprite, GDGenDudeThrow2);
                                        return;
                                    }
                                    if (dist <= meleeVector.maxDist) {
                                        if (AIUNICULT.spriteIsUnderwater(pSprite, false)) {
                                            if (Gameutils.Chance(28672)) {
                                                Ai.aiNewState(pSprite, pXSprite, GDXGenDudePunch);
                                                return;
                                            }
                                            Ai.aiNewState(pSprite, pXSprite, GDXGenDudeDodge[1]);
                                            return;
                                        }
                                        if (Gameutils.Chance(28672)) {
                                            Ai.aiNewState(pSprite, pXSprite, GDXGenDudePunch);
                                            return;
                                        }
                                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeDodge[0]);
                                        return;
                                    }
                                    int state2 = AIUNICULT.checkAttackState(pSprite, pXSprite);
                                    if (state2 == 1) {
                                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeChase[1]);
                                        return;
                                    }
                                    if (state2 != 2) {
                                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeChase[0]);
                                        return;
                                    }
                                    if (Gameutils.Chance(12288)) {
                                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeChase[2]);
                                        return;
                                    }
                                    Ai.aiNewState(pSprite, pXSprite, GDXGenDudeChase[0]);
                                    return;
                                }
                                vdist = defDist = 17920;
                                if (pXSprite.data1 <= 0 || pXSprite.data1 >= 23) break block84;
                                switch (pXSprite.data1) {
                                    case 19: {
                                        pXSprite.data1 = (short)2;
                                        break;
                                    }
                                }
                                VECTORDATA pVectorData = Actor.gVectorData[pXSprite.data1];
                                vdist = pVectorData.maxDist;
                                if (vdist <= 0 || vdist > defDist) {
                                    vdist = defDist;
                                }
                                break block82;
                            }
                            if (pXSprite.data1 >= 200 && pXSprite.data1 < 256) {
                                if (Ai.aiThinkTime[pSprite.xvel] > 0) {
                                    AIUNICULT.updateTargetOfSlaves(pSprite);
                                    if (pXSprite.target >= 0 && Engine.sprite[pXSprite.target].owner == pSprite.xvel) {
                                        Ai.aiSetTarget(pXSprite, pSprite.x, pSprite.y, pSprite.z);
                                        return;
                                    }
                                }
                                int state3 = AIUNICULT.checkAttackState(pSprite, pXSprite);
                                if (Ai.aiThinkTime[pSprite.xvel] <= Globals.pGameInfo.nDifficulty && dist > meleeVector.maxDist) {
                                    vdist = vdist / 2 + Gameutils.Random(vdist / 2);
                                    break block82;
                                } else {
                                    if (dist <= meleeVector.maxDist) {
                                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudePunch);
                                        return;
                                    }
                                    if (state3 == 1) {
                                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeChase[1]);
                                        return;
                                    }
                                    if (state3 == 2) {
                                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeChase[2]);
                                        return;
                                    }
                                    Ai.aiNewState(pSprite, pXSprite, GDXGenDudeChase[0]);
                                    return;
                                }
                            }
                            if (pXSprite.data1 < 300 || pXSprite.data1 >= 318) break block85;
                            int state4 = AIUNICULT.checkAttackState(pSprite, pXSprite);
                            int mdist = pXSprite.data1 != 303 ? 3000 : 2500;
                            switch (pXSprite.data1) {
                                case 315: {
                                    pLeech = AIUNICULT.leechIsDropped(pSprite);
                                    if (pLeech == null) break;
                                    AIUNICULT.removeLeech(pLeech);
                                    break;
                                }
                                case 303: 
                                case 305: 
                                case 312: 
                                case 313: 
                                case 314: {
                                    if (dist > mdist || pXSprite.Locked == 1) break;
                                    if (dist <= meleeVector.maxDist && Gameutils.Chance(28672)) {
                                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudePunch);
                                        return;
                                    }
                                    if (state4 == 1) {
                                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeChase[1]);
                                        return;
                                    }
                                    if (state4 == 2) {
                                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeChase[2]);
                                        return;
                                    }
                                    Ai.aiNewState(pSprite, pXSprite, GDXGenDudeChase[0]);
                                    return;
                                }
                                case 304: 
                                case 308: {
                                    if (AIUNICULT.spriteIsUnderwater(pSprite, false)) {
                                        if (dist > meleeVector.maxDist) {
                                            Ai.aiNewState(pSprite, pXSprite, GDXGenDudeChase[1]);
                                            return;
                                        }
                                        if (Gameutils.Chance(16384)) {
                                            Ai.aiNewState(pSprite, pXSprite, GDXGenDudePunch);
                                            return;
                                        }
                                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeDodge[1]);
                                        return;
                                    }
                                    vdist = 4200;
                                    if ((Globals.gFrameClock & 0x10) != 0) break;
                                    vdist += Gameutils.Random(800);
                                }
                            }
                            break block82;
                        }
                        if (pXSprite.data1 >= 459 && pXSprite.data1 < 467) {
                            int nType = pXSprite.data1 - 459;
                            EXPLODE pExpl = Actor.gExplodeData[nType];
                            boolean inRange = Gameutils.CheckProximity(pSprite, pTarget.x, pTarget.y, pTarget.z, pTarget.sectnum, pExpl.radius / 2);
                            if (pExpl == null) return;
                            if (!inRange) return;
                            if (!AIUNICULT.doExplosion(pSprite, nType)) return;
                            Actor.actKillSprite(pSprite.xvel, pSprite, 3, 65535);
                            return;
                        }
                        state = AIUNICULT.checkAttackState(pSprite, pXSprite);
                        if (Gameutils.Chance(1280) && !AIUNICULT.spriteIsUnderwater(pSprite, false)) {
                            AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 6);
                        }
                        if (!Gameutils.Chance(512)) break block86;
                        if (dist > meleeVector.maxDist) break block87;
                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudePunch);
                        break block83;
                    }
                    if (state == 1) {
                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeDodge[1]);
                        break block83;
                    } else if (state == 2) {
                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeDodge[2]);
                        break block83;
                    } else {
                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeDodge[0]);
                    }
                    break block83;
                }
                if (state == 1) {
                    Ai.aiNewState(pSprite, pXSprite, GDXGenDudeSearch[1]);
                } else {
                    Ai.aiNewState(pSprite, pXSprite, GDXGenDudeSearch[0]);
                }
            }
            Ai.aiSetTarget(pXSprite, pSprite.x, pSprite.y, pSprite.z);
            return;
        }
        if (dist <= vdist && pXSprite.aiState == GDXGenDudeChase[2]) {
            Ai.aiNewState(pSprite, pXSprite, GDXGenDudeChase[0]);
        }
        int state = AIUNICULT.checkAttackState(pSprite, pXSprite);
        if (dist < vdist && Pragmas.klabs(losAngle) < 28) {
            switch (state) {
                case 1: {
                    Ai.aiNewState(pSprite, pXSprite, GDXGenDudeFire[1]);
                    pXSprite.aiState.next = GDXGenDudeFire[1];
                    return;
                }
                case 2: {
                    Ai.aiNewState(pSprite, pXSprite, GDXGenDudeFire[2]);
                    pXSprite.aiState.next = GDXGenDudeFire[2];
                    return;
                }
            }
            Ai.aiNewState(pSprite, pXSprite, GDXGenDudeFire[0]);
            pXSprite.aiState.next = GDXGenDudeFire[0];
            return;
        }
        int nSeq = state < 3 ? 8 : 6;
        SeqInst pInst = SeqHandling.GetInstance(3, pSprite.extra);
        if (pInst.getSeqIndex() == DB.xsprite[pSprite.extra].data2 + nSeq) {
            if (state == 1) {
                pXSprite.aiState.next = GDXGenDudeChase[1];
                return;
            }
            if (state == 2) {
                pXSprite.aiState.next = GDXGenDudeChase[2];
                return;
            }
            pXSprite.aiState.next = GDXGenDudeChase[0];
            return;
        }
        if (state == 1 && pXSprite.aiState != GDXGenDudeChase[1] && pXSprite.aiState != GDXGenDudeFire[1]) {
            Ai.aiNewState(pSprite, pXSprite, GDXGenDudeChase[1]);
            pXSprite.aiState.next = GDXGenDudeFire[1];
            return;
        }
        if (state == 2 && pXSprite.aiState != GDXGenDudeChase[2] && pXSprite.aiState != GDXGenDudeFire[2]) {
            Ai.aiNewState(pSprite, pXSprite, GDXGenDudeChase[2]);
            pXSprite.aiState.next = GDXGenDudeFire[2];
            return;
        }
        if (pXSprite.aiState == GDXGenDudeChase[0]) return;
        if (pXSprite.aiState == GDXGenDudeFire[0]) return;
        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeChase[0]);
        pXSprite.aiState.next = GDXGenDudeFire[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int checkAttackState(SPRITE pSprite, XSPRITE pXSprite) {
        if (!AIUNICULT.checkUniCultistSeq(pSprite, 14) && !AIUNICULT.spriteIsUnderwater(pSprite, false)) return 3;
        if (AIUNICULT.checkUniCultistSeq(pSprite, 14) && !AIUNICULT.spriteIsUnderwater(pSprite, false)) return 2;
        if (!AIUNICULT.spriteIsUnderwater(pSprite, false)) return 0;
        return 1;
    }

    public static boolean checkUniCultistSeq(SPRITE pSprite, int nSeqID) {
        if (pSprite.statnum == 6 && Actor.IsDudeSprite(pSprite)) {
            SeqInst pInst = SeqHandling.GetInstance(3, pSprite.extra);
            return pInst.getSeqIndex() == DB.xsprite[pSprite.extra].data2 + nSeqID && SeqHandling.seqFrame(3, pSprite.extra) >= 0;
        }
        return false;
    }

    public static boolean TargetNearThing(SPRITE pSprite, int thingType) {
        short nSprite = Engine.headspritesect[pSprite.sectnum];
        while (nSprite >= 0) {
            if (Engine.sprite[nSprite].lotag == thingType || Engine.sprite[nSprite].statnum == 2) {
                return true;
            }
            nSprite = Engine.nextspritesect[nSprite];
        }
        return false;
    }

    public static long getGenDudeMoveSpeed(SPRITE pSprite, int which, boolean mul, boolean shift) {
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        XSPRITE pXSprite = DB.xsprite[pSprite.extra];
        int speed = -1;
        int step = 2500;
        int maxSpeed = 146603;
        switch (which) {
            case 0: {
                speed = pDudeInfo.frontSpeed;
                break;
            }
            case 1: {
                speed = pDudeInfo.sideSpeed;
                break;
            }
            case 2: {
                speed = pDudeInfo.backSpeed;
                break;
            }
            case 3: {
                speed = pDudeInfo.angSpeed;
                break;
            }
            default: {
                return -1L;
            }
        }
        if (pXSprite.busyTime > 0) {
            speed /= 3;
        }
        if (speed > 0 && mul && pXSprite.busyTime > 0) {
            speed += step * pXSprite.busyTime;
        }
        if (shift) {
            speed *= Globals.kFrameTicks >> 4;
        }
        if (speed > maxSpeed) {
            speed = maxSpeed;
        }
        return speed;
    }

    public static void aiGenDudeMoveForward(SPRITE pSprite, XSPRITE pXSprite) {
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.goalAng - pSprite.ang & 0x7FF) - 1024;
        pSprite.ang = (short)(pSprite.ang + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF);
        if (Pragmas.klabs(dang) > 341) {
            return;
        }
        int sin = Trig.Sin(pSprite.ang);
        int cos = Trig.Cos(pSprite.ang);
        long frontSpeed = AIUNICULT.getGenDudeMoveSpeed(pSprite, 0, true, false);
        short s = pSprite.xvel;
        Actor.sprXVel[s] = Actor.sprXVel[s] + (long)Pragmas.mulscale(cos, frontSpeed, 30);
        short s2 = pSprite.xvel;
        Actor.sprYVel[s2] = Actor.sprYVel[s2] + (long)Pragmas.mulscale(sin, frontSpeed, 30);
    }

    public static boolean sfxPlayGDXGenDudeSound(SPRITE pSprite, int mode) {
        int sndId;
        if (mode < 0 || mode >= 11) {
            return false;
        }
        GENDUDESND sndInfo = gCustomDudeSnd[mode];
        boolean gotSnd = false;
        short sndStartId = DB.xsprite[pSprite.extra].data3;
        int rand = sndInfo.randomRange;
        int n = sndId = sndStartId <= 0 ? sndInfo.defaultSndId : sndStartId + sndInfo.sndIdOffset;
        if (sndId < 0) {
            return false;
        }
        if (sndStartId <= 0) {
            sndId += Gameutils.Random(rand);
            gotSnd = true;
        } else {
            int maxRetries = 5;
            while (maxRetries-- > 0) {
                int random = Gameutils.Random(rand);
                if (!BuildGdx.cache.contains(sndId + random, "sfx")) continue;
                sndId += random;
                gotSnd = true;
                break;
            }
            if (!gotSnd) {
                while (sndId++ <= sndId + rand) {
                    if (!BuildGdx.cache.contains(sndId, "sfx")) continue;
                    gotSnd = true;
                    break;
                }
            }
        }
        if (!gotSnd) {
            return false;
        }
        if (sndInfo.aiPlaySound) {
            Ai.aiPlaySound(pSprite, sndId, 2, -1);
        } else {
            SOUND.sfxStart3DSound(pSprite, sndId, -1, 0);
        }
        return true;
    }

    public static boolean spriteIsUnderwater(SPRITE pSprite, boolean oldWay) {
        if (oldWay) {
            return DB.xsprite[pSprite.extra].palette == 1 || DB.xsprite[pSprite.extra].palette == 2;
        }
        if (Engine.sector[pSprite.sectnum].extra < 0) {
            return false;
        }
        return DB.xsector[Engine.sector[pSprite.sectnum].extra].Underwater;
    }

    public static SPRITE leechIsDropped(SPRITE pSprite) {
        short nSprite = Engine.headspritestat[4];
        while (nSprite >= 0) {
            if (Engine.sprite[nSprite].lotag == 435 && Engine.sprite[nSprite].owner == pSprite.xvel) {
                return Engine.sprite[nSprite];
            }
            nSprite = Engine.nextspritestat[nSprite];
        }
        return null;
    }

    public static void removeDudeStuff(SPRITE pSprite) {
        short nSprite = Engine.headspritestat[4];
        while (nSprite >= 0) {
            if (Engine.sprite[nSprite].owner == pSprite.xvel) {
                switch (Engine.sprite[nSprite].lotag) {
                    case 401: 
                    case 402: 
                    case 433: {
                        DB.deletesprite(nSprite);
                        break;
                    }
                    case 435: {
                        AIUNICULT.killDudeLeech(Engine.sprite[nSprite]);
                    }
                }
            }
            nSprite = Engine.nextspritestat[nSprite];
        }
        nSprite = Engine.headspritestat[6];
        while (nSprite >= 0) {
            if (Engine.sprite[nSprite].owner == pSprite.xvel) {
                Actor.actDamageSprite(Engine.sprite[nSprite].owner, Engine.sprite[nSprite], 0, 65535);
            }
            nSprite = Engine.nextspritestat[nSprite];
        }
    }

    public static void removeLeech(SPRITE pLeech) {
        if (pLeech != null) {
            SPRITE pEffect = Actor.actSpawnEffect(52, pLeech.sectnum, pLeech.x, pLeech.y, pLeech.z, pLeech.ang);
            if (pEffect != null) {
                pEffect.cstat = 0;
                pEffect.pal = (short)6;
                int repeat = 64 + Gameutils.Random(50);
                pEffect.xrepeat = (short)repeat;
                pEffect.yrepeat = (short)repeat;
            }
            SOUND.sfxStart3DSoundCP(pLeech, 490, -1, 0, 60000L, 0);
            DB.deletesprite(pLeech.xvel);
        }
    }

    public static void killDudeLeech(SPRITE pLeech) {
        Actor.actDamageSprite(pLeech.owner, pLeech, 3, 65535);
        AIUNICULT.removeLeech(pLeech);
        SOUND.sfxStart3DSoundCP(pLeech, 522, -1, 0, 60000L, 0);
    }

    public static void updateTargetOfSlaves(SPRITE pSprite) {
        short nSprite = Engine.headspritestat[6];
        while (nSprite >= 0) {
            if (Engine.sprite[nSprite].owner == pSprite.xvel && Engine.sprite[nSprite].extra >= 0) {
                if (DB.xsprite[pSprite.extra].target != DB.xsprite[Engine.sprite[nSprite].extra].target && Actor.IsDudeSprite(Engine.sprite[DB.xsprite[pSprite.extra].target])) {
                    Ai.aiSetTarget(DB.xsprite[Engine.sprite[nSprite].extra], DB.xsprite[pSprite.extra].target);
                }
                if (DB.xsprite[Engine.sprite[nSprite].extra].target >= 0 && Engine.sprite[DB.xsprite[Engine.sprite[nSprite].extra].target].owner == Engine.sprite[nSprite].owner) {
                    Ai.aiSetTarget(DB.xsprite[Engine.sprite[nSprite].extra], pSprite.x, pSprite.y, pSprite.z);
                }
                if (!Trigger.isActive(Engine.sprite[nSprite].xvel) && DB.xsprite[Engine.sprite[nSprite].extra].target >= 0) {
                    Ai.aiActivateDude(Engine.sprite[nSprite], DB.xsprite[Engine.sprite[nSprite].extra]);
                }
            }
            nSprite = Engine.nextspritestat[nSprite];
        }
    }

    public static boolean dudeIsMelee(XSPRITE pXSprite) {
        int meleeDist;
        int vdist = meleeDist = 2048;
        if (pXSprite.data1 >= 0 && pXSprite.data1 < 23) {
            int vector = pXSprite.data1;
            if (vector <= 0) {
                vector = 2;
            }
            VECTORDATA pVectorData = Actor.gVectorData[vector];
            vdist = pVectorData.maxDist;
            return vdist > 0 && vdist <= meleeDist;
        }
        return pXSprite.data1 >= 459 && pXSprite.data1 < 467;
    }

    public static int getBaseChanceModifier(int baseChance) {
        return Globals.pGameInfo.nDifficulty > 0 ? baseChance - 768 * Globals.pGameInfo.nDifficulty : baseChance;
    }

    public static int getRecoilChance(SPRITE pSprite) {
        int mass = Actor.getDudeMassBySpriteSize(pSprite);
        int cumulDmg = 0;
        int baseChance = AIUNICULT.getBaseChanceModifier(24576);
        if (pSprite.extra >= 0) {
            XSPRITE pXSprite = DB.xsprite[pSprite.extra];
            baseChance += pXSprite.burnTime / 2;
            cumulDmg = Ai.cumulDamage[pSprite.extra];
            if (AIUNICULT.dudeIsMelee(pXSprite)) {
                baseChance = 1280;
            }
        }
        int chance = (baseChance += cumulDmg) / mass << 7;
        return chance;
    }

    public static int getDodgeChance(SPRITE pSprite) {
        int mass = Actor.getDudeMassBySpriteSize(pSprite);
        int baseChance = AIUNICULT.getBaseChanceModifier(8192);
        if (pSprite.extra >= 0) {
            XSPRITE pXSprite = DB.xsprite[pSprite.extra];
            baseChance += pXSprite.burnTime;
            if (AIUNICULT.dudeIsMelee(pXSprite)) {
                baseChance = 512;
            }
        }
        int chance = baseChance / mass << 7;
        return chance;
    }

    public static void dudeLeechOperate(SPRITE pSprite, XSPRITE pXSprite, int evCommand) {
        SPRITE pTarget;
        if (evCommand == 0) {
            Actor.actPostSprite(pSprite.xvel, 1024);
            return;
        }
        if (pXSprite.target >= 0 && pXSprite.target < Globals.kMaxSprites && pXSprite.stateTimer == 0 && Actor.IsDudeSprite(pTarget = Engine.sprite[pXSprite.target]) && (pTarget.hitag & 0x20) == 0 && pTarget.extra > 0 && pTarget.extra < 2048) {
            Gameutils.GetSpriteExtents(pSprite);
            DudeInfo pDudeInfo = DudeInfo.dudeInfo[pTarget.lotag - 200];
            int dz = Gameutils.extents_zTop - pSprite.z - 256;
            long dist = Main.engine.qdist(pTarget.x - pSprite.x, pTarget.y - pSprite.y);
            if (dist != 0L && Main.engine.cansee(pSprite.x, pSprite.y, Gameutils.extents_zTop, pSprite.sectnum, pTarget.x, pTarget.y, pTarget.z, pTarget.sectnum)) {
                SPRITE pMissile;
                short oldang = pSprite.ang;
                long vel = Pragmas.divscale(dist, 0x1AAAAAL, 12);
                pSprite.ang = Main.engine.getangle(Pragmas.mulscale(vel, Actor.sprXVel[pTarget.xvel], 12) + pTarget.x - pSprite.x, Pragmas.mulscale(vel, Actor.sprYVel[pTarget.xvel], 12) + pTarget.y - pSprite.y);
                int eyeAboveZ = pTarget.z - (pDudeInfo.aimHeight * pTarget.yrepeat << 2) - Gameutils.extents_zTop - 256;
                int ax = Trig.Cos(pSprite.ang) >> 16;
                int ay = Trig.Sin(pSprite.ang) >> 16;
                int az = Pragmas.divscale(eyeAboveZ, dist, 10);
                int time = 12;
                int missileType = 316;
                if (pXSprite.data3 != 0) {
                    time = 36;
                    ++missileType;
                }
                if ((pMissile = Actor.actFireMissile(pSprite, 0, dz, ax, ay, az, missileType)) != null) {
                    pMissile.owner = pSprite.owner;
                    pXSprite.stateTimer = 1;
                    pXSprite.data3 = (short)Gameutils.ClipLow(pXSprite.data3 - 1, 0);
                    EVENT.evPostCallback(pSprite.xvel, 3, time, 20);
                }
                pSprite.ang = oldang;
            }
        }
    }

    public static boolean ceilIsTooLow(SPRITE pSprite) {
        if (pSprite != null) {
            SECTOR pSector = Engine.sector[pSprite.sectnum];
            int a = pSector.ceilingz - pSector.floorz;
            Gameutils.GetSpriteExtents(pSprite);
            int b = Gameutils.extents_zTop - Gameutils.extents_zBot;
            return a > b;
        }
        return false;
    }

    public static boolean doExplosion(SPRITE pSprite, int nType) {
        int nExplosion = Actor.actSpawnSprite(pSprite.sectnum, pSprite.x, pSprite.y, pSprite.z, 2, true);
        int nSeq = 4;
        int nSnd = 304;
        EXPLODE pExpl = Actor.gExplodeData[nType];
        if (nExplosion >= 0) {
            SPRITE pExplosion = Engine.sprite[nExplosion];
            pExplosion.yrepeat = pExpl.size;
            pExplosion.xrepeat = pExpl.size;
            pExplosion.lotag = (short)nType;
            pExplosion.cstat = (short)(pExplosion.cstat | 0xFFFF8080);
            pExplosion.owner = pSprite.xvel;
            if (pExplosion.extra >= 0) {
                DB.xsprite[pExplosion.extra].target = 0;
                DB.xsprite[pExplosion.extra].data1 = (short)pExpl.liveCount;
                DB.xsprite[pExplosion.extra].data2 = (short)pExpl.quake;
                DB.xsprite[pExplosion.extra].data3 = (short)pExpl.used3;
                if (nType == 0) {
                    nSeq = 3;
                    nSnd = 303;
                    pExplosion.z = pSprite.z;
                } else if (nType == 2) {
                    nSeq = 4;
                    nSnd = 305;
                } else if (nType == 3) {
                    nSeq = 9;
                    nSnd = 307;
                } else if (nType == 4) {
                    nSeq = 5;
                    nSnd = 307;
                } else if (nType <= 6) {
                    nSeq = 4;
                    nSnd = 303;
                } else if (nType == 7) {
                    nSeq = 4;
                    nSnd = 303;
                }
                if (BuildGdx.cache.contains(nSeq, "SEQ")) {
                    SeqHandling.seqSpawn(nSeq, 3, pExplosion.extra, null);
                }
                SOUND.sfxStart3DSound(pExplosion, nSnd, -1, 0);
                return true;
            }
        }
        return false;
    }

    public static boolean canSwim(SPRITE pSprite) {
        return BuildGdx.cache.contains(DB.xsprite[pSprite.extra].data2 + 8, "SEQ") && BuildGdx.cache.contains(DB.xsprite[pSprite.extra].data2 + 13, "SEQ") && BuildGdx.cache.contains(DB.xsprite[pSprite.extra].data2 + 17, "SEQ");
    }

    public static boolean canDuck(SPRITE pSprite) {
        return BuildGdx.cache.contains(DB.xsprite[pSprite.extra].data2 + 8, "SEQ") && BuildGdx.cache.contains(DB.xsprite[pSprite.extra].data2 + 14, "SEQ");
    }

    public static boolean CDCanMove(SPRITE pSprite) {
        return BuildGdx.cache.contains(DB.xsprite[pSprite.extra].data2 + 9, "SEQ") && BuildGdx.cache.contains(DB.xsprite[pSprite.extra].data2 + 13, "SEQ") && BuildGdx.cache.contains(DB.xsprite[pSprite.extra].data2 + 14, "SEQ");
    }

    public static boolean inDodge(AISTATE aiState) {
        return aiState == GDXGenDudeDodgeDmg[1] || aiState == GDXGenDudeDodgeDmg[2] || aiState == GDXGenDudeDodgeDmg[0];
    }

    public static boolean inIdle(AISTATE aiState) {
        return aiState == GDXGenDudeIdle[1] || aiState == GDXGenDudeIdle[2] || aiState == GDXGenDudeIdle[0];
    }

    public static int getSeqStartId(XSPRITE pXSprite) {
        int seqStartId = DudeInfo.dudeInfo[Engine.sprite[pXSprite.reference].lotag - 200].seqStartID;
        if (pXSprite.data2 > 0) {
            block3: for (int i = seqStartId = (int)pXSprite.data2; i <= seqStartId + 19; ++i) {
                switch (i - seqStartId) {
                    case 3: 
                    case 4: 
                    case 8: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: {
                        continue block3;
                    }
                    default: {
                        if (BuildGdx.cache.contains(i, "SEQ")) continue block3;
                        Main.game.GameWarning("No SEQ file with ID " + i + " found for custom dude #" + pXSprite.reference + "!\nData2 (SEQ Base): " + pXSprite.data2 + "\nSwitching to default animation!");
                        pXSprite.data2 = (short)DudeInfo.dudeInfo[Engine.sprite[pXSprite.reference].lotag - 200].seqStartID;
                        return pXSprite.data2;
                    }
                }
            }
        } else {
            pXSprite.data2 = (short)seqStartId;
        }
        return seqStartId;
    }

    static {
        gCustomDudeSnd = new GENDUDESND[]{new GENDUDESND(1003, 2, 0, true), new GENDUDESND(1013, 2, 2, true), new GENDUDESND(1018, 2, 4, false), new GENDUDESND(1031, 2, 6, true), new GENDUDESND(1018, 2, 8, false), new GENDUDESND(4021, 2, 10, true), new GENDUDESND(1005, 2, 12, true), new GENDUDESND(-1, 0, 14, false), new GENDUDESND(-1, 0, 15, false), new GENDUDESND(-1, 0, 16, false), new GENDUDESND(9008, 0, 17, false)};
    }
}

