/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.AI;

import ru.m210projects.Blood.AI.AISTATE;
import ru.m210projects.Blood.AI.AISTATEFUNC;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.CALLPROC;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;

public class AIZOMBF {
    public static AISTATE zombieFIdle;
    public static AISTATE zombieFChase;
    public static AISTATE zombieFGoto;
    public static AISTATE zombieFDodge;
    public static AISTATE zombieFSearch;
    public static AISTATE zombieFRecoil;
    public static AISTATE zombieFRTesla;
    public static AISTATE zombieFThrow;
    public static AISTATE zombieFPuke;
    public static AISTATE zombieFHack;

    public static void Init() {
        zombieFIdle = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, false, false, true, null){

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiThinkTarget(sprite, xsprite);
            }
        };
        zombieFGoto = new AISTATE(AISTATEFUNC.Type.tgoto, 8, null, 600, false, true, true, zombieFIdle){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIZOMBF.thinkGoto(sprite, xsprite);
            }
        };
        zombieFChase = new AISTATE(AISTATEFUNC.Type.other, 8, null, 0, false, true, true, null){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIZOMBF.thinkChase(sprite, xsprite);
            }
        };
        zombieFDodge = new AISTATE(AISTATEFUNC.Type.other, 8, null, 0, false, true, true, zombieFChase){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveDodge(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIZOMBF.thinkChase(sprite, xsprite);
            }
        };
        zombieFHack = new AISTATE(AISTATEFUNC.Type.other, 6, new CALLPROC(){

            @Override
            public void run(int nXSprite) {
                AIZOMBF.HackCallback(nXSprite);
            }
        }, 120, false, false, false, zombieFChase);
        zombieFPuke = new AISTATE(AISTATEFUNC.Type.other, 9, new CALLPROC(){

            @Override
            public void run(int nXSprite) {
                AIZOMBF.PukeCallback(nXSprite);
            }
        }, 120, false, false, false, zombieFChase);
        zombieFThrow = new AISTATE(AISTATEFUNC.Type.other, 6, new CALLPROC(){

            @Override
            public void run(int nXSprite) {
                AIZOMBF.ThrowCallback(nXSprite);
            }
        }, 120, false, false, false, zombieFChase);
        zombieFSearch = new AISTATE(AISTATEFUNC.Type.search, 8, null, 1800, false, true, true, zombieFIdle){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIZOMBF.thinkSearch(sprite, xsprite);
            }
        };
        zombieFRecoil = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, false, false, false, zombieFChase);
        zombieFRTesla = new AISTATE(AISTATEFUNC.Type.other, 4, null, 0, false, false, false, zombieFChase);
    }

    private static void thinkChase(SPRITE pSprite, XSPRITE pXSprite) {
        PLAYER pPlayer;
        if (pXSprite.target == -1) {
            Ai.aiNewState(pSprite, pXSprite, zombieFGoto);
            return;
        }
        if (!Actor.IsDudeSprite(pSprite) || !ru.m210projects.Build.Gameutils.isValidSprite(pXSprite.target)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        SPRITE pTarget = Engine.sprite[pXSprite.target];
        XSPRITE pXTarget = pTarget.extra > 0 ? DB.xsprite[pTarget.extra] : null;
        int dx = pTarget.x - pSprite.x;
        int dy = pTarget.y - pSprite.y;
        Ai.aiChooseDirection(pSprite, pXSprite, Main.engine.getangle(dx, dy));
        if (pXTarget == null || pXTarget.health == 0) {
            Ai.aiNewState(pSprite, pXSprite, zombieFSearch);
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && (PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.lotag - 231], 13) > 0 || PLAYER.powerupCheck(pPlayer, 31) > 0)) {
            Ai.aiNewState(pSprite, pXSprite, zombieFSearch);
            return;
        }
        int dist = (int)Main.engine.qdist(dx, dy);
        if (dist <= pDudeInfo.seeDist) {
            short nAngle = Main.engine.getangle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.ang & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.yrepeat << 2;
            if (Main.engine.cansee(pTarget.x, pTarget.y, pTarget.z, pTarget.sectnum, pSprite.x, pSprite.y, pSprite.z - eyeAboveZ, pSprite.sectnum) && dist < pDudeInfo.seeDist && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                Ai.aiSetTarget(pXSprite, pXSprite.target);
                if (dist < 5120 && dist > 3584 && Pragmas.klabs(losAngle) < 85) {
                    if (AIZOMBF.checkTarget(pSprite, dx, dy)) {
                        Ai.aiNewState(pSprite, pXSprite, zombieFThrow);
                    } else {
                        Ai.aiNewState(pSprite, pXSprite, zombieFDodge);
                    }
                } else if (dist < 5120 && dist > 1536 && Pragmas.klabs(losAngle) < 85) {
                    if (AIZOMBF.checkTarget(pSprite, dx, dy)) {
                        Ai.aiNewState(pSprite, pXSprite, zombieFPuke);
                    } else {
                        Ai.aiNewState(pSprite, pXSprite, zombieFDodge);
                    }
                } else if (dist < 1024 && Pragmas.klabs(losAngle) < 85) {
                    if (AIZOMBF.checkTarget(pSprite, dx, dy)) {
                        Ai.aiNewState(pSprite, pXSprite, zombieFHack);
                    } else {
                        Ai.aiNewState(pSprite, pXSprite, zombieFDodge);
                    }
                }
                return;
            }
        }
        Ai.aiNewState(pSprite, pXSprite, zombieFSearch);
        pXSprite.target = -1;
    }

    private static boolean checkTarget(SPRITE pSprite, int dx, int dy) {
        int pInfo = Gameutils.HitScan(pSprite, pSprite.z, dx, dy, 0, Engine.pHitInfo, 0x1000040, 0);
        return pInfo <= -1 || pInfo != 3 || pSprite.lotag != Engine.sprite[Engine.pHitInfo.hitsprite].lotag;
    }

    private static void thinkGoto(SPRITE pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int dx = pXSprite.targetX - pSprite.x;
        int dy = pXSprite.targetY - pSprite.y;
        short nAngle = Main.engine.getangle(dx, dy);
        int dist = (int)Main.engine.qdist(dx, dy);
        Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
        if (dist < Gameutils.M2X(1.0) && Pragmas.klabs(pSprite.ang - nAngle) < pDudeInfo.periphery) {
            Ai.aiNewState(pSprite, pXSprite, zombieFSearch);
        }
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void thinkSearch(SPRITE pSprite, XSPRITE pXSprite) {
        Ai.aiChooseDirection(pSprite, pXSprite, pXSprite.goalAng);
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void PukeCallback(int nXIndex) {
        SPRITE pTarget;
        XSPRITE pXSprite = DB.xsprite[nXIndex];
        int nSprite = pXSprite.reference;
        SPRITE pSprite = Engine.sprite[nSprite];
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        short nAngle = Main.engine.getangle(pXSprite.targetX - pSprite.x, pXSprite.targetY - pSprite.y);
        int dx = Trig.Cos(nAngle) >> 16;
        int dy = Trig.Sin(nAngle) >> 16;
        int dz = 0;
        int nZOffset1 = DudeInfo.dudeInfo[pSprite.lotag - 200].eyeHeight * pSprite.yrepeat;
        int nZOffset2 = 0;
        if (pXSprite.target != -1 && Actor.IsDudeSprite(pTarget = Engine.sprite[pXSprite.target])) {
            nZOffset2 = DudeInfo.dudeInfo[pTarget.lotag - 200].eyeHeight * pTarget.yrepeat;
        }
        SOUND.sfxStart3DSound(pSprite, 1203, 1, 0);
        Actor.actFireMissile(pSprite, 0, nZOffset2 - nZOffset1, dx, dy, dz, 309);
    }

    private static void ThrowCallback(int nXIndex) {
        XSPRITE pXSprite = DB.xsprite[nXIndex];
        int nSprite = pXSprite.reference;
        SPRITE pSprite = Engine.sprite[nSprite];
        int dx = Trig.Cos(pSprite.ang) >> 16;
        int dy = Trig.Sin(pSprite.ang) >> 16;
        int dz = 0;
        int nZOffset = 0;
        if (Actor.IsDudeSprite(pSprite)) {
            nZOffset = DudeInfo.dudeInfo[pSprite.lotag - 200].eyeHeight;
        }
        Actor.actFireMissile(pSprite, 0, -nZOffset, dx, dy, dz, 300);
    }

    private static void HackCallback(int nXIndex) {
        if (nXIndex > 0 && nXIndex < 2048) {
            XSPRITE pXSprite = DB.xsprite[nXIndex];
            int nSprite = pXSprite.reference;
            if (nSprite >= 0 && nSprite < Globals.kMaxSprites) {
                SPRITE pSprite = Engine.sprite[nSprite];
                if (pSprite.lotag == 204) {
                    SPRITE pTarget;
                    int dx = Trig.Cos(pSprite.ang) >> 16;
                    int dy = Trig.Sin(pSprite.ang) >> 16;
                    int dz = DudeInfo.dudeInfo[4].eyeHeight * pSprite.yrepeat;
                    if (pXSprite.target != -1 && Actor.IsDudeSprite(pTarget = Engine.sprite[pXSprite.target])) {
                        dz -= DudeInfo.dudeInfo[pTarget.lotag - 200].eyeHeight * pTarget.yrepeat;
                    }
                    Actor.actFireVector(pSprite, 0, 0, dx, dy, dz, 11);
                }
            }
        }
    }
}

