/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.AI;

import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.CALLPROC;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;

public abstract class GeneticDude {
    private static final int kAIThinkMask = 3;
    protected SPRITE pSprite;
    protected XSPRITE pXSprite;
    protected DudeInfo pDudeInfo;
    protected AiState aiState;
    protected int aiClock;
    protected int aiSoundOnce;
    protected int aiTeslaHit;
    protected int cumulDamage;

    public GeneticDude(SPRITE pSprite) {
        this.pSprite = pSprite;
        if (!Actor.IsDudeSprite(pSprite)) {
            Main.game.dassert("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        this.pXSprite = DB.xsprite[pSprite.extra];
        this.pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        this.aiClock = 0;
        this.aiSoundOnce = 0;
        this.cumulDamage = 0;
    }

    public abstract void activate();

    public abstract int damage(int var1, int var2, int var3);

    public abstract void kill(int var1, int var2, int var3);

    public abstract void warp(int var1);

    public abstract void touch();

    protected abstract void recoil(boolean var1);

    protected boolean aiCanMove(int nTarget, int ang, int dist) {
        int dx = Pragmas.mulscale(dist, Trig.Cos(ang), 30);
        int dy = Pragmas.mulscale(dist, Trig.Sin(ang), 30);
        int x = this.pSprite.x;
        int y = this.pSprite.y;
        int z = this.pSprite.z;
        Gameutils.HitScan(this.pSprite, z, Trig.Cos(ang) >> 16, Trig.Sin(ang) >> 16, 0, Engine.pHitInfo, 65537, dist);
        int hitDist = (int)Main.engine.qdist(x - Engine.pHitInfo.hitx, y - Engine.pHitInfo.hity);
        if (hitDist - (this.pSprite.clipdist << 2) < dist) {
            return Engine.pHitInfo.hitsprite >= 0 && Engine.pHitInfo.hitsprite == nTarget;
        }
        return Gameutils.FindSector(x += dx, y += dy, z, this.pSprite.sectnum);
    }

    protected void aiChooseDirection(int ang) {
        int dang = (1024 + ang - this.pSprite.ang & 0x7FF) - 1024;
        int sin = Trig.Sin(this.pSprite.ang);
        int cos = Trig.Cos(this.pSprite.ang);
        long vel = Pragmas.dmulscale(Actor.sprXVel[this.pSprite.xvel], cos, Actor.sprYVel[this.pSprite.xvel], sin, 30);
        int avoidDist = (int)((15L * vel >> 12) - (15L * vel >> 43) >> 1);
        int turnTo = 341;
        if (dang < 0) {
            turnTo = -turnTo;
        }
        this.pXSprite.goalAng = this.aiCanMove(this.pXSprite.target, this.pSprite.ang + dang, avoidDist) ? this.pSprite.ang + dang & 0x7FF : (this.aiCanMove(this.pXSprite.target, this.pSprite.ang + dang / 2, avoidDist) ? this.pSprite.ang + dang / 2 & 0x7FF : (this.aiCanMove(this.pXSprite.target, this.pSprite.ang - dang / 2, avoidDist) ? this.pSprite.ang - dang / 2 & 0x7FF : (this.aiCanMove(this.pXSprite.target, this.pSprite.ang + turnTo, avoidDist) ? this.pSprite.ang + turnTo & 0x7FF : (this.aiCanMove(this.pXSprite.target, this.pSprite.ang, avoidDist) ? (int)this.pSprite.ang : (this.aiCanMove(this.pXSprite.target, this.pSprite.ang - turnTo, avoidDist) ? this.pSprite.ang - turnTo & 0x7FF : this.pSprite.ang + 341 & 0x7FF)))));
        int n = this.pXSprite.dodgeDir = Gameutils.Chance(16384) ? 1 : -1;
        if (!this.aiCanMove(this.pXSprite.target, this.pSprite.ang + 512 * this.pXSprite.dodgeDir, 512)) {
            this.pXSprite.dodgeDir = -this.pXSprite.dodgeDir;
            if (!this.aiCanMove(this.pXSprite.target, this.pSprite.ang + 512 * this.pXSprite.dodgeDir, 512)) {
                this.pXSprite.dodgeDir = 0;
            }
        }
    }

    protected void aiMoveForward() {
        int maxTurn = this.pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + this.pXSprite.goalAng - this.pSprite.ang & 0x7FF) - 1024;
        this.pSprite.ang = (short)(this.pSprite.ang + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF);
        if (Pragmas.klabs(dang) > 341) {
            return;
        }
        int sin = Trig.Sin(this.pSprite.ang);
        int cos = Trig.Cos(this.pSprite.ang);
        short s = this.pSprite.xvel;
        Actor.sprXVel[s] = Actor.sprXVel[s] + (long)Pragmas.mulscale(cos, this.pDudeInfo.frontSpeed, 30);
        short s2 = this.pSprite.xvel;
        Actor.sprYVel[s2] = Actor.sprYVel[s2] + (long)Pragmas.mulscale(sin, this.pDudeInfo.frontSpeed, 30);
    }

    protected void aiMoveTurn() {
        int dang = (1024 + this.pXSprite.goalAng - this.pSprite.ang & 0x7FF) - 1024;
        int maxTurn = this.pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        this.pSprite.ang = (short)(this.pSprite.ang + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF);
    }

    protected void aiMoveDodge() {
        int dang = (1024 + this.pXSprite.goalAng - this.pSprite.ang & 0x7FF) - 1024;
        int maxTurn = this.pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        this.pSprite.ang = (short)(this.pSprite.ang + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF);
        if (this.pXSprite.dodgeDir == 0) {
            return;
        }
        long sin = Trig.Sin(this.pSprite.ang);
        long cos = Trig.Cos(this.pSprite.ang);
        long vel = Pragmas.dmulscale(Actor.sprXVel[this.pSprite.xvel], cos, Actor.sprYVel[this.pSprite.xvel], sin, 30);
        long svel = Pragmas.dmulscale(Actor.sprXVel[this.pSprite.xvel], sin, -Actor.sprYVel[this.pSprite.xvel], cos, 30);
        svel = this.pXSprite.dodgeDir > 0 ? (svel += (long)this.pDudeInfo.sideSpeed) : (svel -= (long)this.pDudeInfo.sideSpeed);
        Actor.sprXVel[this.pSprite.xvel] = Pragmas.dmulscale(vel, cos, svel, sin, 30);
        Actor.sprYVel[this.pSprite.xvel] = Pragmas.dmulscale(vel, sin, -svel, cos, 30);
    }

    protected boolean aiThinkTarget() {
        if (!Gameutils.Chance(this.pDudeInfo.alertChance / 2)) {
            return true;
        }
        short i = Mmulti.connecthead;
        while (i >= 0) {
            PLAYER pPlayer = Globals.gPlayer[i];
            if (this.pSprite.owner != pPlayer.nSprite && pPlayer.pXsprite.health != 0 && PLAYER.powerupCheck(pPlayer, 13) <= 0) {
                int eyeAboveZ;
                int x = pPlayer.pSprite.x;
                int y = pPlayer.pSprite.y;
                int z = pPlayer.pSprite.z;
                short nSector = pPlayer.pSprite.sectnum;
                int dx = x - this.pSprite.x;
                int dy = y - this.pSprite.y;
                long dist = Main.engine.qdist(dx, dy);
                if ((dist <= (long)this.pDudeInfo.seeDist || dist <= (long)this.pDudeInfo.hearDist) && Main.engine.cansee(x, y, z, nSector, this.pSprite.x, this.pSprite.y, this.pSprite.z - (eyeAboveZ = this.pDudeInfo.eyeHeight * this.pSprite.yrepeat << 2), this.pSprite.sectnum)) {
                    short nAngle = Main.engine.getangle(dx, dy);
                    int losAngle = (1024 + nAngle - this.pSprite.ang & 0x7FF) - 1024;
                    if (dist < (long)this.pDudeInfo.seeDist && Pragmas.klabs(losAngle) <= this.pDudeInfo.periphery) {
                        this.setTarget(pPlayer.nSprite);
                        this.activate();
                        return true;
                    }
                    if (dist < (long)this.pDudeInfo.hearDist) {
                        this.setTarget(x, y, z);
                        this.activate();
                        return true;
                    }
                }
            }
            i = Mmulti.connectpoint2[i];
        }
        return false;
    }

    protected void aiPlaySound(int nSound, int soundonce, int nChannel) {
        if (soundonce != 0) {
            if (soundonce > this.aiSoundOnce || Globals.gFrameClock >= this.aiClock) {
                SOUND.sfxKill3DSound(this.pSprite, -1, -1);
                SOUND.sfxStart3DSound(this.pSprite, nSound, nChannel, 0);
                this.aiSoundOnce = soundonce;
                this.aiClock = Globals.gFrameClock + 120;
            }
        } else {
            SOUND.sfxStart3DSound(this.pSprite, nSound, nChannel, 2);
        }
    }

    protected void aiNewState(AiState pState) {
        this.pXSprite.stateTimer = pState.ticks;
        this.aiState = pState;
        int seqStartId = this.pDudeInfo.seqStartID;
        if (pState.seqId >= 0) {
            if (!BuildGdx.cache.contains(seqStartId + pState.seqId, "SEQ")) {
                return;
            }
            SeqHandling.seqSpawn(seqStartId + pState.seqId, 3, this.pSprite.extra, pState.callback);
        }
        if (pState.enter != null) {
            pState.enter.run();
        }
    }

    public void setTarget(int x, int y, int z) {
        this.pXSprite.target = -1;
        this.pXSprite.targetX = x;
        this.pXSprite.targetY = y;
        this.pXSprite.targetZ = z;
    }

    public void setTarget(int nTarget) {
        if (nTarget < 0 || nTarget >= Globals.kMaxSprites) {
            Main.game.dassert("nTarget >= 0 && nTarget < kMaxSprites");
        }
        if (nTarget == this.pSprite.owner) {
            return;
        }
        SPRITE pTarget = Engine.sprite[nTarget];
        if (!Actor.IsDudeSprite(pTarget)) {
            return;
        }
        DudeInfo pTargetInfo = DudeInfo.dudeInfo[pTarget.lotag - 200];
        this.pXSprite.target = nTarget;
        this.pXSprite.targetX = pTarget.x;
        this.pXSprite.targetY = pTarget.y;
        this.pXSprite.targetZ = pTarget.z - (pTargetInfo.eyeHeight * pTarget.yrepeat << 2);
    }

    public void process() {
        if ((this.pSprite.hitag & 0x20) != 0) {
            return;
        }
        short nXSprite = this.pSprite.extra;
        if (this.pXSprite.health == 0) {
            return;
        }
        this.pXSprite.stateTimer = Gameutils.ClipLow(this.pXSprite.stateTimer - Globals.kFrameTicks, 0);
        if (this.aiState != null && this.aiState.move != null) {
            this.aiState.move.run();
        }
        if (this.aiState != null && this.aiState.think != null && (Globals.gFrame & 3) == (this.pSprite.xvel & 3)) {
            this.aiState.think.run();
        }
        if (this.aiState != null && this.pXSprite.stateTimer == 0 && this.aiState.next != null) {
            if (this.aiState != null && this.aiState.ticks > 0) {
                this.aiNewState(this.aiState.next);
            } else if (SeqHandling.seqFrame(3, nXSprite) < 0) {
                this.aiNewState(this.aiState.next);
            }
        }
        if (this.pXSprite.health != 0 && this.cumulDamage >= this.pDudeInfo.hinderDamage << 4) {
            this.pXSprite.data3 = (short)this.cumulDamage;
            boolean chance = Gameutils.Chance(16384);
            if (this.pSprite.statnum != 6 || !Actor.IsDudeSprite(this.pSprite)) {
                return;
            }
            this.recoil(chance);
        }
        this.cumulDamage = 0;
    }

    public boolean heal(int value, int max) {
        value <<= 4;
        if (this.pXSprite.health < (max <<= 4)) {
            this.pXSprite.health = Gameutils.ClipHigh(this.pXSprite.health + value, max);
            return true;
        }
        return false;
    }

    public int mass() {
        return this.pDudeInfo.mass;
    }

    protected static class AiState {
        final int seqId;
        final int ticks;
        final AiState next;
        final Runnable enter;
        final Runnable move;
        final Runnable think;
        final CALLPROC callback;

        public AiState(int seqId, CALLPROC callback, int ticks, Runnable enter, Runnable move, Runnable think, AiState next) {
            this.seqId = seqId;
            this.callback = callback;
            this.ticks = ticks;
            this.enter = enter;
            this.move = move;
            this.think = think;
            this.next = next;
        }
    }
}

