/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.PriorityQueue.BPriorityQueue;
import ru.m210projects.Blood.PriorityQueue.IPriorityQueue;
import ru.m210projects.Blood.PriorityQueue.JPriorityQueue;
import ru.m210projects.Blood.RXBUCKET;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Trigger;
import ru.m210projects.Blood.Types.CALLPROC;
import ru.m210projects.Blood.Types.DEMO;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.Types.XSECTOR;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Blood.VERSION;
import ru.m210projects.Blood.View;
import ru.m210projects.Blood.Weapon;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;

public class EVENT {
    int index;
    int type;
    int to;
    int command;
    public static final int kMaxChannels = 4096;
    public static final int kMaxID = 1024;
    public static final int kCommandOff = 0;
    public static final int kCommandOn = 1;
    public static final int kCommandState = 2;
    public static final int kCommandToggle = 3;
    public static final int kCommandNotState = 4;
    public static final int kCommandLink = 5;
    public static final int kCommandLock = 6;
    public static final int kCommandUnlock = 7;
    public static final int kCommandToggleLock = 8;
    public static final int kCommandStopOff = 9;
    public static final int kCommandStopOn = 10;
    public static final int kCommandStopNext = 11;
    public static final int kCommandCounter = 12;
    public static final int kCommandRespawn = 21;
    public static final int kCommandCallback = 20;
    public static final int kCallbackRespawn = 9;
    public static final int kCommandSpritePush = 30;
    public static final int kCommandSpriteImpact = 31;
    public static final int kCommandSpritePickup = 32;
    public static final int kCommandSpriteTouch = 33;
    public static final int kCommandSpriteSight = 34;
    public static final int kCommandSpriteProximity = 35;
    public static final int kCommandSpriteExplode = 36;
    public static final int kCommandSectorPush = 40;
    public static final int kCommandSectorImpact = 41;
    public static final int kCommandSectorEnter = 42;
    public static final int kCommandSectorExit = 43;
    public static final int kCommandWallPush = 50;
    public static final int kCommandWallImpact = 51;
    public static final int kCommandWallTouch = 52;
    public static final int kGDXCommandPaste = 53;
    public static final int kCommandNumbered = 64;
    public static final int kChannelNull = 0;
    public static final int kChannelSetupSecret = 1;
    public static final int kChannelSecret = 2;
    public static final int kChannelTextOver = 3;
    public static final int kChannelEndLevelA = 4;
    public static final int kChannelEndLevelB = 5;
    public static final int kGDXChannelEndLevel = 6;
    public static final int kChannelTriggerStart = 7;
    public static final int kChannelTriggerMatch = 8;
    public static final int kChannelTriggerCoop = 9;
    public static final int kChannelTriggerTeam = 10;
    public static final int kChannelTeamADeath = 15;
    public static final int kChannelTeamBDeath = 16;
    public static final int kChannelFlag0Captured = 80;
    public static final int kChannelFlag1Captured = 81;
    public static final int kChannelRemoteFire1 = 90;
    public static final int kChannelRemoteFire2 = 91;
    public static final int kChannelRemoteFire3 = 92;
    public static final int kChannelRemoteFire4 = 93;
    public static final int kChannelRemoteFire5 = 94;
    public static final int kChannelRemoteFire6 = 95;
    public static final int kChannelRemoteFire7 = 96;
    public static final int kChannelRemoteFire8 = 97;
    public static final int kUserChannelStart = 100;
    public static RXBUCKET[] rxBucket = new RXBUCKET[4096];
    public static short[] bucketHead = new short[1025];
    public static IPriorityQueue eventQ;
    public static BPriorityQueue origEventQ;
    public static JPriorityQueue gdxEventQ;
    public static final int kPQueueSize = 1024;
    public static final CALLPROC[] gCallback;
    public static final int kCallbackMax = 25;

    public static void makeMissileBlocking(int nSprite) {
        if (nSprite < 0 || nSprite >= Globals.kMaxSprites) {
            Main.game.dassert("nSprite >= 0 && nSprite < kMaxSprites");
        }
        Engine.sprite[nSprite].cstat = (short)(Engine.sprite[nSprite].cstat | 1);
    }

    public static void UniMissileBurstCallback(int nSprite) {
        if (nSprite < 0 || nSprite >= Globals.kMaxSprites) {
            Main.game.dassert("nSprite >= 0 && nSprite < kMaxSprites");
        }
        short nAngle = Main.engine.getangle((int)Actor.sprXVel[nSprite], (int)Actor.sprYVel[nSprite]);
        int nVel = 349525;
        SPRITE pSprite = Engine.sprite[nSprite];
        for (int i = 0; i < 8; ++i) {
            SPRITE pBurst = Actor.actCloneSprite(pSprite, 5);
            pBurst.lotag = pSprite.lotag;
            pBurst.shade = pSprite.shade;
            pBurst.picnum = pSprite.picnum;
            pBurst.cstat = pSprite.cstat;
            if ((pBurst.cstat & 1) != 0) {
                pBurst.cstat = (short)(pBurst.cstat & 0xFFFFFFFE);
                EVENT.evPostCallback(pBurst.xvel, 3, 100L, 24);
            }
            pBurst.pal = pSprite.pal;
            pBurst.xrepeat = (short)(pSprite.xrepeat / 2);
            pBurst.yrepeat = (short)(pSprite.yrepeat / 2);
            pBurst.clipdist = pSprite.clipdist / 2;
            pBurst.hitag = pSprite.hitag;
            pBurst.ang = (short)(pSprite.ang + Actor.gMissileData[pSprite.lotag - 300].angleOfs & 0x7FF);
            pBurst.owner = pSprite.owner;
            Actor.actBuildMissile(pBurst, pBurst.extra, pSprite);
            int dxVel = 0;
            int dyVel = Pragmas.mulscaler(nVel, Trig.Sin(i * 2048 / 8), 30);
            int dzVel = Pragmas.mulscaler(nVel, -Trig.Cos(i * 2048 / 8), 30);
            if ((i & 1) != 0) {
                dyVel >>= 1;
                dzVel >>= 1;
            }
            Trig.RotateVector(dxVel, dyVel, nAngle);
            short s = pBurst.xvel;
            Actor.sprXVel[s] = Actor.sprXVel[s] + (long)((int)Trig.rotated.x);
            short s2 = pBurst.xvel;
            Actor.sprYVel[s2] = Actor.sprYVel[s2] + (long)((int)Trig.rotated.y);
            short s3 = pBurst.xvel;
            Actor.sprZVel[s3] = Actor.sprZVel[s3] + (long)dzVel;
            EVENT.evPostCallback(pBurst.xvel, 3, 960L, 1);
        }
        EVENT.evPostCallback(nSprite, 3, 0L, 1);
    }

    public static XSPRITE getNextIncarnation(XSPRITE pXSprite) {
        if (pXSprite.txID <= 0) {
            return null;
        }
        for (int i = bucketHead[pXSprite.txID]; i < bucketHead[pXSprite.txID + 1]; ++i) {
            if (EVENT.rxBucket[i].type != 3 || !Actor.IsDudeSprite(Engine.sprite[EVENT.rxBucket[i].index]) || Engine.sprite[EVENT.rxBucket[i].index].statnum != 7) continue;
            return DB.xsprite[Engine.sprite[EVENT.rxBucket[i].index].extra];
        }
        return null;
    }

    public static void gdxFragLimitCallback(int nIndex) {
        LEVELS.levelEndLevel(0);
    }

    public static void FlagCaptureCallback(int nIndex) {
        SPRITE pFlag = Engine.sprite[nIndex];
        if (pFlag.owner >= 0 && pFlag.owner < 4096) {
            SPRITE pOwner = Engine.sprite[pFlag.owner];
            short type = pFlag.lotag;
            XSPRITE pXBase = DB.xsprite[pOwner.extra];
            if (type == 147) {
                Trigger.trTriggerSprite(pOwner.xvel, pXBase, 1);
                SOUND.sndStartSample(8003, 255, 2, false);
                View.viewSetMessage("Blue Flag returned to base.", -1, 10);
            }
            if (type == 148) {
                Trigger.trTriggerSprite(pOwner.xvel, pXBase, 1);
                SOUND.sndStartSample(8002, 255, 2, false);
                View.viewSetMessage("Red Flag returned to base.", -1, 7);
            }
        }
        EVENT.evPostCallback(nIndex, 3, 0L, 1);
    }

    public static void SpawnSmoke(int nIndex) {
        if (Actor.sprZVel[nIndex] != 0L) {
            SPRITE pSprite = Engine.sprite[nIndex];
            int radius = Main.engine.getTile(pSprite.picnum).getWidth() / 2 * pSprite.xrepeat >> 2;
            SPRITE pEffect = Actor.actSpawnEffect(7, pSprite.sectnum, pSprite.x + Pragmas.mulscale(radius, Trig.Cos(pSprite.ang - 512), 30), pSprite.y + Pragmas.mulscale(radius, Trig.Sin(pSprite.ang - 512), 30), pSprite.z, 0);
            if (pEffect != null) {
                Actor.sprXVel[pEffect.xvel] = Actor.sprXVel[nIndex];
                Actor.sprYVel[pEffect.xvel] = Actor.sprYVel[nIndex];
                Actor.sprZVel[pEffect.xvel] = Actor.sprZVel[nIndex];
            }
        }
        if (DEMO.IsOriginalDemo() || eventQ.getSize() < 768) {
            EVENT.evPostCallback(nIndex, 3, 12L, 8);
        }
    }

    public static void KillSpriteCallback(int nIndex) {
        EVENT.checkEventList(nIndex, 3);
        if (Engine.sprite[nIndex].extra > 0) {
            SeqHandling.seqKill(3, Engine.sprite[nIndex].extra);
        }
        SOUND.sfxKill3DSound(Engine.sprite[nIndex], -1, -1);
        DB.deletesprite((short)nIndex);
    }

    public static void FlareFireEffect(int nIndex) {
        SPRITE pSprite = Engine.sprite[nIndex];
        SPRITE pEffect = Actor.actSpawnEffect(28, pSprite.sectnum, pSprite.x, pSprite.y, pSprite.z, 0);
        if (pEffect != null) {
            Actor.sprXVel[pEffect.xvel] = Actor.sprXVel[nIndex] + (long)Gameutils.BiRandom(109226);
            Actor.sprYVel[pEffect.xvel] = Actor.sprYVel[nIndex] + (long)Gameutils.BiRandom(109226);
            Actor.sprZVel[pEffect.xvel] = Actor.sprZVel[nIndex] - (long)Gameutils.Random(109226);
        }
        EVENT.evPostCallback(nIndex, 3, 4L, 3);
    }

    public static void FlareFireEffect2(int nIndex) {
        System.out.println("gCallback 4");
        SPRITE pSprite = Engine.sprite[nIndex];
        SPRITE pEffect = Actor.actSpawnEffect(28, pSprite.sectnum, pSprite.x, pSprite.y, pSprite.z, 0);
        if (pEffect != null) {
            Actor.sprXVel[pEffect.xvel] = Actor.sprXVel[nIndex] + (long)Gameutils.BiRandom(109226);
            Actor.sprYVel[pEffect.xvel] = Actor.sprYVel[nIndex] + (long)Gameutils.BiRandom(109226);
            Actor.sprZVel[pEffect.xvel] = Actor.sprZVel[nIndex] - (long)Gameutils.Random(109226);
        }
        EVENT.evPostCallback(nIndex, 3, 12L, 4);
    }

    public static void AltTeslaEffect(int nIndex) {
        SPRITE pSprite = Engine.sprite[nIndex];
        SPRITE pEffect = Actor.actSpawnEffect(49, pSprite.sectnum, pSprite.x, pSprite.y, pSprite.z, 0);
        if (pEffect != null) {
            Actor.sprXVel[pEffect.xvel] = Actor.sprXVel[nIndex] + (long)Gameutils.BiRandom(109226);
            Actor.sprYVel[pEffect.xvel] = Actor.sprYVel[nIndex] + (long)Gameutils.BiRandom(109226);
            Actor.sprZVel[pEffect.xvel] = Actor.sprZVel[nIndex] - (long)Gameutils.Random(109226);
        }
        if (DEMO.IsOriginalDemo() || eventQ.getSize() < 768) {
            EVENT.evPostCallback(nIndex, 3, 3L, 15);
        }
    }

    public static void FatalityCallback(int nIndex) {
        SPRITE pSprite = Engine.sprite[nIndex];
        XSPRITE pXSprite = DB.xsprite[pSprite.extra];
        if (PLAYER.checkPlayerSeq(Globals.gPlayer[pSprite.lotag - 231], VERSION.getPlayerSeq(12)) && pXSprite.target == Globals.gMe.nSprite) {
            SOUND.sndStartSample(3313, -1, 2, false);
        }
    }

    public static void WaterBubblesCallback(int nIndex) {
        SPRITE pSprite = Engine.sprite[nIndex];
        Gameutils.GetSpriteExtents(pSprite);
        int i = 0;
        while ((long)i < Pragmas.klabs(Actor.sprZVel[nIndex]) >> 18) {
            int radius = pSprite.xrepeat * (Main.engine.getTile(pSprite.picnum).getWidth() / 2) >> 2;
            int nAngle = Gameutils.Random(2048);
            int dx = Pragmas.mulscale(Trig.Cos(nAngle), radius, 30);
            int dy = Pragmas.mulscale(Trig.Sin(nAngle), radius, 30);
            int range = Gameutils.extents_zBot - Gameutils.Random(Gameutils.extents_zBot - Gameutils.extents_zTop);
            SPRITE pEffect = Actor.actSpawnEffect(Gameutils.Random(3) + 23, pSprite.sectnum, pSprite.x + dx, pSprite.y + dy, range, 0);
            if (pEffect != null) {
                Actor.sprXVel[pEffect.xvel] = Actor.sprXVel[nIndex] + (long)Gameutils.BiRandom(109226);
                Actor.sprYVel[pEffect.xvel] = Actor.sprYVel[nIndex] + (long)Gameutils.BiRandom(109226);
                Actor.sprZVel[pEffect.xvel] = Actor.sprZVel[nIndex] + (long)Gameutils.BiRandom(109226);
            }
            ++i;
        }
        if (DEMO.IsOriginalDemo() || eventQ.getSize() < 768) {
            EVENT.evPostCallback(nIndex, 3, 4L, 11);
        }
    }

    public static void LeechSparks(int nIndex) {
        SPRITE pSprite = Engine.sprite[nIndex];
        SPRITE pEffect = Actor.actSpawnEffect(15, pSprite.sectnum, pSprite.x, pSprite.y, pSprite.z, 0);
        if (pEffect != null) {
            Actor.sprXVel[pEffect.xvel] = (long)Gameutils.BiRandom(65536) + Actor.sprXVel[nIndex];
            Actor.sprYVel[pEffect.xvel] = (long)Gameutils.BiRandom(65536) + Actor.sprYVel[nIndex];
            Actor.sprZVel[pEffect.xvel] = Actor.sprZVel[nIndex] - (long)Gameutils.Random(109226);
        }
        EVENT.evPostCallback(nIndex, 3, 3L, 7);
    }

    public static void RespawnCallback(int nSprite) {
        SPRITE pSprite = Engine.sprite[nSprite];
        short nXSprite = pSprite.extra;
        if (nXSprite <= 0 || nXSprite >= 2048) {
            Main.game.dassert("nXSprite > 0 && nXSprite < kMaxXSprites");
        }
        XSPRITE pXSprite = DB.xsprite[nXSprite];
        if (pSprite.statnum != 8 && pSprite.statnum != 4) {
            Console.Println("Sprite " + nSprite + " is not on Respawn list", Console.OSDTEXT_RED);
        }
        if ((pSprite.hitag & 0x10) == 0) {
            Console.Println("Sprite " + nSprite + " does not have the respawn attribute", Console.OSDTEXT_RED);
        }
        int respawnTime = 0;
        switch (pXSprite.respawnPending) {
            case 1: {
                respawnTime = Pragmas.mulscale(Actor.actGetRespawnTime(pSprite), 16384L, 16);
                pXSprite.respawnPending = 2;
                EVENT.evPostCallback(nSprite, 3, respawnTime, 9);
                return;
            }
            case 2: {
                respawnTime = Pragmas.mulscale(Actor.actGetRespawnTime(pSprite), 8192L, 16);
                pXSprite.respawnPending = 3;
                EVENT.evPostCallback(nSprite, 3, respawnTime, 9);
                return;
            }
            case 3: {
                if (pSprite.owner == 8) {
                    Main.game.dassert("pSprite.owner != kStatRespawn");
                }
                DB.changespritestat((short)nSprite, pSprite.owner);
                pSprite.owner = (short)-1;
                pSprite.lotag = pSprite.zvel;
                pSprite.hitag = (short)(pSprite.hitag & 0xFFFFFFEF);
                Actor.sprZVel[nSprite] = 0L;
                Actor.sprYVel[nSprite] = 0L;
                Actor.sprXVel[nSprite] = 0L;
                pXSprite.respawnPending = 0;
                pXSprite.isTriggered = false;
                pXSprite.burnTime = 0;
                if (Actor.IsDudeSprite(pSprite)) {
                    pXSprite.key = 0;
                    pSprite.x = (int)Trigger.ksprite[nSprite].x;
                    pSprite.y = (int)Trigger.ksprite[nSprite].y;
                    pSprite.z = (int)Trigger.ksprite[nSprite].z;
                    pSprite.cstat = (short)(pSprite.cstat | 0x1101);
                    short nType = pSprite.lotag;
                    pSprite.clipdist = DudeInfo.dudeInfo[nType - 200].clipdist;
                    pXSprite.health = DudeInfo.dudeInfo[nType - 200].startHealth << 4;
                    if (BuildGdx.cache.contains(DudeInfo.dudeInfo[nType - 200].seqStartID + 0, "SEQ")) {
                        SeqHandling.seqSpawn(DudeInfo.dudeInfo[nType - 200].seqStartID + 0, 3, pSprite.extra, null);
                    }
                    Ai.aiInit(pSprite, DEMO.IsOriginalDemo());
                }
                if (pSprite.lotag == 400) {
                    pSprite.cstat = (short)(pSprite.cstat | 0x101);
                    pSprite.cstat = (short)(pSprite.cstat & 0xFFFF7FFF);
                }
                Actor.actSpawnEffect(29, pSprite.sectnum, pSprite.x, pSprite.y, pSprite.z, 0);
                SOUND.sfxStart3DSound(pSprite, 350, -1, 0);
                return;
            }
        }
        Console.Println("Unexpected respawnPending value = " + pXSprite.respawn);
    }

    public static void ZombieOverHead(int nSprite) {
        if (nSprite < 0 || nSprite >= Globals.kMaxSprites) {
            Main.game.dassert("nSprite >= 0 && nSprite < kMaxSprites");
        }
        SPRITE pSprite = Engine.sprite[nSprite];
        short nXSprite = pSprite.extra;
        if (nXSprite <= 0 || nXSprite >= 2048) {
            Main.game.dassert("nXSprite > 0 && nXSprite < kMaxXSprites");
        }
        XSPRITE pXSprite = DB.xsprite[nXSprite];
        Gameutils.GetSpriteExtents(pSprite);
        SPRITE pEffect = Actor.actSpawnEffect(27, pSprite.sectnum, pSprite.x, pSprite.y, Gameutils.extents_zTop, 0);
        if (pEffect != null) {
            Actor.sprXVel[pEffect.xvel] = Actor.sprXVel[nSprite] + (long)Gameutils.BiRandom(69905);
            Actor.sprYVel[pEffect.xvel] = Actor.sprYVel[nSprite] + (long)Gameutils.BiRandom(69905);
            Actor.sprZVel[pEffect.xvel] = Actor.sprZVel[nSprite] - 436906L;
        }
        if (pXSprite.data1 <= 0) {
            if (pXSprite.data2 > 0) {
                EVENT.evPostCallback(nSprite, 3, 60L, 5);
                pXSprite.data1 = (short)40;
                pXSprite.data2 = (short)(pXSprite.data2 - 1);
            }
        } else {
            EVENT.evPostCallback(nSprite, 3, 4L, 5);
            pXSprite.data1 = (short)(pXSprite.data1 - Globals.kFrameTicks);
        }
    }

    public static void FireEffect(int nSprite) {
        SPRITE pSprite = Engine.sprite[nSprite];
        Gameutils.GetSpriteExtents(pSprite);
        for (int i = 0; i < 3; ++i) {
            int dy;
            int size = pSprite.xrepeat * (Main.engine.getTile(pSprite.picnum).getWidth() / 2) >> 3;
            int nAngle = Gameutils.Random(2048);
            int dx = Pragmas.mulscale(Trig.Cos(nAngle), size, 30);
            SPRITE pEffect = Actor.actSpawnEffect(32, pSprite.sectnum, pSprite.x + dx, pSprite.y + (dy = Pragmas.mulscale(Trig.Sin(nAngle), size, 30)), Gameutils.extents_zBot - Gameutils.Random(Gameutils.extents_zBot - Gameutils.extents_zTop), 0);
            if (pEffect == null) continue;
            Actor.sprXVel[pEffect.xvel] = Actor.sprXVel[nSprite] + (long)Gameutils.BiRandom(-dx);
            Actor.sprYVel[pEffect.xvel] = Actor.sprYVel[nSprite] + (long)Gameutils.BiRandom(-dy);
            Actor.sprZVel[pEffect.xvel] = Actor.sprZVel[nSprite] - (long)Gameutils.Random(109226);
        }
        if (pSprite != null && pSprite.extra > 0 && DB.xsprite[pSprite.extra].burnTime != 0) {
            EVENT.evPostCallback(nSprite, 3, 5L, 0);
        }
    }

    public static void FlareStarburstCallback(int nSprite) {
        if (nSprite < 0 || nSprite >= Globals.kMaxSprites) {
            Main.game.dassert("nSprite >= 0 && nSprite < kMaxSprites");
        }
        short nAngle = Main.engine.getangle((int)Actor.sprXVel[nSprite], (int)Actor.sprYVel[nSprite]);
        int nVel = 349525;
        SPRITE pSprite = Engine.sprite[nSprite];
        for (int i = 0; i < 8; ++i) {
            SPRITE pBurst = Actor.actCloneSprite(pSprite, 5);
            pBurst.picnum = (short)2424;
            pBurst.shade = (byte)-128;
            pBurst.yrepeat = (short)32;
            pBurst.lotag = (short)303;
            pBurst.clipdist = 2;
            pBurst.owner = pSprite.owner;
            pBurst.xrepeat = pBurst.yrepeat;
            int dxVel = 0;
            int dyVel = Pragmas.mulscaler(nVel, Trig.Sin(i * 2048 / 8), 30);
            int dzVel = Pragmas.mulscaler(nVel, -Trig.Cos(i * 2048 / 8), 30);
            if ((i & 1) != 0) {
                dyVel >>= 1;
                dzVel >>= 1;
            }
            Trig.RotateVector(dxVel, dyVel, nAngle);
            short s = pBurst.xvel;
            Actor.sprXVel[s] = Actor.sprXVel[s] + (long)((int)Trig.rotated.x);
            short s2 = pBurst.xvel;
            Actor.sprYVel[s2] = Actor.sprYVel[s2] + (long)((int)Trig.rotated.y);
            short s3 = pBurst.xvel;
            Actor.sprZVel[s3] = Actor.sprZVel[s3] + (long)dzVel;
            EVENT.evPostCallback(pBurst.xvel, 3, 960L, 1);
        }
        EVENT.evPostCallback(nSprite, 3, 0L, 1);
    }

    public static void BulletFloor(int nIndex) {
        SPRITE pSprite = Engine.sprite[nIndex];
        Gameutils.GetZRange(pSprite, pSprite.clipdist, 65537);
        Gameutils.GetSpriteExtents(pSprite);
        pSprite.z += Gameutils.gz_floorZ - Gameutils.extents_zBot;
        int velocity = (int)(Actor.sprZVel[nIndex] - Actor.floorVel[pSprite.sectnum]);
        if (velocity <= 0) {
            if (Actor.sprZVel[nIndex] != 0L) {
                return;
            }
            EVENT.updateBullet(pSprite);
            return;
        }
        Actor.GravityVector(Actor.sprXVel[nIndex], Actor.sprYVel[nIndex], velocity, pSprite.sectnum, 36864);
        Actor.sprXVel[nIndex] = Actor.refl_x;
        Actor.sprYVel[nIndex] = Actor.refl_y;
        Actor.sprZVel[nIndex] = Actor.refl_z;
        if (Actor.floorVel[pSprite.sectnum] == 0L && Pragmas.klabs(Actor.sprZVel[nIndex]) < 131072L) {
            EVENT.updateBullet(pSprite);
            return;
        }
        int nChannel = (pSprite.xvel & 2) + 28;
        if (nChannel > 31) {
            Main.game.dassert("nChannel < 32");
        }
        pSprite.ang = (short)(pSprite.ang + (Gameutils.vRandom() & 0x7FF));
        if (pSprite.lotag < 37 || pSprite.lotag > 39) {
            int snd = 612;
            if (Gameutils.Chance(16384)) {
                snd = 610;
            }
            SOUND.sfxStart3DSound(pSprite, snd, nChannel, 1);
        } else {
            Gameutils.bRandom();
            SOUND.sfxStart3DSound(pSprite, Gameutils.Random(2) + 608, nChannel, 1);
        }
    }

    public static void updateBullet(SPRITE pSprite) {
        Actor.sprZVel[pSprite.xvel] = 0L;
        Actor.sprYVel[pSprite.xvel] = 0L;
        Actor.sprXVel[pSprite.xvel] = 0L;
        if (pSprite.extra > 0) {
            SeqHandling.seqKill(3, pSprite.extra);
        }
        SOUND.sfxKill3DSound(pSprite, -1, -1);
        pSprite.picnum = pSprite.lotag < 37 || pSprite.lotag > 39 ? (short)2464 : (short)2465;
        pSprite.lotag = (short)51;
        pSprite.xrepeat = pSprite.yrepeat = (short)10;
    }

    public static void BloodSplat(int nIndex) {
        SPRITE pSpawn;
        SPRITE pSprite = Engine.sprite[nIndex];
        Gameutils.GetZRange(pSprite, pSprite.clipdist, 65537);
        Gameutils.GetSpriteExtents(pSprite);
        pSprite.z += Gameutils.gz_floorZ - Gameutils.extents_zBot;
        int nAngle = Gameutils.Random(2048);
        int Dist = Gameutils.Random(16) << 4;
        int x = pSprite.x + Pragmas.mulscale(Trig.Cos(nAngle), Dist, 28);
        int y = pSprite.y + Pragmas.mulscale(Trig.Sin(nAngle), Dist, 28);
        Actor.actSpawnEffect(48, pSprite.sectnum, x, y, pSprite.z, 0);
        if (pSprite.ang == 1024) {
            int nChannel = (pSprite.xvel & 2) + 28;
            if (nChannel >= 32) {
                Main.game.dassert("nChannel < 32");
            }
            SOUND.sfxStart3DSound(pSprite, 385, nChannel, 1);
        }
        if (Gameutils.Chance(10240) && (pSpawn = Actor.actSpawnEffect(36, pSprite.sectnum, x, y, Gameutils.gz_floorZ - 64, 0)) != null) {
            if (!DEMO.IsOriginalDemo() && pSprite.sectnum != pSpawn.sectnum) {
                pSpawn.z = Main.engine.getflorzofslope(pSpawn.sectnum, x, y) - 64;
            }
            pSpawn.ang = (short)nAngle;
        }
        Actor.actDeleteEffect2(nIndex);
    }

    public static void PodBloodSplat(int nIndex) {
        SPRITE pSpawn;
        SPRITE pSprite = Engine.sprite[nIndex];
        Gameutils.GetZRange(pSprite, pSprite.clipdist, 65537);
        Gameutils.GetSpriteExtents(pSprite);
        pSprite.z += Gameutils.gz_floorZ - Gameutils.extents_zBot;
        int nAngle = Gameutils.Random(2048);
        int Dist = Gameutils.Random(16) << 4;
        int x = pSprite.x + Pragmas.mulscale(Trig.Cos(nAngle), Dist, 28);
        int y = pSprite.y + Pragmas.mulscale(Trig.Sin(nAngle), Dist, 28);
        if (pSprite.ang == 1024 && pSprite.lotag == 53) {
            int nChannel = (pSprite.xvel & 2) + 28;
            if (nChannel > 31) {
                Main.game.dassert("nChannel < 32");
            }
            SOUND.sfxStart3DSound(pSprite, 385, nChannel, 1);
        }
        if (pSprite.lotag != 53 && pSprite.lotag != 430) {
            SPRITE pSpawn2 = Actor.actSpawnEffect(32, pSprite.sectnum, x, y, Gameutils.gz_floorZ - 64, 0);
            if (pSpawn2 != null) {
                if (pSprite.sectnum != pSpawn2.sectnum) {
                    pSpawn2.z = Main.engine.getflorzofslope(pSpawn2.sectnum, x, y) - 64;
                }
                pSpawn2.ang = (short)nAngle;
            }
        } else if ((Gameutils.Chance(640) || pSprite.lotag == 430) && (pSpawn = Actor.actSpawnEffect(55, pSprite.sectnum, x, y, Gameutils.gz_floorZ - 64, 0)) != null) {
            if (pSprite.sectnum != pSpawn.sectnum) {
                pSpawn.z = Main.engine.getflorzofslope(pSpawn.sectnum, x, y) - 64;
            }
            pSpawn.ang = (short)nAngle;
        }
        Actor.actDeleteEffect2(nIndex);
    }

    public static void CounterCheck(int nSector) {
        if (nSector < 0 || nSector >= Globals.kMaxSectors) {
            Main.game.dassert("nSector >= 0 && nSector < kMaxSectors");
        }
        SECTOR pSector = Engine.sector[nSector];
        short nXSector = pSector.extra;
        if (nXSector > 0) {
            XSECTOR pXSector = DB.xsector[nXSector];
            int data = pXSector.data;
            int waitTime = pXSector.waitTime[1];
            if (data != 0 && waitTime != 0) {
                int cnt = 0;
                short nSprite = Engine.headspritesect[nSector];
                while (nSprite >= 0) {
                    if (Engine.sprite[nSprite].lotag == data) {
                        ++cnt;
                    }
                    nSprite = Engine.nextspritesect[nSprite];
                }
                if (cnt < waitTime) {
                    EVENT.evPostCallback(nSector, 6, 5L, 12);
                } else {
                    Trigger.trTriggerSector(nSector, pXSector, 1);
                    pXSector.locked = 1;
                }
            }
        }
    }

    public static void BloodTrail(int nSprite) {
        SPRITE pSprite = Engine.sprite[nSprite];
        SPRITE pEffect = Actor.actSpawnEffect(27, pSprite.sectnum, pSprite.x, pSprite.y, pSprite.z, 0);
        if (pEffect != null) {
            pEffect.ang = 0;
            Actor.sprXVel[pEffect.xvel] = Actor.sprXVel[nSprite] >> 8;
            Actor.sprYVel[pEffect.xvel] = Actor.sprYVel[nSprite] >> 8;
            Actor.sprZVel[pEffect.xvel] = Actor.sprZVel[nSprite] >> 8;
        }
        EVENT.evPostCallback(nSprite, 3, 6L, 6);
    }

    public static void PodBloodTrail(int nSprite) {
        SPRITE pEffect;
        SPRITE pSprite = Engine.sprite[nSprite];
        int type = 53;
        if (pSprite.lotag != 53) {
            type = 54;
        }
        if ((pEffect = Actor.actSpawnEffect(type, pSprite.sectnum, pSprite.x, pSprite.y, pSprite.z, 0)) != null) {
            pEffect.ang = 0;
            Actor.sprXVel[pEffect.xvel] = Actor.sprXVel[nSprite] >> 8;
            Actor.sprYVel[pEffect.xvel] = Actor.sprYVel[nSprite] >> 8;
            Actor.sprZVel[pEffect.xvel] = Actor.sprZVel[nSprite] >> 8;
        }
        EVENT.evPostCallback(nSprite, 3, 6L, 18);
    }

    public static int getEvent(int index, int type, int command, int funcId) {
        return index & 0x1FFF | (type & 7) << 13 | command << 16 | funcId << 24;
    }

    public static int getIndex(int event) {
        return event & 0x1FFF;
    }

    public static int getType(int event) {
        return (event & 0xE000) >> 13;
    }

    public static int getCommand(int event) {
        return (event & 0xFF0000) >> 16;
    }

    public static int getFuncID(int event) {
        return event >> 24;
    }

    static int GetBucketChannel(RXBUCKET pBucket) {
        switch (pBucket.type) {
            case 6: {
                short nXIndex = Engine.sector[pBucket.index].extra;
                if (nXIndex <= 0) {
                    Main.game.dassert("Sector nXIndex > 0");
                }
                return DB.xsector[nXIndex].rxID;
            }
            case 0: {
                short nXIndex = Engine.wall[pBucket.index].extra;
                if (nXIndex <= 0) {
                    Main.game.dassert("Wall nXIndex > 0");
                }
                return DB.xwall[nXIndex].rxID;
            }
            case 3: {
                short nXIndex = Engine.sprite[pBucket.index].extra;
                if (nXIndex <= 0) {
                    Main.game.dassert("Sprite nXIndex > 0");
                }
                return DB.xsprite[nXIndex].rxID;
            }
        }
        Console.Println("Unexpected rxBucket type " + pBucket.type, Console.OSDTEXT_RED);
        return 0;
    }

    public static int CompareChannels(RXBUCKET ref1, RXBUCKET ref2) {
        return EVENT.GetBucketChannel(ref1) - EVENT.GetBucketChannel(ref2);
    }

    public static void evInit(boolean isOriginal) {
        int i;
        int nCount = 0;
        if (origEventQ == null) {
            origEventQ = new BPriorityQueue(1024);
        }
        if (gdxEventQ == null) {
            gdxEventQ = new JPriorityQueue(1024);
        }
        eventQ = isOriginal ? origEventQ : gdxEventQ;
        for (i = 0; i < 4096; ++i) {
            if (rxBucket[i] == null) {
                EVENT.rxBucket[i] = new RXBUCKET();
                continue;
            }
            rxBucket[i].flush();
        }
        eventQ.flush();
        for (i = 0; i < Engine.numsectors; ++i) {
            short nXSector;
            if (Engine.sector[i] == null || (nXSector = Engine.sector[i].extra) <= 0 || DB.xsector[nXSector].rxID <= 0) continue;
            if (nCount >= 4096) {
                Main.game.dassert("nCount < kMaxChannels");
            }
            EVENT.rxBucket[nCount].type = 6;
            EVENT.rxBucket[nCount].index = i;
            ++nCount;
        }
        for (i = 0; i < Engine.numwalls; ++i) {
            short nXWall;
            if (Engine.wall[i] == null || (nXWall = Engine.wall[i].extra) <= 0 || DB.xwall[nXWall].rxID <= 0) continue;
            if (nCount >= 4096) {
                Main.game.dassert("nCount < kMaxChannels");
            }
            EVENT.rxBucket[nCount].type = 0;
            EVENT.rxBucket[nCount].index = i;
            ++nCount;
        }
        for (i = 0; i < Globals.kMaxSprites; ++i) {
            short nXSprite;
            if (Engine.sprite[i].statnum >= 1024 || (nXSprite = Engine.sprite[i].extra) <= 0 || DB.xsprite[nXSprite].rxID <= 0) continue;
            if (nCount >= 4096) {
                Main.game.dassert("nCount < kMaxChannels");
            }
            EVENT.rxBucket[nCount].type = 3;
            EVENT.rxBucket[nCount].index = i;
            ++nCount;
        }
        EVENT.qsort(nCount);
        int j = 0;
        for (i = 0; i < 1024; ++i) {
            EVENT.bucketHead[i] = (short)j;
            while (j < nCount && EVENT.GetBucketChannel(rxBucket[j]) == i) {
                ++j;
            }
        }
        EVENT.bucketHead[i] = (short)j;
    }

    public static boolean evGetSourceState(int type, int nIndex) {
        switch (type) {
            case 6: {
                short nXIndex = Engine.sector[nIndex].extra;
                if (nXIndex <= 0 || nXIndex >= 512) {
                    Main.game.dassert("nXIndex > 0 && nXIndex < kMaxXSectors");
                }
                return DB.xsector[nXIndex].state != 0;
            }
            case 0: {
                short nXIndex = Engine.wall[nIndex].extra;
                if (nXIndex <= 0 || nXIndex >= 512) {
                    Main.game.dassert("nXIndex > 0 && nXIndex < kMaxXWalls");
                }
                return DB.xwall[nXIndex].state != 0;
            }
            case 3: {
                short nXIndex = Engine.sprite[nIndex].extra;
                if (nXIndex <= 0 || nXIndex >= 2048) {
                    Main.game.dassert("nXIndex > 0 && nXIndex < kMaxXSprites");
                }
                return DB.xsprite[nXIndex].state != 0;
            }
        }
        return false;
    }

    public static void evSend(int index, int type, int to, int command) {
        if (command == 2) {
            command = EVENT.evGetSourceState(type, index) ? 1 : 0;
        } else if (command == 4) {
            command = EVENT.evGetSourceState(type, index) ? 0 : 1;
        }
        int pEvent = EVENT.getEvent(index, type, command, 0);
        if (to > 0) {
            switch (to) {
                case 1: {
                    if (command < 64) {
                        Console.Println("Invalid SetupSecret command by xobject " + index, Console.OSDTEXT_RED);
                    }
                    LEVELS.levelSetupSecret(command - 64);
                    break;
                }
                case 2: {
                    if (command < 64) {
                        Console.Println("Invalid Secret command by xobject " + index, Console.OSDTEXT_RED);
                    }
                    LEVELS.levelCountSecret(command - 64);
                    break;
                }
                case 4: {
                    LEVELS.levelEndLevel(0);
                    return;
                }
                case 5: {
                    LEVELS.levelEndLevel(1);
                    return;
                }
                case 6: {
                    LEVELS.levelEndLevelCustom(command - 64);
                    return;
                }
                case 3: {
                    if (command < 64) {
                        Console.Println("Invalid TextOver command by xobject " + index, Console.OSDTEXT_RED);
                        View.viewSetMessage("Invalid TextOver command", -1, 7);
                        return;
                    }
                    Trigger.trTextOver(command - 64);
                    return;
                }
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: {
                    short nSprite = Engine.headspritestat[4];
                    while (nSprite >= 0) {
                        SPRITE pSprite = Engine.sprite[nSprite];
                        if ((pSprite.hitag & 0x20) == 0 && pSprite.extra > 0 && DB.xsprite[pSprite.extra].rxID == to) {
                            Trigger.trMessageSprite(nSprite, pEvent);
                        }
                        nSprite = Engine.nextspritestat[nSprite];
                    }
                    return;
                }
                case 80: 
                case 81: {
                    short nSprite = Engine.headspritestat[3];
                    while (nSprite >= 0) {
                        SPRITE pSprite = Engine.sprite[nSprite];
                        if ((pSprite.hitag & 0x20) == 0 && pSprite.extra > 0 && DB.xsprite[pSprite.extra].rxID == to) {
                            Trigger.trMessageSprite(nSprite, pEvent);
                        }
                        nSprite = Engine.nextspritestat[nSprite];
                    }
                    return;
                }
            }
        }
        block17: for (int i = bucketHead[to]; i < bucketHead[to + 1]; ++i) {
            if (EVENT.rxBucket[i].type == EVENT.getType(pEvent) && EVENT.rxBucket[i].index == EVENT.getIndex(pEvent)) continue;
            switch (EVENT.rxBucket[i].type) {
                case 6: {
                    Trigger.trMessageSector(EVENT.rxBucket[i].index, pEvent);
                    continue block17;
                }
                case 0: {
                    Trigger.trMessageWall(EVENT.rxBucket[i].index, pEvent);
                    continue block17;
                }
                case 3: {
                    SPRITE pSprite = Engine.sprite[EVENT.rxBucket[i].index];
                    if ((pSprite.hitag & 0x20) != 0 || pSprite.extra <= 0 || DB.xsprite[pSprite.extra].rxID == 0) continue block17;
                    Trigger.trMessageSprite(EVENT.rxBucket[i].index, pEvent);
                    continue block17;
                }
            }
        }
    }

    public static void checkEventList(int nIndex, int nType) {
        eventQ.checkList(nIndex, nType);
    }

    public static void checkEventList(int nIndex, int nType, int funcId) {
        eventQ.checkList(nIndex, nType, funcId);
    }

    public static void evPost(int index, int type, long time, int command) {
        if (command == 20) {
            Main.game.dassert("command != kCommandCallback");
        }
        if (command == 2) {
            command = EVENT.evGetSourceState(type, index) ? 1 : 0;
        } else if (command == 4) {
            command = EVENT.evGetSourceState(type, index) ? 0 : 1;
        }
        int pEvent = EVENT.getEvent(index, type, command, 0);
        eventQ.Insert((long)Globals.gFrameClock + time, pEvent);
    }

    public static void evPostCallback(int index, int type, long time, int funcId) {
        int pEvent = EVENT.getEvent(index, type, 20, funcId);
        eventQ.Insert((long)Globals.gFrameClock + time, pEvent);
    }

    public static void evProcess(long time) {
        while (eventQ.Check(time)) {
            int event = eventQ.Remove();
            if (event == 0) continue;
            if (EVENT.getCommand(event) == 20) {
                int nFunc = EVENT.getFuncID(event);
                if (nFunc >= 25) {
                    Main.game.dassert("event.funcID < kCallbackMax");
                }
                if (gCallback[nFunc] == null) {
                    Main.game.dassert("gCallback[event.funcID] != null");
                }
                gCallback[nFunc].run(EVENT.getIndex(event));
                continue;
            }
            switch (EVENT.getType(event)) {
                case 6: {
                    Trigger.trMessageSector(EVENT.getIndex(event), event);
                    break;
                }
                case 0: {
                    Trigger.trMessageWall(EVENT.getIndex(event), event);
                    break;
                }
                case 3: {
                    Trigger.trMessageSprite(EVENT.getIndex(event), event);
                }
            }
        }
    }

    private static void qsort(int n) {
        int base = 0;
        int sp = 0;
        int[] base_stack = new int[32];
        int[] n_stack = new int[32];
        while (true) {
            block18: {
                block21: {
                    int r;
                    int s;
                    int pn;
                    block20: {
                        int i;
                        int pb;
                        int p2;
                        block19: {
                            if (n <= 1) break block18;
                            if (n >= 16) break block19;
                            for (int shell = 3; shell > 0; shell -= 2) {
                                for (int p1 = base + shell; p1 < base + n; p1 += shell) {
                                    for (p2 = p1; p2 > base && EVENT.CompareChannels(rxBucket[p2 - shell], rxBucket[p2]) > 0; p2 -= shell) {
                                        EVENT.swap(p2, p2 - shell);
                                    }
                                }
                            }
                            break block18;
                        }
                        int mid = base + (n >> 1);
                        if (n > 29) {
                            int p1 = base;
                            p2 = base + (n - 1);
                            if (n > 42) {
                                int s2 = n >> 3;
                                p1 = EVENT.med3(p1, p1 + s2, p1 + (s2 << 1));
                                mid = EVENT.med3(mid - s2, mid, mid + s2);
                                p2 = EVENT.med3(p2 - (s2 << 1), p2 - s2, p2);
                            }
                            mid = EVENT.med3(p1, mid, p2);
                        }
                        RXBUCKET pv = rxBucket[mid];
                        int pa = pb = base;
                        int pd = base + (n - 1);
                        int pc = base + (n - 1);
                        while (true) {
                            int comparison;
                            if (pb <= pc && (comparison = EVENT.CompareChannels(rxBucket[pb], pv)) <= 0) {
                                if (comparison == 0) {
                                    EVENT.swap(pa, pb);
                                    ++pa;
                                }
                                ++pb;
                                continue;
                            }
                            while (pb <= pc && (comparison = EVENT.CompareChannels(rxBucket[pc], pv)) >= 0) {
                                if (comparison == 0) {
                                    EVENT.swap(pc, pd);
                                    --pd;
                                }
                                --pc;
                            }
                            if (pb > pc) break;
                            EVENT.swap(pb, pc);
                            ++pb;
                            --pc;
                        }
                        pn = base + n;
                        s = Math.min(pa - base, pb - pa);
                        if (s > 0) {
                            for (i = 0; i < s; ++i) {
                                EVENT.swap(base + i, pb - s + i);
                            }
                        }
                        if ((s = Math.min(pd - pc, pn - pd - 1)) > 0) {
                            for (i = 0; i < s; ++i) {
                                EVENT.swap(pb + i, pn - s + i);
                            }
                        }
                        if ((s = pd - pc) < (r = pb - pa)) break block20;
                        base_stack[sp] = pn - s;
                        n_stack[sp] = s;
                        n = r;
                        break block21;
                    }
                    if (r <= 1) break block18;
                    base_stack[sp] = base;
                    n_stack[sp] = r;
                    base = pn - s;
                    n = s;
                }
                ++sp;
                continue;
            }
            if (sp-- == 0) break;
            base = base_stack[sp];
            n = n_stack[sp];
        }
    }

    private static void swap(int i, int j) {
        RXBUCKET temp = rxBucket[i];
        EVENT.rxBucket[i] = rxBucket[j];
        EVENT.rxBucket[j] = temp;
    }

    private static int med3(int a, int b, int c) {
        if (EVENT.CompareChannels(rxBucket[a], rxBucket[b]) > 0) {
            if (EVENT.CompareChannels(rxBucket[a], rxBucket[c]) > 0) {
                if (EVENT.CompareChannels(rxBucket[b], rxBucket[c]) > 0) {
                    return b;
                }
                return c;
            }
            return a;
        }
        if (EVENT.CompareChannels(rxBucket[a], rxBucket[c]) >= 0) {
            return a;
        }
        if (EVENT.CompareChannels(rxBucket[b], rxBucket[c]) > 0) {
            return c;
        }
        return b;
    }

    static {
        gCallback = new CALLPROC[]{new CALLPROC(){

            @Override
            public void run(int nIndex) {
                EVENT.FireEffect(nIndex);
            }
        }, new CALLPROC(){

            @Override
            public void run(int nIndex) {
                EVENT.KillSpriteCallback(nIndex);
            }
        }, new CALLPROC(){

            @Override
            public void run(int nIndex) {
                EVENT.FlareStarburstCallback(nIndex);
            }
        }, new CALLPROC(){

            @Override
            public void run(int nIndex) {
                EVENT.FlareFireEffect(nIndex);
            }
        }, new CALLPROC(){

            @Override
            public void run(int nIndex) {
                EVENT.FlareFireEffect2(nIndex);
            }
        }, new CALLPROC(){

            @Override
            public void run(int nIndex) {
                EVENT.ZombieOverHead(nIndex);
            }
        }, new CALLPROC(){

            @Override
            public void run(int nIndex) {
                EVENT.BloodTrail(nIndex);
            }
        }, new CALLPROC(){

            @Override
            public void run(int nIndex) {
                EVENT.LeechSparks(nIndex);
            }
        }, new CALLPROC(){

            @Override
            public void run(int nIndex) {
                EVENT.SpawnSmoke(nIndex);
            }
        }, new CALLPROC(){

            @Override
            public void run(int nIndex) {
                EVENT.RespawnCallback(nIndex);
            }
        }, new CALLPROC(){

            @Override
            public void run(int nIndex) {
                PLAYER.PlayerWaterBubblesCallback(nIndex);
            }
        }, new CALLPROC(){

            @Override
            public void run(int nIndex) {
                EVENT.WaterBubblesCallback(nIndex);
            }
        }, new CALLPROC(){

            @Override
            public void run(int nIndex) {
                EVENT.CounterCheck(nIndex);
            }
        }, new CALLPROC(){

            @Override
            public void run(int nIndex) {
                EVENT.FatalityCallback(nIndex);
            }
        }, new CALLPROC(){

            @Override
            public void run(int nIndex) {
                EVENT.BloodSplat(nIndex);
            }
        }, new CALLPROC(){

            @Override
            public void run(int nIndex) {
                EVENT.AltTeslaEffect(nIndex);
            }
        }, new CALLPROC(){

            @Override
            public void run(int nIndex) {
                EVENT.BulletFloor(nIndex);
            }
        }, new CALLPROC(){

            @Override
            public void run(int nIndex) {
                EVENT.FlagCaptureCallback(nIndex);
            }
        }, new CALLPROC(){

            @Override
            public void run(int nIndex) {
                EVENT.PodBloodTrail(nIndex);
            }
        }, new CALLPROC(){

            @Override
            public void run(int nIndex) {
                EVENT.PodBloodSplat(nIndex);
            }
        }, new CALLPROC(){

            @Override
            public void run(int nIndex) {
                Weapon.LeechCallback(nIndex);
            }
        }, new CALLPROC(){

            @Override
            public void run(int nIndex) {
            }
        }, new CALLPROC(){

            @Override
            public void run(int nIndex) {
                EVENT.gdxFragLimitCallback(nIndex);
            }
        }, new CALLPROC(){

            @Override
            public void run(int nIndex) {
                EVENT.UniMissileBurstCallback(nIndex);
            }
        }, new CALLPROC(){

            @Override
            public void run(int nIndex) {
                EVENT.makeMissileBlocking(nIndex);
            }
        }};
    }
}

