/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Factory;

import com.badlogic.gdx.graphics.Color;
import ru.m210projects.Blood.Factory.BloodMapSettings;
import ru.m210projects.Blood.Factory.BloodTextureManager;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Render.GLFog;
import ru.m210projects.Build.Render.GLInfo;
import ru.m210projects.Build.Render.GLRenderer;
import ru.m210projects.Build.Render.Polymost.Polymost;
import ru.m210projects.Build.Render.TextureHandle.DummyTileData;
import ru.m210projects.Build.Render.TextureHandle.GLTile;
import ru.m210projects.Build.Render.TextureHandle.TextureManager;
import ru.m210projects.Build.Render.TextureHandle.TileData;
import ru.m210projects.Build.Render.Types.Palette;
import ru.m210projects.Build.Settings.GLSettings;

public class BloodPolymost
extends Polymost {
    private GLTile dummy;
    private final float[] pal1_color = new float[]{1.0f, 1.0f, 1.0f, 1.0f};

    public BloodPolymost(Engine engine) {
        super(engine, new BloodMapSettings());
        this.globalfog = new GLFog(){

            @Override
            public void calc() {
                if (this.combvis == 0.0f) {
                    this.start = 2.9E30f;
                    this.end = 3.0E30f;
                } else if (this.shade >= Engine.numshades - 1) {
                    this.start = -1.0f;
                    this.end = 0.001f;
                } else {
                    this.start = this.shade > 0 ? 0.0f : (float)(-(this.FOGDISTCONST * this.shade)) / this.combvis;
                    this.end = (float)(this.FOGDISTCONST * (Engine.numshades - 1 - this.shade)) / this.combvis;
                }
                this.color[0] = (float)Engine.palookupfog[this.pal][0] / 63.0f;
                this.color[1] = (float)Engine.palookupfog[this.pal][1] / 63.0f;
                this.color[2] = (float)Engine.palookupfog[this.pal][2] / 63.0f;
                this.color[3] = 1.0f;
                if (!(this.pal != 1 || GLInfo.multisample != 0 && GLSettings.usePaletteShader.get().booleanValue())) {
                    this.start = 0.0f;
                    if (this.end > 2.0f) {
                        this.end = 2.0f;
                    }
                }
                BuildGdx.gl.glFogfv(2918, this.color, 0);
                BuildGdx.gl.glFogf(2915, this.start);
                BuildGdx.gl.glFogf(2916, this.end);
            }
        };
        this.globalfog.setFogScale(64);
    }

    @Override
    protected void calc_and_apply_fog(int shade, int vis, int pal) {
        TileData.PixelFormat fmt = this.textureCache.getFmt(this.globalpicnum);
        if (fmt == null || fmt != TileData.PixelFormat.Pal8) {
            if (this.rendering == GLRenderer.Rendering.Sprite && Engine.globalpal == 5 && Engine.globalshade == 127) {
                shade = 0;
            }
            if (Engine.globalpal == 1 || pal == 1) {
                if (this.rendering == GLRenderer.Rendering.Model) {
                    shade = this.tspriteptr[GLRenderer.Rendering.Model.getIndex()].shade;
                    if (shade > 0) {
                        shade = Gameutils.BClipRange((int)(2.8f * (float)shade), 32, 52);
                    }
                } else {
                    shade = 0;
                }
            }
        }
        super.calc_and_apply_fog(shade, vis, pal);
    }

    @Override
    public void uninit() {
        if (this.dummy != null) {
            this.dummy.delete();
        }
        this.dummy = null;
        super.uninit();
    }

    @Override
    public Color getshadefactor(int shade, int method) {
        if (GLRenderer.Rendering.Skybox.getIndex() != 0 && Engine.globalpal == 1 && GLInfo.multisample != 0) {
            this.bindBloodPalette(shade);
            return super.getshadefactor(0, 0);
        }
        Color c = super.getshadefactor(shade, method);
        if (Engine.globalpal == 1) {
            c.b = 1.0f;
            c.g = 1.0f;
            c.r = 1.0f;
        }
        return c;
    }

    protected void bindDummyTexture() {
        if (this.dummy == null) {
            this.dummy = new GLTile(new DummyTileData(TileData.PixelFormat.Rgba, 1, 1), 1, false);
        }
        this.bind(this.dummy);
    }

    public void bindBloodPalette(int shade) {
        this.textureCache.activateEffect();
        this.bindDummyTexture();
        this.pal1_color[3] = (float)(Engine.numshades - shade) / (float)Engine.numshades + 0.1f;
        BuildGdx.gl.glTexEnvfv(8960, 8705, this.pal1_color, 0);
        BuildGdx.gl.glTexEnvf(8960, 8704, 34160.0f);
        BuildGdx.gl.glTexEnvf(8960, 34161, 34165.0f);
        BuildGdx.gl.glTexEnvf(8960, 34176, 34168.0f);
        BuildGdx.gl.glTexEnvf(8960, 34192, 768.0f);
        BuildGdx.gl.glTexEnvf(8960, 34177, 34166.0f);
        BuildGdx.gl.glTexEnvf(8960, 34193, 768.0f);
        BuildGdx.gl.glTexEnvf(8960, 34178, 34166.0f);
        BuildGdx.gl.glTexEnvf(8960, 34194, 770.0f);
    }

    @Override
    public TextureManager newTextureManager(Engine engine) {
        return new BloodTextureManager(engine);
    }

    @Override
    public void setTextureParameters(GLTile tile, int tilenum, int pal, int shade, int skybox, int method) {
        if (tile.getPixelFormat() == TileData.PixelFormat.Pal8) {
            if (!this.texshader.isBinded()) {
                BuildGdx.gl.glActiveTexture(33984);
                this.texshader.begin();
            }
            this.texshader.setTextureParams(pal, shade);
            float alpha = 1.0f;
            switch (method & 3) {
                case 2: {
                    alpha = Engine.TRANSLUSCENT1;
                    break;
                }
                case 3: {
                    alpha = Engine.TRANSLUSCENT2;
                }
            }
            if (!this.engine.getTile(tilenum).isLoaded()) {
                alpha = 0.01f;
            }
            this.texshader.setDrawLastIndex((method & 3) == 0 || !this.textureCache.alphaMode(method));
            this.texshader.setTransparent(alpha);
        } else {
            if (tile.isHighTile() && (tile.getHiresXScale() != 1.0f || tile.getHiresYScale() != 1.0f) && GLRenderer.Rendering.Skybox.getIndex() == 0) {
                BuildGdx.gl.glMatrixMode(5890);
                BuildGdx.gl.glLoadIdentity();
                BuildGdx.gl.glScalef(tile.getHiresXScale(), tile.getHiresYScale(), 1.0f);
                BuildGdx.gl.glMatrixMode(5888);
            }
            if (GLInfo.multisample != 0 && GLSettings.useHighTile.get().booleanValue() && GLRenderer.Rendering.Skybox.getIndex() == 0) {
                GLTile glow;
                GLTile detail;
                if (Console.Geti("r_detailmapping") != 0 && (detail = this.textureCache.get(tile.getPixelFormat(), tilenum, 255, 0, method)) != null) {
                    this.bind(detail);
                    this.setupTextureDetail(detail);
                    BuildGdx.gl.glMatrixMode(5890);
                    BuildGdx.gl.glLoadIdentity();
                    if (detail.isHighTile() && detail.getHiresXScale() != 1.0f || detail.getHiresYScale() != 1.0f) {
                        BuildGdx.gl.glScalef(detail.getHiresXScale(), detail.getHiresYScale(), 1.0f);
                    }
                    BuildGdx.gl.glMatrixMode(5888);
                }
                if (Console.Geti("r_glowmapping") != 0 && (glow = this.textureCache.get(tile.getPixelFormat(), tilenum, 254, 0, method)) != null) {
                    this.bind(glow);
                    this.setupTextureGlow(glow);
                }
            }
            Color c = this.getshadefactor(shade, method);
            if (tile.isHighTile() && this.defs.texInfo != null) {
                if (tile.getPal() != pal) {
                    Palette p = this.defs.texInfo.getTints(pal);
                    c.r *= (float)p.r / 255.0f;
                    c.g *= (float)p.g / 255.0f;
                    c.b *= (float)p.b / 255.0f;
                }
                Palette pdetail = this.defs.texInfo.getTints(255);
                if (pdetail.r != 255 || pdetail.g != 255 || pdetail.b != 255) {
                    c.r *= (float)pdetail.r / 255.0f;
                    c.g *= (float)pdetail.g / 255.0f;
                    c.b *= (float)pdetail.b / 255.0f;
                }
            }
            if (!this.engine.getTile(tilenum).isLoaded()) {
                c.a = 0.01f;
            }
            BuildGdx.gl.glColor4f(c.r, c.g, c.b, c.a);
        }
    }
}

