/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Types.BloodTile;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.OnSceenDisplay.Console;

public class Fire {
    private final short kSize = (short)128;
    private final int kSeedLines = 3;
    private final int kPorchLines = 4;
    private final int kSeedBuffers = 16;
    private final int kPicFire = 2342;
    private final int fireSize = 128;
    private final byte[] FrameBuffer;
    private final byte[][] SeedBuffer = new byte[16][128];
    private final byte[] CoolTable = new byte[1024];
    private final int gDamping = 7;
    private final byte[] gCLU;
    private int gFireClock;

    public Fire() throws Exception {
        Console.Println("Initializing dynamic fire");
        BloodTile pic = Main.engine.getTile(2342);
        if (128 != pic.getWidth() && pic.getWidth() != 0 || 128 != pic.getHeight() && pic.getHeight() != 0) {
            throw new Exception("Fire tile size(#2342) is wrong!");
        }
        this.FrameBuffer = new byte[17280];
        this.BuildCoolTable();
        this.InitSeedBuffers();
        this.gCLU = BuildGdx.cache.getBytes("RFIRE.CLU", 0);
        if (this.gCLU == null) {
            throw new Exception("RFIRE.CLU not found");
        }
        for (int i = 0; i < 50; ++i) {
            this.update();
        }
    }

    public int getPicture() {
        return 2342;
    }

    private void InitSeedBuffers() {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 128; j += 2) {
                byte c;
                this.SeedBuffer[i][j] = c = (byte)Gameutils.bRandom();
                this.SeedBuffer[i][j + 1] = c;
            }
        }
    }

    public void process() {
        if (Engine.totalclock < this.gFireClock || this.gFireClock + 2 < Engine.totalclock) {
            if ((Engine.gotpic[292] & 0x40) != 0) {
                this.update();
            }
            this.gFireClock = Engine.totalclock;
        }
    }

    private void BuildCoolTable() {
        for (int i = 0; i < 1024; ++i) {
            this.CoolTable[i] = (byte)Gameutils.ClipLow((i - 7) / 4, 0);
        }
    }

    private void update() {
        int nSeed = Gameutils.vRandom() & 0xF;
        for (int i = 0; i < 3; ++i) {
            System.arraycopy(this.SeedBuffer[nSeed], 0, this.FrameBuffer, (132 + i) * 128, 128);
        }
        this.CellularFrame(this.FrameBuffer, 128, 132);
        byte[] FireData = Main.engine.loadtile(2342);
        if (FireData == null) {
            FireData = new byte[16384];
            BloodTile pic = Main.engine.getTile(2342);
            pic.setWidth(128).setHeight(128);
        }
        this.UpdateTile(this.gCLU, FireData);
    }

    /*
     * Unable to fully structure code
     */
    private void CellularFrame(byte[] buff, int cols, int rows) {
        idx = 0;
        o = 0;
        size = rows * cols;
        pos = 0;
        while (true) {
            for (k = 0; k < 3; ++k) {
                o = cols + pos - 1;
                idx = (buff[o] & 255) + (buff[o + 1] & 255) + (buff[o + 2] & 255) + (buff[o + cols + 1] & 255);
                if ((buff[o + cols + 1] & 255) > 96) break;
                buff[pos] = this.CoolTable[idx];
                if (++pos < size) continue;
                return;
            }
            if ((buff[o + cols + 1] & 255) <= 96) ** continue;
            idx = (idx + (buff[o + cols] & 255) + (buff[o + cols + 1] & 255) + (buff[o + cols + 2] & 255) + (buff[o + cols * 2 + 1] & 255)) / 2;
            buff[pos] = this.CoolTable[idx];
            if (++pos >= size) {
                return;
            }
            o = cols + pos - 1;
            idx = (buff[o] & 255) + (buff[o + 1] & 255) + (buff[o + 2] & 255) + (buff[o + cols + 1] & 255);
            if ((buff[o + cols + 1] & 255) > 96) {
                idx = (idx + (buff[o + cols] & 255) + (buff[o + cols + 1] & 255) + (buff[o + cols + 2] & 255) + (buff[o + cols * 2 + 1] & 255)) / 2;
            }
            buff[pos] = this.CoolTable[idx];
            if (++pos >= size) break;
        }
    }

    private void UpdateTile(byte[] pCLU, byte[] pTile) {
        int k = 0;
        for (int i = 0; i < 128; ++i) {
            for (int j = 0; j < 128; ++j) {
                pTile[i + j * 128] = pCLU[this.FrameBuffer[k] & 0xFF];
                ++k;
            }
        }
        Main.engine.getrender().invalidatetile(2342, -1, -1);
    }
}

