/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Fonts;

import ru.m210projects.Blood.Fonts.QFont;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Types.BloodTile;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Pattern.BuildFont;

public class QFNFont
extends BuildFont {
    private QFont pQFN;
    private final int nTile;

    public QFNFont(Engine draw, int nTile, int nFontId) {
        super(draw);
        this.nTile = nTile;
        this.nScale = 65536;
        this.nFlags = 24;
        Resource hQFN = BuildGdx.cache.open(nFontId, "qfn");
        if (hQFN != null) {
            this.pQFN = new QFont(hQFN);
            hQFN.close();
            this.nHeight = this.pQFN.height & 0xFF;
            for (int i = 0; i < 96; ++i) {
                this.pQFN.buildChar(this.nTile, i);
                BloodTile pic = Main.engine.getTile(nTile + i);
                if (pic.getWidth() == 0) continue;
                this.addChar((char)(i + 32), nTile + i, pic.getWidth() + this.pQFN.charSpace, this.nScale, 0, 0);
                if (i != 0) continue;
                this.addChar(' ', -2, Main.engine.getTile(nTile).getWidth() + this.pQFN.charSpace, this.nScale, 0, 0);
            }
        }
    }

    public void rebuildChar() {
        if (this.pQFN != null) {
            for (int i = 0; i < 96; ++i) {
                this.pQFN.buildChar(this.nTile, (char)(i + 32));
            }
        }
    }
}

