/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Fonts;

import java.util.Arrays;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Types.BloodTile;
import ru.m210projects.Blood.Types.CHARINFO;
import ru.m210projects.Build.FileHandle.Resource;

public class QFont {
    public byte charSpace;
    public byte width;
    public byte height;
    private final CHARINFO[] info;
    private final byte[] data;
    private byte baseline;

    public QFont(Resource bb) {
        byte[] buf = new byte[12];
        bb.read(buf, 0, 4);
        bb.readShort();
        short type = bb.readShort();
        int totalsize = bb.readInt();
        bb.readByte();
        bb.readByte();
        bb.readByte();
        this.baseline = bb.readByte();
        bb.readByte();
        this.charSpace = bb.readByte();
        this.width = bb.readByte();
        this.height = bb.readByte();
        bb.read(buf, 0, 12);
        this.info = new CHARINFO[256];
        for (int i = 0; i < 256; ++i) {
            this.info[i] = new CHARINFO(bb);
        }
        if (this.width == 12 && this.height == 5 && totalsize == 40674 && type != 0 && this.baseline == 0 && this.charSpace == 0) {
            this.baseline = (byte)8;
            this.height = (byte)21;
        }
        if (this.width == 6 && this.height == 8 && totalsize == 7566 && type != 0 && this.baseline == 6 && this.charSpace == 1) {
            this.baseline = (byte)8;
        }
        if (this.width == 15 && this.height == 15 && totalsize == 16866 && type != 0 && this.baseline == 15 && this.charSpace == -1) {
            this.baseline = (byte)8;
        }
        int len = bb.size() - bb.position();
        this.data = new byte[len];
        bb.read(this.data);
    }

    public void buildChar(int nBase, int nChar) {
        CHARINFO pInfo = this.info[nChar + 32];
        int sizeX = pInfo.cols & 0xFF;
        int sizeY = pInfo.rows & 0xFF;
        int nSize = sizeX * sizeY;
        if (nChar != 0 && nSize == 0) {
            return;
        }
        int nTile = nChar + nBase;
        if (nChar == 0) {
            sizeX = (short)(this.width / 2);
        }
        BloodTile pic = Main.engine.getTile(nTile);
        pic.setWidth(sizeX);
        pic.setHeight(this.height);
        byte[] waloff = new byte[sizeX * this.height];
        Arrays.fill(waloff, (byte)-1);
        int voffset = this.baseline + pInfo.voffset;
        for (int y = 0; y < sizeY && y + voffset < this.height; ++y) {
            for (int x = 0; x < sizeX; ++x) {
                if (voffset + y + x * this.height < 0) continue;
                waloff[voffset + y + x * this.height] = this.data[pInfo.offset + y + x * sizeY];
            }
        }
        pic.data = waloff;
    }
}

