/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.Fonts.QFNFont;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Mirror;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.RFScript;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Tile;
import ru.m210projects.Blood.Types.BloodDef;
import ru.m210projects.Blood.Types.BloodIniFile;
import ru.m210projects.Blood.Types.EpisodeInfo;
import ru.m210projects.Blood.Types.MapInfo;
import ru.m210projects.Blood.Types.Seq.SeqType;
import ru.m210projects.Blood.VERSION;
import ru.m210projects.Blood.View;
import ru.m210projects.Blood.Weapon;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Cache1D;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.DirectoryEntry;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.FileResource;
import ru.m210projects.Build.FileHandle.FileUtils;
import ru.m210projects.Build.FileHandle.Group;
import ru.m210projects.Build.FileHandle.GroupResource;
import ru.m210projects.Build.FileHandle.PackedZipGroup;
import ru.m210projects.Build.FileHandle.UserGroup;
import ru.m210projects.Build.FileHandle.ZipGroup;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.Tools.IniFile;
import ru.m210projects.Build.Script.CueScript;
import ru.m210projects.Build.Types.SPRITE;

public class LEVELS {
    public static final int kMinEpisode = 1;
    public static final int kMaxEpisode = 6;
    public static final int kMinMap = 1;
    public static final int kMaxMap = 16;
    public static final int kMaxMessages = 128;
    public static int foundSecret = 0;
    public static int totalSecrets = 0;
    public static int autoTotalSecrets = 0;
    public static int superSecrets = 0;
    public static int totalKills = 0;
    public static int kills = 0;
    public static int gNextMap;
    public static int nEpisodeCount;
    public static EpisodeInfo currentEpisode;
    public static EpisodeInfo[] gEpisodeInfo;
    public static EpisodeInfo[] gUserEpisodeInfo;
    public static HashMap<String, BloodIniFile> episodes;
    public static MapInfo gUserMapInfo;
    private static UserGroup usergroup;
    public static boolean usecustomarts;
    public static boolean usecustomqavs;

    public static void levelCalcKills() {
        totalKills = 0;
        short i = Engine.headspritestat[6];
        while (i >= 0) {
            SPRITE pSprite = Engine.sprite[i];
            if (!Actor.IsDudeSprite(pSprite)) {
                Console.Println("Warning: pDude.type >= kDudeBase && pDude.type < kDudeMax : " + pSprite.lotag);
            } else if (pSprite.statnum == 6 && pSprite.lotag != 219 && pSprite.lotag != 220 && pSprite.lotag != 245 && pSprite.lotag != 239) {
                ++totalKills;
            }
            i = Engine.nextspritestat[i];
        }
    }

    public static String levelEpisodePath(BloodIniFile ini) {
        if (ini.isPackage()) {
            return ini.getFile().getPath() + ":" + ini.getName();
        }
        return ini.getFile().getPath();
    }

    public static BloodIniFile levelGetEpisode(String filepath) {
        FileEntry file;
        if (filepath == null) {
            return null;
        }
        String fullname = filepath;
        String packedIni = null;
        int filenameIndex = -1;
        filenameIndex = fullname.indexOf(":");
        if (filenameIndex != -1) {
            filepath = fullname.substring(0, filenameIndex);
            packedIni = fullname.substring(filenameIndex + 1);
        }
        if ((file = BuildGdx.compat.checkFile(filepath)) != null) {
            BloodIniFile ini = null;
            if (filenameIndex == -1 && (ini = episodes.get(file.getPath())) == null) {
                if (file.getExtension().equals("ini")) {
                    FileResource res = BuildGdx.compat.open(file);
                    byte[] data = res.getBytes();
                    res.close();
                    if (data == null) {
                        Console.Println("file is exists, but data == null!" + file.getPath());
                    }
                    ini = new BloodIniFile(data, file.getName(), file);
                    episodes.put(file.getPath(), ini);
                }
            } else if (filenameIndex != -1 && (ini = episodes.get(fullname)) == null && (file.getExtension().equals("zip") || file.getExtension().equals("grp") || file.getExtension().equals("rff"))) {
                try {
                    Group res = BuildGdx.cache.isGroup(file.getPath());
                    if (res != null) {
                        for (GroupResource files : res.getList()) {
                            if (!files.getExtension().equals("ini") || !files.getFullName().equals(packedIni)) continue;
                            GroupResource gres = res.open(files.getFullName());
                            byte[] data = gres.getBytes();
                            ini = new BloodIniFile(data, packedIni, file);
                            ini.setPackage(true);
                            episodes.put(fullname, ini);
                            gres.close();
                        }
                    }
                    res.dispose();
                    res = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return ini;
        }
        return null;
    }

    public static void loadUserMapInfo(String mLevelName) {
        LEVELS.gUserMapInfo.MapName = LEVELS.gUserMapInfo.Title = mLevelName;
        Globals.pGameInfo.zLevelName = LEVELS.gUserMapInfo.Title;
        LEVELS.gUserMapInfo.Song = null;
        LEVELS.gUserMapInfo.Track = 0;
        String defFile = mLevelName.substring(0, mLevelName.lastIndexOf(46)) + ".def";
        FileEntry file = BuildGdx.compat.checkFile(defFile);
        if (file != null) {
            FileResource res = BuildGdx.compat.open(file);
            BloodIniFile ini = new BloodIniFile(res.getBytes(), defFile, file);
            res.close();
            ini.initDef();
            LEVELS.gUserMapInfo.Title = ini.GetKeyString("Title");
            if (LEVELS.gUserMapInfo.Title == null) {
                LEVELS.gUserMapInfo.Title = LEVELS.gUserMapInfo.MapName;
            }
            String song = ini.GetKeyString("Song");
            String currPath = ini.getFile().getParent().getName();
            if (ini.getFile().getParent() != BuildGdx.compat.getDirectory(Compat.Path.Game)) {
                song = currPath + File.separator + song;
            }
            LEVELS.gUserMapInfo.Song = song;
            LEVELS.gUserMapInfo.Track = ini.GetKeyInt("Track");
        } else {
            file = BuildGdx.compat.checkFile(LEVELS.gUserMapInfo.Title);
            if (file != null) {
                LEVELS.gUserMapInfo.Title = file.getName();
            }
        }
        Globals.pGameInfo.nEpisode = 0;
        Globals.pGameInfo.nLevel = 16;
        Globals.pGameInfo.zLevelSong = LEVELS.gUserMapInfo.Song;
        Globals.pGameInfo.nTrackNumber = LEVELS.gUserMapInfo.Track;
        currentEpisode = null;
    }

    public static void levelSetupSecret(int command) {
        totalSecrets = Main.cfg.useautosecretcount ? autoTotalSecrets : command;
    }

    public static void initEpisodeInfo(BloodIniFile MainINI) {
        for (int i = 0; i < 6; ++i) {
            LEVELS.gEpisodeInfo[i] = new EpisodeInfo();
            LEVELS.gEpisodeInfo[i].filename = MainINI.getName();
            LEVELS.gUserEpisodeInfo[i] = new EpisodeInfo();
        }
        nEpisodeCount = 6;
        episodes = new HashMap();
        String path = MainINI.getFile().getPath();
        if (path == null) {
            path = MainINI.getFile().getName();
        }
        episodes.put(path, MainINI);
    }

    private static String handleCutscenePath(String path) {
        String out = path;
        if (path != null) {
            if (out.startsWith(".")) {
                out = out.substring(1);
            }
            if ((out = FileUtils.getCorrectPath(out)).startsWith(File.separator)) {
                out = out.substring(1);
            }
        }
        return out;
    }

    public static int getEpisodeInfo(EpisodeInfo[] pEpisodes, BloodIniFile INI) {
        int nEpisodeCount = 0;
        for (int i = 0; i < 6; ++i) {
            String BloodBatchOnly;
            EpisodeInfo pEpisode = pEpisodes[i];
            pEpisode.clear();
            if (!INI.set("Episode" + (i + 1))) continue;
            pEpisode.filename = INI.isPackage() ? INI.getFile().getName() + ":" + INI.getName() : INI.getName();
            String title = INI.GetKeyString("Title");
            if (title == null || title.isEmpty()) {
                title = "Episode" + (i + 1);
            }
            pEpisode.Title = title;
            pEpisode.CutSceneA = LEVELS.handleCutscenePath(INI.GetKeyString("CutSceneA"));
            String episodePath = INI.getFile().getParent().getRelativePath();
            pEpisode.CutWavA = LEVELS.handleCutscenePath(INI.GetKeyString("CutWavA"));
            pEpisode.CutSceneB = LEVELS.handleCutscenePath(INI.GetKeyString("CutSceneB"));
            pEpisode.CutWavB = LEVELS.handleCutscenePath(INI.GetKeyString("CutWavB"));
            if (episodePath != null || INI.isPackage()) {
                pEpisode.CutSceneA = Main.game.getFilename(pEpisode.CutSceneA);
                pEpisode.CutSceneB = Main.game.getFilename(pEpisode.CutSceneB);
                pEpisode.CutWavA = Main.game.getFilename(pEpisode.CutWavA);
                pEpisode.CutWavB = Main.game.getFilename(pEpisode.CutWavB);
            }
            pEpisode.BBOnly = (BloodBatchOnly = INI.GetKeyString("BloodBathOnly")) != null && BloodBatchOnly.charAt(0) == '1' ? 1 : 0;
            pEpisode.CutSceneALevel = 0;
            int CutSceneALevel = INI.GetKeyInt("CutSceneALevel");
            if (CutSceneALevel != -1) {
                pEpisode.CutSceneALevel = CutSceneALevel - 1;
            }
            int nMaps = 0;
            for (int j = 1; j < 16; ++j) {
                INI.set("Episode" + (i + 1));
                String mapName = INI.GetKeyString("Map" + j);
                if (mapName == null) continue;
                if (pEpisode.gMapInfo[j - 1] == null) {
                    pEpisode.gMapInfo[j - 1] = new MapInfo();
                }
                MapInfo pMap = pEpisode.gMapInfo[j - 1];
                INI.set(mapName);
                pMap.MapName = mapName;
                LEVELS.levelLoadDef(pMap, INI);
                ++nMaps;
            }
            if (nMaps == 0) {
                pEpisode.clear();
                continue;
            }
            pEpisode.nMaps = nMaps;
            pEpisode.setDirectory(INI.getFile().getParent());
            ++nEpisodeCount;
        }
        return nEpisodeCount;
    }

    public static void levelCountSecret(int command) {
        if (command < 0) {
            System.err.println("Invalid secret type " + command + " triggered");
            return;
        }
        if (command != 0) {
            ++superSecrets;
        } else {
            ++foundSecret;
        }
        if (Globals.pGameInfo.nGameType == 0) {
            if (Gameutils.Random(2) == 1) {
                View.viewSetMessage("You found a secret.", Globals.gPlayer[View.gViewIndex].nPlayer, 9);
            } else {
                View.viewSetMessage("A secret is revealed.", Globals.gPlayer[View.gViewIndex].nPlayer, 9);
            }
        }
    }

    public static void levelResetKills() {
        totalKills = 0;
        kills = 0;
    }

    public static void levelResetSecrets() {
        superSecrets = 0;
        totalSecrets = 0;
        foundSecret = 0;
    }

    public static void levelAddKills(SPRITE pSprite) {
        if (pSprite.statnum == 6 && pSprite.lotag != 219 && pSprite.lotag != 220 && pSprite.lotag != 245 && pSprite.lotag != 239) {
            ++kills;
        }
    }

    public static void prepareusergroup(Group group) throws Exception {
        if (group.type == Cache1D.PackageType.Zip) {
            ((ZipGroup)group).removeFolders();
        } else if (group.type == Cache1D.PackageType.PackedZip) {
            ((PackedZipGroup)group).removeFolders();
        }
        if (!(group.containsType("rff") || group.containsType("grp") || group.containsType("zip") || group.containsType("rfs") || group.containsType("cue"))) {
            return;
        }
        List<GroupResource> list = group.getList();
        for (GroupResource res : list) {
            switch (res.getExtension()) {
                case "rff": 
                case "grp": 
                case "zip": {
                    BuildGdx.cache.add(res, group.isRemovable());
                    break;
                }
                case "rfs": {
                    new RFScript(group, res.getFullName(), res.getBytes());
                    res.flush();
                    break;
                }
                case "cue": {
                    CueScript cdTracks = new CueScript(res.getFullName(), res.getBytes());
                    String[] cdtracks = cdTracks.getTracks();
                    int num = 0;
                    for (int i = 0; i < cdtracks.length; ++i) {
                        if (cdtracks[i] == null) continue;
                        SOUND.usertrack[i] = Main.game.getFilename(cdtracks[i]);
                        ++num;
                    }
                    Console.Println(num + " cd tracks found...");
                    res.flush();
                }
            }
        }
    }

    public static void searchEpisodeResources(DirectoryEntry cache, HashMap<String, Integer> fileids) {
        for (FileEntry file : cache.getFiles().values()) {
            FileResource res;
            if (file.getExtension().equals("rfs")) {
                res = BuildGdx.compat.open(file);
                if (res == null) continue;
                RFScript scr = new RFScript(null, file.getPath(), res.getBytes());
                fileids.putAll(scr.getIds());
                res.close();
                continue;
            }
            if (!file.getExtension().equals("cue") || (res = BuildGdx.compat.open(file)) == null) continue;
            CueScript cdTracks = new CueScript(res.getFullName(), res.getBytes());
            String[] cdtracks = cdTracks.getTracks();
            int num = 0;
            for (int i = 0; i < cdtracks.length; ++i) {
                if (cdtracks[i] == null) continue;
                SOUND.usertrack[i] = Main.game.getFilename(cdtracks[i]);
                ++num;
            }
            Console.Println(num + " cd tracks found...");
            res.close();
        }
        if (cache.getDirectories().size() > 0) {
            for (DirectoryEntry dir : cache.getDirectories().values()) {
                dir.InitDirectory(dir.getAbsolutePath());
                if (dir == BuildGdx.compat.getDirectory(Compat.Path.User)) continue;
                LEVELS.searchEpisodeResources(dir, fileids);
            }
        }
        for (FileEntry file : cache.getFiles().values()) {
            if (!file.getExtension().equals("zip") && !file.getExtension().equals("grp") && !file.getExtension().equals("rff")) continue;
            try {
                Group gr = BuildGdx.cache.add(file.getPath());
                gr.setFlags(true, true);
                LEVELS.prepareusergroup(gr);
            }
            catch (Exception e) {
                Console.Println("Error to load " + file.getName(), Console.OSDTEXT_RED);
            }
        }
        if (usergroup == null) {
            usergroup = BuildGdx.cache.add("User", true);
        }
        for (FileEntry file : cache.getFiles().values()) {
            if (file.getExtension().equals("ini") || file.getExtension().equals("rfs") || file.getExtension().equals("zip") || file.getExtension().equals("grp") || file.getExtension().equals("rff")) continue;
            Integer id = fileids.get(file.getName());
            usergroup.add(file, id != null ? id : -1);
        }
    }

    public static void checkEpisodeResources(BloodIniFile ini) {
        if (ini == null) {
            return;
        }
        LEVELS.resetEpisodeResources();
        BloodDef addonScript = new BloodDef(Main.game.getBaseDef(), ini.getFile());
        DirectoryEntry currdir = ini.getFile().getParent();
        if (ini.isPackage()) {
            try {
                Group gr = BuildGdx.cache.add(ini.getFile().getPath());
                gr.setFlags(true, true);
                GroupResource res = gr.open("bloodgdx.def");
                if (res != null) {
                    addonScript.loadScript(gr.name + " script", res.getBytes());
                    res.close();
                }
                LEVELS.prepareusergroup(gr);
            }
            catch (Exception e) {
                Main.game.GameMessage("Error found in " + ini.getFile().getName() + "\r\n" + e.getMessage());
                return;
            }
        } else if (currdir != BuildGdx.compat.getDirectory(Compat.Path.Game)) {
            FileEntry def;
            HashMap<String, Integer> fileids = new HashMap<String, Integer>();
            LEVELS.searchEpisodeResources(ini.getFile().getParent(), fileids);
            if (currdir != null && (def = currdir.checkFile("bloodgdx.def")) != null) {
                addonScript.loadScript(def);
            }
        }
        if (ini.getName().equals("cryptic.ini")) {
            String artname = "CPART07.AR_";
            if (currdir != BuildGdx.compat.getDirectory(Compat.Path.Game)) {
                artname = currdir.getName() + File.separator + artname;
            }
            Main.engine.loadpic(artname);
            artname = "CPART15.AR_";
            if (currdir != BuildGdx.compat.getDirectory(Compat.Path.Game)) {
                artname = currdir.getName() + File.separator + artname;
            }
            Main.engine.loadpic(artname);
            usecustomarts = true;
        }
        LEVELS.InitGroupResources(addonScript, BuildGdx.cache.getDynamicResources());
        Main.game.setDefs(addonScript);
        View.InitBallBuffer();
    }

    public static void InitGroupResources(BloodDef script, List<GroupResource> list) {
        for (GroupResource res : list) {
            if (res.getExtension().equals("art")) {
                Main.engine.loadpic(res.getFullName());
                usecustomarts = true;
                continue;
            }
            if (res.getFullName().equals("voxel.dat")) {
                Tile.voxelsInit(res.getFullName());
                System.err.println("Found voxel.dat. Loading... ");
                continue;
            }
            if (res.getFullName().equals("surface.dat")) {
                script.surfaceInit(res.getFullName());
                System.err.println("Found surface.dat. Loading... ");
                continue;
            }
            if (res.getFullName().equals("shade.dat")) {
                Tile.shadeInit(res.getFullName());
                System.err.println("Found shade.dat. Loading... ");
                continue;
            }
            if (!res.getExtension().equals("qav")) continue;
            usecustomqavs = true;
        }
        if (usecustomqavs) {
            System.err.println("Found qav files. Loading... ");
            Weapon.WeaponInit();
        }
    }

    public static void resetEpisodeResources() {
        int i;
        BuildGdx.cache.clearDynamicResources();
        usergroup = null;
        Arrays.fill(SOUND.pSFXs, null);
        SeqType.flushCache();
        Arrays.fill(SOUND.usertrack, null);
        if (usecustomqavs) {
            Weapon.WeaponInit();
            usecustomqavs = false;
        }
        if (!usecustomarts) {
            Main.game.setDefs(Main.game.baseDef);
            return;
        }
        System.err.println("Reset to default resources");
        for (i = 0; i < Globals.kMaxTiles; ++i) {
            Main.engine.getTile(i).clear();
        }
        if (Main.engine.loadpics() == 0) {
            Main.game.dassert("ART files not found " + new File(Compat.Path.Game.getPath() + Main.engine.tilesPath).getAbsolutePath());
            return;
        }
        Tile.tileInit();
        Main.game.setDefs(Main.game.baseDef);
        Mirror.InitMirrorTiles();
        if (VERSION.hasQFN) {
            for (i = 0; i < 5; ++i) {
                ((QFNFont)Main.game.getFont(i)).rebuildChar();
            }
        }
        View.InitBallBuffer();
        usecustomarts = false;
    }

    public static void loadMapInfo(int nEp, int nMap) {
        Globals.pGameInfo.nEpisode = nEp;
        Globals.pGameInfo.nLevel = nMap;
        currentEpisode = Main.mUserFlag != Main.UserFlag.Addon ? gEpisodeInfo[Globals.pGameInfo.nEpisode] : gUserEpisodeInfo[Globals.pGameInfo.nEpisode];
        if (LEVELS.currentEpisode.gMapInfo[nMap] != null && LEVELS.currentEpisode.gMapInfo[nMap].MapName != null) {
            Globals.pGameInfo.zLevelSong = LEVELS.currentEpisode.gMapInfo[nMap].Song;
            Globals.pGameInfo.zLevelName = LEVELS.currentEpisode.gMapInfo[nMap].MapName;
            Globals.pGameInfo.nTrackNumber = LEVELS.currentEpisode.gMapInfo[nMap].Track;
        } else if (Main.mUserFlag != Main.UserFlag.UserMap) {
            Globals.pGameInfo.zLevelName = "Unknown";
            Globals.pGameInfo.nLevel = 0;
        }
    }

    public static void levelLoadDef(MapInfo pMap, IniFile INI) {
        String Song;
        pMap.Title = INI.GetKeyString("Title");
        if (pMap.Title == null) {
            pMap.Title = pMap.MapName;
        }
        pMap.Author = INI.GetKeyString("Author");
        pMap.Song = INI.GetKeyString("Song");
        pMap.Song = Song = INI.GetKeyString("Song");
        pMap.Track = INI.GetKeyInt("Track");
        pMap.EndingA = INI.GetKeyInt("EndingA");
        pMap.EndingB = INI.GetKeyInt("EndingB");
        pMap.Fog = INI.GetKeyInt("Fog") == 1;
        pMap.Weather = INI.GetKeyInt("Weather") == 1;
        for (int i = 1; i < 128; ++i) {
            pMap.gMessage[i - 1] = INI.GetKeyString("Message" + i);
        }
    }

    public static void levelEndLevel(int levType) {
        int pnEndingB;
        int i;
        if (Mmulti.numplayers > 1 && Main.game.pNet.bufferJitter > 1 && Mmulti.myconnectindex == Mmulti.connecthead) {
            for (i = 0; i < Main.game.pNet.bufferJitter; ++i) {
                Main.game.pNet.GetNetworkInput();
            }
        }
        if (!Main.game.pNet.WaitForAllPlayers(5000)) {
            Main.game.pNet.NetDisconnect(Mmulti.myconnectindex);
            return;
        }
        if (Globals.pGameInfo.nGameType == 1 && Globals.pGameInfo.nReviveMode) {
            i = Mmulti.connecthead;
            while (i >= 0) {
                if (Globals.gPlayer[i].deathTime > 0) {
                    PLAYER.resetInventory(Globals.gPlayer[i]);
                    PLAYER.playerReset(i);
                }
                i = Mmulti.connectpoint2[i];
            }
        }
        Globals.pGameInfo.uGameFlags |= 1;
        Engine.getInput().setKey(256, 0);
        MapInfo pMap = null;
        if (currentEpisode == null || (pMap = LEVELS.currentEpisode.gMapInfo[Globals.pGameInfo.nLevel]) == null) {
            Globals.pGameInfo.uGameFlags |= 2;
            Globals.pGameInfo.nLevel = 0;
            return;
        }
        int pnEndingA = pMap.EndingA;
        if (pnEndingA >= 0) {
            --pnEndingA;
        }
        if ((pnEndingB = pMap.EndingB) >= 0) {
            --pnEndingB;
        }
        if (levType == 1) {
            if (pnEndingB == -1) {
                if (Globals.pGameInfo.nEpisode + 1 < nEpisodeCount) {
                    if (LEVELS.currentEpisode.CutSceneB != null) {
                        Globals.pGameInfo.uGameFlags |= 8;
                    }
                    Globals.pGameInfo.nLevel = 0;
                    Globals.pGameInfo.uGameFlags |= 2;
                    return;
                }
                Globals.pGameInfo.uGameFlags |= 1;
                Globals.pGameInfo.nLevel = 0;
                return;
            }
            gNextMap = pnEndingB;
            return;
        }
        if (pnEndingA != -1) {
            gNextMap = pnEndingA;
            return;
        }
        if (LEVELS.currentEpisode.CutSceneB != null) {
            Globals.pGameInfo.uGameFlags |= 8;
        }
        Globals.pGameInfo.uGameFlags |= 2;
        Globals.pGameInfo.nLevel = 0;
    }

    public static void levelEndLevelCustom(int nLevel) {
        if (!Main.game.pNet.WaitForAllPlayers(5000)) {
            Main.game.pNet.NetDisconnect(Mmulti.myconnectindex);
            return;
        }
        if (Globals.pGameInfo.nGameType == 1 && Globals.pGameInfo.nReviveMode) {
            short i = Mmulti.connecthead;
            while (i >= 0) {
                if (Globals.gPlayer[i].deathTime > 0) {
                    PLAYER.resetInventory(Globals.gPlayer[i]);
                    PLAYER.playerReset(i);
                }
                i = Mmulti.connectpoint2[i];
            }
        }
        Globals.pGameInfo.uGameFlags |= 1;
        Engine.getInput().setKey(256, 0);
        if (Main.mUserFlag == Main.UserFlag.UserMap || nLevel >= 16 || nLevel < 0) {
            Globals.pGameInfo.uGameFlags |= 2;
            Globals.pGameInfo.nLevel = 0;
            return;
        }
        gNextMap = nLevel;
    }

    static {
        gEpisodeInfo = new EpisodeInfo[6];
        gUserEpisodeInfo = new EpisodeInfo[6];
        gUserMapInfo = new MapInfo();
    }
}

