/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.EVENT;
import ru.m210projects.Blood.Factory.BloodNetwork;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Menus.MenuCorruptGame;
import ru.m210projects.Blood.Mirror;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.PriorityQueue.BPriorityQueue;
import ru.m210projects.Blood.PriorityQueue.JPriorityQueue;
import ru.m210projects.Blood.PriorityQueue.PriorityItem;
import ru.m210projects.Blood.RXBUCKET;
import ru.m210projects.Blood.SECTORFX;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Screen;
import ru.m210projects.Blood.Trigger;
import ru.m210projects.Blood.Types.BitHandler;
import ru.m210projects.Blood.Types.BloodIniFile;
import ru.m210projects.Blood.Types.BloodTile;
import ru.m210projects.Blood.Types.DEMO;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.LSInfo;
import ru.m210projects.Blood.Types.SafeLoader;
import ru.m210projects.Blood.Types.Seq.CeilingInst;
import ru.m210projects.Blood.Types.Seq.FloorInst;
import ru.m210projects.Blood.Types.Seq.MaskedWallInst;
import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.Types.Seq.SeqInst;
import ru.m210projects.Blood.Types.Seq.SpriteInst;
import ru.m210projects.Blood.Types.Seq.WallInst;
import ru.m210projects.Blood.Types.XSECTOR;
import ru.m210projects.Blood.Types.XWALL;
import ru.m210projects.Blood.View;
import ru.m210projects.Blood.Warp;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.FileResource;
import ru.m210projects.Build.FileHandle.FileUtils;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.Tools.SaveManager;
import ru.m210projects.Build.Types.LittleEndian;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.WALL;

public class LOADSAVE {
    private static final SafeLoader loader = new SafeLoader();
    public static boolean gQuickSaving;
    public static boolean gAutosaveRequest;
    public static LSInfo lsInf;
    public static int quickslot;
    public static String lastload;
    public static final String savsign = "BLUD";
    public static final int gdxSave = 300;
    public static final int currentGdxSave = 302;
    public static final int SAVEHEADER = 10;
    public static final int SAVETIME = 8;
    public static final int SAVENAME = 16;
    public static final int SAVELEVELINFO = 9;
    public static final int SAVESCREENSHOTSIZE = 64000;
    public static final int SAVEINFO = 43;
    public static final int SAVEGDXDATA = 128;
    public static final char[] filenum;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void FindSaves() {
        FileResource fil = null;
        for (FileEntry file : BuildGdx.compat.getDirectory(Compat.Path.User).getFiles().values()) {
            if (!file.getExtension().equals("sav")) continue;
            String name = file.getFile().getName();
            fil = BuildGdx.compat.open(file);
            if (fil == null) continue;
            try {
                String signature = fil.readString(4);
                if (signature == null) continue;
                short nVersion = 0;
                if (signature.equals(savsign)) {
                    nVersion = fil.readShort();
                    if (nVersion >= 300) {
                        fil.seek(10L, Resource.Whence.Set);
                    } else {
                        fil.seek(328L, Resource.Whence.Set);
                    }
                } else {
                    fil.seek(318L, Resource.Whence.Set);
                }
                long time = 0L;
                if (nVersion >= 301) {
                    time = fil.readLong();
                } else {
                    String num = name.replaceAll("[^0-9]", "");
                    if (!num.isEmpty()) {
                        time = Long.parseLong(num);
                    }
                }
                String savname = fil.readString(16).trim();
                Main.game.pSavemgr.add(savname, time, file.getName());
            }
            catch (Exception exception) {}
            continue;
            finally {
                fil.close();
            }
        }
        Main.game.pSavemgr.sort();
    }

    public static String makeNum(int num) {
        LOADSAVE.filenum[3] = (char)(num % 10 + 48);
        LOADSAVE.filenum[2] = (char)(num / 10 % 10 + 48);
        LOADSAVE.filenum[1] = (char)(num / 100 % 10 + 48);
        LOADSAVE.filenum[0] = (char)(num / 1000 % 10 + 48);
        return new String(filenum);
    }

    public static void MapSave(FileResource fil) {
        int i;
        int mapversion = 7;
        fil.writeInt(mapversion);
        fil.writeInt(0);
        fil.writeInt(0);
        fil.writeInt(0);
        fil.writeShort(0);
        fil.writeShort(0);
        fil.writeShort(Engine.numsectors);
        ByteBuffer buffer = ByteBuffer.allocate(Engine.numsectors * 40);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < Engine.numsectors; ++i) {
            if (Engine.sector[i] == null) continue;
            buffer.putShort(Engine.sector[i].wallptr);
            buffer.putShort(Engine.sector[i].wallnum);
            buffer.putInt(Engine.sector[i].ceilingz);
            buffer.putInt(Engine.sector[i].floorz);
            buffer.putShort(Engine.sector[i].ceilingstat);
            buffer.putShort(Engine.sector[i].floorstat);
            buffer.putShort(Engine.sector[i].ceilingpicnum);
            buffer.putShort(Engine.sector[i].ceilingheinum);
            buffer.put(Engine.sector[i].ceilingshade);
            buffer.put((byte)Engine.sector[i].ceilingpal);
            buffer.put((byte)Engine.sector[i].ceilingxpanning);
            buffer.put((byte)Engine.sector[i].ceilingypanning);
            buffer.putShort(Engine.sector[i].floorpicnum);
            buffer.putShort(Engine.sector[i].floorheinum);
            buffer.put(Engine.sector[i].floorshade);
            buffer.put((byte)Engine.sector[i].floorpal);
            buffer.put((byte)Engine.sector[i].floorxpanning);
            buffer.put((byte)Engine.sector[i].floorypanning);
            buffer.put((byte)Engine.sector[i].visibility);
            buffer.put((byte)Engine.sector[i].filler);
            buffer.putShort(Engine.sector[i].lotag);
            buffer.putShort(Engine.sector[i].hitag);
            buffer.putShort(Engine.sector[i].extra);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        fil.writeShort(Engine.numwalls);
        buffer = ByteBuffer.allocate(Engine.numwalls * 32);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < Engine.numwalls; ++i) {
            if (Engine.wall[i] == null) continue;
            buffer.putInt(Engine.wall[i].x);
            buffer.putInt(Engine.wall[i].y);
            buffer.putShort(Engine.wall[i].point2);
            buffer.putShort(Engine.wall[i].nextwall);
            buffer.putShort(Engine.wall[i].nextsector);
            buffer.putShort(Engine.wall[i].cstat);
            buffer.putShort(Engine.wall[i].picnum);
            buffer.putShort(Engine.wall[i].overpicnum);
            buffer.put(Engine.wall[i].shade);
            buffer.put((byte)Engine.wall[i].pal);
            buffer.put((byte)Engine.wall[i].xrepeat);
            buffer.put((byte)Engine.wall[i].yrepeat);
            buffer.put((byte)Engine.wall[i].xpanning);
            buffer.put((byte)Engine.wall[i].ypanning);
            buffer.putShort(Engine.wall[i].lotag);
            buffer.putShort(Engine.wall[i].hitag);
            buffer.putShort(Engine.wall[i].extra);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        int pos = fil.position();
        fil.writeShort(0);
        buffer = ByteBuffer.allocate(Globals.kMaxSprites * 44);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int spritenum = 0;
        for (int i2 = 0; i2 < Globals.kMaxSprites; ++i2) {
            if (Engine.sprite[i2].statnum == 1024) continue;
            buffer.putInt(Engine.sprite[i2].x);
            buffer.putInt(Engine.sprite[i2].y);
            buffer.putInt(Engine.sprite[i2].z);
            buffer.putShort(Engine.sprite[i2].cstat);
            buffer.putShort(Engine.sprite[i2].picnum);
            buffer.put(Engine.sprite[i2].shade);
            buffer.put((byte)Engine.sprite[i2].pal);
            buffer.put((byte)Engine.sprite[i2].clipdist);
            buffer.put((byte)Engine.sprite[i2].detail);
            buffer.put((byte)Engine.sprite[i2].xrepeat);
            buffer.put((byte)Engine.sprite[i2].yrepeat);
            buffer.put((byte)Engine.sprite[i2].xoffset);
            buffer.put((byte)Engine.sprite[i2].yoffset);
            buffer.putShort(Engine.sprite[i2].sectnum);
            buffer.putShort(Engine.sprite[i2].statnum);
            buffer.putShort(Engine.sprite[i2].ang);
            buffer.putShort(Engine.sprite[i2].owner);
            buffer.putShort(Engine.sprite[i2].xvel);
            buffer.putShort(Engine.sprite[i2].yvel);
            buffer.putShort(Engine.sprite[i2].zvel);
            buffer.putShort(Engine.sprite[i2].lotag);
            buffer.putShort(Engine.sprite[i2].hitag);
            buffer.putShort(Engine.sprite[i2].extra);
            ++spritenum;
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        fil.seek(pos, Resource.Whence.Set);
        fil.writeShort(spritenum);
        fil.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int savegame(String savename, String filename) {
        File file = BuildGdx.compat.checkFile(filename, Compat.Path.User);
        if (file != null && !file.delete()) {
            View.viewSetMessage("Game not saved. Access denied!", -1, 7);
            return -1;
        }
        FileResource fil = BuildGdx.compat.open(filename, Compat.Path.User, FileResource.Mode.Write);
        if (fil != null) {
            long time = Main.game.date.getCurrentDate();
            try {
                LOADSAVE.save(fil, savename, time);
                Main.game.pSavemgr.add(savename, time, filename);
                lastload = filename;
                View.viewSetMessage("Game saved", -1, 10);
            }
            catch (Exception e) {
                View.viewSetMessage("Game not saved! " + e.getMessage(), -1, 7);
            }
            finally {
                fil.close();
            }
            return 0;
        }
        View.viewSetMessage("Game not saved. Access denied!", -1, 7);
        return -1;
    }

    private static void save(FileResource fil, String savename, long time) throws Exception {
        LOADSAVE.SaveVersion(fil, 302);
        LOADSAVE.SaveInfo(fil, savename, time);
        LOADSAVE.SaveGDXBlock(fil);
        LOADSAVE.MySave110(fil, savename, 0);
        LOADSAVE.DudesSave(fil);
        fil.writeByte(Globals.cheatsOn ? 1 : 0);
        LOADSAVE.WarpSave(fil);
        LOADSAVE.MirrorSave(fil);
        LOADSAVE.SeqSave(fil);
        LOADSAVE.EventSave(fil);
        LOADSAVE.TriggersSave(fil);
        LOADSAVE.PlayersSave(fil, 277);
        LOADSAVE.ActorsSave(fil);
        LOADSAVE.GameInfoSave(fil, savename, 0);
        LOADSAVE.StatsSave(fil);
        LOADSAVE.ScreenSave(fil);
        System.gc();
    }

    public static void SaveInfo(FileResource fil, String savename, long time) {
        byte[] buf = new byte[8];
        LittleEndian.putLong(buf, 0, time);
        fil.writeBytes(buf, 8);
        fil.writeBytes(savename.toCharArray(), 16);
        fil.writeByte(Globals.pGameInfo.nDifficulty);
        fil.writeInt(Globals.pGameInfo.nEpisode);
        fil.writeInt(Globals.pGameInfo.nLevel);
        LOADSAVE.SaveScreenshot(fil);
        LOADSAVE.SaveUserEpisodeInfo(fil);
    }

    public static void SaveGDXBlock(FileResource fil) {
        ByteBuffer buffer = ByteBuffer.allocate(128);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)Globals.pGameInfo.nEnemyDamage);
        buffer.put((byte)Globals.pGameInfo.nEnemyQuantity);
        buffer.put((byte)Globals.pGameInfo.nDifficulty);
        buffer.put((byte)(Globals.pGameInfo.nPitchforkOnly ? 1 : 0));
        buffer.put((byte)(Globals.gInfiniteAmmo ? 1 : 0));
        fil.writeBytes(buffer.array(), 128);
    }

    public static void SaveUserEpisodeInfo(FileResource fil) {
        fil.writeByte(Main.mUserFlag == Main.UserFlag.Addon ? 1 : 0);
        if (Main.mUserFlag == Main.UserFlag.Addon) {
            if (LEVELS.currentEpisode != null && LEVELS.currentEpisode.filename != null) {
                String dir = LEVELS.currentEpisode.getDirectory().getRelativePath();
                String filename = LEVELS.currentEpisode.filename;
                if (dir != null && !dir.isEmpty()) {
                    filename = dir + File.separator + filename;
                }
                fil.writeBytes(filename.toCharArray(), 144);
            } else {
                fil.writeBytes(new byte[144], 144);
            }
        }
    }

    public static void SaveScreenshot(FileResource fil) {
        fil.writeBytes(Main.gGameScreen.captBuffer, 64000);
        Main.gGameScreen.captBuffer = null;
    }

    public static void SaveVersion(FileResource fil, int nVersion) {
        fil.writeBytes(savsign.toCharArray(), 4);
        fil.writeShort(nVersion);
        fil.writeInt(4);
    }

    public static void MySave110(FileResource fil, String pName, int nSaveGameSlot) {
        int i;
        int i2;
        int i3;
        int kMaxTiles = 6144;
        fil.writeByte(Globals.pGameInfo.nGameType);
        fil.writeByte(Globals.pGameInfo.nDifficulty);
        fil.writeInt(Globals.pGameInfo.nEpisode);
        fil.writeInt(Globals.pGameInfo.nLevel);
        fil.writeBytes(Globals.pGameInfo.zLevelName.toCharArray(), 144);
        if (Globals.pGameInfo.zLevelSong != null) {
            fil.writeBytes(Globals.pGameInfo.zLevelSong.toCharArray(), 144);
        } else {
            fil.writeBytes(new byte[144], 144);
        }
        fil.writeInt(Globals.pGameInfo.nTrackNumber);
        fil.writeBytes(pName.toCharArray(), 16);
        fil.writeBytes(pName.toCharArray(), 16);
        fil.writeShort(nSaveGameSlot);
        fil.writeInt(0);
        fil.writeInt((int)Globals.pGameInfo.uMapCRC);
        fil.writeByte(Globals.pGameInfo.nMonsterSettings);
        fil.writeInt(Globals.pGameInfo.uGameFlags);
        fil.writeInt(Globals.pGameInfo.uNetGameFlags);
        fil.writeByte(Globals.pGameInfo.nWeaponSettings);
        fil.writeByte(Globals.pGameInfo.nItemSettings);
        fil.writeByte(Globals.pGameInfo.nRespawnSettings);
        fil.writeByte(Globals.pGameInfo.nTeamSettings);
        fil.writeInt(Globals.pGameInfo.nMonsterRespawnTime);
        fil.writeInt(Globals.pGameInfo.nWeaponRespawnTime);
        fil.writeInt(Globals.pGameInfo.nItemRespawnTime);
        fil.writeInt(Globals.pGameInfo.nSpecialRespawnTime);
        fil.writeShort(Engine.numsectors);
        fil.writeShort(Engine.numwalls);
        fil.writeInt(Engine.numsprites);
        ByteBuffer buffer = ByteBuffer.allocate(Engine.numsectors * 40);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i3 = 0; i3 < Engine.numsectors; ++i3) {
            if (Engine.sector[i3] == null) continue;
            buffer.putShort(Engine.sector[i3].wallptr);
            buffer.putShort(Engine.sector[i3].wallnum);
            buffer.putInt(Engine.sector[i3].ceilingz);
            buffer.putInt(Engine.sector[i3].floorz);
            buffer.putShort(Engine.sector[i3].ceilingstat);
            buffer.putShort(Engine.sector[i3].floorstat);
            buffer.putShort(Engine.sector[i3].ceilingpicnum);
            buffer.putShort(Engine.sector[i3].ceilingheinum);
            buffer.put(Engine.sector[i3].ceilingshade);
            buffer.put((byte)Engine.sector[i3].ceilingpal);
            buffer.put((byte)Engine.sector[i3].ceilingxpanning);
            buffer.put((byte)Engine.sector[i3].ceilingypanning);
            buffer.putShort(Engine.sector[i3].floorpicnum);
            buffer.putShort(Engine.sector[i3].floorheinum);
            buffer.put(Engine.sector[i3].floorshade);
            buffer.put((byte)Engine.sector[i3].floorpal);
            buffer.put((byte)Engine.sector[i3].floorxpanning);
            buffer.put((byte)Engine.sector[i3].floorypanning);
            buffer.put((byte)Engine.sector[i3].visibility);
            buffer.put((byte)Engine.sector[i3].filler);
            buffer.putShort(Engine.sector[i3].lotag);
            buffer.putShort(Engine.sector[i3].hitag);
            buffer.putShort(Engine.sector[i3].extra);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(Engine.numwalls * 32);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i3 = 0; i3 < Engine.numwalls; ++i3) {
            if (Engine.wall[i3] == null) continue;
            buffer.putInt(Engine.wall[i3].x);
            buffer.putInt(Engine.wall[i3].y);
            buffer.putShort(Engine.wall[i3].point2);
            buffer.putShort(Engine.wall[i3].nextwall);
            buffer.putShort(Engine.wall[i3].nextsector);
            buffer.putShort(Engine.wall[i3].cstat);
            buffer.putShort(Engine.wall[i3].picnum);
            buffer.putShort(Engine.wall[i3].overpicnum);
            buffer.put(Engine.wall[i3].shade);
            buffer.put((byte)Engine.wall[i3].pal);
            buffer.put((byte)Engine.wall[i3].xrepeat);
            buffer.put((byte)Engine.wall[i3].yrepeat);
            buffer.put((byte)Engine.wall[i3].xpanning);
            buffer.put((byte)Engine.wall[i3].ypanning);
            buffer.putShort(Engine.wall[i3].lotag);
            buffer.putShort(Engine.wall[i3].hitag);
            buffer.putShort(Engine.wall[i3].extra);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(Globals.kMaxSprites * 44);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i3 = 0; i3 < Globals.kMaxSprites; ++i3) {
            buffer.putInt(Engine.sprite[i3].x);
            buffer.putInt(Engine.sprite[i3].y);
            buffer.putInt(Engine.sprite[i3].z);
            buffer.putShort(Engine.sprite[i3].cstat);
            buffer.putShort(Engine.sprite[i3].picnum);
            buffer.put(Engine.sprite[i3].shade);
            buffer.put((byte)Engine.sprite[i3].pal);
            buffer.put((byte)Engine.sprite[i3].clipdist);
            buffer.put((byte)Engine.sprite[i3].detail);
            buffer.put((byte)Engine.sprite[i3].xrepeat);
            buffer.put((byte)Engine.sprite[i3].yrepeat);
            buffer.put((byte)Engine.sprite[i3].xoffset);
            buffer.put((byte)Engine.sprite[i3].yoffset);
            buffer.putShort(Engine.sprite[i3].sectnum);
            buffer.putShort(Engine.sprite[i3].statnum);
            buffer.putShort(Engine.sprite[i3].ang);
            buffer.putShort(Engine.sprite[i3].owner);
            buffer.putShort(Engine.sprite[i3].xvel);
            buffer.putShort(Engine.sprite[i3].yvel);
            buffer.putShort(Engine.sprite[i3].zvel);
            buffer.putShort(Engine.sprite[i3].lotag);
            buffer.putShort(Engine.sprite[i3].hitag);
            buffer.putShort(Engine.sprite[i3].extra);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        fil.writeInt(Gameutils.bseed);
        fil.writeByte(0);
        fil.writeByte(Engine.showinvisibility ? 1 : 0);
        fil.writeInt(0);
        fil.writeInt(Engine.parallaxyscale);
        fil.writeInt(Engine.visibility);
        fil.writeInt(Engine.parallaxvisibility);
        buffer = ByteBuffer.allocate(512);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i3 = 0; i3 < 256; ++i3) {
            buffer.putShort(Engine.pskyoff[i3]);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        fil.writeShort(Engine.pskybits);
        buffer = ByteBuffer.allocate((Globals.kMaxSectors + 1) * 2);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i3 = 0; i3 <= Globals.kMaxSectors; ++i3) {
            buffer.putShort(Engine.headspritesect[i3]);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(2050);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i3 = 0; i3 <= 1024; ++i3) {
            buffer.putShort(Engine.headspritestat[i3]);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(Globals.kMaxSprites * 8);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i3 = 0; i3 < Globals.kMaxSprites; ++i3) {
            buffer.putShort(Engine.prevspritesect[i3]);
        }
        for (i3 = 0; i3 < Globals.kMaxSprites; ++i3) {
            buffer.putShort(Engine.prevspritestat[i3]);
        }
        for (i3 = 0; i3 < Globals.kMaxSprites; ++i3) {
            buffer.putShort(Engine.nextspritesect[i3]);
        }
        for (i3 = 0; i3 < Globals.kMaxSprites; ++i3) {
            buffer.putShort(Engine.nextspritestat[i3]);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        fil.writeBytes(Engine.show2dsector, Engine.show2dsector.length);
        fil.writeBytes(Engine.show2dwall, 1024);
        fil.writeBytes(Engine.show2dsprite, Engine.show2dsprite.length);
        fil.writeByte(Engine.automapping);
        fil.writeBytes(Engine.gotpic, kMaxTiles + 7 >> 3);
        fil.writeBytes(Engine.gotsector, Engine.gotsector.length);
        fil.writeInt(Globals.gFrameClock);
        fil.writeInt(Globals.gTicks);
        fil.writeInt(Globals.gFrame);
        fil.writeInt(Engine.totalclock);
        fil.writeByte(Main.game.gPaused ? 1 : 0);
        fil.writeByte(0);
        buffer = ByteBuffer.allocate(Engine.numwalls * 8);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i3 = 0; i3 < Engine.numwalls; ++i3) {
            buffer.putInt((int)Trigger.kwall[i3].x);
            buffer.putInt((int)Trigger.kwall[i3].y);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(Engine.numsprites * 12);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i3 = 0; i3 < Engine.numsprites; ++i3) {
            buffer.putInt((int)Trigger.ksprite[i3].x);
            buffer.putInt((int)Trigger.ksprite[i3].y);
            buffer.putInt((int)Trigger.ksprite[i3].z);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(Engine.numsectors * 16);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i3 = 0; i3 < Engine.numsectors; ++i3) {
            buffer.putInt(Trigger.secFloorZ[i3]);
        }
        for (i3 = 0; i3 < Engine.numsectors; ++i3) {
            buffer.putInt(Trigger.secCeilZ[i3]);
        }
        for (i3 = 0; i3 < Engine.numsectors; ++i3) {
            buffer.putInt((int)Actor.floorVel[i3]);
        }
        for (i3 = 0; i3 < Engine.numsectors; ++i3) {
            buffer.putInt((int)Actor.ceilingVel[i3]);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        fil.writeShort(Engine.pHitInfo.hitsect);
        fil.writeShort(Engine.pHitInfo.hitwall);
        fil.writeShort(Engine.pHitInfo.hitsprite);
        fil.writeInt(Engine.pHitInfo.hitx);
        fil.writeInt(Engine.pHitInfo.hity);
        fil.writeInt(Engine.pHitInfo.hitz);
        fil.writeByte(Main.mUserFlag == Main.UserFlag.UserMap ? 1 : 0);
        fil.writeByte(1);
        fil.writeByte(1);
        buffer = ByteBuffer.allocate(128);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        String copyright = "Copyright 1997 Monolith Productions.";
        buffer.put(copyright.getBytes());
        fil.writeBytes(buffer.array(), 128);
        buffer = ByteBuffer.allocate(2050);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i2 = 0; i2 <= 1024; ++i2) {
            buffer.putShort(DB.nStatSize[i2]);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(4096);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i2 = 0; i2 < 2048; ++i2) {
            buffer.putShort((short)DB.nextXSprite[i2]);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(1024);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i2 = 0; i2 < 512; ++i2) {
            buffer.putShort((short)DB.nextXWall[i2]);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(1024);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i2 = 0; i2 < 512; ++i2) {
            buffer.putShort((short)DB.nextXSector[i2]);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        byte[] data = new byte[Globals.kMaxSprites * 56];
        int nXSprite = 0;
        for (int i4 = 0; i4 < Globals.kMaxSprites; ++i4) {
            if (Engine.sprite[i4].statnum >= 1024 || Engine.sprite[i4].extra <= 0) continue;
            BitHandler.bput(data, 0 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].reference, 0, 13);
            BitHandler.bput(data, 1 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].state, 6, 6);
            BitHandler.bput(data, 1 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].busy, 7, 23);
            BitHandler.bput(data, 4 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].txID, 0, 9);
            BitHandler.bput(data, 5 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].rxID, 2, 11);
            BitHandler.bput(data, 6 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].command, 4, 11);
            BitHandler.bput(data, 7 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].triggerOn ? 1 : 0, 4, 4);
            BitHandler.bput(data, 7 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].triggerOff ? 1 : 0, 5, 5);
            BitHandler.bput(data, 7 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].wave, 6, 7);
            BitHandler.bput(data, 8 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].busyTime, 0, 11);
            BitHandler.bput(data, 9 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].waitTime, 4, 15);
            BitHandler.bput(data, 11 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].restState, 0, 0);
            BitHandler.bput(data, 11 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].Interrutable ? 1 : 0, 1, 1);
            BitHandler.bput(data, 11 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].respawnPending, 4, 6);
            BitHandler.bput(data, 11 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].lT ? 1 : 0, 7, 7);
            BitHandler.bput(data, 12 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].dropMsg, 0, 7);
            BitHandler.bput(data, 13 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].Decoupled ? 1 : 0, 0, 0);
            BitHandler.bput(data, 13 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].triggerOnce ? 1 : 0, 1, 1);
            BitHandler.bput(data, 13 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].isTriggered ? 1 : 0, 2, 2);
            BitHandler.bput(data, 13 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].key, 3, 5);
            BitHandler.bput(data, 13 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].Push ? 1 : 0, 6, 6);
            BitHandler.bput(data, 13 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].Vector ? 1 : 0, 7, 7);
            BitHandler.bput(data, 14 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].Impact ? 1 : 0, 0, 0);
            BitHandler.bput(data, 14 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].Pickup ? 1 : 0, 1, 1);
            BitHandler.bput(data, 14 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].Touch ? 1 : 0, 2, 2);
            BitHandler.bput(data, 14 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].Sight ? 1 : 0, 3, 3);
            BitHandler.bput(data, 14 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].Proximity ? 1 : 0, 4, 4);
            BitHandler.bput(data, 14 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].l1, 7, 7);
            BitHandler.bput(data, 15 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].l2, 0, 0);
            BitHandler.bput(data, 15 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].l3, 1, 1);
            BitHandler.bput(data, 15 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].l4, 2, 2);
            BitHandler.bput(data, 15 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].l5, 3, 3);
            BitHandler.bput(data, 15 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].lS ? 1 : 0, 4, 4);
            BitHandler.bput(data, 15 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].lB ? 1 : 0, 5, 5);
            BitHandler.bput(data, 15 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].lC ? 1 : 0, 6, 6);
            BitHandler.bput(data, 15 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].DudeLockout ? 1 : 0, 7, 7);
            BitHandler.bput(data, 16 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].data1, 0, 15);
            BitHandler.bput(data, 18 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].data2, 0, 15);
            BitHandler.bput(data, 20 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].data3, 0, 15);
            BitHandler.bput(data, 22 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].goalAng, 0, 10);
            BitHandler.bput(data, 23 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].dodgeDir, 3, 4);
            BitHandler.bput(data, 23 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].Locked, 5, 5);
            BitHandler.bput(data, 23 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].palette, 6, 7);
            BitHandler.bput(data, 24 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].respawn, 0, 1);
            BitHandler.bput(data, 24 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].data4, 2, 17);
            BitHandler.bput(data, 26 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].moveState, 2, 7);
            BitHandler.bput(data, 27 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].lockMsg, 0, 7);
            BitHandler.bput(data, 28 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].health, 0, 11);
            BitHandler.bput(data, 29 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].dudeDeaf ? 1 : 0, 4, 4);
            BitHandler.bput(data, 29 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].dudeAmbush ? 1 : 0, 5, 5);
            BitHandler.bput(data, 29 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].dudeGuard ? 1 : 0, 6, 6);
            BitHandler.bput(data, 29 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].dudeFlag4 ? 1 : 0, 7, 7);
            BitHandler.bput(data, 30 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].target, 0, 15);
            BitHandler.bput(data, 32 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].targetX, 0, 31);
            BitHandler.bput(data, 36 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].targetY, 0, 31);
            BitHandler.bput(data, 40 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].targetZ, 0, 31);
            BitHandler.bput(data, 44 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].burnTime, 0, 15);
            BitHandler.bput(data, 46 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].burnSource, 0, 15);
            BitHandler.bput(data, 48 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].height, 0, 15);
            BitHandler.bput(data, 50 + nXSprite * 56, DB.xsprite[Engine.sprite[i4].extra].stateTimer, 0, 15);
            BitHandler.bput(data, 52 + nXSprite * 56, 0, 0, 31);
            ++nXSprite;
        }
        fil.writeBytes(data, nXSprite * 56);
        data = new byte[Engine.numwalls * XWALL.sizeof];
        int nXWall = 0;
        for (int i5 = 0; i5 < Engine.numwalls; ++i5) {
            if (Engine.wall[i5].extra <= 0) continue;
            BitHandler.bput(data, 0 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i5].extra].reference, 0, 13);
            BitHandler.bput(data, 1 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i5].extra].state, 6, 6);
            BitHandler.bput(data, 1 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i5].extra].busy, 7, 23);
            BitHandler.bput(data, 4 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i5].extra].data, 0, 15);
            BitHandler.bput(data, 6 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i5].extra].txID, 0, 9);
            BitHandler.bput(data, 8 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i5].extra].rxID, 0, 9);
            BitHandler.bput(data, 9 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i5].extra].command, 2, 9);
            BitHandler.bput(data, 10 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i5].extra].triggerOn ? 1 : 0, 2, 2);
            BitHandler.bput(data, 10 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i5].extra].triggerOff ? 1 : 0, 3, 3);
            BitHandler.bput(data, 10 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i5].extra].busyTime, 4, 15);
            BitHandler.bput(data, 12 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i5].extra].waitTime, 0, 11);
            BitHandler.bput(data, 13 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i5].extra].restState, 4, 4);
            BitHandler.bput(data, 13 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i5].extra].interruptable ? 1 : 0, 5, 5);
            BitHandler.bput(data, 13 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i5].extra].panAlways ? 1 : 0, 6, 6);
            BitHandler.bput(data, 13 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i5].extra].panXVel, 7, 14);
            BitHandler.bput(data, 14 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i5].extra].panYVel, 7, 14);
            BitHandler.bput(data, 15 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i5].extra].decoupled ? 1 : 0, 7, 7);
            BitHandler.bput(data, 16 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i5].extra].triggerOnce ? 1 : 0, 0, 0);
            BitHandler.bput(data, 16 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i5].extra].isTriggered ? 1 : 0, 1, 1);
            BitHandler.bput(data, 16 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i5].extra].key, 2, 4);
            BitHandler.bput(data, 16 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i5].extra].triggerPush ? 1 : 0, 5, 5);
            BitHandler.bput(data, 16 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i5].extra].triggerVector ? 1 : 0, 6, 6);
            BitHandler.bput(data, 16 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i5].extra].triggerReserved ? 1 : 0, 7, 7);
            BitHandler.bput(data, 17 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i5].extra].xpanFrac, 0, 7);
            BitHandler.bput(data, 18 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i5].extra].ypanFrac, 0, 7);
            BitHandler.bput(data, 19 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i5].extra].locked, 2, 2);
            BitHandler.bput(data, 19 + nXWall * XWALL.sizeof, DB.xwall[Engine.wall[i5].extra].dudeLockout ? 1 : 0, 3, 3);
            ++nXWall;
        }
        fil.writeBytes(data, nXWall * XWALL.sizeof);
        data = new byte[Engine.numsectors * XSECTOR.sizeof];
        int nXSector = 0;
        for (i = 0; i < Engine.numsectors; ++i) {
            if (Engine.sector[i].extra <= 0) continue;
            BitHandler.bput(data, 0 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].reference, 0, 13);
            BitHandler.bput(data, 1 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].state, 6, 6);
            BitHandler.bput(data, 1 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].busy, 7, 23);
            BitHandler.bput(data, 4 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].data, 0, 15);
            BitHandler.bput(data, 6 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].txID, 0, 9);
            BitHandler.bput(data, 7 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].waveTime[1], 2, 3);
            BitHandler.bput(data, 7 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].waveTime[0], 5, 6);
            BitHandler.bput(data, 8 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].rxID, 0, 9);
            BitHandler.bput(data, 9 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].command, 2, 9);
            BitHandler.bput(data, 10 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].triggerOn ? 1 : 0, 2, 2);
            BitHandler.bput(data, 10 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].triggerOff ? 1 : 0, 3, 3);
            BitHandler.bput(data, 10 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].busyTime[1], 4, 15);
            BitHandler.bput(data, 12 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].waitTime[1], 0, 11);
            BitHandler.bput(data, 13 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].interruptable ? 1 : 0, 5, 5);
            BitHandler.bput(data, 13 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].amplitude, 6, 13);
            BitHandler.bput(data, 14 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].freq, 6, 13);
            BitHandler.bput(data, 15 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].waitFlag[1] ? 1 : 0, 6, 6);
            BitHandler.bput(data, 15 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].waitFlag[0] ? 1 : 0, 7, 7);
            BitHandler.bput(data, 16 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].phase, 0, 7);
            BitHandler.bput(data, 17 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].wave, 0, 3);
            BitHandler.bput(data, 17 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].shadeAlways ? 1 : 0, 4, 4);
            BitHandler.bput(data, 17 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].shadeFloor ? 1 : 0, 5, 5);
            BitHandler.bput(data, 17 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].shadeCeiling ? 1 : 0, 6, 6);
            BitHandler.bput(data, 17 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].shadeWalls ? 1 : 0, 7, 7);
            BitHandler.bput(data, 18 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].shade, 0, 7);
            BitHandler.bput(data, 19 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].panAlways ? 1 : 0, 0, 0);
            BitHandler.bput(data, 19 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].panFloor ? 1 : 0, 1, 1);
            BitHandler.bput(data, 19 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].panCeiling ? 1 : 0, 2, 2);
            BitHandler.bput(data, 19 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].Drag ? 1 : 0, 3, 3);
            BitHandler.bput(data, 19 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].Underwater ? 1 : 0, 4, 4);
            BitHandler.bput(data, 19 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].Depth, 5, 7);
            BitHandler.bput(data, 20 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].panVel, 0, 7);
            BitHandler.bput(data, 21 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].panAngle, 0, 10);
            BitHandler.bput(data, 22 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].wind ? 1 : 0, 3, 3);
            BitHandler.bput(data, 22 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].decoupled ? 1 : 0, 4, 4);
            BitHandler.bput(data, 22 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].triggerOnce ? 1 : 0, 5, 5);
            BitHandler.bput(data, 22 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].isTriggered ? 1 : 0, 6, 6);
            BitHandler.bput(data, 22 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].Key, 7, 9);
            BitHandler.bput(data, 23 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].Push ? 1 : 0, 2, 2);
            BitHandler.bput(data, 23 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].Vector ? 1 : 0, 3, 3);
            BitHandler.bput(data, 23 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].Reserved ? 1 : 0, 4, 4);
            BitHandler.bput(data, 23 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].Enter ? 1 : 0, 5, 5);
            BitHandler.bput(data, 23 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].Exit ? 1 : 0, 6, 6);
            BitHandler.bput(data, 23 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].Wallpush ? 1 : 0, 7, 7);
            BitHandler.bput(data, 24 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].color ? 1 : 0, 0, 0);
            BitHandler.bput(data, 24 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].busyTime[0], 2, 9);
            BitHandler.bput(data, 25 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].waitTime[0], 6, 13);
            BitHandler.bput(data, 27 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].ceilpal, 4, 7);
            BitHandler.bput(data, 28 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].offCeilZ, 0, 31);
            BitHandler.bput(data, 32 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].onCeilZ, 0, 31);
            BitHandler.bput(data, 36 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].offFloorZ, 0, 31);
            BitHandler.bput(data, 40 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].onFloorZ, 0, 31);
            BitHandler.bput(data, 44 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].marker0, 0, 15);
            BitHandler.bput(data, 46 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].marker1, 0, 15);
            BitHandler.bput(data, 48 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].Crush ? 1 : 0, 0, 0);
            BitHandler.bput(data, 48 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].ceilxpanFrac, 1, 8);
            BitHandler.bput(data, 49 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].ceilypanFrac, 1, 8);
            BitHandler.bput(data, 50 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].floorxpanFrac, 1, 8);
            BitHandler.bput(data, 51 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].damageType, 1, 3);
            BitHandler.bput(data, 51 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].floorpal, 4, 7);
            BitHandler.bput(data, 52 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].floorypanFrac, 0, 7);
            BitHandler.bput(data, 53 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].locked, 0, 0);
            BitHandler.bput(data, 53 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].windVel, 1, 10);
            BitHandler.bput(data, 54 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].windAng, 3, 13);
            BitHandler.bput(data, 55 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].windAlways ? 1 : 0, 6, 6);
            BitHandler.bput(data, 55 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].dudelockout ? 1 : 0, 7, 7);
            BitHandler.bput(data, 56 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].bobTheta, 0, 10);
            BitHandler.bput(data, 57 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].bobZRange, 3, 7);
            BitHandler.bput(data, 58 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].bobSpeed, 0, 11);
            BitHandler.bput(data, 59 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].bobAlways ? 1 : 0, 4, 4);
            BitHandler.bput(data, 59 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].bobFloor ? 1 : 0, 5, 5);
            BitHandler.bput(data, 59 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].bobCeiling ? 1 : 0, 6, 6);
            BitHandler.bput(data, 59 + nXSector * XSECTOR.sizeof, DB.xsector[Engine.sector[i].extra].bobRotate ? 1 : 0, 7, 7);
            ++nXSector;
        }
        fil.writeBytes(data, nXSector * XSECTOR.sizeof);
        buffer = ByteBuffer.allocate(Engine.numsprites * 12);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < Engine.numsprites; ++i) {
            buffer.putInt((int)Actor.sprXVel[i]);
        }
        for (i = 0; i < Engine.numsprites; ++i) {
            buffer.putInt((int)Actor.sprYVel[i]);
        }
        for (i = 0; i < Engine.numsprites; ++i) {
            buffer.putInt((int)Actor.sprZVel[i]);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        fil.writeInt(0);
        fil.writeInt(0);
        fil.writeInt(DB.gSkyCount);
        fil.writeByte(Globals.gFogMode ? 1 : 0);
    }

    public static void MySave100(FileResource fil, String pName, int nSaveGameSlot) {
        int i;
        int i2;
        fil.writeByte(Globals.pGameInfo.nGameType);
        fil.writeByte(Globals.pGameInfo.nDifficulty);
        fil.writeInt(Globals.pGameInfo.nEpisode);
        fil.writeInt(Globals.pGameInfo.nLevel);
        fil.writeBytes(Globals.pGameInfo.zLevelName.toCharArray(), 144);
        if (Globals.pGameInfo.zLevelSong != null) {
            fil.writeBytes(Globals.pGameInfo.zLevelSong.toCharArray(), 144);
        } else {
            fil.writeBytes(new byte[144], 144);
        }
        fil.writeInt(Globals.pGameInfo.nTrackNumber);
        fil.writeBytes(pName.toCharArray(), 16);
        fil.writeBytes(pName.toCharArray(), 16);
        fil.writeShort(nSaveGameSlot);
        fil.writeInt(0);
        fil.writeInt((int)Globals.pGameInfo.uMapCRC);
        fil.writeByte(Globals.pGameInfo.nMonsterSettings);
        fil.writeInt(Globals.pGameInfo.uGameFlags);
        fil.writeInt(Globals.pGameInfo.uNetGameFlags);
        fil.writeByte(Globals.pGameInfo.nWeaponSettings);
        fil.writeByte(Globals.pGameInfo.nItemSettings);
        fil.writeByte(Globals.pGameInfo.nRespawnSettings);
        fil.writeByte(Globals.pGameInfo.nTeamSettings);
        fil.writeInt(Globals.pGameInfo.nMonsterRespawnTime);
        fil.writeInt(Globals.pGameInfo.nWeaponRespawnTime);
        fil.writeInt(Globals.pGameInfo.nItemRespawnTime);
        fil.writeInt(Globals.pGameInfo.nSpecialRespawnTime);
        fil.writeInt(Globals.gFrameClock);
        fil.writeInt(Globals.gTicks);
        fil.writeInt(Globals.gFrame);
        fil.writeInt(Engine.totalclock);
        fil.writeByte(Main.game.gPaused ? 1 : 0);
        fil.writeByte(0);
        ByteBuffer buffer = ByteBuffer.allocate(65536);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i2 = 0; i2 < 8192; ++i2) {
            buffer.putInt((int)Trigger.kwall[i2].x);
            buffer.putInt((int)Trigger.kwall[i2].y);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(Globals.kMaxSprites * 12);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i2 = 0; i2 < Globals.kMaxSprites; ++i2) {
            buffer.putInt((int)Trigger.ksprite[i2].x);
            buffer.putInt((int)Trigger.ksprite[i2].y);
            buffer.putInt((int)Trigger.ksprite[i2].z);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(Globals.kMaxSectors * 16);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i2 = 0; i2 < Globals.kMaxSectors; ++i2) {
            buffer.putInt(Trigger.secFloorZ[i2]);
        }
        for (i2 = 0; i2 < Globals.kMaxSectors; ++i2) {
            buffer.putInt(Trigger.secCeilZ[i2]);
        }
        for (i2 = 0; i2 < Globals.kMaxSectors; ++i2) {
            buffer.putInt((int)Actor.floorVel[i2]);
        }
        for (i2 = 0; i2 < Globals.kMaxSectors; ++i2) {
            buffer.putInt((int)Actor.ceilingVel[i2]);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        fil.writeShort(Engine.pHitInfo.hitsect);
        fil.writeShort(Engine.pHitInfo.hitwall);
        fil.writeShort(Engine.pHitInfo.hitsprite);
        fil.writeInt(Engine.pHitInfo.hitx);
        fil.writeInt(Engine.pHitInfo.hity);
        fil.writeInt(Engine.pHitInfo.hitz);
        fil.writeByte(Main.mUserFlag == Main.UserFlag.UserMap ? 1 : 0);
        buffer = ByteBuffer.allocate(2050);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i2 = 0; i2 <= 1024; ++i2) {
            buffer.putShort(DB.nStatSize[i2]);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        byte[] data = new byte[114688];
        for (i = 0; i < 2048; ++i) {
            if (DB.xsprite[i] == null) continue;
            BitHandler.bput(data, 0 + i * 56, DB.xsprite[i].reference, 0, 13);
            BitHandler.bput(data, 1 + i * 56, DB.xsprite[i].state, 6, 6);
            BitHandler.bput(data, 1 + i * 56, DB.xsprite[i].busy, 7, 23);
            BitHandler.bput(data, 4 + i * 56, DB.xsprite[i].txID, 0, 9);
            BitHandler.bput(data, 5 + i * 56, DB.xsprite[i].rxID, 2, 11);
            BitHandler.bput(data, 6 + i * 56, DB.xsprite[i].command, 4, 11);
            BitHandler.bput(data, 7 + i * 56, DB.xsprite[i].triggerOn ? 1 : 0, 4, 4);
            BitHandler.bput(data, 7 + i * 56, DB.xsprite[i].triggerOff ? 1 : 0, 5, 5);
            BitHandler.bput(data, 7 + i * 56, DB.xsprite[i].wave, 6, 7);
            BitHandler.bput(data, 8 + i * 56, DB.xsprite[i].busyTime, 0, 11);
            BitHandler.bput(data, 9 + i * 56, DB.xsprite[i].waitTime, 4, 15);
            BitHandler.bput(data, 11 + i * 56, DB.xsprite[i].restState, 0, 0);
            BitHandler.bput(data, 11 + i * 56, DB.xsprite[i].Interrutable ? 1 : 0, 1, 1);
            BitHandler.bput(data, 11 + i * 56, DB.xsprite[i].respawnPending, 4, 6);
            BitHandler.bput(data, 11 + i * 56, DB.xsprite[i].lT ? 1 : 0, 7, 7);
            BitHandler.bput(data, 12 + i * 56, DB.xsprite[i].dropMsg, 0, 7);
            BitHandler.bput(data, 13 + i * 56, DB.xsprite[i].Decoupled ? 1 : 0, 0, 0);
            BitHandler.bput(data, 13 + i * 56, DB.xsprite[i].triggerOnce ? 1 : 0, 1, 1);
            BitHandler.bput(data, 13 + i * 56, DB.xsprite[i].isTriggered ? 1 : 0, 2, 2);
            BitHandler.bput(data, 13 + i * 56, DB.xsprite[i].key, 3, 5);
            BitHandler.bput(data, 13 + i * 56, DB.xsprite[i].Push ? 1 : 0, 6, 6);
            BitHandler.bput(data, 13 + i * 56, DB.xsprite[i].Vector ? 1 : 0, 7, 7);
            BitHandler.bput(data, 14 + i * 56, DB.xsprite[i].Impact ? 1 : 0, 0, 0);
            BitHandler.bput(data, 14 + i * 56, DB.xsprite[i].Pickup ? 1 : 0, 1, 1);
            BitHandler.bput(data, 14 + i * 56, DB.xsprite[i].Touch ? 1 : 0, 2, 2);
            BitHandler.bput(data, 14 + i * 56, DB.xsprite[i].Sight ? 1 : 0, 3, 3);
            BitHandler.bput(data, 14 + i * 56, DB.xsprite[i].Proximity ? 1 : 0, 4, 4);
            BitHandler.bput(data, 14 + i * 56, DB.xsprite[i].l1, 7, 7);
            BitHandler.bput(data, 15 + i * 56, DB.xsprite[i].l2, 0, 0);
            BitHandler.bput(data, 15 + i * 56, DB.xsprite[i].l3, 1, 1);
            BitHandler.bput(data, 15 + i * 56, DB.xsprite[i].l4, 2, 2);
            BitHandler.bput(data, 15 + i * 56, DB.xsprite[i].l5, 3, 3);
            BitHandler.bput(data, 15 + i * 56, DB.xsprite[i].lS ? 1 : 0, 4, 4);
            BitHandler.bput(data, 15 + i * 56, DB.xsprite[i].lB ? 1 : 0, 5, 5);
            BitHandler.bput(data, 15 + i * 56, DB.xsprite[i].lC ? 1 : 0, 6, 6);
            BitHandler.bput(data, 15 + i * 56, DB.xsprite[i].DudeLockout ? 1 : 0, 7, 7);
            BitHandler.bput(data, 16 + i * 56, DB.xsprite[i].data1, 0, 15);
            BitHandler.bput(data, 18 + i * 56, DB.xsprite[i].data2, 0, 15);
            BitHandler.bput(data, 20 + i * 56, DB.xsprite[i].data3, 0, 15);
            BitHandler.bput(data, 22 + i * 56, DB.xsprite[i].goalAng, 0, 10);
            BitHandler.bput(data, 23 + i * 56, DB.xsprite[i].dodgeDir, 3, 4);
            BitHandler.bput(data, 23 + i * 56, DB.xsprite[i].Locked, 5, 5);
            BitHandler.bput(data, 23 + i * 56, DB.xsprite[i].palette, 6, 7);
            BitHandler.bput(data, 24 + i * 56, DB.xsprite[i].respawn, 0, 1);
            BitHandler.bput(data, 24 + i * 56, DB.xsprite[i].data4, 2, 17);
            BitHandler.bput(data, 26 + i * 56, DB.xsprite[i].moveState, 2, 7);
            BitHandler.bput(data, 27 + i * 56, DB.xsprite[i].lockMsg, 0, 7);
            BitHandler.bput(data, 28 + i * 56, DB.xsprite[i].health, 0, 11);
            BitHandler.bput(data, 29 + i * 56, DB.xsprite[i].dudeDeaf ? 1 : 0, 4, 4);
            BitHandler.bput(data, 29 + i * 56, DB.xsprite[i].dudeAmbush ? 1 : 0, 5, 5);
            BitHandler.bput(data, 29 + i * 56, DB.xsprite[i].dudeGuard ? 1 : 0, 6, 6);
            BitHandler.bput(data, 29 + i * 56, DB.xsprite[i].dudeFlag4 ? 1 : 0, 7, 7);
            BitHandler.bput(data, 30 + i * 56, DB.xsprite[i].target, 0, 15);
            BitHandler.bput(data, 32 + i * 56, DB.xsprite[i].targetX, 0, 31);
            BitHandler.bput(data, 36 + i * 56, DB.xsprite[i].targetY, 0, 31);
            BitHandler.bput(data, 40 + i * 56, DB.xsprite[i].targetZ, 0, 31);
            BitHandler.bput(data, 44 + i * 56, DB.xsprite[i].burnTime, 0, 15);
            BitHandler.bput(data, 46 + i * 56, DB.xsprite[i].burnSource, 0, 15);
            BitHandler.bput(data, 48 + i * 56, DB.xsprite[i].height, 0, 15);
            BitHandler.bput(data, 50 + i * 56, DB.xsprite[i].stateTimer, 0, 15);
            BitHandler.bput(data, 52 + i * 56, 0, 0, 31);
        }
        fil.writeBytes(data, data.length);
        data = new byte[512 * XWALL.sizeof];
        for (i = 0; i < 512; ++i) {
            if (DB.xwall[i] == null) continue;
            BitHandler.bput(data, 0 + i * XWALL.sizeof, DB.xwall[i].reference, 0, 13);
            BitHandler.bput(data, 1 + i * XWALL.sizeof, DB.xwall[i].state, 6, 6);
            BitHandler.bput(data, 1 + i * XWALL.sizeof, DB.xwall[i].busy, 7, 23);
            BitHandler.bput(data, 4 + i * XWALL.sizeof, DB.xwall[i].data, 0, 15);
            BitHandler.bput(data, 6 + i * XWALL.sizeof, DB.xwall[i].txID, 0, 9);
            BitHandler.bput(data, 8 + i * XWALL.sizeof, DB.xwall[i].rxID, 0, 9);
            BitHandler.bput(data, 9 + i * XWALL.sizeof, DB.xwall[i].command, 2, 9);
            BitHandler.bput(data, 10 + i * XWALL.sizeof, DB.xwall[i].triggerOn ? 1 : 0, 2, 2);
            BitHandler.bput(data, 10 + i * XWALL.sizeof, DB.xwall[i].triggerOff ? 1 : 0, 3, 3);
            BitHandler.bput(data, 10 + i * XWALL.sizeof, DB.xwall[i].busyTime, 4, 15);
            BitHandler.bput(data, 12 + i * XWALL.sizeof, DB.xwall[i].waitTime, 0, 11);
            BitHandler.bput(data, 13 + i * XWALL.sizeof, DB.xwall[i].restState, 4, 4);
            BitHandler.bput(data, 13 + i * XWALL.sizeof, DB.xwall[i].interruptable ? 1 : 0, 5, 5);
            BitHandler.bput(data, 13 + i * XWALL.sizeof, DB.xwall[i].panAlways ? 1 : 0, 6, 6);
            BitHandler.bput(data, 13 + i * XWALL.sizeof, DB.xwall[i].panXVel, 7, 14);
            BitHandler.bput(data, 14 + i * XWALL.sizeof, DB.xwall[i].panYVel, 7, 14);
            BitHandler.bput(data, 15 + i * XWALL.sizeof, DB.xwall[i].decoupled ? 1 : 0, 7, 7);
            BitHandler.bput(data, 16 + i * XWALL.sizeof, DB.xwall[i].triggerOnce ? 1 : 0, 0, 0);
            BitHandler.bput(data, 16 + i * XWALL.sizeof, DB.xwall[i].isTriggered ? 1 : 0, 1, 1);
            BitHandler.bput(data, 16 + i * XWALL.sizeof, DB.xwall[i].key, 2, 4);
            BitHandler.bput(data, 16 + i * XWALL.sizeof, DB.xwall[i].triggerPush ? 1 : 0, 5, 5);
            BitHandler.bput(data, 16 + i * XWALL.sizeof, DB.xwall[i].triggerVector ? 1 : 0, 6, 6);
            BitHandler.bput(data, 16 + i * XWALL.sizeof, DB.xwall[i].triggerReserved ? 1 : 0, 7, 7);
            BitHandler.bput(data, 17 + i * XWALL.sizeof, DB.xwall[i].xpanFrac, 0, 7);
            BitHandler.bput(data, 18 + i * XWALL.sizeof, DB.xwall[i].ypanFrac, 0, 7);
            BitHandler.bput(data, 19 + i * XWALL.sizeof, DB.xwall[i].locked, 2, 2);
            BitHandler.bput(data, 19 + i * XWALL.sizeof, DB.xwall[i].dudeLockout ? 1 : 0, 3, 3);
        }
        fil.writeBytes(data, data.length);
        data = new byte[512 * XSECTOR.sizeof];
        for (i = 0; i < 512; ++i) {
            if (DB.xsector[i] == null) continue;
            BitHandler.bput(data, 0 + i * XSECTOR.sizeof, DB.xsector[i].reference, 0, 13);
            BitHandler.bput(data, 1 + i * XSECTOR.sizeof, DB.xsector[i].state, 6, 6);
            BitHandler.bput(data, 1 + i * XSECTOR.sizeof, DB.xsector[i].busy, 7, 23);
            BitHandler.bput(data, 4 + i * XSECTOR.sizeof, DB.xsector[i].data, 0, 15);
            BitHandler.bput(data, 6 + i * XSECTOR.sizeof, DB.xsector[i].txID, 0, 9);
            BitHandler.bput(data, 7 + i * XSECTOR.sizeof, DB.xsector[i].waveTime[1], 2, 3);
            BitHandler.bput(data, 7 + i * XSECTOR.sizeof, DB.xsector[i].waveTime[0], 5, 6);
            BitHandler.bput(data, 8 + i * XSECTOR.sizeof, DB.xsector[i].rxID, 0, 9);
            BitHandler.bput(data, 9 + i * XSECTOR.sizeof, DB.xsector[i].command, 2, 9);
            BitHandler.bput(data, 10 + i * XSECTOR.sizeof, DB.xsector[i].triggerOn ? 1 : 0, 2, 2);
            BitHandler.bput(data, 10 + i * XSECTOR.sizeof, DB.xsector[i].triggerOff ? 1 : 0, 3, 3);
            BitHandler.bput(data, 10 + i * XSECTOR.sizeof, DB.xsector[i].busyTime[1], 4, 15);
            BitHandler.bput(data, 12 + i * XSECTOR.sizeof, DB.xsector[i].waitTime[1], 0, 11);
            BitHandler.bput(data, 13 + i * XSECTOR.sizeof, DB.xsector[i].interruptable ? 1 : 0, 5, 5);
            BitHandler.bput(data, 13 + i * XSECTOR.sizeof, DB.xsector[i].amplitude, 6, 13);
            BitHandler.bput(data, 14 + i * XSECTOR.sizeof, DB.xsector[i].freq, 6, 13);
            BitHandler.bput(data, 15 + i * XSECTOR.sizeof, DB.xsector[i].waitFlag[1] ? 1 : 0, 6, 6);
            BitHandler.bput(data, 15 + i * XSECTOR.sizeof, DB.xsector[i].waitFlag[0] ? 1 : 0, 7, 7);
            BitHandler.bput(data, 16 + i * XSECTOR.sizeof, DB.xsector[i].phase, 0, 7);
            BitHandler.bput(data, 17 + i * XSECTOR.sizeof, DB.xsector[i].wave, 0, 3);
            BitHandler.bput(data, 17 + i * XSECTOR.sizeof, DB.xsector[i].shadeAlways ? 1 : 0, 4, 4);
            BitHandler.bput(data, 17 + i * XSECTOR.sizeof, DB.xsector[i].shadeFloor ? 1 : 0, 5, 5);
            BitHandler.bput(data, 17 + i * XSECTOR.sizeof, DB.xsector[i].shadeCeiling ? 1 : 0, 6, 6);
            BitHandler.bput(data, 17 + i * XSECTOR.sizeof, DB.xsector[i].shadeWalls ? 1 : 0, 7, 7);
            BitHandler.bput(data, 18 + i * XSECTOR.sizeof, DB.xsector[i].shade, 0, 7);
            BitHandler.bput(data, 19 + i * XSECTOR.sizeof, DB.xsector[i].panAlways ? 1 : 0, 0, 0);
            BitHandler.bput(data, 19 + i * XSECTOR.sizeof, DB.xsector[i].panFloor ? 1 : 0, 1, 1);
            BitHandler.bput(data, 19 + i * XSECTOR.sizeof, DB.xsector[i].panCeiling ? 1 : 0, 2, 2);
            BitHandler.bput(data, 19 + i * XSECTOR.sizeof, DB.xsector[i].Drag ? 1 : 0, 3, 3);
            BitHandler.bput(data, 19 + i * XSECTOR.sizeof, DB.xsector[i].Underwater ? 1 : 0, 4, 4);
            BitHandler.bput(data, 19 + i * XSECTOR.sizeof, DB.xsector[i].Depth, 5, 7);
            BitHandler.bput(data, 20 + i * XSECTOR.sizeof, DB.xsector[i].panVel, 0, 7);
            BitHandler.bput(data, 21 + i * XSECTOR.sizeof, DB.xsector[i].panAngle, 0, 10);
            BitHandler.bput(data, 22 + i * XSECTOR.sizeof, DB.xsector[i].wind ? 1 : 0, 3, 3);
            BitHandler.bput(data, 22 + i * XSECTOR.sizeof, DB.xsector[i].decoupled ? 1 : 0, 4, 4);
            BitHandler.bput(data, 22 + i * XSECTOR.sizeof, DB.xsector[i].triggerOnce ? 1 : 0, 5, 5);
            BitHandler.bput(data, 22 + i * XSECTOR.sizeof, DB.xsector[i].isTriggered ? 1 : 0, 6, 6);
            BitHandler.bput(data, 22 + i * XSECTOR.sizeof, DB.xsector[i].Key, 7, 9);
            BitHandler.bput(data, 23 + i * XSECTOR.sizeof, DB.xsector[i].Push ? 1 : 0, 2, 2);
            BitHandler.bput(data, 23 + i * XSECTOR.sizeof, DB.xsector[i].Vector ? 1 : 0, 3, 3);
            BitHandler.bput(data, 23 + i * XSECTOR.sizeof, DB.xsector[i].Reserved ? 1 : 0, 4, 4);
            BitHandler.bput(data, 23 + i * XSECTOR.sizeof, DB.xsector[i].Enter ? 1 : 0, 5, 5);
            BitHandler.bput(data, 23 + i * XSECTOR.sizeof, DB.xsector[i].Exit ? 1 : 0, 6, 6);
            BitHandler.bput(data, 23 + i * XSECTOR.sizeof, DB.xsector[i].Wallpush ? 1 : 0, 7, 7);
            BitHandler.bput(data, 24 + i * XSECTOR.sizeof, DB.xsector[i].color ? 1 : 0, 0, 0);
            BitHandler.bput(data, 24 + i * XSECTOR.sizeof, DB.xsector[i].busyTime[0], 2, 9);
            BitHandler.bput(data, 25 + i * XSECTOR.sizeof, DB.xsector[i].waitTime[0], 6, 13);
            BitHandler.bput(data, 27 + i * XSECTOR.sizeof, DB.xsector[i].ceilpal, 4, 7);
            BitHandler.bput(data, 28 + i * XSECTOR.sizeof, DB.xsector[i].offCeilZ, 0, 31);
            BitHandler.bput(data, 32 + i * XSECTOR.sizeof, DB.xsector[i].onCeilZ, 0, 31);
            BitHandler.bput(data, 36 + i * XSECTOR.sizeof, DB.xsector[i].offFloorZ, 0, 31);
            BitHandler.bput(data, 40 + i * XSECTOR.sizeof, DB.xsector[i].onFloorZ, 0, 31);
            BitHandler.bput(data, 44 + i * XSECTOR.sizeof, DB.xsector[i].marker0, 0, 15);
            BitHandler.bput(data, 46 + i * XSECTOR.sizeof, DB.xsector[i].marker1, 0, 15);
            BitHandler.bput(data, 48 + i * XSECTOR.sizeof, DB.xsector[i].Crush ? 1 : 0, 0, 0);
            BitHandler.bput(data, 48 + i * XSECTOR.sizeof, DB.xsector[i].ceilxpanFrac, 1, 8);
            BitHandler.bput(data, 49 + i * XSECTOR.sizeof, DB.xsector[i].ceilypanFrac, 1, 8);
            BitHandler.bput(data, 50 + i * XSECTOR.sizeof, DB.xsector[i].floorxpanFrac, 1, 8);
            BitHandler.bput(data, 51 + i * XSECTOR.sizeof, DB.xsector[i].damageType, 1, 3);
            BitHandler.bput(data, 51 + i * XSECTOR.sizeof, DB.xsector[i].floorpal, 4, 7);
            BitHandler.bput(data, 52 + i * XSECTOR.sizeof, DB.xsector[i].floorypanFrac, 0, 7);
            BitHandler.bput(data, 53 + i * XSECTOR.sizeof, DB.xsector[i].locked, 0, 0);
            BitHandler.bput(data, 53 + i * XSECTOR.sizeof, DB.xsector[i].windVel, 1, 10);
            BitHandler.bput(data, 54 + i * XSECTOR.sizeof, DB.xsector[i].windAng, 3, 13);
            BitHandler.bput(data, 55 + i * XSECTOR.sizeof, DB.xsector[i].windAlways ? 1 : 0, 6, 6);
            BitHandler.bput(data, 55 + i * XSECTOR.sizeof, DB.xsector[i].dudelockout ? 1 : 0, 7, 7);
            BitHandler.bput(data, 56 + i * XSECTOR.sizeof, DB.xsector[i].bobTheta, 0, 10);
            BitHandler.bput(data, 57 + i * XSECTOR.sizeof, DB.xsector[i].bobZRange, 3, 7);
            BitHandler.bput(data, 58 + i * XSECTOR.sizeof, DB.xsector[i].bobSpeed, 0, 11);
            BitHandler.bput(data, 59 + i * XSECTOR.sizeof, DB.xsector[i].bobAlways ? 1 : 0, 4, 4);
            BitHandler.bput(data, 59 + i * XSECTOR.sizeof, DB.xsector[i].bobFloor ? 1 : 0, 5, 5);
            BitHandler.bput(data, 59 + i * XSECTOR.sizeof, DB.xsector[i].bobCeiling ? 1 : 0, 6, 6);
            BitHandler.bput(data, 59 + i * XSECTOR.sizeof, DB.xsector[i].bobRotate ? 1 : 0, 7, 7);
        }
        fil.writeBytes(data, data.length);
        buffer = ByteBuffer.allocate(Globals.kMaxSprites * 12);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < Globals.kMaxSprites; ++i) {
            buffer.putInt((int)Actor.sprXVel[i]);
        }
        for (i = 0; i < Globals.kMaxSprites; ++i) {
            buffer.putInt((int)Actor.sprYVel[i]);
        }
        for (i = 0; i < Globals.kMaxSprites; ++i) {
            buffer.putInt((int)Actor.sprZVel[i]);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(4096);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < 2048; ++i) {
            buffer.putShort((short)DB.nextXSprite[i]);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(1024);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < 512; ++i) {
            buffer.putShort((short)DB.nextXWall[i]);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(1024);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < 512; ++i) {
            buffer.putShort((short)DB.nextXSector[i]);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        fil.writeInt(0);
        fil.writeInt(0);
        fil.writeInt(DB.gSkyCount);
        fil.writeByte(Globals.gFogMode ? 1 : 0);
        buffer = ByteBuffer.allocate(Globals.kMaxSectors * 40);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < Globals.kMaxSectors; ++i) {
            if (Engine.sector[i] == null) continue;
            buffer.putShort(Engine.sector[i].wallptr);
            buffer.putShort(Engine.sector[i].wallnum);
            buffer.putInt(Engine.sector[i].ceilingz);
            buffer.putInt(Engine.sector[i].floorz);
            buffer.putShort(Engine.sector[i].ceilingstat);
            buffer.putShort(Engine.sector[i].floorstat);
            buffer.putShort(Engine.sector[i].ceilingpicnum);
            buffer.putShort(Engine.sector[i].ceilingheinum);
            buffer.put(Engine.sector[i].ceilingshade);
            buffer.put((byte)Engine.sector[i].ceilingpal);
            buffer.put((byte)Engine.sector[i].ceilingxpanning);
            buffer.put((byte)Engine.sector[i].ceilingypanning);
            buffer.putShort(Engine.sector[i].floorpicnum);
            buffer.putShort(Engine.sector[i].floorheinum);
            buffer.put(Engine.sector[i].floorshade);
            buffer.put((byte)Engine.sector[i].floorpal);
            buffer.put((byte)Engine.sector[i].floorxpanning);
            buffer.put((byte)Engine.sector[i].floorypanning);
            buffer.put((byte)Engine.sector[i].visibility);
            buffer.put((byte)Engine.sector[i].filler);
            buffer.putShort(Engine.sector[i].lotag);
            buffer.putShort(Engine.sector[i].hitag);
            buffer.putShort(Engine.sector[i].extra);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(262144);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < 8192; ++i) {
            if (Engine.wall[i] == null) continue;
            buffer.putInt(Engine.wall[i].x);
            buffer.putInt(Engine.wall[i].y);
            buffer.putShort(Engine.wall[i].point2);
            buffer.putShort(Engine.wall[i].nextwall);
            buffer.putShort(Engine.wall[i].nextsector);
            buffer.putShort(Engine.wall[i].cstat);
            buffer.putShort(Engine.wall[i].picnum);
            buffer.putShort(Engine.wall[i].overpicnum);
            buffer.put(Engine.wall[i].shade);
            buffer.put((byte)Engine.wall[i].pal);
            buffer.put((byte)Engine.wall[i].xrepeat);
            buffer.put((byte)Engine.wall[i].yrepeat);
            buffer.put((byte)Engine.wall[i].xpanning);
            buffer.put((byte)Engine.wall[i].ypanning);
            buffer.putShort(Engine.wall[i].lotag);
            buffer.putShort(Engine.wall[i].hitag);
            buffer.putShort(Engine.wall[i].extra);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(Globals.kMaxSprites * 44);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < Globals.kMaxSprites; ++i) {
            buffer.putInt(Engine.sprite[i].x);
            buffer.putInt(Engine.sprite[i].y);
            buffer.putInt(Engine.sprite[i].z);
            buffer.putShort(Engine.sprite[i].cstat);
            buffer.putShort(Engine.sprite[i].picnum);
            buffer.put(Engine.sprite[i].shade);
            buffer.put((byte)Engine.sprite[i].pal);
            buffer.put((byte)Engine.sprite[i].clipdist);
            buffer.put((byte)Engine.sprite[i].detail);
            buffer.put((byte)Engine.sprite[i].xrepeat);
            buffer.put((byte)Engine.sprite[i].yrepeat);
            buffer.put((byte)Engine.sprite[i].xoffset);
            buffer.put((byte)Engine.sprite[i].yoffset);
            buffer.putShort(Engine.sprite[i].sectnum);
            buffer.putShort(Engine.sprite[i].statnum);
            buffer.putShort(Engine.sprite[i].ang);
            buffer.putShort(Engine.sprite[i].owner);
            buffer.putShort(Engine.sprite[i].xvel);
            buffer.putShort(Engine.sprite[i].yvel);
            buffer.putShort(Engine.sprite[i].zvel);
            buffer.putShort(Engine.sprite[i].lotag);
            buffer.putShort(Engine.sprite[i].hitag);
            buffer.putShort(Engine.sprite[i].extra);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        fil.writeShort(Engine.numsectors);
        fil.writeShort(Engine.numwalls);
        fil.writeInt(Gameutils.bseed);
        fil.writeByte(0);
        fil.writeByte(Engine.showinvisibility ? 1 : 0);
        fil.writeInt(0);
        fil.writeInt(Engine.parallaxyscale);
        fil.writeInt(Engine.visibility);
        fil.writeInt(Engine.parallaxvisibility);
        buffer = ByteBuffer.allocate(512);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < 256; ++i) {
            buffer.putShort(Engine.pskyoff[i]);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        fil.writeShort(Engine.pskybits);
        buffer = ByteBuffer.allocate((Globals.kMaxSectors + 1) * 2);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i <= Globals.kMaxSectors; ++i) {
            buffer.putShort(Engine.headspritesect[i]);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(2050);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i <= 1024; ++i) {
            buffer.putShort(Engine.headspritestat[i]);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(Globals.kMaxSprites * 8);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < Globals.kMaxSprites; ++i) {
            buffer.putShort(Engine.prevspritesect[i]);
        }
        for (i = 0; i < Globals.kMaxSprites; ++i) {
            buffer.putShort(Engine.prevspritestat[i]);
        }
        for (i = 0; i < Globals.kMaxSprites; ++i) {
            buffer.putShort(Engine.nextspritesect[i]);
        }
        for (i = 0; i < Globals.kMaxSprites; ++i) {
            buffer.putShort(Engine.nextspritestat[i]);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        fil.writeBytes(Engine.show2dsector, Engine.show2dsector.length);
        fil.writeBytes(Engine.show2dwall, 1024);
        fil.writeBytes(Engine.show2dsprite, Engine.show2dsprite.length);
        fil.writeByte(Engine.automapping);
        fil.writeBytes(Engine.gotpic, 512);
        fil.writeBytes(Engine.gotsector, Engine.gotsector.length);
    }

    public static void DudesSave(FileResource fil) {
        int i;
        ByteBuffer buffer = ByteBuffer.allocate(16384);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < 2048; ++i) {
            buffer.putInt(Ai.cumulDamage[i]);
        }
        for (i = 0; i < 2048; ++i) {
            buffer.putInt(Ai.gDudeSlope[i]);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
    }

    public static void WarpSave(FileResource fil) {
        int i;
        ByteBuffer buffer = ByteBuffer.allocate(128);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < 8; ++i) {
            buffer.putInt((int)Warp.gStartZone[i].x);
            buffer.putInt((int)Warp.gStartZone[i].y);
            buffer.putInt((int)Warp.gStartZone[i].z);
            buffer.putShort(Warp.gStartZone[i].sector);
            buffer.putShort(Warp.gStartZone[i].angle);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(Globals.kMaxSectors * 4);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < Globals.kMaxSectors; ++i) {
            buffer.putShort((short)Warp.gUpperLink[i]);
        }
        for (i = 0; i < Globals.kMaxSectors; ++i) {
            buffer.putShort((short)Warp.gLowerLink[i]);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
    }

    public static void MirrorSave(FileResource fil) {
        int i;
        fil.writeInt(Mirror.mirrorcnt);
        fil.writeInt(Mirror.MirrorSector);
        ByteBuffer buffer = ByteBuffer.allocate(384);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < 16; ++i) {
            buffer.putShort((short)Mirror.MirrorType[i]);
            buffer.putShort((short)0);
            buffer.putInt(Mirror.MirrorLower[i]);
            buffer.putInt(Mirror.MirrorX[i]);
            buffer.putInt(Mirror.MirrorY[i]);
            buffer.putInt(Mirror.MirrorZ[i]);
            buffer.putInt(Mirror.MirrorUpper[i]);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(16);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < 4; ++i) {
            buffer.putInt(Mirror.MirrorWall[i]);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
    }

    public static void SeqSave(FileResource fil) {
        int i;
        ByteBuffer buffer = ByteBuffer.allocate(20480);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < 512; ++i) {
            buffer.put(SeqHandling.siWall[i].getBytes());
        }
        for (i = 0; i < 512; ++i) {
            buffer.put(SeqHandling.siMasked[i].getBytes());
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(20480);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < 512; ++i) {
            buffer.put(SeqHandling.siCeiling[i].getBytes());
        }
        for (i = 0; i < 512; ++i) {
            buffer.put(SeqHandling.siFloor[i].getBytes());
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(40960);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < 2048; ++i) {
            buffer.put(SeqHandling.siSprite[i].getBytes());
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(SeqHandling.kMaxSequences * 3);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < SeqHandling.kMaxSequences; ++i) {
            SeqInst pInst = SeqHandling.activeList.getInst(i);
            if (pInst instanceof WallInst) {
                buffer.put((byte)0);
            } else if (pInst instanceof MaskedWallInst) {
                buffer.put((byte)4);
            } else if (pInst instanceof FloorInst) {
                buffer.put((byte)2);
            } else if (pInst instanceof CeilingInst) {
                buffer.put((byte)1);
            } else if (pInst instanceof SpriteInst) {
                buffer.put((byte)3);
            } else {
                buffer.put((byte)-1);
            }
            buffer.putShort(SeqHandling.activeList.getIndex(i));
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        fil.writeInt(SeqHandling.activeList.getSize());
    }

    public static void EventSave(FileResource fil) {
        int i;
        ByteBuffer buffer = ByteBuffer.allocate(8192);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(0);
        buffer.putInt(0);
        for (i = 0; i < 1023; ++i) {
            if (i < EVENT.eventQ.getSize()) {
                PriorityItem item = EVENT.eventQ.getItem(i);
                buffer.putInt((int)item.priority);
                buffer.putInt(item.event);
                continue;
            }
            buffer.putInt(0);
            buffer.putInt(0);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        fil.writeInt(0);
        fil.writeInt(0);
        fil.writeInt(EVENT.eventQ.getSize());
        buffer = ByteBuffer.allocate(16384);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < 4096; ++i) {
            buffer.putInt(EVENT.getEvent(EVENT.rxBucket[i].index, EVENT.rxBucket[i].type, 0, 0));
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(2050);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i <= 1024; ++i) {
            buffer.putShort(EVENT.bucketHead[i]);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
    }

    public static void TriggersSave(FileResource fil) {
        int i;
        fil.writeInt(Trigger.gBusyCount);
        ByteBuffer buffer = ByteBuffer.allocate(1664);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < 128; ++i) {
            buffer.putInt(Trigger.gBusy[i].nIndex);
            buffer.putInt(Trigger.gBusy[i].nDelta);
            buffer.putInt(Trigger.gBusy[i].nBusy);
            buffer.put((byte)Trigger.gBusy[i].busyProc);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(Globals.kMaxSectors * 4);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < Globals.kMaxSectors; ++i) {
            buffer.putInt(Trigger.secPath[i]);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
    }

    public static void PlayersSave(FileResource fil, int nVersion) {
        int i;
        for (i = 0; i < 8; ++i) {
            fil.writeInt(Globals.nTeamCount[i]);
        }
        fil.writeInt(Mmulti.numplayers);
        for (i = 0; i < 8; ++i) {
            fil.writeByte(Main.game.net.gProfile[i].autoaim ? 1 : 0);
            if (nVersion >= 302) {
                fil.writeByte(Main.game.net.gProfile[i].slopetilt ? 1 : 0);
            }
            fil.writeByte(Main.game.net.gProfile[i].skill);
            fil.writeBytes(Main.game.net.gProfile[i].name.toCharArray(), 15);
        }
        for (i = 0; i < 8; ++i) {
            fil.writeInt(0);
            fil.writeInt(0);
            fil.writeInt(0);
            byte[] input = Globals.gPlayer[i].pInput.getBytes(nVersion);
            fil.writeBytes(input, input.length);
            byte[] data = Globals.gPlayer[i].getBytes(nVersion);
            fil.writeBytes(data, data.length);
        }
    }

    public static void ActorsSave(FileResource fil) {
        int i;
        ByteBuffer buffer = ByteBuffer.allocate(24576);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < 2048; ++i) {
            buffer.putInt(Actor.gSpriteHit[i].moveHit);
            buffer.putInt(Actor.gSpriteHit[i].ceilHit);
            buffer.putInt(Actor.gSpriteHit[i].floorHit);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(Globals.kMaxSectors * 2);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < Globals.kMaxSectors; ++i) {
            buffer.putShort((short)Actor.gSectorExp[i]);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        buffer = ByteBuffer.allocate(1024);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < 512; ++i) {
            buffer.putShort((short)Actor.gWallExp[i]);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        fil.writeInt(Actor.gPostCount);
        buffer = ByteBuffer.allocate(Globals.kMaxSprites * 4);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < Globals.kMaxSprites; ++i) {
            buffer.putShort(Actor.gPost[i].nSprite);
            buffer.putShort(Actor.gPost[i].nStatus);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
    }

    public static void UnkSave(FileResource fil) {
        fil.writeShort(0);
    }

    public static void GameInfoSave(FileResource fil, String pName, int nSaveGameSlot) {
        fil.writeInt(LEVELS.gNextMap);
        fil.writeShort(0);
        fil.writeByte(Globals.pGameInfo.nGameType);
        fil.writeByte(Globals.pGameInfo.nDifficulty);
        fil.writeInt(Globals.pGameInfo.nEpisode);
        fil.writeInt(Globals.pGameInfo.nLevel);
        fil.writeBytes(Globals.pGameInfo.zLevelName.toCharArray(), 144);
        if (Globals.pGameInfo.zLevelSong != null) {
            fil.writeBytes(Globals.pGameInfo.zLevelSong.toCharArray(), 144);
        } else {
            fil.writeBytes(new byte[144], 144);
        }
        fil.writeInt(Globals.pGameInfo.nTrackNumber);
        fil.writeBytes(pName.toCharArray(), 16);
        fil.writeBytes(pName.toCharArray(), 16);
        fil.writeShort(nSaveGameSlot);
        fil.writeInt(0);
        fil.writeInt((int)Globals.pGameInfo.uMapCRC);
        fil.writeByte(Globals.pGameInfo.nMonsterSettings);
        fil.writeInt(Globals.pGameInfo.uGameFlags);
        fil.writeInt(Globals.pGameInfo.uNetGameFlags);
        fil.writeByte(Globals.pGameInfo.nWeaponSettings);
        fil.writeByte(Globals.pGameInfo.nItemSettings);
        fil.writeByte(Globals.pGameInfo.nRespawnSettings);
        fil.writeByte(Globals.pGameInfo.nTeamSettings);
        fil.writeInt(Globals.pGameInfo.nMonsterRespawnTime);
        fil.writeInt(Globals.pGameInfo.nWeaponRespawnTime);
        fil.writeInt(Globals.pGameInfo.nItemRespawnTime);
        fil.writeInt(Globals.pGameInfo.nSpecialRespawnTime);
        fil.writeByte(0);
        fil.writeByte(0);
    }

    public static void StatsSave(FileResource fil) {
        fil.writeInt(LEVELS.totalSecrets);
        fil.writeInt(LEVELS.foundSecret);
        fil.writeInt(LEVELS.superSecrets);
        fil.writeInt(LEVELS.totalKills);
        fil.writeInt(LEVELS.kills);
    }

    public static void ScreenSave(FileResource fil) {
        fil.writeInt(123);
        fil.writeBytes(new byte[256], 256);
        fil.writeShort(0);
        fil.writeShort(0);
        fil.writeInt(0);
        fil.writeInt(View.deliriumTilt);
        fil.writeInt(View.deliriumTurn);
        fil.writeInt(View.deliriumPitch);
    }

    public static void quicksave() {
        if (Mmulti.numplayers > 1 || Globals.kFakeMultiplayer) {
            return;
        }
        if (Globals.gMe.pXsprite.health != 0) {
            gQuickSaving = true;
        }
    }

    public static boolean checkfile(Resource bb) {
        int saveHeader = LOADSAVE.checkSave(bb);
        int nVersion = saveHeader & 0xFFFF;
        if (nVersion < 300) {
            Console.Println("Dos saved game found, version: " + nVersion);
        }
        if (nVersion != 302 && nVersion != 277 && nVersion != 256) {
            return false;
        }
        return loader.load(bb, nVersion);
    }

    public static boolean canLoad(String filename) {
        FileResource fil = BuildGdx.compat.open(filename, Compat.Path.User, FileResource.Mode.Read);
        if (fil != null) {
            int nVersion = LOADSAVE.checkSave(fil) & 0xFFFF;
            if (nVersion != 302 && nVersion >= 300) {
                final BloodIniFile addon = loader.LoadGDXHeader(fil);
                if (LOADSAVE.loader.safeGameInfo.nLevel <= 16 && LOADSAVE.loader.safeGameInfo.nEpisode < 6 && LOADSAVE.loader.safeGameInfo.nDifficulty >= 0 && LOADSAVE.loader.safeGameInfo.nDifficulty < 5 && !LOADSAVE.loader.gForceMap) {
                    MenuCorruptGame menu = (MenuCorruptGame)Main.game.menu.mMenus[17];
                    menu.setRunnable(new Runnable(){

                        @Override
                        public void run() {
                            int nEpisode = loader.safeGameInfo.nEpisode;
                            int nLevel = loader.safeGameInfo.nLevel;
                            int nSkill = loader.safeGameInfo.nDifficulty;
                            Main.gGameScreen.newgame(false, addon, nEpisode, nLevel, nSkill, nSkill, nSkill, false);
                        }
                    });
                    Main.game.menu.mOpen(menu, -1);
                }
            }
            fil.close();
            return nVersion == 302;
        }
        return false;
    }

    public static void quickload() {
        if (Mmulti.numplayers > 1) {
            return;
        }
        final String loadname = Main.game.pSavemgr.getLast();
        if (loadname != null && LOADSAVE.canLoad(loadname)) {
            Main.game.changeScreen(Main.gLoadingScreen.setTitle(loadname));
            Main.gLoadingScreen.init(new Runnable(){

                @Override
                public void run() {
                    if (!LOADSAVE.loadgame(loadname)) {
                        Main.game.setPrevScreen();
                        Main.game.pNet.ready2send = true;
                    }
                }
            });
        }
    }

    public static int lsReadLoadData(String filename) {
        FileResource file = BuildGdx.compat.open(filename, Compat.Path.User, FileResource.Mode.Read);
        if (file != null) {
            BloodTile pic = Main.engine.getTile(SaveManager.Screenshot);
            if (pic.data == null) {
                Main.engine.allocatepermanenttile(SaveManager.Screenshot, 320, 200);
            }
            int nVersion = LOADSAVE.checkSave(file) & 0xFFFF;
            lsInf.clear();
            switch (nVersion) {
                case 302: {
                    file.seek(10L, Resource.Whence.Set);
                    LOADSAVE.lsInf.date = Main.game.date.getDate(file.readLong());
                    file.seek(34L, Resource.Whence.Set);
                    lsInf.read(file);
                    if (file.remaining() <= 64000) {
                        file.close();
                        return -1;
                    }
                    file.read(pic.data, 0, 64000);
                    byte gUserEpisode = file.readByte();
                    if (gUserEpisode == 1) {
                        String ininame;
                        byte[] buf = new byte[144];
                        file.read(buf, 0, 144);
                        String fullname = new String(buf).trim();
                        int filenameIndex = -1;
                        filenameIndex = fullname.indexOf(":");
                        if (filenameIndex != -1) {
                            String ext = FileUtils.getExtension(fullname.substring(0, filenameIndex));
                            ininame = ext + ":" + Main.game.getFilename(fullname.substring(filenameIndex + 1));
                        } else {
                            ininame = Main.game.getFilename(fullname);
                        }
                        if (!ininame.isEmpty()) {
                            LOADSAVE.lsInf.iniName = "File: " + ininame;
                        }
                    }
                    int nEnemyDamage = file.readByte() + 1;
                    int nEnemyQuantity = file.readByte() + 1;
                    int nDifficulty = file.readByte() + 1;
                    boolean nPitchforkOnly = file.readBoolean();
                    if (LOADSAVE.lsInf.skill != nEnemyDamage || LOADSAVE.lsInf.skill != nEnemyQuantity || LOADSAVE.lsInf.skill != nDifficulty || nPitchforkOnly) {
                        LOADSAVE.lsInf.skill = 6;
                    }
                    lsInf.update();
                    Main.engine.getrender().invalidatetile(SaveManager.Screenshot, 0, -1);
                    file.close();
                    return 1;
                }
                case 256: {
                    file.seek(1L, Resource.Whence.Set);
                    lsInf.read(file);
                    file.close();
                    return -1;
                }
            }
            file.seek(11L, Resource.Whence.Set);
            if (nVersion >= 300) {
                LOADSAVE.lsInf.info = "Incompatible ver. " + nVersion + " != " + 302;
            } else {
                lsInf.read(file);
            }
            file.close();
            return -1;
        }
        lsInf.clear();
        return -1;
    }

    public static void LoadGameInfo() {
        Globals.pGameInfo.copy(LOADSAVE.loader.safeGameInfo);
    }

    public static int checkSave(Resource bb) {
        String signature = bb.readString(4);
        if (signature == null || !signature.equals(savsign)) {
            Console.Println("Old saved game found");
            return 256;
        }
        short nVersion = bb.readShort();
        int nBuild = bb.readInt();
        return nVersion | nBuild << 16;
    }

    public static boolean loadgame(String filename) {
        FileResource fil = BuildGdx.compat.open(filename, Compat.Path.User, FileResource.Mode.Read);
        if (fil != null) {
            Console.Println("debug: start loadgame()", Console.OSDTEXT_BLUE);
            boolean status = LOADSAVE.checkfile(fil);
            fil.close();
            if (status) {
                LOADSAVE.load();
                if (lastload == null || lastload.isEmpty()) {
                    lastload = filename;
                }
                if (loader.getMessage() != null) {
                    View.viewSetMessage(loader.getMessage(), -1, 7);
                }
                return true;
            }
            View.viewSetMessage("Incompatible version of saved game found!", -1, 7);
            return false;
        }
        View.viewSetMessage("Can't access to file or file not found!", -1, 7);
        return false;
    }

    public static boolean load() {
        SOUND.sndStopAllSamples();
        SOUND.sfxKillAll3DSounds();
        SOUND.ambStopAll();
        SeqHandling.seqKillAll();
        View.resetQuotes();
        DB.dbInit();
        Trigger.trInitStructs();
        Actor.actInitStruct();
        LOADSAVE.LoadGDXBlock();
        LOADSAVE.MyLoad();
        LOADSAVE.DudesLoad();
        LOADSAVE.WarpLoad();
        LOADSAVE.MirrorLoad();
        LOADSAVE.SeqLoad();
        LOADSAVE.EventLoad();
        LOADSAVE.TriggersLoad();
        LOADSAVE.PlayersLoad();
        LOADSAVE.ActorsLoad();
        LOADSAVE.GameInfoLoad();
        LOADSAVE.StatsLoad();
        LOADSAVE.ScreenLoad();
        LOADSAVE.LoadUserEpisodeInfo();
        Globals.cheatsOn = LOADSAVE.loader.cheatsOn;
        Globals.gInfiniteAmmo = LOADSAVE.loader.gInfiniteAmmo;
        Mirror.InitMirrorTiles();
        LEVELS.loadMapInfo(Globals.pGameInfo.nEpisode, Globals.pGameInfo.nLevel);
        DB.gVisibility = Engine.visibility;
        if (Main.mUserFlag == Main.UserFlag.UserMap || LEVELS.currentEpisode.gMapInfo[Globals.pGameInfo.nLevel] == null || LEVELS.currentEpisode.gMapInfo[Globals.pGameInfo.nLevel].Title == null) {
            LEVELS.gUserMapInfo.MapName = LEVELS.gUserMapInfo.Title = Globals.pGameInfo.zLevelName + ".map";
            Globals.boardfilename = LEVELS.gUserMapInfo.Title;
            LEVELS.gUserMapInfo.Song = null;
            LEVELS.gUserMapInfo.Track = 0;
        } else {
            Globals.boardfilename = LEVELS.currentEpisode.gMapInfo[Globals.pGameInfo.nLevel].Title;
        }
        if (!Main.game.isCurrentScreen(Main.gGameScreen) && !Main.game.isCurrentScreen(Main.gDemoScreen)) {
            Screen.scrLoadPLUs();
        }
        SECTORFX.InitSectorFX();
        ((BloodNetwork)Main.game.pNet).PredictReset();
        Main.gPrecacheScreen.init(false, new Runnable(){

            @Override
            public void run() {
                SOUND.ambPrepare();
                SOUND.sndPlayMusic();
                View.viewSetMessage("Game loaded", -1, 10);
                Globals.gTicks = 0;
                Globals.gFrame = 0;
                Screen.scrReset();
                View.gViewPos = 0;
                View.gViewMode = 3;
                Engine.totalclock = 0;
                Main.game.gPaused = false;
                Main.game.changeScreen(Main.gGameScreen);
                Main.game.pNet.ResetTimers();
                Main.game.pNet.WaitForAllPlayers(0);
                Main.game.pNet.ready2send = true;
                Main.game.nNetMode = BuildGame.NetMode.Single;
                BuildGdx.audio.getSound().setReverb(false, 0.0f);
                View.PaletteView = 0;
                Screen.scrSetPalette(View.PaletteView);
                if (PLAYER.powerupCheck(Globals.gMe, 18) != 0) {
                    BuildGdx.audio.getSound().setReverb(true, 0.2f);
                }
                if (PLAYER.powerupCheck(Globals.gMe, 24) != 0) {
                    BuildGdx.audio.getSound().setReverb(true, 0.4f);
                }
                Main.game.pInput.resetMousePos();
                System.gc();
                Console.Println("debug: end loadgame()", Console.OSDTEXT_BLUE);
            }
        });
        Main.game.changeScreen(Main.gPrecacheScreen);
        return true;
    }

    public static void LoadGDXBlock() {
        Globals.pGameInfo.nEnemyDamage = LOADSAVE.loader.safeGameInfo.nEnemyDamage;
        Globals.pGameInfo.nEnemyQuantity = LOADSAVE.loader.safeGameInfo.nEnemyQuantity;
        Globals.pGameInfo.nDifficulty = LOADSAVE.loader.safeGameInfo.nDifficulty;
        Globals.pGameInfo.nPitchforkOnly = LOADSAVE.loader.safeGameInfo.nPitchforkOnly;
        Globals.gInfiniteAmmo = LOADSAVE.loader.gInfiniteAmmo;
    }

    public static void MyLoad() {
        int i;
        LOADSAVE.LoadGameInfo();
        Engine.numsectors = LOADSAVE.loader.numsectors;
        Engine.numwalls = LOADSAVE.loader.numwalls;
        Engine.numsprites = LOADSAVE.loader.numsprites;
        for (i = 0; i < Engine.numsectors; ++i) {
            if (Engine.sector[i] == null) {
                Engine.sector[i] = new SECTOR();
            }
            Engine.sector[i].set(LOADSAVE.loader.sector[i]);
        }
        for (i = 0; i < Engine.numwalls; ++i) {
            if (Engine.wall[i] == null) {
                Engine.wall[i] = new WALL();
            }
            Engine.wall[i].set(LOADSAVE.loader.wall[i]);
        }
        for (i = 0; i < Globals.kMaxSprites; ++i) {
            Engine.sprite[i].set(LOADSAVE.loader.sprite[i]);
        }
        Gameutils.bseed = LOADSAVE.loader.randomseed;
        Engine.showinvisibility = LOADSAVE.loader.showinvisibility;
        Engine.parallaxyscale = LOADSAVE.loader.parallaxyscale;
        Engine.visibility = LOADSAVE.loader.visibility;
        Engine.parallaxvisibility = LOADSAVE.loader.parallaxvisibility;
        System.arraycopy(LOADSAVE.loader.pskyoff, 0, Engine.pskyoff, 0, 256);
        Engine.pskybits = LOADSAVE.loader.pskybits;
        Arrays.fill(Engine.zeropskyoff, (short)0);
        System.arraycopy(Engine.pskyoff, 0, Engine.zeropskyoff, 0, 256);
        if (Globals.kMaxSectors + 1 >= 0) {
            System.arraycopy(LOADSAVE.loader.headspritesect, 0, Engine.headspritesect, 0, Globals.kMaxSectors + 1);
        }
        System.arraycopy(LOADSAVE.loader.headspritestat, 0, Engine.headspritestat, 0, 1025);
        if (Globals.kMaxSprites >= 0) {
            System.arraycopy(LOADSAVE.loader.prevspritesect, 0, Engine.prevspritesect, 0, Globals.kMaxSprites);
        }
        if (Globals.kMaxSprites >= 0) {
            System.arraycopy(LOADSAVE.loader.prevspritestat, 0, Engine.prevspritestat, 0, Globals.kMaxSprites);
        }
        if (Globals.kMaxSprites >= 0) {
            System.arraycopy(LOADSAVE.loader.nextspritesect, 0, Engine.nextspritesect, 0, Globals.kMaxSprites);
        }
        if (Globals.kMaxSprites >= 0) {
            System.arraycopy(LOADSAVE.loader.nextspritestat, 0, Engine.nextspritestat, 0, Globals.kMaxSprites);
        }
        if (Globals.kMaxSectors + 7 >> 3 >= 0) {
            System.arraycopy(LOADSAVE.loader.show2dsector, 0, Engine.show2dsector, 0, Globals.kMaxSectors + 7 >> 3);
        }
        System.arraycopy(LOADSAVE.loader.show2dwall, 0, Engine.show2dwall, 0, 1024);
        if (Globals.kMaxSprites + 7 >> 3 >= 0) {
            System.arraycopy(LOADSAVE.loader.show2dsprite, 0, Engine.show2dsprite, 0, Globals.kMaxSprites + 7 >> 3);
        }
        Engine.automapping = LOADSAVE.loader.automapping;
        if (Globals.kMaxTiles + 7 >> 3 >= 0) {
            System.arraycopy(LOADSAVE.loader.gotpic, 0, Engine.gotpic, 0, Globals.kMaxTiles + 7 >> 3);
        }
        if (Globals.kMaxSectors + 7 >> 3 >= 0) {
            System.arraycopy(LOADSAVE.loader.gotsector, 0, Engine.gotsector, 0, Globals.kMaxSectors + 7 >> 3);
        }
        Globals.gFrameClock = LOADSAVE.loader.gFrameClock;
        Globals.gTicks = LOADSAVE.loader.gTicks;
        Globals.gFrame = LOADSAVE.loader.gFrame;
        Engine.totalclock = LOADSAVE.loader.gGameClock;
        Main.game.gPaused = LOADSAVE.loader.gPaused;
        for (i = 0; i < LOADSAVE.loader.kwall.length; ++i) {
            Trigger.kwall[i].set(LOADSAVE.loader.kwall[i]);
        }
        for (i = 0; i < LOADSAVE.loader.ksprite.length; ++i) {
            Trigger.ksprite[i].set(LOADSAVE.loader.ksprite[i]);
        }
        if (Engine.numsectors >= 0) {
            System.arraycopy(LOADSAVE.loader.secFloorZ, 0, Trigger.secFloorZ, 0, Engine.numsectors);
        }
        if (Engine.numsectors >= 0) {
            System.arraycopy(LOADSAVE.loader.secCeilZ, 0, Trigger.secCeilZ, 0, Engine.numsectors);
        }
        if (Engine.numsectors >= 0) {
            System.arraycopy(LOADSAVE.loader.floorVel, 0, Actor.floorVel, 0, Engine.numsectors);
        }
        if (Engine.numsectors >= 0) {
            System.arraycopy(LOADSAVE.loader.ceilingVel, 0, Actor.ceilingVel, 0, Engine.numsectors);
        }
        Engine.pHitInfo.hitsect = LOADSAVE.loader.safeHitInfo.hitsect;
        Engine.pHitInfo.hitwall = LOADSAVE.loader.safeHitInfo.hitwall;
        Engine.pHitInfo.hitsprite = LOADSAVE.loader.safeHitInfo.hitsprite;
        Engine.pHitInfo.hitx = LOADSAVE.loader.safeHitInfo.hitx;
        Engine.pHitInfo.hity = LOADSAVE.loader.safeHitInfo.hity;
        Engine.pHitInfo.hitz = LOADSAVE.loader.safeHitInfo.hitz;
        Main.mUserFlag = Main.UserFlag.None;
        if (LOADSAVE.loader.gForceMap) {
            Main.mUserFlag = Main.UserFlag.UserMap;
        }
        System.arraycopy(LOADSAVE.loader.nStatSize, 0, DB.nStatSize, 0, 1025);
        System.arraycopy(LOADSAVE.loader.nextXSprite, 0, DB.nextXSprite, 0, 2048);
        System.arraycopy(LOADSAVE.loader.nextXWall, 0, DB.nextXWall, 0, 512);
        System.arraycopy(LOADSAVE.loader.nextXSector, 0, DB.nextXSector, 0, 512);
        for (i = 0; i < 2048; ++i) {
            DB.xsprite[i].copy(LOADSAVE.loader.xsprite[i]);
        }
        for (i = 0; i < 512; ++i) {
            DB.xwall[i].copy(LOADSAVE.loader.xwall[i]);
        }
        for (i = 0; i < 512; ++i) {
            DB.xsector[i].copy(LOADSAVE.loader.xsector[i]);
        }
        System.arraycopy(LOADSAVE.loader.sprXVel, 0, Actor.sprXVel, 0, Globals.kMaxSprites);
        System.arraycopy(LOADSAVE.loader.sprYVel, 0, Actor.sprYVel, 0, Globals.kMaxSprites);
        System.arraycopy(LOADSAVE.loader.sprZVel, 0, Actor.sprZVel, 0, Globals.kMaxSprites);
        DB.gSkyCount = LOADSAVE.loader.gSkyCount;
        Globals.gFogMode = LOADSAVE.loader.gFogMode;
        Globals.gNoClip = LOADSAVE.loader.gNoClip;
        Globals.gFullMap = LOADSAVE.loader.gFullMap;
    }

    public static void DudesLoad() {
        Arrays.fill(Ai.cumulDamage, 0);
        System.arraycopy(LOADSAVE.loader.gDudeSlope, 0, Ai.gDudeSlope, 0, 2048);
    }

    public static void WarpLoad() {
        for (int i = 0; i < 8; ++i) {
            Warp.gStartZone[i].x = LOADSAVE.loader.gStartZone[i].x;
            Warp.gStartZone[i].y = LOADSAVE.loader.gStartZone[i].y;
            Warp.gStartZone[i].z = LOADSAVE.loader.gStartZone[i].z;
            Warp.gStartZone[i].sector = LOADSAVE.loader.gStartZone[i].sector;
            Warp.gStartZone[i].angle = LOADSAVE.loader.gStartZone[i].angle;
        }
        if (Globals.kMaxSectors >= 0) {
            System.arraycopy(LOADSAVE.loader.gUpperLink, 0, Warp.gUpperLink, 0, Globals.kMaxSectors);
        }
        if (Globals.kMaxSectors >= 0) {
            System.arraycopy(LOADSAVE.loader.gLowerLink, 0, Warp.gLowerLink, 0, Globals.kMaxSectors);
        }
    }

    public static void MirrorLoad() {
        Mirror.mirrorcnt = LOADSAVE.loader.mirrorcnt;
        Mirror.MirrorSector = LOADSAVE.loader.MirrorSector;
        for (int i = 0; i < 16; ++i) {
            Mirror.MirrorType[i] = LOADSAVE.loader.MirrorType[i];
            Mirror.MirrorLower[i] = LOADSAVE.loader.MirrorLower[i];
            Mirror.MirrorX[i] = LOADSAVE.loader.MirrorX[i];
            Mirror.MirrorY[i] = LOADSAVE.loader.MirrorY[i];
            Mirror.MirrorZ[i] = LOADSAVE.loader.MirrorZ[i];
            Mirror.MirrorUpper[i] = LOADSAVE.loader.MirrorUpper[i];
        }
        System.arraycopy(LOADSAVE.loader.MirrorWall, 0, Mirror.MirrorWall, 0, 4);
        Mirror.initMirrorWall();
    }

    public static void SeqLoad() {
        int i;
        for (i = 0; i < 512; ++i) {
            SeqHandling.siWall[i].copy(LOADSAVE.loader.siWall[i]);
        }
        for (i = 0; i < 512; ++i) {
            SeqHandling.siMasked[i].copy(LOADSAVE.loader.siMasked[i]);
        }
        for (i = 0; i < 512; ++i) {
            SeqHandling.siCeiling[i].copy(LOADSAVE.loader.siCeiling[i]);
        }
        for (i = 0; i < 512; ++i) {
            SeqHandling.siFloor[i].copy(LOADSAVE.loader.siFloor[i]);
        }
        for (i = 0; i < 2048; ++i) {
            SeqHandling.siSprite[i].copy(LOADSAVE.loader.siSprite[i]);
        }
        SeqHandling.activeList.set(LOADSAVE.loader.actListType, LOADSAVE.loader.actListIndex, LOADSAVE.loader.activeCount);
    }

    public static void EventLoad() {
        int i;
        if (EVENT.eventQ == null || EVENT.eventQ instanceof BPriorityQueue) {
            if (EVENT.gdxEventQ == null) {
                EVENT.gdxEventQ = new JPriorityQueue(1024);
            }
            EVENT.eventQ = EVENT.gdxEventQ;
            for (i = 0; i < 4096; ++i) {
                if (EVENT.rxBucket[i] == null) {
                    EVENT.rxBucket[i] = new RXBUCKET();
                    continue;
                }
                EVENT.rxBucket[i].flush();
            }
        }
        EVENT.eventQ.flush();
        for (i = 0; i <= LOADSAVE.loader.fNodeCount; ++i) {
            EVENT.eventQ.Insert(LOADSAVE.loader.qEventPriority[i], LOADSAVE.loader.qEventEvent[i]);
        }
        for (i = 0; i < 4096; ++i) {
            EVENT.rxBucket[i].index = LOADSAVE.loader.rxBucketIndex[i];
            EVENT.rxBucket[i].type = LOADSAVE.loader.rxBucketType[i];
        }
        System.arraycopy(LOADSAVE.loader.bucketHead, 0, EVENT.bucketHead, 0, 1025);
    }

    public static void TriggersLoad() {
        Trigger.gBusyCount = LOADSAVE.loader.gBusyCount;
        for (int i = 0; i < 128; ++i) {
            Trigger.gBusy[i].nIndex = LOADSAVE.loader.gBusy[i].nIndex;
            Trigger.gBusy[i].nDelta = LOADSAVE.loader.gBusy[i].nDelta;
            Trigger.gBusy[i].nBusy = LOADSAVE.loader.gBusy[i].nBusy;
            Trigger.gBusy[i].busyProc = LOADSAVE.loader.gBusy[i].busyProc;
        }
        if (Globals.kMaxSectors >= 0) {
            System.arraycopy(LOADSAVE.loader.secPath, 0, Trigger.secPath, 0, Globals.kMaxSectors);
        }
    }

    public static void PlayersLoad() {
        int i;
        System.arraycopy(LOADSAVE.loader.nTeamCount, 0, Globals.nTeamCount, 0, 8);
        Mmulti.numplayers = (short)LOADSAVE.loader.gNetPlayers;
        if (Mmulti.numplayers >= 0) {
            System.arraycopy(LOADSAVE.loader.connectpoint2, 0, Mmulti.connectpoint2, 0, Mmulti.numplayers);
        }
        for (i = 0; i < 8; ++i) {
            if (LOADSAVE.loader.autoaim[i] != -1) {
                boolean bl = Main.game.net.gProfile[i].autoaim = LOADSAVE.loader.autoaim[i] == 1;
            }
            if (LOADSAVE.loader.slopetilt[i] != -1) {
                boolean bl = Main.game.net.gProfile[i].slopetilt = LOADSAVE.loader.slopetilt[i] == 1;
            }
            if (LOADSAVE.loader.skill[i] != -1) {
                Main.game.net.gProfile[i].skill = LOADSAVE.loader.skill[i];
            }
            if (LOADSAVE.loader.name[i] == null) continue;
            Main.game.net.gProfile[i].name = LOADSAVE.loader.name[i];
        }
        for (i = 0; i < 8; ++i) {
            LOADSAVE.loader.safePlayer[i].pInput.Copy(Globals.gPlayer[i].pInput);
            Globals.gPlayer[i].copy(LOADSAVE.loader.safePlayer[i]);
        }
        for (i = 0; i < Mmulti.numplayers; ++i) {
            Globals.gPlayer[i].pSprite = Engine.sprite[Globals.gPlayer[i].nSprite];
            Globals.gPlayer[i].pXsprite = DB.xsprite[Globals.gPlayer[i].pSprite.extra];
            Globals.gPlayer[i].pDudeInfo = DudeInfo.dudeInfo[Globals.gPlayer[i].pSprite.lotag - 200];
        }
        View.gViewIndex = Mmulti.myconnectindex;
    }

    public static void ActorsLoad() {
        if (Globals.kMaxSectors >= 0) {
            System.arraycopy(LOADSAVE.loader.gSectorExp, 0, Actor.gSectorExp, 0, Globals.kMaxSectors);
        }
        System.arraycopy(LOADSAVE.loader.gWallExp, 0, Actor.gWallExp, 0, 512);
        Actor.gPostCount = LOADSAVE.loader.gPostCount;
        Actor.actInit(true, DEMO.IsOriginalDemo());
        for (int p = 0; p < Mmulti.numplayers; ++p) {
            PLAYER.playerSetRace(Globals.gPlayer[p], Globals.gPlayer[p].nLifeMode);
            Globals.gPlayer[p].ang = Globals.gPlayer[p].pSprite.ang;
        }
    }

    public static void GameInfoLoad() {
        LEVELS.gNextMap = LOADSAVE.loader.gNextMap;
        LOADSAVE.LoadGameInfo();
    }

    public static void StatsLoad() {
        LEVELS.totalSecrets = LOADSAVE.loader.totalSecrets;
        LEVELS.foundSecret = LOADSAVE.loader.foundSecret;
        LEVELS.superSecrets = LOADSAVE.loader.superSecrets;
        LEVELS.totalKills = LOADSAVE.loader.totalKills;
        LEVELS.kills = LOADSAVE.loader.kills;
    }

    public static void ScreenLoad() {
        View.deliriumTilt = LOADSAVE.loader.deliriumTilt;
        View.deliriumTurn = LOADSAVE.loader.deliriumTurn;
        View.deliriumPitch = LOADSAVE.loader.deliriumPitch;
    }

    public static void LoadUserEpisodeInfo() {
        if (LOADSAVE.loader.gUserEpisode) {
            Main.mUserFlag = Main.UserFlag.Addon;
        }
        if (Main.mUserFlag == Main.UserFlag.Addon) {
            BloodIniFile ini = LOADSAVE.loader.addon;
            LEVELS.getEpisodeInfo(LEVELS.gUserEpisodeInfo, ini);
            LEVELS.checkEpisodeResources(ini);
        } else {
            LEVELS.resetEpisodeResources();
        }
    }

    static {
        lsInf = new LSInfo();
        quickslot = 0;
        filenum = new char[4];
    }
}

