/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Menus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ru.m210projects.Blood.Factory.BloodMenuHandler;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Menus.MenuDifficulty;
import ru.m210projects.Blood.Types.BloodIniFile;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuList;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Pattern.MenuItems.MenuTitle;

public class MenuNewAddon
extends BuildMenu {
    private BloodIniFile ini;
    private final MenuList mSlot;
    private final List<char[]> mEpisodelist;
    private final int[] episodeNum;

    public MenuNewAddon(Main app) {
        final BloodMenuHandler menu = app.menu;
        MenuTitle EpTitle = new MenuTitle(app.pEngine, "Episode", app.getFont(1), 160, 20, 2038);
        this.mEpisodelist = new ArrayList<char[]>();
        this.episodeNum = new int[6];
        MenuProc newEpProc = new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuList button = (MenuList)pItem;
                MenuDifficulty next = (MenuDifficulty)menu.mMenus[4];
                next.setEpisode(MenuNewAddon.this.ini, MenuNewAddon.this.episodeNum[button.l_nFocus]);
                menu.mOpen(next, -1);
            }
        };
        this.mSlot = new MenuList(this.mEpisodelist, app.getFont(1), 0, 45, 320, 1, null, newEpProc, 6){

            @Override
            public int mFontOffset() {
                return this.font.getHeight() + 5;
            }
        };
        this.mSlot.fontShadow = true;
        this.addItem(EpTitle, false);
        this.addItem(this.mSlot, true);
        this.addItem(menu.addMenuBlood(), false);
    }

    public void setEpisode(BloodIniFile ini) {
        this.ini = ini;
        this.mEpisodelist.clear();
        Arrays.fill(this.episodeNum, -1);
        for (int i = 0; i < 6; ++i) {
            String BloodBatchOnly;
            if (!ini.set("Episode" + (i + 1)) || (BloodBatchOnly = ini.GetKeyString("BloodBathOnly")) != null && BloodBatchOnly.charAt(0) == '1') continue;
            String title = ini.GetKeyString("Title");
            if (title == null || title.isEmpty()) {
                title = "Episode" + (i + 1);
            }
            this.episodeNum[this.mEpisodelist.size()] = i;
            this.mEpisodelist.add(title.toCharArray());
        }
        this.mSlot.len = this.mEpisodelist.size();
        this.mSlot.l_nMin = 0;
        this.mSlot.l_nFocus = 0;
    }
}

