/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.XSECTOR;
import ru.m210projects.Blood.Types.XWALL;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SECTOR;

public class SECTORFX {
    public static short[] shadeList = new short[512];
    public static short[] panList = new short[512];
    public static int shadeCount = 0;
    public static int panCount = 0;
    public static short[] wallPanList = new short[512];
    public static int wallPanCount = 0;
    public static final int kPanScale = 10;
    public static final int kWaveNone = 0;
    public static final int kWaveSquare = 1;
    public static final int kWaveSaw = 2;
    public static final int kWaveRampup = 3;
    public static final int kWaveRampdown = 4;
    public static final int kWaveSine = 5;
    public static final int kWaveFlicker1 = 6;
    public static final int kWaveFlicker2 = 7;
    public static final int kWaveFlicker3 = 8;
    public static final int kWaveFlicker4 = 9;
    public static final int kWaveStrobe = 10;
    public static final int kWaveSearch = 11;
    public static final int[] flicker1 = new int[]{0, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1};
    public static final int[] flicker2 = new int[]{1, 2, 4, 2, 3, 4, 3, 2, 0, 0, 1, 2, 4, 3, 2, 0, 2, 1, 0, 1, 0, 2, 3, 4, 3, 2, 1, 1, 2, 0, 0, 1, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 2, 1, 0, 1, 0, 0, 0, 0, 1, 2, 3, 4, 3, 2, 1, 2, 3, 4, 3, 2};
    public static final int[] flicker3 = new int[]{4, 4, 4, 4, 3, 4, 4, 4, 4, 4, 4, 2, 4, 3, 4, 4, 4, 4, 2, 1, 3, 3, 3, 4, 3, 4, 4, 4, 4, 4, 2, 4, 4, 4, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 2, 1, 0, 1, 0, 1, 0, 1, 0, 2, 3, 4, 4, 4, 4, 4, 4, 4, 3, 4};
    public static final int[] flicker4 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 3, 0, 1, 0, 1, 0, 4, 4, 4, 4, 4, 2, 0, 0, 0, 0, 4, 4, 3, 2, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 2, 1, 2, 1, 2, 1, 2, 1, 4, 3, 2};
    public static final int[] strobe = new int[]{64, 64, 64, 48, 36, 27, 20, 15, 11, 9, 6, 5, 4, 3, 2, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public static void InitSectorFX() {
        int i;
        shadeCount = 0;
        panCount = 0;
        wallPanCount = 0;
        for (i = 0; i < Engine.numsectors; ++i) {
            short nXSector = Engine.sector[i].extra;
            if (nXSector <= 0) continue;
            XSECTOR pXSector = DB.xsector[nXSector];
            if (pXSector.amplitude != 0) {
                SECTORFX.shadeList[SECTORFX.shadeCount++] = nXSector;
            }
            if (pXSector.panVel == 0) continue;
            SECTORFX.panList[SECTORFX.panCount++] = nXSector;
        }
        for (i = 0; i < Engine.numwalls; ++i) {
            short nXWall = Engine.wall[i].extra;
            if (nXWall <= 0) continue;
            XWALL pXWall = DB.xwall[nXWall];
            if (pXWall.panXVel == 0 && pXWall.panYVel == 0) continue;
            SECTORFX.wallPanList[SECTORFX.wallPanCount++] = nXWall;
        }
    }

    public static void DoSectorPanning() {
        int i;
        for (i = 0; i < panCount; ++i) {
            int panY;
            int panX;
            short nTile;
            short nXSector = panList[i];
            XSECTOR pXSector = DB.xsector[nXSector];
            int nSector = pXSector.reference;
            if (nSector < 0 || nSector >= Globals.kMaxSectors) {
                Main.game.dassert("nSector >= 0 && nSector < kMaxSectors");
            }
            SECTOR pSector = Engine.sector[nSector];
            if (pSector.extra != nXSector) {
                Main.game.dassert("pSector.extra == nXSector");
            }
            if (!pXSector.panAlways && pXSector.busy == 0) continue;
            int panAngle = pXSector.panAngle + 1024;
            int panVel = (pXSector.panVel & 0xFF) << 10;
            if (!pXSector.panAlways && (pXSector.busy & 0xFFFF) != 0) {
                panVel = Pragmas.mulscale(panVel, pXSector.busy, 16);
            }
            if (pXSector.panFloor) {
                nTile = pSector.floorpicnum;
                if ((pSector.floorstat & 0x40) != 0) {
                    panAngle -= 512;
                }
                panX = (pSector.floorxpanning << 8) + pXSector.floorxpanFrac;
                panY = (pSector.floorypanning << 8) + pXSector.floorypanFrac;
                int n = (pSector.floorstat & 8) != 0 ? 1 : 0;
                pSector.floorxpanning = (byte)((panX += Pragmas.mulscale(Globals.kFrameTicks * panVel, Trig.Cos(panAngle), 30) >> (Engine.picsiz[nTile] & 0xF) - ((pSector.floorstat & 8) != 0 ? 1 : 0)) >> 8);
                pSector.floorypanning = (byte)((panY -= Pragmas.mulscale(Globals.kFrameTicks * panVel, Trig.Sin(panAngle), 30) >> Engine.picsiz[nTile] / 16 - n) >> 8);
                pXSector.floorxpanFrac = panX & 0xFF;
                pXSector.floorypanFrac = panY & 0xFF;
            }
            if (!pXSector.panCeiling) continue;
            nTile = pSector.ceilingpicnum;
            if ((pSector.ceilingstat & 0x40) != 0) {
                panAngle -= 512;
            }
            panX = (pSector.ceilingxpanning << 8) + pXSector.ceilxpanFrac;
            panY = (pSector.ceilingypanning << 8) + pXSector.ceilypanFrac;
            int n = (pSector.ceilingstat & 8) != 0 ? 1 : 0;
            pSector.ceilingxpanning = (byte)((panX += Pragmas.mulscale(Globals.kFrameTicks * panVel, Trig.Cos(panAngle), 30) >> (Engine.picsiz[nTile] & 0xF) - ((pSector.ceilingstat & 8) != 0 ? 1 : 0)) >> 8);
            pSector.ceilingypanning = (byte)((panY += Pragmas.mulscale(Globals.kFrameTicks * panVel, Trig.Sin(panAngle), 30) >> Engine.picsiz[nTile] / 16 - n) >> 8);
            pXSector.ceilxpanFrac = panX & 0xFF;
            pXSector.ceilypanFrac = panY & 0xFF;
        }
        for (i = 0; i < wallPanCount; ++i) {
            short nXWall = wallPanList[i];
            XWALL pXWall = DB.xwall[nXWall];
            int nWall = pXWall.reference;
            if (Engine.wall[nWall].extra != nXWall) {
                Main.game.dassert("wall[nWall].extra == nXWall");
            }
            if (!pXWall.panAlways && pXWall.busy == 0) continue;
            int panXVel = pXWall.panXVel << 10;
            int panYVel = pXWall.panYVel << 10;
            if (!pXWall.panAlways && (pXWall.busy & 0xFFFF) != 0) {
                panXVel = Pragmas.mulscale(panXVel, pXWall.busy, 16);
                panYVel = Pragmas.mulscale(panYVel, pXWall.busy, 16);
            }
            short nTile = Engine.wall[nWall].picnum;
            int panX = (Engine.wall[nWall].xpanning << 8) + pXWall.xpanFrac;
            int panY = (Engine.wall[nWall].ypanning << 8) + pXWall.ypanFrac;
            Engine.wall[nWall].xpanning = (byte)((panX += Globals.kFrameTicks * panXVel >> (Engine.picsiz[nTile] & 0xF)) >> 8);
            Engine.wall[nWall].ypanning = (byte)((panY += Globals.kFrameTicks * panYVel >> Engine.picsiz[nTile] / 16) >> 8);
            pXWall.xpanFrac = panX & 0xFF;
            pXWall.ypanFrac = panY & 0xFF;
        }
    }

    public static int GetWaveValue(int nWave, long time, int freq, int amplitude) {
        switch (nWave) {
            case 0: {
                return amplitude;
            }
            case 1: {
                return (int)((time * (long)freq >> 10 & 1L) * (long)amplitude);
            }
            case 2: {
                return (int)(Pragmas.klabs(128L - (time * (long)freq >> 3 & 0xFFL)) * (long)amplitude >> 7);
            }
            case 3: {
                return (int)((time * (long)freq >> 3 & 0xFFL) * (long)amplitude >> 8);
            }
            case 4: {
                return (int)((255L - (time * (long)freq >> 3 & 0xFFL)) * (long)amplitude >> 8);
            }
            case 5: {
                return amplitude + Pragmas.mulscale(amplitude, Trig.Sin((int)(time * (long)freq)), 30) >> 1;
            }
            case 6: {
                return flicker1[(int)(time * (long)freq >> 5 & 0x3FL)] * amplitude;
            }
            case 7: {
                return flicker2[(int)(time * (long)freq >> 5 & 0x3FL)] * amplitude >> 2;
            }
            case 8: {
                return flicker3[(int)(time * (long)freq >> 5 & 0x3FL)] * amplitude >> 2;
            }
            case 9: {
                return flicker4[(int)(time * (long)freq >> 5 & 0x3FL)] * amplitude >> 2;
            }
            case 10: {
                return strobe[(int)(time * (long)freq >> 5 & 0x3FL)] * amplitude >> 6;
            }
            case 11: {
                int phi = (int)((time * (long)freq & 0x7FFL) << 2);
                if (phi > 2048) {
                    return 0;
                }
                return amplitude - Pragmas.mulscale(amplitude, Trig.Cos(phi), 30) >> 1;
            }
        }
        return 0;
    }

    public static void DoSectorLighting() {
        for (int i = 0; i < shadeCount; ++i) {
            int nWall;
            int endwall;
            int startwall;
            short ceilingpal;
            short pal;
            short floorpal;
            int value;
            short nXSector = shadeList[i];
            XSECTOR pXSector = DB.xsector[nXSector];
            int nSector = pXSector.reference;
            if (Engine.sector[nSector].extra != nXSector) {
                Main.game.dassert("sector[nSector].extra == nXSector");
            }
            if (pXSector.shade != 0) {
                value = pXSector.shade;
                if (pXSector.shadeFloor) {
                    Engine.sector[nSector].floorshade = (byte)(Engine.sector[nSector].floorshade - value);
                    if (pXSector.color) {
                        floorpal = pXSector.floorpal;
                        pXSector.floorpal = pal = Engine.sector[nSector].floorpal;
                        Engine.sector[nSector].floorpal = floorpal;
                    }
                }
                if (pXSector.shadeCeiling) {
                    Engine.sector[nSector].ceilingshade = (byte)(Engine.sector[nSector].ceilingshade - value);
                    if (pXSector.color) {
                        ceilingpal = pXSector.ceilpal;
                        pXSector.ceilpal = pal = Engine.sector[nSector].ceilingpal;
                        Engine.sector[nSector].ceilingpal = ceilingpal;
                    }
                }
                if (pXSector.shadeWalls) {
                    startwall = Engine.sector[nSector].wallptr;
                    endwall = startwall + Engine.sector[nSector].wallnum - 1;
                    for (nWall = startwall; nWall <= endwall; ++nWall) {
                        Engine.wall[nWall].shade = (byte)(Engine.wall[nWall].shade - value);
                        if (!pXSector.color) continue;
                        Engine.wall[nWall].pal = Engine.sector[nSector].floorpal;
                    }
                }
                pXSector.shade = 0;
            }
            if (!pXSector.shadeAlways && pXSector.busy == 0) continue;
            short freq = pXSector.freq;
            short nWave = pXSector.wave;
            int amplitude = pXSector.amplitude;
            if (!pXSector.shadeAlways && pXSector.busy != 0) {
                amplitude = Pragmas.mulscale(amplitude, pXSector.busy, 16);
            }
            value = SECTORFX.GetWaveValue(nWave, Engine.totalclock + pXSector.phase, freq, amplitude);
            if (pXSector.shadeFloor) {
                Engine.sector[nSector].floorshade = (byte)Gameutils.ClipRange(Engine.sector[nSector].floorshade + value, -128, 127);
                if (pXSector.color && value != 0) {
                    floorpal = pXSector.floorpal;
                    pXSector.floorpal = pal = Engine.sector[nSector].floorpal;
                    Engine.sector[nSector].floorpal = floorpal;
                }
            }
            if (pXSector.shadeCeiling) {
                Engine.sector[nSector].ceilingshade = (byte)Gameutils.ClipRange(Engine.sector[nSector].ceilingshade + value, -128, 127);
                if (pXSector.color && value != 0) {
                    ceilingpal = pXSector.ceilpal;
                    pXSector.ceilpal = pal = Engine.sector[nSector].ceilingpal;
                    Engine.sector[nSector].ceilingpal = ceilingpal;
                }
            }
            if (pXSector.shadeWalls) {
                startwall = Engine.sector[nSector].wallptr;
                endwall = startwall + Engine.sector[nSector].wallnum - 1;
                for (nWall = startwall; nWall <= endwall; ++nWall) {
                    Engine.wall[nWall].shade = (byte)Gameutils.ClipRange(Engine.wall[nWall].shade + value, -128, 127);
                    if (!pXSector.color || value == 0) continue;
                    Engine.wall[nWall].pal = Engine.sector[nSector].floorpal;
                }
            }
            pXSector.shade = value;
        }
    }
}

