/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import com.badlogic.gdx.utils.BufferUtils;
import java.nio.ByteBuffer;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.AMBIENT;
import ru.m210projects.Blood.Types.SAMPLE2D;
import ru.m210projects.Blood.Types.SFX;
import ru.m210projects.Blood.Types.SOUNDEFFECT;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Blood.View;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Audio.BuildAudio;
import ru.m210projects.Build.Audio.MusicSource;
import ru.m210projects.Build.Audio.Sound;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Group;
import ru.m210projects.Build.FileHandle.GroupResource;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.LittleEndian;
import ru.m210projects.Build.Types.SPRITE;

public class SOUND {
    public static final int BLUDSPLT = 385;
    public static final String[] track = new String[]{"blood00.ogg", "blood01.ogg", "blood02.ogg", "blood03.ogg", "blood04.ogg", "blood05.ogg", "blood06.ogg", "blood07.ogg", "blood08.ogg", "blood09.ogg"};
    public static final int MAXUSERTRACKS = 64;
    public static String[] usertrack = new String[64];
    public static SFX[] pSFXs = new SFX[65536];
    public static final int kSoundVel = Gameutils.M2X(280.0);
    public static final float kIntraAuralTime = 6.0E-4f;
    public static final int kIntraAuralDist = (int)(3.0E-4f * (float)kSoundVel);
    public static final int kBackFilter = 16384;
    public static int nSndEffect;
    public static SOUNDEFFECT[] soundEffect;
    public static final int kVolScale = 80;
    public static final int kMaxAmbients = 16;
    public static final int kMaxChannels = 32;
    public static final int kMaxSources = 256;
    public static final int[] sndRate;
    public static SAMPLE2D[] Channel;
    public static int earX0;
    public static int earX;
    public static int earY0;
    public static int earY;
    public static int earZ0;
    public static int earZ;
    public static int earVX;
    public static int earVY;
    public static int earVZ;
    public static int earVolume;
    public static int earVelocity;
    public static AMBIENT[] ambient;
    public static int numambients;
    public static int currTrack;
    public static String currEpisode;
    public static String currSong;
    public static MusicSource currMusic;

    public static void sndHandlePause(boolean gPaused) {
        if (gPaused) {
            if (currMusic != null) {
                currMusic.pause();
            }
            BuildGdx.audio.getSound().stopAllSounds();
        } else if (!Main.cfg.muteMusic && currMusic != null) {
            currMusic.resume();
        }
    }

    public static boolean sndLoadSound(int soundId) {
        if (soundId < 0) {
            return false;
        }
        if (pSFXs[soundId] == null) {
            Resource dat = BuildGdx.cache.open(soundId, "SFX");
            if (dat != null) {
                SOUND.pSFXs[soundId] = new SFX(dat);
                dat.close();
            } else {
                return false;
            }
        }
        if (SOUND.pSFXs[soundId].hResource == null) {
            String rawName = SOUND.pSFXs[soundId].rawName + "." + "RAW";
            Resource fp = BuildGdx.cache.open(rawName, 0);
            if (fp != null) {
                int size = fp.size();
                SOUND.pSFXs[soundId].hResource = ByteBuffer.allocateDirect(size);
                SOUND.pSFXs[soundId].hResource.put(fp.getBytes());
                SOUND.pSFXs[soundId].hResource.rewind();
                SOUND.pSFXs[soundId].size = size;
                fp.close();
            } else {
                return false;
            }
        }
        return true;
    }

    public static void sfxStart3DSound(SPRITE pSprite, int soundId, int nChannel, int flags) {
        if (Main.cfg.noSound || !BuildGdx.audio.IsInited(BuildAudio.Driver.Sound)) {
            return;
        }
        if (pSprite != null && soundId >= 0) {
            if (!SOUND.sndLoadSound(soundId)) {
                return;
            }
            SFX pEffect = pSFXs[soundId];
            if (pEffect.size <= 0) {
                return;
            }
            int nPitch = Pragmas.mulscale(SOUND.sndGetSampleRate(pEffect.format), pEffect.pitch, 16);
            SOUNDEFFECT pSource = null;
            if (nChannel < 0) {
                if (nSndEffect >= 256) {
                    return;
                }
                pSource = soundEffect[nSndEffect++];
                pSource.pSprite = null;
            } else {
                int i;
                for (i = 0; i < nSndEffect; ++i) {
                    pSource = soundEffect[i];
                    if (nChannel != pSource.channel || pSprite != pSource.pSprite && (flags & 1) == 0) continue;
                    if (pSource.hVoice != null && pSource.hVoice.data == pSource.hResource && ((flags & 4) != 0 && nChannel == pSource.channel || (flags & 2) != 0 && soundId == pSource.soundId)) {
                        return;
                    }
                    if (pSource.hVoice != null) {
                        pSource.hVoice.dispose();
                    }
                    if (pSource.hResource == null) break;
                    pSource.hResource = null;
                    break;
                }
                if (i == nSndEffect) {
                    if (nSndEffect >= 256) {
                        return;
                    }
                    pSource = soundEffect[nSndEffect++];
                }
                pSource.pSprite = pSprite;
                pSource.channel = nChannel;
            }
            pSource.x = pSprite.x;
            pSource.y = pSprite.y;
            pSource.z = pSprite.z;
            pSource.nSector = pSprite.sectnum;
            pSource.oldX = pSource.x;
            pSource.oldY = pSource.y;
            pSource.oldZ = pSource.z;
            pSource.soundId = soundId;
            pSource.hResource = pEffect.hResource;
            pSource.relVol = pEffect.relVol;
            pSource.nPitch = nPitch;
            SOUND.Calc3DValues(pSource);
            int nPriority = 1;
            if (nPriority < earVolume) {
                nPriority = earVolume;
            }
            int loopStart = pEffect.loopStart;
            if (nChannel < 0) {
                loopStart = -1;
            }
            ByteBuffer pRaw = pEffect.hResource;
            pRaw.rewind();
            boolean global = pSprite == Globals.gPlayer[View.gViewIndex].pSprite;
            pSource.hVoice = BuildGdx.audio.newSound(pRaw, global ? pSource.nPitch : earVelocity, 8, nPriority);
            if (pSource.hVoice != null) {
                if (loopStart >= 0) {
                    pSource.hVoice.setLooping(true, loopStart, Gameutils.ClipLow(pEffect.size - 1, 0));
                }
                if (global) {
                    pSource.hVoice.setGlobal(1);
                    pSource.pSprite = Globals.gPlayer[View.gViewIndex].pSprite;
                } else {
                    SOUND.setPosition(pSource);
                }
                pSource.hVoice.play((float)earVolume / 255.0f);
            }
        }
    }

    public static void sfxStart3DSoundCP(SPRITE pSprite, int soundId, int nChannel, int flags, long pitch, int volume) {
        if (Main.cfg.noSound || !BuildGdx.audio.IsInited(BuildAudio.Driver.Sound)) {
            return;
        }
        if (pSprite != null && soundId >= 0) {
            if (!SOUND.sndLoadSound(soundId)) {
                return;
            }
            SFX pEffect = pSFXs[soundId];
            pitch = pitch <= 0L ? (long)pEffect.pitch : (pitch -= (long)Gameutils.BiRandom(pEffect.pitchrange));
            if (pEffect.size <= 0) {
                return;
            }
            int nPitch = Pragmas.mulscale(SOUND.sndGetSampleRate(pEffect.format), pitch, 16);
            SOUNDEFFECT pSource = null;
            if (nChannel < 0) {
                if (nSndEffect >= 256) {
                    return;
                }
                pSource = soundEffect[nSndEffect++];
                pSource.pSprite = null;
            } else {
                int i;
                for (i = 0; i < nSndEffect; ++i) {
                    pSource = soundEffect[i];
                    if (nChannel != pSource.channel || pSprite != pSource.pSprite && (flags & 1) == 0) continue;
                    if (pSource.hVoice != null && pSource.hVoice.data == pSource.hResource && ((flags & 4) != 0 && nChannel == pSource.channel || (flags & 2) != 0 && soundId == pSource.soundId)) {
                        return;
                    }
                    if (pSource.hVoice != null) {
                        pSource.hVoice.dispose();
                    }
                    if (pSource.hResource == null) break;
                    pSource.hResource = null;
                    break;
                }
                if (i == nSndEffect) {
                    if (nSndEffect >= 256) {
                        return;
                    }
                    pSource = soundEffect[nSndEffect++];
                }
                pSource.pSprite = pSprite;
                pSource.channel = nChannel;
            }
            pSource.x = pSprite.x;
            pSource.y = pSprite.y;
            pSource.z = pSprite.z;
            pSource.nSector = pSprite.sectnum;
            pSource.oldX = pSource.x;
            pSource.oldY = pSource.y;
            pSource.oldZ = pSource.z;
            pSource.soundId = soundId;
            pSource.hResource = pEffect.hResource;
            pSource.relVol = volume == 0 ? pEffect.relVol : (volume == -1 ? 0 : Math.min(volume, 255));
            pSource.nPitch = nPitch;
            SOUND.Calc3DValues(pSource);
            int nPriority = 1;
            if (nPriority < earVolume) {
                nPriority = earVolume;
            }
            int loopStart = pEffect.loopStart;
            if (nChannel < 0) {
                loopStart = -1;
            }
            ByteBuffer pRaw = pEffect.hResource;
            pRaw.rewind();
            boolean global = pSprite == Globals.gPlayer[View.gViewIndex].pSprite;
            pSource.hVoice = BuildGdx.audio.newSound(pRaw, global ? pSource.nPitch : earVelocity, 8, nPriority);
            if (pSource.hVoice != null) {
                if (loopStart >= 0) {
                    pSource.hVoice.setLooping(true, loopStart, Gameutils.ClipLow(pEffect.size - 1, 0));
                }
                if (global) {
                    pSource.hVoice.setGlobal(1);
                    pSource.pSprite = Globals.gPlayer[View.gViewIndex].pSprite;
                } else {
                    SOUND.setPosition(pSource);
                }
                pSource.hVoice.play((float)earVolume / 255.0f);
            }
        }
    }

    public static void sfxCreate3DSound(int x, int y, int z, int soundId, int nSector) {
        if (Main.cfg.noSound || !BuildGdx.audio.IsInited(BuildAudio.Driver.Sound)) {
            return;
        }
        if (nSector < 0 || nSector > Engine.numsectors) {
            return;
        }
        if (soundId < 0) {
            Main.game.dassert("Invalid sound ID: " + soundId);
        }
        if (!SOUND.sndLoadSound(soundId)) {
            return;
        }
        SFX pEffect = pSFXs[soundId];
        if (pEffect.size <= 0) {
            return;
        }
        int nPitch = Pragmas.mulscale(SOUND.sndGetSampleRate(pEffect.format), pEffect.pitch, 16);
        if (nSndEffect < 256) {
            SOUNDEFFECT pSoundEffect = soundEffect[nSndEffect++];
            pSoundEffect.pSprite = null;
            pSoundEffect.x = x;
            pSoundEffect.y = y;
            pSoundEffect.z = z;
            pSoundEffect.nSector = nSector;
            Gameutils.FindSector(x, y, z, (short)pSoundEffect.nSector);
            pSoundEffect.nSector = Gameutils.foundSector;
            pSoundEffect.oldX = pSoundEffect.x;
            pSoundEffect.oldY = pSoundEffect.y;
            pSoundEffect.oldZ = pSoundEffect.z;
            pSoundEffect.soundId = soundId;
            pSoundEffect.hResource = pEffect.hResource;
            pSoundEffect.relVol = pEffect.relVol;
            pSoundEffect.nPitch = nPitch;
            pSoundEffect.format = pEffect.format;
            ByteBuffer pRaw = pEffect.hResource;
            pRaw.rewind();
            SOUND.Calc3DValues(pSoundEffect);
            int nPriority = 1;
            if (nPriority < earVolume) {
                nPriority = earVolume;
            }
            pSoundEffect.hVoice = BuildGdx.audio.newSound(pRaw, earVelocity, 8, nPriority);
            if (pSoundEffect.hVoice != null) {
                SOUND.setPosition(pSoundEffect);
                pSoundEffect.hVoice.play((float)earVolume / 255.0f);
            }
        }
    }

    public static void setPosition(SOUNDEFFECT pSoundEffect) {
        pSoundEffect.hVoice.setPosition(pSoundEffect.x, pSoundEffect.z >> 4, pSoundEffect.y);
    }

    public static void Calc3DValues(SOUNDEFFECT pSource) {
        if (Main.cfg.noSound || !BuildGdx.audio.IsInited(BuildAudio.Driver.Sound)) {
            return;
        }
        int dx = pSource.x - Globals.gPlayer[View.gViewIndex].pSprite.x;
        int dy = pSource.y - Globals.gPlayer[View.gViewIndex].pSprite.y;
        int dz = pSource.z - Globals.gPlayer[View.gViewIndex].pSprite.z;
        short nAngle = Main.engine.getangle(dx, dy);
        int dist = Gameutils.Dist3d(dx, dy, dz);
        dist = Gameutils.ClipLow((dist >> 3) + (dist >> 2), 64);
        int monoVol = Pragmas.muldiv(pSource.relVol, 80L, dist);
        dx = Trig.Cos(nAngle);
        dy = Trig.Sin(nAngle);
        earVolume = SOUND.Vol3d(nAngle - Globals.gPlayer[View.gViewIndex].pSprite.ang, monoVol);
        earVelocity = pSource.nPitch;
        int div = Pragmas.dmulscaler(dx, pSource.x - pSource.oldX, dy, pSource.y - pSource.oldY, 30) + 5853;
        int kVel = Pragmas.klabs(Pragmas.dmulscaler(dx, earVX, dy, earVY, 30) + 5853);
        if (div != 0) {
            earVelocity = Pragmas.muldiv(kVel, pSource.nPitch, div);
        }
    }

    public static int Vol3d(int nAngle, int vol) {
        return vol - Pragmas.mulscale(vol, 8192 - Pragmas.mulscale(8192L, Trig.Cos(nAngle), 30), 16);
    }

    public static void sfxResetListener() {
        earX0 = earX = Globals.gPlayer[View.gViewIndex].pSprite.x;
        earY0 = earY = Globals.gPlayer[View.gViewIndex].pSprite.y;
        earZ0 = earZ = Globals.gPlayer[View.gViewIndex].pSprite.z;
    }

    public static void sfxUpdate3DSounds() {
        if (Main.cfg.noSound || !BuildGdx.audio.IsInited(BuildAudio.Driver.Sound) || nSndEffect >= 256) {
            return;
        }
        earX0 = earX;
        earY0 = earY;
        earZ0 = earZ;
        earX = Globals.gPlayer[View.gViewIndex].pSprite.x;
        earY = Globals.gPlayer[View.gViewIndex].pSprite.y;
        earZ = Globals.gPlayer[View.gViewIndex].pSprite.z;
        earVX = earX - earX0;
        earVY = earY - earY0;
        earVZ = earZ - earZ0;
        BuildGdx.audio.getSound().setListener(earX0, earZ0 >> 4, earY0, Globals.gPlayer[View.gViewIndex].pSprite.ang);
        for (int i = nSndEffect - 1; i >= 0; --i) {
            SOUNDEFFECT pSoundEffect = soundEffect[i];
            if (pSoundEffect.hVoice == null) {
                SOUND.SoundCallback(i);
            }
            if (pSoundEffect.hVoice != null && !pSoundEffect.hVoice.isActive()) {
                pSoundEffect.hVoice.dispose();
                SOUND.SoundCallback(i);
                continue;
            }
            if (pSoundEffect.hResource == null) continue;
            SPRITE pSprite = pSoundEffect.pSprite;
            if (pSprite != null) {
                pSoundEffect.oldX = pSoundEffect.x;
                pSoundEffect.oldY = pSoundEffect.y;
                pSoundEffect.oldZ = pSoundEffect.z;
                pSoundEffect.x = pSprite.x;
                pSoundEffect.y = pSprite.y;
                pSoundEffect.z = pSprite.z;
                pSoundEffect.nSector = pSprite.sectnum;
            }
            SOUND.Calc3DValues(pSoundEffect);
            if (pSoundEffect.hVoice == null || pSoundEffect.hVoice.data != pSoundEffect.hResource || pSoundEffect.pSprite == Globals.gPlayer[View.gViewIndex].pSprite) continue;
            pSoundEffect.hVoice.setVolume((float)earVolume / 255.0f);
            float pitch = 0.0f;
            if (pSoundEffect.nPitch > 0) {
                pitch = (float)earVelocity / (float)pSoundEffect.nPitch;
            }
            pSoundEffect.hVoice.setPitch(pitch);
            SOUND.setPosition(pSoundEffect);
        }
    }

    public static void SoundCallback(int num) {
        SOUNDEFFECT pSoundEffect = soundEffect[num];
        pSoundEffect.clear();
        int tmp = nSndEffect - 1;
        SOUND.soundEffect[num] = soundEffect[tmp];
        SOUND.soundEffect[tmp] = pSoundEffect;
        nSndEffect = tmp;
    }

    public static void sfxKill3DSound(SPRITE pSprite, int nChannel, int nSoundId) {
        if (!BuildGdx.audio.IsInited(BuildAudio.Driver.Sound)) {
            return;
        }
        int i = nSndEffect;
        while (--i >= 0) {
            SOUNDEFFECT pSoundEffect = soundEffect[i];
            if (pSprite != pSoundEffect.pSprite || nChannel >= 0 && nChannel != pSoundEffect.channel || nSoundId >= 0 && nSoundId != pSoundEffect.soundId) continue;
            if (pSoundEffect.hVoice != null) {
                pSoundEffect.hVoice.dispose();
            }
            SOUND.SoundCallback(i);
        }
    }

    public static void sfxKillAll3DSounds() {
        int i = nSndEffect;
        while (--i >= 0) {
            SOUNDEFFECT pSoundEffect = soundEffect[i];
            if (pSoundEffect.hVoice != null) {
                pSoundEffect.hVoice.dispose();
            }
            SOUND.SoundCallback(i);
        }
    }

    public static void varsInit() {
        int i;
        nSndEffect = 0;
        Channel = new SAMPLE2D[32];
        for (i = 0; i < 32; ++i) {
            SOUND.Channel[i] = new SAMPLE2D();
        }
        soundEffect = new SOUNDEFFECT[256];
        for (i = 0; i < 256; ++i) {
            SOUND.soundEffect[i] = new SOUNDEFFECT();
        }
        ambient = new AMBIENT[16];
        for (i = 0; i < 16; ++i) {
            SOUND.ambient[i] = new AMBIENT();
        }
        numambients = 0;
    }

    public static void sndInit() {
        if (Main.cfg.maxvoices < 4) {
            Main.cfg.maxvoices = 4;
        }
        SOUND.varsInit();
        if (BuildGdx.audio.getSound().init(Sound.SystemType.Stereo, Main.cfg.maxvoices, Main.cfg.resampler_num)) {
            BuildGdx.audio.setVolume(BuildAudio.Driver.Sound, Main.cfg.soundVolume);
        } else {
            Console.Println(BuildGdx.audio.getName(BuildAudio.Driver.Sound) + " initialization failed", Console.OSDTEXT_RED);
        }
        if (!BuildGdx.audio.getMusic().init()) {
            Console.Println(BuildGdx.audio.getName(BuildAudio.Driver.Music) + " initialization failed", Console.OSDTEXT_RED);
        }
        if (!Main.cfg.muteMusic) {
            BuildGdx.audio.setVolume(BuildAudio.Driver.Music, Main.cfg.musicVolume);
        } else {
            BuildGdx.audio.setVolume(BuildAudio.Driver.Music, 0.0f);
        }
    }

    public static int sndGetSampleRate(int SND_FMT) {
        if (SND_FMT >= 13) {
            return 11025;
        }
        return sndRate[SND_FMT];
    }

    public static SAMPLE2D FindChannel() {
        int i;
        for (i = 31; i >= 0 && SOUND.Channel[i].hResource != null; --i) {
        }
        if (i < 0) {
            return null;
        }
        return Channel[i];
    }

    public static void sndStopSound(SAMPLE2D pChannel) {
        if (!BuildGdx.audio.IsInited(BuildAudio.Driver.Sound)) {
            return;
        }
        if ((pChannel.loop & 1) != 0) {
            pChannel.loop &= 0xFFFFFFFE;
        }
        pChannel.hVoice.dispose();
        pChannel.hVoice = null;
    }

    public static void sndStopAllSounds() {
        SOUND.sndStopAllSamples();
        SOUND.sndStopMusic();
        SOUND.sfxKillAll3DSounds();
        SOUND.ambStopAll();
    }

    public static void sndStopAllSamples() {
        for (int i = 0; i < 32; ++i) {
            SAMPLE2D pChannel = Channel[i];
            if (pChannel.hVoice != null) {
                SOUND.sndStopSound(pChannel);
            }
            if (pChannel.hResource == null) continue;
            pChannel.hResource = null;
        }
    }

    public static void sndStartSample(int soundId, int nVol, int nChannel, boolean loop) {
        int sampleSize;
        if (Main.cfg.noSound || !BuildGdx.audio.IsInited(BuildAudio.Driver.Sound)) {
            return;
        }
        if (nChannel < -1 || nChannel >= 32) {
            Main.game.dassert("nChannel >= -1 && nChannel < kMaxChannels");
        }
        if (!SOUND.sndLoadSound(soundId)) {
            Console.Println("Could not load sample" + (pSFXs[soundId] != null ? SOUND.pSFXs[soundId].rawName : Integer.valueOf(soundId)), Console.OSDTEXT_RED);
            return;
        }
        SFX pEffect = pSFXs[soundId];
        if (pEffect.size <= 0) {
            return;
        }
        SAMPLE2D pChannel = nChannel == -1 ? SOUND.FindChannel() : Channel[nChannel];
        if (pChannel == null) {
            return;
        }
        if (pChannel.hVoice != null) {
            SOUND.sndStopSound(pChannel);
        }
        pChannel.hResource = pEffect.hResource;
        if (nVol < 0) {
            nVol = pEffect.relVol;
        }
        if ((sampleSize = pEffect.size) > 0) {
            ByteBuffer pRaw = pChannel.hResource;
            pRaw.rewind();
            if (nChannel < 0) {
                loop = false;
            }
            pChannel.hVoice = BuildGdx.audio.newSound(pRaw, SOUND.sndGetSampleRate(pEffect.format), 8, 80 * nVol);
            if (pChannel.hVoice != null) {
                pChannel.loop &= 0xFFFFFFFE;
                pChannel.hVoice.setGlobal(1);
                if (loop) {
                    int loopStart = pEffect.loopStart;
                    int loopEnd = Gameutils.ClipLow(sampleSize - 1, 0);
                    pChannel.hVoice.setLooping(true, loopStart, loopEnd);
                    pChannel.loop |= 1;
                }
                pChannel.hVoice.play((float)(80 * nVol) / 255.0f);
            }
        }
    }

    public static void sndPreloadSounds() {
        Group sounds = BuildGdx.cache.getGroup("sounds.rff");
        if (sounds != null) {
            for (GroupResource res : sounds.getList()) {
                if (!res.getExtension().equals("sfx")) continue;
                SOUND.sndLoadSound(res.getIdentification());
            }
        }
    }

    public static boolean midRestart() {
        SOUND.sndStopMusic();
        if (!BuildGdx.audio.getMusic().init()) {
            Console.Println(BuildGdx.audio.getName(BuildAudio.Driver.Music) + " initialization failed", Console.OSDTEXT_RED);
            return false;
        }
        return true;
    }

    public static boolean sndRestart(int nvoices, int resampler) {
        SOUND.ambStopAll();
        BuildGdx.audio.getSound().stopAllSounds();
        BuildGdx.audio.getSound().uninit();
        Main.cfg.maxvoices = nvoices;
        Console.Println("Sound restarting...");
        if (!BuildGdx.audio.getSound().init(Sound.SystemType.Stereo, nvoices, resampler)) {
            Console.Println(BuildGdx.audio.getName(BuildAudio.Driver.Sound) + " initialization failed", Console.OSDTEXT_RED);
            return false;
        }
        BuildGdx.audio.setVolume(BuildAudio.Driver.Sound, Main.cfg.soundVolume);
        if (Main.game.isCurrentScreen(Main.gGameScreen) || Main.game.isCurrentScreen(Main.gDemoScreen)) {
            SOUND.ambPrepare();
        }
        return true;
    }

    public static void sndProcess() {
        if (Main.cfg.noSound || !BuildGdx.audio.IsInited(BuildAudio.Driver.Sound)) {
            return;
        }
        for (int i = 0; i < Channel.length; ++i) {
            if (SOUND.Channel[i].hVoice != null && SOUND.Channel[i].hVoice.isPlaying() || SOUND.Channel[i].hResource == null) continue;
            SOUND.Channel[i].hResource = null;
        }
    }

    public static void ambProcess() {
        if (Main.cfg.noSound || !BuildGdx.audio.IsInited(BuildAudio.Driver.Sound) || !Main.game.isCurrentScreen(Main.gGameScreen) && !Main.game.isCurrentScreen(Main.gDemoScreen)) {
            return;
        }
        short i = Engine.headspritestat[12];
        while (i >= 0) {
            SPRITE pSprite = Engine.sprite[i];
            short nXSprite = pSprite.extra;
            if (nXSprite > 0 && nXSprite < 2048 && DB.xsprite[nXSprite].state != 0 && pSprite.owner != -1) {
                XSPRITE pXSprite = DB.xsprite[nXSprite];
                int dx = pSprite.x - Globals.gPlayer[View.gViewIndex].pSprite.x >> 4;
                int dy = pSprite.y - Globals.gPlayer[View.gViewIndex].pSprite.y >> 4;
                int dz = pSprite.z - Globals.gPlayer[View.gViewIndex].pSprite.z >> 8;
                int dist = Main.engine.ksqrt(dx * dx + dy * dy + dz * dz);
                int volume = Pragmas.mulscale(pXSprite.busy, pXSprite.data4, 16);
                int radius = Gameutils.ClipRange(volume + -volume * (dist - pXSprite.data1) / (pXSprite.data2 - pXSprite.data1), 0, volume);
                SOUND.ambient[pSprite.owner].volume += radius;
            }
            i = Engine.nextspritestat[i];
        }
        for (int nAmbient = 0; nAmbient < numambients; ++nAmbient) {
            AMBIENT pAmbient = ambient[nAmbient];
            int volume = pAmbient.volume;
            if (pAmbient.hVoice == null || !pAmbient.hVoice.isPlaying()) {
                if (volume > 0) {
                    pAmbient.hVoice = BuildGdx.audio.newSound(pAmbient.pRaw, SOUND.sndGetSampleRate(pAmbient.format), 8, volume);
                    if (pAmbient.hVoice != null) {
                        pAmbient.hVoice.setGlobal(1);
                        pAmbient.hVoice.setLooping(true, 0, pAmbient.nSize);
                        pAmbient.hVoice.play((float)volume / 255.0f);
                    }
                }
            } else if (pAmbient.hVoice.data == pAmbient.pRaw) {
                pAmbient.hVoice.setGlobal(1);
                pAmbient.hVoice.setVolume((float)volume / 255.0f);
                pAmbient.hVoice.setPriority(volume);
            } else {
                pAmbient.hVoice = null;
            }
            pAmbient.volume = 0;
        }
    }

    public static void ambStopAll() {
        for (int nAmbient = 0; nAmbient < numambients; ++nAmbient) {
            AMBIENT pAmbient = ambient[nAmbient];
            if (pAmbient.hVoice != null) {
                pAmbient.hVoice.dispose();
            }
            pAmbient.clear();
        }
        numambients = 0;
    }

    public static void ambPrepare() {
        SOUND.ambStopAll();
        if (Main.cfg.noSound || !BuildGdx.audio.IsInited(BuildAudio.Driver.Sound)) {
            return;
        }
        short i = Engine.headspritestat[12];
        while (i >= 0) {
            SPRITE pSprite = Engine.sprite[i];
            short nXSprite = pSprite.extra;
            if (nXSprite > 0 && nXSprite < 2048) {
                XSPRITE pXSprite = DB.xsprite[nXSprite];
                if (pXSprite.data2 > pXSprite.data1) {
                    int nAmbient;
                    for (nAmbient = 0; nAmbient < numambients && pXSprite.data3 != SOUND.ambient[nAmbient].nSoundId; ++nAmbient) {
                    }
                    if (nAmbient != numambients) {
                        pSprite.owner = (short)nAmbient;
                    } else if (numambients < 16) {
                        short soundId = pXSprite.data3;
                        if (!SOUND.sndLoadSound(soundId)) {
                            Console.Println("Missing sound #" + soundId + " used in ambient sound generator " + nAmbient, Console.OSDTEXT_RED);
                        } else {
                            int nSize;
                            SFX pEffect = pSFXs[soundId];
                            if (pEffect.size > 0 && (nSize = pEffect.size) > 0) {
                                pEffect.hResource.rewind();
                                AMBIENT pAmbient = ambient[nAmbient];
                                pAmbient.nSize = nSize;
                                pAmbient.nSoundId = soundId;
                                pAmbient.nSize = nSize;
                                pAmbient.pRaw = pEffect.hResource;
                                pAmbient.format = pEffect.format;
                                pSprite.owner = (short)nAmbient;
                                ++numambients;
                            }
                        }
                    }
                }
            }
            i = Engine.nextspritestat[i];
        }
    }

    public static void sndPlayMenu() {
        String himus;
        SOUND.sndStopMusic();
        if (Main.game.currentDef != null && (himus = Main.game.currentDef.audInfo.getDigitalInfo("mainmenu")) != null) {
            MusicSource hisource;
            byte[] data = BuildGdx.cache.getBytes(himus, 0);
            if (data == null) {
                return;
            }
            int sign = LittleEndian.getInt(data);
            if (sign == 1684558925 && (hisource = BuildGdx.audio.newMusic(BuildAudio.MusicType.Midi, data)) != null) {
                currMusic = hisource;
                currMusic.play(true);
            } else if (Main.cfg.musicType != 0 && (hisource = BuildGdx.audio.newMusic(BuildAudio.MusicType.Digital, data)) != null) {
                currMusic = hisource;
                currMusic.play(true);
            }
        }
    }

    public static boolean sndPlayTrack(int nTrack) {
        if (Main.cfg.musicType != 2) {
            return false;
        }
        if (currMusic != null && currMusic.isPlaying() && currTrack == Globals.pGameInfo.nTrackNumber && (Main.mUserFlag == Main.UserFlag.UserMap || Main.mUserFlag != Main.UserFlag.UserMap && LEVELS.currentEpisode.filename.equals(currEpisode))) {
            return true;
        }
        SOUND.sndStopMusic();
        if (nTrack > 0 && nTrack <= 64 && usertrack[nTrack - 1] != null && (currMusic = BuildGdx.audio.newMusic(BuildAudio.MusicType.Digital, usertrack[nTrack - 1])) != null) {
            currTrack = nTrack;
            currEpisode = LEVELS.currentEpisode.filename;
            currMusic.play(true);
            return true;
        }
        if (nTrack >= 0 && nTrack < track.length && (currMusic = BuildGdx.audio.newMusic(BuildAudio.MusicType.Digital, track[nTrack])) != null) {
            currTrack = nTrack;
            if (Main.mUserFlag != Main.UserFlag.UserMap) {
                currEpisode = LEVELS.currentEpisode.filename;
            }
            currMusic.play(true);
            return true;
        }
        return false;
    }

    public static void sndPlaySong(String name) {
        if (name == null || name.length() == 0) {
            SOUND.sndStopMusic();
            return;
        }
        if (currMusic != null && currMusic.isPlaying() && currSong != null && currSong.equals(Globals.pGameInfo.zLevelSong)) {
            return;
        }
        SOUND.sndStopMusic();
        byte[] pRaw = BuildGdx.cache.getBytes(name + "." + "MID", 0);
        if (pRaw == null || pRaw.length <= 0) {
            return;
        }
        currSong = name;
        currMusic = BuildGdx.audio.newMusic(BuildAudio.MusicType.Midi, pRaw);
        if (currMusic != null) {
            currMusic.play(true);
        }
    }

    public static void sndPlayMusic() {
        String himus;
        if (!Main.cfg.muteMusic) {
            BuildGdx.audio.setVolume(BuildAudio.Driver.Music, Main.cfg.musicVolume);
        } else {
            BuildGdx.audio.setVolume(BuildAudio.Driver.Music, 0.0f);
        }
        if (Main.cfg.musicType == 1 && Main.game.currentDef != null && (himus = Main.game.currentDef.audInfo.getDigitalInfo(Globals.pGameInfo.zLevelSong)) != null) {
            if (currMusic != null && currMusic.isPlaying() && currSong.equals(himus)) {
                return;
            }
            SOUND.sndStopMusic();
            currMusic = BuildGdx.audio.newMusic(BuildAudio.MusicType.Digital, himus);
            if (currMusic != null) {
                currSong = himus;
                currMusic.play(true);
                return;
            }
        }
        if (!SOUND.sndPlayTrack(Globals.pGameInfo.nTrackNumber)) {
            SOUND.sndPlaySong(Globals.pGameInfo.zLevelSong);
        }
    }

    public static void sndStopMusic() {
        if (currMusic != null) {
            currMusic.stop();
        }
        currSong = null;
        currTrack = -1;
        currEpisode = null;
        currMusic = null;
    }

    private static ByteBuffer loadSample(String sampleName) {
        ByteBuffer buf = null;
        Resource res = BuildGdx.cache.open(sampleName, 0);
        if (res != null) {
            buf = ByteBuffer.allocateDirect(res.size());
            buf.put(res.getBytes());
            buf.rewind();
        }
        return buf;
    }

    public static void sndStartSample(String sampleName, int nVol, int nChannel) {
        ByteBuffer buf;
        SAMPLE2D pChannel;
        if (Main.cfg.noSound || !BuildGdx.audio.IsInited(BuildAudio.Driver.Sound)) {
            return;
        }
        if (sampleName.length() == 0) {
            return;
        }
        if (nChannel < -1 || nChannel >= 32) {
            Main.game.dassert("nChannel >= -1 && nChannel < kMaxChannels");
        }
        if ((pChannel = nChannel == -1 ? SOUND.FindChannel() : Channel[nChannel]) == null) {
            return;
        }
        if (pChannel.hVoice != null) {
            SOUND.sndStopSound(pChannel);
        }
        if (!sampleName.contains(".")) {
            sampleName = sampleName + ".raw";
        }
        if ((buf = SOUND.loadSample(sampleName)) == null || buf.capacity() <= 0) {
            System.err.println("Could not load sample " + sampleName);
            return;
        }
        pChannel.hResource = buf;
        pChannel.hVoice = BuildGdx.audio.newSound(buf, SOUND.sndGetSampleRate(1), 8, nVol);
        if (pChannel.hVoice != null) {
            pChannel.hVoice.setGlobal(1);
            pChannel.loop &= 0xFFFFFFFE;
            pChannel.hVoice.play((float)nVol / 255.0f);
        }
    }

    public static void sndStartWAV(String sampleName, int nVol, int nChannel) {
        SAMPLE2D pChannel;
        if (Main.cfg.noSound || !BuildGdx.audio.IsInited(BuildAudio.Driver.Sound)) {
            return;
        }
        if (sampleName.length() == 0) {
            return;
        }
        if (nChannel < -1 || nChannel >= 32) {
            Main.game.dassert("nChannel >= -1 && nChannel < kMaxChannels");
        }
        if ((pChannel = nChannel == -1 ? SOUND.FindChannel() : Channel[nChannel]) == null) {
            return;
        }
        if (pChannel.hVoice != null) {
            SOUND.sndStopSound(pChannel);
        }
        if (!BuildGdx.cache.contains(sampleName, 0)) {
            Console.Println("Could not load wav file: " + sampleName, Console.OSDTEXT_RED);
            return;
        }
        byte[] buf = BuildGdx.cache.getBytes(sampleName, 0);
        ByteBuffer pRaw = BufferUtils.newByteBuffer(buf.length);
        pRaw.put(buf);
        pRaw.flip();
        pChannel.hVoice = BuildGdx.audio.newSound(pRaw, SOUND.sndGetSampleRate(8), 8, nVol);
        if (pChannel.hVoice != null) {
            pChannel.hVoice.setGlobal(1);
            pChannel.loop &= 0xFFFFFFFE;
            pChannel.hVoice.play((float)nVol / 255.0f);
        }
    }

    static {
        sndRate = new int[]{11025, 11025, 11025, 11025, 11025, 22050, 22050, 22050, 22050, 44100, 44100, 44100, 44100};
        currTrack = -1;
        currEpisode = null;
        currSong = null;
        currMusic = null;
    }
}

