/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import java.util.Arrays;
import ru.m210projects.Blood.AI.AISTATEFUNC;
import ru.m210projects.Blood.AI.AIUNICULT;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.EVENT;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Gib;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.SECTORFX;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.BUSY;
import ru.m210projects.Blood.Types.BUSYPROC;
import ru.m210projects.Blood.Types.DEMO;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.MapInfo;
import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.Types.XSECTOR;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Blood.Types.XWALL;
import ru.m210projects.Blood.VERSION;
import ru.m210projects.Blood.View;
import ru.m210projects.Blood.Weapon;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.WALL;

public class Trigger {
    public static final int kMaxBusyArray = 128;
    public static int gBusyCount = 0;
    public static BUSY[] gBusy = new BUSY[128];
    public static Vector2[] kwall = new Vector2[Globals.kMaxWalls];
    public static Vector3[] ksprite = new Vector3[Globals.kMaxSprites];
    public static int[] secFloorZ = new int[Globals.kMaxSectors];
    public static int[] secCeilZ = new int[Globals.kMaxSectors];
    public static int[] secPath = new int[Globals.kMaxSectors];
    public static final int kRemoteDelay = 18;
    public static final int kProxDelay = 30;
    public static final int kBusyOk = 0;
    public static final int kBusyRestore = 1;
    public static final int kBusyReverse = 2;
    public static final int kBusyComplete = 3;
    public static BUSYPROC[] gBusyProc = new BUSYPROC[]{new BUSYPROC(){

        @Override
        public int run(int nIndex, int nBusy) {
            return Trigger.VCrushBusy(nIndex, nBusy);
        }
    }, new BUSYPROC(){

        @Override
        public int run(int nIndex, int nBusy) {
            return Trigger.VSpriteBusy(nIndex, nBusy);
        }
    }, new BUSYPROC(){

        @Override
        public int run(int nIndex, int nBusy) {
            return Trigger.VDoorBusy(nIndex, nBusy);
        }
    }, new BUSYPROC(){

        @Override
        public int run(int nIndex, int nBusy) {
            return Trigger.HDoorBusy(nIndex, nBusy);
        }
    }, new BUSYPROC(){

        @Override
        public int run(int nIndex, int nBusy) {
            return Trigger.RDoorBusy(nIndex, nBusy);
        }
    }, new BUSYPROC(){

        @Override
        public int run(int nIndex, int nBusy) {
            return Trigger.SRDoorBusy(nIndex, nBusy);
        }
    }, new BUSYPROC(){

        @Override
        public int run(int nIndex, int nBusy) {
            if (nIndex < 0 || nIndex >= Engine.numsectors) {
                Main.game.dassert("nSector >= 0 && nSector < numsectors");
            }
            SECTOR pSector = Engine.sector[nIndex];
            short nXSector = pSector.extra;
            if (nXSector <= 0 || nXSector >= 512) {
                Main.game.dassert("nXSector > 0 && nXSector < kMaxXSectors");
            }
            XSECTOR pXSector = DB.xsector[nXSector];
            pXSector.busy = nBusy;
            if (pXSector.command == 5 && pXSector.txID != 0) {
                EVENT.evSend(nIndex, 6, pXSector.txID, 5);
            }
            if ((nBusy & 0xFFFF) == 0) {
                Trigger.SetSectorState(nIndex, pXSector, nBusy >> 16);
                Trigger.sfxSectorStop(nIndex, nBusy >> 16);
                return 3;
            }
            return 0;
        }
    }, new BUSYPROC(){

        @Override
        public int run(int nIndex, int nBusy) {
            return Trigger.PathSectorBusy(nIndex, nBusy);
        }
    }};
    private static final Vector3 wallVel = new Vector3(100.0f, 100.0f, 250.0f);
    public static int getHighestZ;
    public static int getRangepzTop;
    public static int getRangepzBot;

    public static boolean valueIsBetween(int val, int min, int max) {
        return val > min && val < max;
    }

    public static int Lin2Sin(int nBusy, int opt) {
        switch (opt) {
            case 0: {
                return 32768 - (Trig.Cos(nBusy * 1024 / 65536) >> 15);
            }
            case 2: {
                return 65536 - (Trig.Cos(nBusy * 512 / 65536) >> 14);
            }
            case 3: {
                return Trig.Sin(nBusy * 512 / 65536) >> 14;
            }
        }
        return nBusy;
    }

    public static int gdxTypeSetSpriteState(int nSprite, XSPRITE pXSprite, int state) {
        if ((pXSprite.busy & 0xFFFF) == 0 && pXSprite.state == state) {
            return state ^ pXSprite.state;
        }
        pXSprite.busy = state << 16;
        pXSprite.state = (short)state;
        EVENT.checkEventList(nSprite, 3);
        if ((Engine.sprite[nSprite].hitag & 0x10) != 0 && Engine.sprite[nSprite].zvel >= 200 && Engine.sprite[nSprite].zvel < 256) {
            pXSprite.respawnPending = 3;
            EVENT.evPostCallback(nSprite, 3, Globals.pGameInfo.nMonsterRespawnTime, 9);
            return 1;
        }
        if (state != pXSprite.restState && pXSprite.waitTime > 0) {
            EVENT.evPost(nSprite, 3, pXSprite.waitTime * 120 / 10, pXSprite.restState != 0 ? 1 : 0);
        }
        if (pXSprite.txID != 0 && (pXSprite.triggerOn && pXSprite.state == 1 || pXSprite.triggerOff && pXSprite.state == 0)) {
            switch (pXSprite.command) {
                case 5: 
                case 53: {
                    EVENT.evSend(nSprite, 3, pXSprite.txID, 53);
                    break;
                }
                case 7: {
                    EVENT.evSend(nSprite, 3, pXSprite.txID, pXSprite.command);
                    EVENT.evSend(nSprite, 3, pXSprite.txID, 53);
                    break;
                }
                default: {
                    EVENT.evSend(nSprite, 3, pXSprite.txID, 53);
                    EVENT.evSend(nSprite, 3, pXSprite.txID, pXSprite.command);
                }
            }
        }
        return 1;
    }

    public static int SetSpriteState(int nSprite, XSPRITE pXSprite, int state) {
        if ((pXSprite.busy & 0xFFFF) == 0 && pXSprite.state == state) {
            return state ^ pXSprite.state;
        }
        pXSprite.busy = state << 16;
        pXSprite.state = (short)state;
        EVENT.checkEventList(nSprite, 3);
        if ((Engine.sprite[nSprite].hitag & 0x10) != 0 && Engine.sprite[nSprite].zvel >= 200 && Engine.sprite[nSprite].zvel < 256) {
            pXSprite.respawnPending = 3;
            EVENT.evPostCallback(nSprite, 3, Globals.pGameInfo.nMonsterRespawnTime, 9);
            return 1;
        }
        if (state != pXSprite.restState && pXSprite.waitTime > 0) {
            EVENT.evPost(nSprite, 3, pXSprite.waitTime * 120 / 10, pXSprite.restState != 0 ? 1 : 0);
        }
        if (pXSprite.txID != 0) {
            if (pXSprite.command == 5) {
                return 1;
            }
            if (pXSprite.triggerOn && pXSprite.state == 1) {
                EVENT.evSend(nSprite, 3, pXSprite.txID, pXSprite.command);
            }
            if (pXSprite.triggerOff && pXSprite.state == 0) {
                EVENT.evSend(nSprite, 3, pXSprite.txID, pXSprite.command);
            }
        }
        return 1;
    }

    public static int SetWallState(int nWall, XWALL pXWall, int state) {
        if ((pXWall.busy & 0xFFFF) == 0 && pXWall.state == state) {
            return state ^ pXWall.state;
        }
        pXWall.busy = state << 16;
        pXWall.state = (short)state;
        EVENT.checkEventList(nWall, 0);
        if (state != pXWall.restState && pXWall.waitTime > 0) {
            EVENT.evPost(nWall, 0, pXWall.waitTime * 120 / 10, pXWall.restState != 0 ? 1 : 0);
        }
        if (pXWall.txID != 0) {
            if (pXWall.command == 5) {
                return 1;
            }
            if (pXWall.triggerOn && pXWall.state == 1) {
                EVENT.evSend(nWall, 0, pXWall.txID, pXWall.command);
            }
            if (pXWall.triggerOff && pXWall.state == 0) {
                EVENT.evSend(nWall, 0, pXWall.txID, pXWall.command);
            }
        }
        return 1;
    }

    public static void SetSectorState(int nSector, XSECTOR pXSector, int state) {
        if ((pXSector.busy & 0xFFFF) == 0 && pXSector.state == state) {
            return;
        }
        pXSector.busy = state << 16;
        pXSector.state = (short)state;
        EVENT.checkEventList(nSector, 6);
        if (state == 1) {
            if (pXSector.command != 5 && pXSector.triggerOn && pXSector.txID != 0) {
                EVENT.evSend(nSector, 6, pXSector.txID, pXSector.command);
            }
            if (pXSector.stopFlag[1]) {
                pXSector.stopFlag[1] = false;
                pXSector.stopFlag[0] = false;
                return;
            }
            if (pXSector.waitFlag[1]) {
                EVENT.evPost(nSector, 6, pXSector.waitTime[1] * 120 / 10, 0);
            }
            return;
        }
        if (pXSector.command != 5 && pXSector.triggerOff && pXSector.txID != 0) {
            EVENT.evSend(nSector, 6, pXSector.txID, pXSector.command);
        }
        if (pXSector.stopFlag[0]) {
            pXSector.stopFlag[1] = false;
            pXSector.stopFlag[0] = false;
            return;
        }
        if (pXSector.waitFlag[0]) {
            EVENT.evPost(nSector, 6, pXSector.waitTime[0] * 120 / 10, 1);
        }
    }

    public static void AddBusy(int nIndex, int busyProc, int nDelta) {
        int i;
        if (nDelta == 0) {
            Main.game.dassert("nDelta != 0");
        }
        for (i = 0; i < gBusyCount && (nIndex != Trigger.gBusy[i].nIndex || busyProc != Trigger.gBusy[i].busyProc); ++i) {
        }
        if (i == gBusyCount) {
            if (gBusyCount == 128) {
                return;
            }
            Trigger.gBusy[i].nIndex = nIndex;
            Trigger.gBusy[i].busyProc = busyProc;
            Trigger.gBusy[i].nBusy = nDelta > 0 ? 0 : 65536;
            ++gBusyCount;
        }
        Trigger.gBusy[i].nDelta = nDelta;
    }

    public static void ReverseBusy(int nIndex, int busyProc) {
        for (int i = 0; i < gBusyCount; ++i) {
            if (nIndex != Trigger.gBusy[i].nIndex || busyProc != Trigger.gBusy[i].busyProc) continue;
            Trigger.gBusy[i].nDelta = -Trigger.gBusy[i].nDelta;
            return;
        }
    }

    public static int GetSourceBusy(int event) {
        switch (EVENT.getType(event)) {
            case 6: {
                short nXIndex = Engine.sector[EVENT.getIndex((int)event)].extra;
                if (nXIndex <= 0 || nXIndex >= 512) {
                    Main.game.dassert("nXIndex > 0 && nXIndex < kMaxXSectors");
                }
                return DB.xsector[nXIndex].busy;
            }
            case 0: {
                short nXIndex = Engine.wall[EVENT.getIndex((int)event)].extra;
                if (nXIndex <= 0 || nXIndex >= 512) {
                    Main.game.dassert("nXIndex > 0 && nXIndex < kMaxXWalls");
                }
                return DB.xwall[nXIndex].busy;
            }
            case 3: {
                short nXIndex = Engine.sprite[EVENT.getIndex((int)event)].extra;
                if (nXIndex <= 0 || nXIndex >= 2048) {
                    Main.game.dassert("nXIndex > 0 && nXIndex < kMaxXSprites");
                }
                return DB.xsprite[nXIndex].busy;
            }
        }
        return 0;
    }

    public static void OperateSprite(int nSprite, XSPRITE pXSprite, int evCommand) {
        SPRITE pSprite = Engine.sprite[nSprite];
        switch (evCommand) {
            case 6: {
                pXSprite.Locked = 1;
                switch (pSprite.lotag) {
                    case 39: {
                        Trigger.stopWindOnSectors(pXSprite);
                    }
                }
                return;
            }
            case 7: {
                pXSprite.Locked = 0;
                return;
            }
            case 8: {
                pXSprite.Locked ^= 1;
                switch (pSprite.lotag) {
                    case 39: {
                        if (pXSprite.Locked != 1) break;
                        Trigger.stopWindOnSectors(pXSprite);
                    }
                }
                return;
            }
        }
        if (pSprite.statnum == 6 && Actor.IsDudeSprite(pSprite)) {
            switch (evCommand) {
                case 0: {
                    Trigger.SetSpriteState(nSprite, pXSprite, 0);
                    break;
                }
                case 1: 
                case 30: 
                case 33: {
                    if (pXSprite.state == 0) {
                        Trigger.SetSpriteState(nSprite, pXSprite, 1);
                    }
                    Ai.aiActivateDude(pSprite, pXSprite);
                    break;
                }
                case 35: {
                    if (pXSprite.state != 0) break;
                    Trigger.SetSpriteState(nSprite, pXSprite, 1);
                    Ai.aiActivateDude(pSprite, pXSprite);
                }
            }
            return;
        }
        block16 : switch (pSprite.lotag) {
            case 25: {
                int maxRetries;
                int tx = 0;
                if (pXSprite.data1 > 0 && pXSprite.data2 <= 0 && pXSprite.data3 <= 0 && pXSprite.data4 > 0) {
                    if (pXSprite.data1 > pXSprite.data4) {
                        short tmp = pXSprite.data1;
                        pXSprite.data1 = (short)pXSprite.data4;
                        pXSprite.data4 = tmp;
                    }
                    int total = pXSprite.data4 - pXSprite.data1;
                    while (maxRetries > 0 && (tx = Globals.pGameInfo.nGameType != 0 || Mmulti.numplayers > 1 ? Gameutils.Random(total) + pXSprite.data1 : (int)((double)total * Math.random()) + pXSprite.data1) == pXSprite.txID) {
                        --maxRetries;
                    }
                } else {
                    for (maxRetries = 10; maxRetries > 0 && ((tx = Actor.GetRandDataVal(null, pSprite)) <= 0 || tx == pXSprite.txID); --maxRetries) {
                    }
                }
                pXSprite.txID = (short)tx;
                Trigger.SetSpriteState(nSprite, pXSprite, pXSprite.state ^ 1);
                break;
            }
            case 26: {
                boolean range = false;
                int cnt = 3;
                int tx = 0;
                if (pXSprite.data1 > 0 && pXSprite.data2 <= 0 && pXSprite.data3 <= 0 && pXSprite.data4 > 0) {
                    if (pXSprite.data1 > pXSprite.data4) {
                        short tmp = pXSprite.data1;
                        pXSprite.data1 = (short)pXSprite.data4;
                        pXSprite.data4 = tmp;
                    }
                    if (pSprite.hitag == 1) {
                        for (int i = pXSprite.data1; i <= pXSprite.data4; ++i) {
                            EVENT.evSend(nSprite, 3, i, pXSprite.command);
                        }
                        pXSprite.dropMsg = 0;
                        return;
                    }
                    if (pXSprite.dropMsg < pXSprite.data1) {
                        pXSprite.dropMsg = pXSprite.data1;
                    } else if (pXSprite.dropMsg > pXSprite.data4) {
                        pXSprite.dropMsg = (short)pXSprite.data4;
                    }
                    range = true;
                } else {
                    if (pSprite.hitag == 1) {
                        for (int i = 0; i < 4; ++i) {
                            tx = Actor.GetDataVal(pSprite, i);
                            if (tx <= 0) continue;
                            EVENT.evSend(nSprite, 3, tx, pXSprite.command);
                        }
                        pXSprite.dropMsg = 0;
                        return;
                    }
                    if (pXSprite.dropMsg > 3) {
                        pXSprite.dropMsg = 0;
                    } else if (pXSprite.dropMsg < 0) {
                        pXSprite.dropMsg = (short)3;
                    }
                }
                block53 : switch (evCommand) {
                    case 0: {
                        if (!range) {
                            while (cnt-- >= 0) {
                                pXSprite.dropMsg = (short)(pXSprite.dropMsg - 1);
                                if (pXSprite.dropMsg < 0) {
                                    pXSprite.dropMsg = (short)3;
                                }
                                if ((tx = Actor.GetDataVal(pSprite, pXSprite.dropMsg)) < 0) {
                                    Main.game.ThrowError(" -- Current data index is negative");
                                }
                                if (tx <= 0) continue;
                                break block53;
                            }
                            break;
                        }
                        pXSprite.dropMsg = (short)(pXSprite.dropMsg - 1);
                        if (pXSprite.dropMsg < pXSprite.data1) {
                            pXSprite.dropMsg = (short)pXSprite.data4;
                        }
                        tx = pXSprite.dropMsg;
                        break;
                    }
                    default: {
                        if (!range) {
                            while (cnt-- >= 0) {
                                if (pXSprite.dropMsg > 3) {
                                    pXSprite.dropMsg = 0;
                                }
                                if ((tx = Actor.GetDataVal(pSprite, pXSprite.dropMsg)) < 0) {
                                    Main.game.ThrowError(" ++ Current data index is negative");
                                }
                                pXSprite.dropMsg = (short)(pXSprite.dropMsg + 1);
                                if (tx <= 0) continue;
                                break block53;
                            }
                            break;
                        }
                        tx = pXSprite.dropMsg;
                        pXSprite.dropMsg = pXSprite.dropMsg >= pXSprite.data4 ? pXSprite.data1 : (short)(pXSprite.dropMsg + 1);
                    }
                }
                pXSprite.txID = (short)tx;
                Trigger.SetSpriteState(nSprite, pXSprite, pXSprite.state ^ 1);
                break;
            }
            case 24: {
                if (Globals.pGameInfo.nMonsterSettings == 0 || Actor.actSpawnCustomDude(pSprite, -1) == null) break;
                ++LEVELS.totalKills;
                break;
            }
            case 18: {
                if (Globals.pGameInfo.nMonsterSettings == 0 || pXSprite.data1 < 200 || pXSprite.data1 >= 256) break;
                SPRITE pSpawn = null;
                if (!DEMO.IsOriginalDemo()) {
                    pSpawn = Actor.spawnRandomDude(pSprite);
                    if (pSpawn == null) {
                        pSpawn = Actor.actSpawnDude(pSprite, pXSprite.data1, -1);
                    }
                } else {
                    pSpawn = Actor.actSpawnDude(pSprite, pXSprite.data1, -1);
                }
                if (pSpawn == null) break;
                ++LEVELS.totalKills;
                switch (pSpawn.lotag) {
                    case 239: 
                    case 240: 
                    case 241: 
                    case 242: 
                    case 252: 
                    case 253: {
                        XSPRITE pXSpawn = DB.xsprite[pSpawn.extra];
                        pXSpawn.health = DudeInfo.dudeInfo[pXSprite.data1 - 200].startHealth << 4;
                        pXSpawn.burnTime = 10;
                        pXSpawn.target = -1;
                        Ai.aiActivateDude(pSpawn, pXSpawn);
                    }
                }
                break;
            }
            case 19: {
                if (Globals.pGameInfo.nGameType >= 2) break;
                pXSprite.isTriggered = true;
                pXSprite.triggerOn = false;
                Trigger.SetSpriteState(nSprite, pXSprite, 1);
                short i = Mmulti.connecthead;
                while (i >= 0) {
                    int dx = pSprite.x - Globals.gPlayer[i].pSprite.x >> 4;
                    int dy = pSprite.y - Globals.gPlayer[i].pSprite.y >> 4;
                    int dz = pSprite.z - Globals.gPlayer[i].pSprite.z >> 8;
                    Globals.gPlayer[i].quakeTime = (pXSprite.data1 << 16) / (262144 + dx * dx + dy * dy + dz * dz);
                    i = Mmulti.connectpoint2[i];
                }
                break;
            }
            case 8: {
                if (pXSprite.txID <= 0) {
                    if (Trigger.SetSpriteState(nSprite, pXSprite, pXSprite.state ^ 1) != 1) break;
                    Trigger.useTeleportTarget(pXSprite, null);
                    break;
                }
                Trigger.gdxTypeSetSpriteState(nSprite, pXSprite, pXSprite.state ^ 1);
                break;
            }
            case 36: {
                if (pXSprite.txID <= 0) {
                    if (Trigger.SetSpriteState(nSprite, pXSprite, pXSprite.state ^ 1) != 1) break;
                    Trigger.useSpriteDamager(pXSprite, null);
                    break;
                }
                Trigger.gdxTypeSetSpriteState(nSprite, pXSprite, pXSprite.state ^ 1);
                break;
            }
            case 28: 
            case 29: 
            case 31: 
            case 34: 
            case 35: {
                Trigger.gdxTypeSetSpriteState(nSprite, pXSprite, pXSprite.state ^ 1);
                break;
            }
            case 20: {
                switch (evCommand) {
                    case 0: {
                        if (Trigger.SetSpriteState(nSprite, pXSprite, 0) != 1) break block16;
                        SOUND.sfxStart3DSound(pSprite, pXSprite.data2, 0, 0);
                        break;
                    }
                    case 1: {
                        if (Trigger.SetSpriteState(nSprite, pXSprite, 1) != 1) break block16;
                        SOUND.sfxStart3DSound(pSprite, pXSprite.data1, 0, 0);
                        break;
                    }
                    default: {
                        if (Trigger.SetSpriteState(nSprite, pXSprite, pXSprite.state ^ 1) != 1) break block16;
                        if (pXSprite.state == 0) {
                            SOUND.sfxStart3DSound(pSprite, pXSprite.data2, 0, 0);
                            break;
                        }
                        SOUND.sfxStart3DSound(pSprite, pXSprite.data1, 0, 0);
                        break;
                    }
                }
                break;
            }
            case 21: {
                switch (evCommand) {
                    case 0: {
                        if (Trigger.SetSpriteState(nSprite, pXSprite, 0) != 1) break block16;
                        SOUND.sfxStart3DSound(pSprite, pXSprite.data2, 0, 0);
                        break;
                    }
                    case 1: {
                        if (Trigger.SetSpriteState(nSprite, pXSprite, 1) != 1) break block16;
                        SOUND.sfxStart3DSound(pSprite, pXSprite.data1, 0, 0);
                        break;
                    }
                    default: {
                        if (Trigger.SetSpriteState(nSprite, pXSprite, pXSprite.restState ^ 1) != 1) break block16;
                        if (pXSprite.state == 0) {
                            SOUND.sfxStart3DSound(pSprite, pXSprite.data2, 0, 0);
                            break;
                        }
                        SOUND.sfxStart3DSound(pSprite, pXSprite.data1, 0, 0);
                        break;
                    }
                }
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                if (pXSprite.command != 5 || pXSprite.txID == 0) break;
                EVENT.evSend(nSprite, 3, pXSprite.txID, 5);
                break;
            }
            case 15: {
                switch (evCommand) {
                    case 0: {
                        Trigger.SetSpriteState(nSprite, pXSprite, 0);
                        break;
                    }
                    case 1: {
                        Trigger.SetSpriteState(nSprite, pXSprite, 1);
                        break;
                    }
                    case 5: {
                        if (pXSprite.txID == 0) break block16;
                        EVENT.evSend(nSprite, 3, pXSprite.txID, 5);
                        break;
                    }
                    default: {
                        Trigger.SetSpriteState(nSprite, pXSprite, pXSprite.state ^ 1);
                        break;
                    }
                }
                break;
            }
            case 22: {
                switch (evCommand) {
                    case 0: {
                        pXSprite.data1 = (short)(pXSprite.data1 - 1);
                        if (pXSprite.data1 >= 0) break;
                        pXSprite.data1 = (short)(pXSprite.data1 + pXSprite.data3);
                        break;
                    }
                    default: {
                        pXSprite.data1 = (short)(pXSprite.data1 + 1);
                        if (pXSprite.data1 < pXSprite.data3) break;
                        pXSprite.data1 = (short)(pXSprite.data1 - pXSprite.data3);
                    }
                }
                if (pXSprite.command == 5 && pXSprite.txID != 0) {
                    EVENT.evSend(nSprite, 3, pXSprite.txID, 5);
                }
                SOUND.sfxStart3DSound(pSprite, pXSprite.data4, -1, 0);
                if (pXSprite.data1 == pXSprite.data2) {
                    Trigger.SetSpriteState(nSprite, pXSprite, 1);
                    break;
                }
                Trigger.SetSpriteState(nSprite, pXSprite, 0);
                break;
            }
            case 23: {
                switch (evCommand) {
                    case 0: {
                        Trigger.SetSpriteState(nSprite, pXSprite, 0);
                        break block16;
                    }
                    case 1: {
                        Trigger.SetSpriteState(nSprite, pXSprite, 1);
                        SeqHandling.seqSpawn(VERSION.getSeq(2), 3, pSprite.extra, null);
                        break block16;
                    }
                }
                Trigger.SetSpriteState(nSprite, pXSprite, pXSprite.state ^ 1);
                if (pXSprite.state == 0) break;
                SeqHandling.seqSpawn(VERSION.getSeq(2), 3, pSprite.extra, null);
                break;
            }
            case 402: {
                if (Engine.sprite[nSprite].statnum == 8) break;
                switch (evCommand) {
                    case 1: {
                        SOUND.sfxStart3DSound(pSprite, 454, 0, 0);
                        EVENT.evPost(nSprite, 3, 18L, 0);
                        break block16;
                    }
                }
                Actor.actExplodeSprite((short)nSprite);
                break;
            }
            case 405: 
            case 408: {
                if (Trigger.SetSpriteState(nSprite, pXSprite, 0) == 0) {
                    return;
                }
                Actor.actPostSprite(nSprite, 1024);
                break;
            }
            case 400: {
                if ((pSprite.hitag & 0x10) != 0) break;
                Actor.actExplodeSprite(nSprite);
                break;
            }
            case 418: 
            case 419: 
            case 420: {
                Actor.actExplodeSprite(nSprite);
                break;
            }
            case 401: 
            case 433: {
                if (Engine.sprite[nSprite].statnum == 8) break;
                switch (evCommand) {
                    case 1: {
                        SOUND.sfxStart3DSound(pSprite, 451, 0, 0);
                        pXSprite.Proximity = true;
                        break;
                    }
                    case 35: {
                        if (pXSprite.state != 0) break;
                        SOUND.sfxStart3DSound(pSprite, 452, 0, 0);
                        EVENT.evPost(nSprite, 3, 30L, 0);
                        pXSprite.state = 1;
                        break;
                    }
                    default: {
                        Actor.actExplodeSprite(nSprite);
                        break;
                    }
                }
                break;
            }
            case 413: {
                if (pXSprite.health <= 0) break;
                if (evCommand == 1) {
                    if (Trigger.SetSpriteState(nSprite, pXSprite, 1) == 0) break;
                    SeqHandling.seqSpawn(VERSION.getSeq(3), 3, pSprite.extra, SeqHandling.callbacks[2]);
                    if (pXSprite.data1 <= 0) break;
                    pXSprite.data2 = pXSprite.data1;
                    break;
                }
                if (evCommand != 0 || Trigger.SetSpriteState(nSprite, pXSprite, 0) == 0) break;
                SeqHandling.seqSpawn(VERSION.getSeq(5), 3, pSprite.extra, null);
                break;
            }
            case 452: {
                if (evCommand == 1) {
                    if (Trigger.SetSpriteState(nSprite, pXSprite, 1) == 0) break;
                    SeqHandling.seqSpawn(VERSION.getSeq(3), 3, pSprite.extra, null);
                    SOUND.sfxStart3DSound(pSprite, 441, 0, 0);
                    break;
                }
                if (evCommand != 0 || Trigger.SetSpriteState(nSprite, pXSprite, 0) == 0) break;
                SeqHandling.seqSpawn(VERSION.getSeq(5), 3, pSprite.extra, null);
                SOUND.sfxKill3DSound(pSprite, -1, -1);
                break;
            }
            case 414: {
                if (Trigger.SetSpriteState(nSprite, pXSprite, 1) == 0) break;
                pSprite.hitag = (short)(pSprite.hitag | 7);
                break;
            }
            case 416: 
            case 417: 
            case 425: 
            case 426: 
            case 427: {
                switch (evCommand) {
                    case 0: {
                        if (Trigger.SetSpriteState(nSprite, pXSprite, 0) != 1) break block16;
                        Actor.actGibObject(pSprite, pXSprite);
                        break;
                    }
                    case 1: {
                        if (Trigger.SetSpriteState(nSprite, pXSprite, 1) != 1) break block16;
                        Actor.actGibObject(pSprite, pXSprite);
                        break;
                    }
                    default: {
                        if (Trigger.SetSpriteState(nSprite, pXSprite, pXSprite.state ^ 1) != 1) break block16;
                        Actor.actGibObject(pSprite, pXSprite);
                        break;
                    }
                }
                break;
            }
            case 456: {
                switch (evCommand) {
                    case 0: {
                        pXSprite.state = 0;
                        pSprite.cstat = (short)(pSprite.cstat | 0x8000);
                        pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFFFE);
                        break;
                    }
                    case 1: {
                        pXSprite.state = 1;
                        pSprite.cstat = (short)(pSprite.cstat & 0xFFFF7FFF);
                        pSprite.cstat = (short)(pSprite.cstat | 1);
                        break;
                    }
                    case 3: {
                        pXSprite.state = (short)(pXSprite.state ^ 1);
                        pSprite.cstat = (short)(pSprite.cstat ^ 0x8000);
                        pSprite.cstat = (short)(pSprite.cstat ^ 1);
                    }
                }
                break;
            }
            case 459: {
                if (evCommand != 1) {
                    pSprite.cstat = (short)(pSprite.cstat & 0xFFFF7FFF);
                    Actor.actExplodeSprite(pSprite.xvel);
                    return;
                }
                Trigger.SetSpriteState(nSprite, pXSprite, 1);
                break;
            }
            case 431: {
                Weapon.LeechOperate(pSprite, pXSprite, evCommand);
                break;
            }
            case 435: {
                AIUNICULT.dudeLeechOperate(pSprite, pXSprite, evCommand);
                break;
            }
            case 27: 
            case 38: {
                switch (evCommand) {
                    case 0: {
                        if (pXSprite.state != 1) break block16;
                        Trigger.SetSpriteState(nSprite, pXSprite, 0);
                        break;
                    }
                    case 1: {
                        EVENT.checkEventList(nSprite, 3);
                        if (pXSprite.state == 0) {
                            Trigger.SetSpriteState(nSprite, pXSprite, 1);
                        }
                    }
                    case 21: {
                        if (pXSprite.txID <= 0) {
                            if (pSprite.lotag == 27) {
                                Trigger.useSeqSpawnerGen(pXSprite, 3, pSprite.xvel);
                            } else {
                                Trigger.useEffectGen(pXSprite, pSprite);
                            }
                        } else {
                            switch (pXSprite.command) {
                                case 5: {
                                    EVENT.evSend(nSprite, 3, pXSprite.txID, 53);
                                    break;
                                }
                                case 7: {
                                    EVENT.evSend(nSprite, 3, pXSprite.txID, pXSprite.command);
                                    EVENT.evSend(nSprite, 3, pXSprite.txID, 53);
                                    break;
                                }
                                default: {
                                    EVENT.evSend(nSprite, 3, pXSprite.txID, 53);
                                    EVENT.evSend(nSprite, 3, pXSprite.txID, pXSprite.command);
                                }
                            }
                        }
                        if (pXSprite.busyTime <= 0) break block16;
                        EVENT.evPost(nSprite, 3, (pXSprite.busyTime + Gameutils.BiRandom(pXSprite.data1)) * 120 / 10, 21);
                        break;
                    }
                    default: {
                        if (pXSprite.state == 0) {
                            EVENT.evPost(nSprite, 3, 0L, 1);
                            break;
                        }
                        EVENT.evPost(nSprite, 3, 0L, 0);
                        break;
                    }
                }
                break;
            }
            case 39: {
                switch (evCommand) {
                    case 0: {
                        Trigger.stopWindOnSectors(pXSprite);
                        if (pXSprite.state != 1) break block16;
                        Trigger.SetSpriteState(nSprite, pXSprite, 0);
                        break;
                    }
                    case 1: {
                        EVENT.checkEventList(nSprite, 3);
                        if (pXSprite.state == 0) {
                            Trigger.SetSpriteState(nSprite, pXSprite, 1);
                        }
                    }
                    case 21: {
                        if (pXSprite.txID <= 0) {
                            Trigger.useSectorWindGen(pXSprite, Engine.sector[pSprite.sectnum]);
                        } else {
                            switch (pXSprite.command) {
                                case 5: {
                                    EVENT.evSend(nSprite, 3, pXSprite.txID, 53);
                                    break;
                                }
                                case 7: {
                                    EVENT.evSend(nSprite, 3, pXSprite.txID, pXSprite.command);
                                    EVENT.evSend(nSprite, 3, pXSprite.txID, 53);
                                    break;
                                }
                                default: {
                                    EVENT.evSend(nSprite, 3, pXSprite.txID, 53);
                                    EVENT.evSend(nSprite, 3, pXSprite.txID, pXSprite.command);
                                }
                            }
                        }
                        if (pXSprite.busyTime <= 0) break block16;
                        EVENT.evPost(nSprite, 3, pXSprite.busyTime, 21);
                        break;
                    }
                    default: {
                        if (pXSprite.state == 0) {
                            EVENT.evPost(nSprite, 3, 0L, 1);
                            break;
                        }
                        EVENT.evPost(nSprite, 3, 0L, 0);
                        break;
                    }
                }
                break;
            }
            case 33: {
                boolean activated = false;
                if (pXSprite.dropMsg == 3 && 3 != pXSprite.data4) {
                    Trigger.activateDudes(pXSprite.txID);
                    activated = true;
                }
                switch (evCommand) {
                    case 0: {
                        if (pXSprite.data4 == 3 && !activated) {
                            Trigger.activateDudes(pXSprite.txID);
                        }
                        if (pXSprite.state != 1) break;
                        Trigger.SetSpriteState(nSprite, pXSprite, 0);
                        break;
                    }
                    case 1: {
                        EVENT.checkEventList(nSprite, 3);
                        if (pXSprite.state == 0) {
                            Trigger.SetSpriteState(nSprite, pXSprite, 1);
                        }
                    }
                    case 21: {
                        if (pXSprite.txID <= 0 || !Trigger.getDudesForTargetChg(pXSprite)) {
                            EVENT.evPost(nSprite, 3, 0L, 0);
                            break;
                        }
                        switch (pXSprite.command) {
                            case 5: {
                                EVENT.evSend(nSprite, 3, pXSprite.txID, 53);
                                break;
                            }
                            case 7: {
                                EVENT.evSend(nSprite, 3, pXSprite.txID, pXSprite.command);
                                EVENT.evSend(nSprite, 3, pXSprite.txID, 53);
                                break;
                            }
                            default: {
                                EVENT.evSend(nSprite, 3, pXSprite.txID, 53);
                                EVENT.evSend(nSprite, 3, pXSprite.txID, pXSprite.command);
                            }
                        }
                        if (pXSprite.busyTime <= 0) break;
                        EVENT.evPost(nSprite, 3, pXSprite.busyTime, 21);
                        break;
                    }
                    default: {
                        if (pXSprite.state == 0) {
                            EVENT.evPost(nSprite, 3, 0L, 1);
                            break;
                        }
                        EVENT.evPost(nSprite, 3, 0L, 0);
                    }
                }
                pXSprite.dropMsg = (short)pXSprite.data4;
                break;
            }
            case 37: {
                switch (evCommand) {
                    case 0: {
                        if (pXSprite.state != 1) break block16;
                        Trigger.SetSpriteState(nSprite, pXSprite, 0);
                        break;
                    }
                    case 1: {
                        EVENT.checkEventList(nSprite, 3);
                        if (pXSprite.state == 0) {
                            Trigger.SetSpriteState(nSprite, pXSprite, 1);
                        }
                    }
                    case 21: {
                        if (pXSprite.txID <= 0 || pSprite.hitag == 0 && Trigger.goalValueIsReached(pXSprite)) {
                            EVENT.evPost(nSprite, 3, 0L, 0);
                            break;
                        }
                        if (pXSprite.txID <= 0 || pXSprite.data1 <= 0 || pXSprite.data1 > 4) break block16;
                        switch (pXSprite.command) {
                            case 5: {
                                EVENT.evSend(nSprite, 3, pXSprite.txID, 53);
                                break;
                            }
                            case 7: {
                                EVENT.evSend(nSprite, 3, pXSprite.txID, pXSprite.command);
                                EVENT.evSend(nSprite, 3, pXSprite.txID, 53);
                                break;
                            }
                            default: {
                                EVENT.evSend(nSprite, 3, pXSprite.txID, 53);
                                EVENT.evSend(nSprite, 3, pXSprite.txID, pXSprite.command);
                            }
                        }
                        if (pXSprite.busyTime <= 0) break block16;
                        EVENT.evPost(nSprite, 3, pXSprite.busyTime, 21);
                        break;
                    }
                    default: {
                        if (pXSprite.state == 0) {
                            EVENT.evPost(nSprite, 3, 0L, 1);
                            break;
                        }
                        EVENT.evPost(nSprite, 3, 0L, 0);
                        break;
                    }
                }
                break;
            }
            case 704: {
                if (DEMO.IsOriginalDemo()) break;
                switch (evCommand) {
                    case 0: {
                        if (pXSprite.state != 1) break block16;
                        Trigger.SetSpriteState(nSprite, pXSprite, 0);
                        break;
                    }
                    case 1: {
                        EVENT.checkEventList(nSprite, 3);
                        if (pXSprite.state == 0) {
                            Trigger.SetSpriteState(nSprite, pXSprite, 1);
                        }
                    }
                    case 21: {
                        Trigger.ActivateGenerator(nSprite);
                        if (pXSprite.txID != 0) {
                            EVENT.evSend(nSprite, 3, pXSprite.txID, pXSprite.command);
                        }
                        if (pXSprite.busyTime <= 0) break block16;
                        EVENT.evPost(nSprite, 3, pXSprite.busyTime * 120 / 10, 21);
                        break;
                    }
                    default: {
                        if (pXSprite.state == 0) {
                            EVENT.evPost(nSprite, 3, 0L, 1);
                            break;
                        }
                        EVENT.evPost(nSprite, 3, 0L, 0);
                        break;
                    }
                }
                break;
            }
            case 40: 
            case 80: {
                if (DEMO.IsOriginalDemo()) break;
                switch (evCommand) {
                    case 0: {
                        if (pXSprite.state != 1) break block16;
                        Trigger.SetSpriteState(nSprite, pXSprite, 0);
                        break;
                    }
                    case 1: {
                        EVENT.checkEventList(nSprite, 3);
                        if (pXSprite.state == 0) {
                            Trigger.SetSpriteState(nSprite, pXSprite, 1);
                        }
                    }
                    case 21: {
                        Trigger.ActivateGenerator(nSprite);
                        if (pXSprite.busyTime <= 0) break block16;
                        EVENT.evPost(nSprite, 3, pXSprite.busyTime * 120 / 10, 21);
                        break;
                    }
                    default: {
                        if (pXSprite.state == 0) {
                            EVENT.evPost(nSprite, 3, 0L, 1);
                            break;
                        }
                        EVENT.evPost(nSprite, 3, 0L, 0);
                        break;
                    }
                }
                break;
            }
            case 700: 
            case 701: 
            case 702: 
            case 703: 
            case 705: 
            case 706: 
            case 707: 
            case 708: {
                switch (evCommand) {
                    case 0: {
                        Trigger.SetSpriteState(nSprite, pXSprite, 0);
                        break;
                    }
                    case 21: {
                        if (pSprite.lotag != 700) {
                            Trigger.ActivateGenerator(nSprite);
                        }
                        if (pXSprite.txID != 0) {
                            EVENT.evSend(nSprite, 3, pXSprite.txID, pXSprite.command);
                        }
                        if (pXSprite.busyTime <= 0) break block16;
                        EVENT.evPost(nSprite, 3, (pXSprite.busyTime + Gameutils.BiRandom(pXSprite.data1)) * 120 / 10, 21);
                        break;
                    }
                    default: {
                        if (pXSprite.state != 0) break block16;
                        Trigger.SetSpriteState(nSprite, pXSprite, 1);
                        EVENT.evPost(nSprite, 3, 0L, 21);
                        break;
                    }
                }
                break;
            }
            case 711: {
                if (Globals.pGameInfo.nGameType == 0) {
                    if (Globals.gMe == null || Globals.gMe.pXsprite == null || Globals.gMe.pXsprite.health == 0) {
                        return;
                    }
                    Globals.gMe.stayTime = 0;
                }
                SOUND.sndStartSample(pXSprite.data1, -1, 1, false);
                break;
            }
            default: {
                switch (evCommand) {
                    case 0: {
                        Trigger.SetSpriteState(nSprite, pXSprite, 0);
                        break block16;
                    }
                    case 1: {
                        Trigger.SetSpriteState(nSprite, pXSprite, 1);
                        break block16;
                    }
                }
                Trigger.SetSpriteState(nSprite, pXSprite, pXSprite.state ^ 1);
            }
        }
    }

    public static void OperateWall(int nWall, XWALL pXWall, int evCommand) {
        WALL pWall = Engine.wall[nWall];
        switch (evCommand) {
            case 6: {
                pXWall.locked = 1;
                return;
            }
            case 7: {
                pXWall.locked = 0;
                return;
            }
            case 8: {
                pXWall.locked ^= 1;
                return;
            }
        }
        block5 : switch (pWall.lotag) {
            case 511: {
                int spartType;
                int action = 0;
                switch (evCommand) {
                    case 0: {
                        action = Trigger.SetWallState(nWall, pXWall, 0);
                        break;
                    }
                    case 1: 
                    case 51: {
                        action = Trigger.SetWallState(nWall, pXWall, 1);
                        break;
                    }
                    default: {
                        action = Trigger.SetWallState(nWall, pXWall, pXWall.state ^ 1);
                    }
                }
                if (action == 0) break;
                WALL nextWall = null;
                if (pWall.nextwall >= 0) {
                    nextWall = Engine.wall[pWall.nextwall];
                }
                if (pXWall.state != 0) {
                    pWall.cstat = (short)(pWall.cstat & 0xFFFFFFBE);
                    if (nextWall != null) {
                        nextWall.cstat = (short)(nextWall.cstat & 0xFFFFFFBE);
                        pWall.cstat = (short)(pWall.cstat & 0xFFFFFFEF);
                        nextWall.cstat = (short)(nextWall.cstat & 0xFFFFFFEF);
                    }
                } else {
                    pWall.cstat = (short)(pWall.cstat | 1);
                    if (pXWall.triggerVector) {
                        pWall.cstat = (short)(pWall.cstat | 0x40);
                    }
                    if (nextWall != null) {
                        nextWall.cstat = (short)(nextWall.cstat & 0xFFFFFFFE);
                        if (pXWall.triggerVector) {
                            nextWall.cstat = (short)(nextWall.cstat | 0x40);
                        }
                        pWall.cstat = (short)(pWall.cstat | 0x10);
                        nextWall.cstat = (short)(nextWall.cstat | 0x10);
                    }
                }
                if (pXWall.state == 0 || (spartType = Gameutils.ClipRange(pXWall.data, 0, 31)) <= 0) break;
                Gib.walGenerateGib(nWall, spartType, wallVel);
                break;
            }
            default: {
                switch (evCommand) {
                    case 0: {
                        Trigger.SetWallState(nWall, pXWall, 0);
                        break block5;
                    }
                    case 1: {
                        Trigger.SetWallState(nWall, pXWall, 1);
                        break block5;
                    }
                }
                Trigger.SetWallState(nWall, pXWall, pXWall.state ^ 1);
            }
        }
    }

    public static void sfxSectorBusy(int nSector, int nBusy) {
        short i = Engine.headspritesect[nSector];
        while (i >= 0) {
            SPRITE pSprite = Engine.sprite[i];
            if (pSprite.statnum == 0 && pSprite.lotag == 709) {
                short nXSprite = pSprite.extra;
                if (nXSprite <= 0 || nXSprite >= 2048) {
                    Main.game.dassert("nXSprite > 0 && nXSprite < kMaxXSprites: " + nXSprite);
                }
                XSPRITE pXSPrite = DB.xsprite[nXSprite];
                if (nBusy != 0) {
                    if (pXSPrite.data3 != 0) {
                        SOUND.sfxStart3DSound(pSprite, pXSPrite.data3, 0, 0);
                    }
                } else if (pXSPrite.data1 != 0) {
                    SOUND.sfxStart3DSound(pSprite, pXSPrite.data1, 0, 0);
                }
            }
            i = Engine.nextspritesect[i];
        }
    }

    public static void sfxSectorBusy(int nSector, int soundId, int flags) {
        short i = Engine.headspritesect[nSector];
        while (i >= 0) {
            SPRITE pSprite = Engine.sprite[i];
            if (pSprite.statnum == 0 && pSprite.lotag == 709) {
                SOUND.sfxStart3DSound(pSprite, soundId, 0, flags);
            }
            i = Engine.nextspritesect[i];
        }
    }

    public static void sfxSectorStop(int nSector, int nBusy) {
        short i = Engine.headspritesect[nSector];
        while (i >= 0) {
            SPRITE pSprite = Engine.sprite[i];
            if (pSprite.statnum == 0 && pSprite.lotag == 709) {
                short nXSprite = pSprite.extra;
                if (nXSprite <= 0 || nXSprite >= 2048) {
                    Main.game.dassert("nXSprite > 0 && nXSprite < kMaxXSprites");
                }
                XSPRITE pXSPrite = DB.xsprite[nXSprite];
                if (nBusy != 0) {
                    if (pXSPrite.data2 != 0) {
                        SOUND.sfxStart3DSound(pSprite, pXSPrite.data2, 0, 0);
                    }
                } else if (pXSPrite.data4 != 0) {
                    SOUND.sfxStart3DSound(pSprite, pXSPrite.data4, 0, 0);
                }
            }
            i = Engine.nextspritesect[i];
        }
    }

    public static void TranslateSector(int nSector, int i0, int i1, int cx, int cy, int x0, int y0, int a0, int x1, int y1, int a1, boolean fAllWalls) {
        int y;
        int x;
        int i;
        XSECTOR pXSector = DB.xsector[Engine.sector[nSector].extra];
        int vX = x1 - x0;
        int vY = y1 - y0;
        int vA = a1 - a0;
        int Xi0 = x0 + Pragmas.mulscale(i0, vX, 16);
        int Xi1 = x0 + Pragmas.mulscale(i1, vX, 16);
        int dX = Xi1 - Xi0;
        int Yi0 = y0 + Pragmas.mulscale(i0, vY, 16);
        int Yi1 = y0 + Pragmas.mulscale(i1, vY, 16);
        int dY = Yi1 - Yi0;
        int Ai0 = a0 + Pragmas.mulscale(i0, vA, 16);
        int Ai1 = a0 + Pragmas.mulscale(i1, vA, 16);
        int dA = Ai1 - Ai0;
        short nWall = Engine.sector[nSector].wallptr;
        if (fAllWalls) {
            for (i = 0; i < Engine.sector[nSector].wallnum; ++i) {
                x = (int)Trigger.kwall[nWall].x;
                y = (int)Trigger.kwall[nWall].y;
                if (Ai1 != 0) {
                    Engine.Point out = Gameutils.RotatePoint(x, y, Ai1, cx, cy);
                    x = out.getX();
                    y = out.getY();
                }
                Main.engine.dragpoint(nWall, x + Xi1 - cx, y + Yi1 - cy);
                nWall = (short)(nWall + 1);
            }
        } else {
            for (i = 0; i < Engine.sector[nSector].wallnum; ++i) {
                Engine.Point out;
                short nWall2 = Engine.wall[nWall].point2;
                x = (int)Trigger.kwall[nWall].x;
                y = (int)Trigger.kwall[nWall].y;
                if ((Engine.wall[nWall].cstat & 0x4000) != 0) {
                    if (Ai1 != 0) {
                        out = Gameutils.RotatePoint(x, y, Ai1, cx, cy);
                        x = out.getX();
                        y = out.getY();
                    }
                    Main.engine.dragpoint(nWall, x + Xi1 - cx, y + Yi1 - cy);
                    if ((Engine.wall[nWall2].cstat & 0xC000) == 0) {
                        x = (int)Trigger.kwall[nWall2].x;
                        y = (int)Trigger.kwall[nWall2].y;
                        if (Ai1 != 0) {
                            out = Gameutils.RotatePoint(x, y, Ai1, cx, cy);
                            x = out.getX();
                            y = out.getY();
                        }
                        Main.engine.dragpoint(nWall2, x + Xi1 - cx, y + Yi1 - cy);
                    }
                } else if ((Engine.wall[nWall].cstat & 0x8000) != 0) {
                    if (Ai1 != 0) {
                        out = Gameutils.RotatePoint(x, y, -Ai1, cx, cy);
                        x = out.getX();
                        y = out.getY();
                    }
                    Main.engine.dragpoint(nWall, x - (Xi1 - cx), y - (Yi1 - cy));
                    if ((Engine.wall[nWall2].cstat & 0xC000) == 0) {
                        x = (int)Trigger.kwall[nWall2].x;
                        y = (int)Trigger.kwall[nWall2].y;
                        if (Ai1 != 0) {
                            out = Gameutils.RotatePoint(x, y, -Ai1, cx, cy);
                            x = out.getX();
                            y = out.getY();
                        }
                        Main.engine.dragpoint(nWall2, x - (Xi1 - cx), y - (Yi1 - cy));
                    }
                }
                nWall = (short)(nWall + 1);
            }
        }
        short nSprite = Engine.headspritesect[nSector];
        while (nSprite >= 0) {
            SPRITE pSprite = Engine.sprite[nSprite];
            if (pSprite.statnum != 10 && pSprite.statnum != 16 || pSprite.hitag == 1) {
                x = (int)Trigger.ksprite[nSprite].x;
                y = (int)Trigger.ksprite[nSprite].y;
                if ((Engine.sprite[nSprite].cstat & 0x2000) != 0) {
                    if (Ai1 != 0) {
                        Engine.Point out = Gameutils.RotatePoint(x, y, Ai1, cx, cy);
                        x = out.getX();
                        y = out.getY();
                    }
                    View.viewBackupSpriteLoc(nSprite, pSprite);
                    pSprite.ang = (short)(pSprite.ang + dA & 0x7FF);
                    if (Gameutils.IsPlayerSprite(pSprite)) {
                        PLAYER pPlayer = Globals.gPlayer[pSprite.lotag - 231];
                        pPlayer.ang = ru.m210projects.Build.Gameutils.BClampAngle(pPlayer.ang + (float)dA);
                    }
                    pSprite.x = x + Xi1 - cx;
                    pSprite.y = y + Yi1 - cy;
                } else if ((Engine.sprite[nSprite].cstat & 0x4000) != 0) {
                    if (Ai1 != 0) {
                        Engine.Point out = Gameutils.RotatePoint(x, y, -Ai1, cx, cy);
                        x = out.getX();
                        y = out.getY();
                    }
                    View.viewBackupSpriteLoc(nSprite, pSprite);
                    pSprite.ang = (short)(pSprite.ang - dA & 0x7FF);
                    if (Gameutils.IsPlayerSprite(pSprite)) {
                        PLAYER pPlayer = Globals.gPlayer[pSprite.lotag - 231];
                        pPlayer.ang = ru.m210projects.Build.Gameutils.BClampAngle(pPlayer.ang + (float)dA);
                    }
                    pSprite.x = x - (Xi1 - cx);
                    pSprite.y = y - (Yi1 - cy);
                } else if (pXSector.Drag) {
                    Gameutils.GetSpriteExtents(pSprite);
                    int z = Main.engine.getflorzofslope((short)nSector, pSprite.x, pSprite.y);
                    if ((pSprite.cstat & 0x30) == 0 && Gameutils.extents_zBot >= z) {
                        if (dA != 0) {
                            Engine.Point out = Gameutils.RotatePoint(pSprite.x, pSprite.y, dA, Xi0, Yi0);
                            pSprite.x = out.getX();
                            pSprite.y = out.getY();
                        }
                        View.viewBackupSpriteLoc(nSprite, pSprite);
                        pSprite.ang = (short)(pSprite.ang + dA & 0x7FF);
                        if (Gameutils.IsPlayerSprite(pSprite)) {
                            PLAYER pPlayer = Globals.gPlayer[pSprite.lotag - 231];
                            pPlayer.ang = ru.m210projects.Build.Gameutils.BClampAngle(pPlayer.ang + (float)dA);
                        }
                        pSprite.x += dX;
                        pSprite.y += dY;
                    }
                }
            }
            nSprite = Engine.nextspritesect[nSprite];
        }
    }

    public static void zMotion(int nSector, XSECTOR pXSector, int busy, int opt) {
        int ceilZRange;
        SECTOR pSector = Engine.sector[nSector];
        View.viewBackupSectorLoc(nSector, pSector);
        int floorZRange = pXSector.onFloorZ - pXSector.offFloorZ;
        if (floorZRange != 0) {
            int oldFloorZ = pSector.floorz;
            Trigger.secFloorZ[nSector] = pSector.floorz = Pragmas.mulscale(floorZRange, Trigger.Lin2Sin(busy, opt), 16) + pXSector.offFloorZ;
            int n = nSector;
            Actor.floorVel[n] = Actor.floorVel[n] + (long)(pSector.floorz - oldFloorZ << 8);
            short nSprite = Engine.headspritesect[nSector];
            while (nSprite >= 0) {
                SPRITE pSprite = Engine.sprite[nSprite];
                Gameutils.GetSpriteExtents(pSprite);
                if ((pSprite.cstat & 0x2000) != 0) {
                    View.viewBackupSpriteLoc(nSprite, pSprite);
                    pSprite.z += pSector.floorz - oldFloorZ;
                } else if ((pSprite.hitag & 2) != 0) {
                    pSprite.hitag = (short)(pSprite.hitag | 4);
                } else if (oldFloorZ <= Gameutils.extents_zBot && (pSprite.cstat & 0x30) == 0) {
                    View.viewBackupSpriteLoc(nSprite, pSprite);
                    pSprite.z += pSector.floorz - oldFloorZ;
                }
                nSprite = Engine.nextspritesect[nSprite];
            }
        }
        if ((ceilZRange = pXSector.onCeilZ - pXSector.offCeilZ) != 0) {
            int oldCeilZ = pSector.ceilingz;
            Trigger.secCeilZ[nSector] = pSector.ceilingz = Pragmas.mulscale(ceilZRange, Trigger.Lin2Sin(busy, opt), 16) + pXSector.offCeilZ;
            int n = nSector;
            Actor.ceilingVel[n] = Actor.ceilingVel[n] + (long)(pSector.ceilingz - oldCeilZ << 8);
            short nSprite = Engine.headspritesect[nSector];
            while (nSprite >= 0) {
                SPRITE pSprite = Engine.sprite[nSprite];
                Gameutils.GetSpriteExtents(pSprite);
                if ((pSprite.cstat & 0x4000) != 0) {
                    View.viewBackupSpriteLoc(nSprite, pSprite);
                    pSprite.z += pSector.ceilingz - oldCeilZ;
                }
                nSprite = Engine.nextspritesect[nSprite];
            }
        }
    }

    public static int GetHighestSprite(int nSector, int nStatus) {
        getHighestZ = Engine.sector[nSector].floorz;
        int retSprite = -1;
        int nSprite = Engine.headspritesect[nSector];
        while (nSprite >= 0) {
            if (Engine.sprite[nSprite].statnum == nStatus || nStatus == 1024) {
                SPRITE pSprite = Engine.sprite[nSprite];
                Gameutils.GetSpriteExtents(pSprite);
                if (pSprite.z - Gameutils.extents_zTop < getHighestZ) {
                    getHighestZ = pSprite.z - Gameutils.extents_zTop;
                    retSprite = nSprite;
                }
            }
            nSprite = Engine.nextspritesect[nSprite];
        }
        return retSprite;
    }

    public static int GetSpriteRange(int nSector) {
        if (nSector < 0 || nSector >= Engine.numsectors) {
            Main.game.dassert("nSector >= 0 && nSector < numsectors");
        }
        int retSprite = -1;
        int ceilingz = Engine.sector[nSector].ceilingz;
        int nSprite = Engine.headspritesect[nSector];
        while (nSprite >= 0) {
            SPRITE pSprite = Engine.sprite[nSprite];
            if (pSprite.statnum == 4 || pSprite.statnum == 6) {
                Gameutils.GetSpriteExtents(pSprite);
                if (ceilingz > Gameutils.extents_zTop) {
                    ceilingz = Gameutils.extents_zTop;
                    getRangepzTop = Gameutils.extents_zTop;
                    getRangepzBot = Gameutils.extents_zBot;
                    retSprite = nSprite;
                }
            }
            nSprite = Engine.nextspritesect[nSprite];
        }
        return retSprite;
    }

    public static int VCrushBusy(int nSector, int nBusy) {
        System.out.println("crush");
        return 0;
    }

    public static int VSpriteBusy(int nSector, int nBusy) {
        int ceilZRange;
        if (nSector < 0 || nSector >= Engine.numsectors) {
            Main.game.dassert("nSector >= 0 && nSector < numsectors");
        }
        SECTOR pSector = Engine.sector[nSector];
        short nXSector = pSector.extra;
        if (nXSector <= 0 || nXSector >= 512) {
            Main.game.dassert("nXSector > 0 && nXSector < kMaxXSectors");
        }
        XSECTOR pXSector = DB.xsector[nXSector];
        int opt = Trigger.getWave(pXSector, nBusy);
        int floorZRange = pXSector.onFloorZ - pXSector.offFloorZ;
        if (floorZRange != 0) {
            short nSprite = Engine.headspritesect[nSector];
            while (nSprite >= 0) {
                SPRITE pSprite = Engine.sprite[nSprite];
                if ((pSprite.cstat & 0x2000) != 0) {
                    View.viewBackupSpriteLoc(nSprite, pSprite);
                    pSprite.z = (int)(Trigger.ksprite[nSprite].z + (float)Pragmas.mulscale(floorZRange, Trigger.Lin2Sin(nBusy, opt), 16));
                }
                nSprite = Engine.nextspritesect[nSprite];
            }
        }
        if ((ceilZRange = pXSector.onCeilZ - pXSector.offCeilZ) != 0) {
            short nSprite = Engine.headspritesect[nSector];
            while (nSprite >= 0) {
                SPRITE pSprite = Engine.sprite[nSprite];
                if ((pSprite.cstat & 0x4000) != 0) {
                    View.viewBackupSpriteLoc(nSprite, pSprite);
                    pSprite.z = (int)(Trigger.ksprite[nSprite].z + (float)Pragmas.mulscale(ceilZRange, Trigger.Lin2Sin(nBusy, opt), 16));
                }
                nSprite = Engine.nextspritesect[nSprite];
            }
        }
        pXSector.busy = nBusy;
        if (pXSector.command == 5 && pXSector.txID != 0) {
            EVENT.evSend(nSector, 6, pXSector.txID, 5);
        }
        if ((nBusy & 0xFFFF) == 0) {
            Trigger.SetSectorState(nSector, pXSector, nBusy >> 16);
            Trigger.sfxSectorStop(nSector, nBusy >> 16);
            return 3;
        }
        return 0;
    }

    public static int VDoorBusy(int nSector, int nBusy) {
        if (nSector < 0 || nSector >= Engine.numsectors) {
            Main.game.dassert("nSector >= 0 && nSector < numsectors");
        }
        SECTOR pSector = Engine.sector[nSector];
        short nXSector = pSector.extra;
        if (nXSector <= 0 || nXSector >= 512) {
            Main.game.dassert("nXSector > 0 && nXSector < kMaxXSectors");
        }
        XSECTOR pXSector = DB.xsector[nXSector];
        int nDelta = pXSector.state != 0 ? 65536 / Gameutils.ClipLow(pXSector.busyTime[1] * 120 / 10, 1) : -65536 / Gameutils.ClipLow(pXSector.busyTime[0] * 120 / 10, 1);
        int nSprite = Trigger.GetSpriteRange(nSector);
        if (nSprite >= 0) {
            SPRITE pSprite = Engine.sprite[nSprite];
            if (pSprite.extra <= 0 || pSprite.extra >= 2048) {
                Main.game.dassert("VDoorBusy pSprite.extra > 0 && pSprite.extra < kMaxXSprites");
            }
            XSPRITE pXSprite = DB.xsprite[pSprite.extra];
            if (nBusy < pXSector.busy) {
                if (pXSector.offCeilZ > pXSector.onCeilZ || pXSector.offFloorZ < pXSector.onFloorZ) {
                    if (pXSector.interruptable) {
                        if (pXSector.Crush) {
                            if (pXSprite.health == 0) {
                                return 2;
                            }
                            Actor.actDamageSprite(nSprite, pSprite, 0, pXSector.data != 0 ? pXSector.data << 4 : 8000);
                        }
                        nBusy = Gameutils.ClipRange(nBusy + Globals.kFrameTicks * (nDelta / 2), 0, 65536);
                    } else if (pXSector.Crush && pXSprite.health > 0) {
                        Actor.actDamageSprite(nSprite, pSprite, 0, pXSector.data != 0 ? pXSector.data << 4 : 8000);
                        nBusy = Gameutils.ClipRange(nBusy + Globals.kFrameTicks * (nDelta / 2), 0, 65536);
                    }
                }
            } else if (nBusy > pXSector.busy && (pXSector.onCeilZ > pXSector.offCeilZ || pXSector.onFloorZ < pXSector.offFloorZ)) {
                if (pXSector.interruptable) {
                    if (pXSector.Crush) {
                        if (pXSprite.health == 0) {
                            return 2;
                        }
                        Actor.actDamageSprite(nSprite, pSprite, 0, pXSector.data != 0 ? pXSector.data << 4 : 8000);
                    }
                    nBusy = Gameutils.ClipRange(nBusy - Globals.kFrameTicks * (nDelta / 2), 0, 65536);
                } else if (pXSector.Crush && pXSprite.health > 0) {
                    Actor.actDamageSprite(nSprite, pSprite, 0, pXSector.data != 0 ? pXSector.data << 4 : 8000);
                    nBusy = Gameutils.ClipRange(nBusy - Globals.kFrameTicks * (nDelta / 2), 0, 65536);
                }
            }
        }
        Trigger.zMotion(nSector, pXSector, nBusy, Trigger.getWave(pXSector, nBusy));
        pXSector.busy = nBusy;
        if (pXSector.command == 5 && pXSector.txID != 0) {
            EVENT.evSend(nSector, 6, pXSector.txID, 5);
        }
        if ((nBusy & 0xFFFF) == 0) {
            Trigger.SetSectorState(nSector, pXSector, nBusy >> 16);
            Trigger.sfxSectorStop(nSector, nBusy >> 16);
            return 3;
        }
        return 0;
    }

    public static int HDoorBusy(int nSector, int nBusy) {
        if (nSector < 0 || nSector >= Engine.numsectors) {
            Main.game.dassert("nSector >= 0 && nSector < numsectors");
        }
        SECTOR pSector = Engine.sector[nSector];
        short nXSector = pSector.extra;
        if (nXSector <= 0 || nXSector >= 512) {
            Main.game.dassert("nXSector > 0 && nXSector < kMaxXSectors");
        }
        XSECTOR pXSector = DB.xsector[nXSector];
        int opt = Trigger.getWave(pXSector, nBusy);
        SPRITE pMark0 = Engine.sprite[pXSector.marker0];
        SPRITE pMark1 = Engine.sprite[pXSector.marker1];
        Trigger.TranslateSector(nSector, Trigger.Lin2Sin(pXSector.busy, opt), Trigger.Lin2Sin(nBusy, opt), pMark0.x, pMark0.y, pMark0.x, pMark0.y, pMark0.ang, pMark1.x, pMark1.y, pMark1.ang, pSector.lotag == 616);
        Trigger.zMotion(nSector, pXSector, nBusy, opt);
        pXSector.busy = nBusy;
        if (pXSector.command == 5 && pXSector.txID != 0) {
            EVENT.evSend(nSector, 6, pXSector.txID, 5);
        }
        if ((nBusy & 0xFFFF) == 0) {
            Trigger.SetSectorState(nSector, pXSector, nBusy >> 16);
            Trigger.sfxSectorStop(nSector, nBusy >> 16);
            return 3;
        }
        return 0;
    }

    public static int RDoorBusy(int nSector, int nBusy) {
        if (nSector < 0 || nSector >= Engine.numsectors) {
            Main.game.dassert("nSector >= 0 && nSector < numsectors");
        }
        SECTOR pSector = Engine.sector[nSector];
        short nXSector = pSector.extra;
        if (nXSector <= 0 || nXSector >= 512) {
            Main.game.dassert("nXSector > 0 && nXSector < kMaxXSectors");
        }
        XSECTOR pXSector = DB.xsector[nXSector];
        int opt = Trigger.getWave(pXSector, nBusy);
        SPRITE pMark = Engine.sprite[pXSector.marker0];
        Trigger.TranslateSector(nSector, Trigger.Lin2Sin(pXSector.busy, opt), Trigger.Lin2Sin(nBusy, opt), pMark.x, pMark.y, pMark.x, pMark.y, 0, pMark.x, pMark.y, pMark.ang, pSector.lotag == 617);
        Trigger.zMotion(nSector, pXSector, nBusy, opt);
        pXSector.busy = nBusy;
        if (pXSector.command == 5 && pXSector.txID != 0) {
            EVENT.evSend(nSector, 6, pXSector.txID, 5);
        }
        if ((nBusy & 0xFFFF) == 0) {
            Trigger.SetSectorState(nSector, pXSector, nBusy >> 16);
            Trigger.sfxSectorStop(nSector, nBusy >> 16);
            return 3;
        }
        return 0;
    }

    public static int SRDoorBusy(int nSector, int nBusy) {
        int data;
        int a1;
        int a0;
        if (nSector < 0 || nSector >= Engine.numsectors) {
            Main.game.dassert("nSector >= 0 && nSector < numsectors");
        }
        SECTOR pSector = Engine.sector[nSector];
        short nXSector = pSector.extra;
        if (nXSector <= 0 || nXSector >= 512) {
            Main.game.dassert("nXSector > 0 && nXSector < kMaxXSectors");
        }
        XSECTOR pXSector = DB.xsector[nXSector];
        SPRITE pMark = Engine.sprite[pXSector.marker0];
        int opt = Trigger.getWave(pXSector, nBusy);
        if (pXSector.busy >= nBusy) {
            a0 = pXSector.data - pMark.ang;
            a1 = pXSector.data;
            data = pXSector.data - pMark.ang;
        } else {
            a0 = pXSector.data;
            a1 = pXSector.data + pMark.ang;
            data = pXSector.data + pMark.ang;
        }
        Trigger.TranslateSector(nSector, Trigger.Lin2Sin(pXSector.busy, opt), Trigger.Lin2Sin(nBusy, opt), pMark.x, pMark.y, pMark.x, pMark.y, a0, pMark.x, pMark.y, a1, true);
        pXSector.busy = nBusy;
        if (pXSector.command == 5 && pXSector.txID != 0) {
            EVENT.evSend(nSector, 6, pXSector.txID, 5);
        }
        if ((nBusy & 0xFFFF) == 0) {
            Trigger.SetSectorState(nSector, pXSector, nBusy >> 16);
            pXSector.data = data;
            Trigger.sfxSectorStop(nSector, nBusy >> 16);
            return 3;
        }
        return 0;
    }

    public static int PathSectorBusy(int nSector, int nBusy) {
        if (nSector < 0 || nSector >= Engine.numsectors) {
            Main.game.dassert("nSector >= 0 && nSector < numsectors");
        }
        SECTOR pSector = Engine.sector[nSector];
        short nXSector = pSector.extra;
        if (nXSector <= 0 || nXSector >= 512) {
            Main.game.dassert("nXSector > 0 && nXSector < kMaxXSectors");
        }
        XSECTOR pXSector = DB.xsector[nXSector];
        SPRITE pMarker0 = Engine.sprite[pXSector.marker0];
        XSPRITE pXMarker0 = DB.xsprite[pMarker0.extra];
        SPRITE pMarker1 = Engine.sprite[pXSector.marker1];
        XSPRITE pXMarker1 = DB.xsprite[pMarker1.extra];
        SPRITE pPivot = Engine.sprite[secPath[nSector]];
        Trigger.TranslateSector(nSector, Trigger.Lin2Sin(pXSector.busy, pXMarker0.wave), Trigger.Lin2Sin(nBusy, pXMarker0.wave), pPivot.x, pPivot.y, pMarker0.x, pMarker0.y, pMarker0.ang, pMarker1.x, pMarker1.y, pMarker1.ang, true);
        Trigger.zMotion(nSector, pXSector, nBusy, pXMarker0.wave);
        pXSector.busy = nBusy;
        if ((nBusy & 0xFFFF) == 0) {
            EVENT.evPost(nSector, 6, pXMarker1.waitTime * 120 / 10, 1);
            pXSector.busy = 0;
            pXSector.state = 0;
            if (pXMarker0.data4 != 0) {
                Trigger.sfxSectorBusy(nSector, pXMarker0.data4, pXSector.busy);
            }
            pXSector.marker0 = pXSector.marker1;
            pXSector.data = pXMarker1.data1;
            return 3;
        }
        return 0;
    }

    public static void OperateDoor(int nSector, XSECTOR pXSector, int evCommand, int busyProc) {
        switch (evCommand) {
            case 0: {
                if (pXSector.busy == 0) break;
                int nDelta = -65536 / Gameutils.ClipLow(pXSector.busyTime[0] * 120 / 10, 1);
                Trigger.AddBusy(nSector, busyProc, nDelta);
                Trigger.sfxSectorBusy(nSector, 1);
                break;
            }
            case 1: {
                if (pXSector.busy == 65536) break;
                int nDelta = 65536 / Gameutils.ClipLow(pXSector.busyTime[1] * 120 / 10, 1);
                Trigger.AddBusy(nSector, busyProc, nDelta);
                Trigger.sfxSectorBusy(nSector, 0);
                break;
            }
            default: {
                if ((pXSector.busy & 0xFFFF) != 0) {
                    if (!pXSector.interruptable) break;
                    Trigger.ReverseBusy(nSector, busyProc);
                    pXSector.state = (short)(pXSector.state == 0 ? 1 : 0);
                    break;
                }
                int nDelta = pXSector.state == 0 ? 65536 / Gameutils.ClipLow(pXSector.busyTime[1] * 120 / 10, 1) : -65536 / Gameutils.ClipLow(pXSector.busyTime[0] * 120 / 10, 1);
                Trigger.AddBusy(nSector, busyProc, nDelta);
                Trigger.sfxSectorBusy(nSector, pXSector.state);
            }
        }
    }

    public static boolean TeleportDudes(int sectnum) {
        short i = Engine.headspritesect[sectnum];
        while (i >= 0) {
            if (Engine.sprite[i].statnum == 6) {
                return true;
            }
            i = Engine.nextspritesect[i];
        }
        return false;
    }

    public static void TeleportDamage(int nSource, int nSector) {
        short i = Engine.headspritesect[nSector];
        while (i >= 0) {
            SPRITE pSprite = Engine.sprite[i];
            if (pSprite.statnum == 6) {
                Actor.actDamageSprite(nSource, pSprite, 3, 4000);
            } else if (pSprite.statnum == 4) {
                Actor.actDamageSprite(nSource, pSprite, 3, 8000);
            }
            i = Engine.nextspritesect[i];
        }
    }

    public static void OperateTeleport(int nSector, XSECTOR pXSector) {
        int nDest;
        if (nSector >= Engine.numsectors) {
            Main.game.dassert("nSector < numsectors " + nSector + " < " + Engine.numsectors);
        }
        if ((nDest = pXSector.marker0) >= Globals.kMaxSprites) {
            Main.game.dassert("nDest < kMaxSprites");
        }
        SPRITE pDest = Engine.sprite[nDest];
        if (pDest.statnum != 10) {
            Main.game.dassert("pDest.statnum != kStatMarker");
        }
        if (pDest.lotag != 8) {
            Main.game.dassert("pDest.type != kMarkerWarpDest");
        }
        if (pDest.sectnum < 0 || pDest.sectnum >= Globals.kMaxSectors) {
            Main.game.dassert("pDest.sectnum >= 0 && pDest.sectnum < kMaxSectors");
        }
        short i = Engine.headspritesect[nSector];
        while (i >= 0) {
            SPRITE pSprite = Engine.sprite[i];
            if (pSprite.statnum == 6) {
                PLAYER pPlayer = null;
                if (Gameutils.IsPlayerSprite(pSprite)) {
                    pPlayer = Globals.gPlayer[pSprite.lotag - 231];
                }
                if (pPlayer != null || !Trigger.TeleportDudes(pDest.sectnum)) {
                    Trigger.TeleportDamage(pXSector.data, pDest.sectnum);
                    pSprite.x = pDest.x;
                    pSprite.y = pDest.y;
                    pSprite.z += Engine.sector[pDest.sectnum].floorz - Engine.sector[nSector].floorz;
                    pSprite.ang = pDest.ang;
                    DB.changespritesect(i, pDest.sectnum);
                    SOUND.sfxStart3DSound(pDest, 201, -1, 0);
                    Actor.sprXVel[i] = 0L;
                    Actor.sprYVel[i] = 0L;
                    Actor.sprZVel[i] = 0L;
                    View.viewBackupSpriteLoc(i, pSprite);
                    if (pPlayer != null) {
                        View.viewUpdatePlayerLoc(pPlayer);
                        Globals.gPlayer[pPlayer.nPlayer].viewOffdZ = 0;
                        Globals.gPlayer[pPlayer.nPlayer].weapOffdZ = 0;
                        Globals.gPlayer[pPlayer.nPlayer].ang = pSprite.ang;
                    }
                }
            }
            i = Engine.nextspritesect[i];
        }
    }

    public static void OperatePath(int nSector, XSECTOR pXSector, int evCommand) {
        if (nSector >= Engine.numsectors) {
            Main.game.dassert("nSector < numsectors");
        }
        if (pXSector.marker0 == -1) {
            return;
        }
        SPRITE pMarker = Engine.sprite[pXSector.marker0];
        XSPRITE pXMarker = DB.xsprite[pMarker.extra];
        int nMarker2 = -1;
        nMarker2 = Engine.headspritestat[16];
        while (nMarker2 >= 0) {
            SPRITE pMarker2 = Engine.sprite[nMarker2];
            if (pMarker2.lotag == 15 && DB.xsprite[pMarker2.extra].data1 == pXMarker.data2) break;
            nMarker2 = Engine.nextspritestat[nMarker2];
        }
        if (nMarker2 == -1) {
            System.err.println("Unable to find path marker with id " + pXMarker.data2);
            return;
        }
        if (pXMarker.state != 1) {
            Trigger.trTriggerSprite(pMarker.xvel, pXMarker, 1);
        }
        pXSector.marker1 = nMarker2;
        pXSector.onFloorZ = Engine.sprite[nMarker2].z;
        pXSector.offFloorZ = pMarker.z;
        if (evCommand == 1) {
            pXSector.busy = 0;
            pXSector.state = 0;
            int nDelta = 65536 / Gameutils.ClipLow(pXMarker.busyTime * 120 / 10, 1);
            Trigger.AddBusy(nSector, 7, nDelta);
            if (pXMarker.data3 != 0) {
                Trigger.sfxSectorBusy(nSector, pXMarker.data3, 0);
            }
        }
    }

    public static void OperateSector(int nSector, XSECTOR pXSector, int evCommand) {
        SECTOR pSector = Engine.sector[nSector];
        block0 : switch (evCommand) {
            case 6: {
                pXSector.locked = 1;
                break;
            }
            case 7: {
                pXSector.locked = 0;
                if (pSector.lotag != 619) break;
                pXSector.state = 0;
                EVENT.evPostCallback(nSector, 6, 0L, 12);
                break;
            }
            case 8: {
                pXSector.locked ^= 1;
                if (pSector.lotag != 619 || pXSector.locked == 1) break;
                pXSector.state = 0;
                EVENT.evPostCallback(nSector, 6, 0L, 12);
                break;
            }
            case 9: {
                pXSector.stopFlag[0] = true;
                break;
            }
            case 10: {
                pXSector.stopFlag[1] = true;
                break;
            }
            case 11: {
                pXSector.stopFlag[0] = true;
                pXSector.stopFlag[1] = true;
                break;
            }
            default: {
                switch (pSector.lotag) {
                    case 602: {
                        Trigger.OperateDoor(nSector, pXSector, evCommand, 1);
                        break block0;
                    }
                    case 600: {
                        Trigger.OperateDoor(nSector, pXSector, evCommand, 2);
                        break block0;
                    }
                    case 614: 
                    case 616: {
                        Trigger.OperateDoor(nSector, pXSector, evCommand, 3);
                        break block0;
                    }
                    case 615: 
                    case 617: {
                        Trigger.OperateDoor(nSector, pXSector, evCommand, 4);
                        break block0;
                    }
                    case 613: {
                        int nDelta;
                        if (evCommand == 1) {
                            pXSector.busy = 0;
                            pXSector.state = 0;
                            nDelta = 65536 / Gameutils.ClipLow(pXSector.busyTime[1] * 120 / 10, 1);
                            Trigger.AddBusy(nSector, 5, nDelta);
                            Trigger.sfxSectorBusy(nSector, 0);
                        }
                        if (evCommand != 0) break block0;
                        pXSector.busy = 65536;
                        pXSector.state = 1;
                        nDelta = -65536 / Gameutils.ClipLow(pXSector.busyTime[0] * 120 / 10, 1);
                        Trigger.AddBusy(nSector, 5, nDelta);
                        Trigger.sfxSectorBusy(nSector, 0);
                        break block0;
                    }
                    case 604: {
                        Trigger.OperateTeleport(nSector, pXSector);
                        break block0;
                    }
                    case 612: {
                        Trigger.OperatePath(nSector, pXSector, evCommand);
                        break block0;
                    }
                    default: {
                        if (pXSector.busyTime[0] != 0 || pXSector.busyTime[1] != 0) {
                            Trigger.OperateDoor(nSector, pXSector, evCommand, 6);
                            break block0;
                        }
                        if (evCommand == 0) {
                            Trigger.SetSectorState(nSector, pXSector, 0);
                            break block0;
                        }
                        if (evCommand == 1) {
                            Trigger.SetSectorState(nSector, pXSector, 1);
                            break block0;
                        }
                        Trigger.SetSectorState(nSector, pXSector, pXSector.state ^ 1);
                    }
                }
            }
        }
    }

    public static void PathSectorInit(int nSector, XSECTOR pXSector) {
        if (nSector < 0 || nSector >= Engine.numsectors) {
            Main.game.dassert("nSector >= 0 && nSector < numsectors");
        }
        int nMarker2 = -1;
        nMarker2 = Engine.headspritestat[16];
        while (nMarker2 >= 0) {
            SPRITE pSprite = Engine.sprite[nMarker2];
            if (pSprite.lotag == 15 && DB.xsprite[pSprite.extra].data1 == pXSector.data) break;
            nMarker2 = Engine.nextspritestat[nMarker2];
        }
        pXSector.marker0 = nMarker2;
        Trigger.secPath[nSector] = nMarker2;
        if (pXSector.state != 0) {
            EVENT.evPost(nSector, 6, 0L, 1);
        }
    }

    public static void LinkSector(int nSector, XSECTOR pXSector, int event) {
        SECTOR pSector = Engine.sector[nSector];
        int nBusy = Trigger.GetSourceBusy(event);
        switch (pSector.lotag) {
            case 602: {
                Trigger.VSpriteBusy(nSector, nBusy);
                break;
            }
            case 600: {
                Trigger.VDoorBusy(nSector, nBusy);
                break;
            }
            case 614: 
            case 616: {
                Trigger.HDoorBusy(nSector, nBusy);
                break;
            }
            case 615: 
            case 617: {
                Trigger.RDoorBusy(nSector, nBusy);
                break;
            }
            case 619: {
                short nXIndex = Engine.sector[EVENT.getIndex((int)event)].extra;
                if (nXIndex <= 0 || nXIndex >= 512) {
                    Main.game.dassert("nXIndex > 0 && nXIndex < kMaxXSectors");
                }
                pXSector.waitTime[1] = DB.xsector[nXIndex].waitTime[1];
                pXSector.data = DB.xsector[nXIndex].data;
                break;
            }
            default: {
                pXSector.busy = nBusy;
                if ((nBusy & 0xFFFF) != 0) break;
                Trigger.SetSectorState(nSector, pXSector, nBusy >> 16);
            }
        }
    }

    public static void LinkSprite(int nSprite, XSPRITE pXSprite, int event) {
        SPRITE pSprite = Engine.sprite[nSprite];
        int nBusy = Trigger.GetSourceBusy(event);
        switch (pSprite.lotag) {
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                if (EVENT.getType(event) != 3) break;
                SPRITE pSprite2 = Engine.sprite[EVENT.getIndex(event)];
                if (pSprite2.extra < 0) break;
                XSPRITE pXSprite2 = DB.xsprite[pSprite2.extra];
                block5 : switch (pSprite.lotag) {
                    case 6: 
                    case 10: 
                    case 12: 
                    case 14: {
                        switch (pSprite2.lotag) {
                            case 6: 
                            case 10: 
                            case 12: 
                            case 14: {
                                break block5;
                            }
                        }
                        return;
                    }
                    case 7: 
                    case 9: 
                    case 11: 
                    case 13: {
                        switch (pSprite2.lotag) {
                            case 7: 
                            case 9: 
                            case 11: 
                            case 13: {
                                break block5;
                            }
                        }
                        return;
                    }
                }
                if (pXSprite.data2 < 5 && pXSprite2.data2 < 5) {
                    short tmp2 = pXSprite2.data2;
                    pXSprite2.data2 = pXSprite.data2;
                    pXSprite.data2 = tmp2;
                }
                short tmp3 = pSprite2.lotag;
                pSprite2.lotag = pSprite.lotag;
                pSprite.lotag = tmp3;
                SECTOR pSector = Engine.sector[pSprite.sectnum];
                SECTOR pSector2 = Engine.sector[pSprite2.sectnum];
                XSECTOR pXSector = null;
                XSECTOR pXSector2 = null;
                if (pSector.extra > 0) {
                    pXSector = DB.xsector[pSector.extra];
                }
                if (pSector2.extra > 0) {
                    pXSector2 = DB.xsector[pSector2.extra];
                }
                if (pXSector != null && pXSector2 != null) {
                    boolean tmp6 = pXSector.Underwater;
                    pXSector.Underwater = pXSector2.Underwater;
                    pXSector2.Underwater = tmp6;
                }
                if (pXSprite2.data3 == 1) {
                    short tmp4 = pSector.floorpicnum;
                    pSector.floorpicnum = pSector2.floorpicnum;
                    pSector2.floorpicnum = tmp4;
                }
                if (pXSprite2.data4 != 1) break;
                short tmp5 = pSector.ceilingpicnum;
                pSector.ceilingpicnum = pSector2.ceilingpicnum;
                pSector2.ceilingpicnum = tmp5;
                break;
            }
            case 15: {
                if (EVENT.getType(event) != 3) break;
                short nXSprite2 = Engine.sprite[EVENT.getIndex((int)event)].extra;
                pXSprite.data1 = DB.xsprite[nXSprite2].data1;
                pXSprite.data2 = DB.xsprite[nXSprite2].data2;
                pXSprite.data3 = DB.xsprite[nXSprite2].data3;
                pXSprite.busyTime = DB.xsprite[nXSprite2].busyTime;
                pXSprite.waitTime = DB.xsprite[nXSprite2].waitTime;
                break;
            }
            case 22: {
                if (EVENT.getType(event) != 3) break;
                short nXSprite2 = Engine.sprite[EVENT.getIndex((int)event)].extra;
                if (nXSprite2 <= 0 || nXSprite2 >= 2048) {
                    Main.game.dassert("nXSprite2 > 0 && nXSprite2 < kMaxXSprites");
                }
                pXSprite.data1 = DB.xsprite[nXSprite2].data1;
                if (pXSprite.data1 == pXSprite.data2) {
                    Trigger.SetSpriteState(nSprite, pXSprite, 1);
                    break;
                }
                Trigger.SetSpriteState(nSprite, pXSprite, 0);
                break;
            }
            default: {
                pXSprite.busy = nBusy;
                if ((nBusy & 0xFFFF) != 0) break;
                Trigger.SetSpriteState(nSprite, pXSprite, nBusy >> 16);
            }
        }
    }

    public static void LinkWall(int nWall, XWALL pXWall, int event) {
        WALL pWall = Engine.wall[nWall];
        int nBusy = Trigger.GetSourceBusy(event);
        switch (pWall.lotag) {
            default: 
        }
        pXWall.busy = nBusy;
        if ((nBusy & 0xFFFF) == 0) {
            Trigger.SetWallState(nWall, pXWall, nBusy >> 16);
        }
    }

    public static void trTriggerSector(int nSector, XSECTOR pXSector, int command) {
        if (pXSector.locked != 0) {
            return;
        }
        if (pXSector.isTriggered) {
            return;
        }
        if (pXSector.triggerOnce) {
            pXSector.isTriggered = true;
        }
        if (pXSector.decoupled) {
            if (pXSector.txID != 0) {
                EVENT.evSend(nSector, 6, pXSector.txID, pXSector.command);
            }
        } else {
            Trigger.OperateSector(nSector, pXSector, command);
        }
    }

    public static void pastePropertiesInObj(int type, int nDest, int event) {
        if (EVENT.getType(event) != 3) {
            return;
        }
        SPRITE pSource = Engine.sprite[EVENT.getIndex(event)];
        XSPRITE pXSource = DB.xsprite[pSource.extra];
        if (pSource.lotag == 8) {
            Trigger.useTeleportTarget(pXSource, Engine.sprite[nDest]);
            return;
        }
        if (pSource.lotag == 36) {
            if (DB.xsprite[Engine.sprite[nDest].extra].health > 0) {
                Trigger.useSpriteDamager(pXSource, Engine.sprite[nDest]);
            }
            return;
        }
        if (pSource.lotag == 38) {
            if (pXSource.data2 < 0 || pXSource.data2 >= 57) {
                return;
            }
            if (type == 3) {
                Trigger.useEffectGen(pXSource, Engine.sprite[nDest]);
            }
            return;
        }
        if (pSource.lotag == 27) {
            if (pXSource.data2 > 0 && !BuildGdx.cache.contains(pXSource.data2, "SEQ")) {
                return;
            }
            if (pXSource.data2 >= 0) {
                Trigger.useSeqSpawnerGen(pXSource, type, nDest);
            }
            return;
        }
        if (pSource.lotag == 39) {
            if (type != 6) {
                return;
            }
            Trigger.useSectorWindGen(pXSource, Engine.sector[nDest]);
            return;
        }
        if (pSource.lotag == 37) {
            long data = Trigger.getDataFieldOfObject(type, nDest, pXSource.data1);
            if (data == -65535L) {
                Main.game.ThrowError("Can't get data field #" + pXSource.data1 + " of object #" + nDest + ", type " + type + "!\n");
            }
            if (pXSource.data2 < pXSource.data3) {
                if (data < (long)pXSource.data2) {
                    data = pXSource.data2;
                }
                if (data > (long)pXSource.data3) {
                    data = pXSource.data3;
                }
                if ((data += (long)pXSource.data4) >= (long)pXSource.data3) {
                    switch (pSource.hitag) {
                        case 0: 
                        case 1: {
                            if (data <= (long)pXSource.data3) break;
                            data = pXSource.data3;
                            break;
                        }
                        case 2: {
                            if (data > (long)pXSource.data3) {
                                data = pXSource.data3;
                            }
                            if (!Trigger.goalValueIsReached(pXSource)) break;
                            short tmp = pXSource.data3;
                            pXSource.data3 = pXSource.data2;
                            pXSource.data2 = tmp;
                            break;
                        }
                        case 3: {
                            if (data <= (long)pXSource.data3) break;
                            data = pXSource.data2;
                        }
                    }
                }
            } else if (pXSource.data2 > pXSource.data3) {
                if (data > (long)pXSource.data2) {
                    data = pXSource.data2;
                }
                if (data < (long)pXSource.data3) {
                    data = pXSource.data3;
                }
                if ((data -= (long)pXSource.data4) <= (long)pXSource.data3) {
                    switch (pSource.hitag) {
                        case 0: 
                        case 1: {
                            if (data >= (long)pXSource.data3) break;
                            data = pXSource.data3;
                            break;
                        }
                        case 2: {
                            if (data < (long)pXSource.data3) {
                                data = pXSource.data3;
                            }
                            if (!Trigger.goalValueIsReached(pXSource)) break;
                            short tmp = pXSource.data3;
                            pXSource.data3 = pXSource.data2;
                            pXSource.data2 = tmp;
                            break;
                        }
                        case 3: {
                            if (data >= (long)pXSource.data3) break;
                            data = pXSource.data2;
                        }
                    }
                }
            }
            Trigger.setDataValueOfObject(type, nDest, pXSource.data1, (short)data);
            return;
        }
        if (pSource.lotag == 35) {
            switch (type) {
                case 6: {
                    if ((pSource.hitag & 1) == 0 && (pXSource.data1 == -1 || pXSource.data1 == Short.MAX_VALUE)) break;
                    DB.xsector[Engine.sector[nDest].extra].data = pXSource.data1;
                    break;
                }
                case 3: {
                    if ((pSource.hitag & 1) != 0 || pXSource.data1 != -1 && pXSource.data1 != Short.MAX_VALUE) {
                        DB.xsprite[Engine.sprite[nDest].extra].data1 = pXSource.data1;
                    }
                    if ((pSource.hitag & 1) != 0 || pXSource.data2 != -1 && pXSource.data2 != Short.MAX_VALUE) {
                        DB.xsprite[Engine.sprite[nDest].extra].data2 = pXSource.data2;
                    }
                    if ((pSource.hitag & 1) != 0 || pXSource.data3 != -1 && pXSource.data3 != Short.MAX_VALUE) {
                        DB.xsprite[Engine.sprite[nDest].extra].data3 = pXSource.data3;
                    }
                    if ((pSource.hitag & 1) == 0 && (pXSource.data4 == -1 || pXSource.data1 == 65535)) break;
                    DB.xsprite[Engine.sprite[nDest].extra].data4 = pXSource.data4;
                    break;
                }
                case 0: {
                    if ((pSource.hitag & 1) == 0 && (pXSource.data1 == -1 || pXSource.data1 == Short.MAX_VALUE)) break;
                    DB.xwall[Engine.wall[nDest].extra].data = pXSource.data1;
                }
            }
        } else if (pSource.lotag == 34) {
            if (type != 6) {
                return;
            }
            XSECTOR pXSector = DB.xsector[Engine.sector[nDest].extra];
            if (Trigger.valueIsBetween(pXSource.data1, -1, Short.MAX_VALUE)) {
                pXSector.wave = (short)(pXSource.data1 > 11 ? 11 : (int)pXSource.data1);
            }
            short oldAmplitude = pXSector.amplitude;
            if (pXSource.data2 >= 0) {
                pXSector.amplitude = (short)(pXSource.data2 > 127 ? 127 : (int)pXSource.data2);
            } else if (pXSource.data2 < -1) {
                pXSector.amplitude = (short)(pXSource.data2 < -127 ? -127 : (int)pXSource.data2);
            }
            if (Trigger.valueIsBetween(pXSource.data3, -1, Short.MAX_VALUE)) {
                pXSector.freq = (short)(pXSource.data3 > 255 ? 255 : (int)pXSource.data3);
            }
            if (Trigger.valueIsBetween(pXSource.data4, -1, 65535)) {
                pXSector.phase = (short)(pXSource.data4 > 255 ? 255 : (short)pXSource.data4);
            }
            if ((pSource.hitag & 1) != 0) {
                pXSector.shadeAlways = true;
            }
            if (oldAmplitude == 0 && pXSector.amplitude != 0) {
                int i = SECTORFX.shadeCount;
                while (i >= 0 && SECTORFX.shadeList[i] != Engine.sector[nDest].extra) {
                    if (i == 0) {
                        SECTORFX.shadeList[SECTORFX.shadeCount++] = Engine.sector[nDest].extra;
                    }
                    --i;
                }
            }
        } else if (pSource.lotag == 33) {
            SPRITE pPlayer;
            if (type != 3 || !Actor.IsDudeSprite(Engine.sprite[nDest]) || Engine.sprite[nDest].statnum != 6) {
                return;
            }
            SPRITE pSprite = Engine.sprite[nDest];
            XSPRITE pXSprite = DB.xsprite[pSprite.extra];
            SPRITE pTarget = null;
            XSPRITE pXTarget = null;
            int receiveHp = 33 + Gameutils.Random(33);
            DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
            int matesPerEnemy = 1;
            if (pXSprite.burnTime > 0 && pXSprite.burnSource >= 0 && pXSprite.burnSource < Globals.kMaxSprites) {
                if (!Actor.IsBurningDude(pSprite)) {
                    SPRITE pBurnSource = Engine.sprite[pXSprite.burnSource];
                    if (pBurnSource.extra >= 0) {
                        if (pXSource.data2 == 1 && Trigger.isMateOf(pXSprite, DB.xsprite[pBurnSource.extra])) {
                            pXSprite.burnTime = 0;
                            if (pXSprite.data4 > 0 && pXSprite.health < pXSprite.data4) {
                                Actor.actHealDude(pXSprite, receiveHp, pXSprite.data4);
                            } else if (pXSprite.health < pDudeInfo.startHealth) {
                                Actor.actHealDude(pXSprite, receiveHp, pDudeInfo.startHealth);
                            }
                        } else if (pBurnSource.xvel == pSprite.xvel || DB.xsprite[pBurnSource.extra].health <= 0) {
                            pXSprite.burnTime = 0;
                        }
                    }
                } else {
                    Actor.actKillSprite(pSource.xvel, pSprite, 0, 65535);
                    return;
                }
            }
            if ((pPlayer = Trigger.targetIsPlayer(pXSprite)) != null && pXSprite.aiState != Ai.genIdle) {
                if (pXSource.data4 == 3) {
                    Ai.aiSetTarget(pXSprite, pSprite.x, pSprite.y, pSprite.z);
                    Ai.aiNewState(pSprite, pXSprite, Ai.genIdle);
                    Ai.aiActive[pSprite.xvel] = 0;
                    if (pSprite.lotag == 254) {
                        AIUNICULT.removeLeech(AIUNICULT.leechIsDropped(pSprite));
                    }
                } else if (pXSource.data4 == 4) {
                    Ai.aiSetTarget(pXSprite, pPlayer.x, pPlayer.y, pPlayer.z);
                    if (pSprite.lotag == 254) {
                        AIUNICULT.removeLeech(AIUNICULT.leechIsDropped(pSprite));
                    }
                }
            }
            int maxAlarmDudes = 8 + Gameutils.Random(8);
            if (pXSprite.target > -1 && Engine.sprite[pXSprite.target].extra > -1 && pPlayer == null) {
                pTarget = Engine.sprite[pXSprite.target];
                pXTarget = DB.xsprite[pTarget.extra];
                if (Trigger.unitCanFly(pSprite) && Trigger.isMeleeUnit(pTarget) && !Trigger.unitCanFly(pTarget)) {
                    pSprite.hitag = (short)(pSprite.hitag | 2);
                } else if (Trigger.unitCanFly(pSprite)) {
                    pSprite.hitag = (short)(pSprite.hitag & 0xFFFFFFFD);
                }
                if (!Actor.IsDudeSprite(pTarget) || pXTarget.health < 1 || !Trigger.dudeCanSeeTarget(pXSprite, pDudeInfo, pTarget)) {
                    Ai.aiSetTarget(pXSprite, pSprite.x, pSprite.y, pSprite.z);
                } else if (pXSource.data1 != 666 && pXTarget.data1 != pXSource.data1) {
                    if (Trigger.affectedByTargetChg(pXTarget) != null) {
                        Ai.aiSetTarget(pXSprite, pSprite.x, pSprite.y, pSprite.z);
                        if (pXSprite.burnSource == pTarget.xvel) {
                            pXSprite.burnTime = 0;
                            pXSprite.burnSource = -1;
                        }
                        Ai.aiSetTarget(pXTarget, pTarget.x, pTarget.y, pTarget.z);
                        if (pXTarget.burnSource == pSprite.xvel) {
                            pXTarget.burnTime = 0;
                            pXTarget.burnSource = -1;
                        }
                    }
                } else if (Trigger.isAnnoyingUnit(pTarget) && !Trigger.isAnnoyingUnit(pSprite) && Main.engine.getTile(pSprite.picnum).getHeight() >= 60 && Trigger.getTargetDist(pSprite, pDudeInfo, pTarget) < 2) {
                    Actor.actKillSprite(pSource.xvel, pTarget, 0, 65535);
                    Ai.aiSetTarget(pXSprite, pSprite.x, pSprite.y, pSprite.z);
                } else if (pXSource.data2 == 1 && Trigger.isMateOf(pXSprite, pXTarget)) {
                    SPRITE pMate = pTarget;
                    XSPRITE pXMate = pXTarget;
                    if (pXSprite.data4 > 0 && pXSprite.health < pXSprite.data4) {
                        Actor.actHealDude(pXSprite, receiveHp, pXSprite.data4);
                    } else if (pXSprite.health < pDudeInfo.startHealth) {
                        Actor.actHealDude(pXSprite, receiveHp, pDudeInfo.startHealth);
                    }
                    if (pXMate.data4 > 0 && pXMate.health < pXMate.data4) {
                        Actor.actHealDude(pXMate, receiveHp, pXMate.data4);
                    } else {
                        DudeInfo pTDudeInfo = DudeInfo.dudeInfo[pMate.lotag - 200];
                        if (pXMate.health < pTDudeInfo.startHealth) {
                            Actor.actHealDude(pXMate, receiveHp, pTDudeInfo.startHealth);
                        }
                    }
                    if (pXMate.target > -1 && Engine.sprite[pXMate.target].extra >= 0) {
                        pTarget = Engine.sprite[pXMate.target];
                        if (pXMate.target == pSprite.xvel) {
                            Ai.aiSetTarget(pXMate, pMate.x, pMate.y, pMate.z);
                        } else {
                            if (!Trigger.isMateOf(pXSprite, DB.xsprite[pTarget.extra])) {
                                Ai.aiSetTarget(pXSprite, pTarget.xvel);
                                return;
                            }
                            Ai.aiSetTarget(pXMate, pMate.x, pMate.y, pMate.z);
                        }
                    }
                    if (pXSprite.target == pMate.xvel) {
                        Ai.aiSetTarget(pXSprite, pSprite.x, pSprite.y, pSprite.z);
                    }
                } else if (Trigger.targetIsPlayer(pXTarget) != null) {
                    Ai.aiSetTarget(pXTarget, pSprite.xvel);
                }
                int mDist = 3;
                if (Trigger.isMeleeUnit(pSprite)) {
                    mDist = 2;
                }
                if (pXSprite.target >= 0 && Trigger.getTargetDist(pSprite, pDudeInfo, Engine.sprite[pXSprite.target]) < mDist) {
                    if (!Trigger.isActive(pSprite.xvel)) {
                        Ai.aiActivateDude(pSprite, pXSprite);
                    }
                    return;
                }
                if ((Globals.gFrameClock & 0x100) != 0 && (pXSprite.target < 0 || Trigger.getTargetDist(pSprite, pDudeInfo, pTarget) >= mDist) && (pTarget = Trigger.getTargetInRange(pSprite, 0, mDist, pXSource.data1, pXSource.data2)) != null) {
                    pXTarget = DB.xsprite[pTarget.extra];
                    if (pXSprite.target > -1) {
                        SPRITE prvTarget = Engine.sprite[pXSprite.target];
                        Ai.aiSetTarget(DB.xsprite[prvTarget.extra], prvTarget.x, prvTarget.y, prvTarget.z);
                        if (!Trigger.isActive(pTarget.xvel)) {
                            Ai.aiActivateDude(pTarget, pXTarget);
                        }
                    }
                    Ai.aiSetTarget(pXSprite, pTarget.xvel);
                    if (!Trigger.isActive(pSprite.xvel)) {
                        Ai.aiActivateDude(pSprite, pXSprite);
                    }
                    if (pXSource.data3 > 0 && pXTarget.target != pSprite.xvel) {
                        Ai.aiSetTarget(pXTarget, pSprite.xvel);
                        if (!Trigger.isActive(pTarget.xvel)) {
                            Ai.aiActivateDude(pTarget, pXTarget);
                        }
                    }
                    return;
                }
            }
            if ((pXSprite.target < 0 || pPlayer != null) && (Globals.gFrameClock & 0x20) != 0) {
                short nSprite = Engine.headspritestat[6];
                while (nSprite >= 0) {
                    pTarget = Engine.sprite[nSprite];
                    pXTarget = DB.xsprite[pTarget.extra];
                    if (pXTarget.target == pSprite.xvel) {
                        Ai.aiSetTarget(pXSprite, pTarget.xvel);
                        return;
                    }
                    if (!(!Actor.IsDudeSprite(pTarget) || Gameutils.IsPlayerSprite(pTarget) && pXSource.data4 > 0 || !Trigger.dudeCanSeeTarget(pXSprite, pDudeInfo, pTarget) || pSprite.xvel == pTarget.xvel || pTarget.owner == pSprite.xvel || pXSource.data1 != 666 && pXSource.data1 != pXTarget.data1 || Actor.IsBurningDude(pTarget) || !Actor.IsKillableDude(pTarget) || pXSource.data2 == 1 && Trigger.isMateOf(pXSprite, pXTarget))) {
                        if (pXSource.data2 != 0 && (pXSource.data2 != 1 || Trigger.isMatesHaveSameTarget(pXSprite, pTarget, matesPerEnemy))) break;
                        Ai.aiSetTarget(pXSprite, pTarget.xvel);
                        if (!Trigger.isActive(pSprite.xvel)) {
                            Ai.aiActivateDude(pSprite, pXSprite);
                        }
                        if (pXSource.data3 > 0 && pXTarget.target != pSprite.xvel) {
                            Ai.aiSetTarget(pXTarget, pSprite.xvel);
                            if (!Trigger.isActive(pTarget.xvel)) {
                                Ai.aiActivateDude(pTarget, pXTarget);
                            }
                            if (pXSource.data3 == 2) {
                                Trigger.disturbDudesInSight(pTarget, maxAlarmDudes);
                            }
                        }
                        return;
                    }
                    nSprite = Engine.nextspritestat[nSprite];
                }
            }
            if ((pXSprite.target < 0 || pPlayer != null) && pXSource.data2 == 1 && (Globals.gFrameClock & 0x40) != 0) {
                SPRITE pMateTarget = null;
                pMateTarget = Trigger.getMateTargets(pXSprite);
                if (pMateTarget != null && pMateTarget.extra > 0) {
                    XSPRITE pXMateTarget = DB.xsprite[pMateTarget.extra];
                    if (Trigger.dudeCanSeeTarget(pXSprite, pDudeInfo, pMateTarget)) {
                        if (pXMateTarget.target < 0) {
                            Ai.aiSetTarget(pXMateTarget, pSprite.xvel);
                            if (Actor.IsDudeSprite(pMateTarget) && !Trigger.isActive(pMateTarget.xvel)) {
                                Ai.aiActivateDude(pMateTarget, pXMateTarget);
                            }
                        }
                        Ai.aiSetTarget(pXSprite, pMateTarget.xvel);
                        if (!Trigger.isActive(pSprite.xvel)) {
                            Ai.aiActivateDude(pSprite, pXSprite);
                        }
                        return;
                    }
                    if (pXMateTarget.target >= 0 && Trigger.dudeCanSeeTarget(pXSprite, pDudeInfo, Engine.sprite[pXMateTarget.target])) {
                        SPRITE pMate = Engine.sprite[pXMateTarget.target];
                        pXSprite.target = pMateTarget.xvel;
                        pXSprite.targetX = pMate.x;
                        pXSprite.targetY = pMate.y;
                        pXSprite.targetZ = pMate.z;
                        if (!Trigger.isActive(pSprite.xvel)) {
                            Ai.aiActivateDude(pSprite, pXSprite);
                        }
                        return;
                    }
                }
            }
        } else if (pSource.lotag == 31) {
            if (pXSource.data1 > 255) {
                pXSource.data1 = (short)255;
            }
            if (pXSource.data2 > 255) {
                pXSource.data2 = (short)255;
            }
            if (pXSource.data3 > 255) {
                pXSource.data3 = (short)255;
            }
            if (Trigger.valueIsBetween(pXSource.data4, 255, 65535)) {
                pXSource.data4 = 255;
            }
            switch (type) {
                case 6: {
                    if (Trigger.valueIsBetween(pXSource.data1, -1, Short.MAX_VALUE)) {
                        Engine.sector[nDest].floorxpanning = pXSource.data1;
                    }
                    if (Trigger.valueIsBetween(pXSource.data2, -1, Short.MAX_VALUE)) {
                        Engine.sector[nDest].floorypanning = pXSource.data2;
                    }
                    if (Trigger.valueIsBetween(pXSource.data3, -1, Short.MAX_VALUE)) {
                        Engine.sector[nDest].ceilingxpanning = pXSource.data3;
                    }
                    if (!Trigger.valueIsBetween(pXSource.data4, -1, 65535)) break;
                    Engine.sector[nDest].ceilingypanning = (short)pXSource.data4;
                    break;
                }
                case 3: {
                    if (Trigger.valueIsBetween(pXSource.data1, -1, Short.MAX_VALUE)) {
                        Engine.sprite[nDest].xrepeat = pXSource.data1 < 1 ? (short)0 : pXSource.data1;
                    }
                    if (Trigger.valueIsBetween(pXSource.data2, -1, Short.MAX_VALUE)) {
                        Engine.sprite[nDest].yrepeat = pXSource.data2 < 1 ? (short)0 : pXSource.data2;
                    }
                    if (Trigger.valueIsBetween(pXSource.data3, -1, Short.MAX_VALUE)) {
                        Engine.sprite[nDest].xoffset = pXSource.data3;
                    }
                    if (!Trigger.valueIsBetween(pXSource.data4, -1, 65535)) break;
                    Engine.sprite[nDest].yoffset = (short)pXSource.data4;
                    break;
                }
                case 0: {
                    if (Trigger.valueIsBetween(pXSource.data1, -1, Short.MAX_VALUE)) {
                        Engine.wall[nDest].xrepeat = pXSource.data1;
                    }
                    if (Trigger.valueIsBetween(pXSource.data2, -1, Short.MAX_VALUE)) {
                        Engine.wall[nDest].yrepeat = pXSource.data2;
                    }
                    if (Trigger.valueIsBetween(pXSource.data3, -1, Short.MAX_VALUE)) {
                        Engine.wall[nDest].xpanning = pXSource.data3;
                    }
                    if (!Trigger.valueIsBetween(pXSource.data4, -1, 65535)) break;
                    Engine.wall[nDest].ypanning = (short)pXSource.data4;
                }
            }
        } else if (pSource.lotag == 29) {
            switch (type) {
                case 6: {
                    if (Trigger.valueIsBetween(pXSource.data1, -1, Short.MAX_VALUE)) {
                        Engine.sector[nDest].floorpicnum = pXSource.data1;
                    }
                    if (Trigger.valueIsBetween(pXSource.data2, -1, Short.MAX_VALUE)) {
                        Engine.sector[nDest].ceilingpicnum = pXSource.data2;
                    }
                    XSECTOR pXSector = DB.xsector[Engine.sector[nDest].extra];
                    if (Trigger.valueIsBetween(pXSource.data3, -1, Short.MAX_VALUE)) {
                        Engine.sector[nDest].floorpal = pXSource.data3;
                        if ((pSource.hitag & 1) != 0) {
                            pXSector.floorpal = pXSource.data3;
                        }
                    }
                    if (!Trigger.valueIsBetween(pXSource.data4, -1, 65535)) break;
                    Engine.sector[nDest].ceilingpal = (short)pXSource.data4;
                    if ((pSource.hitag & 1) == 0) break;
                    pXSector.ceilpal = (short)pXSource.data4;
                    break;
                }
                case 3: {
                    if (Trigger.valueIsBetween(pXSource.data1, -1, Short.MAX_VALUE)) {
                        Engine.sprite[nDest].picnum = pXSource.data1;
                    }
                    if (pXSource.data2 >= 0) {
                        Engine.sprite[nDest].shade = (byte)(pXSource.data2 > 127 ? 127 : (int)pXSource.data2);
                    } else if (pXSource.data2 < -1) {
                        Engine.sprite[nDest].shade = (byte)(pXSource.data2 < -127 ? -127 : (int)pXSource.data2);
                    }
                    if (!Trigger.valueIsBetween(pXSource.data3, -1, Short.MAX_VALUE)) break;
                    Engine.sprite[nDest].pal = pXSource.data3;
                    break;
                }
                case 0: {
                    if (Trigger.valueIsBetween(pXSource.data1, -1, Short.MAX_VALUE)) {
                        Engine.wall[nDest].picnum = pXSource.data1;
                    }
                    if (Trigger.valueIsBetween(pXSource.data2, -1, Short.MAX_VALUE)) {
                        Engine.wall[nDest].overpicnum = pXSource.data2;
                    }
                    if (!Trigger.valueIsBetween(pXSource.data3, -1, Short.MAX_VALUE)) break;
                    Engine.wall[nDest].pal = pXSource.data3;
                }
            }
        } else if (pSource.lotag == 28) {
            switch (type) {
                case 6: {
                    XSECTOR pXSector = DB.xsector[Engine.sector[nDest].extra];
                    switch (pXSource.data1) {
                        case 0: {
                            pXSector.Underwater = false;
                            break;
                        }
                        case 1: {
                            pXSector.Underwater = true;
                            break;
                        }
                        case 2: {
                            pXSector.Depth = 0;
                            break;
                        }
                        case 3: {
                            pXSector.Depth = 1;
                            break;
                        }
                        case 4: {
                            pXSector.Depth = (short)2;
                            break;
                        }
                        case 5: {
                            pXSector.Depth = (short)3;
                            break;
                        }
                        case 6: {
                            pXSector.Depth = (short)4;
                            break;
                        }
                        case 7: {
                            pXSector.Depth = (short)5;
                            break;
                        }
                        case 8: {
                            pXSector.Depth = (short)6;
                            break;
                        }
                        case 9: {
                            pXSector.Depth = (short)7;
                        }
                    }
                    if (Trigger.valueIsBetween(pXSource.data2, -1, Short.MAX_VALUE)) {
                        Engine.sector[nDest].visibility = pXSource.data2 > 255 ? (short)255 : pXSource.data2;
                    }
                    if (Trigger.valueIsBetween(pXSource.data3, -1, Short.MAX_VALUE)) {
                        Engine.sector[nDest].ceilingstat = pXSource.data3;
                    }
                    if (!Trigger.valueIsBetween(pXSource.data4, -1, 65535)) break;
                    Engine.sector[nDest].floorstat = (short)pXSource.data4;
                    break;
                }
                case 3: {
                    if (Trigger.valueIsBetween(pXSource.data3, -1, Short.MAX_VALUE)) {
                        Engine.sprite[nDest].hitag = pXSource.data3;
                    }
                    if (!Trigger.valueIsBetween(pXSource.data4, -1, 65535)) break;
                    pXSource.data4 |= 0x80;
                    Engine.sprite[nDest].cstat = (short)pXSource.data4;
                    break;
                }
                case 0: {
                    if (Trigger.valueIsBetween(pXSource.data3, -1, Short.MAX_VALUE)) {
                        Engine.wall[nDest].hitag = pXSource.data3;
                    }
                    if (!Trigger.valueIsBetween(pXSource.data4, -1, 65535)) break;
                    Engine.wall[nDest].cstat = (short)pXSource.data4;
                }
            }
        }
    }

    public static void trMessageSector(int nSector, int event) {
        if (nSector >= Engine.numsectors) {
            Main.game.dassert("nSector < numsectors " + nSector + " < " + Engine.numsectors);
        }
        if (Engine.sector[nSector].extra <= 0 || Engine.sector[nSector].extra >= 512) {
            Main.game.dassert("sector[nSector].extra > 0 && sector[nSector].extra < kMaxXSectors");
        }
        XSECTOR pXSector = DB.xsector[Engine.sector[nSector].extra];
        if (pXSector.locked != 0 && EVENT.getCommand(event) != 7 && EVENT.getCommand(event) != 8) {
            return;
        }
        if (EVENT.getCommand(event) == 5) {
            Trigger.LinkSector(nSector, pXSector, event);
        } else if (EVENT.getCommand(event) == 53) {
            Trigger.pastePropertiesInObj(6, nSector, event);
        } else {
            Trigger.OperateSector(nSector, pXSector, EVENT.getCommand(event));
        }
    }

    public static void trTriggerWall(int nWall, XWALL pXWall, int command) {
        if (nWall >= Engine.numwalls) {
            Main.game.dassert("nWall < numwalls");
        }
        if (pXWall.locked != 0) {
            return;
        }
        if (pXWall.isTriggered) {
            return;
        }
        if (pXWall.triggerOnce) {
            pXWall.isTriggered = true;
        }
        if (pXWall.decoupled) {
            if (pXWall.txID != 0) {
                EVENT.evSend(nWall, 0, pXWall.txID, pXWall.command);
            }
        } else {
            Trigger.OperateWall(nWall, pXWall, command);
        }
    }

    public static void trMessageWall(int nWall, int event) {
        if (nWall >= Engine.numwalls) {
            Main.game.dassert("nWall < numwalls");
        }
        if (Engine.wall[nWall].extra <= 0 || Engine.wall[nWall].extra >= 512) {
            Main.game.dassert("wall[nWall].extra > 0 && wall[nWall].extra < kMaxXWalls");
        }
        XWALL pXWall = DB.xwall[Engine.wall[nWall].extra];
        if (pXWall.locked != 0 && EVENT.getCommand(event) != 7 && EVENT.getCommand(event) != 8) {
            return;
        }
        if (EVENT.getCommand(event) == 5) {
            Trigger.LinkWall(nWall, pXWall, event);
        } else if (EVENT.getCommand(event) == 53) {
            Trigger.pastePropertiesInObj(0, nWall, event);
        } else {
            Trigger.OperateWall(nWall, pXWall, EVENT.getCommand(event));
        }
    }

    public static void trTriggerSprite(int nSprite, XSPRITE pXSprite, int command) {
        if (pXSprite.Locked != 0) {
            return;
        }
        if (pXSprite.isTriggered) {
            return;
        }
        if (pXSprite.triggerOnce) {
            pXSprite.isTriggered = true;
        }
        if (pXSprite.Decoupled) {
            if (pXSprite.txID != 0) {
                EVENT.evSend(nSprite, 3, pXSprite.txID, pXSprite.command);
            }
        } else {
            Trigger.OperateSprite(nSprite, pXSprite, command);
        }
    }

    public static void trMessageSprite(int nSprite, int event) {
        if (Engine.sprite[nSprite].statnum == 1024) {
            return;
        }
        if (Engine.sprite[nSprite].extra <= 0 || Engine.sprite[nSprite].extra >= 2048) {
            Main.game.dassert("sprite[nSprite].extra > 0 && sprite[nSprite].extra < kMaxXSprites");
        }
        XSPRITE pXSprite = DB.xsprite[Engine.sprite[nSprite].extra];
        if (pXSprite.Locked != 0 && EVENT.getCommand(event) != 7 && EVENT.getCommand(event) != 8) {
            return;
        }
        if (EVENT.getCommand(event) == 5) {
            Trigger.LinkSprite(nSprite, pXSprite, event);
        } else if (EVENT.getCommand(event) == 53) {
            Trigger.pastePropertiesInObj(3, nSprite, event);
        } else {
            Trigger.OperateSprite(nSprite, pXSprite, EVENT.getCommand(event));
        }
    }

    public static void trProcessMotion() {
        for (int nSector = 0; nSector < Engine.numsectors; ++nSector) {
            SPRITE pSprite;
            SECTOR pSector = Engine.sector[nSector];
            if (pSector.extra <= 0) continue;
            XSECTOR pXSector = DB.xsector[pSector.extra];
            if (pXSector.bobSpeed == 0) continue;
            if (pXSector.bobAlways) {
                pXSector.bobTheta += pXSector.bobSpeed;
            } else {
                if (pXSector.busy == 0) continue;
                pXSector.bobTheta += Pragmas.mulscale(pXSector.busy, pXSector.bobSpeed, 16);
            }
            int phase = Pragmas.mulscale(pXSector.bobZRange << 8, Trig.Sin(pXSector.bobTheta), 30);
            short nSprite = Engine.headspritesect[nSector];
            while (nSprite >= 0) {
                SPRITE pSprite2 = Engine.sprite[nSprite];
                if ((pSprite2.cstat & 0x6000) != 0) {
                    View.viewBackupSpriteLoc(nSprite, pSprite2);
                    pSprite2.z += phase;
                }
                nSprite = Engine.nextspritesect[nSprite];
            }
            if (pXSector.bobFloor) {
                int oldFloorz = pSector.floorz;
                View.viewBackupSectorLoc(nSector, pSector);
                pSector.floorz = phase + secFloorZ[nSector];
                short nSprite2 = Engine.headspritesect[nSector];
                while (nSprite2 >= 0) {
                    pSprite = Engine.sprite[nSprite2];
                    if ((pSprite.hitag & 2) != 0) {
                        pSprite.hitag = (short)(pSprite.hitag | 4);
                    } else {
                        Gameutils.GetSpriteExtents(pSprite);
                        if (Gameutils.extents_zBot >= oldFloorz && (pSprite.cstat & 0x30) == 0) {
                            View.viewBackupSpriteLoc(nSprite2, pSprite);
                            pSprite.z += phase;
                        }
                    }
                    nSprite2 = Engine.nextspritesect[nSprite2];
                }
            }
            if (!pXSector.bobCeiling) continue;
            int oldCeilz = pSector.ceilingz;
            View.viewBackupSectorLoc(nSector, pSector);
            pSector.ceilingz = phase + secCeilZ[nSector];
            short nSprite3 = Engine.headspritesect[nSector];
            while (nSprite3 >= 0) {
                pSprite = Engine.sprite[nSprite3];
                Gameutils.GetSpriteExtents(pSprite);
                if (Gameutils.extents_zTop <= oldCeilz && (pSprite.cstat & 0x30) == 0) {
                    View.viewBackupSpriteLoc(nSprite3, pSprite);
                    pSprite.z += phase;
                }
                nSprite3 = Engine.nextspritesect[nSprite3];
            }
        }
    }

    public static void trProcessSlope() {
        for (int nSector = 0; nSector < Engine.numsectors; ++nSector) {
            SECTOR pSector = Engine.sector[nSector];
            if (pSector.filler == 0) continue;
            WALL pWall = Engine.wall[pSector.filler + pSector.wallptr];
            WALL pWall2 = Engine.wall[pWall.point2];
            if (pWall.nextsector < 0) continue;
            int dx = (pWall2.x + pWall.x) / 2;
            int dy = (pWall2.y + pWall.y) / 2;
            View.viewBackupSectorLoc(nSector, pSector);
            int floorslope = Main.engine.getflorzofslope(pWall.nextsector, dx, dy);
            Main.engine.alignflorslope((short)nSector, dx, dy, floorslope);
            int ceilingslope = Main.engine.getceilzofslope(pWall.nextsector, dx, dy);
            Main.engine.alignceilslope((short)nSector, dx, dy, ceilingslope);
        }
    }

    public static void trProcessBusy() {
        Arrays.fill(Actor.floorVel, 0L);
        Arrays.fill(Actor.ceilingVel, 0L);
        int i = gBusyCount - 1;
        while (i >= 0) {
            int tempBusy = Trigger.gBusy[i].nBusy;
            Trigger.gBusy[i].nBusy = Gameutils.ClipRange(Trigger.gBusy[i].nBusy + Trigger.gBusy[i].nDelta * Globals.kFrameTicks, 0, 65536);
            int rcode = gBusyProc[Trigger.gBusy[i].busyProc].run(Trigger.gBusy[i].nIndex, Trigger.gBusy[i].nBusy);
            switch (rcode) {
                case 1: {
                    Trigger.gBusy[i].nBusy = tempBusy;
                    break;
                }
                case 2: {
                    Trigger.gBusy[i].nBusy = tempBusy;
                    Trigger.gBusy[i].nDelta = -Trigger.gBusy[i].nDelta;
                    break;
                }
                case 3: {
                    Trigger.gBusy[i].nIndex = Trigger.gBusy[--Trigger.gBusyCount].nIndex;
                    Trigger.gBusy[i].nBusy = Trigger.gBusy[Trigger.gBusyCount].nBusy;
                    Trigger.gBusy[i].nDelta = Trigger.gBusy[Trigger.gBusyCount].nDelta;
                    Trigger.gBusy[i].busyProc = Trigger.gBusy[Trigger.gBusyCount].busyProc;
                }
            }
            --i;
        }
        Trigger.trProcessMotion();
        Trigger.trProcessSlope();
    }

    public static void trInitStructs() {
        gBusyCount = 0;
        for (int i = 0; i < 128; ++i) {
            if (gBusy[i] == null) {
                Trigger.gBusy[i] = new BUSY();
                continue;
            }
            gBusy[i].clear();
        }
        for (int nWall = 0; nWall < Globals.kMaxWalls; ++nWall) {
            if (kwall[nWall] == null) {
                Trigger.kwall[nWall] = new Vector2();
                continue;
            }
            kwall[nWall].set(0.0f, 0.0f);
        }
        for (int nSprite = 0; nSprite < Globals.kMaxSprites; ++nSprite) {
            if (ksprite[nSprite] == null) {
                Trigger.ksprite[nSprite] = new Vector3();
                continue;
            }
            ksprite[nSprite].set(0.0f, 0.0f, 0.0f);
        }
    }

    public static void trInit() {
        int nSprite;
        int nWall;
        Trigger.trInitStructs();
        for (nWall = 0; nWall < Engine.numwalls; ++nWall) {
            Trigger.kwall[nWall].x = Engine.wall[nWall].x;
            Trigger.kwall[nWall].y = Engine.wall[nWall].y;
        }
        for (nSprite = 0; nSprite < Globals.kMaxSprites; ++nSprite) {
            if (Engine.sprite[nSprite].statnum < 1024) {
                Trigger.ksprite[nSprite].x = Engine.sprite[nSprite].x;
                Trigger.ksprite[nSprite].y = Engine.sprite[nSprite].y;
                Trigger.ksprite[nSprite].z = Engine.sprite[nSprite].z;
                Engine.sprite[nSprite].zvel = Engine.sprite[nSprite].lotag;
                continue;
            }
            Engine.sprite[nSprite].zvel = (short)-1;
        }
        for (nWall = 0; nWall < Engine.numwalls; ++nWall) {
            if (Engine.wall[nWall].extra <= 0) continue;
            short nXWall = Engine.wall[nWall].extra;
            if (nXWall >= 512) {
                Main.game.dassert("nXWall < kMaxXWalls");
            }
            XWALL pXWall = DB.xwall[nXWall];
            if (pXWall.state == 0) continue;
            pXWall.busy = 65536;
        }
        if (Engine.numsectors < 0 || Engine.numsectors >= Globals.kMaxSectors) {
            Main.game.dassert("(numsectors >= 0) && (numsectors < kMaxSectors)");
        }
        block16: for (int nSector = 0; nSector < Engine.numsectors; ++nSector) {
            SECTOR pSector = Engine.sector[nSector];
            Trigger.secFloorZ[nSector] = pSector.floorz;
            Trigger.secCeilZ[nSector] = pSector.ceilingz;
            short nXSector = pSector.extra;
            if (nXSector <= 0) continue;
            if (nXSector >= 512) {
                Main.game.dassert("nXSector < kMaxXSectors");
            }
            XSECTOR pXSector = DB.xsector[nXSector];
            if (pXSector.state != 0) {
                pXSector.busy = 65536;
            }
            switch (pSector.lotag) {
                case 600: 
                case 602: {
                    Trigger.zMotion(nSector, pXSector, pXSector.busy, 1);
                    continue block16;
                }
                case 612: {
                    Trigger.PathSectorInit(nSector, pXSector);
                    continue block16;
                }
                case 614: 
                case 616: {
                    int i;
                    SPRITE pMark0 = Engine.sprite[pXSector.marker0];
                    SPRITE pMark1 = Engine.sprite[pXSector.marker1];
                    Trigger.TranslateSector(nSector, 0, -65536, pMark0.x, pMark0.y, pMark0.x, pMark0.y, pMark0.ang, pMark1.x, pMark1.y, pMark1.ang, pSector.lotag == 616);
                    for (i = 0; i < pSector.wallnum; ++i) {
                        nWall = pSector.wallptr + i;
                        Trigger.kwall[nWall].x = Engine.wall[nWall].x;
                        Trigger.kwall[nWall].y = Engine.wall[nWall].y;
                    }
                    nSprite = Engine.headspritesect[nSector];
                    while (nSprite >= 0) {
                        Trigger.ksprite[nSprite].x = Engine.sprite[nSprite].x;
                        Trigger.ksprite[nSprite].y = Engine.sprite[nSprite].y;
                        Trigger.ksprite[nSprite].z = Engine.sprite[nSprite].z;
                        nSprite = Engine.nextspritesect[nSprite];
                    }
                    Trigger.TranslateSector(nSector, 0, pXSector.busy, pMark0.x, pMark0.y, pMark0.x, pMark0.y, pMark0.ang, pMark1.x, pMark1.y, pMark1.ang, pSector.lotag == 616);
                    Trigger.zMotion(nSector, pXSector, pXSector.busy, 1);
                    continue block16;
                }
                case 615: 
                case 617: {
                    int i;
                    SPRITE pMark = Engine.sprite[pXSector.marker0];
                    Trigger.TranslateSector(nSector, 0, -65536, pMark.x, pMark.y, pMark.x, pMark.y, 0, pMark.x, pMark.y, pMark.ang, pSector.lotag == 617);
                    for (i = 0; i < pSector.wallnum; ++i) {
                        nWall = pSector.wallptr + i;
                        Trigger.kwall[nWall].x = Engine.wall[nWall].x;
                        Trigger.kwall[nWall].y = Engine.wall[nWall].y;
                    }
                    nSprite = Engine.headspritesect[nSector];
                    while (nSprite >= 0) {
                        Trigger.ksprite[nSprite].x = Engine.sprite[nSprite].x;
                        Trigger.ksprite[nSprite].y = Engine.sprite[nSprite].y;
                        Trigger.ksprite[nSprite].z = Engine.sprite[nSprite].z;
                        nSprite = Engine.nextspritesect[nSprite];
                    }
                    Trigger.TranslateSector(nSector, 0, pXSector.busy, pMark.x, pMark.y, pMark.x, pMark.y, 0, pMark.x, pMark.y, pMark.ang, pSector.lotag == 617);
                    Trigger.zMotion(nSector, pXSector, pXSector.busy, 1);
                    continue block16;
                }
                case 619: {
                    EVENT.evPostCallback(nSector, 6, 0L, 12);
                }
            }
        }
        for (nSprite = 0; nSprite < Globals.kMaxSprites; ++nSprite) {
            short nXSprite = Engine.sprite[nSprite].extra;
            if (Engine.sprite[nSprite].statnum >= 1024 || nXSprite <= 0) continue;
            if (nXSprite >= 2048) {
                Main.game.dassert("nXSprite < kMaxXSprites");
            }
            XSPRITE pXSprite = DB.xsprite[nXSprite];
            if (pXSprite.state != 0) {
                pXSprite.busy = 65536;
            }
            switch (Engine.sprite[nSprite].lotag) {
                case 23: {
                    pXSprite.triggerOnce = true;
                    break;
                }
                case 401: 
                case 433: {
                    pXSprite.Proximity = true;
                    break;
                }
                case 414: {
                    if (pXSprite.state != 0) {
                        Engine.sprite[nSprite].hitag = (short)(Engine.sprite[nSprite].hitag | 7);
                        break;
                    }
                    Engine.sprite[nSprite].hitag = (short)(Engine.sprite[nSprite].hitag & 0xFFFFFFF8);
                    break;
                }
                case 27: 
                case 33: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 80: 
                case 700: 
                case 701: 
                case 702: 
                case 703: 
                case 704: 
                case 705: 
                case 706: 
                case 707: 
                case 708: {
                    Trigger.InitGenerator(nSprite);
                }
            }
            if (pXSprite.Push) {
                Engine.sprite[nSprite].cstat = (short)(Engine.sprite[nSprite].cstat | 0x1000);
            }
            if (!pXSprite.Vector) continue;
            Engine.sprite[nSprite].cstat = (short)(Engine.sprite[nSprite].cstat | 0x100);
        }
        EVENT.evSend(0, 0, 7, 1);
        if (Globals.pGameInfo.nGameType == 1) {
            EVENT.evSend(0, 0, 9, 1);
        }
        if (Globals.pGameInfo.nGameType == 2 || Globals.pGameInfo.nGameType == 3) {
            EVENT.evSend(0, 0, 8, 1);
        }
        if (Globals.pGameInfo.nGameType == 3) {
            EVENT.evSend(0, 0, 10, 1);
        }
    }

    public static void useTeleportTarget(XSPRITE pXSource, SPRITE pSprite) {
        XSECTOR pXSector;
        SPRITE pSource = Engine.sprite[pXSource.reference];
        XSECTOR xSECTOR = pXSector = Engine.sector[pSource.sectnum].extra >= 0 ? DB.xsector[Engine.sector[pSource.sectnum].extra] : null;
        if (pSprite == null) {
            short i = Mmulti.connecthead;
            while (i >= 0) {
                if (pXSource.data1 >= 8 || pXSource.data1 == i + 1 && (pXSource.data1 >= 239 || pXSource.data1 < 231 || pXSource.data1 + 230 != Globals.gPlayer[i].pSprite.lotag)) {
                    Trigger.useTeleportTarget(pXSource, Globals.gPlayer[i].pSprite);
                    return;
                }
                i = Mmulti.connectpoint2[i];
            }
            return;
        }
        pSprite.x = pSource.x;
        pSprite.y = pSource.y;
        pSprite.z += Engine.sector[pSource.sectnum].floorz - Engine.sector[pSprite.sectnum].floorz;
        if ((pSource.hitag & 1) != 0) {
            Trigger.TeleportDamage(pSprite.xvel, pSource.sectnum);
        }
        DB.changespritesect(pSprite.xvel, pSource.sectnum);
        DB.xsprite[pSprite.extra].palette = pXSector != null && pXSector.Underwater ? 1 : 0;
        if (pXSource.data2 == 1) {
            pSprite.ang = pSource.ang;
        }
        if (pXSource.data3 == 1) {
            Actor.sprZVel[pSprite.xvel] = 0L;
            Actor.sprYVel[pSprite.xvel] = 0L;
            Actor.sprXVel[pSprite.xvel] = 0L;
        }
        View.viewBackupSpriteLoc(pSprite.xvel, pSprite);
        if (pXSource.data4 > 0) {
            SOUND.sfxStart3DSound(pSource, pXSource.data4, -1, 0);
        }
        if (Gameutils.IsPlayerSprite(pSprite)) {
            PLAYER pPlayer = Globals.gPlayer[pSprite.lotag - 231];
            View.viewUpdatePlayerLoc(pPlayer);
            if (pXSource.data2 == 1) {
                Globals.gPlayer[pPlayer.nPlayer].viewOffdZ = 0;
                Globals.gPlayer[pPlayer.nPlayer].weapOffdZ = 0;
                Globals.gPlayer[pPlayer.nPlayer].ang = pSprite.ang;
            }
        }
    }

    public static void useSpriteDamager(XSPRITE pXSource, SPRITE pSprite) {
        int dmgType;
        int dmg;
        int n = dmg = pXSource.data4 == 0 || pXSource.data4 > 65534 ? 65535 : pXSource.data4;
        int n2 = pXSource.data3 >= 7 ? Gameutils.Random(6) : (dmgType = pXSource.data3 < 0 ? 0 : (int)pXSource.data3);
        if (pSprite != null) {
            Actor.actDamageSprite(pSprite.xvel, pSprite, dmgType, dmg);
            return;
        }
        if (pXSource.data2 > 0 && pXSource.data2 <= 8) {
            short i = Mmulti.connecthead;
            while (i >= 0) {
                if (pXSource.data1 >= 8 || pXSource.data1 == i + 1 && (pXSource.data1 >= 239 || pXSource.data1 < 231 || pXSource.data1 + 230 != Globals.gPlayer[i].pSprite.lotag)) {
                    Actor.actDamageSprite(Engine.sprite[pXSource.reference].xvel, Globals.gPlayer[i].pSprite, dmgType, dmg);
                    return;
                }
                i = Mmulti.connectpoint2[i];
            }
        }
    }

    public static void useSeqSpawnerGen(XSPRITE pXSource, int objType, int index) {
        switch (objType) {
            case 6: {
                if (pXSource.data2 <= 0) {
                    if (pXSource.data3 == 3 || pXSource.data3 == 1) {
                        SeqHandling.seqKill(2, Engine.sector[index].extra);
                    }
                    if (pXSource.data3 == 3 || pXSource.data3 == 2) {
                        SeqHandling.seqKill(1, Engine.sector[index].extra);
                    }
                } else {
                    if (pXSource.data3 == 3 || pXSource.data3 == 1) {
                        SeqHandling.seqSpawn(pXSource.data2, 2, Engine.sector[index].extra, null);
                    }
                    if (pXSource.data3 == 3 || pXSource.data3 == 2) {
                        SeqHandling.seqSpawn(pXSource.data2, 1, Engine.sector[index].extra, null);
                    }
                }
                return;
            }
            case 0: {
                if (pXSource.data2 <= 0) {
                    if (pXSource.data3 == 3 || pXSource.data3 == 1) {
                        SeqHandling.seqKill(0, Engine.wall[index].extra);
                    }
                    if ((pXSource.data3 == 3 || pXSource.data3 == 2) && (Engine.wall[index].cstat & 0x10) != 0) {
                        SeqHandling.seqKill(4, Engine.wall[index].extra);
                    }
                } else {
                    if (pXSource.data3 == 3 || pXSource.data3 == 1) {
                        SeqHandling.seqSpawn(pXSource.data2, 0, Engine.wall[index].extra, null);
                    }
                    if (pXSource.data3 == 3 || pXSource.data3 == 2) {
                        if (Engine.wall[index].nextwall < 0) {
                            if (pXSource.data3 == 3) {
                                SeqHandling.seqSpawn(pXSource.data2, 0, Engine.wall[index].extra, null);
                            }
                        } else {
                            if ((Engine.wall[index].cstat & 0x10) == 0) {
                                Engine.wall[index].cstat = (short)(Engine.wall[index].cstat | 0x10);
                            }
                            SeqHandling.seqSpawn(pXSource.data2, 4, Engine.wall[index].extra, null);
                        }
                    }
                    if (pXSource.data4 > 0) {
                        int cx = (Engine.wall[Engine.wall[index].point2].x + Engine.wall[index].x) / 2;
                        int cy = (Engine.wall[Engine.wall[index].point2].y + Engine.wall[index].y) / 2;
                        short nSector = Main.engine.sectorofwall((short)index);
                        Main.engine.getzsofslope(nSector, cx, cy, Globals.zofslope);
                        int floorz = Globals.zofslope[1];
                        int ceilz = Globals.zofslope[0];
                        if (Engine.wall[index].nextsector != -1) {
                            Main.engine.getzsofslope(Engine.wall[index].nextsector, cx, cy, Globals.zofslope);
                        }
                        int nextfloorz = Globals.zofslope[1];
                        int nextceilz = Globals.zofslope[0];
                        int cz = ceilz;
                        int fz = floorz;
                        if (ceilz < nextceilz) {
                            cz = nextceilz;
                        }
                        if (floorz >= nextfloorz) {
                            fz = nextfloorz;
                        }
                        SOUND.sfxCreate3DSound(cx, cy, fz + cz >> 1, pXSource.data4, nSector);
                    }
                }
                return;
            }
            case 3: {
                if (pXSource.data2 <= 0) {
                    SeqHandling.seqKill(3, Engine.sprite[index].extra);
                } else {
                    SeqHandling.seqSpawn(pXSource.data2, 3, Engine.sprite[index].extra, pXSource.data3 > 0 ? SeqHandling.callbacks[pXSource.data3] : null);
                    if (pXSource.data4 > 0) {
                        SOUND.sfxStart3DSound(Engine.sprite[index], pXSource.data4, -1, 0);
                    }
                }
                return;
            }
        }
    }

    public static void useSectorWindGen(XSPRITE pXSource, SECTOR pSector) {
        SPRITE pSource = Engine.sprite[pXSource.reference];
        XSECTOR pXSector = null;
        boolean forceWind = false;
        if (pSector.extra >= 0) {
            pXSector = DB.xsector[pSector.extra];
        } else {
            int nXSector = DB.dbInsertXSector(pSource.sectnum);
            if (nXSector < 0) {
                return;
            }
            pXSector = DB.xsector[nXSector];
            forceWind = true;
        }
        if ((pSource.hitag & 1) != 0) {
            pXSector.panAlways = true;
            pXSector.windAlways = true;
        } else if (forceWind) {
            pXSector.windAlways = true;
        }
        if (pXSource.data2 > 32766) {
            pXSource.data2 = Short.MAX_VALUE;
        }
        pXSector.windVel = pXSource.data1 == 1 || pXSource.data1 == 3 ? Gameutils.Random(pXSource.data2) : (int)pXSource.data2;
        if (pXSource.data1 == 2 || pXSource.data1 == 3) {
            short ang = pSource.ang;
            while (pSource.ang == ang) {
                pSource.ang = (short)Gameutils.BiRandom(2048);
            }
        }
        pXSector.windAng = pSource.ang;
        if (pXSource.data3 > 0 && pXSource.data3 < 4) {
            switch (pXSource.data3) {
                case 1: {
                    pXSector.panFloor = true;
                    pXSector.panCeiling = false;
                    break;
                }
                case 2: {
                    pXSector.panFloor = false;
                    pXSector.panCeiling = true;
                    break;
                }
                case 3: {
                    pXSector.panFloor = true;
                    pXSector.panCeiling = true;
                }
            }
            short oldPan = pXSector.panVel;
            pXSector.panAngle = (short)pXSector.windAng;
            pXSector.panVel = (short)pXSector.windVel;
            if (oldPan == 0 && pXSector.panVel != 0) {
                int i = SECTORFX.panCount;
                while (i >= 0 && SECTORFX.panList[i] != pSector.extra) {
                    if (i == 0) {
                        SECTORFX.panList[SECTORFX.panCount++] = pSector.extra;
                    }
                    --i;
                }
            }
        }
    }

    public static void useEffectGen(XSPRITE pXSource, SPRITE pSprite) {
        if (pSprite.extra < 0) {
            return;
        }
        Gameutils.GetSpriteExtents(pSprite);
        SPRITE pEffect = null;
        int dx = 0;
        int dy = 0;
        int cnt = Math.min(pXSource.data4, 32);
        while (cnt-- >= 0) {
            if (cnt > 0) {
                dx = Gameutils.BiRandom(250);
                dy = Gameutils.BiRandom(150);
            }
            if ((pEffect = Actor.actSpawnEffect(pXSource.data2, pSprite.sectnum, pSprite.x + dx, pSprite.y + dy, Gameutils.extents_zTop, 0)) == null) continue;
            if (pEffect.pal <= 0) {
                pEffect.pal = pSprite.pal;
            }
            if (pEffect.xrepeat <= 0) {
                pEffect.xrepeat = pSprite.xrepeat;
            }
            if (pEffect.yrepeat <= 0) {
                pEffect.yrepeat = pSprite.yrepeat;
            }
            if (pEffect.shade != 0) continue;
            pEffect.shade = pSprite.shade;
        }
        if (pXSource.data3 > 0) {
            SOUND.sfxStart3DSound(pSprite, pXSource.data3, -1, 0);
        }
    }

    public static void stopWindOnSectors(XSPRITE pXSource) {
        SPRITE pSource = Engine.sprite[pXSource.reference];
        if (pXSource.txID <= 0) {
            if (Engine.sector[pSource.sectnum].extra >= 0) {
                DB.xsector[Engine.sector[pSource.sectnum].extra].windVel = 0;
            }
            return;
        }
        for (int i = EVENT.bucketHead[pXSource.txID]; i < EVENT.bucketHead[pXSource.txID + 1]; ++i) {
            if (EVENT.rxBucket[i].type != 6) continue;
            XSECTOR pXSector = DB.xsector[Engine.sector[EVENT.rxBucket[i].index].extra];
            if ((pXSector.state != 1 || pXSector.windAlways) && pSource.hitag != 1) continue;
            pXSector.windVel = 0;
        }
    }

    public static boolean targetMustBeForced(SPRITE pDude) {
        switch (pDude.lotag) {
            case 205: 
            case 244: {
                return true;
            }
        }
        return false;
    }

    public static boolean dudeCanSeeTarget(XSPRITE pXDude, DudeInfo pDudeInfo, SPRITE pTarget) {
        SPRITE pDude = Engine.sprite[pXDude.reference];
        int dx = pTarget.x - pDude.x;
        int dy = pTarget.y - pDude.y;
        int dist = (int)Main.engine.qdist(dx, dy);
        if (dist < pDudeInfo.seeDist) {
            int eyeAboveZ = pDudeInfo.eyeHeight * pDude.yrepeat << 2;
            return Main.engine.cansee(pDude.x, pDude.y, pDude.z, pDude.sectnum, pTarget.x, pTarget.y, pTarget.z - eyeAboveZ, pTarget.sectnum);
        }
        return false;
    }

    public static void disturbDudesInSight(SPRITE pSprite, int max) {
        SPRITE pDude = null;
        XSPRITE pXDude = null;
        XSPRITE pXSprite = DB.xsprite[pSprite.extra];
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        short nSprite = Engine.headspritestat[6];
        while (nSprite >= 0) {
            pDude = Engine.sprite[nSprite];
            if (pDude.xvel != pSprite.xvel && Actor.IsDudeSprite(pDude) && pDude.extra >= 0) {
                pXDude = DB.xsprite[pDude.extra];
                if (Trigger.dudeCanSeeTarget(pXSprite, pDudeInfo, pDude) && pXDude.target == -1 && pXDude.rxID <= 0) {
                    Ai.aiSetTarget(pXDude, pDude.x, pDude.y, pDude.z);
                    Ai.aiActivateDude(pDude, pXDude);
                    if (max-- < 1) break;
                }
            }
            nSprite = Engine.nextspritestat[nSprite];
        }
    }

    public static int getTargetDist(SPRITE pSprite, DudeInfo pDudeInfo, SPRITE pTarget) {
        int x = pTarget.x;
        int dx = x - pSprite.x;
        int y = pTarget.y;
        int dy = y - pSprite.y;
        int dist = (int)Main.engine.qdist(dx, dy);
        if (dist <= pDudeInfo.meleeDist) {
            return 0;
        }
        if (dist >= pDudeInfo.seeDist) {
            return 13;
        }
        if (dist <= pDudeInfo.seeDist / 12) {
            return 1;
        }
        if (dist <= pDudeInfo.seeDist / 11) {
            return 2;
        }
        if (dist <= pDudeInfo.seeDist / 10) {
            return 3;
        }
        if (dist <= pDudeInfo.seeDist / 9) {
            return 4;
        }
        if (dist <= pDudeInfo.seeDist / 8) {
            return 5;
        }
        if (dist <= pDudeInfo.seeDist / 7) {
            return 6;
        }
        if (dist <= pDudeInfo.seeDist / 6) {
            return 7;
        }
        if (dist <= pDudeInfo.seeDist / 5) {
            return 8;
        }
        if (dist <= pDudeInfo.seeDist / 4) {
            return 9;
        }
        if (dist <= pDudeInfo.seeDist / 3) {
            return 10;
        }
        if (dist <= pDudeInfo.seeDist / 2) {
            return 11;
        }
        return 12;
    }

    public static int getFineTargetDist(SPRITE pSprite, DudeInfo pDudeInfo, SPRITE pTarget) {
        int x = pTarget.x;
        int y = pTarget.y;
        int dx = x - pSprite.x;
        int dy = y - pSprite.y;
        int dist = (int)Main.engine.qdist(dx, dy);
        return dist;
    }

    public static SPRITE getTargetInRange(SPRITE pSprite, int minDist, int maxDist, short data, short teamMode) {
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        XSPRITE pXSprite = DB.xsprite[pSprite.extra];
        SPRITE pTarget = null;
        XSPRITE pXTarget = null;
        SPRITE cTarget = null;
        short nSprite = Engine.headspritestat[6];
        while (nSprite >= 0) {
            int dist;
            pTarget = Engine.sprite[nSprite];
            pXTarget = DB.xsprite[pTarget.extra];
            if (Trigger.dudeCanSeeTarget(pXSprite, pDudeInfo, pTarget) && (dist = Trigger.getTargetDist(pSprite, pDudeInfo, pTarget)) >= minDist && dist <= maxDist) {
                int fineDist2;
                int fineDist1;
                if (pXSprite.target == pTarget.xvel) {
                    return pTarget;
                }
                if (!(!Actor.IsDudeSprite(pTarget) || pTarget.xvel == pSprite.xvel || Gameutils.IsPlayerSprite(pTarget) || Actor.IsBurningDude(pTarget) || !Actor.IsKillableDude(pTarget) || pTarget.owner == pSprite.xvel || teamMode == 1 && Trigger.isMateOf(pXSprite, pXTarget) || Trigger.isMatesHaveSameTarget(pXSprite, pTarget, 1) || data != 666 && pXTarget.data1 != data || pXSprite.target > 0 && (fineDist1 = Trigger.getFineTargetDist(pSprite, pDudeInfo, cTarget = Engine.sprite[pXSprite.target])) < (fineDist2 = Trigger.getFineTargetDist(pSprite, pDudeInfo, pTarget)))) {
                    return pTarget;
                }
            }
            nSprite = Engine.nextspritestat[nSprite];
        }
        return null;
    }

    public static boolean isActive(int nSprite) {
        AISTATEFUNC.Type type = DB.xsprite[Engine.sprite[nSprite].extra].aiState.getType();
        if (type == AISTATEFUNC.Type.idle) {
            return false;
        }
        if ((Globals.gFrameClock & 0x30) != 0) {
            if (type == AISTATEFUNC.Type.tgoto || type == AISTATEFUNC.Type.search) {
                return false;
            }
            return Ai.aiActive[nSprite] > 0;
        }
        return true;
    }

    public static boolean isAnnoyingUnit(SPRITE pDude) {
        switch (pDude.lotag) {
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 226: {
                return true;
            }
        }
        return false;
    }

    public static boolean unitCanFly(SPRITE pDude) {
        switch (pDude.lotag) {
            case 206: 
            case 207: 
            case 210: 
            case 219: {
                return true;
            }
        }
        return false;
    }

    public static boolean isMeleeUnit(SPRITE pDude) {
        switch (pDude.lotag) {
            case 203: 
            case 205: 
            case 206: 
            case 208: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 222: 
            case 224: 
            case 226: 
            case 244: 
            case 245: 
            case 250: 
            case 251: {
                return true;
            }
            case 254: {
                if (!AIUNICULT.dudeIsMelee(DB.xsprite[pDude.extra])) break;
                return true;
            }
        }
        return false;
    }

    public static SPRITE targetIsPlayer(XSPRITE pXSprite) {
        if (pXSprite.target >= 0 && Gameutils.IsPlayerSprite(Engine.sprite[pXSprite.target])) {
            return Engine.sprite[pXSprite.target];
        }
        return null;
    }

    public static boolean isTargetAimsDude(XSPRITE pXTarget, SPRITE pDude) {
        return pXTarget.target == pDude.xvel;
    }

    public static boolean isMateOf(XSPRITE pXDude, XSPRITE pXSprite) {
        return pXDude.rxID == pXSprite.rxID;
    }

    public static boolean getDudesForTargetChg(XSPRITE pXSprite) {
        for (int i = EVENT.bucketHead[pXSprite.txID]; i < EVENT.bucketHead[pXSprite.txID + 1]; ++i) {
            if (EVENT.rxBucket[i].type != 3 || !Actor.IsDudeSprite(Engine.sprite[EVENT.rxBucket[i].index]) || DB.xsprite[Engine.sprite[EVENT.rxBucket[i].index].extra].health <= 0) continue;
            return true;
        }
        return false;
    }

    public static XSPRITE affectedByTargetChg(XSPRITE pXDude) {
        if (pXDude.rxID <= 0 || pXDude.Locked == 1) {
            return null;
        }
        short nSprite = Engine.headspritestat[20];
        while (nSprite >= 0) {
            XSPRITE pXSprite;
            XSPRITE xSPRITE = pXSprite = Engine.sprite[nSprite].extra >= 0 ? DB.xsprite[Engine.sprite[nSprite].extra] : null;
            if (pXSprite != null && pXSprite.txID > 0 && pXSprite.state == 1) {
                for (int i = EVENT.bucketHead[pXSprite.txID]; i < EVENT.bucketHead[pXSprite.txID + 1]; ++i) {
                    if (EVENT.rxBucket[i].type != 3) continue;
                    SPRITE pSprite = Engine.sprite[EVENT.rxBucket[i].index];
                    if (pSprite.extra < 0 || !Actor.IsDudeSprite(pSprite) || pSprite.xvel != Engine.sprite[pXDude.reference].xvel) continue;
                    return pXSprite;
                }
            }
            nSprite = Engine.nextspritestat[nSprite];
        }
        return null;
    }

    public static int getDataFieldOfObject(int objType, int objIndex, int dataIndex) {
        int data = -65535;
        switch (objType) {
            case 3: {
                switch (dataIndex) {
                    case 1: {
                        return DB.xsprite[Engine.sprite[objIndex].extra].data1;
                    }
                    case 2: {
                        return DB.xsprite[Engine.sprite[objIndex].extra].data2;
                    }
                    case 3: {
                        return DB.xsprite[Engine.sprite[objIndex].extra].data3;
                    }
                    case 4: {
                        return DB.xsprite[Engine.sprite[objIndex].extra].data4;
                    }
                }
                return data;
            }
            case 6: {
                return DB.xsector[Engine.sector[objIndex].extra].data;
            }
            case 0: {
                return DB.xwall[Engine.wall[objIndex].extra].data;
            }
        }
        return data;
    }

    public static boolean setDataValueOfObject(int objType, int objIndex, int dataIndex, int value) {
        switch (objType) {
            case 3: {
                switch (dataIndex) {
                    case 1: {
                        DB.xsprite[Engine.sprite[objIndex].extra].data1 = (short)value;
                        return true;
                    }
                    case 2: {
                        DB.xsprite[Engine.sprite[objIndex].extra].data2 = (short)value;
                        return true;
                    }
                    case 3: {
                        DB.xsprite[Engine.sprite[objIndex].extra].data3 = (short)value;
                        return true;
                    }
                    case 4: {
                        DB.xsprite[Engine.sprite[objIndex].extra].data4 = (short)value;
                        return true;
                    }
                }
                return false;
            }
            case 6: {
                DB.xsector[Engine.sector[objIndex].extra].data = (short)value;
                return true;
            }
            case 0: {
                DB.xwall[Engine.wall[objIndex].extra].data = (short)value;
                return true;
            }
        }
        return false;
    }

    public static boolean goalValueIsReached(XSPRITE pXSprite) {
        for (int i = EVENT.bucketHead[pXSprite.txID]; i < EVENT.bucketHead[pXSprite.txID + 1]; ++i) {
            if (Trigger.getDataFieldOfObject(EVENT.rxBucket[i].type, EVENT.rxBucket[i].index, pXSprite.data1) == pXSprite.data3) continue;
            return false;
        }
        return true;
    }

    public static void activateDudes(int rx) {
        for (int i = EVENT.bucketHead[rx]; i < EVENT.bucketHead[rx + 1]; ++i) {
            if (EVENT.rxBucket[i].type != 3 || !Actor.IsDudeSprite(Engine.sprite[EVENT.rxBucket[i].index])) continue;
            Ai.aiInit(Engine.sprite[EVENT.rxBucket[i].index], false);
        }
    }

    public static SPRITE getMateTargets(XSPRITE pXSprite) {
        short rx = pXSprite.rxID;
        SPRITE pMate = null;
        XSPRITE pXMate = null;
        for (int i = EVENT.bucketHead[rx]; i < EVENT.bucketHead[rx + 1]; ++i) {
            if (EVENT.rxBucket[i].type != 3) continue;
            pMate = Engine.sprite[EVENT.rxBucket[i].index];
            if (pMate.extra < 0 || pMate.xvel == Engine.sprite[pXSprite.reference].xvel || !Actor.IsDudeSprite(pMate)) continue;
            pXMate = DB.xsprite[pMate.extra];
            if (pXMate.target <= -1 || Gameutils.IsPlayerSprite(Engine.sprite[pXMate.target])) continue;
            return Engine.sprite[pXMate.target];
        }
        return null;
    }

    public static boolean isMatesHaveSameTarget(XSPRITE pXLeader, SPRITE pTarget, int allow) {
        short rx = pXLeader.rxID;
        SPRITE pMate = null;
        XSPRITE pXMate = null;
        for (int i = EVENT.bucketHead[rx]; i < EVENT.bucketHead[rx + 1]; ++i) {
            if (EVENT.rxBucket[i].type != 3) continue;
            pMate = Engine.sprite[EVENT.rxBucket[i].index];
            if (pMate.extra < 0 || pMate.xvel == Engine.sprite[pXLeader.reference].xvel || !Actor.IsDudeSprite(pMate)) continue;
            pXMate = DB.xsprite[pMate.extra];
            if (pXMate.target != pTarget.xvel || allow-- > 0) continue;
            return true;
        }
        return false;
    }

    public static void trTextOver(int nMessage) {
        MapInfo pMap;
        if (nMessage >= 128) {
            Main.game.dassert("nMessage < kMaxMessages");
        }
        if (LEVELS.currentEpisode != null && (pMap = LEVELS.currentEpisode.gMapInfo[Globals.pGameInfo.nLevel]) != null && pMap.gMessage[nMessage] != null) {
            View.viewSetMessage(pMap.gMessage[nMessage], Globals.gPlayer[View.gViewIndex].nPlayer, 2);
        }
    }

    public static void FireballTrapCallback(int nXIndex) {
        int dz;
        int dx;
        int dy;
        XSPRITE pXSprite = DB.xsprite[nXIndex];
        int nSprite = pXSprite.reference;
        SPRITE pSprite = Engine.sprite[nSprite];
        if ((pSprite.cstat & 0x20) != 0) {
            dy = 0;
            dx = 0;
            dz = (pSprite.cstat & 8) != 0 ? 16384 : -16384;
        } else {
            dx = Trig.Cos(pSprite.ang) >> 16;
            dy = Trig.Sin(pSprite.ang) >> 16;
            dz = 0;
        }
        Actor.actFireMissile(pSprite, 0, 0, dx, dy, dz, 305);
    }

    public static void UniMissileTrapCallback(int nXIndex) {
        XSPRITE pXSprite = DB.xsprite[nXIndex];
        int dx = 0;
        int dy = 0;
        int dz = 0;
        SPRITE pSprite = Engine.sprite[pXSprite.reference];
        if (pXSprite.data1 < 300 || pXSprite.data1 >= 318) {
            return;
        }
        if ((pSprite.cstat & 0x20) != 0) {
            dz = (pSprite.cstat & 8) != 0 ? 16384 : -16384;
        } else {
            dx = Trig.Cos(pSprite.ang) >> 16;
            dy = Trig.Sin(pSprite.ang) >> 16;
            dz = pXSprite.data3 << 6;
            if (dz > 65536) {
                dz = 65536;
            } else if (dz < -65536) {
                dz = -65536;
            }
        }
        SPRITE pMissile = null;
        pMissile = Actor.actFireMissile(pSprite, 0, 0, dx, dy, dz, pXSprite.data1);
        if (pMissile != null) {
            if ((pSprite.hitag & 1) != 0) {
                pMissile.xrepeat = pSprite.xrepeat;
                pMissile.yrepeat = pSprite.yrepeat;
                pMissile.pal = pSprite.pal;
                pMissile.shade = pSprite.shade;
            }
            if (pXSprite.data2 > 0) {
                long velocity = pXSprite.data2 << 12;
                Actor.sprXVel[pMissile.xvel] = Pragmas.mulscale(dx, velocity, 14);
                Actor.sprYVel[pMissile.xvel] = Pragmas.mulscale(dy, velocity, 14);
                Actor.sprZVel[pMissile.xvel] = Pragmas.mulscale(dz, velocity, 14);
            }
            if (pMissile.lotag != 303 && pXSprite.data4 > 0) {
                EVENT.evPostCallback(pMissile.xvel, 3, pXSprite.data4 > 500 ? 500L : (long)(pXSprite.data4 - 1), 23);
            }
        }
    }

    public static void MGunOpenCallback(int nXIndex) {
        SeqHandling.seqSpawn(VERSION.getSeq(4), 3, nXIndex, SeqHandling.callbacks[3]);
    }

    public static void MGunFireCallback(int nXIndex) {
        XSPRITE pXSprite = DB.xsprite[nXIndex];
        int nSprite = pXSprite.reference;
        SPRITE pSprite = Engine.sprite[nSprite];
        if (pXSprite.data2 > 0 || pXSprite.data1 == 0) {
            if (pXSprite.data2 > 0) {
                pXSprite.data2 = (short)(pXSprite.data2 - 1);
                if (pXSprite.data2 == 0) {
                    EVENT.evPost(nSprite, 3, 1L, 0);
                }
            }
            int dx = (Trig.Cos(pSprite.ang) >> 16) + Gameutils.BiRandom(1000);
            int dy = (Trig.Sin(pSprite.ang) >> 16) + Gameutils.BiRandom(1000);
            int dz = Gameutils.BiRandom(1000);
            Actor.actFireVector(pSprite, 0, 0, dx, dy, dz, 2);
            SOUND.sfxStart3DSound(pSprite, 359, -1, 0);
        }
    }

    public static int getWave(XSECTOR pXSector, int nBusy) {
        short wave = pXSector.busy >= nBusy ? pXSector.waveTime[0] : pXSector.waveTime[1];
        return wave;
    }

    public static void InitGenerator(int nSprite) {
        short nXSprite;
        if (nSprite >= Globals.kMaxSprites) {
            Main.game.dassert("nSprite < kMaxSprites");
        }
        SPRITE pSprite = Engine.sprite[nSprite];
        if (pSprite.statnum == 1024) {
            Main.game.dassert("pSprite.statnum != kMaxStatus");
        }
        if ((nXSprite = pSprite.extra) <= 0) {
            Main.game.dassert("nXSprite > 0");
        }
        XSPRITE pXSprite = DB.xsprite[nXSprite];
        switch (pSprite.lotag) {
            case 33: {
                pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFFFE);
                pSprite.cstat = (short)(pSprite.cstat | 0x8000);
                if (pXSprite.busyTime <= 0) {
                    pXSprite.busyTime = (short)5;
                }
                if (pXSprite.state != pXSprite.restState) {
                    EVENT.evPost(nSprite, 3, 0L, 21);
                }
                return;
            }
            case 27: 
            case 37: 
            case 38: {
                pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFFFE);
                pSprite.cstat = (short)(pSprite.cstat | 0x8000);
                if (pXSprite.state != pXSprite.restState) {
                    EVENT.evPost(nSprite, 3, 0L, 21);
                }
                return;
            }
            case 39: {
                pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFFFE);
                if (pXSprite.state != pXSprite.restState) {
                    EVENT.evPost(nSprite, 3, 0L, 21);
                }
                return;
            }
            case 40: 
            case 80: {
                pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFFFE);
                pSprite.cstat = (short)(pSprite.cstat | 0x8000);
                if (pXSprite.state != pXSprite.restState) {
                    EVENT.evPost(nSprite, 3, 0L, 21);
                }
                return;
            }
            case 700: {
                pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFFFE);
                pSprite.cstat = (short)(pSprite.cstat | 0x8000);
                break;
            }
        }
        if (pXSprite.state != pXSprite.restState && pXSprite.busyTime > 0) {
            EVENT.evPost(nSprite, 3, (pXSprite.busyTime + Gameutils.BiRandom(pXSprite.data1)) * 120 / 10, 21);
        }
    }

    public static void ActivateGenerator(int nSprite) {
        short nXSprite;
        if (nSprite >= Globals.kMaxSprites) {
            Main.game.dassert("nSprite < kMaxSprites");
        }
        SPRITE pSprite = Engine.sprite[nSprite];
        if (pSprite.statnum == 1024) {
            Main.game.dassert("pSprite.statnum != kMaxStatus");
        }
        if ((nXSprite = pSprite.extra) <= 0) {
            Main.game.dassert("nXSprite > 0");
        }
        XSPRITE pXSprite = DB.xsprite[nXSprite];
        switch (pSprite.lotag) {
            case 40: 
            case 80: {
                if (pXSprite.dropMsg > 0) {
                    short nItem = Engine.headspritestat[3];
                    while (nItem >= 0) {
                        SPRITE pItem = Engine.sprite[nItem];
                        if (pItem.lotag == pXSprite.dropMsg && pItem.x == pSprite.x && pItem.y == pSprite.y && pItem.z == pSprite.z) {
                            Actor.actSpawnEffect(29, pSprite.sectnum, pSprite.x, pSprite.y, pSprite.z, 0);
                            DB.deletesprite(nItem);
                            break;
                        }
                        nItem = Engine.nextspritestat[nItem];
                    }
                }
                Actor.DropRandomPickupObject(pSprite, pXSprite.dropMsg);
                break;
            }
            case 701: {
                Gameutils.GetSpriteExtents(pSprite);
                Actor.actSpawnThing(pSprite.sectnum, pSprite.x, pSprite.y, Gameutils.extents_zBot, 423);
                break;
            }
            case 702: {
                Gameutils.GetSpriteExtents(pSprite);
                Actor.actSpawnThing(pSprite.sectnum, pSprite.x, pSprite.y, Gameutils.extents_zBot, 424);
                break;
            }
            case 708: {
                if (DEMO.IsOriginalDemo()) {
                    SOUND.sfxStart3DSound(pSprite, pXSprite.data2, -1, 0);
                    break;
                }
                long pitch = (long)pXSprite.data4 << 1;
                short volume = pXSprite.data3;
                SOUND.sfxStart3DSoundCP(pSprite, pXSprite.data2, -1, 0, pitch < 2000L ? 0L : pitch, volume);
                break;
            }
            case 704: {
                if (DEMO.IsOriginalDemo()) break;
                Trigger.UniMissileTrapCallback(nXSprite);
                break;
            }
            case 705: {
                break;
            }
            case 703: {
                switch (pXSprite.data2) {
                    case 0: {
                        Trigger.FireballTrapCallback(nXSprite);
                        break;
                    }
                    case 1: {
                        SeqHandling.seqSpawn(VERSION.getSeq(0), 3, nXSprite, SeqHandling.callbacks[4]);
                        break;
                    }
                    case 2: {
                        SeqHandling.seqSpawn(VERSION.getSeq(1), 3, nXSprite, SeqHandling.callbacks[4]);
                    }
                }
                break;
            }
            case 706: {
                Gameutils.GetSpriteExtents(pSprite);
                Actor.actSpawnEffect(23, pSprite.sectnum, pSprite.x, pSprite.y, Gameutils.extents_zTop, 0);
                break;
            }
            case 707: {
                Gameutils.GetSpriteExtents(pSprite);
                Actor.actSpawnEffect(26, pSprite.sectnum, pSprite.x, pSprite.y, Gameutils.extents_zTop, 0);
            }
        }
    }
}

