/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Types;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import java.io.FileNotFoundException;
import java.util.Arrays;
import ru.m210projects.Blood.EVENT;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.Types.BUSY;
import ru.m210projects.Blood.Types.BitHandler;
import ru.m210projects.Blood.Types.BloodIniFile;
import ru.m210projects.Blood.Types.GAMEINFO;
import ru.m210projects.Blood.Types.INPUT;
import ru.m210projects.Blood.Types.POSTPONE;
import ru.m210projects.Blood.Types.SPRITEHIT;
import ru.m210projects.Blood.Types.Seq.CeilingInst;
import ru.m210projects.Blood.Types.Seq.FloorInst;
import ru.m210projects.Blood.Types.Seq.MaskedWallInst;
import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.Types.Seq.SeqInst;
import ru.m210projects.Blood.Types.Seq.SpriteInst;
import ru.m210projects.Blood.Types.Seq.WallInst;
import ru.m210projects.Blood.Types.XSECTOR;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Blood.Types.XWALL;
import ru.m210projects.Blood.Types.ZONE;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.FileUtils;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.Hitscan;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.WALL;

public class SafeLoader {
    public short[] pskyoff = new short[256];
    public short pskybits;
    public int parallaxyscale;
    public short connecthead;
    public short[] connectpoint2 = new short[8];
    public int randomseed;
    public int visibility;
    public int parallaxvisibility;
    public byte automapping;
    public byte[] show2dsector = new byte[Globals.kMaxSectors + 7 >> 3];
    public byte[] show2dwall = new byte[Globals.kMaxWalls + 7 >> 3];
    public byte[] show2dsprite = new byte[Globals.kMaxSprites + 7 >> 3];
    public byte[] gotpic = new byte[Engine.MAXTILES + 7 >> 3];
    public byte[] gotsector = new byte[Globals.kMaxSectors + 7 >> 3];
    public Hitscan safeHitInfo;
    public short numsectors;
    public short numwalls;
    public short numsprites;
    public short[] headspritesect;
    public short[] headspritestat;
    public short[] prevspritesect;
    public short[] prevspritestat;
    public short[] nextspritesect;
    public short[] nextspritestat;
    public SECTOR[] sector = new SECTOR[Globals.kMaxSectors];
    public WALL[] wall = new WALL[Globals.kMaxWalls];
    public SPRITE[] sprite = new SPRITE[Globals.kMaxSprites];
    public Vector2[] kwall = new Vector2[8192];
    public Vector3[] ksprite = new Vector3[Globals.kMaxSprites];
    public int[] secFloorZ = new int[Globals.kMaxSectors];
    public int[] secCeilZ = new int[Globals.kMaxSectors];
    public int[] secPath = new int[Globals.kMaxSectors];
    public long[] sprXVel = new long[Globals.kMaxSprites];
    public long[] sprYVel = new long[Globals.kMaxSprites];
    public long[] sprZVel = new long[Globals.kMaxSprites];
    public long[] floorVel = new long[Globals.kMaxSectors];
    public long[] ceilingVel = new long[Globals.kMaxSectors];
    public short[] nStatSize = new short[1025];
    public XSPRITE[] xsprite = new XSPRITE[2048];
    public XWALL[] xwall = new XWALL[512];
    public XSECTOR[] xsector = new XSECTOR[512];
    public int[] nextXSprite = new int[2048];
    public int[] nextXWall = new int[512];
    public int[] nextXSector = new int[512];
    public GAMEINFO safeGameInfo = new GAMEINFO();
    public boolean showinvisibility;
    public boolean gNoClip;
    public boolean gFogMode;
    public boolean gFullMap;
    public boolean gPaused;
    public boolean gInfiniteAmmo;
    public boolean cheatsOn;
    public int gSkyCount;
    public int gFrameClock;
    public int gTicks;
    public int gFrame;
    public int gGameClock;
    public int[] cumulDamage = new int[2048];
    public int[] gDudeSlope = new int[2048];
    public ZONE[] gStartZone = new ZONE[8];
    public int[] gUpperLink = new int[Globals.kMaxSectors];
    public int[] gLowerLink = new int[Globals.kMaxSectors];
    public int mirrorcnt;
    public int[] MirrorType = new int[16];
    public int[] MirrorX = new int[16];
    public int[] MirrorY = new int[16];
    public int[] MirrorZ = new int[16];
    public int[] MirrorLower = new int[16];
    public int[] MirrorUpper = new int[16];
    public int MirrorSector;
    public int[] MirrorWall = new int[4];
    public SeqInst[] siWall = new SeqInst[512];
    public SeqInst[] siMasked = new SeqInst[512];
    public SeqInst[] siCeiling = new SeqInst[512];
    public SeqInst[] siFloor = new SeqInst[512];
    public SeqInst[] siSprite = new SeqInst[2048];
    public short[] actListIndex = new short[SeqHandling.kMaxSequences];
    public byte[] actListType = new byte[SeqHandling.kMaxSequences];
    public int activeCount;
    public int[] rxBucketIndex = new int[4096];
    public int[] rxBucketType = new int[4096];
    public short[] bucketHead = new short[1025];
    public int[] qEventEvent = new int[1025];
    public int[] qEventPriority = new int[1025];
    public int fNodeCount;
    public int gBusyCount = 0;
    public BUSY[] gBusy = new BUSY[128];
    public int[] nTeamCount = new int[8];
    public int gNetPlayers;
    public byte[] autoaim = new byte[8];
    public byte[] slopetilt = new byte[8];
    public byte[] skill = new byte[8];
    public String[] name = new String[8];
    public PLAYER[] safePlayer = new PLAYER[8];
    public SPRITEHIT[] gSpriteHit = new SPRITEHIT[2048];
    public int[] gWallExp = new int[Globals.kMaxWalls];
    public int[] gSectorExp = new int[Globals.kMaxSectors];
    public byte[] gSpriteExp = new byte[Globals.kMaxSectors + 7 >> 3];
    public POSTPONE[] gPost = new POSTPONE[Globals.kMaxSprites];
    public int gPostCount;
    public int gNextMap;
    public int foundSecret;
    public int totalSecrets;
    public int superSecrets;
    public int totalKills;
    public int kills;
    public int deliriumTilt = 0;
    public int deliriumTurn = 0;
    public int deliriumPitch = 0;
    public boolean gUserEpisode;
    public boolean gForceMap;
    public BloodIniFile addon;
    public String addonFileName;
    private String message;

    public SafeLoader() {
        int i;
        this.headspritesect = new short[Engine.MAXSECTORS + 1];
        this.headspritestat = new short[1025];
        this.prevspritesect = new short[Engine.MAXSPRITES];
        this.prevspritestat = new short[Engine.MAXSPRITES];
        this.nextspritesect = new short[Engine.MAXSPRITES];
        this.nextspritestat = new short[Engine.MAXSPRITES];
        for (i = 0; i < Engine.MAXSPRITES; ++i) {
            this.sprite[i] = new SPRITE();
        }
        for (i = 0; i < Engine.MAXSECTORS; ++i) {
            this.sector[i] = new SECTOR();
        }
        for (i = 0; i < Globals.kMaxWalls; ++i) {
            this.wall[i] = new WALL();
        }
        for (i = 0; i < 8192; ++i) {
            this.kwall[i] = new Vector2();
        }
        for (i = 0; i < Globals.kMaxSprites; ++i) {
            this.ksprite[i] = new Vector3();
            this.gPost[i] = new POSTPONE();
        }
        for (i = 0; i < 2048; ++i) {
            this.xsprite[i] = new XSPRITE();
            this.gSpriteHit[i] = new SPRITEHIT();
        }
        for (i = 0; i < 512; ++i) {
            this.xwall[i] = new XWALL();
        }
        for (i = 0; i < 512; ++i) {
            this.xsector[i] = new XSECTOR();
        }
        for (i = 0; i < 8; ++i) {
            this.gStartZone[i] = new ZONE();
            this.safePlayer[i] = new PLAYER();
        }
        for (i = 0; i < 512; ++i) {
            this.siWall[i] = new WallInst();
        }
        for (i = 0; i < 512; ++i) {
            this.siMasked[i] = new MaskedWallInst();
        }
        for (i = 0; i < 512; ++i) {
            this.siCeiling[i] = new CeilingInst();
        }
        for (i = 0; i < 512; ++i) {
            this.siFloor[i] = new FloorInst();
        }
        for (i = 0; i < 2048; ++i) {
            this.siSprite[i] = new SpriteInst();
        }
        for (i = 0; i < 128; ++i) {
            this.gBusy[i] = new BUSY();
        }
        this.safeHitInfo = new Hitscan();
    }

    public String getMessage() {
        return this.message;
    }

    public boolean load(Resource bb, int nVersion) {
        this.addon = null;
        this.addonFileName = null;
        this.message = null;
        this.gUserEpisode = false;
        try {
            int i;
            for (i = 0; i < 8192; ++i) {
                this.kwall[i].set(0.0f, 0.0f);
            }
            for (i = 0; i < Globals.kMaxSprites; ++i) {
                this.ksprite[i].set(0.0f, 0.0f, 0.0f);
            }
            Arrays.fill(this.gotpic, (byte)0);
            for (i = 0; i < 8; ++i) {
                this.autoaim[i] = -1;
                this.slopetilt[i] = -1;
                this.skill[i] = -1;
                this.name[i] = null;
            }
            if (nVersion == 256) {
                bb.seek(0L, Resource.Whence.Set);
                this.MyLoad100(bb);
                this.DudesLoad(bb);
                this.WarpLoad(bb);
                this.MirrorLoad(bb);
                this.SeqLoad(bb, nVersion);
                this.EventLoad(bb);
                this.TriggersLoad(bb);
                this.PlayersLoad(bb, nVersion);
                this.ActorsLoad(bb);
                bb.readShort();
                this.GameInfoLoad(bb);
                this.StatsLoad(bb);
                this.ScreenLoad(bb);
            } else {
                if (nVersion >= 300) {
                    bb.seek(64043L, Resource.Whence.Set);
                    this.LoadGDXBlock(bb);
                }
                this.MyLoad110(nVersion, bb);
                this.DudesLoad(bb);
                this.cheatsOn = bb.readBoolean();
                this.WarpLoad(bb);
                this.MirrorLoad(bb);
                this.SeqLoad(bb, nVersion);
                this.EventLoad(bb);
                this.TriggersLoad(bb);
                this.PlayersLoad(bb, 277);
                this.ActorsLoad(bb);
                this.GameInfoLoad(bb);
                this.StatsLoad(bb);
                this.ScreenLoad(bb);
            }
            if (this.gUserEpisode) {
                this.addon = LEVELS.levelGetEpisode(this.addonFileName);
                if (this.addon == null) {
                    this.message = "Can't find user episode file: " + this.addonFileName;
                    this.gUserEpisode = false;
                    this.safeGameInfo.nEpisode = 0;
                    this.safeGameInfo.nLevel = 16;
                    this.gForceMap = true;
                }
            }
            if (bb.position() == bb.size()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void MyLoad100(Resource bb) {
        int i;
        int i2;
        int kMaxTiles = 4096;
        this.LoadGameInfo(bb);
        this.gFrameClock = bb.readInt();
        this.gTicks = bb.readInt();
        this.gFrame = bb.readInt();
        this.gGameClock = bb.readInt();
        this.gPaused = bb.readBoolean();
        bb.readByte();
        for (i2 = 0; i2 < 8192; ++i2) {
            this.kwall[i2].x = bb.readInt().intValue();
            this.kwall[i2].y = bb.readInt().intValue();
        }
        for (i2 = 0; i2 < Globals.kMaxSprites; ++i2) {
            this.ksprite[i2].x = bb.readInt().intValue();
            this.ksprite[i2].y = bb.readInt().intValue();
            this.ksprite[i2].z = bb.readInt().intValue();
        }
        for (i2 = 0; i2 < Globals.kMaxSectors; ++i2) {
            this.secFloorZ[i2] = bb.readInt();
        }
        for (i2 = 0; i2 < Globals.kMaxSectors; ++i2) {
            this.secCeilZ[i2] = bb.readInt();
        }
        for (i2 = 0; i2 < Globals.kMaxSectors; ++i2) {
            this.floorVel[i2] = bb.readInt().intValue();
        }
        for (i2 = 0; i2 < Globals.kMaxSectors; ++i2) {
            this.ceilingVel[i2] = bb.readInt().intValue();
        }
        this.safeHitInfo.hitsect = bb.readShort();
        this.safeHitInfo.hitwall = bb.readShort();
        this.safeHitInfo.hitsprite = bb.readShort();
        this.safeHitInfo.hitx = bb.readInt();
        this.safeHitInfo.hity = bb.readInt();
        this.safeHitInfo.hitz = bb.readInt();
        this.gForceMap = bb.readBoolean();
        for (i2 = 0; i2 <= 1024; ++i2) {
            this.nStatSize[i2] = bb.readShort();
        }
        byte[] buf = new byte[56];
        for (i = 0; i < 2048; ++i) {
            bb.read(buf);
            this.xsprite[i].init(buf);
            this.xsprite[i].reference = BitHandler.bsread(buf, 0, 0, 13);
        }
        buf = new byte[XWALL.sizeof];
        for (i = 0; i < 512; ++i) {
            bb.read(buf);
            this.xwall[i].init(buf);
            this.xwall[i].reference = BitHandler.bsread(buf, 0, 0, 13);
        }
        buf = new byte[XSECTOR.sizeof];
        for (i = 0; i < 512; ++i) {
            bb.read(buf);
            this.xsector[i].init(buf);
            this.xsector[i].reference = BitHandler.bsread(buf, 0, 0, 13);
        }
        for (i = 0; i < Globals.kMaxSprites; ++i) {
            this.sprXVel[i] = bb.readInt().intValue();
        }
        for (i = 0; i < Globals.kMaxSprites; ++i) {
            this.sprYVel[i] = bb.readInt().intValue();
        }
        for (i = 0; i < Globals.kMaxSprites; ++i) {
            this.sprZVel[i] = bb.readInt().intValue();
        }
        for (i = 0; i < 2048; ++i) {
            this.nextXSprite[i] = bb.readShort().shortValue();
        }
        for (i = 0; i < 512; ++i) {
            this.nextXWall[i] = bb.readShort().shortValue();
        }
        for (i = 0; i < 512; ++i) {
            this.nextXSector[i] = bb.readShort().shortValue();
        }
        bb.readInt();
        bb.readInt();
        this.gSkyCount = bb.readInt();
        this.gFogMode = bb.readBoolean();
        for (i = 0; i < Globals.kMaxSectors; ++i) {
            this.sector[i].buildSector(bb);
        }
        for (i = 0; i < 8192; ++i) {
            this.wall[i].buildWall(bb);
        }
        for (i = 0; i < Globals.kMaxSprites; ++i) {
            this.sprite[i].buildSprite(bb);
        }
        this.numsectors = bb.readShort();
        this.numwalls = bb.readShort();
        this.randomseed = bb.readInt();
        bb.readByte();
        this.showinvisibility = bb.readBoolean();
        bb.readInt();
        this.parallaxyscale = bb.readInt();
        this.visibility = bb.readInt();
        this.parallaxvisibility = bb.readInt();
        for (i = 0; i < 256; ++i) {
            this.pskyoff[i] = bb.readShort();
        }
        this.pskybits = bb.readShort();
        for (i = 0; i <= Globals.kMaxSectors; ++i) {
            this.headspritesect[i] = bb.readShort();
        }
        for (i = 0; i <= 1024; ++i) {
            this.headspritestat[i] = bb.readShort();
        }
        for (i = 0; i < Globals.kMaxSprites; ++i) {
            this.prevspritesect[i] = bb.readShort();
        }
        for (i = 0; i < Globals.kMaxSprites; ++i) {
            this.prevspritestat[i] = bb.readShort();
        }
        for (i = 0; i < Globals.kMaxSprites; ++i) {
            this.nextspritesect[i] = bb.readShort();
        }
        for (i = 0; i < Globals.kMaxSprites; ++i) {
            this.nextspritestat[i] = bb.readShort();
        }
        for (i = 0; i < Globals.kMaxSectors + 7 >> 3; ++i) {
            this.show2dsector[i] = bb.readByte();
        }
        for (i = 0; i < 1024; ++i) {
            this.show2dwall[i] = bb.readByte();
        }
        for (i = 0; i < Globals.kMaxSprites + 7 >> 3; ++i) {
            this.show2dsprite[i] = bb.readByte();
        }
        this.automapping = bb.readByte();
        for (i = 0; i < kMaxTiles + 7 >> 3; ++i) {
            this.gotpic[i] = bb.readByte();
        }
        for (i = 0; i < Globals.kMaxSectors + 7 >> 3; ++i) {
            this.gotsector[i] = bb.readByte();
        }
        this.safeGameInfo.nEnemyDamage = this.safeGameInfo.nDifficulty;
        this.safeGameInfo.nEnemyQuantity = this.safeGameInfo.nDifficulty;
        this.safeGameInfo.nPitchforkOnly = false;
        this.gInfiniteAmmo = false;
        this.cheatsOn = false;
    }

    public void MyLoad110(int nVersion, Resource bb) {
        int i;
        int i2;
        int kMaxTiles = 6144;
        this.LoadGameInfo(bb);
        this.numsectors = bb.readShort();
        this.numwalls = bb.readShort();
        int tmp = bb.readInt();
        this.numsprites = (short)tmp;
        for (i2 = 0; i2 < this.numsectors; ++i2) {
            this.sector[i2].buildSector(bb);
        }
        for (i2 = 0; i2 < this.numwalls; ++i2) {
            this.wall[i2].buildWall(bb);
        }
        for (i2 = 0; i2 < Globals.kMaxSprites; ++i2) {
            this.sprite[i2].buildSprite(bb);
        }
        this.randomseed = bb.readInt();
        bb.readByte();
        this.showinvisibility = bb.readBoolean();
        bb.readInt();
        this.parallaxyscale = bb.readInt();
        this.visibility = bb.readInt();
        this.parallaxvisibility = bb.readInt();
        for (i2 = 0; i2 < 256; ++i2) {
            this.pskyoff[i2] = bb.readShort();
        }
        this.pskybits = bb.readShort();
        for (i2 = 0; i2 <= Globals.kMaxSectors; ++i2) {
            this.headspritesect[i2] = bb.readShort();
        }
        for (i2 = 0; i2 <= 1024; ++i2) {
            this.headspritestat[i2] = bb.readShort();
        }
        for (i2 = 0; i2 < Globals.kMaxSprites; ++i2) {
            this.prevspritesect[i2] = bb.readShort();
        }
        for (i2 = 0; i2 < Globals.kMaxSprites; ++i2) {
            this.prevspritestat[i2] = bb.readShort();
        }
        for (i2 = 0; i2 < Globals.kMaxSprites; ++i2) {
            this.nextspritesect[i2] = bb.readShort();
        }
        for (i2 = 0; i2 < Globals.kMaxSprites; ++i2) {
            this.nextspritestat[i2] = bb.readShort();
        }
        for (i2 = 0; i2 < Globals.kMaxSectors + 7 >> 3; ++i2) {
            this.show2dsector[i2] = bb.readByte();
        }
        for (i2 = 0; i2 < 1024; ++i2) {
            this.show2dwall[i2] = bb.readByte();
        }
        for (i2 = 0; i2 < Globals.kMaxSprites + 7 >> 3; ++i2) {
            this.show2dsprite[i2] = bb.readByte();
        }
        this.automapping = bb.readByte();
        for (i2 = 0; i2 < kMaxTiles + 7 >> 3; ++i2) {
            this.gotpic[i2] = bb.readByte();
        }
        for (i2 = 0; i2 < Globals.kMaxSectors + 7 >> 3; ++i2) {
            this.gotsector[i2] = bb.readByte();
        }
        this.gFrameClock = bb.readInt();
        this.gTicks = bb.readInt();
        this.gFrame = bb.readInt();
        this.gGameClock = bb.readInt();
        this.gPaused = bb.readBoolean();
        bb.readByte();
        for (i2 = 0; i2 < this.numwalls; ++i2) {
            this.kwall[i2].x = bb.readInt().intValue();
            this.kwall[i2].y = bb.readInt().intValue();
        }
        for (i2 = 0; i2 < this.numsprites; ++i2) {
            int x = bb.readInt();
            int y = bb.readInt();
            int z = bb.readInt();
            if (i2 >= Globals.kMaxSprites) continue;
            this.ksprite[i2].x = x;
            this.ksprite[i2].y = y;
            this.ksprite[i2].z = z;
        }
        for (i2 = 0; i2 < this.numsectors; ++i2) {
            this.secFloorZ[i2] = bb.readInt();
        }
        for (i2 = 0; i2 < this.numsectors; ++i2) {
            this.secCeilZ[i2] = bb.readInt();
        }
        for (i2 = 0; i2 < this.numsectors; ++i2) {
            this.floorVel[i2] = bb.readInt().intValue();
        }
        for (i2 = 0; i2 < this.numsectors; ++i2) {
            this.ceilingVel[i2] = bb.readInt().intValue();
        }
        this.safeHitInfo.hitsect = bb.readShort();
        this.safeHitInfo.hitwall = bb.readShort();
        this.safeHitInfo.hitsprite = bb.readShort();
        this.safeHitInfo.hitx = bb.readInt();
        this.safeHitInfo.hity = bb.readInt();
        this.safeHitInfo.hitz = bb.readInt();
        this.gForceMap = bb.readBoolean();
        bb.readByte();
        bb.readByte();
        byte[] buf = new byte[128];
        bb.read(buf, 0, 128);
        for (i = 0; i <= 1024; ++i) {
            this.nStatSize[i] = bb.readShort();
        }
        for (i = 0; i < 2048; ++i) {
            this.nextXSprite[i] = bb.readShort().shortValue();
        }
        for (i = 0; i < 512; ++i) {
            this.nextXWall[i] = bb.readShort().shortValue();
        }
        for (i = 0; i < 512; ++i) {
            this.nextXSector[i] = bb.readShort().shortValue();
        }
        for (i = 0; i < 2048; ++i) {
            this.xsprite[i].free();
        }
        buf = new byte[56];
        for (i = 0; i < Globals.kMaxSprites; ++i) {
            if (this.sprite[i].statnum >= 1024 || this.sprite[i].extra <= 0) continue;
            bb.read(buf);
            this.xsprite[this.sprite[i].extra].init(buf);
            this.xsprite[this.sprite[i].extra].reference = BitHandler.bsread(buf, 0, 0, 13);
        }
        for (i = 0; i < 512; ++i) {
            this.xwall[i].free();
        }
        buf = new byte[XWALL.sizeof];
        for (i = 0; i < this.numwalls; ++i) {
            if (this.wall[i].extra <= 0) continue;
            bb.read(buf);
            this.xwall[this.wall[i].extra].init(buf);
            this.xwall[this.wall[i].extra].reference = BitHandler.bsread(buf, 0, 0, 13);
        }
        for (i = 0; i < 512; ++i) {
            this.xsector[i].free();
        }
        buf = new byte[XSECTOR.sizeof];
        for (i = 0; i < this.numsectors; ++i) {
            if (this.sector[i].extra <= 0) continue;
            bb.read(buf);
            this.xsector[this.sector[i].extra].init(buf);
            this.xsector[this.sector[i].extra].reference = BitHandler.bsread(buf, 0, 0, 13);
        }
        Arrays.fill(this.sprXVel, 0L);
        Arrays.fill(this.sprYVel, 0L);
        Arrays.fill(this.sprZVel, 0L);
        for (i = 0; i < this.numsprites; ++i) {
            int xvel = bb.readInt();
            if (i >= Globals.kMaxSprites) continue;
            this.sprXVel[i] = xvel;
        }
        for (i = 0; i < this.numsprites; ++i) {
            int yvel = bb.readInt();
            if (i >= Globals.kMaxSprites) continue;
            this.sprYVel[i] = yvel;
        }
        for (i = 0; i < this.numsprites; ++i) {
            int zvel = bb.readInt();
            if (i >= Globals.kMaxSprites) continue;
            this.sprZVel[i] = zvel;
        }
        bb.readInt();
        bb.readInt();
        this.gSkyCount = bb.readInt();
        this.gFogMode = bb.readBoolean();
        if (this.numsprites >= Globals.kMaxSprites) {
            this.numsprites = (short)(Globals.kMaxSprites - 1);
        }
        this.gNoClip = false;
        this.gFullMap = false;
        if (nVersion < 300) {
            this.safeGameInfo.nEnemyDamage = this.safeGameInfo.nDifficulty;
            this.safeGameInfo.nEnemyQuantity = this.safeGameInfo.nDifficulty;
            this.safeGameInfo.nPitchforkOnly = false;
            this.gInfiniteAmmo = false;
        }
    }

    public void LoadGameInfo(Resource bb) {
        this.safeGameInfo.nGameType = bb.readByte() & 0xFF;
        this.safeGameInfo.nDifficulty = bb.readByte() & 0xFF;
        this.safeGameInfo.nEpisode = bb.readInt();
        this.safeGameInfo.nLevel = bb.readInt();
        byte[] buf = new byte[144];
        bb.read(buf);
        String name = new String(buf).trim();
        name = Strhandler.toLowerCase(name);
        if (FileUtils.isExtension(name, "map")) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        this.safeGameInfo.zLevelName = name;
        bb.read(buf);
        this.safeGameInfo.zLevelSong = new String(buf).trim();
        this.safeGameInfo.nTrackNumber = bb.readInt();
        buf = new byte[16];
        bb.read(buf);
        bb.read(buf);
        bb.readShort();
        bb.readInt();
        this.safeGameInfo.uMapCRC = bb.readInt().intValue();
        this.safeGameInfo.nMonsterSettings = bb.readByte() & 0xFF;
        this.safeGameInfo.uGameFlags = bb.readInt();
        this.safeGameInfo.uNetGameFlags = bb.readInt();
        this.safeGameInfo.nWeaponSettings = bb.readByte() & 0xFF;
        this.safeGameInfo.nItemSettings = bb.readByte() & 0xFF;
        this.safeGameInfo.nRespawnSettings = bb.readByte() & 0xFF;
        this.safeGameInfo.nTeamSettings = bb.readByte() & 0xFF;
        this.safeGameInfo.nMonsterRespawnTime = bb.readInt();
        this.safeGameInfo.nWeaponRespawnTime = bb.readInt();
        this.safeGameInfo.nItemRespawnTime = bb.readInt();
        this.safeGameInfo.nSpecialRespawnTime = bb.readInt();
    }

    public void DudesLoad(Resource bb) {
        int i;
        for (i = 0; i < 2048; ++i) {
            this.cumulDamage[i] = 0;
            bb.readInt();
        }
        for (i = 0; i < 2048; ++i) {
            this.gDudeSlope[i] = bb.readInt();
        }
    }

    public void WarpLoad(Resource bb) {
        int i;
        for (i = 0; i < 8; ++i) {
            this.gStartZone[i].x = bb.readInt().intValue();
            this.gStartZone[i].y = bb.readInt().intValue();
            this.gStartZone[i].z = bb.readInt().intValue();
            this.gStartZone[i].sector = bb.readShort();
            this.gStartZone[i].angle = bb.readShort();
        }
        for (i = 0; i < Globals.kMaxSectors; ++i) {
            this.gUpperLink[i] = bb.readShort().shortValue();
        }
        for (i = 0; i < Globals.kMaxSectors; ++i) {
            this.gLowerLink[i] = bb.readShort().shortValue();
        }
    }

    public void MirrorLoad(Resource bb) {
        int i;
        this.mirrorcnt = bb.readInt();
        this.MirrorSector = bb.readInt();
        for (i = 0; i < 16; ++i) {
            this.MirrorType[i] = bb.readShort().shortValue();
            bb.readShort();
            this.MirrorLower[i] = bb.readInt();
            this.MirrorX[i] = bb.readInt();
            this.MirrorY[i] = bb.readInt();
            this.MirrorZ[i] = bb.readInt();
            this.MirrorUpper[i] = bb.readInt();
        }
        for (i = 0; i < 4; ++i) {
            this.MirrorWall[i] = bb.readInt();
        }
    }

    public void SeqLoad(Resource bb, int nVersion) throws FileNotFoundException {
        int i;
        int i2;
        for (i2 = 0; i2 < 512; ++i2) {
            this.siWall[i2].load(bb);
        }
        for (i2 = 0; i2 < 512; ++i2) {
            this.siMasked[i2].load(bb);
        }
        for (i2 = 0; i2 < 512; ++i2) {
            this.siCeiling[i2].load(bb);
        }
        for (i2 = 0; i2 < 512; ++i2) {
            this.siFloor[i2].load(bb);
        }
        for (i2 = 0; i2 < 2048; ++i2) {
            this.siSprite[i2].load(bb);
        }
        int len = SeqHandling.kMaxSequences;
        if (nVersion < 302) {
            len = 1024;
        }
        Arrays.fill(this.actListType, (byte)0);
        Arrays.fill(this.actListIndex, (short)0);
        for (i = 0; i < len; ++i) {
            this.actListType[i] = bb.readByte();
            this.actListIndex[i] = bb.readShort();
        }
        this.activeCount = bb.readInt();
        for (i = 0; i < this.activeCount; ++i) {
            SeqInst pInst = this.GetInstance(this.actListType[i], this.actListIndex[i]);
            if (!pInst.isPlaying() || BuildGdx.cache.contains(pInst.getSeqIndex(), "SEQ")) continue;
            throw new FileNotFoundException("hSeq != null, id=" + pInst.getSeqIndex() + " \n\rWrong Blood.RFF version or file corrupt!");
        }
    }

    public SeqInst GetInstance(int type, int nXIndex) {
        switch (type) {
            case 0: {
                if (nXIndex <= 0 || nXIndex >= 512) {
                    return null;
                }
                return this.siWall[nXIndex];
            }
            case 1: {
                if (nXIndex <= 0 || nXIndex >= 512) {
                    return null;
                }
                return this.siCeiling[nXIndex];
            }
            case 2: {
                if (nXIndex <= 0 || nXIndex >= 512) {
                    return null;
                }
                return this.siFloor[nXIndex];
            }
            case 3: {
                if (nXIndex <= 0 || nXIndex >= 2048) {
                    return null;
                }
                return this.siSprite[nXIndex];
            }
            case 4: {
                if (nXIndex <= 0 || nXIndex >= 512) {
                    return null;
                }
                return this.siMasked[nXIndex];
            }
        }
        return null;
    }

    public void EventLoad(Resource bb) {
        int i;
        for (i = 0; i < 1025; ++i) {
            this.qEventPriority[i] = bb.readInt();
            this.qEventEvent[i] = bb.readInt();
        }
        this.fNodeCount = bb.readInt();
        for (i = 0; i < 4096; ++i) {
            int data = bb.readInt();
            this.rxBucketIndex[i] = EVENT.getIndex(data);
            this.rxBucketType[i] = EVENT.getType(data);
        }
        for (i = 0; i <= 1024; ++i) {
            this.bucketHead[i] = bb.readShort();
        }
    }

    public void TriggersLoad(Resource bb) {
        int i;
        this.gBusyCount = bb.readInt();
        for (i = 0; i < 128; ++i) {
            this.gBusy[i].nIndex = bb.readInt();
            this.gBusy[i].nDelta = bb.readInt();
            this.gBusy[i].nBusy = bb.readInt();
            this.gBusy[i].busyProc = bb.readByte() & 0xFF;
        }
        for (i = 0; i < Globals.kMaxSectors; ++i) {
            this.secPath[i] = bb.readInt();
        }
    }

    public void PlayersLoad(Resource bb, int nVersion) {
        int i;
        for (i = 0; i < 8; ++i) {
            this.nTeamCount[i] = bb.readInt();
        }
        this.gNetPlayers = bb.readInt();
        for (i = 0; i < this.gNetPlayers - 1; ++i) {
            this.connectpoint2[i] = (short)(i + 1);
        }
        this.connectpoint2[this.gNetPlayers - 1] = -1;
        byte[] plname = new byte[15];
        for (int i2 = 0; i2 < 8; ++i2) {
            this.autoaim[i2] = bb.readByte();
            if (nVersion >= 302) {
                this.slopetilt[i2] = bb.readByte();
            }
            this.skill[i2] = bb.readByte();
            bb.read(plname);
            this.name[i2] = new String(plname).trim();
        }
        byte[] input = new byte[INPUT.sizeof(nVersion)];
        for (int i3 = 0; i3 < 8; ++i3) {
            bb.readInt();
            bb.readInt();
            bb.readInt();
            bb.read(input);
            this.safePlayer[i3].pInput = new INPUT(input, nVersion);
            this.safePlayer[i3].set(bb, nVersion);
        }
    }

    public void ActorsLoad(Resource bb) {
        int i;
        for (i = 0; i < 2048; ++i) {
            this.gSpriteHit[i].moveHit = bb.readInt();
            this.gSpriteHit[i].ceilHit = bb.readInt();
            this.gSpriteHit[i].floorHit = bb.readInt();
        }
        for (i = 0; i < Globals.kMaxSectors; ++i) {
            this.gSectorExp[i] = bb.readShort().shortValue();
        }
        for (i = 0; i < 512; ++i) {
            this.gWallExp[i] = bb.readShort().shortValue();
        }
        this.gPostCount = bb.readInt();
        for (i = 0; i < Globals.kMaxSprites; ++i) {
            this.gPost[i].nSprite = bb.readShort();
            this.gPost[i].nStatus = bb.readShort();
        }
    }

    public void GameInfoLoad(Resource bb) {
        this.gNextMap = bb.readInt();
        bb.readShort();
        this.LoadGameInfo(bb);
        bb.readByte();
        bb.readByte();
    }

    public void StatsLoad(Resource bb) {
        this.totalSecrets = bb.readInt();
        this.foundSecret = bb.readInt();
        this.superSecrets = bb.readInt();
        this.totalKills = bb.readInt();
        this.kills = bb.readInt();
    }

    public void ScreenLoad(Resource bb) {
        bb.readInt();
        byte[] buf = new byte[256];
        bb.read(buf);
        bb.readShort();
        bb.readShort();
        bb.readInt();
        this.deliriumTilt = bb.readInt();
        this.deliriumTurn = bb.readInt();
        this.deliriumPitch = bb.readInt();
    }

    public void LoadUserEpisodeInfo(Resource bb) {
        this.gUserEpisode = bb.readBoolean();
        if (this.gUserEpisode) {
            byte[] buf = new byte[144];
            bb.read(buf);
            this.addonFileName = Strhandler.toLowerCase(new String(buf).trim());
        }
    }

    public void LoadGDXBlock(Resource bb) {
        this.LoadUserEpisodeInfo(bb);
        byte[] data = new byte[128];
        bb.read(data);
        int pos = 0;
        this.safeGameInfo.nEnemyDamage = data[pos++];
        this.safeGameInfo.nEnemyQuantity = data[pos++];
        this.safeGameInfo.nDifficulty = data[pos++];
        this.safeGameInfo.nPitchforkOnly = data[pos++] == 1;
        this.gInfiniteAmmo = data[pos++] == 1;
    }

    public BloodIniFile LoadGDXHeader(Resource fil) {
        this.addon = null;
        this.addonFileName = null;
        this.message = null;
        this.gUserEpisode = false;
        this.safeGameInfo.nDifficulty = -1;
        this.safeGameInfo.nEpisode = -1;
        this.safeGameInfo.nLevel = -1;
        try {
            fil.seek(64043L, Resource.Whence.Set);
            this.LoadUserEpisodeInfo(fil);
            fil.seek(128L, Resource.Whence.Current);
            this.LoadGameInfo(fil);
            if (this.gUserEpisode) {
                this.addon = LEVELS.levelGetEpisode(this.addonFileName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.addon;
    }
}

