/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Types.Seq;

import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.EVENT;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.Trigger;
import ru.m210projects.Blood.Types.CALLPROC;
import ru.m210projects.Blood.Types.Seq.ActiveList;
import ru.m210projects.Blood.Types.Seq.CeilingInst;
import ru.m210projects.Blood.Types.Seq.FloorInst;
import ru.m210projects.Blood.Types.Seq.MaskedWallInst;
import ru.m210projects.Blood.Types.Seq.SeqInst;
import ru.m210projects.Blood.Types.Seq.SeqType;
import ru.m210projects.Blood.Types.Seq.SpriteInst;
import ru.m210projects.Blood.Types.Seq.WallInst;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.OnSceenDisplay.Console;

public class SeqHandling {
    public static final int kMaxSequences = Globals.kMaxSprites;
    public static WallInst[] siWall = new WallInst[512];
    public static MaskedWallInst[] siMasked = new MaskedWallInst[512];
    public static CeilingInst[] siCeiling = new CeilingInst[512];
    public static FloorInst[] siFloor = new FloorInst[512];
    public static SpriteInst[] siSprite = new SpriteInst[2048];
    public static ActiveList activeList = new ActiveList(kMaxSequences);
    public static final int AIEnemyCallback = 0;
    public static final int ReviveCallback = 1;
    public static final int MGunOpenCallback = 2;
    public static final int MGunFireCallback = 3;
    public static final int FireballTrapCallback = 4;
    public static final int DamageTreeCallback = 5;
    public static final int SmokeCallback = 6;
    public static final int FireballCallback = 7;
    public static final int TchernobogCallback1 = 8;
    public static final int TchernobogCallback2 = 9;
    public static final int DamageDude = 10;
    public static final int DamageDude2 = 11;
    public static final int FatalityDead = 12;
    public static final int UniMissileTrapCallback = 13;
    public static CALLPROC[] callbacks = new CALLPROC[]{new CALLPROC(){

        @Override
        public void run(int nIndex) {
        }
    }, new CALLPROC(){

        @Override
        public void run(int nIndex) {
            PLAYER.FReviveCallback(nIndex);
        }
    }, new CALLPROC(){

        @Override
        public void run(int nIndex) {
            Trigger.MGunOpenCallback(nIndex);
        }
    }, new CALLPROC(){

        @Override
        public void run(int nIndex) {
            Trigger.MGunFireCallback(nIndex);
        }
    }, new CALLPROC(){

        @Override
        public void run(int nIndex) {
            Trigger.FireballTrapCallback(nIndex);
        }
    }, new CALLPROC(){

        @Override
        public void run(int nIndex) {
            Actor.DamageTreeCallback(nIndex);
        }
    }, new CALLPROC(){

        @Override
        public void run(int nIndex) {
            Actor.SmokeCallback(nIndex);
        }
    }, new CALLPROC(){

        @Override
        public void run(int nIndex) {
            Actor.FireballCallback(nIndex);
        }
    }, new CALLPROC(){

        @Override
        public void run(int nIndex) {
            Actor.TchernobogCallback1(nIndex);
        }
    }, new CALLPROC(){

        @Override
        public void run(int nIndex) {
            Actor.TchernobogCallback2(nIndex);
        }
    }, new CALLPROC(){

        @Override
        public void run(int nIndex) {
            Actor.DamageDude(nIndex, 8);
        }
    }, new CALLPROC(){

        @Override
        public void run(int nIndex) {
            Actor.DamageDude(nIndex, 3);
        }
    }, new CALLPROC(){

        @Override
        public void run(int nIndex) {
            PLAYER.FatalityDeadCallback(nIndex);
        }
    }, new CALLPROC(){

        @Override
        public void run(int nIndex) {
            Trigger.UniMissileTrapCallback(nIndex);
        }
    }};

    public static int getIndex(CALLPROC callback) {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callback != callbacks[i]) continue;
            return i;
        }
        if (callback != null) {
            return 0;
        }
        return -1;
    }

    public static void SeqInit() {
        int i;
        Console.Println("Initializing SEQ animation", 0);
        for (i = 0; i < 512; ++i) {
            SeqHandling.siWall[i] = new WallInst();
        }
        for (i = 0; i < 512; ++i) {
            SeqHandling.siMasked[i] = new MaskedWallInst();
        }
        for (i = 0; i < 512; ++i) {
            SeqHandling.siCeiling[i] = new CeilingInst();
        }
        for (i = 0; i < 512; ++i) {
            SeqHandling.siFloor[i] = new FloorInst();
        }
        for (i = 0; i < 2048; ++i) {
            SeqHandling.siSprite[i] = new SpriteInst();
        }
    }

    public static SeqInst GetInstance(int type, int nXIndex) {
        switch (type) {
            case 0: {
                if (nXIndex <= 0 || nXIndex >= 512) {
                    Main.game.dassert("nXIndex > 0 && nXIndex < kMaxXWalls: " + nXIndex);
                }
                return siWall[nXIndex];
            }
            case 1: {
                if (nXIndex <= 0 || nXIndex >= 512) {
                    Main.game.dassert("nXIndex > 0 && nXIndex < kMaxXSectors: " + nXIndex);
                }
                return siCeiling[nXIndex];
            }
            case 2: {
                if (nXIndex <= 0 || nXIndex >= 512) {
                    Main.game.dassert("nXIndex > 0 && nXIndex < kMaxXSectors: " + nXIndex);
                }
                return siFloor[nXIndex];
            }
            case 3: {
                if (nXIndex <= 0 || nXIndex >= 2048) {
                    Main.game.dassert("nXIndex > 0 && nXIndex < kMaxXSprites: " + nXIndex);
                }
                return siSprite[nXIndex];
            }
            case 4: {
                if (nXIndex <= 0 || nXIndex >= 512) {
                    Main.game.dassert("nXIndex > 0 && nXIndex < kMaxXWalls: " + nXIndex);
                }
                return siMasked[nXIndex];
            }
        }
        System.err.println("Unexcepted object type");
        return null;
    }

    public static void seqKill(int type, int nXIndex) {
        SeqInst pInst = SeqHandling.GetInstance(type, nXIndex);
        if (pInst != null && pInst.isPlaying) {
            if (activeList.remove(pInst) == -1) {
                Main.game.dassert("i < activeCount");
            }
            SeqHandling.UnlockInstance(pInst);
        }
    }

    public static void seqKillAll() {
        int i;
        for (i = 0; i < 512; ++i) {
            if (SeqHandling.siWall[i].isPlaying) {
                SeqHandling.UnlockInstance(siWall[i]);
            }
            if (!SeqHandling.siMasked[i].isPlaying) continue;
            SeqHandling.UnlockInstance(siMasked[i]);
        }
        for (i = 0; i < 512; ++i) {
            if (SeqHandling.siCeiling[i].isPlaying) {
                SeqHandling.UnlockInstance(siCeiling[i]);
            }
            if (!SeqHandling.siFloor[i].isPlaying) continue;
            SeqHandling.UnlockInstance(siFloor[i]);
        }
        for (i = 0; i < 2048; ++i) {
            if (!SeqHandling.siSprite[i].isPlaying) continue;
            SeqHandling.UnlockInstance(siSprite[i]);
        }
        activeList.clear();
    }

    public static void seqSpawn(int nSeqID, int type, int nXIndex, CALLPROC callback) {
        SeqType pSequence;
        SeqInst pInst = SeqHandling.GetInstance(type, nXIndex);
        if (!BuildGdx.cache.contains(nSeqID, "SEQ")) {
            Main.game.dassert("hSeq != null, id = " + nSeqID);
        }
        boolean inList = false;
        if (pInst.isPlaying) {
            if (pInst.nSeqID == nSeqID) {
                return;
            }
            inList = activeList.getIndex(pInst) != -1;
            SeqHandling.UnlockInstance(pInst);
        }
        pInst.pSequence = pSequence = SeqType.getInstance(nSeqID);
        pInst.nSeqID = nSeqID;
        pInst.callback = callback;
        pInst.isPlaying = true;
        pInst.timeCounter = (short)pSequence.ticksPerFrame;
        pInst.frameIndex = 0;
        if (!inList && !activeList.add(pInst, nXIndex)) {
            Main.game.dassert("activeCount < kMaxSequences");
        }
        pInst.update(nXIndex);
    }

    private static void UnlockInstance(SeqInst pInst) {
        if (pInst == null) {
            Main.game.dassert("pInst != null");
        }
        if (pInst.pSequence == null) {
            Main.game.dassert("pInst.pSequence != null");
        }
        pInst.pSequence = null;
        pInst.isPlaying = false;
    }

    public static void clearInstances() {
        int i;
        for (i = 0; i < 512; ++i) {
            siWall[i].clear();
        }
        for (i = 0; i < 512; ++i) {
            siMasked[i].clear();
        }
        for (i = 0; i < 512; ++i) {
            siCeiling[i].clear();
        }
        for (i = 0; i < 512; ++i) {
            siFloor[i].clear();
        }
        for (i = 0; i < 2048; ++i) {
            siSprite[i].clear();
        }
    }

    public static int seqFrame(int type, int nXIndex) {
        SeqInst pInst = SeqHandling.GetInstance(type, nXIndex);
        if (pInst.isPlaying) {
            return pInst.frameIndex;
        }
        return -1;
    }

    public static void seqProcess(int nTicks) {
        block0: for (int i = 0; i < activeList.getSize(); ++i) {
            short index = activeList.getIndex(i);
            SeqInst pInst = activeList.getInst(i);
            SeqType pSeq = pInst.pSequence;
            if (pInst.frameIndex >= pSeq.nFrames) {
                Main.game.dassert("pInst.frameIndex < pSeq.nFrames");
            }
            pInst.timeCounter = (short)(pInst.timeCounter - nTicks);
            while (pInst.timeCounter < 0) {
                pInst.timeCounter = (short)(pInst.timeCounter + pSeq.ticksPerFrame);
                pInst.frameIndex = (short)(pInst.frameIndex + 1);
                if (pInst.frameIndex == pSeq.nFrames) {
                    if (!pSeq.isLooping()) {
                        SeqHandling.UnlockInstance(pInst);
                        if (pSeq.isRemovable()) {
                            if (pInst instanceof SpriteInst) {
                                short nSprite = (short)DB.xsprite[index].reference;
                                if (nSprite < 0 || nSprite >= Globals.kMaxSprites) {
                                    Main.game.dassert("nSprite >= 0 && nSprite < kMaxSprites");
                                }
                                EVENT.checkEventList(nSprite, 3);
                                if ((Engine.sprite[nSprite].hitag & 0x10) != 0 && Engine.sprite[nSprite].zvel >= 200 && Engine.sprite[nSprite].zvel < 256) {
                                    EVENT.evPostCallback(nSprite, 3, Globals.pGameInfo.nWeaponSettings, 9);
                                } else {
                                    DB.deletesprite(nSprite);
                                }
                            }
                            if (pInst instanceof MaskedWallInst) {
                                int nWall = DB.xwall[index].reference;
                                if (nWall < 0 || nWall >= Globals.kMaxWalls) {
                                    Main.game.dassert("nWall >= 0 && nWall < kMaxWalls");
                                }
                                Engine.wall[nWall].cstat = (short)(Engine.wall[nWall].cstat & 0xFFFFFFC7);
                                if (Engine.wall[nWall].nextwall != -1) {
                                    Engine.wall[Engine.wall[nWall].nextwall].cstat = (short)(Engine.wall[Engine.wall[nWall].nextwall].cstat & 0xFFFFFFC7);
                                }
                            }
                        }
                        activeList.remove(i--);
                        continue block0;
                    }
                    pInst.frameIndex = 0;
                }
                pInst.update(index);
            }
        }
    }
}

