/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Types.Seq;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Types.CALLPROC;
import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.Types.Seq.SeqType;
import ru.m210projects.Blood.VERSION;
import ru.m210projects.Build.FileHandle.Resource;

public abstract class SeqInst {
    public static final int sizeof = 20;
    private static final ByteBuffer buffer = ByteBuffer.allocate(20).order(ByteOrder.LITTLE_ENDIAN);
    protected SeqType pSequence;
    protected CALLPROC callback;
    protected int nSeqID;
    protected short timeCounter;
    protected short frameIndex;
    protected boolean isPlaying;

    protected abstract void updateInstance(int var1);

    protected void update(int index) {
        if (this.frameIndex >= this.pSequence.getFrames()) {
            Main.game.dassert("frameIndex < pSequence.nFrames");
        }
        this.updateInstance(index);
        if (this.pSequence.getFrame((int)this.frameIndex).trigger && this.callback != null) {
            this.callback.run(index);
        }
    }

    public int getSeqIndex() {
        return this.nSeqID;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public byte[] getBytes() {
        buffer.clear();
        buffer.putInt(0);
        buffer.putInt(0);
        buffer.putInt(this.nSeqID);
        buffer.putInt(SeqHandling.getIndex(this.callback));
        buffer.putShort(this.timeCounter);
        buffer.put((byte)this.frameIndex);
        buffer.put(this.isPlaying ? (byte)1 : 0);
        return buffer.array();
    }

    public void load(Resource bb) {
        bb.readInt();
        bb.readInt();
        this.pSequence = null;
        this.nSeqID = bb.readInt();
        int callb = bb.readInt();
        if (callb != -1) {
            this.callback = callb > SeqHandling.callbacks.length ? VERSION.getCallback(callb) : SeqHandling.callbacks[callb];
        }
        this.timeCounter = bb.readShort();
        this.frameIndex = (short)(bb.readByte() & 0xFF);
        this.isPlaying = bb.readBoolean();
    }

    public void clear() {
        this.pSequence = null;
        this.callback = null;
        this.nSeqID = 0;
        this.timeCounter = 0;
        this.frameIndex = 0;
        this.isPlaying = false;
    }

    public void copy(SeqInst src) {
        this.pSequence = src.pSequence;
        this.nSeqID = src.nSeqID;
        this.timeCounter = src.timeCounter;
        this.frameIndex = src.frameIndex;
        this.isPlaying = src.isPlaying;
    }
}

