/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import com.badlogic.gdx.math.Vector3;
import java.util.Arrays;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Factory.BloodNetwork;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Menus.MenuInterfaceSet;
import ru.m210projects.Blood.Mirror;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.QAV;
import ru.m210projects.Blood.SECTORFX;
import ru.m210projects.Blood.Screen;
import ru.m210projects.Blood.Strings;
import ru.m210projects.Blood.Tile;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.BURN;
import ru.m210projects.Blood.Types.BloodTile;
import ru.m210projects.Blood.Types.DEMO;
import ru.m210projects.Blood.Types.HANDANIM;
import ru.m210projects.Blood.Types.Hud.AltHud;
import ru.m210projects.Blood.Types.Hud.FullHud;
import ru.m210projects.Blood.Types.Hud.HudRenderer;
import ru.m210projects.Blood.Types.Hud.MiniHud;
import ru.m210projects.Blood.Types.Hud.SplitHud;
import ru.m210projects.Blood.Types.PLOCATION;
import ru.m210projects.Blood.Types.POSTURE;
import ru.m210projects.Blood.Types.QUOTE;
import ru.m210projects.Blood.VERSION;
import ru.m210projects.Blood.Warp;
import ru.m210projects.Build.Architecture.BuildFrame;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.GLRenderer;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.LittleEndian;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.WALL;

public class View {
    protected static HudRenderer[] hudlist;
    protected static HudRenderer splitHud;
    public static int smoothratio;
    public static int viewWeaponX;
    public static int viewWeaponY;
    public static int viewCrossX;
    public static int viewCrossY;
    public static int viewCrossZoom;
    public static int gPlayerIndex;
    private static int nextTime;
    public static int nextY;
    private static final int kMaxQuotes = 16;
    public static int numQuotes;
    private static int hideQuotes;
    private static int totalQuotes;
    private static final QUOTE[] quotes;
    public static int yOffset;
    public static int kMapZoom;
    private static int viewThirdDist;
    private static int viewThirdClock;
    private static final char[] number_buffer;
    public static int PaletteView;
    public static final int kStatBarHeight = 25;
    private static final int kLensSize = 80;
    private static byte[] lensTable;
    private static final byte[] otherMirrorGotpic;
    private static final byte[] bakMirrorGotpic;
    public static final int kView2D = 2;
    public static final int kView3D = 3;
    public static final int kView2DIcon = 4;
    public static final int kViewPosCenter = 0;
    public static int gViewIndex;
    public static int gViewPos;
    public static int gViewMode;
    public static int deliriumTilt;
    public static int deliriumTurn;
    public static int deliriumPitch;
    private static final int kViewEffectShadow = 0;
    private static final int kViewEffectFlareHalo = 1;
    private static final int kViewEffectCeilGlow = 2;
    private static final int kViewEffectFloorGlow = 3;
    private static final int kViewEffectTorchHigh = 4;
    private static final int kViewEffectTorchLow = 5;
    private static final int kViewEffectSmokeHigh = 6;
    private static final int kViewEffectSmokeLow = 7;
    private static final int kViewEffectFlame = 8;
    private static final int kViewEffectSpear = 9;
    private static final int kViewEffectTrail = 10;
    private static final int kViewEffectPhase = 11;
    private static final int kViewEffectShowWeapon = 12;
    private static final int kViewEffectReflectiveBall = 13;
    private static final int kViewEffectShoot = 14;
    private static final int kViewEffectTesla = 15;
    private static final int kViewEffectFlag = 16;
    private static final int kViewEffectBigFlag = 17;
    private static final int kViewEffectAtom = 18;
    private static final int kViewEffectMax = 19;
    public static int scrollX;
    public static int scrollOX;
    public static int scrollY;
    public static int scrollOY;
    public static short scrollAng;
    public static short scrollOAng;
    public static HANDANIM viewHandAnim;
    public static int gViewX0;
    public static int gViewY0;
    public static int gViewX1;
    public static int gViewY1;
    public static int gViewX0Scaled;
    public static int gViewX1Scaled;
    public static int gViewY0Scaled;
    public static int gViewY1Scaled;
    private static final short[] viewWeaponTile;
    private static final int kViewDistance = 1280;
    private static int othercameradist;
    private static int othercameraclock;
    private static final int TA_LEFT = 0;
    private static final int TA_CENTER = 1;
    private static final int kDrawYFlip = 4;
    private static final int kDrawXFlip = 2048;
    private static final int[] gEffectDetail;
    private static final Vector3[] atomEffectVelocity;
    private static int lastDacUpdate;
    private static final BURN[] burnTable;

    public static void viewHandInit() {
        viewHandAnim = new HANDANIM();
        Resource hQAV = BuildGdx.cache.open(518, "QAV");
        if (hQAV == null) {
            Console.Println("Could not load QAVID 518", Console.OSDTEXT_RED);
            VERSION.SHAREWARE = true;
            return;
        }
        View.viewHandAnim.pQAV = new QAV(hQAV);
        View.viewHandAnim.duration = View.viewHandAnim.pQAV.duration;
        View.viewHandAnim.clock = Engine.totalclock;
        hQAV.close();
    }

    public static void resetQuotes() {
        numQuotes = 0;
        totalQuotes = 0;
        hideQuotes = 0;
    }

    public static void viewResizeView(int size) {
        gViewX0Scaled = (Engine.xdim << 16) / 320;
        gViewY0Scaled = (Engine.ydim << 16) / 200;
        gViewX1Scaled = 0x1400000 / Engine.xdim;
        gViewY1Scaled = 0xC80000 / Engine.ydim;
        Main.cfg.gViewSize = Gameutils.ClipRange(size, 0, hudlist.length - 1);
        if (Main.cfg.gViewSize > hudlist.length - 1) {
            gViewX0 = 0;
            gViewY0 = 0;
            gViewX1 = Engine.xdim - 1;
            gViewY1 = Engine.ydim - 1 - Pragmas.scale(25L, Engine.ydim, 200L);
            int vsiz = Main.cfg.gViewSize - (hudlist.length - 1);
            int dView = ((gViewY1 -= vsiz * Engine.ydim / 16) - (gViewY0 += vsiz * Engine.ydim / 16)) * vsiz;
            Main.engine.setview(gViewX0 += vsiz * Engine.xdim / 16, gViewY0 += dView / 16, gViewX1 -= vsiz * Engine.xdim / 16, gViewY1 -= dView / 16);
        } else {
            gViewX0 = 0;
            gViewY0 = 0;
            gViewX1 = Engine.xdim - 1;
            gViewY1 = Engine.ydim - 1;
            Main.engine.setview(gViewX0, gViewY0, gViewX1, gViewY1);
        }
    }

    public static QUOTE viewSetMessage(String message, int nPlayer) {
        return View.viewSetMessage(message, nPlayer, 0);
    }

    public static QUOTE viewSetMessage(String message, int nPlayer, int pal) {
        if (message.isEmpty()) {
            return null;
        }
        QUOTE quote = quotes[totalQuotes];
        quote.messageText = message;
        quote.pal = nPlayer != -1 && nPlayer != Mmulti.myconnectindex ? (int)Globals.gPlayer[nPlayer].pSprite.pal : pal;
        Console.Println(message, pal);
        quote.messageTime = 120 * Main.cfg.quoteTime + Globals.gFrameClock;
        ++totalQuotes;
        totalQuotes %= 16;
        if (++numQuotes > Main.cfg.showQuotes) {
            ++hideQuotes;
            hideQuotes %= 16;
            nextTime = 0;
            numQuotes = Main.cfg.showQuotes;
            nextY = yOffset;
        }
        return quote;
    }

    public static void InitBallBuffer() {
        byte[] pLens = Main.engine.allocatepermanenttile(4077, 80, 80);
        Arrays.fill(pLens, (byte)-1);
    }

    public static void viewInit() {
        int i;
        Console.Println("Initializing status bar", 0);
        hudlist = new HudRenderer[]{null, new MiniHud(), new AltHud(), new FullHud()};
        splitHud = new SplitHud();
        View.viewResizeView(Main.cfg.gViewSize);
        for (i = 0; i < 16; ++i) {
            View.quotes[i] = new QUOTE();
        }
        lensTable = BuildGdx.cache.getBytes("LENS.DAT", 0);
        if (lensTable == null) {
            Main.game.dassert("lens.dat == null");
        }
        if (lensTable.length != 25600) {
            Main.game.dassert("gSysRes.Size(hLens) != kLensSize * kLensSize * sizeof(int)");
        }
        View.InitBallBuffer();
        for (i = 0; i < 16; ++i) {
            View.atomEffectVelocity[i] = new Vector3();
            View.atomEffectVelocity[i].x = Gameutils.Random(2048);
            View.atomEffectVelocity[i].y = Gameutils.Random(2048);
            View.atomEffectVelocity[i].z = Gameutils.Random(2048);
        }
    }

    public static void viewUpdatePlayerLoc(PLAYER pPlayer) {
        POSTURE cp = Globals.gPosture[pPlayer.nLifeMode][pPlayer.moveState];
        pPlayer.viewOffZ = pPlayer.pSprite.z - cp.viewSpeed;
        pPlayer.weaponAboveZ = pPlayer.pSprite.z - cp.weapSpeed;
        View.viewBackupView(pPlayer.nPlayer);
    }

    public static void viewBackupView(int nPlayer) {
        SPRITE pSprite = Globals.gPlayer[nPlayer].pSprite;
        PLOCATION pPLocation = PLAYER.gPrevView[nPlayer];
        pPLocation.x = pSprite.x;
        pPLocation.y = pSprite.y;
        pPLocation.ang = Globals.gPlayer[nPlayer].ang;
        pPLocation.horiz = Globals.gPlayer[nPlayer].horiz;
        pPLocation.horizOff = Globals.gPlayer[nPlayer].horizOff;
        pPLocation.slope = Globals.gPlayer[nPlayer].slope;
        pPLocation.viewOffZ = Globals.gPlayer[nPlayer].viewOffZ;
        pPLocation.weapOffZ = Globals.gPlayer[nPlayer].weaponAboveZ - Globals.gPlayer[nPlayer].viewOffZ - 3072;
        pPLocation.bobHeight = Globals.gPlayer[nPlayer].bobHeight;
        pPLocation.bobWidth = Globals.gPlayer[nPlayer].bobWidth;
        pPLocation.swayHeight = Globals.gPlayer[nPlayer].swayHeight;
        pPLocation.swayWidth = Globals.gPlayer[nPlayer].swayWidth;
    }

    public static void viewDrawSplitHUD(PLAYER gView) {
        splitHud.draw(gView, 0, 0);
    }

    private static boolean showItem(int item) {
        switch (item + 100) {
            case 112: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 139: {
                return true;
            }
        }
        return false;
    }

    public static void viewDrawHUD(PLAYER gView) {
        if (Main.cfg.gViewSize >= 0 && Main.cfg.gViewSize < hudlist.length && hudlist[Main.cfg.gViewSize] != null) {
            hudlist[Main.cfg.gViewSize].draw(gView, 0, 0);
        }
        int posy = 20;
        for (int i = 0; i < 49; ++i) {
            if (PLAYER.powerupCheck(gView, i) <= 0 || !View.showItem(i)) continue;
            BloodTile pic = Main.engine.getTile(Actor.gItemInfo[i].picnum);
            View.DrawStatSprite(Actor.gItemInfo[i].picnum, 280 - Main.engine.getTile(Actor.gItemInfo[i].picnum + Main.engine.animateoffs(Actor.gItemInfo[i].picnum, 0)).getWidth() / 4, posy - pic.getHeight() / 4, 0, 0, 528, 32768);
            int fx = View.viewDrawNumber(3, gView.powerUpTimer[i] * 100 / Math.max(Actor.gPowerUpInfo[i].addPower, 1), 276, posy + pic.getHeight() / 4 + 4, 65535, 32, 0, BuildFont.TextAlign.Center, 512, false);
            Main.game.getFont(3).drawText(277 + fx, posy + pic.getHeight() / 4 + 4, "%", 65535, 24, 0, BuildFont.TextAlign.Center, 514, true);
            posy += 40;
        }
        if (Globals.pGameInfo.nGameType == 0) {
            return;
        }
        if (Globals.pGameInfo.nGameType == 3) {
            if (Globals.nTeamClock[0] == 0 || (Engine.totalclock & 8) != 0) {
                Main.game.getFont(0).drawText(1, 1, Gameutils.toCharArray("Blue"), -128, 10, BuildFont.TextAlign.Left, 258, false);
                Globals.nTeamClock[0] = Gameutils.ClipLow(Globals.nTeamClock[0] - Globals.kFrameTicks, 0);
                View.viewDrawNumber(0, Globals.nTeamCount[0], 1, 11, 65536, -128, 10, BuildFont.TextAlign.Left, 256, false);
            }
            if (Globals.nTeamClock[1] == 0 || (Engine.totalclock & 8) != 0) {
                Main.game.getFont(0).drawText(319, 1, Gameutils.toCharArray("Red"), -128, 7, BuildFont.TextAlign.Right, 514, false);
                Globals.nTeamClock[1] = Gameutils.ClipLow(Globals.nTeamClock[1] - Globals.kFrameTicks, 0);
                View.viewDrawNumber(0, Globals.nTeamCount[1], 319, 11, 65536, -128, 7, BuildFont.TextAlign.Right, 512, false);
            }
        } else {
            View.viewNetPlayers(0, true);
        }
        if (gView != Globals.gMe) {
            String viewed = "View from ";
            System.arraycopy("View from ".toCharArray(), 0, number_buffer, 0, "View from ".length());
            int len = Main.game.net.gProfile[gView.nPlayer].name.length();
            System.arraycopy(Main.game.net.gProfile[gView.nPlayer].name.toCharArray(), 0, number_buffer, "View from ".length(), len);
            View.number_buffer["View from ".length() + len] = '\u0000';
            int shade = 32 - (Engine.totalclock & 0x3F);
            Main.game.getFont(0).drawText(160, 150, number_buffer, shade, 0, BuildFont.TextAlign.Center, 2, false);
        }
    }

    public static void viewNetPlayers(int yoffset, boolean showpalette) {
        int row = (Mmulti.numplayers - 1) / 4;
        if (row >= 0) {
            if (yoffset > 0) {
                yoffset -= 9 * row;
            }
            BloodTile pic = Main.engine.getTile(2229);
            for (int r = 0; r <= row; ++r) {
                for (int i = 0; i < 4; ++i) {
                    View.DrawStatSprite(2229, 80 * i + 40, 9 * r + 8 - pic.getHeight() / 2 + yoffset, 16, 0, 10, 65536);
                }
            }
            int plu = (Globals.gPlayer[Mmulti.myconnectindex].teamID & 3) + 11;
            if (plu == 13) {
                plu = 4;
            }
            if (!showpalette) {
                plu = 0;
            }
            if (Main.game.isCurrentScreen(Main.gGameScreen) && Globals.pGameInfo.nReviveMode && Globals.pGameInfo.nGameType == 1 && Globals.gMe.pXsprite.health <= 0) {
                int shade = 32 - (Engine.totalclock & 0x3F);
                View.DrawStatSprite(2229, 0, yoffset, shade, 2, 26, 65536);
            }
            Main.game.getFont(4).drawText(4, yoffset + 1, Gameutils.toCharArray(Main.game.net.gProfile[Mmulti.myconnectindex].name), -128, plu, BuildFont.TextAlign.Left, 2, false);
            View.viewDrawNumber(4, Globals.gPlayer[Mmulti.myconnectindex].fragCount, 76, yoffset + 1, 65536, -128, plu, BuildFont.TextAlign.Right, 0, false);
            int p = 0;
            short i = Mmulti.connecthead;
            while (i >= 0) {
                if (i != Mmulti.myconnectindex) {
                    int posx = 80 * (++p & 3);
                    int posy = 9 * (p / 4);
                    plu = (Globals.gPlayer[i].teamID & 3) + 11;
                    if (plu == 13) {
                        plu = 4;
                    }
                    if (!showpalette) {
                        plu = 0;
                    }
                    if (Main.game.isCurrentScreen(Main.gGameScreen) && Globals.pGameInfo.nReviveMode && Globals.pGameInfo.nGameType == 1 && Globals.gPlayer[i].pXsprite.health <= 0) {
                        int shade = 32 - (Engine.totalclock & 0x3F);
                        View.DrawStatSprite(2229, posx, posy + yoffset, shade, 2, 26, 65536);
                    }
                    Main.game.getFont(4).drawText(posx + 4, posy + yoffset + 1, Gameutils.toCharArray(Main.game.net.gProfile[i].name), -128, plu, BuildFont.TextAlign.Left, 2, false);
                    View.viewDrawNumber(4, Globals.gPlayer[i].fragCount, posx + 76, posy + yoffset + 1, 65536, -128, plu, BuildFont.TextAlign.Right, 0, false);
                }
                i = Mmulti.connectpoint2[i];
            }
        }
    }

    public static void viewPaletteHandler(PLAYER gView) {
        int vPalette = 0;
        lastDacUpdate = Engine.totalclock;
        if (PLAYER.powerupCheck(gView, 14) > 0) {
            vPalette = 4;
        } else if (PLAYER.powerupCheck(gView, 24) > 0) {
            vPalette = 1;
        } else if (gView.Underwater) {
            vPalette = gView.pXsprite.palette;
        } else if (gView.nLifeMode == 1) {
            vPalette = 2;
        }
        if (vPalette != PaletteView) {
            Screen.scrSetPalette(vPalette);
            PaletteView = vPalette;
        }
        if (Main.engine.getrender().getType().getFrameType() == BuildFrame.FrameType.GL) {
            Screen.scrGLSetDac(Engine.totalclock - lastDacUpdate);
        } else {
            Screen.scrSetDac(Engine.totalclock - lastDacUpdate);
        }
        lastDacUpdate = Engine.totalclock;
    }

    public static void viewDrawScreen(int gViewIndex, int smooth) {
        PLAYER gView = Globals.gPlayer[gViewIndex];
        if (gView == null || gView.pSprite == null) {
            short s = Mmulti.myconnectindex;
            View.gViewIndex = s;
            gViewIndex = s;
            gView = Globals.gPlayer[gViewIndex];
        }
        if (gView == null || gView.pSprite == null) {
            return;
        }
        smoothratio = smooth;
        gPlayerIndex = -1;
        if (!Globals.gMapScrollMode) {
            scrollOX = scrollX = gView.pSprite.x;
            scrollOY = scrollY = gView.pSprite.y;
            scrollOAng = scrollAng = gView.pSprite.ang;
        }
        if (gViewMode == 3 || gViewMode == 2) {
            boolean bDelirious;
            SECTORFX.DoSectorLighting();
            long x = gView.pSprite.x;
            long y = gView.pSprite.y;
            long z = gView.viewOffZ;
            float nAngle = gView.ang;
            float nHoriz = gView.horiz;
            int bobWidth = gView.bobWidth;
            int bobHeight = gView.bobHeight;
            int swayWidth = gView.swayWidth;
            int swayHeight = gView.swayHeight;
            int nSlope = gView.slope;
            short nSector = gView.pSprite.sectnum;
            if (nSector == -1) {
                return;
            }
            int weapOffZ = gView.weaponAboveZ - gView.viewOffZ - 3072;
            if (Main.cfg.gInterpolation != 0 && (!Main.game.menu.gShowMenu && !Console.IsShown() || Main.game.isCurrentScreen(Main.gDemoScreen))) {
                if (Mmulti.numplayers > 1 && gView == Globals.gMe && Globals.gMe.pXsprite.health != 0) {
                    BloodNetwork net = (BloodNetwork)Main.game.pNet;
                    nSector = net.predict.sectnum;
                    x = net.predictOld.x + Pragmas.mulscale(net.predict.x - net.predictOld.x, smoothratio, 16);
                    y = net.predictOld.y + Pragmas.mulscale(net.predict.y - net.predictOld.y, smoothratio, 16);
                    z = net.predictOld.viewOffZ + Pragmas.mulscale(net.predict.viewOffZ - net.predictOld.viewOffZ, smoothratio, 16);
                    weapOffZ = net.predictOld.weapOffZ + Pragmas.mulscale(net.predict.weapOffZ - net.predictOld.weapOffZ, smoothratio, 16);
                    nHoriz = net.predictOld.horiz + (net.predict.horiz - net.predictOld.horiz) * (float)smoothratio / 65536.0f;
                    nAngle = net.predictOld.ang + (ru.m210projects.Build.Gameutils.BClampAngle(net.predict.ang - net.predictOld.ang + 1024.0f) - 1024.0f) * (float)smoothratio / 65536.0f;
                    bobWidth = net.predictOld.bobWidth + Pragmas.mulscale(net.predict.bobWidth - net.predictOld.bobWidth, smoothratio, 16);
                    bobHeight = net.predictOld.bobHeight + Pragmas.mulscale(net.predict.bobHeight - net.predictOld.bobHeight, smoothratio, 16);
                    swayWidth = net.predictOld.swayWidth + Pragmas.mulscale(net.predict.swayWidth - net.predictOld.swayWidth, smoothratio, 16);
                    swayHeight = net.predictOld.swayHeight + Pragmas.mulscale(net.predict.swayHeight - net.predictOld.swayHeight, smoothratio, 16);
                    nSlope = net.predictOld.slope + Pragmas.mulscale(net.predict.slope - net.predictOld.slope, smoothratio, 16);
                } else {
                    x = PLAYER.gPrevView[gViewIndex].x + Pragmas.mulscale(x - (long)PLAYER.gPrevView[gViewIndex].x, smoothratio, 16);
                    y = PLAYER.gPrevView[gViewIndex].y + Pragmas.mulscale(y - (long)PLAYER.gPrevView[gViewIndex].y, smoothratio, 16);
                    z = PLAYER.gPrevView[gViewIndex].viewOffZ + Pragmas.mulscale(z - (long)PLAYER.gPrevView[gViewIndex].viewOffZ, smoothratio, 16);
                    weapOffZ = PLAYER.gPrevView[gViewIndex].weapOffZ + Pragmas.mulscale(weapOffZ - PLAYER.gPrevView[gViewIndex].weapOffZ, smoothratio, 16);
                    nHoriz = PLAYER.gPrevView[gViewIndex].horiz + (nHoriz - PLAYER.gPrevView[gViewIndex].horiz) * (float)smoothratio / 65536.0f;
                    nAngle = PLAYER.gPrevView[gViewIndex].ang + (ru.m210projects.Build.Gameutils.BClampAngle(nAngle - PLAYER.gPrevView[gViewIndex].ang + 1024.0f) - 1024.0f) * (float)smoothratio / 65536.0f;
                    bobWidth = PLAYER.gPrevView[gViewIndex].bobWidth + Pragmas.mulscale(bobWidth - PLAYER.gPrevView[gViewIndex].bobWidth, smoothratio, 16);
                    bobHeight = PLAYER.gPrevView[gViewIndex].bobHeight + Pragmas.mulscale(bobHeight - PLAYER.gPrevView[gViewIndex].bobHeight, smoothratio, 16);
                    swayWidth = PLAYER.gPrevView[gViewIndex].swayWidth + Pragmas.mulscale(swayWidth - PLAYER.gPrevView[gViewIndex].swayWidth, smoothratio, 16);
                    swayHeight = PLAYER.gPrevView[gViewIndex].swayHeight + Pragmas.mulscale(swayHeight - PLAYER.gPrevView[gViewIndex].swayHeight, smoothratio, 16);
                    nSlope = PLAYER.gPrevView[gViewIndex].slope + Pragmas.mulscale(nSlope - PLAYER.gPrevView[gViewIndex].slope, smoothratio, 16);
                }
            }
            if (gView.explosion != 0) {
                int explCount = Gameutils.ClipRange(gView.explosion * 8, 0, 2000);
                x += (long)Gameutils.ViRandom(explCount >> 4);
                y += (long)Gameutils.ViRandom(explCount >> 4);
                z += (long)Gameutils.ViRandom(explCount);
                nHoriz += (float)Gameutils.ViRandom(explCount >> 8);
                nAngle += (float)Gameutils.ViRandom(explCount >> 8);
                swayWidth += Gameutils.ViRandom(explCount);
                swayHeight += Gameutils.ViRandom(explCount);
            }
            if (gView.quakeTime != 0) {
                int explCount = Gameutils.ClipRange(gView.quakeTime * 8, 0, 2000);
                x += (long)Gameutils.ViRandom(explCount >> 4);
                y += (long)Gameutils.ViRandom(explCount >> 4);
                z += (long)Gameutils.ViRandom(explCount);
                nHoriz += (float)Gameutils.ViRandom(explCount >> 8);
                nAngle += (float)Gameutils.ViRandom(explCount >> 8);
                swayWidth += Gameutils.ViRandom(explCount);
                swayHeight += Gameutils.ViRandom(explCount);
            }
            nHoriz += (float)Pragmas.mulscale(30L, 0x40000000L - (long)Trig.Cos(4 * gView.tilt), 30);
            nAngle += (float)gView.lookang;
            if (gViewPos == 0) {
                if (Main.cfg.gBobWidth) {
                    x = (long)((double)x - (double)bobWidth * ru.m210projects.Build.Gameutils.BSinAngle(nAngle) / 261568.0);
                    y = (long)((double)y + (double)bobWidth * ru.m210projects.Build.Gameutils.BCosAngle(nAngle) / 261568.0);
                }
                if (Main.cfg.gBobHeight) {
                    z += (long)bobHeight;
                }
                if (Main.game.net.gProfile[Mmulti.myconnectindex].slopetilt) {
                    nHoriz += (float)nSlope;
                }
                z = (long)((float)z + 10.0f * nHoriz);
                viewThirdDist = -1;
                viewThirdClock = Engine.totalclock;
            } else {
                float dx = (float)(1280.0 * -ru.m210projects.Build.Gameutils.BCosAngle(nAngle) / 16384.0);
                float dy = (float)(1280.0 * -ru.m210projects.Build.Gameutils.BSinAngle(nAngle) / 16384.0);
                int dz = 160 * (int)nHoriz - 4096;
                short oldcstat = gView.pSprite.cstat;
                gView.pSprite.cstat = (short)(gView.pSprite.cstat & 0xFFFFFEFF);
                if (nSector < 0 || nSector >= Globals.kMaxSectors) {
                    Main.game.dassert("nSector >= 0 && nSector < kMaxSectors");
                }
                Gameutils.FindSector((int)x, (int)y, (int)z, nSector);
                nSector = Gameutils.foundSector;
                Engine.hitscangoalx = 0x1FFFFFFF;
                Engine.hitscangoaly = 0x1FFFFFFF;
                Main.engine.hitscan((int)x, (int)y, (int)z, nSector, (int)dx, (int)dy, dz, Engine.pHitInfo, 0x1000040);
                int hx = (int)((long)Engine.pHitInfo.hitx - x);
                int hy = (int)((long)Engine.pHitInfo.hity - y);
                if ((float)(Pragmas.klabs(hx) + Pragmas.klabs(hy)) - (Math.abs(dx) + Math.abs(dy)) < 1024.0f) {
                    nSector = Engine.pHitInfo.hitsect;
                    int wx = 1;
                    if (dx < 0.0f) {
                        wx = -1;
                    }
                    int wy = 1;
                    if (dy < 0.0f) {
                        wy = -1;
                    }
                    hx -= wx << 9;
                    hy -= wy << 9;
                    int dist = 0;
                    if (dx != 0.0f && dy != 0.0f) {
                        dist = Math.abs(dx) <= Math.abs(dy) ? (int)Gameutils.ClipHigh((float)(hy << 16) / dy, viewThirdDist) : (int)Gameutils.ClipHigh((float)(hx << 16) / dx, viewThirdDist);
                    }
                    viewThirdDist = dist;
                }
                x += (long)Pragmas.mulscale(viewThirdDist, (int)dx, 16);
                y += (long)Pragmas.mulscale(viewThirdDist, (int)dy, 16);
                z += (long)Pragmas.mulscale(viewThirdDist, dz, 16);
                viewThirdDist = Gameutils.ClipHigh(viewThirdDist + (Engine.totalclock - viewThirdClock << 10), 65536);
                viewThirdClock = Engine.totalclock;
                if (nSector < 0 || nSector >= Globals.kMaxSectors) {
                    Main.game.dassert("nSector >= 0 && nSector < kMaxSectors");
                }
                Gameutils.FindSector((int)x, (int)y, (int)z, nSector);
                nSector = Gameutils.foundSector;
                gView.pSprite.cstat = oldcstat;
            }
            Warp.checkWarping(x, y, z, nSector);
            x = Warp.checkWx;
            y = Warp.checkWy;
            z = Warp.checkWz;
            nSector = Warp.checkWs;
            GLRenderer gl = Main.engine.glrender();
            boolean bl = bDelirious = PLAYER.powerupCheck(gView, 28) > 0;
            if (deliriumTilt != 0 || bDelirious) {
                if (gl != null) {
                    gl.setdrunk(deliriumTilt);
                } else {
                    BloodTile pic = Main.engine.getTile(4078);
                    if (pic.data == null || pic.getWidth() == 0 || pic.getHeight() == 0) {
                        Main.engine.allocatepermanenttile(4078, 320, 320);
                    }
                    Main.engine.setviewtotile(4078, 320, 320);
                    int tilt = deliriumTilt & 0x1FF;
                    if (tilt > 256) {
                        tilt = 512 - tilt;
                    }
                    Main.engine.setaspect(Pragmas.dmulscale(256000L, Trig.Cos(tilt), 160000L, Trig.Sin(tilt), 32), Engine.yxaspect);
                }
            } else {
                if (gl != null) {
                    gl.setdrunk(0.0f);
                }
                if (PLAYER.powerupCheck(gView, 21) > 0 && (Mmulti.numplayers > 1 || Main.game.isCurrentScreen(Main.gGameScreen) && Globals.kFakeMultiplayer && Globals.nFakePlayers > 1)) {
                    int explCount;
                    int nViewed;
                    int nP = Mmulti.numplayers;
                    if (Globals.kFakeMultiplayer) {
                        nP = Globals.nFakePlayers;
                    }
                    int nEyes = Engine.totalclock / 240 % (nP - 1);
                    if (!Globals.kFakeMultiplayer) {
                        nViewed = Mmulti.connecthead;
                        while (true) {
                            if (nViewed == gViewIndex) {
                                nViewed = Mmulti.connectpoint2[nViewed];
                            }
                            if (nEyes != 0) {
                                nViewed = Mmulti.connectpoint2[nViewed];
                                --nEyes;
                                continue;
                            }
                            break;
                        }
                    } else {
                        nViewed = nEyes + 1;
                    }
                    PLAYER pViewed = Globals.gPlayer[nViewed];
                    BloodTile pic = Main.engine.getTile(4079);
                    if (pic.data == null || pic.getWidth() == 0 || pic.getHeight() == 0) {
                        Main.engine.allocatepermanenttile(4079, 128, 128);
                    }
                    Main.engine.setviewtotile(4079, 128, 128);
                    Main.engine.setaspect(65536, 78643);
                    int cx = pViewed.pSprite.x;
                    int cy = pViewed.pSprite.y;
                    int cz = pViewed.viewOffZ;
                    short cnSector = pViewed.pSprite.sectnum;
                    int cnAngle = pViewed.pSprite.ang;
                    int cnHoriz = 0;
                    if (pViewed.explosion != 0) {
                        explCount = Gameutils.ClipRange(gView.explosion * 8, 0, 2000);
                        cx += Gameutils.ViRandom(explCount >> 4);
                        cy += Gameutils.ViRandom(explCount >> 4);
                        cz += Gameutils.ViRandom(explCount);
                        cnHoriz += Gameutils.ViRandom(explCount >> 8);
                        cnAngle += Gameutils.ViRandom(explCount >> 8);
                    }
                    if (pViewed.quakeTime != 0) {
                        explCount = Gameutils.ClipRange(gView.quakeTime * 8, 0, 2000);
                        cx += Gameutils.ViRandom(explCount >> 4);
                        cy += Gameutils.ViRandom(explCount >> 4);
                        cz += Gameutils.ViRandom(explCount);
                        cnHoriz += Gameutils.ViRandom(explCount >> 8);
                        cnAngle += Gameutils.ViRandom(explCount >> 8);
                    }
                    int nx = Pragmas.mulscale(-Trig.Cos(cnAngle), 1280L, 30);
                    int ny = Pragmas.mulscale(-Trig.Sin(cnAngle), 1280L, 30);
                    int nz = Pragmas.mulscale(cnHoriz, 1280L, 3);
                    nz -= 4096;
                    SPRITE sp = pViewed.pSprite;
                    short bakcstat = sp.cstat;
                    sp.cstat = (short)(sp.cstat & 0xFFFFFEFF);
                    Gameutils.FindSector(cx, cy, cz, cnSector);
                    cnSector = Gameutils.foundSector;
                    Main.engine.hitscan(cx, cy, cz, cnSector, nx, ny, nz, Engine.pHitInfo, 0x1000040);
                    int hx = Engine.pHitInfo.hitx - cx;
                    int hy = Engine.pHitInfo.hity - cy;
                    if (Pragmas.klabs(nx) + Pragmas.klabs(ny) > Pragmas.klabs(hx) + Pragmas.klabs(hy)) {
                        cnSector = Engine.pHitInfo.hitsect;
                        hx -= Pragmas.ksgn(nx) * 4 << 4;
                        hy -= Pragmas.ksgn(ny) * 4 << 4;
                        othercameradist = Pragmas.klabs(nx) > Pragmas.klabs(ny) ? Gameutils.ClipHigh(othercameradist, Pragmas.divscale(hx, nx, 16)) : Gameutils.ClipHigh(othercameradist, Pragmas.divscale(hy, ny, 16));
                    }
                    cx += Pragmas.mulscale(nx, othercameradist, 16);
                    cy += Pragmas.mulscale(ny, othercameradist, 16);
                    cz += Pragmas.mulscale(nz, othercameradist, 16);
                    if ((othercameradist += Engine.totalclock - othercameraclock << 10) > 65536) {
                        othercameradist = 65536;
                    }
                    othercameraclock = Engine.totalclock;
                    Gameutils.FindSector(cx, cy, cz, cnSector);
                    cnSector = Gameutils.foundSector;
                    sp.cstat = bakcstat;
                    Warp.checkWarping(cx, cy, cz, cnSector);
                    cx = (int)Warp.checkWx;
                    cy = (int)Warp.checkWy;
                    cz = (int)Warp.checkWz;
                    cnSector = Warp.checkWs;
                    System.arraycopy(Engine.gotpic, 510, bakMirrorGotpic, 0, 8);
                    System.arraycopy(otherMirrorGotpic, 0, Engine.gotpic, 510, 8);
                    Engine.visibility = Gameutils.ClipLow(DB.gVisibility - pViewed.visibility * 32, 0);
                    Mirror.DrawMirrors(cx, cy, cz, cnAngle, 90 + cnHoriz);
                    Main.engine.drawrooms(cx, cy, cz, cnAngle, 90 + cnHoriz, cnSector);
                    System.arraycopy(Engine.gotpic, 510, otherMirrorGotpic, 0, 8);
                    System.arraycopy(bakMirrorGotpic, 0, Engine.gotpic, 510, 8);
                    View.viewProcessSprites(cx, cy, cz);
                    Main.engine.drawmasks();
                    Main.engine.setviewback();
                } else {
                    othercameradist = -1;
                    othercameraclock = Engine.totalclock;
                }
            }
            int vis = 0;
            short i = Engine.headspritestat[2];
            while (i >= 0) {
                short sectnum;
                SPRITE pSprite = Engine.sprite[i];
                short nXSprite = pSprite.extra;
                if (nXSprite <= 0 || nXSprite >= 2048) {
                    Main.game.dassert("nXSprite > 0 && nXSprite < kMaxXSprites");
                }
                if ((Engine.gotsector[(sectnum = pSprite.sectnum) >> 3] & Engine.pow2char[sectnum & 7]) != 0) {
                    vis += 32 * DB.xsprite[nXSprite].data3;
                }
                i = Engine.nextspritestat[i];
            }
            i = Engine.headspritestat[5];
            while (i >= 0) {
                SPRITE pSprite = Engine.sprite[i];
                switch (pSprite.lotag) {
                    case 301: 
                    case 302: 
                    case 303: 
                    case 306: {
                        if ((Engine.gotsector[pSprite.sectnum >> 3] & Engine.pow2char[pSprite.sectnum & 7]) == 0) break;
                        vis += 256;
                    }
                }
                i = Engine.nextspritestat[i];
            }
            Engine.visibility = Gameutils.ClipLow(DB.gVisibility - 32 * gView.visibility - vis, 0);
            nAngle = ru.m210projects.Build.Gameutils.BClampAngle((float)deliriumTurn + nAngle);
            int nUpper = Warp.gUpperLink[nSector];
            int nLower = Warp.gLowerLink[nSector];
            Main.engine.getzsofslope(nSector, (int)x, (int)y, Globals.zofslope);
            int lz = 1024;
            long crossDz = 0L;
            if (z < (long)(Globals.zofslope[0] + lz) && (nLower == -1 || Main.engine.getrender().getType().equals((Object)Renderer.RenderType.Polymost) && Engine.sector[nSector].ceilingpicnum < 4080 || Engine.sector[nSector].ceilingpicnum >= 4096)) {
                crossDz = z;
                z = Globals.zofslope[0] + lz;
                crossDz -= z;
            }
            if (z > (long)(Globals.zofslope[1] - lz) && (nUpper == -1 || Main.engine.getrender().getType().equals((Object)Renderer.RenderType.Polymost) && Engine.sector[nSector].floorpicnum < 4080 || Engine.sector[nSector].floorpicnum >= 4096)) {
                crossDz = z;
                z = Globals.zofslope[1] - lz;
                crossDz -= z;
            }
            nHoriz = ru.m210projects.Build.Gameutils.BClipRange(nHoriz, -200.0f, 200.0f);
            int defHoriz = 90;
            if (PLAYER.newHoriz && !DEMO.IsOriginalDemo()) {
                defHoriz = 100;
            }
            Main.engine.getrender().settiltang(deliriumTilt);
            Mirror.DrawMirrors(x, y, z, nAngle, (float)defHoriz + nHoriz + (float)deliriumPitch);
            byte gotfire = Engine.gotpic[Globals.fire.getPicture() >> 3];
            short oldcstat = gView.pSprite.cstat;
            gView.pSprite.cstat = gViewPos == 0 ? (short)(gView.pSprite.cstat | 0x8000) : (short)(gView.pSprite.cstat | 0x202);
            Main.engine.drawrooms(x, y, z, nAngle, (float)defHoriz + nHoriz + (float)deliriumPitch, nSector);
            if ((gotfire & Engine.pow2char[Globals.fire.getPicture() & 7]) != 0) {
                int n = Globals.fire.getPicture() >> 3;
                Engine.gotpic[n] = (byte)(Engine.gotpic[n] | Engine.pow2char[Globals.fire.getPicture() & 7]);
            }
            View.viewProcessSprites(x, y, z);
            Mirror.setMirrorParalax(true);
            Main.engine.drawmasks();
            Mirror.setMirrorParalax(false);
            Mirror.processMirror(x, y);
            gView.pSprite.cstat = oldcstat;
            if ((deliriumTilt != 0 || bDelirious) && gl == null) {
                int tilt;
                if (Main.engine.getTile((int)4078).data == null) {
                    Main.game.dassert("waloff[ TILTBUFFER ] != null");
                }
                Main.engine.setviewback();
                int nFlags = 1090;
                if (bDelirious) {
                    nFlags |= 0x21;
                }
                if (Main.engine.glrender() == null) {
                    nFlags |= 4;
                }
                if ((tilt = deliriumTilt & 0x1FF) > 256) {
                    tilt = 512 - tilt;
                }
                Main.engine.rotatesprite(0xA00000, 0x640000, Pragmas.dmulscale(256000L, Trig.Cos(tilt), 160000L, Trig.Sin(tilt), 32), deliriumTilt + (Main.engine.glrender() != null ? 0 : 512), 4078, 0, 0, nFlags, gViewX0, gViewY0, gViewX1, gViewY1);
            }
            if (!bDelirious) {
                deliriumTilt = 0;
                deliriumTurn = 0;
                deliriumPitch = 0;
            }
            if (gViewPos == 0) {
                if ((!Main.game.menu.gShowMenu || Main.game.menu.getCurrentMenu() instanceof MenuInterfaceSet) && Main.cfg.gCrosshair) {
                    viewCrossX = 160 - (gView.lookang >> 1);
                    viewCrossY = 90;
                    if (PLAYER.newHoriz && !DEMO.IsOriginalDemo()) {
                        viewCrossY = 100;
                    }
                    viewCrossY += Pragmas.klabs(gView.lookang) / 9;
                    viewCrossY = (int)((long)viewCrossY + (crossDz >> 7));
                    int zoom = Main.cfg.gCrossSize;
                    if (Globals.SplitScreen) {
                        zoom >>= 1;
                    }
                    viewCrossX = Pragmas.divscale(viewCrossX, gViewX1Scaled, 16);
                    viewCrossY = Pragmas.divscale(viewCrossY, gViewY1Scaled, 16);
                    viewCrossZoom = Pragmas.divscale(zoom, gViewY1Scaled, 16);
                }
                viewWeaponX = 160 + (swayWidth >> 8);
                viewWeaponY = 220 + (swayHeight >> 8) + (weapOffZ >> 7);
                if (Globals.SplitScreen && gViewIndex == 0) {
                    viewWeaponY = 120 + (swayHeight >> 8) + (weapOffZ >> 7);
                }
            }
        }
    }

    public static void updateviewmap() {
        short i = Globals.gPlayer[View.gViewIndex].pSprite.sectnum;
        if (i > -1) {
            int wallid = Engine.sector[i].wallptr;
            int n = i >> 3;
            Engine.show2dsector[n] = (byte)(Engine.show2dsector[n] | 1 << (i & 7));
            for (int j = Engine.sector[i].wallnum; j > 0; --j) {
                WALL wal = Engine.wall[wallid++];
                i = wal.nextsector;
                if (i < 0 || (wal.cstat & 0x71) != 0 || Engine.wall[wal.nextwall] != null && (Engine.wall[wal.nextwall].cstat & 0x71) != 0 || Engine.sector[i] != null && Engine.sector[i].ceilingz >= Engine.sector[i].floorz) continue;
                int n2 = i >> 3;
                Engine.show2dsector[n2] = (byte)(Engine.show2dsector[n2] | 1 << (i & 7));
            }
        }
    }

    public static void viewDrawBurn(int burnTime) {
        if (burnTime == 0) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            int nTile = View.burnTable[i].nTile + Main.engine.animateoffs((short)View.burnTable[i].nTile, i - 32768);
            int nPal = View.burnTable[i].nPal;
            int nFlags = View.burnTable[i].nFlags;
            int zoom = View.burnTable[i].zoom;
            if (burnTime < 600) {
                zoom = burnTime * (zoom / 600);
            }
            View.viewDrawSprite(View.burnTable[i].x << 16, View.burnTable[i].y << 16, zoom, 0, nTile, 0, nPal, nFlags | 0x400, Engine.windowx1, Engine.windowy1, Engine.windowx2, Engine.windowy2);
        }
    }

    public static void viewDisplayMessage(int nPlayer) {
        if (!Main.cfg.MessageState || Main.game.menu.gShowMenu) {
            return;
        }
        int x = 0;
        int y = 0;
        int nShade = Gameutils.ClipHigh(numQuotes << 3, 48);
        if (gViewMode == 3) {
            x = Pragmas.mulscale(gViewX0, gViewX1Scaled, 16);
            y = Pragmas.mulscale(gViewY0, gViewY1Scaled, 16);
        }
        y += nextY;
        if (Globals.pGameInfo.nGameType != 0 && Globals.pGameInfo.nGameType != 3) {
            int row = (Mmulti.numplayers - 1) / 4;
            y += (row + 1) * 9;
        }
        if (Globals.pGameInfo.nGameType == 3) {
            y += 22;
        }
        for (int i = 0; i < numQuotes; ++i) {
            QUOTE quote = quotes[(i + hideQuotes) % 16];
            if (Globals.gFrameClock < quote.messageTime) {
                Main.game.getFont(Main.cfg.MessageFont).drawText(x + 1, y, Gameutils.toCharArray(quote.messageText), nShade, quote.pal, BuildFont.TextAlign.Left, 258, false);
                y += yOffset;
                nShade = Gameutils.ClipLow(nShade - 64 / numQuotes, -128);
                continue;
            }
            --numQuotes;
            ++hideQuotes;
            hideQuotes %= 16;
        }
        if (nextY != 0) {
            nextY = nextTime * yOffset / 120;
            nextTime += Globals.gTicks;
        }
    }

    public static int viewDrawNumber(int nFontId, int number, int x, int y, int zoom, int shade, int nPLU, BuildFont.TextAlign nAlign, int nFlags, boolean textShadow) {
        Strhandler.Bitoa(number, number_buffer);
        return Main.game.getFont(nFontId).drawText(x, y, number_buffer, zoom, shade, nPLU, nAlign, 2 | nFlags, textShadow);
    }

    public static void viewDrawInputText(int nFontId, char[] text, int textlength, int x, int y, int zoom, int shade, int nPLU, int nAlign, int nFlags, boolean textShadow) {
        if (nFontId >= 0 && nFontId < 5 && text != null) {
            if (nAlign != 0) {
                int nWidth = Main.game.getFont(nFontId).getWidth(text);
                if (nAlign == 1) {
                    nWidth >>= 1;
                }
                x -= nWidth;
            }
            for (int pos = 0; pos < textlength && text[pos] != '\u0000'; ++pos) {
                x += Main.game.getFont(nFontId).drawChar(x, y, text[pos], zoom, shade, nPLU, 2 | nFlags, textShadow);
            }
        }
    }

    private static void viewDrawSprite(int sx, int sy, int nZoom, int nAngle, int nTile, int nShade, int nPLU, int nFlags, int wx1, int wy1, int wx2, int wy2) {
        if ((nFlags & 0x800) != 0) {
            nAngle = nAngle + 1024 & 0x7FF;
            nFlags ^= 4;
        }
        Main.engine.rotatesprite(sx, sy, nZoom, (short)nAngle, nTile, nShade, nPLU, nFlags, wx1, wy1, wx2, wy2);
    }

    /*
     * Unable to fully structure code
     */
    public static void viewProcessSprites(long nViewX, long nViewY, long nViewZ) {
        gView = Globals.gPlayer[View.gViewIndex];
        if (gView == null) {
            return;
        }
        if (Engine.spritesortcnt > 1024) {
            return;
        }
        ospritesortcnt = Engine.spritesortcnt;
        maphack_sprite = -1;
        if (Globals.maphack_highlight) {
            maphack_sprite = Main.game.getSprite();
        }
        block42: for (nTSprite = Engine.spritesortcnt - 1; nTSprite >= 0; --nTSprite) {
            pTSprite = Engine.tsprite[nTSprite];
            pTXSprite = null;
            nXSprite = pTSprite.extra;
            if (pTSprite.detail > Main.cfg.gDetail || pTSprite.sectnum == -1) {
                pTSprite.xrepeat = 0;
                continue;
            }
            if (nXSprite > 0) {
                pTXSprite = DB.xsprite[nXSprite];
            }
            if ((nTile = pTSprite.picnum) < 0 || nTile >= Globals.kMaxTiles) {
                System.err.println("tsprite[].cstat = " + pTSprite.cstat);
                System.err.println("tsprite[].shade = " + pTSprite.shade);
                System.err.println("tsprite[].pal = " + pTSprite.pal);
                System.err.println("tsprite[].picnum = " + pTSprite.picnum);
                System.err.println("tsprite[].ang = " + pTSprite.ang);
                System.err.println("tsprite[].owner = " + pTSprite.owner);
                System.err.println("tsprite[].sectnum = " + pTSprite.sectnum);
                System.err.println("tsprite[].statnum = " + pTSprite.statnum);
                System.err.println("tsprite[].type = " + pTSprite.lotag);
                System.err.println("tsprite[].flags = " + pTSprite.hitag);
                System.err.println("tsprite[].extra = " + pTSprite.extra);
                if (nTile < 0 || nTile >= Globals.kMaxTiles) {
                    Main.game.dassert("nTile >= 0 && nTile < kMaxTiles");
                }
            }
            oldLoc = Main.game.pInt.getsprinterpolate(pTSprite.owner);
            if (Main.cfg.gInterpolation == 1 && oldLoc != null && (pTSprite.hitag & 512) == 0) {
                x = oldLoc.x;
                y = oldLoc.y;
                z = oldLoc.z;
                nAngle = oldLoc.ang;
                nAngle = (short)(nAngle + Pragmas.mulscale((pTSprite.ang - oldLoc.ang + 1024 & 2047) - 1024, View.smoothratio, 16));
                pTSprite.x = x += Pragmas.mulscale(pTSprite.x - oldLoc.x, View.smoothratio, 16);
                pTSprite.y = y += Pragmas.mulscale(pTSprite.y - oldLoc.y, View.smoothratio, 16);
                pTSprite.z = z += Pragmas.mulscale(pTSprite.z - oldLoc.z, View.smoothratio, 16);
                pTSprite.ang = nAngle;
            }
            nFrames = 0;
            pic = Main.engine.getTile(pTSprite.picnum);
            switch (1.$SwitchMap$ru$m210projects$Blood$Types$BloodTile$ViewType[pic.getView().ordinal()]) {
                case 1: {
                    if (nXSprite <= 0) break;
                    if (nXSprite >= 2048) {
                        Main.game.dassert("nXSprite < kMaxXSprites");
                    }
                    switch (pTSprite.lotag) {
                        case 20: 
                        case 21: {
                            if (DB.xsprite[nXSprite].state == 0) break;
                            nFrames = 1;
                            break;
                        }
                        case 22: {
                            nFrames = DB.xsprite[nXSprite].data1;
                        }
                    }
                    break;
                }
                case 2: {
                    dx = nViewX - (long)pTSprite.x;
                    dy = nViewY - (long)pTSprite.y;
                    Trig.RotateVector(dx, dy, -pTSprite.ang + 128);
                    nFrames = Trig.GetOctant((int)Trig.rotated.x, (int)Trig.rotated.y);
                    if (nFrames > 4) {
                        nFrames = 8 - nFrames;
                        pTSprite.cstat = (short)(pTSprite.cstat | 4);
                        break;
                    }
                    pTSprite.cstat = (short)(pTSprite.cstat & -5);
                    break;
                }
                case 3: {
                    dx = nViewX - (long)pTSprite.x;
                    dy = nViewY - (long)pTSprite.y;
                    Trig.RotateVector(dx, dy, -pTSprite.ang + 128);
                    nFrames = Trig.GetOctant((int)Trig.rotated.x, (int)Trig.rotated.y);
                    break;
                }
                case 4: {
                    if (nXSprite <= 0) {
                        Gameutils.GetSpriteExtents(pTSprite);
                        if (Main.engine.getflorzofslope(pTSprite.sectnum, pTSprite.x, pTSprite.y) <= Gameutils.extents_zBot) break;
                        nFrames = 1;
                        break;
                    }
                    if (Actor.gSpriteHit[nXSprite].floorHit != 0) break;
                    nFrames = 1;
                    break;
                }
                case 5: 
                case 6: {
                    if (Main.cfg.gDetail < 4 || (pTSprite.hitag & 16) != 0 || pic.getView() != BloodTile.ViewType.kSpriteViewSpinVoxel) break;
                    pTSprite.ang = (short)(8 * Engine.totalclock & 2047);
                    break;
                }
            }
            while (nFrames > 0) {
                pTSprite.picnum = (short)(pTSprite.picnum + (Main.engine.getTile(pTSprite.picnum).getFrames() + 1));
                if (pTSprite.picnum >= Globals.kMaxTiles - 1) break;
                --nFrames;
            }
            if (pTSprite.sectnum < 0 || pTSprite.sectnum > Engine.numsectors) continue;
            sprshade = pTSprite.shade;
            pSector = Engine.sector[pTSprite.sectnum];
            pXSector = null;
            if (pSector.extra > 0) {
                pXSector = DB.xsector[pSector.extra];
            }
            if ((pSector.ceilingstat & 1) == 0 || (pSector.floorstat & 32768) != 0) {
                shade1 = pSector.floorshade;
                shade2 = Tile.shadeTable[pSector.floorpicnum];
            } else {
                shade1 = pSector.ceilingshade;
                shade2 = Tile.shadeTable[pSector.ceilingpicnum];
            }
            sprshade = pTSprite.shade + shade1 + shade2 + (pTSprite.picnum >= 0 ? Tile.shadeTable[pTSprite.picnum] : 0);
            pTSprite.shade = (byte)Gameutils.ClipRange(sprshade, -128, Engine.numshades - 1);
            if ((pTSprite.hitag & 16) != 0 && Engine.sprite[pTSprite.owner].owner == 3) {
                if (pTXSprite == null) {
                    Main.game.dassert("pTXSprite != NULL");
                }
                pTSprite.picnum = (short)(2272 + 2 * pTXSprite.respawnPending);
                pTSprite.xrepeat = (short)48;
                pTSprite.yrepeat = (short)48;
                pTSprite.shade = (byte)-128;
                pTSprite.cstat = (short)(pTSprite.cstat & -515);
                pTSprite.yrepeat = (Actor.IsItemSprite(pTSprite) != false || Actor.IsAmmoSprite(pTSprite) != false) && Globals.pGameInfo.nItemSettings == 2 || Actor.IsWeaponSprite(pTSprite) != false && Globals.pGameInfo.nWeaponSettings == 3 ? (short)48 : 0;
                pTSprite.xrepeat = pTSprite.yrepeat;
            }
            if (Engine.spritesortcnt >= 1024) continue;
            if (pTXSprite != null && Actor.actGetBurnTime(pTXSprite) > 0) {
                pTSprite.shade = (byte)Gameutils.ClipRange(pTSprite.shade - Pragmas.mulscale(8L, Gameutils.vRandom(), 15) - 16, -128, 127);
            }
            if ((pTSprite.hitag & 256) != 0) {
                View.viewAddEffect(nTSprite, 6);
            }
            if (Mirror.display_mirror) {
                // empty if block
            }
            if ((pTSprite.hitag & 1024) != 0) {
                pTSprite.cstat = (short)(pTSprite.cstat | 4);
            }
            if ((pTSprite.hitag & 2048) != 0) {
                pTSprite.cstat = (short)(pTSprite.cstat | 8);
            }
            switch (pTSprite.statnum) {
                case 0: {
                    switch (pTSprite.lotag) {
                        case 30: {
                            if (pTXSprite != null) {
                                if (pTXSprite.state != 0) {
                                    pTSprite.picnum = (short)(pTSprite.picnum + 1);
                                    View.viewAddEffect(nTSprite, 4);
                                    break;
                                }
                                View.viewAddEffect(nTSprite, 6);
                                break;
                            }
                            pTSprite.picnum = (short)(pTSprite.picnum + 1);
                            View.viewAddEffect(nTSprite, 4);
                            break;
                        }
                        case 32: {
                            if (pTXSprite != null && pTXSprite.state == 0) {
                                pTSprite.shade = (byte)-8;
                                break;
                            }
                            pTSprite.shade = (byte)-128;
                            View.viewAddEffect(nTSprite, 11);
                            break;
                        }
                        default: {
                            if (pXSector != null && pXSector.color) {
                                pTSprite.pal = (byte)pSector.floorpal;
                                break;
                            }
                            ** GOTO lbl302
                        }
                    }
                    ** GOTO lbl302
                }
                case 3: {
                    switch (pTSprite.lotag) {
                        case 145: {
                            if (pTXSprite != null && pTXSprite.state != 0 && Globals.pGameInfo.nGameType == 3 && (pEffect = View.viewAddEffect(nTSprite, 17)) != null) {
                                pEffect.pal = (short)10;
                                break;
                            }
                            ** GOTO lbl302
                        }
                        case 146: {
                            if (pTXSprite != null && pTXSprite.state != 0 && Globals.pGameInfo.nGameType == 3 && (pEffect = View.viewAddEffect(nTSprite, 17)) != null) {
                                pEffect.pal = (short)7;
                                break;
                            }
                            ** GOTO lbl302
                        }
                        case 147: {
                            pTSprite.pal = (short)10;
                            pTSprite.cstat = (short)(pTSprite.cstat | 4);
                            break;
                        }
                        case 148: {
                            pTSprite.pal = (short)7;
                            pTSprite.cstat = (short)(pTSprite.cstat | 4);
                            break;
                        }
                        default: {
                            if (pTSprite.lotag >= 100 && pTSprite.lotag <= 106) {
                                pTSprite.shade = (byte)-128;
                            }
                            if (pXSector != null && pXSector.color) {
                                pTSprite.pal = (byte)pSector.floorpal;
                                break;
                            }
                            ** GOTO lbl302
                        }
                    }
                    ** GOTO lbl302
                }
                case 5: {
                    switch (pTSprite.lotag) {
                        case 302: {
                            pTSprite.cstat = (short)(pTSprite.cstat | 32);
                            pTSprite.shade = (byte)-128;
                            ** GOTO lbl302
                        }
                        case 306: {
                            View.viewAddEffect(nTSprite, 15);
                            ** GOTO lbl302
                        }
                        case 300: {
                            View.viewAddEffect(nTSprite, 10);
                            ** GOTO lbl302
                        }
                        case 301: 
                        case 303: {
                            if (pTSprite.statnum != 14) {
                                View.viewAddEffect(nTSprite, 1);
                                if (pTSprite.lotag == 301) {
                                    if ((pSector.ceilingstat & 1) == 0 && pTSprite.z - pSector.ceilingz >> 8 < 64 && pSector.ceilingpicnum < 4080) {
                                        View.viewAddEffect(nTSprite, 2);
                                    }
                                    if ((pSector.floorstat & 1) == 0 && pSector.floorz - pTSprite.z >> 8 < 64 && pSector.floorpicnum < 4080) {
                                        View.viewAddEffect(nTSprite, 3);
                                    }
                                }
                            } else {
                                if (pTXSprite == null) {
                                    Main.game.dassert("pTXSprite != NULL");
                                }
                                if (pTXSprite.target != gView.nSprite) {
                                    View.viewAddEffect(nTSprite, 1);
                                    if (pTSprite.lotag == 301) {
                                        if ((pSector.ceilingstat & 1) == 0 && pTSprite.z - pSector.ceilingz >> 8 < 64 && pSector.ceilingpicnum < 4080) {
                                            View.viewAddEffect(nTSprite, 2);
                                        }
                                        if ((pSector.floorstat & 1) == 0 && pSector.floorz - pTSprite.z >> 8 < 64 && pSector.floorpicnum < 4080) {
                                            View.viewAddEffect(nTSprite, 3);
                                        }
                                    }
                                } else {
                                    pTSprite.xrepeat = 0;
                                }
                            }
                            ** GOTO lbl302
                        }
                    }
                    continue block42;
                }
                case 6: {
                    if (pTSprite.lotag == 242) {
                        pTSprite.xrepeat = (short)48;
                    }
                    if (Engine.sector[pTSprite.sectnum].extra > 0 && DB.xsector[Engine.sector[pTSprite.sectnum].extra].color) {
                        switch (pTSprite.lotag) {
                            case 201: 
                            case 202: 
                            case 230: 
                            case 246: 
                            case 247: 
                            case 248: 
                            case 249: {
                                break;
                            }
                            default: {
                                pTSprite.pal = (byte)Engine.sector[pTSprite.sectnum].floorpal;
                            }
                        }
                    }
                    if (PLAYER.powerupCheck(gView, 25) > 0) {
                        pTSprite.shade = (byte)-128;
                    }
                    if (Gameutils.IsPlayerSprite(pTSprite)) {
                        pPlayer = Globals.gPlayer[pTSprite.lotag - 231];
                        if (pTSprite.owner != gView.pSprite.xvel && Pragmas.klabs(Pragmas.mulscale(losAngle = (1024 + (nAngle = Main.engine.getangle(tx = pTSprite.x - (int)nViewX, ty = pTSprite.y - (int)nViewY)) - gView.pSprite.ang & 2047) - 1024, dist = Main.engine.qdist(tx, ty), 14)) < 4) {
                            z1 = (long)Pragmas.mulscale(dist, (int)gView.horizOff, 10) + nViewZ;
                            Gameutils.GetSpriteExtents(pTSprite);
                            if (z1 < (long)Gameutils.extents_zBot && z1 > (long)Gameutils.extents_zTop && Main.engine.cansee((int)nViewX, (int)nViewY, (int)nViewZ, gView.pSprite.sectnum, pTSprite.x, pTSprite.y, pTSprite.z, pTSprite.sectnum)) {
                                View.gPlayerIndex = pPlayer.nPlayer;
                            }
                        }
                        if (PLAYER.powerupCheck(pPlayer, 13) == 0 || PLAYER.powerupCheck(gView, 25) > 0) {
                            if (PLAYER.powerupCheck(pPlayer, 14) != 0) {
                                pTSprite.shade = (byte)-128;
                                pTSprite.pal = (short)5;
                            } else if (PLAYER.powerupCheck(pPlayer, 23) != 0) {
                                pTSprite.pal = (byte)((gView.teamID & 3) + 11);
                            }
                        } else {
                            pTSprite.cstat = (short)(pTSprite.cstat | 2);
                            pTSprite.pal = (short)5;
                        }
                        if (PLAYER.powerupCheck(pPlayer, 24) != 0) {
                            View.viewAddEffect(nTSprite, 13);
                        }
                        if (Main.cfg.gShowWeapon && Globals.pGameInfo.nGameType > 0 && pPlayer != gView) {
                            View.viewAddEffect(nTSprite, 12);
                        }
                        if ((pPlayer.fireEffect & 1) != 0 && (pPlayer != gView || View.gViewPos != 0) && (pEffect = View.viewAddEffect(nTSprite, 14)) != null) {
                            cp = Globals.gPosture[pPlayer.nLifeMode][pPlayer.moveState];
                            pEffect.x += Pragmas.mulscale(Trig.Cos(pTSprite.ang), cp.xoffset, 28);
                            pEffect.y += Pragmas.mulscale(Trig.Sin(pTSprite.ang), cp.xoffset, 28);
                            pEffect.z = pPlayer.pSprite.z - cp.zoffset;
                        }
                        if (pPlayer.hasFlag > 0 && Globals.pGameInfo.nGameType == 3) {
                            if ((pPlayer.hasFlag & 1) != 0 && (pEffect = View.viewAddEffect(nTSprite, 16)) != null) {
                                pEffect.pal = (short)10;
                                pEffect.cstat = (short)(pEffect.cstat | 4);
                            }
                            if ((pPlayer.hasFlag & 2) != 0 && (pEffect = View.viewAddEffect(nTSprite, 16)) != null) {
                                pEffect.pal = (short)7;
                                pEffect.cstat = (short)(pEffect.cstat | 4);
                            }
                        }
                    }
                    if ((pTSprite.owner != gView.pSprite.xvel || View.gViewPos != 0) && (long)Main.engine.getflorzofslope(pTSprite.sectnum, pTSprite.x, pTSprite.y) >= nViewZ && (pTSpr = View.viewAddEffect(nTSprite, 0)) != null) {
                        camangle = Main.engine.getangle((int)nViewX - pTSprite.x, (int)nViewY - pTSprite.y);
                        pTSpr.x -= Pragmas.mulscale(Engine.sintable[camangle + 512 & 2047], 300L, 16);
                        pTSpr.y += Pragmas.mulscale(Engine.sintable[camangle + 1024 & 2047], 300L, 16);
                    }
                    ** GOTO lbl302
                }
                case 11: {
                    if (pTSprite.lotag == 454) {
                        if (pTXSprite.state == 1) {
                            if (pTXSprite.data1 != 0) {
                                pTSprite.picnum = (short)772;
                                if (pTXSprite.data2 != 0) {
                                    View.viewAddEffect(nTSprite, 9);
                                }
                            }
                        } else {
                            pTSprite.picnum = pTXSprite.data1 != 0 ? (short)773 : (short)656;
                        }
                    }
                    ** GOTO lbl302
                }
                case 4: {
                    if (pXSector != null && pXSector.color) {
                        pTSprite.pal = (byte)pSector.floorpal;
                    }
                    if ((pTSprite.hitag & 1) != 0 && (long)Main.engine.getflorzofslope(pTSprite.sectnum, pTSprite.x, pTSprite.y) >= nViewZ && (pTSprite.lotag < 400 || pTSprite.lotag >= 436 || Actor.gSpriteHit[pTSprite.extra].floorHit == 0)) {
                        View.viewAddEffect(nTSprite, 0);
                    }
                }
lbl302:
                // 19 sources

                default: {
                    if (maphack_sprite == -1 || maphack_sprite != pTSprite.owner) continue block42;
                    pTSprite.shade = (byte)(32 - Engine.totalclock & 32);
                }
            }
        }
        for (nTSprite = Engine.spritesortcnt - 1; nTSprite >= ospritesortcnt; --nTSprite) {
            pTSprite = Engine.tsprite[nTSprite];
            nFrames = 0;
            switch (1.$SwitchMap$ru$m210projects$Blood$Types$BloodTile$ViewType[Main.engine.getTile(pTSprite.picnum).getView().ordinal()]) {
                case 2: {
                    dx = nViewX - (long)pTSprite.x;
                    dy = nViewY - (long)pTSprite.y;
                    Trig.RotateVector(dx, dy, -pTSprite.ang + 128);
                    nFrames = Trig.GetOctant((int)Trig.rotated.x, (int)Trig.rotated.y);
                    if (nFrames > 4) {
                        nFrames = 8 - nFrames;
                        pTSprite.cstat = (short)(pTSprite.cstat | 4);
                        break;
                    }
                    pTSprite.cstat = (short)(pTSprite.cstat & -5);
                    break;
                }
                case 3: {
                    dx = nViewX - (long)pTSprite.x;
                    dy = nViewY - (long)pTSprite.y;
                    Trig.RotateVector(dx, dy, -pTSprite.ang + 128);
                    nFrames = Trig.GetOctant((int)Trig.rotated.x, (int)Trig.rotated.y);
                    break;
                }
            }
            while (nFrames > 0) {
                --nFrames;
                pTSprite.picnum = (short)(pTSprite.picnum + (Main.engine.getTile(pTSprite.picnum).getFrames() + 1));
            }
        }
    }

    public static void viewShowLoadingTile() {
        int flags = 74;
        int pic = 2049;
        switch (4 * Engine.ydim / Engine.xdim) {
            default: {
                pic = 2049;
                break;
            }
            case 2: {
                if (Main.engine.getTile((int)9223).data == null) break;
                pic = 9223;
                break;
            }
            case 1: {
                if (Main.engine.getTile((int)9224).data == null) break;
                pic = 9224;
            }
        }
        Main.engine.rotatesprite(0xA00000, 0x640000, 65536, 0, pic, 0, 0, flags, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
    }

    public static void DoLensEffect() {
        byte[] s;
        byte[] d = Main.engine.getTile((int)4077).data;
        if (d == null) {
            Main.game.dassert("d != null");
        }
        if ((s = Main.engine.getTile((int)4079).data) == null) {
            Main.game.dassert("s != null");
        }
        int i = 0;
        int dptr = 0;
        while (i < 6400) {
            int lensData = LittleEndian.getInt(lensTable, 4 * i);
            if (lensData >= 0) {
                d[dptr] = s[lensData];
            }
            ++i;
            ++dptr;
        }
        Main.engine.getrender().invalidatetile(4077, 0, -1);
    }

    public static void viewSecretStat() {
        Main.game.getFont(1).drawText(75, 70, Strings.secrets, -128, 0, BuildFont.TextAlign.Left, 2, true);
        View.viewDrawNumber(1, LEVELS.foundSecret, 160, 70, 65536, -128, 0, BuildFont.TextAlign.Left, 0, true);
        Main.game.getFont(1).drawText(190, 70, Strings.of, -128, 0, BuildFont.TextAlign.Left, 2, true);
        View.viewDrawNumber(1, LEVELS.totalSecrets, 220, 70, 65536, -128, 0, BuildFont.TextAlign.Left, 0, true);
        if (LEVELS.superSecrets > 0) {
            Main.game.getFont(1).drawText(160, 100, Strings.supersecret, -128, 2, BuildFont.TextAlign.Center, 2, true);
        }
    }

    public static void viewFragStat() {
        Main.game.getFont(1).drawText(75, 50, Strings.killsstat, -128, 0, BuildFont.TextAlign.Left, 2, true);
        View.viewDrawNumber(1, LEVELS.kills, 160, 50, 65536, -128, 0, BuildFont.TextAlign.Left, 0, true);
        Main.game.getFont(1).drawText(190, 50, Strings.of, -128, 0, BuildFont.TextAlign.Left, 2, true);
        View.viewDrawNumber(1, LEVELS.totalKills, 220, 50, 65536, -128, 0, BuildFont.TextAlign.Left, 0, true);
    }

    public static void viewBackupSpriteLoc(int nSprite, SPRITE pSprite) {
        Main.game.pInt.setsprinterpolate(nSprite, pSprite);
    }

    public static void viewBackupSectorLoc(int nSector, SECTOR pSector) {
        Main.game.pInt.setceilinterpolate(nSector, pSector);
        Main.game.pInt.setfheinuminterpolate(nSector, pSector);
        Main.game.pInt.setfloorinterpolate(nSector, pSector);
    }

    public static SPRITE viewInsertTSprite(int nSector, int nStatus, SPRITE pSource) {
        int nTSprite = -1;
        nTSprite = (short)Engine.spritesortcnt;
        if (Engine.tsprite[nTSprite] == null) {
            Engine.tsprite[nTSprite] = new SPRITE();
        }
        SPRITE pTSprite = Engine.tsprite[nTSprite];
        pTSprite.reset((byte)0);
        pTSprite.lotag = (short)-1;
        pTSprite.sectnum = (short)nSector;
        pTSprite.statnum = (short)nStatus;
        pTSprite.cstat = (short)128;
        pTSprite.xrepeat = (short)64;
        pTSprite.yrepeat = (short)64;
        pTSprite.owner = (short)-1;
        pTSprite.extra = (short)-1;
        ++Engine.spritesortcnt;
        if (pSource != null) {
            pTSprite.x = pSource.x;
            pTSprite.y = pSource.y;
            pTSprite.z = pSource.z;
            pTSprite.owner = pSource.owner;
            pTSprite.ang = pSource.ang;
        }
        return pTSprite;
    }

    private static SPRITE viewAddEffect(int nTSprite, int nViewEffect) {
        if (nViewEffect < 0 || nViewEffect >= 19) {
            Main.game.dassert("nViewEffect >= 0 && nViewEffect < kViewEffectMax " + nViewEffect);
        }
        SPRITE pTSprite = Engine.tsprite[nTSprite];
        if (Main.cfg.gDetail < gEffectDetail[nViewEffect] || Engine.spritesortcnt >= 1024 || nViewEffect > 18) {
            return null;
        }
        switch (nViewEffect) {
            case 0: {
                SPRITE pTEffect = View.viewInsertTSprite(pTSprite.sectnum, Short.MAX_VALUE, pTSprite);
                pTEffect.z = Main.engine.getflorzofslope(pTSprite.sectnum, pTEffect.x, pTEffect.y);
                pTEffect.cstat = (short)(pTEffect.cstat | 2);
                if (Main.engine.getTile(Engine.sprite[pTSprite.owner].picnum).getView() == BloodTile.ViewType.kSpriteView5Full) {
                    int dx = Globals.gPlayer[View.gViewIndex].pSprite.x - pTEffect.x;
                    int dy = Globals.gPlayer[View.gViewIndex].pSprite.y - pTEffect.y;
                    Trig.RotateVector(dx, dy, -pTEffect.ang + 128);
                    int nFrames = Trig.GetOctant((int)Trig.rotated.x, (int)Trig.rotated.y);
                    if (nFrames > 4) {
                        nFrames = 8 - nFrames;
                        pTEffect.cstat = (short)(pTEffect.cstat | 4);
                    } else {
                        pTEffect.cstat = (short)(pTEffect.cstat & 0xFFFFFFFB);
                    }
                }
                pTEffect.shade = (byte)127;
                pTEffect.xrepeat = pTSprite.xrepeat;
                pTEffect.yrepeat = (short)(pTSprite.yrepeat >> 2);
                pTEffect.picnum = pTSprite.picnum;
                pTEffect.pal = (short)5;
                BloodTile pic = Main.engine.getTile(pTEffect.picnum);
                pTEffect.z -= (pic.getHeight() - (pic.getOffsetY() + pic.getHeight() / 2)) * pTEffect.yrepeat << 2;
                return pTEffect;
            }
            case 1: {
                SPRITE pTEffect = View.viewInsertTSprite(pTSprite.sectnum, Short.MAX_VALUE, pTSprite);
                pTEffect.shade = (byte)-128;
                pTEffect.pal = (short)2;
                pTEffect.z = pTSprite.z;
                pTEffect.cstat = (short)(pTEffect.cstat | 2);
                pTEffect.picnum = (short)2427;
                pTEffect.xrepeat = pTSprite.xrepeat;
                pTEffect.yrepeat = pTSprite.yrepeat;
                break;
            }
            case 2: {
                SPRITE pTEffect = View.viewInsertTSprite(pTSprite.sectnum, Short.MAX_VALUE, pTSprite);
                pTEffect.x = pTSprite.x;
                pTEffect.y = pTSprite.y;
                pTEffect.pal = (short)2;
                pTEffect.xrepeat = (short)64;
                pTEffect.yrepeat = (short)64;
                pTEffect.picnum = (short)624;
                pTEffect.z = Engine.sector[pTSprite.sectnum].ceilingz;
                pTEffect.shade = (byte)((pTSprite.z - Engine.sector[pTSprite.sectnum].ceilingz >> 8) - 64);
                pTEffect.cstat = (short)(pTEffect.cstat | 0x6A);
                pTEffect.ang = pTSprite.ang;
                pTEffect.owner = pTSprite.owner;
                break;
            }
            case 3: {
                SPRITE pTEffect = View.viewInsertTSprite(pTSprite.sectnum, Short.MAX_VALUE, pTSprite);
                pTEffect.x = pTSprite.x;
                pTEffect.y = pTSprite.y;
                pTEffect.pal = (short)2;
                pTEffect.picnum = (short)624;
                pTEffect.z = Engine.sector[pTSprite.sectnum].floorz;
                pTEffect.shade = (byte)((Engine.sector[pTSprite.sectnum].floorz - pTSprite.z >> 8) - 32);
                pTEffect.xrepeat = (short)(Engine.sector[pTSprite.sectnum].floorz - pTSprite.z >> 8);
                pTEffect.yrepeat = (short)(Engine.sector[pTSprite.sectnum].floorz - pTSprite.z >> 8);
                pTEffect.cstat = (short)(pTEffect.cstat | 0x62);
                pTEffect.ang = pTSprite.ang;
                pTEffect.owner = pTSprite.owner;
                break;
            }
            case 4: {
                short size;
                SPRITE pTEffect = View.viewInsertTSprite(pTSprite.sectnum, Short.MAX_VALUE, pTSprite);
                Gameutils.GetSpriteExtents(pTSprite);
                pTEffect.picnum = (short)2101;
                pTEffect.shade = (byte)-128;
                pTEffect.z = Gameutils.extents_zTop;
                pTEffect.yrepeat = size = (short)(Main.engine.getTile(pTSprite.picnum).getWidth() * pTSprite.xrepeat / 32);
                pTEffect.xrepeat = size;
                break;
            }
            case 5: {
                short size;
                SPRITE pTEffect = View.viewInsertTSprite(pTSprite.sectnum, Short.MAX_VALUE, pTSprite);
                Gameutils.GetSpriteExtents(pTSprite);
                pTEffect.picnum = (short)2101;
                pTEffect.shade = (byte)-128;
                pTEffect.z = Gameutils.extents_zBot;
                pTEffect.yrepeat = size = (short)(Main.engine.getTile(pTSprite.picnum).getWidth() * pTSprite.xrepeat / 32);
                pTEffect.xrepeat = size;
                break;
            }
            case 6: {
                SPRITE pTEffect = View.viewInsertTSprite(pTSprite.sectnum, Short.MAX_VALUE, pTSprite);
                Gameutils.GetSpriteExtents(pTSprite);
                pTEffect.z = Gameutils.extents_zTop;
                pTEffect.picnum = pTSprite.lotag >= 200 && pTSprite.lotag < 247 ? (short)672 : (short)754;
                pTEffect.shade = (byte)8;
                pTEffect.cstat = (short)(pTEffect.cstat | 2);
                pTEffect.xrepeat = pTSprite.xrepeat;
                pTEffect.yrepeat = pTSprite.yrepeat;
                break;
            }
            case 7: {
                SPRITE pTEffect = View.viewInsertTSprite(pTSprite.sectnum, Short.MAX_VALUE, pTSprite);
                Gameutils.GetSpriteExtents(pTSprite);
                pTEffect.z = Gameutils.extents_zBot;
                pTEffect.picnum = pTSprite.lotag >= 200 && pTSprite.lotag < 247 ? (short)672 : (short)754;
                pTEffect.shade = (byte)8;
                pTEffect.cstat = (short)(pTEffect.cstat | 2);
                pTEffect.xrepeat = pTSprite.xrepeat;
                pTEffect.yrepeat = pTSprite.yrepeat;
                break;
            }
            case 8: {
                SPRITE pTEffect = View.viewInsertTSprite(pTSprite.sectnum, Short.MAX_VALUE, pTSprite);
                pTEffect.shade = (byte)-128;
                pTEffect.z = pTSprite.z;
                short size = (short)(Main.engine.getTile(pTSprite.picnum).getWidth() * pTSprite.xrepeat / 64);
                pTEffect.picnum = (short)908;
                pTEffect.statnum = 0;
                pTEffect.yrepeat = size;
                pTEffect.xrepeat = size;
                break;
            }
            case 9: {
                SPRITE pTEffect = View.viewInsertTSprite(pTSprite.sectnum, Short.MAX_VALUE, pTSprite);
                pTEffect.z = pTSprite.z;
                if (Main.cfg.gDetail > 1) {
                    pTEffect.cstat = (short)(pTEffect.cstat | 0x202);
                }
                pTEffect.shade = (byte)Gameutils.ClipLow(pTSprite.shade - 32, -128);
                pTEffect.yrepeat = (short)64;
                pTEffect.picnum = (short)775;
                pTEffect.xrepeat = pTSprite.xrepeat;
                break;
            }
            case 10: {
                int nAngle = pTSprite.ang;
                nAngle = (pTSprite.cstat & 0x10) != 0 ? (nAngle += 512) : (nAngle += 1024);
                nAngle &= 0x7FF;
                for (int i = 0; i < 5 && Engine.spritesortcnt < 1024; ++i) {
                    short nSector = pTSprite.sectnum;
                    SPRITE pTEffect = View.viewInsertTSprite(pTSprite.sectnum, Short.MAX_VALUE, null);
                    pTEffect.ang = pTSprite.ang;
                    pTEffect.x = pTSprite.x + Pragmas.mulscale(Trig.Cos(nAngle), (i << 7) + 128, 30);
                    pTEffect.y = pTSprite.y + Pragmas.mulscale(Trig.Sin(nAngle), (i << 7) + 128, 30);
                    pTEffect.z = pTSprite.z;
                    if (nSector < 0 || nSector >= Globals.kMaxSectors) {
                        Main.game.dassert("nSector >= 0 && nSector < kMaxSectors");
                    }
                    Gameutils.FindSector(pTEffect.x, pTEffect.y, pTEffect.z, pTSprite.sectnum);
                    pTEffect.owner = pTSprite.owner;
                    pTEffect.picnum = pTSprite.picnum;
                    pTEffect.cstat = (short)(pTEffect.cstat | 2);
                    if (i < 2) {
                        pTEffect.cstat = (short)(pTEffect.cstat | 0x202);
                    }
                    pTEffect.shade = (byte)Gameutils.ClipLow(pTSprite.shade - 16, -128);
                    pTEffect.xrepeat = pTSprite.xrepeat;
                    pTEffect.yrepeat = pTSprite.yrepeat;
                    pTEffect.picnum = pTSprite.picnum;
                }
                break;
            }
            case 11: {
                SPRITE pTEffect = View.viewInsertTSprite(pTSprite.sectnum, Short.MAX_VALUE, pTSprite);
                Gameutils.GetSpriteExtents(pTSprite);
                pTEffect.shade = (byte)26;
                pTEffect.pal = 0;
                pTEffect.yrepeat = (short)24;
                pTEffect.picnum = (short)626;
                pTEffect.z = Gameutils.extents_zTop;
                pTEffect.cstat = (short)(pTEffect.cstat | 2);
                pTEffect.xrepeat = pTEffect.yrepeat;
                break;
            }
            case 12: {
                if (!Gameutils.IsPlayerSprite(pTSprite)) {
                    Main.game.dassert("pTSprite.type >= kDudePlayer1 && pTSprite.type <= kDudePlayer8");
                }
                PLAYER pPlayer = Globals.gPlayer[pTSprite.lotag - 231];
                if (viewWeaponTile[pPlayer.currentWeapon] == -1) break;
                SPRITE pTEffect = View.viewInsertTSprite(pTSprite.sectnum, Short.MAX_VALUE, pTSprite);
                pTEffect.x = pTSprite.x;
                pTEffect.y = pTSprite.y;
                pTEffect.z = pTSprite.z - 8192;
                pTEffect.picnum = viewWeaponTile[pPlayer.currentWeapon];
                pTEffect.shade = pTSprite.shade;
                pTEffect.xrepeat = (short)32;
                pTEffect.yrepeat = (short)32;
                break;
            }
            case 13: {
                SPRITE pTEffect = View.viewInsertTSprite(pTSprite.sectnum, Short.MAX_VALUE, pTSprite);
                pTEffect.shade = (byte)26;
                pTEffect.pal = 0;
                pTEffect.yrepeat = (short)64;
                pTEffect.picnum = (short)2089;
                pTEffect.cstat = (short)(pTEffect.cstat | 2);
                pTEffect.xrepeat = pTEffect.yrepeat;
                break;
            }
            case 14: {
                SPRITE pTEffect = View.viewInsertTSprite(pTSprite.sectnum, Short.MAX_VALUE, pTSprite);
                pTEffect.shade = (byte)-128;
                pTEffect.pal = 0;
                pTEffect.yrepeat = (short)64;
                pTEffect.picnum = (short)2605;
                pTEffect.xrepeat = pTEffect.yrepeat;
                return pTEffect;
            }
            case 15: {
                SPRITE pTEffect = View.viewInsertTSprite(pTSprite.sectnum, Short.MAX_VALUE, pTSprite);
                pTEffect.z = pTSprite.z;
                pTEffect.shade = (byte)-128;
                pTEffect.cstat = (short)(pTEffect.cstat | 2);
                pTEffect.xrepeat = pTSprite.xrepeat;
                pTEffect.picnum = (short)2135;
                pTEffect.yrepeat = pTSprite.yrepeat;
                break;
            }
            case 16: 
            case 17: {
                Gameutils.GetSpriteExtents(pTSprite);
                SPRITE pTEffect = View.viewInsertTSprite(pTSprite.sectnum, Short.MAX_VALUE, pTSprite);
                pTEffect.shade = (byte)-128;
                pTEffect.pal = 0;
                pTEffect.z = Gameutils.extents_zTop;
                pTEffect.yrepeat = nViewEffect == 16 ? (short)16 : (short)64;
                pTEffect.xrepeat = pTEffect.yrepeat;
                pTEffect.picnum = (short)3558;
                return pTEffect;
            }
            case 18: {
                for (int i = 0; i < 16; ++i) {
                    SPRITE pTEffect = View.viewInsertTSprite(pTSprite.sectnum, Short.MAX_VALUE, pTSprite);
                    int velocity = (int)((float)Pragmas.divscale(Globals.gFrameClock, 120L, 11) + View.atomEffectVelocity[i].z);
                    int dx = Pragmas.mulscale(Trig.Cos(velocity), 512L, 30);
                    int dy = Pragmas.mulscale(Trig.Sin(velocity), 512L, 30);
                    dy = (int)Trig.RotateVector((long)((long)dy), (long)0L, (int)((int)View.atomEffectVelocity[i].x)).x;
                    int dz = (int)Trig.RotateVector((long)((long)dx), (long)((long)((int)Trig.rotated.y)), (int)((int)View.atomEffectVelocity[i].y)).y;
                    dx = (int)Trig.rotated.x;
                    pTEffect.x = pTSprite.x + dx;
                    pTEffect.y = pTSprite.y + dy;
                    pTEffect.z = pTSprite.z + (dz << 4);
                    pTEffect.picnum = (short)1720;
                    pTEffect.shade = (byte)-128;
                }
                break;
            }
        }
        return null;
    }

    private static void DrawStatSprite(int nTile, int x, int y, int nShade, int nPLU, int nFlag, int nScale) {
        Main.engine.rotatesprite(x << 16, y << 16, nScale, 0, (short)nTile, nShade, nPLU, nFlag | 0xA, gViewX0, gViewY0, gViewX1, gViewY1);
    }

    static {
        quotes = new QUOTE[16];
        yOffset = 11;
        kMapZoom = 1024;
        viewThirdDist = -1;
        viewThirdClock = 0;
        number_buffer = new char[256];
        PaletteView = 0;
        otherMirrorGotpic = new byte[8];
        bakMirrorGotpic = new byte[8];
        gViewIndex = 0;
        gViewPos = 0;
        gViewMode = 3;
        deliriumTilt = 0;
        deliriumTurn = 0;
        deliriumPitch = 0;
        viewWeaponTile = new short[]{-1, -1, 524, 559, 558, 526, 589, 618, 539, 800, 525, 811, 810, -1};
        othercameradist = 1280;
        othercameraclock = 0;
        gEffectDetail = new int[]{0, 4, 4, 4, 0, 0, 0, 0, 0, 1, 4, 4, 0, 0, 0, 1, 0, 0, 0};
        atomEffectVelocity = new Vector3[16];
        burnTable = new BURN[]{new BURN(2101, 2, 0, 118784, 10, 220), new BURN(2101, 2, 0, 110592, 40, 220), new BURN(2101, 2, 0, 81920, 85, 220), new BURN(2101, 2, 0, 69632, 120, 220), new BURN(2101, 2, 0, 61440, 160, 220), new BURN(2101, 2, 0, 73728, 200, 220), new BURN(2101, 2, 0, 77824, 235, 220), new BURN(2101, 2, 0, 110592, 275, 220), new BURN(2101, 2, 0, 122880, 310, 220)};
    }
}

