/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Architecture;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.ApplicationLogger;
import com.badlogic.gdx.Audio;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.LifecycleListener;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Clipboard;
import com.badlogic.gdx.utils.GdxRuntimeException;
import ru.m210projects.Build.Architecture.ApplicationFactory;
import ru.m210projects.Build.Architecture.BuildConfiguration;
import ru.m210projects.Build.Architecture.BuildFrame;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Render.Renderer;

public class BuildApplication
implements Application {
    protected BuildFrame frame;
    protected final BuildConfiguration config;
    protected final ApplicationListener listener;
    protected final Platform platform;
    protected final Application.ApplicationType type;
    protected final Clipboard clipboard;
    protected final Files files;
    protected int version;
    protected boolean running = true;
    protected Thread mainLoopThread;
    protected final Array<Runnable> runnables = new Array();
    protected final Array<Runnable> executedRunnables = new Array();

    public BuildApplication(BuildGame listener, ApplicationFactory factory, Renderer.RenderType type) {
        this.listener = listener;
        this.config = factory.getConfiguration();
        if (this.config.title == null) {
            this.config.title = listener.getClass().getSimpleName();
        }
        this.frame = factory.getFrame();
        if (this.config.getIconPaths().size > 0) {
            this.frame.icon = this.getClass().getResource("/" + this.config.getIconPaths().first());
        }
        BuildGdx.app = this;
        Gdx.app = BuildGdx.app;
        BuildGdx.files = this.files = factory.getFiles();
        Gdx.files = this.files;
        BuildGdx.audio = factory.getAudio();
        BuildGdx.message = factory.getMessage();
        BuildGdx.message.setFrame(this.frame);
        BuildGdx.controllers = factory.getControllers();
        this.platform = factory.getPlatform();
        this.type = factory.getApplicationType();
        this.clipboard = factory.getClipboard();
        this.version = factory.getVersion();
        this.initialize(type.getFrameType());
    }

    private void initialize(final BuildFrame.FrameType type) {
        if (this.platform == Platform.Android) {
            this.frame.setType(type);
        } else {
            this.mainLoopThread = new Thread("Build Application"){

                @Override
                public void run() {
                    try {
                        BuildApplication.this.frame.setType(type);
                        BuildApplication.this.mainLoop();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        BuildApplication.this.destroyLoop();
                        if (t instanceof RuntimeException) {
                            throw (RuntimeException)t;
                        }
                        throw new GdxRuntimeException(t);
                    }
                }
            };
            this.mainLoopThread.start();
        }
    }

    private void mainLoop() {
        this.listener.create();
        while (this.running) {
            BuildGdx.input.processMessages();
            switch (this.frame.getStatus()) {
                case Closed: {
                    this.exit();
                    break;
                }
                case Running: {
                    break;
                }
                case Pause: {
                    this.listener.pause();
                    break;
                }
                case Resume: {
                    this.listener.resume();
                    break;
                }
                case Changed: {
                    this.listener.resize(this.config.width, this.config.height);
                }
            }
            boolean shouldRender = this.executeRunnables();
            if (!this.running) break;
            if (!this.frame.process(shouldRender)) continue;
            this.listener.render();
            this.frame.update();
        }
        this.destroyLoop();
    }

    private void destroyLoop() {
        if (BuildGdx.input != null) {
            BuildGdx.input.setCursorCatched(false);
        }
        if (this.listener != null) {
            this.listener.pause();
            this.listener.dispose();
        }
        if (BuildGdx.audio != null) {
            BuildGdx.audio.dispose();
        }
        if (BuildGdx.message != null) {
            BuildGdx.message.dispose();
        }
        this.frame.dispose();
    }

    public void stop() {
        this.running = false;
        try {
            this.mainLoopThread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void exit() {
        this.postRunnable(new Runnable(){

            @Override
            public void run() {
                BuildApplication.this.running = false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeRunnables() {
        Array<Runnable> array = this.runnables;
        synchronized (array) {
            for (int i = this.runnables.size - 1; i >= 0; --i) {
                this.executedRunnables.add(this.runnables.get(i));
            }
            this.runnables.clear();
        }
        if (this.executedRunnables.size == 0) {
            return false;
        }
        do {
            this.executedRunnables.pop().run();
        } while (this.executedRunnables.size > 0);
        return true;
    }

    @Override
    public ApplicationListener getApplicationListener() {
        return this.listener;
    }

    public void setFrame(BuildFrame.FrameType type) {
        this.frame.setType(type);
    }

    public boolean isActive() {
        return this.frame.getGraphics().isActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postRunnable(Runnable runnable) {
        Array<Runnable> array = this.runnables;
        synchronized (array) {
            this.runnables.add(runnable);
        }
    }

    @Override
    public Clipboard getClipboard() {
        return this.clipboard;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    @Override
    public Application.ApplicationType getType() {
        return this.type;
    }

    @Override
    public Graphics getGraphics() {
        return this.frame.getGraphics();
    }

    @Override
    public Input getInput() {
        return this.frame.getInput();
    }

    @Override
    public Files getFiles() {
        return this.files;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public long getJavaHeap() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    @Override
    public long getNativeHeap() {
        return this.getJavaHeap();
    }

    @Override
    public void log(String tag, String message) {
    }

    @Override
    public void log(String tag, String message, Throwable exception) {
    }

    @Override
    public void error(String tag, String message) {
    }

    @Override
    public void error(String tag, String message, Throwable exception) {
    }

    @Override
    public void debug(String tag, String message) {
    }

    @Override
    public void debug(String tag, String message, Throwable exception) {
    }

    @Override
    public void setLogLevel(int logLevel) {
    }

    @Override
    public int getLogLevel() {
        return 0;
    }

    @Override
    public Audio getAudio() {
        return null;
    }

    @Override
    public Net getNet() {
        return null;
    }

    @Override
    public void setApplicationLogger(ApplicationLogger applicationLogger) {
    }

    @Override
    public ApplicationLogger getApplicationLogger() {
        return null;
    }

    @Override
    public Preferences getPreferences(String name) {
        return null;
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
    }

    public static enum Platform {
        Windows,
        Linux,
        MacOSX,
        Android;

    }
}

