/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Architecture;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.net.URL;
import ru.m210projects.Build.Architecture.BuildConfiguration;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Architecture.BuildGraphics;
import ru.m210projects.Build.Architecture.BuildInput;

public abstract class BuildFrame {
    private FrameType type;
    public URL icon;
    protected BuildInput input;
    protected BuildGraphics graphics;
    private final BuildConfiguration config;
    protected boolean wasActive = true;

    public BuildFrame(BuildConfiguration config) {
        this.config = config;
    }

    public abstract BuildGraphics getGraphics(FrameType var1);

    public abstract BuildInput getInput(FrameType var1);

    public void setType(FrameType type) {
        if (this.getType() != type) {
            this.dispose();
            this.graphics = this.getGraphics(type);
            this.input = this.getInput(type);
            this.init();
            this.graphics.setVSync(this.getConfig().vsync);
            BuildGdx.gl = this.graphics.getGL10();
            Gdx.gl = BuildGdx.gl;
            Gdx.gl20 = BuildGdx.gl20 = this.graphics.getGL20();
            Gdx.gl30 = BuildGdx.gl30 = this.graphics.getGL30();
            BuildGdx.graphics = this.graphics;
            Gdx.graphics = BuildGdx.graphics;
            BuildGdx.input = this.input;
            Gdx.input = BuildGdx.input;
        }
    }

    public BuildInput getInput() {
        return this.input;
    }

    public BuildGraphics getGraphics() {
        return this.graphics;
    }

    public BuildFrame init() {
        try {
            this.graphics.init();
            this.input.init(this);
        }
        catch (Exception e) {
            throw new GdxRuntimeException(e);
        }
        this.graphics.resize = true;
        this.graphics.lastTime = System.nanoTime();
        return this;
    }

    protected boolean isChanged() {
        this.getConfig().x = this.graphics.getX();
        this.getConfig().y = this.graphics.getY();
        if (this.graphics.resize || this.graphics.wasResized() || this.graphics.getWidth() != this.getConfig().width || this.graphics.getHeight() != this.getConfig().height) {
            this.graphics.resize = false;
            this.getConfig().width = this.graphics.getWidth();
            this.getConfig().height = this.graphics.getHeight();
            this.graphics.updateSize(this.getConfig().width, this.getConfig().height);
            this.graphics.requestRendering();
            return true;
        }
        return false;
    }

    public boolean process(boolean shouldRender) {
        int frameRate;
        boolean isActive = this.graphics.isActive();
        this.input.update();
        shouldRender |= this.graphics.shouldRender();
        this.input.processEvents();
        if (!isActive && this.getConfig().backgroundFPS == -1) {
            shouldRender = false;
        }
        int n = frameRate = isActive ? this.getConfig().foregroundFPS : this.getConfig().backgroundFPS;
        if (this.graphics.vsync) {
            frameRate = this.graphics.getRefreshRate();
        }
        if (shouldRender) {
            this.graphics.updateTime();
            ++this.graphics.frameId;
        } else {
            if (frameRate == -1) {
                frameRate = 10;
            }
            if (frameRate == 0) {
                frameRate = this.getConfig().backgroundFPS;
            }
            if (frameRate == 0) {
                frameRate = 30;
            }
        }
        if (frameRate > 0) {
            this.graphics.sync(frameRate);
        }
        return shouldRender;
    }

    public FrameStatus getStatus() {
        if (this.graphics.isCloseRequested() || !BuildGdx.app.running) {
            return FrameStatus.Closed;
        }
        boolean isActive = this.graphics.isActive();
        if (this.wasActive && !isActive) {
            this.wasActive = false;
            return FrameStatus.Pause;
        }
        if (!this.wasActive && isActive) {
            this.wasActive = true;
            return FrameStatus.Resume;
        }
        if (this.isChanged()) {
            return FrameStatus.Changed;
        }
        return FrameStatus.Running;
    }

    public boolean isActive() {
        return this.graphics.isActive();
    }

    public void dispose() {
        if (this.graphics != null) {
            this.graphics.dispose();
            BuildGdx.gl = null;
            Gdx.gl = null;
            BuildGdx.gl20 = null;
            Gdx.gl20 = null;
            BuildGdx.gl30 = null;
            Gdx.gl30 = null;
        }
    }

    public void update() {
        this.graphics.update();
    }

    public int getX() {
        return this.graphics.getX();
    }

    public int getY() {
        return this.graphics.getY();
    }

    public FrameType getType() {
        return this.type;
    }

    public BuildConfiguration getConfig() {
        return this.config;
    }

    public static enum FrameType {
        Canvas,
        GL;

    }

    public static enum FrameStatus {
        Running,
        Pause,
        Resume,
        Changed,
        Closed;

    }
}

