/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.FileHandle;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.FileResource;
import ru.m210projects.Build.FileHandle.Group;
import ru.m210projects.Build.FileHandle.GroupResource;
import ru.m210projects.Build.FileHandle.GrpGroup;
import ru.m210projects.Build.FileHandle.PackedZipGroup;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.FileHandle.RffGroup;
import ru.m210projects.Build.FileHandle.UserGroup;
import ru.m210projects.Build.FileHandle.ZipGroup;
import ru.m210projects.Build.OnSceenDisplay.Console;

public class Cache1D {
    private final Compat compat;
    private final List<Group> groupfil = new ArrayList<Group>();
    private final int grpsign = 1399743819;
    private final int zipsign = 67324752;
    private final int rffsign = 440813138;

    public Cache1D(Compat compat) {
        this.compat = compat;
    }

    public List<Group> getGroupList() {
        return new ArrayList<Group>(this.groupfil);
    }

    public Group getGroup(String groupname) {
        for (Group gr : this.groupfil) {
            if (!gr.name.equalsIgnoreCase(groupname)) continue;
            return gr;
        }
        return null;
    }

    public Group add(String filename) {
        Group res = this.isGroup(filename);
        if (res != null) {
            if (res.numfiles != 0) {
                Console.Println("Found " + res.numfiles + " files in " + filename + " archive");
                this.groupfil.add(res);
            }
            return res;
        }
        return null;
    }

    public Group add(Group res) {
        if (res != null && res.numfiles != 0) {
            this.groupfil.add(res);
        }
        return res;
    }

    public UserGroup add(String name, boolean dynamic) {
        UserGroup group = new UserGroup(this.compat);
        group.name = name;
        group.type = PackageType.User;
        if (dynamic) {
            group.flags = (byte)(group.flags | 3);
        }
        this.groupfil.add(group);
        return group;
    }

    public Group add(Resource res, String name) {
        Group out = null;
        res.seek(0L, Resource.Whence.Set);
        switch (res.readInt()) {
            case 1399743819: {
                byte[] tmp = new byte[8];
                res.read(tmp);
                if (new String(tmp).compareTo("ilverman") != 0) break;
                try {
                    out = new GrpGroup(res, PackageType.PackedGrp);
                    out.name = name;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 67324752: {
                try {
                    out = new PackedZipGroup(res);
                    out.name = name;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 440813138: {
                try {
                    out = new RffGroup(res, PackageType.PackedRff);
                    out.name = name;
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (out != null && out.numfiles != 0) {
            Console.Println("Found " + out.numfiles + " files in " + out.name + " archive");
            this.groupfil.add(out);
        }
        return out;
    }

    public Group add(GroupResource res, boolean removable) {
        if (res.isClosed()) {
            res.getParent().open(res);
        }
        Group out = this.add((Resource)res, (Object)((Object)res.getParent().type) + ":" + res.getFullName());
        out.setFlags(true, removable);
        return out;
    }

    public Group isGroup(String filename) {
        Group out = null;
        FileResource handle = this.compat.open(filename);
        if (handle != null && handle.size() > 4) {
            switch (handle.readInt()) {
                case 1399743819: {
                    byte[] tmp = new byte[8];
                    handle.read(tmp);
                    if (new String(tmp).compareTo("ilverman") != 0) break;
                    try {
                        out = new GrpGroup(handle, PackageType.Grp);
                        out.name = filename;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 67324752: {
                    try {
                        String path = handle.getPath();
                        handle.close();
                        out = new ZipGroup(path);
                        out.name = filename;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 440813138: {
                    try {
                        out = new RffGroup(handle, PackageType.Rff);
                        out.name = filename;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                default: {
                    handle.close();
                }
            }
        }
        return out;
    }

    public boolean remove(String filename) {
        Iterator<Group> iterator = this.groupfil.iterator();
        while (iterator.hasNext()) {
            Group group = iterator.next();
            if (!group.name.equals(filename)) continue;
            group.dispose();
            iterator.remove();
            return true;
        }
        return false;
    }

    public boolean remove(Group group) {
        if (this.groupfil.remove(group)) {
            group.dispose();
            return true;
        }
        return false;
    }

    public void clearDynamicResources() {
        Iterator<Group> iterator = this.groupfil.iterator();
        while (iterator.hasNext()) {
            Group group = iterator.next();
            if ((group.flags & 3) != 3) continue;
            System.err.println("remove dynamic group: " + group.name);
            group.dispose();
            iterator.remove();
        }
    }

    public List<GroupResource> getDynamicResources() {
        ArrayList<GroupResource> list = new ArrayList<GroupResource>();
        for (Group group : this.groupfil) {
            if ((group.flags & 1) == 0) continue;
            list.addAll(group.getList());
        }
        return list;
    }

    public boolean contains(String filename, int searchfirst) {
        switch (searchfirst) {
            case 0: {
                int k;
                for (k = this.groupfil.size() - 1; k >= 0; --k) {
                    Group group = this.groupfil.get(k);
                    if ((group.flags & 1) == 0 || !group.contains(filename)) continue;
                    return true;
                }
                if (this.compat.checkFile(filename) != null) {
                    return true;
                }
            }
            case -1: {
                int k;
                for (k = this.groupfil.size() - 1; k >= 0; --k) {
                    if (!this.groupfil.get(k).contains(filename)) continue;
                    return true;
                }
                break;
            }
            default: {
                int index = searchfirst - 1;
                if (index >= this.groupfil.size() || !this.groupfil.get(index).contains(filename)) break;
                return true;
            }
        }
        return false;
    }

    public boolean contains(int fileid, String type) {
        for (int k = this.groupfil.size() - 1; k >= 0; --k) {
            if (!this.groupfil.get(k).contains(fileid, type)) continue;
            return true;
        }
        return false;
    }

    public Resource open(String filename, int searchfirst) {
        switch (searchfirst) {
            case 0: {
                Resource res;
                int k;
                for (k = this.groupfil.size() - 1; k >= 0; --k) {
                    Group group = this.groupfil.get(k);
                    if ((group.flags & 1) == 0 || (res = group.open(filename)) == null) continue;
                    return res;
                }
                res = this.compat.open(filename);
                if (res != null) {
                    return res;
                }
            }
            case -1: {
                Resource res;
                int k;
                for (k = this.groupfil.size() - 1; k >= 0; --k) {
                    res = this.groupfil.get(k).open(filename);
                    if (res == null) continue;
                    return res;
                }
                break;
            }
            default: {
                GroupResource res;
                int index = searchfirst - 1;
                if (index >= this.groupfil.size() || (res = this.groupfil.get(index).open(filename)) == null) break;
                return res;
            }
        }
        return null;
    }

    public Resource open(int fileid, String type) {
        for (int k = this.groupfil.size() - 1; k >= 0; --k) {
            GroupResource res = this.groupfil.get(k).open(fileid, type);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public byte[] getBytes(String filename, int searchfirst) {
        byte[] out = null;
        Resource res = this.open(filename, searchfirst);
        if (res != null) {
            out = res.getBytes();
            res.close();
        }
        return out;
    }

    public byte[] getBytes(int fileid, String type) {
        byte[] out = null;
        Resource res = this.open(fileid, type);
        if (res != null) {
            out = res.getBytes();
            res.close();
        }
        return out;
    }

    public static enum PackageType {
        Grp,
        Rff,
        Zip,
        User,
        PackedGrp,
        PackedRff,
        PackedZip;

    }
}

