/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.FileHandle;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import ru.m210projects.Build.FileHandle.DirectoryEntry;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.FileResource;
import ru.m210projects.Build.FileHandle.FileUtils;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Strhandler;

public class Compat {
    private final boolean debug = false;
    private final int MAXOPENFILES = 64;
    private final FileResource[] list = new FileResource[64];
    private int pos = 0;
    private CacheList cache;

    public Compat(String mainPath, String userPath) {
        Path.Game.setPath(mainPath);
        Path.User.setPath(userPath);
        for (int i = 0; i < 64; ++i) {
            this.list[i] = new FileResource();
        }
    }

    protected CacheList getCacheList() {
        if (this.cache == null) {
            this.cache = new CacheList(Path.Game.getPath(), Path.User.getPath());
        }
        return this.cache;
    }

    public FileEntry checkFile(String filepath) {
        return this.getCacheList().checkFile(filepath);
    }

    public DirectoryEntry checkDirectory(String dirpath) {
        return this.getCacheList().checkDirectory(dirpath);
    }

    public DirectoryEntry getDirectory(Path folder) {
        if (folder == Path.Game) {
            return this.getCacheList().getDirectory();
        }
        if (folder == Path.User) {
            return this.checkDirectory("<userdir>");
        }
        return null;
    }

    public File checkFile(String name, Path folder) {
        FileEntry entry = null;
        switch (folder) {
            case Game: {
                entry = this.checkFile(name);
                break;
            }
            case User: {
                entry = this.getDirectory(Path.User).checkFile(new File(Strhandler.toLowerCase(name)).getName());
                break;
            }
            case Absolute: {
                File file = new File(Strhandler.toLowerCase(name));
                if (!file.exists()) break;
                return file;
            }
        }
        if (entry != null) {
            return entry.getFile();
        }
        return null;
    }

    private FileResource obtain() {
        for (int i = 0; i < 64; ++i) {
            this.pos = this.pos + 1 & 0x3F;
            FileResource res = this.list[this.pos];
            if (!res.isClosed()) continue;
            return res;
        }
        Console.Println("TOO MANY FILES OPEN!", Console.OSDTEXT_RED);
        return null;
    }

    public List<FileResource> getOpened() {
        ArrayList<FileResource> out = new ArrayList<FileResource>();
        for (int i = 0; i < 64; ++i) {
            if (this.list[i].isClosed()) continue;
            out.add(this.list[i]);
        }
        return out;
    }

    public FileResource open(FileEntry fil) {
        FileResource res = this.obtain();
        if (res != null) {
            res = res.open(fil.getFile(), FileResource.Mode.Read);
        }
        return res;
    }

    public FileResource open(String name) {
        return this.open(name, Path.Game, FileResource.Mode.Read);
    }

    public FileResource open(String name, Path folder, FileResource.Mode mode) {
        FileResource res = null;
        switch (mode) {
            case Read: {
                File fil = this.checkFile(name, folder);
                if (fil == null || (res = this.obtain()) == null) break;
                res = res.open(fil, mode);
                break;
            }
            case Write: {
                if (folder == Path.Game) {
                    File fil;
                    res = this.obtain();
                    if (res == null || (res = res.open(fil = new File(Path.Game.getPath() + name), mode)) == null) break;
                    this.getCacheList().getDirectory().addFile(fil);
                    break;
                }
                if (folder == Path.User) {
                    File fil;
                    res = this.obtain();
                    if (res == null || (res = res.open(fil = new File(Path.User.getPath() + name), mode)) == null) break;
                    this.getDirectory(Path.User).addFile(fil);
                    break;
                }
                res = this.obtain();
                if (res == null) break;
                res = res.open(new File(name), mode);
            }
        }
        if (res != null) {
            // empty if block
        }
        return res;
    }

    public byte[] getBytes(FileEntry entry) {
        byte[] out = null;
        FileResource res = this.open(entry);
        if (res != null) {
            out = res.getBytes();
            res.close();
        }
        return out;
    }

    public static enum Path {
        Game,
        User,
        Absolute;

        String path;

        public String getPath() {
            return this.path;
        }

        protected void setPath(String path) {
            this.path = FileUtils.getCorrectPath(path);
        }
    }

    public class CacheList {
        private final DirectoryEntry entry;

        public CacheList(String path, String userpath) {
            this.entry = DirectoryEntry.init(path, userpath);
        }

        protected DirectoryEntry getDirectory() {
            return this.entry;
        }

        protected FileEntry checkFile(String filepath) {
            return this.entry.checkFile(filepath);
        }

        protected DirectoryEntry checkDirectory(String dirpath) {
            return this.entry.checkDirectory(dirpath);
        }

        public String toString() {
            return this.entry.toString();
        }
    }
}

