/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.FileHandle;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.FEntryResource;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.Strhandler;

public class DirectoryEntry {
    private final HashMap<String, DirectoryEntry> subDirectory;
    private final HashMap<String, FileEntry> files = new HashMap();
    private final String name;
    private String relativePath;
    private final String absolutePath;
    private DirectoryEntry parentDir;
    private boolean inited;
    private static HashMap<String, DirectoryEntry> cache;

    protected DirectoryEntry(String name, String Path2) {
        this.subDirectory = new HashMap();
        this.name = name;
        if (Path2 != null) {
            this.relativePath = this.getRelativePath(Path2);
        }
        this.absolutePath = Path2;
    }

    public void addFile(File file) {
        this.files.put(Strhandler.toLowerCase(file.getName()), new FileEntry(file, this, this.getRelativePath(file.getAbsolutePath())));
    }

    public DirectoryEntry addDirectory(String name, String relPath) {
        DirectoryEntry added = new DirectoryEntry(name, relPath);
        this.subDirectory.put(Strhandler.toLowerCase(name), added);
        return added;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public DirectoryEntry getParent() {
        return this.parentDir;
    }

    public FileEntry checkFile(String filepath) {
        if (filepath == null) {
            return null;
        }
        filepath = Strhandler.toLowerCase(filepath);
        DirectoryEntry dir = this;
        while (filepath.indexOf(File.separator) != -1) {
            int index = filepath.indexOf(File.separator);
            String folder = filepath.substring(0, index);
            if (dir == null) {
                return null;
            }
            dir = dir.checkDirectory(folder);
            filepath = filepath.substring(index + 1);
        }
        if (dir == null) {
            return null;
        }
        return dir.files.get(filepath);
    }

    public DirectoryEntry checkDirectory(String dirpath) {
        dirpath = Strhandler.toLowerCase(dirpath);
        DirectoryEntry dir = this;
        while (dirpath.indexOf(File.separator) != -1) {
            int index = dirpath.indexOf(File.separator);
            String folder = dirpath.substring(0, index);
            if (dir == null) {
                return null;
            }
            dir = dir.checkDirectory(folder);
            dirpath = dirpath.substring(index + 1);
        }
        if (dir == null) {
            return null;
        }
        DirectoryEntry subDir = dir.subDirectory.get(dirpath);
        if (subDir != null) {
            subDir.InitDirectory(subDir.getAbsolutePath());
        }
        return subDir;
    }

    public HashMap<String, FileEntry> getFiles() {
        return this.files;
    }

    public HashMap<String, DirectoryEntry> getDirectories() {
        return this.subDirectory;
    }

    public List<FEntryResource> getList() {
        ArrayList<FEntryResource> list = new ArrayList<FEntryResource>();
        for (FileEntry file : this.getFiles().values()) {
            list.add(new FEntryResource(file));
        }
        return list;
    }

    public String getName() {
        return this.name;
    }

    protected static DirectoryEntry init(String mainpath, String userpath) {
        if (cache == null) {
            cache = new HashMap();
        } else {
            cache.clear();
        }
        String dirName = "<main>";
        DirectoryEntry dir = new DirectoryEntry(dirName, null);
        cache.put(dirName, dir);
        dir.InitDirectory(mainpath);
        DirectoryEntry user = dir.addDirectory("<userdir>", userpath);
        user.InitDirectory(userpath);
        return dir;
    }

    public boolean checkCacheList() {
        File directory;
        boolean isMain;
        if (!this.inited) {
            return false;
        }
        int currentSize = this.files.size() + this.subDirectory.size();
        boolean bl = isMain = this == BuildGdx.compat.getDirectory(Compat.Path.Game);
        if (isMain) {
            directory = new File(Compat.Path.Game.getPath());
            --currentSize;
        } else {
            directory = new File(this.absolutePath);
        }
        File[] fList = directory.listFiles();
        if (fList != null && currentSize != fList.length) {
            DirectoryEntry userdir = null;
            if (isMain) {
                userdir = BuildGdx.compat.getDirectory(Compat.Path.User);
            }
            this.subDirectory.clear();
            this.files.clear();
            for (File file : fList) {
                if (file.isFile()) {
                    this.addFile(file);
                    continue;
                }
                DirectoryEntry subDir = this.addDirectory(file.getName(), file.getAbsolutePath());
                subDir.parentDir = this;
            }
            if (isMain) {
                this.subDirectory.put("<userdir>", userdir);
            }
            return currentSize != this.files.size() + this.subDirectory.size() - 1;
        }
        return false;
    }

    public void InitDirectory(String directoryPath) {
        if (this.inited) {
            return;
        }
        File directory = new File(directoryPath);
        File[] fList = directory.listFiles();
        if (fList != null) {
            for (File file : fList) {
                if (file.isFile()) {
                    this.addFile(file);
                    continue;
                }
                DirectoryEntry subDir = this.addDirectory(file.getName(), file.getAbsolutePath());
                subDir.parentDir = this;
            }
        }
        this.inited = true;
    }

    public String toString() {
        StringBuilder out = new StringBuilder("Directory name: " + this.getName() + "\r\n");
        out.append("\r\nSubDirectories: \r\n");
        for (String dir : this.getDirectories().keySet()) {
            out.append("\t").append(dir).append("\r\n");
        }
        out.append("\r\nFiles: \r\n");
        for (FileEntry file : this.getFiles().values()) {
            out.append("\t").append(file.getFile().getName()).append("\r\n");
        }
        return out.toString();
    }

    public boolean isInited() {
        return this.inited;
    }

    private String getRelativePath(String path) {
        String mainpath = Compat.Path.Game.getPath();
        if (this.name.equals("<userdir>")) {
            mainpath = Compat.Path.User.getPath();
        }
        if (path.length() > mainpath.length()) {
            int i;
            for (i = 0; i < mainpath.length() && mainpath.charAt(i) == path.charAt(i); ++i) {
            }
            if (i == 0) {
                return null;
            }
            path = path.substring(i);
        } else if (mainpath.startsWith(path)) {
            return null;
        }
        return Strhandler.toLowerCase(path);
    }
}

