/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.FileHandle;

import java.nio.ByteBuffer;
import ru.m210projects.Build.FileHandle.Group;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.StringUtils;

public abstract class GroupResource
implements Resource {
    protected ByteBuffer buffer;
    protected Group parent;
    protected String filename;
    protected String filenamext;
    protected String fileformat;
    protected int fileid;
    protected int size;

    protected void handleName(String fullname) {
        this.filenamext = Strhandler.toLowerCase(StringUtils.toUnicode(fullname));
        int point = this.filenamext.lastIndexOf(46);
        if (point != -1) {
            this.fileformat = this.filenamext.substring(point + 1);
            this.filename = this.filenamext.substring(0, point);
        } else {
            this.fileformat = "";
            this.filename = this.filenamext;
        }
    }

    public GroupResource(Group parent) {
        this.parent = parent;
        this.fileid = -1;
    }

    @Override
    public Group getParent() {
        return this.parent;
    }

    public void flush() {
        if (this.buffer != null) {
            this.buffer.clear();
            this.buffer = null;
        }
    }

    public boolean isCached() {
        return this.buffer != null;
    }

    @Override
    public String getFullName() {
        return this.filenamext;
    }

    public String getName() {
        return this.filename;
    }

    @Override
    public String getExtension() {
        return this.fileformat;
    }

    public int getIdentification() {
        return this.fileid;
    }

    public void setIdentification(int fileid) {
        this.fileid = fileid;
    }

    @Override
    public int size() {
        return this.size;
    }

    public String toString() {
        return this.getFullName() + " fileid: " + this.getIdentification() + " parent: " + (this.parent != null ? this.parent.name : "") + "\r\n";
    }

    public static enum ResourceType {
        Data,
        GroupFile;

    }
}

