/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.FileHandle;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.FileHandle.Cache1D;
import ru.m210projects.Build.FileHandle.Group;
import ru.m210projects.Build.FileHandle.GroupResource;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.OnSceenDisplay.Console;

public class GrpGroup
extends Group {
    private static final byte[] tmp = new byte[1024];
    private Resource file;

    public GrpGroup(Resource groupFile, Cache1D.PackageType type) throws Exception {
        this.file = groupFile;
        this.type = type;
        if (type == Cache1D.PackageType.PackedGrp) {
            this.file.toMemory();
        }
        if (this.file.position() != 12) {
            this.file.seek(0L, Resource.Whence.Set);
            this.file.read(tmp, 0, 12);
            if (new String(tmp).compareTo("KenSilverman") != 0) {
                throw new Exception("GRP header corrupted");
            }
        }
        this.numfiles = this.file.readInt();
        int HeaderSize = this.numfiles + 1 << 4;
        if (this.numfiles != 0) {
            int offset = HeaderSize;
            for (int i = 0; i < this.numfiles; ++i) {
                GrpResource file = new GrpResource(offset);
                this.add(file);
                offset += file.size;
            }
        }
    }

    @Override
    protected boolean open(GroupResource res) {
        if (this.file == null) {
            return false;
        }
        GrpResource gres = (GrpResource)res;
        if (gres != null) {
            gres.pos = 0;
            return true;
        }
        return false;
    }

    @Override
    public int position() {
        if (this.file != null) {
            return this.file.position();
        }
        return -1;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.file != null && !this.file.isClosed()) {
            this.file.close();
        }
        this.file = null;
    }

    private class GrpResource
    extends GroupResource {
        public int offset;
        public int pos;

        public GrpResource(int offset) {
            super(GrpGroup.this);
            GrpGroup.this.file.read(tmp, 0, 12);
            String fullname = new String(tmp);
            int eos = fullname.indexOf(0);
            if (eos != -1) {
                fullname = fullname.substring(0, eos);
            }
            this.handleName(fullname);
            this.size = GrpGroup.this.file.readInt();
            this.offset = offset;
            if (GrpGroup.this.debug) {
                System.out.println("\t" + this.filenamext + ", offset: " + offset + ", size: " + this.size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() {
            Group group = this.parent;
            synchronized (group) {
                super.flush();
                this.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Group group = this.parent;
            synchronized (group) {
                this.pos = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int seek(long offset, Resource.Whence whence) {
            Group group = this.parent;
            synchronized (group) {
                switch (whence) {
                    case Set: {
                        this.pos = (int)offset;
                        break;
                    }
                    case Current: {
                        this.pos = (int)((long)this.pos + offset);
                        break;
                    }
                    case End: {
                        this.pos = this.size + (int)offset;
                    }
                }
                GrpGroup.this.file.seek(this.offset + this.pos, Resource.Whence.Set);
                return this.pos;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] buf, int offs, int len) {
            Group group = this.parent;
            synchronized (group) {
                if (this.pos >= this.size) {
                    return -1;
                }
                len = Math.min(len, this.size - this.pos);
                int i = this.offset + this.pos;
                int groupfilpos = GrpGroup.this.file.position();
                if (i != groupfilpos) {
                    GrpGroup.this.file.seek(i, Resource.Whence.Set);
                }
                len = GrpGroup.this.file.read(buf, offs, len);
                this.pos += len;
                return len;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] buf) {
            Group group = this.parent;
            synchronized (group) {
                return this.read(buf, 0, buf.length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(ByteBuffer bb, int offset, int len) {
            Group group = this.parent;
            synchronized (group) {
                bb.position(offset);
                int p = 0;
                while (len > 0) {
                    int var = this.read(tmp, 0, Math.min(len, tmp.length));
                    if (var == -1) {
                        return p;
                    }
                    bb.put(tmp, 0, var);
                    len -= var;
                    p += var;
                }
                return len;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Byte readByte() {
            Group group = this.parent;
            synchronized (group) {
                Byte out;
                int len = 1;
                if (len > this.size - this.pos) {
                    return null;
                }
                int i = this.offset + this.pos;
                int groupfilpos = GrpGroup.this.file.position();
                if (i != groupfilpos) {
                    GrpGroup.this.file.seek(i, Resource.Whence.Set);
                }
                if ((out = GrpGroup.this.file.readByte()) == null) {
                    return null;
                }
                this.pos += len;
                return out;
            }
        }

        @Override
        public Boolean readBoolean() {
            Byte var = this.readByte();
            if (var != null) {
                return var == 1;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Short readShort() {
            Group group = this.parent;
            synchronized (group) {
                Short out;
                int len = 2;
                if (len > this.size - this.pos) {
                    return null;
                }
                int i = this.offset + this.pos;
                int groupfilpos = GrpGroup.this.file.position();
                if (i != groupfilpos) {
                    GrpGroup.this.file.seek(i, Resource.Whence.Set);
                }
                if ((out = GrpGroup.this.file.readShort()) == null) {
                    return null;
                }
                this.pos += len;
                return out;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer readInt() {
            Group group = this.parent;
            synchronized (group) {
                Integer out;
                int len = 4;
                if (len > this.size - this.pos) {
                    return null;
                }
                int i = this.offset + this.pos;
                int groupfilpos = GrpGroup.this.file.position();
                if (i != groupfilpos) {
                    GrpGroup.this.file.seek(i, Resource.Whence.Set);
                }
                if ((out = GrpGroup.this.file.readInt()) == null) {
                    return null;
                }
                this.pos += len;
                return out;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long readLong() {
            Group group = this.parent;
            synchronized (group) {
                Long out;
                int len = 8;
                if (len > this.size - this.pos) {
                    return null;
                }
                int i = this.offset + this.pos;
                int groupfilpos = GrpGroup.this.file.position();
                if (i != groupfilpos) {
                    GrpGroup.this.file.seek(i, Resource.Whence.Set);
                }
                if ((out = GrpGroup.this.file.readLong()) == null) {
                    return null;
                }
                this.pos += len;
                return out;
            }
        }

        @Override
        public Float readFloat() {
            Integer i = this.readInt();
            if (i != null) {
                return Float.valueOf(Float.intBitsToFloat(i));
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String readString(int len) {
            Group group = this.parent;
            synchronized (group) {
                byte[] data = len < tmp.length ? tmp : new byte[len];
                if (this.read(data, 0, len) != len) {
                    return null;
                }
                return new String(data, 0, len);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int position() {
            Group group = this.parent;
            synchronized (group) {
                return this.pos;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void toMemory() {
            Group group = this.parent;
            synchronized (group) {
                if (this.buffer == null) {
                    if (GrpGroup.this.file.seek(this.offset, Resource.Whence.Set) == -1) {
                        Console.Println("Error seeking to resource!");
                        return;
                    }
                    this.buffer = ByteBuffer.allocateDirect(this.size);
                    this.buffer.order(ByteOrder.LITTLE_ENDIAN);
                    GrpGroup.this.file.read(this.buffer, 0, this.size);
                }
                this.buffer.rewind();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] getBytes() {
            Group group = this.parent;
            synchronized (group) {
                int size = this.size();
                if (size > 0) {
                    if (GrpGroup.this.file.seek(this.offset, Resource.Whence.Set) == -1) {
                        Console.Println("Error seeking to resource!");
                        return null;
                    }
                    byte[] data = new byte[size];
                    if (GrpGroup.this.file.read(data) == -1) {
                        Console.Println("Error loading resource!");
                        return null;
                    }
                    return data;
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isClosed() {
            Group group = this.parent;
            synchronized (group) {
                if (GrpGroup.this.file != null) {
                    return GrpGroup.this.file.isClosed();
                }
                return true;
            }
        }

        @Override
        public int remaining() {
            return this.size() - this.position();
        }

        @Override
        public boolean hasRemaining() {
            return this.position() < this.size();
        }
    }
}

