/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.FileHandle;

import java.nio.ByteBuffer;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.FileResource;
import ru.m210projects.Build.FileHandle.Group;
import ru.m210projects.Build.FileHandle.GroupResource;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Strhandler;

public class UserGroup
extends Group {
    private static final byte[] tmp = new byte[1024];
    private final Compat compat;

    protected UserGroup(Compat compat) {
        this.compat = compat;
    }

    @Override
    protected boolean open(GroupResource res) {
        if (res != null) {
            if (res instanceof UserResource) {
                UserResource userres = (UserResource)res;
                if (userres.fil == null && userres.entry != null) {
                    userres.fil = this.compat.open(userres.entry.getPath(), Compat.Path.Game, FileResource.Mode.Read);
                } else if (userres.absolutePath != null) {
                    userres.fil = this.compat.open(userres.absolutePath, Compat.Path.Absolute, FileResource.Mode.Read);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int position() {
        return -1;
    }

    public UserResource add(FileEntry entry, int fileid) {
        if (entry == null) {
            return null;
        }
        UserResource out = null;
        out = new UserResource(entry, fileid);
        this.add(out);
        ++this.numfiles;
        return out;
    }

    public UserResource add(String absolutePath, int fileid) {
        if (absolutePath == null || absolutePath.isEmpty()) {
            return null;
        }
        UserResource out = null;
        out = new UserResource(absolutePath, fileid);
        this.add(out);
        ++this.numfiles;
        return out;
    }

    public class UserResource
    extends GroupResource {
        public final FileEntry entry;
        public FileResource fil;
        public String absolutePath;

        public UserResource(String absolutePath, int fileid) {
            super(UserGroup.this);
            this.filenamext = Strhandler.toLowerCase(absolutePath);
            int point = this.filenamext.lastIndexOf(46);
            if (point != -1) {
                this.fileformat = this.filenamext.substring(point + 1);
                this.filename = this.filenamext.substring(0, point);
            } else {
                this.fileformat = "";
                this.filename = this.filenamext;
            }
            this.entry = null;
            this.fileid = fileid;
            this.fil = null;
            this.absolutePath = absolutePath;
        }

        public UserResource(FileEntry file, int fileid) {
            super(UserGroup.this);
            this.handleName(file.getName());
            this.entry = file;
            this.fileid = fileid;
            this.fil = null;
        }

        @Override
        public int size() {
            if (this.fil != null) {
                return this.fil.size();
            }
            return this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Group group = this.parent;
            synchronized (group) {
                if (this.fil != null) {
                    this.fil.close();
                    if (this.entry != null) {
                        this.fil = null;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int seek(long offset, Resource.Whence whence) {
            Group group = this.parent;
            synchronized (group) {
                if (this.fil != null) {
                    return this.fil.seek(offset, whence);
                }
                return -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] buf, int offset, int len) {
            Group group = this.parent;
            synchronized (group) {
                if (this.fil != null) {
                    return this.fil.read(buf, offset, len);
                }
                return -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] buf) {
            Group group = this.parent;
            synchronized (group) {
                return this.read(buf, 0, buf.length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(ByteBuffer bb, int offset, int len) {
            Group group = this.parent;
            synchronized (group) {
                if (this.fil != null) {
                    int var = -1;
                    bb.position(offset);
                    int p = 0;
                    while (len > 0) {
                        var = this.read(tmp, 0, Math.min(len, tmp.length));
                        if (var == -1) {
                            return p;
                        }
                        bb.put(tmp, 0, var);
                        len -= var;
                        p += var;
                    }
                    return len;
                }
                return -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Byte readByte() {
            Group group = this.parent;
            synchronized (group) {
                if (this.fil != null) {
                    return this.fil.readByte();
                }
                return null;
            }
        }

        @Override
        public Boolean readBoolean() {
            Byte var = this.readByte();
            if (var != null) {
                return var == 1;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Short readShort() {
            Group group = this.parent;
            synchronized (group) {
                if (this.fil != null) {
                    return this.fil.readShort();
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer readInt() {
            Group group = this.parent;
            synchronized (group) {
                if (this.fil != null) {
                    return this.fil.readInt();
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long readLong() {
            Group group = this.parent;
            synchronized (group) {
                if (this.fil != null) {
                    return this.fil.readLong();
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Float readFloat() {
            Group group = this.parent;
            synchronized (group) {
                if (this.fil != null) {
                    return this.fil.readFloat();
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String readString(int len) {
            Group group = this.parent;
            synchronized (group) {
                if (this.fil != null) {
                    return this.fil.readString(len);
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int position() {
            Group group = this.parent;
            synchronized (group) {
                if (this.fil != null) {
                    return this.fil.position();
                }
                return -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void toMemory() {
            Group group = this.parent;
            synchronized (group) {
                if (this.isClosed()) {
                    this.parent.open(this);
                }
                if (this.fil != null) {
                    this.fil.toMemory();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] getBytes() {
            Group group = this.parent;
            synchronized (group) {
                if (this.isClosed()) {
                    this.parent.open(this);
                }
                if (this.fil != null) {
                    return this.fil.getBytes();
                }
                return null;
            }
        }

        @Override
        public boolean isClosed() {
            if (this.fil != null) {
                return this.fil.isClosed();
            }
            return true;
        }

        @Override
        public int remaining() {
            return this.size() - this.position();
        }

        @Override
        public boolean hasRemaining() {
            return this.position() < this.size();
        }
    }
}

