/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.Arrays;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Net.ISocket;
import ru.m210projects.Build.Net.NetInfo;
import ru.m210projects.Build.Net.UDPServer;
import ru.m210projects.Build.Net.UDPSocket;
import ru.m210projects.Build.Net.WaifUPnp.UPnP;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Types.LittleEndian;

public class Mmulti {
    public static final byte kPacketTick = -84;
    public static final int NETPORT = 23513;
    public static final int MAXPAKSIZ = 256;
    public static final int PAKRATE = 40;
    private static final byte[] pakbuf = new byte[256];
    public static short numplayers;
    public static short myconnectindex;
    public static short connecthead;
    public static short[] connectpoint2;
    public static ISocket mysock;
    public static int danetmode;
    public static Object[] othersocket;
    public static Object snatsocket;
    public static final int FIFSIZ = 512;
    static int[][] ipak;
    static int[] icnt0;
    static int[][] opak;
    static int[] ocnt0;
    static int[] ocnt1;
    public static byte[] pakmem;
    public static int pakmemi;
    public static long netping;
    public static char syncstate;
    public static long tims;
    public static long[] lastsendtims;
    public static NetInfo inet;
    private static final int[] crctab16;
    public static int otherpacket;

    private static long GetTickCount() {
        return System.currentTimeMillis();
    }

    static void initcrc16() {
        for (int j = 0; j < 256; ++j) {
            int a = 0;
            int k = j << 8;
            for (int i = 7; i >= 0; --i) {
                a = ((k ^ a) & 0x8000) != 0 ? a << 1 & 0xFFFF ^ 0x1021 : a << 1 & 0xFFFF;
                k = k << 1 & 0xFFFF;
            }
            Mmulti.crctab16[j] = a & 0xFFFF;
        }
    }

    private static int updatecrc16(int crc, byte dat) {
        return crc << 8 & 0xFFFF ^ crctab16[(crc & 0xFFFF) >> 8 & 0xFFFF ^ dat & 0xFF];
    }

    private static int getcrc16(byte[] buffer, int bufleng) {
        int j = 0;
        for (int i = bufleng - 1; i >= 0; --i) {
            j = Mmulti.updatecrc16(j, buffer[i]);
        }
        return j & 0xFFFF;
    }

    private static int netinit(int numplayers, int portnum) {
        try {
            String hostAddress = Mmulti.inet.myip = InetAddress.getLocalHost().getHostAddress();
            if (myconnectindex == 0) {
                mysock = new UDPServer(portnum);
                Mmulti.inet.useUPnP = Mmulti.initupnp(portnum);
            } else {
                mysock = new UDPSocket(portnum);
            }
            Console.Println("mmulti: This machine's IP is " + hostAddress);
            return 1;
        }
        catch (Throwable e) {
            Console.Println(e.getMessage(), Console.OSDTEXT_RED);
            return 0;
        }
    }

    public static boolean initupnp(int portnum) {
        Mmulti.inet.uPnPPort = -1;
        if (UPnP.isUPnPAvailable() && (UPnP.isMappedUDP(portnum) || UPnP.openPortUDP(portnum))) {
            Mmulti.inet.uPnPPort = portnum;
            Mmulti.inet.extip = Mmulti.getExternalIp();
            return true;
        }
        return false;
    }

    public static void uninitmultiplayer() {
        if (Mmulti.inet.useUPnP) {
            UPnP.closePortUDP(Mmulti.inet.uPnPPort);
            Mmulti.inet.uPnPPort = -1;
            Mmulti.inet.useUPnP = false;
        }
        if (mysock != null) {
            mysock.dispose();
        }
        Mmulti.initmultiplayers_reset();
        connecthead = 0;
        for (int i = 0; i < numplayers - 1; ++i) {
            Mmulti.connectpoint2[i] = (short)(i + 1);
        }
        Mmulti.connectpoint2[Mmulti.numplayers - 1] = -1;
        numplayers = 1;
        danetmode = 255;
        pakmemi = 1;
    }

    private static void netsend(int other, byte[] dabuf, int bufsiz) {
        if (othersocket[other] == null || mysock == null) {
            return;
        }
        mysock.sendto(othersocket[other], dabuf, bufsiz);
    }

    private static int netread(byte[] dabuf, int bufsiz) {
        Object recip;
        if (mysock == null || (recip = mysock.recvfrom(dabuf, bufsiz)) == null) {
            return -1;
        }
        snatsocket = recip;
        int other = myconnectindex;
        for (int i = 0; i < 16; ++i) {
            if (!snatsocket.equals(othersocket[i]) || ((InetSocketAddress)snatsocket).getPort() != ((InetSocketAddress)othersocket[i]).getPort()) continue;
            other = i;
            break;
        }
        return other;
    }

    private static boolean isvalidipaddress(String st) {
        int bcnt = 0;
        int num = 0;
        for (int i = 0; i < st.length() && st.charAt(i) != '\u0000'; ++i) {
            if (st.charAt(i) == '.') {
                ++bcnt;
                num = 0;
                continue;
            }
            if (st.charAt(i) == ':') {
                if (bcnt != 3) {
                    return false;
                }
                num = 0;
                ++i;
                while (st.charAt(i) != '\u0000') {
                    if (st.charAt(i) >= '0' && st.charAt(i) <= '9') {
                        if ((num = num * 10 + st.charAt(i) - 48) >= 65536) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            if (st.charAt(i) < '0' || st.charAt(i) > '9' || (num = num * 10 + st.charAt(i) - 48) < 256) continue;
            return false;
        }
        return bcnt == 3;
    }

    private static void initmultiplayers_reset() {
        int i;
        inet.clear();
        Mmulti.initcrc16();
        Arrays.fill(icnt0, 0);
        Arrays.fill(ocnt0, 0);
        Arrays.fill(ocnt1, 0);
        for (i = 0; i < 16; ++i) {
            Arrays.fill(ipak[i], 0);
        }
        Mmulti.lastsendtims[0] = Mmulti.GetTickCount();
        for (i = 1; i < 16; ++i) {
            Mmulti.lastsendtims[i] = lastsendtims[0];
        }
        numplayers = 1;
        myconnectindex = 0;
        Arrays.fill(othersocket, null);
    }

    public static int initmultiplayerscycle() {
        Mmulti.getpacket(null);
        tims = Mmulti.GetTickCount();
        if (myconnectindex == connecthead) {
            int i;
            for (i = numplayers - 1; i > 0 && othersocket[i] != null; --i) {
            }
            Mmulti.inet.message = "Waiting for other players [" + Mmulti.inet.plready + " / " + numplayers + "]";
            if (i == 0) {
                Mmulti.inet.netready = 1;
                return 0;
            }
            if (tims < lastsendtims[connecthead]) {
                Mmulti.lastsendtims[Mmulti.connecthead] = tims;
            }
            if (tims >= lastsendtims[connecthead] + 1000L) {
                Mmulti.lastsendtims[Mmulti.connecthead] = tims;
                i = connecthead;
                while (i >= 0) {
                    if (i != myconnectindex) {
                        Mmulti.pakbuf[0] = -84;
                        Mmulti.pakbuf[1] = (byte)Mmulti.inet.plready;
                        Mmulti.sendpacket(i, pakbuf, 2);
                    }
                    i = connectpoint2[i];
                }
            }
        } else {
            Mmulti.inet.message = "Trying to connect to " + Mmulti.inet.serverip + ":" + Mmulti.inet.port;
            if (Mmulti.inet.netready != 0) {
                Mmulti.inet.message = "Connected! Waiting for other players...";
                return 0;
            }
            if (tims < lastsendtims[connecthead]) {
                Mmulti.lastsendtims[Mmulti.connecthead] = tims;
            }
            if (tims >= lastsendtims[connecthead] + 250L) {
                Mmulti.lastsendtims[Mmulti.connecthead] = tims;
                int k = 2;
                LittleEndian.putInt(pakbuf, k, -1);
                k += 4;
                Mmulti.pakbuf[k++] = -86;
                LittleEndian.putShort(pakbuf, 0, (short)k);
                LittleEndian.putShort(pakbuf, k, (short)Mmulti.getcrc16(pakbuf, k));
                Mmulti.netsend(connecthead, pakbuf, k += 2);
            }
        }
        return 1;
    }

    public static void initmultiplayers(final String[] argv, final int timeout) {
        Mmulti.inet.waitThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Mmulti.inet.message = "Initializing...";
                    Mmulti.inet.plready = 1;
                    if (Mmulti.initmultiplayersparms(argv)) {
                        Console.Println("Waiting for players...");
                        long starttime = System.currentTimeMillis();
                        while (Mmulti.initmultiplayerscycle() != 0) {
                            long time = System.currentTimeMillis() - starttime;
                            if (timeout != 0 && time > (long)timeout) {
                                throw new Exception("Connection timed out!");
                            }
                            if (BuildGdx.input == null || !BuildGdx.input.isKeyPressed(131)) continue;
                            throw new Exception("Connection cancelled");
                        }
                        Mmulti.inet.netready = 1;
                    }
                }
                catch (Throwable e) {
                    Mmulti.inet.message = e.getMessage();
                    Mmulti.uninitmultiplayer();
                }
            }
        });
        Mmulti.inet.waitThread.start();
    }

    public static boolean initmultiplayersparms(String[] argv) {
        int i;
        int portnum = 23513;
        Mmulti.initmultiplayers_reset();
        danetmode = 255;
        int daindex = 0;
        if (argv != null) {
            for (i = 0; i < argv.length; ++i) {
                if (argv[i] == null || argv[i].length() < 3 || argv[i].charAt(0) != '-' && argv[i].charAt(0) != '/' || argv[i].charAt(1) != 'p' && argv[i].charAt(1) != 'P' || argv[i].charAt(2) == '\u0000') continue;
                String port = argv[i].substring(2).trim();
                int j = Integer.parseInt(port);
                if (j > 0 && j < 65535) {
                    portnum = j;
                }
                Console.Println("mmulti: Using port " + portnum);
            }
            for (i = 0; i < argv.length; ++i) {
                if (argv[i] == null || argv[i].isEmpty()) continue;
                if (argv[i].charAt(0) == '-' || argv[i].charAt(0) == '/') {
                    if (argv[i].charAt(1) == 'N' || argv[i].charAt(1) == 'n' || argv[i].charAt(1) == 'I' || argv[i].charAt(1) == 'i') {
                        numplayers = (short)2;
                        if (argv[i].length() <= 1 || argv[i].charAt(2) != '0') continue;
                        danetmode = 0;
                        if (argv[i].length() > 3 && argv[i].charAt(3) == ':' && argv[i].charAt(4) >= '0' && argv[i].charAt(4) <= '9') {
                            numplayers = (short)(argv[i].charAt(4) - 48);
                            if (argv[i].length() > 5 && argv[i].charAt(5) >= '0' && argv[i].charAt(5) <= '9') {
                                numplayers = (short)(numplayers * 10 + (argv[i].charAt(5) - 48));
                            }
                            Console.Println("mmulti: " + numplayers + "-player game");
                        }
                        Console.Println("mmulti: Master-slave mode");
                        continue;
                    }
                    if (argv[i].charAt(1) == 'P' || argv[i].charAt(1) == 'p') continue;
                }
                if (Mmulti.isvalidipaddress(argv[i])) {
                    if (danetmode == 1 && daindex == myconnectindex) {
                        ++daindex;
                    }
                    Mmulti.inet.serverip = argv[i];
                    Mmulti.inet.port = portnum;
                    Mmulti.othersocket[daindex] = new InetSocketAddress(argv[i], portnum);
                    Console.Println("mmulti: Player " + daindex + " at " + argv[i] + ":" + portnum);
                    ++daindex;
                    continue;
                }
                int pt = portnum;
                try {
                    InetAddress addr = InetAddress.getByName(argv[i]);
                    if (danetmode == 1 && daindex == myconnectindex) {
                        ++daindex;
                    }
                    Mmulti.inet.serverip = addr.getHostName();
                    Mmulti.othersocket[daindex] = new InetSocketAddress(addr.getHostAddress(), pt);
                    Mmulti.inet.port = portnum = pt;
                    Console.Println("mmulti: Player " + daindex + " at " + othersocket[daindex]);
                    ++daindex;
                    continue;
                }
                catch (Exception e) {
                    Console.Println("mmulti: Failed resolving " + argv[i]);
                }
            }
        }
        if (danetmode == 255 && daindex != 0) {
            numplayers = (short)2;
            danetmode = 0;
        }
        if (numplayers >= 2 && daindex != 0 && danetmode == 0) {
            myconnectindex = 1;
        }
        if (daindex > numplayers) {
            numplayers = (short)daindex;
        }
        connecthead = 0;
        for (i = 0; i < numplayers - 1; ++i) {
            Mmulti.connectpoint2[i] = (short)(i + 1);
        }
        Mmulti.connectpoint2[Mmulti.numplayers - 1] = -1;
        if (Mmulti.netinit(numplayers, portnum) == 0) {
            Mmulti.initmultiplayers_reset();
            return false;
        }
        return danetmode == 0 && numplayers >= 2 || numplayers == 2;
    }

    public static int getoutputcirclesize() {
        return 0;
    }

    public static boolean canSend(int other) {
        return Mmulti.GetTickCount() >= lastsendtims[other] + 25L;
    }

    public static void dosendpackets(int other) {
        int i;
        if (othersocket[other] == null) {
            return;
        }
        tims = Mmulti.GetTickCount();
        if (tims < lastsendtims[other]) {
            Mmulti.lastsendtims[other] = tims;
        }
        if (tims < lastsendtims[other] + 25L) {
            return;
        }
        Mmulti.lastsendtims[other] = tims;
        int k = 2;
        LittleEndian.putInt(pakbuf, k, icnt0[other]);
        Arrays.fill(pakbuf, k += 4, k + 32, (byte)0);
        for (i = icnt0[other]; i < icnt0[other] + 256; ++i) {
            if (ipak[other][i & 0x1FF] == 0) continue;
            int n = (i - icnt0[other] >> 3) + k;
            pakbuf[n] = (byte)(pakbuf[n] | 1 << (i - icnt0[other] & 7));
        }
        k += 32;
        while (ocnt0[other] < ocnt1[other] && opak[other][ocnt0[other] & 0x1FF] == 0) {
            int n = other;
            ocnt0[n] = ocnt0[n] + 1;
        }
        for (i = ocnt0[other]; i < ocnt1[other]; ++i) {
            short j = LittleEndian.getShort(pakmem, opak[other][i & 0x1FF]);
            if (j == 0) continue;
            if (k + 6 + j + 4 > pakbuf.length) break;
            LittleEndian.putUShort(pakbuf, k, j);
            LittleEndian.putInt(pakbuf, k += 2, i);
            System.arraycopy(pakmem, opak[other][i & 0x1FF] + 2, pakbuf, k += 4, j);
            k += j;
        }
        LittleEndian.putUShort(pakbuf, k, 0);
        LittleEndian.putUShort(pakbuf, 0, k += 2);
        LittleEndian.putUShort(pakbuf, k, Mmulti.getcrc16(pakbuf, k));
        Mmulti.netsend(other, pakbuf, k += 2);
    }

    public static void sendpacket(int other, byte[] bufptr, int messleng) {
        if (numplayers < 2) {
            return;
        }
        if (pakmemi + messleng + 2 > pakmem.length) {
            pakmemi = 1;
        }
        Mmulti.opak[other][Mmulti.ocnt1[other] & 0x1FF] = pakmemi;
        LittleEndian.putShort(pakmem, pakmemi, (short)messleng);
        System.arraycopy(bufptr, 0, pakmem, pakmemi + 2, messleng);
        pakmemi += messleng + 2;
        int n = other;
        ocnt1[n] = ocnt1[n] + 1;
        Mmulti.dosendpackets(other);
    }

    public static int getpacket(byte[] bufptr) {
        int j;
        int messleng;
        int other;
        int i;
        if (numplayers < 2) {
            return 0;
        }
        if (Mmulti.inet.netready != 0) {
            i = connecthead;
            while (i >= 0) {
                if (i != myconnectindex) {
                    Mmulti.dosendpackets(i);
                }
                if (danetmode == 0 && myconnectindex != connecthead) break;
                i = connectpoint2[i];
            }
        }
        block1: while ((other = Mmulti.netread(pakbuf, pakbuf.length)) != -1) {
            int k = 0;
            int crc16ofs = LittleEndian.getUShort(pakbuf);
            k += 2;
            if (crc16ofs == 0) {
                return 0;
            }
            if (crc16ofs + 2 > pakbuf.length || Mmulti.getcrc16(pakbuf, crc16ofs) != LittleEndian.getUShort(pakbuf, crc16ofs)) continue;
            int ic0 = LittleEndian.getInt(pakbuf, k);
            k += 4;
            if (ic0 == -1) {
                if ((pakbuf[k] & 0xFF) == 170 && myconnectindex == connecthead) {
                    for (other = 1; other < numplayers; ++other) {
                        if (othersocket[other] != null && (!othersocket[other].equals(snatsocket) || ((InetSocketAddress)snatsocket).getPort() != ((InetSocketAddress)othersocket[other]).getPort())) continue;
                        if (othersocket[other] == null) {
                            ++Mmulti.inet.plready;
                        }
                        Mmulti.othersocket[other] = snatsocket;
                        k = 2;
                        LittleEndian.putInt(pakbuf, k, -1);
                        k += 4;
                        Mmulti.pakbuf[k++] = -85;
                        Mmulti.pakbuf[k++] = (byte)other;
                        Mmulti.pakbuf[k++] = (byte)numplayers;
                        LittleEndian.putUShort(pakbuf, 0, k);
                        LittleEndian.putUShort(pakbuf, k, Mmulti.getcrc16(pakbuf, k));
                        Mmulti.netsend(other, pakbuf, k += 2);
                        continue block1;
                    }
                    continue;
                }
                if ((pakbuf[k] & 0xFF) != 171 || myconnectindex == connecthead || (pakbuf[k + 1] & 0xFF) >= (pakbuf[k + 2] & 0xFF) || (pakbuf[k + 2] & 0xFF) >= 16) continue;
                myconnectindex = (short)(pakbuf[k + 1] & 0xFF);
                numplayers = (short)(pakbuf[k + 2] & 0xFF);
                connecthead = 0;
                for (i = 0; i < numplayers - 1; ++i) {
                    Mmulti.connectpoint2[i] = (short)(i + 1);
                }
                Mmulti.connectpoint2[Mmulti.numplayers - 1] = -1;
                Mmulti.othersocket[Mmulti.connecthead] = snatsocket;
                Mmulti.inet.netready = 1;
                continue;
            }
            if (ocnt0[other] < ic0) {
                Mmulti.ocnt0[other] = ic0;
            }
            for (i = ic0; i < Math.min(ic0 + 256, ocnt1[other]); ++i) {
                if ((pakbuf[(i - ic0 >> 3) + k] & 1 << (i - ic0 & 7)) == 0) continue;
                Mmulti.opak[other][i & 0x1FF] = 0;
            }
            messleng = LittleEndian.getUShort(pakbuf, k += 32);
            k += 2;
            while (messleng != 0) {
                j = LittleEndian.getInt(pakbuf, k);
                k += 4;
                if (j >= icnt0[other] && ipak[other][j & 0x1FF] == 0) {
                    if (pakmemi + messleng + 2 > pakmem.length) {
                        pakmemi = 1;
                    }
                    Mmulti.ipak[other][j & 0x1FF] = pakmemi;
                    LittleEndian.putShort(pakmem, pakmemi, (short)messleng);
                    System.arraycopy(pakbuf, k, pakmem, pakmemi + 2, messleng);
                    pakmemi += messleng + 2;
                }
                messleng = LittleEndian.getUShort(pakbuf, k += messleng);
                k += 2;
            }
        }
        if (bufptr == null) {
            return 0;
        }
        i = connecthead;
        while (i >= 0) {
            if (i != myconnectindex && (j = ipak[i][icnt0[i] & 0x1FF]) != 0) {
                messleng = LittleEndian.getShort(pakmem, j);
                System.arraycopy(pakmem, j + 2, bufptr, 0, messleng);
                otherpacket = i;
                Mmulti.ipak[i][Mmulti.icnt0[i] & 0x1FF] = 0;
                int n = i;
                icnt0[n] = icnt0[n] + 1;
                return messleng;
            }
            if (danetmode == 0 && myconnectindex != connecthead) break;
            i = connectpoint2[i];
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getExternalIp() {
        BufferedReader in = null;
        try {
            URL whatismyip = new URL("http://myip.dnsomatic.com");
            in = new BufferedReader(new InputStreamReader(whatismyip.openStream()));
            String string = in.readLine();
            return string;
        }
        catch (IOException iOException) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    static {
        connectpoint2 = new short[16];
        danetmode = 255;
        othersocket = new Object[16];
        ipak = new int[16][512];
        icnt0 = new int[16];
        opak = new int[16][512];
        ocnt0 = new int[16];
        ocnt1 = new int[16];
        pakmem = new byte[0x400000];
        pakmemi = 1;
        netping = 0L;
        lastsendtims = new long[16];
        inet = new NetInfo();
        crctab16 = new int[256];
    }
}

