/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.CommonMenus;

import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuKeyboardList;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Pattern.MenuItems.MenuText;
import ru.m210projects.Build.Pattern.MenuItems.MenuTitle;
import ru.m210projects.Build.Settings.BuildConfig;

public abstract class MenuKeyboard
extends BuildMenu {
    public MenuKeyboardList mList;
    public MenuText mText;
    public MenuText mText2;

    public abstract MenuTitle getTitle(BuildGame var1, String var2);

    public abstract String keyNames(int var1);

    public MenuKeyboard(final BuildGame app, int posx, int posy, int width, int list_len, BuildFont style) {
        this.addItem(this.getTitle(app, "Configure keys"), false);
        final BuildConfig cfg = app.pCfg;
        MenuProc callback = new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuKeyboardList item = (MenuKeyboardList)pItem;
                if (item.l_set == 0) {
                    item.l_pressedId = null;
                    item.l_set = 1;
                } else if (item.l_set == 1) {
                    int[] mousekeys = cfg.mousekeys;
                    switch (item.l_pressedId) {
                        case UP: {
                            cfg.setKey(item.l_nFocus, 19);
                            item.l_set = 0;
                            break;
                        }
                        case DW: {
                            cfg.setKey(item.l_nFocus, 20);
                            item.l_set = 0;
                            break;
                        }
                        case LEFT: {
                            cfg.setKey(item.l_nFocus, 21);
                            item.l_set = 0;
                            break;
                        }
                        case RIGHT: {
                            cfg.setKey(item.l_nFocus, 22);
                            item.l_set = 0;
                            break;
                        }
                        case ENTER: {
                            cfg.setKey(item.l_nFocus, 66);
                            item.l_set = 0;
                            break;
                        }
                        case ESC: {
                            if (item.l_nFocus == BuildConfig.GameKeys.Menu_Toggle.getNum()) {
                                cfg.setKey(item.l_nFocus, 131);
                            }
                            app.pInput.ctrlResetKeyStatus();
                            item.l_set = 0;
                            break;
                        }
                        case SPACE: {
                            cfg.setKey(item.l_nFocus, 62);
                            item.l_set = 0;
                            break;
                        }
                        case BSPACE: {
                            cfg.setKey(item.l_nFocus, 67);
                            item.l_set = 0;
                            break;
                        }
                        case DELETE: {
                            if (item.l_nFocus != BuildConfig.GameKeys.Show_Console.getNum() && item.l_nFocus != BuildConfig.GameKeys.Menu_Toggle.getNum()) {
                                cfg.setKey(item.l_nFocus, 112);
                            }
                            item.l_set = 0;
                            break;
                        }
                        case LMB: {
                            mousekeys[item.l_nFocus] = 226;
                            for (int i = 0; i < mousekeys.length; ++i) {
                                if (i == item.l_nFocus || 226 != mousekeys[i]) continue;
                                mousekeys[i] = 0;
                            }
                            item.l_set = 0;
                            break;
                        }
                        case PGUP: {
                            cfg.setKey(item.l_nFocus, 92);
                            item.l_set = 0;
                            break;
                        }
                        case PGDW: {
                            cfg.setKey(item.l_nFocus, 93);
                            item.l_set = 0;
                            break;
                        }
                        case HOME: {
                            cfg.setKey(item.l_nFocus, 3);
                            item.l_set = 0;
                            break;
                        }
                        case END: {
                            cfg.setKey(item.l_nFocus, 132);
                            item.l_set = 0;
                            break;
                        }
                        case MWUP: {
                            mousekeys[item.l_nFocus] = 224;
                            for (int i = 0; i < mousekeys.length; ++i) {
                                if (i == item.l_nFocus || 224 != mousekeys[i]) continue;
                                mousekeys[i] = 0;
                            }
                            item.l_set = 0;
                            break;
                        }
                        case MWDW: {
                            mousekeys[item.l_nFocus] = 225;
                            for (int i = 0; i < mousekeys.length; ++i) {
                                if (i == item.l_nFocus || 225 != mousekeys[i]) continue;
                                mousekeys[i] = 0;
                            }
                            item.l_set = 0;
                            break;
                        }
                        case RMB: {
                            mousekeys[item.l_nFocus] = 227;
                            for (int i = 0; i < mousekeys.length; ++i) {
                                if (i == item.l_nFocus || 227 != mousekeys[i]) continue;
                                mousekeys[i] = 0;
                            }
                            item.l_set = 0;
                            break;
                        }
                        default: {
                            for (int kb = 0; kb < 256; ++kb) {
                                if (kb >= 224 && kb <= 236) {
                                    if (!app.pInput.ctrlKeyStatus(kb)) continue;
                                    mousekeys[item.l_nFocus] = kb;
                                    for (int i = 0; i < mousekeys.length; ++i) {
                                        if (i == item.l_nFocus || kb != mousekeys[i]) continue;
                                        mousekeys[i] = 0;
                                    }
                                    item.l_set = 0;
                                    continue;
                                }
                                if (!app.pInput.ctrlKeyStatus(kb)) continue;
                                cfg.setKey(item.l_nFocus, kb);
                                item.l_set = 0;
                            }
                        }
                    }
                }
                if (item.l_nFocus == BuildConfig.GameKeys.Show_Console.getNum()) {
                    app.pInput.ctrlResetKeyStatus();
                    Console.setCaptureKey(cfg.primarykeys[item.l_nFocus], 0);
                    Console.setCaptureKey(cfg.secondkeys[item.l_nFocus], 1);
                    Console.setCaptureKey(cfg.mousekeys[item.l_nFocus], 2);
                }
            }
        };
        this.mList = new MenuKeyboardList(app.pSlider, app.pCfg, style, posx, posy, width, list_len, callback){

            @Override
            public String getKeyName(int keycode) {
                return MenuKeyboard.this.keyNames(keycode);
            }
        };
        posy += this.mList.mFontOffset() * list_len;
        this.mText = new MenuText("UP/DOWN = Select action", style, 160, posy += 2 * this.mList.mFontOffset(), 1);
        this.mText2 = new MenuText("Enter = modify  Delete = clear", style, 160, posy += this.mList.mFontOffset(), 1);
        this.addItem(this.mList, true);
        this.addItem(this.mText, false);
        this.addItem(this.mText2, false);
    }
}

