/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.CommonMenus;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenuList;
import ru.m210projects.Build.Pattern.MenuItems.DummyItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuButton;
import ru.m210projects.Build.Pattern.MenuItems.MenuConteiner;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Pattern.MenuItems.MenuSlider;
import ru.m210projects.Build.Pattern.MenuItems.MenuSwitch;
import ru.m210projects.Build.Pattern.MenuItems.MenuTitle;
import ru.m210projects.Build.Render.GLInfo;
import ru.m210projects.Build.Render.GLRenderer;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Render.TextureHandle.TileData;
import ru.m210projects.Build.Settings.BuildSettings;
import ru.m210projects.Build.Settings.GLSettings;
import ru.m210projects.Build.Types.BuildVariable;

public abstract class MenuRendererSettings
extends BuildMenuList {
    private final MenuItem title;
    private Renderer currentRenderer;
    private TileData.PixelFormat currentFormat;
    public BuildGame app;
    public BuildFont style;
    public int width;
    public boolean fontShadow = false;
    public boolean listShadow = false;
    protected BuildMenuList GLHiresMenu;
    protected boolean RenderParamBuilt = false;
    protected boolean GLRenderParamBuilt = false;
    protected MenuSlider palettedGamma;
    protected MenuSlider fovSlider;
    protected MenuSwitch vSync;
    protected MenuSwitch useVoxels;
    protected MenuConteiner fpsLimits;
    protected DummyItem separator;
    protected MenuSlider GLGamma;
    protected MenuConteiner GLTextureFilter;
    protected MenuConteiner GLTextureAnisotropy;
    protected MenuSwitch GLUseHighTile;
    protected MenuSwitch GLUseModels;
    protected MenuButton GLHires;
    protected MenuSwitch GLPalette;

    @Override
    public abstract MenuTitle getTitle(BuildGame var1, String var2);

    public MenuRendererSettings(BuildGame app, int x, int y, int width, int step, BuildFont style) {
        super(app, "Renderer settings", x, y, width, step, 15);
        this.app = app;
        this.style = style;
        this.width = width;
        this.title = this.m_pItems[0];
    }

    @Override
    public void mDraw(MenuHandler handler) {
        if (this.currentFormat != this.app.pEngine.getrender().getTexFormat()) {
            this.rebuild();
        }
        super.mDraw(handler);
    }

    @Override
    public boolean mLoadRes(MenuHandler handler, MenuHandler.MenuOpt opt) {
        if (opt == MenuHandler.MenuOpt.Open && (this.currentRenderer != this.app.pEngine.getrender() || this.currentFormat != this.app.pEngine.getrender().getTexFormat())) {
            this.rebuild();
        }
        return super.mLoadRes(handler, opt);
    }

    protected void rebuild() {
        this.clear();
        this.currentRenderer = this.app.pEngine.getrender();
        this.currentFormat = this.app.pEngine.getrender().getTexFormat();
        if (this.title != null) {
            this.title.text = (this.app.pEngine.getrender().getType().getName() + " settings").toCharArray();
        }
        this.BuildRenderParameters();
        if (this.currentRenderer instanceof GLRenderer) {
            this.BuildGLRenderParameters();
            this.addItem(this.GLGamma, true);
            this.addItem(this.separator, false);
            this.addItem(this.fovSlider, false);
            this.addItem(this.vSync, false);
            this.addItem(this.fpsLimits, false);
            this.addItem(this.useVoxels, false);
            this.addItem(this.separator, false);
            this.addItem(this.GLPalette, false);
            this.addItem(this.GLHires, false);
        } else {
            this.addItem(this.palettedGamma, true);
            this.addItem(this.separator, false);
            this.addItem(this.fovSlider, false);
            this.addItem(this.vSync, false);
            this.addItem(this.fpsLimits, false);
            this.addItem(this.useVoxels, false);
        }
    }

    protected MenuConteiner BuildConteiner(String text, final BuildVariable<?> var, String[] names, final Object[] values) {
        MenuConteiner conteiner = new MenuConteiner(text, this.style, 0, 0, this.width, names, 0, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuConteiner item = (MenuConteiner)pItem;
                var.set(values[item.num]);
            }
        }){

            @Override
            public void draw(MenuHandler handler) {
                this.num = -1;
                for (int i = 0; i < values.length; ++i) {
                    if (!var.get().equals(values[i])) continue;
                    this.num = i;
                }
                super.draw(handler);
            }
        };
        conteiner.fontShadow = this.fontShadow;
        conteiner.listShadow = this.listShadow;
        return conteiner;
    }

    protected MenuSlider BuildSlider(String text, final BuildVariable<Integer> var, int min, int max, int step, Integer digmax) {
        MenuSlider slider = new MenuSlider(this.app.pSlider, text, this.style, 0, 0, this.width, 0, min, max, step, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSlider slider = (MenuSlider)pItem;
                var.set(slider.value);
            }
        }, true){

            @Override
            public void draw(MenuHandler handler) {
                this.value = (Integer)var.get();
                super.draw(handler);
            }
        };
        slider.fontShadow = this.fontShadow;
        if (digmax != null) {
            slider.digitalMax = digmax.intValue();
        }
        return slider;
    }

    protected MenuSwitch BuildSwitch(String text, final BuildVariable<Boolean> var) {
        MenuSwitch sw = new MenuSwitch(text, this.style, 0, 0, this.width, false, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSwitch ss = (MenuSwitch)pItem;
                var.set(ss.value);
            }
        }, null, null){

            @Override
            public void draw(MenuHandler handler) {
                this.value = (Boolean)var.get();
                super.draw(handler);
            }
        };
        sw.fontShadow = this.fontShadow;
        return sw;
    }

    protected MenuButton BuildButton(String text, MenuProc callback) {
        MenuButton sw = new MenuButton(text, this.style, 0, 0, this.width, 0, 0, null, 0, callback, -1);
        sw.fontShadow = this.fontShadow;
        return sw;
    }

    protected void BuildGLRenderParameters() {
        if (this.GLRenderParamBuilt) {
            return;
        }
        this.GLGamma = this.BuildSlider("Gamma", GLSettings.gamma, 0, 4096, 64, 4096);
        int ogamma = GLSettings.gamma.get();
        if (GLSettings.gamma.set(64) == BuildVariable.RespondType.Fail) {
            this.GLGamma.mCheckEnableItem(false);
        } else {
            GLSettings.gamma.set(ogamma);
        }
        this.GLHires = this.BuildButton("Hires settings", new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                handler.mOpen(MenuRendererSettings.this.GLHiresMenu, -1);
            }
        });
        this.GLPalette = this.BuildSwitch("Palette emulation", GLSettings.usePaletteShader);
        this.GLHiresMenu = new BuildMenuList(this.app, "Hires settings", this.list.x, this.list.y, this.width, this.list.mFontOffset(), 10){

            @Override
            public MenuTitle getTitle(BuildGame app, String text) {
                return MenuRendererSettings.this.getTitle(app, text);
            }
        };
        String[] filters = new String[GLSettings.glfiltermodes.length];
        for (int i = 0; i < filters.length; ++i) {
            filters[i] = GLSettings.glfiltermodes[i].name;
        }
        this.GLTextureFilter = this.BuildConteiner("Texture filtering", GLSettings.textureFilter, filters, GLSettings.glfiltermodes);
        int anisotropysize = 0;
        for (int s = (int)GLInfo.maxanisotropy; s > 1; s >>= 1) {
            ++anisotropysize;
        }
        Object[] list = new Integer[anisotropysize + 1];
        String[] anisotropies = new String[anisotropysize + 1];
        for (int i = 0; i < list.length; ++i) {
            list[i] = Engine.pow2long[i];
            anisotropies[i] = i == 0 ? "None" : list[i] + "x";
        }
        this.GLTextureAnisotropy = this.BuildConteiner("Anisotropy", GLSettings.textureAnisotropy, anisotropies, list);
        this.GLUseHighTile = this.BuildSwitch("True color textures", GLSettings.useHighTile);
        this.GLUseModels = this.BuildSwitch("3d models", GLSettings.useModels);
        this.GLHiresMenu.addItem(this.GLTextureFilter, true);
        this.GLHiresMenu.addItem(this.GLTextureAnisotropy, false);
        this.GLHiresMenu.addItem(this.GLUseHighTile, false);
        this.GLHiresMenu.addItem(this.GLUseModels, false);
        this.GLRenderParamBuilt = true;
    }

    protected void BuildRenderParameters() {
        if (this.RenderParamBuilt) {
            return;
        }
        this.separator = new DummyItem();
        this.palettedGamma = this.BuildSlider("Gamma", BuildSettings.paletteGamma, 0, 15, 1, null);
        this.fovSlider = this.BuildSlider("Field of view", BuildSettings.fov, 60, 140, 5, null);
        this.vSync = this.BuildSwitch("Vsync", BuildSettings.vsync);
        String[] limits = new String[BuildSettings.fpslimits.length];
        for (int i = 0; i < limits.length; ++i) {
            limits[i] = i == 0 ? "None" : BuildSettings.fpslimits[i] + " fps";
        }
        this.fpsLimits = this.BuildConteiner("Framerate limit", BuildSettings.fpsLimit, limits, BuildSettings.fpslimits);
        this.useVoxels = this.BuildSwitch("Voxels", BuildSettings.useVoxels);
        this.RenderParamBuilt = true;
    }
}

