/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.MenuItems;

import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;

public class MenuConteiner
extends MenuItem {
    public int num;
    public MenuProc callback;
    public char[][] list;
    public BuildFont listFont;
    public boolean listShadow;

    public MenuConteiner(Object text, BuildFont font, int x, int y, int width, String[] list, int num, MenuProc callback) {
        super(text, font);
        this.listFont = font;
        this.flags = 7;
        if (list != null) {
            this.list = new char[list.length][];
            for (int i = 0; i < list.length; ++i) {
                this.list[i] = list[i].toCharArray();
            }
        }
        this.x = x;
        this.y = y;
        this.width = width;
        this.callback = callback;
        this.num = num;
        this.pal = 0;
    }

    public MenuConteiner(Object text, BuildFont font, BuildFont listFont, int x, int y, int width, String[] list, int num, MenuProc callback) {
        this(text, font, x, y, width, list, num, callback);
        this.listFont = listFont;
    }

    @Override
    public void draw(MenuHandler handler) {
        int px = this.x;
        int py = this.y;
        char[] key = null;
        if (this.list != null && this.num != -1 && this.num < this.list.length) {
            key = this.list[this.num];
        }
        int pal = handler.getPal(this.font, this);
        int shade = handler.getShade(this);
        this.font.drawText(px, py, this.text, shade, pal, BuildFont.TextAlign.Left, 2, this.fontShadow);
        if (key != null) {
            int bound = 10;
            int w1 = this.font.getWidth(this.text);
            int w2 = this.listFont.getWidth(key);
            if (w2 + bound >= this.width - w1) {
                int tx = px + w1 + bound;
                int ty = py + (this.font.getHeight() - this.listFont.getHeight()) / 2;
                this.brDrawText(this.listFont, key, tx + bound, ty, shade, handler.getPal(this.listFont, this), 0, px + this.width - 1);
            } else {
                this.listFont.drawText(this.x + this.width - 1 - this.listFont.getWidth(key), py + (this.font.getHeight() - this.listFont.getHeight()) / 2, key, shade, handler.getPal(this.listFont, this), BuildFont.TextAlign.Left, 2, this.listShadow);
            }
        }
        handler.mPostDraw(this);
    }

    protected void brDrawText(BuildFont font, char[] text, int x, int y, int shade, int pal, int x1, int x2) {
        for (int tptr = 0; tptr < text.length && text[tptr] != '\u0000'; ++tptr) {
            if (x > x1 && x <= x2) {
                x += font.drawChar(x, y, text[tptr], shade, pal, 2, this.listShadow);
                continue;
            }
            x += font.getWidth(text[tptr]);
        }
    }

    @Override
    public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
        switch (opt) {
            case LEFT: 
            case MWDW: {
                if ((this.flags & 4) == 0) {
                    return false;
                }
                this.num = this.num > 0 ? --this.num : 0;
                if (this.callback != null) {
                    this.callback.run(handler, this);
                }
                return false;
            }
            case RIGHT: 
            case MWUP: {
                if ((this.flags & 4) == 0) {
                    return false;
                }
                this.num = this.num < this.list.length - 1 ? ++this.num : this.list.length - 1;
                if (this.callback != null) {
                    this.callback.run(handler, this);
                }
                return false;
            }
            case ENTER: 
            case LMB: {
                if ((this.flags & 4) == 0) {
                    return false;
                }
                this.num = this.num < this.list.length - 1 ? ++this.num : 0;
                if (this.callback != null) {
                    this.callback.run(handler, this);
                }
                return false;
            }
        }
        return this.m_pMenu.mNavigation(opt);
    }

    @Override
    public boolean mouseAction(int mx, int my) {
        char[] key;
        int fontx;
        int px;
        if (this.text != null && mx > this.x && mx < this.x + this.font.getWidth(this.text) && my > this.y && my < this.y + this.font.getHeight()) {
            return true;
        }
        if (this.list == null) {
            return false;
        }
        if (this.num != -1 && this.num < this.list.length && mx > (px = this.x + this.width - 1 - (fontx = this.listFont.getWidth(key = this.list[this.num]))) && mx < px + fontx) {
            return my > this.y && my < this.y + this.font.getHeight();
        }
        return false;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }
}

