/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.MenuItems;

import java.util.List;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuList;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Render.VideoMode;

public class MenuResolutionList
extends MenuList {
    private final int nBackground;
    protected Engine draw;
    public int transparent = 1;
    public int backgroundPal;

    public MenuResolutionList(Engine draw, List<char[]> text, BuildFont font, int x, int y, int width, int align, BuildMenu nextMenu, MenuProc specialCall, int nListItems, int nBackground) {
        super(text, font, x, y, width, align, nextMenu, specialCall, nListItems);
        this.nBackground = nBackground;
        this.draw = draw;
    }

    @Override
    public void open() {
        this.l_nFocus = -1;
        this.l_nMin = 0;
        for (int m = 0; m < VideoMode.validmodes.size(); ++m) {
            if (VideoMode.validmodes.get((int)m).xdim != Engine.xdim || VideoMode.validmodes.get((int)m).ydim != Engine.ydim) continue;
            this.l_nFocus = m;
            break;
        }
        if (this.l_nFocus != -1 && this.l_nFocus >= this.l_nMin + this.nListItems) {
            this.l_nMin = this.l_nFocus - this.nListItems + 1;
        }
    }

    @Override
    public void draw(MenuHandler handler) {
        this.draw.rotatesprite(this.x - 10 << 16, this.y - 8 << 16, 65536, 0, this.nBackground, 128, this.backgroundPal, 0x1A | this.transparent, 0, 0, Gameutils.coordsConvertXScaled(this.x + this.width, Gameutils.ConvertType.Normal), Gameutils.coordsConvertYScaled(this.y + this.nListItems * this.mFontOffset() + 3));
        if (this.text.size() > 0) {
            int px = this.x;
            int py = this.y;
            for (int i = this.l_nMin; i >= 0 && i < this.l_nMin + this.nListItems && i < this.text.size(); ++i) {
                int pal = handler.getPal(this.font, null);
                int shade = handler.getShade(null);
                if (i == this.l_nFocus) {
                    shade = handler.getShade(this);
                    pal = handler.getPal(this.font, this);
                }
                if (this.align == 1) {
                    px = this.width / 2 + this.x - this.font.getWidth((char[])this.text.get(i)) / 2;
                }
                if (this.align == 2) {
                    px = this.x + this.width - 1 - this.font.getWidth((char[])this.text.get(i));
                }
                this.font.drawText(px, py, (char[])this.text.get(i), shade, pal, BuildFont.TextAlign.Left, 2, this.fontShadow);
                py += this.mFontOffset();
            }
        } else {
            int pal = handler.getPal(this.font, this);
            String text = "List is empty";
            int px = this.x;
            int py = this.y;
            if (this.align == 1) {
                px = this.width / 2 + this.x - this.font.getWidth(text.toCharArray()) / 2;
            }
            if (this.align == 2) {
                px = this.x + this.width - 1 - this.font.getWidth(text.toCharArray());
            }
            int shade = handler.getShade(this);
            this.font.drawText(px, py, text.toCharArray(), shade, pal, BuildFont.TextAlign.Left, 2, this.fontShadow);
        }
        handler.mPostDraw(this);
    }

    @Override
    public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
        switch (opt) {
            case MWUP: {
                this.ListMouseWheelUp(handler);
                return false;
            }
            case MWDW: {
                if (this.text != null) {
                    this.ListMouseWheelDown(handler, this.text.size());
                }
                return false;
            }
            case UP: {
                this.ListUp(handler, this.text.size());
                return false;
            }
            case DW: {
                this.ListDown(handler, this.text.size());
                return false;
            }
            case LEFT: {
                this.ListLeft(handler);
                return false;
            }
            case RIGHT: {
                this.ListRight(handler);
                return false;
            }
            case ENTER: 
            case LMB: {
                if ((this.flags & 4) == 0) {
                    return false;
                }
                if (this.l_nFocus != -1 && this.text.size() > 0 && this.callback != null) {
                    this.callback.run(handler, this);
                    if (this.nextMenu != null) {
                        handler.mOpen(this.nextMenu, -1);
                    }
                }
                Engine.getInput().resetKeyStatus();
                return false;
            }
            case ESC: 
            case RMB: {
                this.ListEscape(handler, opt);
                return true;
            }
            case PGUP: {
                this.ListPGUp(handler);
                return false;
            }
            case PGDW: {
                this.ListPGDown(handler, this.text.size());
                return false;
            }
            case HOME: {
                this.ListHome(handler);
                return false;
            }
            case END: {
                this.ListEnd(handler, this.text.size());
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean mouseAction(int mx, int my) {
        if (this.text.size() > 0) {
            int px = this.x;
            int py = this.y;
            for (int i = this.l_nMin; i >= 0 && i < this.l_nMin + this.nListItems && i < this.text.size(); ++i) {
                int fontx = this.font.getWidth((char[])this.text.get(i));
                if (this.align == 1) {
                    px = this.width / 2 + this.x - fontx / 2;
                }
                if (this.align == 2) {
                    px = this.x + this.width - 1 - fontx;
                }
                if (mx > px && mx < px + fontx && my > py && my < py + this.font.getHeight()) {
                    this.l_nFocus = i;
                    return true;
                }
                py += this.mFontOffset();
            }
        }
        return false;
    }
}

